/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware.bus.registers;

import bk2010.hardware.bus.QBusError;
import bk2010.hardware.bus.QBusSlave;

public final class FocalIRPS
implements QBusSlave {
    private static final short IRPSBase = -144;
    private static final short IRPSRxStatus = -144;
    private static final short IRPSRxData = -142;
    private static final short IRPSTxStatus = -140;
    private static final short IRPSTxData = -138;
    private static final short IRPSvector = 48;
    protected short txStatus = (short)128;
    protected short txData = 0;
    protected short rxStatus = 0;
    protected short rxData = 0;

    @Override
    public short getBaseAddress() {
        return -144;
    }

    @Override
    public int getNumWords() {
        return 4;
    }

    @Override
    public boolean gotInterrupt() {
        return (this.txStatus & 0xC0) == 192 || (this.rxStatus & 0xC0) == 192;
    }

    @Override
    public byte interruptVector() {
        return (byte)((this.rxStatus & 0x80) != 0 ? 48 : 52);
    }

    @Override
    public short readWord(short addr) throws QBusError {
        switch (addr & 0xFFFFFFFE) {
            case -138: {
                return 48;
            }
            case -140: {
                return this.txStatus;
            }
            case -142: {
                this.rxStatus = (short)(this.rxStatus & 0xFFFFFF37);
                return this.rxData;
            }
            case -144: {
                return this.rxStatus;
            }
        }
        throw new IllegalArgumentException("Impossible IRPS address");
    }

    @Override
    public void writeByteAsWord(short addr, short data) throws QBusError {
        if ((addr & 1) != 0) {
            return;
        }
        switch (addr & 0xFFFFFFFE) {
            case -138: {
                this.txData = (short)(data & 0xFF);
                this.txStatus = (short)(this.txStatus & 0xFFFFFF37);
                return;
            }
            case -140: {
                this.txStatus = (short)(this.txStatus & 0xFFFFFFBF | data & 0x40);
                return;
            }
            case -142: {
                return;
            }
            case -144: {
                this.rxStatus = (short)(this.rxStatus & 0xFFFFFFBF | data & 0x40);
                return;
            }
        }
        throw new IllegalArgumentException("Impossible IRPS address");
    }

    @Override
    public void writeWord(short addr, short data) throws QBusError {
        this.writeByteAsWord(addr, data);
    }

    @Override
    public void reset() {
        this.txStatus = (short)128;
        this.txData = 0;
        this.rxStatus = 0;
        this.rxData = 0;
    }

    public int pollTx() {
        if ((this.txStatus & 0x80) != 0) {
            return -1;
        }
        this.txStatus = (short)(this.txStatus | 0x80);
        return this.txData & 0xFF;
    }
}

