/*
 * Decompiled with CFR 0.152.
 */
package bk2010;

import bk2010.gui.LauncherHWConfigurationDialog;
import bk2010.gui.bk0010DisplayPanel;
import bk2010.hardware.BaseBK0010;
import bk2010.hardware.bus.QBusError;
import bk2010.hardware.bus.registers.FDDController;
import bk2010.hardware.cpu.K1801VM1;
import bk2010.io.FloppyDisk;
import bk2010.io.JoystickMapper;
import bk2010.io.KeyMapper;
import bk2010.sound.NoSoundException;
import bk2010.sound.SoundRenderer;
import bk2010.sound.StreamOutput;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Emulator {
    static final long cyclesPerFrame = 60000L;
    static final int maxSkippedFrames = 4;
    static boolean isSilent = true;
    static int screenshots = 0;

    public static void main(String[] args) throws IOException, QBusError {
        LauncherHWConfigurationDialog.State hwConf = LauncherHWConfigurationDialog.doIt();
        boolean cfgDisk = hwConf.machine.indexOf("DISK") >= 0;
        boolean cfgDiskBasic = cfgDisk && hwConf.machine.indexOf("BASIC") >= 0;
        JoystickMapper joyMapper = new JoystickMapper();
        KeyMapper keyMapper = new KeyMapper(joyMapper);
        bk0010DisplayPanel panel = new bk0010DisplayPanel(keyMapper);
        bk0010DisplayPanel.TestFrame jframe = new bk0010DisplayPanel.TestFrame(panel);
        jframe.setDefaultCloseOperation(3);
        Dimension winsize = jframe.getSize();
        Dimension scrsize = jframe.getToolkit().getScreenSize();
        jframe.setLocation((scrsize.width - winsize.width) / 2, (scrsize.height - winsize.height) / 2);
        jframe.setTitle(hwConf.machine);
        jframe.setIconImage(ImageIO.read(Emulator.class.getResource("/resources/icon_filled.bmp")));
        jframe.setVisible(true);
        BaseBK0010 machine = new BaseBK0010();
        K1801VM1 cpu = new K1801VM1(machine);
        machine.timer.setTimeSource(cpu);
        if (cfgDisk) {
            FloppyDisk driveA = new FloppyDisk(3000000L);
            FloppyDisk driveB = new FloppyDisk(3000000L);
            FDDController fdc = new FDDController(driveA, driveB, cpu);
            machine.attach(fdc);
            driveA.mountImage(new File("disks/a.img"));
            driveB.mountImage(new File("disks/b.img"));
            machine.setFDD10Model();
            if (cfgDiskBasic) {
                fdc.setMemorySelector(machine);
            }
            machine.writeWord((short)-24576, (short)95);
            machine.writeWord((short)-24574, (short)-8192);
        }
        SoundRenderer sr = null;
        StreamOutput so = null;
        try {
            so = new StreamOutput();
            sr = new SoundRenderer(so, cpu, 62.5f);
            machine.setSoundRenderer(sr);
            isSilent = false;
        }
        catch (NoSoundException e1) {
            System.out.println("Cannot initialize audio");
        }
        BufferedImage display = new BufferedImage(512, 256, 13, bk0010DisplayPanel.getRGB332Model());
        panel.setDisplay(display);
        byte[] frameBuffer = new byte[131072];
        cpu.reset();
        long cycles = 0L;
        int skippedFrames = 0;
        long expectedTime = isSilent ? System.currentTimeMillis() : so.timeMillis() - 100L;
        int frame = 0;
        while (!Thread.interrupted()) {
            long slack = expectedTime - (isSilent ? System.currentTimeMillis() : so.timeMillis());
            if (slack < -30L && skippedFrames <= 4) {
                ++skippedFrames;
                System.out.append('.');
            } else {
                skippedFrames = 0;
                machine.copyFramebuffer(frameBuffer);
                display.getRaster().setDataElements(0, 0, 512, 256, frameBuffer);
                slack = expectedTime - (isSilent ? System.currentTimeMillis() : so.timeMillis());
            }
            if (slack < -100L) {
                expectedTime -= slack;
                System.out.printf("\nStalled for %d us", (int)(-slack));
            } else if (slack > 20L) {
                try {
                    Thread.sleep(slack);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            if (skippedFrames == 0) {
                panel.paintImmediately(0, 0, 1024, 768);
            }
            while (cpu.getCycles() - cycles <= 60000L) {
                cpu.exec_insn();
            }
            sr.push();
            cycles += 60000L;
            expectedTime += 20L;
            int key = keyMapper.pollKey();
            if (key > -1) {
                machine.keyboard.punch((byte)key);
            } else {
                machine.keyboard.setKeyDown(keyMapper.pollKeyHold());
            }
            key = keyMapper.pollEvents();
            if ((key & 1) != 0) {
                cpu.nmi();
            }
            if ((key & 2) != 0) {
                machine.cycleVideomodes();
            }
            if ((key & 4) != 0) {
                cpu.reset();
            }
            if ((key & 8) != 0) {
                cpu.trace ^= true;
            }
            if ((key & 0x10) != 0) {
                System.out.println("\nSaving screenshot");
                File shotdir = new File("shots/");
                if (shotdir.exists() && shotdir.isDirectory() || shotdir.mkdir()) {
                    File shot;
                    do {
                        if (screenshots <= 9999) continue;
                        System.out.println("Maximum screenshot count (10000) exceeded");
                        shot = new File("shots/shot.png");
                        break;
                    } while ((shot = new File(String.format("shots/shot%04d.png", screenshots++))).exists());
                    ImageIO.write((RenderedImage)display, "png", shot);
                }
            }
            if ((key & 0x10000) != 0) {
                System.out.printf("\nRendered %d frames\n", frame);
                System.exit(0);
            }
            machine.joystick.setState(joyMapper.getJoystickState());
            ++frame;
        }
    }
}

