/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware.bus;

import bk2010.hardware.bus.QBusError;
import bk2010.hardware.bus.QBusSlave;

public abstract class QBusProxy
implements QBusSlave {
    @Override
    public short readWord(short addr) throws QBusError {
        throw new QBusError(addr, 1, "Attempted to read an unoccupied memory location");
    }

    @Override
    public void writeWord(short addr, short data) throws QBusError {
        throw new QBusError(addr, 10, "Attempted to write an unoccupied memory location");
    }

    @Override
    public void writeByteAsWord(short addr, short data) throws QBusError {
        throw new QBusError(addr, 6, "Attempted to write an unoccupied memory location");
    }

    public final byte readByte(short addr) throws QBusError {
        return (byte)((addr & 1) == 0 ? this.readWord(addr) : this.readWord(addr) >> 8);
    }

    public final short readByteAsWord(short addr) throws QBusError {
        return this.readWord(addr);
    }

    public final void writeByte(short addr, byte data) throws QBusError {
        this.writeByteAsWord(addr, (short)((addr & 1) == 0 ? data | 0xFF00 : data << 8 | 0xFF));
    }
}

