/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware.bus;

public class QBusError
extends Throwable {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int BYTE = 4;
    public static final int WORD = 8;
    public final short address;
    public final int operation;

    public QBusError(short addr, int op, String message) {
        super(message);
        this.address = addr;
        this.operation = op;
    }

    public QBusError(short addr, int op) {
        this.address = addr;
        this.operation = op;
    }

    @Override
    public String toString() {
        return "QBusError at emulated address " + Integer.toOctalString(this.address & 0x177777);
    }

    private QBusError() throws Exception {
        throw new IllegalArgumentException("QBusError was created without information on offending memory access");
    }

    private QBusError(String arg0) throws Exception {
        throw new IllegalArgumentException("QBusError was created without information on offending memory access, but with the message:" + arg0);
    }

    private QBusError(Throwable arg0) throws Exception {
        throw new IllegalArgumentException("QBusError was created without information on offending memory access", arg0);
    }

    private QBusError(String arg0, Throwable arg1) throws Exception {
        throw new IllegalArgumentException("QBusError was created without information on offending memory access, but with the message:" + arg0, arg1);
    }
}

