/*
 * Decompiled with CFR 0.152.
 */
package bk2010;

import bk2010.gui.BK2010DisplayPanel;
import bk2010.gui.LauncherHWConfigurationDialog;
import bk2010.hardware.BaseBK001x;
import bk2010.hardware.bus.QBusError;
import bk2010.hardware.bus.registers.FDDController;
import bk2010.hardware.cpu.K1801VM1;
import bk2010.io.FakeTape;
import bk2010.io.FloppyDisk;
import bk2010.io.JoystickMapper;
import bk2010.io.KeyMapper;
import bk2010.preferences.MachineConfiguration;
import bk2010.sound.NoSoundException;
import bk2010.sound.SoundRenderer;
import bk2010.sound.StreamOutput;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public final class Emulator {
    static final int maxSkippedFrames = 4;
    long cyclesPerFrame;
    static boolean isSilent = true;
    static int screenshots = 0;
    protected MachineConfiguration hwConf;
    protected BK2010DisplayPanel panel;
    protected BaseBK001x machine;
    protected K1801VM1 cpu;
    protected byte[] frameBuffer;
    protected boolean cfg11M;
    BufferedImage display;
    SoundRenderer sr;
    StreamOutput so;

    public Emulator(long CPUfreq, MachineConfiguration hwc, BK2010DisplayPanel bdp) throws IOException {
        boolean cfgDiskBasic;
        this.hwConf = hwc;
        this.panel = bdp;
        boolean cfgDisk = this.hwConf.machine.indexOf("DISK") >= 0;
        boolean bl = cfgDiskBasic = cfgDisk && this.hwConf.machine.indexOf("BASIC") >= 0;
        if (this.hwConf.machine.indexOf("11M") >= 0) {
            cfgDisk = true;
            cfgDiskBasic = false;
            this.cfg11M = true;
        } else {
            this.cfg11M = false;
        }
        if (this.cfg11M) {
            CPUfreq = 4000000L;
        }
        this.cyclesPerFrame = CPUfreq / 50L;
        this.machine = new BaseBK001x();
        this.cpu = new K1801VM1(this.machine);
        this.machine.timer.setTimeSource(this.cpu);
        if (cfgDisk) {
            FloppyDisk driveA = new FloppyDisk(CPUfreq);
            FloppyDisk driveB = new FloppyDisk(CPUfreq);
            FDDController fdc = new FDDController(driveA, driveB, this.cpu);
            this.machine.attach(fdc);
            if (this.hwConf.diskA.doMount) {
                driveA.mountImage(this.hwConf.diskA.imageFile, this.hwConf.diskA.readOnly);
            }
            if (this.hwConf.diskB.doMount) {
                driveB.mountImage(this.hwConf.diskB.imageFile, this.hwConf.diskB.readOnly);
            }
            this.machine.setFDD10Model();
            if (cfgDiskBasic) {
                fdc.setMemorySelector(this.machine);
            }
            if (this.cfg11M) {
                this.machine.setFDD11MModel();
            } else {
                try {
                    this.machine.writeWord((short)-24576, (short)95);
                    this.machine.writeWord((short)-24574, (short)-8192);
                }
                catch (QBusError e) {
                    System.out.println("Internal error - no RAM in BK+DISK mode ...");
                }
            }
        }
        try {
            this.so = new StreamOutput();
            this.sr = new SoundRenderer(this.so, this.cpu, (float)((double)CPUfreq / 48000.0));
            this.machine.setSoundRenderer(this.sr);
            isSilent = false;
        }
        catch (NoSoundException e1) {
            System.out.println("Cannot initialize audio");
        }
        this.display = new BufferedImage(512, 256, 13, BK2010DisplayPanel.getBGR233Model());
        this.panel.setDisplay(this.display);
        this.frameBuffer = new byte[131072];
        this.cpu.reset();
    }

    /*
     * Unable to fully structure code
     */
    public void runEmulator() {
        cycles = 0L;
        skippedFrames = 0;
        expectedTime = Emulator.isSilent != false ? System.currentTimeMillis() : this.so.timeMillis() - 100L;
        frame = 0;
        while (!Thread.interrupted()) {
            block22: {
                slack = expectedTime - (Emulator.isSilent != false ? System.currentTimeMillis() : this.so.timeMillis());
                if (slack < -30L && skippedFrames <= 4) {
                    ++skippedFrames;
                    System.out.append('.');
                } else {
                    skippedFrames = 0;
                    this.machine.copyFramebufferFast(this.frameBuffer);
                    this.display.getRaster().setDataElements(0, 0, 512, 256, this.frameBuffer);
                    slack = expectedTime - (Emulator.isSilent != false ? System.currentTimeMillis() : this.so.timeMillis());
                }
                if (slack < -100L) {
                    expectedTime -= slack;
                    System.out.printf("\nStalled for %d us", new Object[]{(int)(-slack)});
                } else if (slack > 20L) {
                    try {
                        Thread.sleep(slack);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                if (skippedFrames == 0) {
                    this.panel.paintImmediately(0, 0, 1024, 768);
                }
                if (!this.cfg11M) ** GOTO lbl41
                while (this.cpu.getCycles() - cycles <= this.cyclesPerFrame) {
                    this.cpu.exec_insn();
                }
                break block22;
lbl-1000:
                // 1 sources

                {
                    this.cpu.exec_insn();
                    if ((this.cpu.regs[7] & 65535) != 39998) continue;
                    try {
                        FakeTape.fakeTape(this.machine, this.cpu.regs);
                        continue;
                    }
                    catch (QBusError e) {
                        this.cpu.trap(4);
                    }
lbl41:
                    // 4 sources

                    ** while (this.cpu.getCycles() - cycles <= this.cyclesPerFrame)
                }
            }
            if (this.cfg11M && this.machine.timerEnabled()) {
                this.cpu.irq();
            }
            this.sr.push();
            cycles += this.cyclesPerFrame;
            expectedTime += 20L;
            keyMapper = this.panel.getKeyMapper();
            key = keyMapper.pollKey();
            if (key > -1) {
                this.machine.keyboard.punch((byte)key);
            } else {
                this.machine.keyboard.setKeyDown(keyMapper.pollKeyHold());
            }
            key = keyMapper.pollEvents();
            if ((key & 1) != 0) {
                this.cpu.nmi();
            }
            if ((key & 2) != 0) {
                this.machine.cycleVideomodes();
            }
            if ((key & 4) != 0) {
                this.cpu.reset();
            }
            if ((key & 8) != 0) {
                this.cpu.trace ^= true;
            }
            if ((key & 16) != 0) {
                this.takeScreenShot();
            }
            if ((key & 65536) != 0) {
                System.out.printf("\nRendered %d frames\n", new Object[]{frame});
                break;
            }
            this.machine.joystick.setState(keyMapper.getJoystickState());
            ++frame;
        }
    }

    void takeScreenShot() {
        System.out.println("\nSaving screenshot");
        File shotdir = new File("shots/");
        if (shotdir.exists() && shotdir.isDirectory() || shotdir.mkdir()) {
            File shot;
            do {
                if (screenshots <= 9999) continue;
                System.out.println("Maximum screenshot count (10000) exceeded");
                shot = new File("shots/shot.png");
                break;
            } while ((shot = new File(String.format("shots/shot%04d.png", screenshots++))).exists());
            try {
                ImageIO.write((RenderedImage)this.display, "png", shot);
            }
            catch (IOException e) {
                System.out.println("Error saving screenshot");
            }
        }
    }

    public static void main(String[] args) throws IOException, QBusError {
        MachineConfiguration hwConf = LauncherHWConfigurationDialog.doIt();
        if (!hwConf.doLaunch) {
            System.exit(0);
        }
        JoystickMapper joyMapper = new JoystickMapper();
        KeyMapper keyMapper = new KeyMapper(joyMapper);
        BK2010DisplayPanel panel = new BK2010DisplayPanel(keyMapper);
        BK2010DisplayPanel.SimpleFrame jframe = new BK2010DisplayPanel.SimpleFrame(panel);
        jframe.setDefaultCloseOperation(3);
        Dimension winsize = jframe.getSize();
        Dimension scrsize = jframe.getToolkit().getScreenSize();
        jframe.setLocation((scrsize.width - winsize.width) / 2, (scrsize.height - winsize.height) / 2);
        jframe.setTitle(hwConf.machine);
        jframe.setIconImage(ImageIO.read(Emulator.class.getResource("/resources/icon_filled.bmp")));
        jframe.setVisible(true);
        Emulator emu = new Emulator(3000000L, hwConf, panel);
        emu.runEmulator();
        System.exit(0);
    }
}

