/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui;

import bk2010.gui.DiskImageFileFilter;
import bk2010.gui.SlickTextField;
import bk2010.preferences.MachineConfiguration;
import bk2010.preferences.PathStrings;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class DiskMountPanel
extends JPanel {
    MachineConfiguration.Disk diskSettings;
    JCheckBox jcbMount;
    JCheckBox jcbReadOnly;
    SlickTextField jtfFileName;
    JFileChooser fileChooser;

    private void showSelectImageDialog() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(PathStrings.diskImagesPath);
            this.fileChooser.setAcceptAllFileFilterUsed(false);
            this.fileChooser.setFileFilter(new DiskImageFileFilter(new File(PathStrings.diskImagesPath)));
        }
        if (this.diskSettings.imageFile != null) {
            this.fileChooser.setSelectedFile(this.diskSettings.imageFile);
        }
        if (this.fileChooser.showOpenDialog(this) == 0) {
            this.diskSettings.imageFile = this.fileChooser.getSelectedFile();
            this.jcbMount.setSelected(true);
            this.diskSettings.doMount = true;
        }
        if (this.diskSettings.imageFile != null) {
            this.jtfFileName.setText(this.diskSettings.imageFile.getPath());
        }
    }

    public DiskMountPanel(String title, MachineConfiguration.Disk theDiskSettings) {
        this.diskSettings = theDiskSettings;
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title));
        this.setLayout(new BoxLayout(this, 1));
        Box box = Box.createHorizontalBox();
        this.jcbMount = new JCheckBox("Mount", theDiskSettings.doMount);
        this.jcbMount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiskMountPanel.this.diskSettings.doMount = DiskMountPanel.this.jcbMount.isSelected();
            }
        });
        box.add(this.jcbMount);
        this.jcbReadOnly = new JCheckBox("Read only", theDiskSettings.readOnly);
        this.jcbReadOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiskMountPanel.this.diskSettings.readOnly = DiskMountPanel.this.jcbReadOnly.isSelected();
            }
        });
        box.add(this.jcbReadOnly);
        box.add(Box.createHorizontalGlue());
        this.add(box);
        box = Box.createHorizontalBox();
        this.jtfFileName = new SlickTextField(theDiskSettings.imageFile == null ? "" : theDiskSettings.imageFile.getAbsolutePath(), PathStrings.diskImagesPath.length() + 32);
        this.jtfFileName.setEditable(false);
        box.add(this.jtfFileName);
        box.add(Box.createRigidArea(new Dimension(10, 1)));
        JButton jbBrowse = new JButton("Browse");
        jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiskMountPanel.this.showSelectImageDialog();
            }
        });
        box.add(jbBrowse);
        this.add(box);
    }
}

