/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui;

import bk2010.gui.helpers.DiskImageFileFilter;
import bk2010.gui.helpers.OnOffBox;
import bk2010.gui.helpers.SlickTextField;
import bk2010.preferences.MachineConfiguration;
import bk2010.preferences.PathStrings;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class DiskMountPanel
extends JPanel {
    MachineConfiguration.Disk diskSettings;
    OnOffBox cbMount;
    OnOffBox cbReadOnly;
    SlickTextField jtfFileName;
    JFileChooser fileChooser;

    private void showSelectImageDialog() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(PathStrings.diskImagesPath);
            this.fileChooser.setAcceptAllFileFilterUsed(false);
            this.fileChooser.setFileFilter(new DiskImageFileFilter(new File(PathStrings.diskImagesPath)));
        }
        if (this.diskSettings.imageFile != null) {
            this.fileChooser.setSelectedFile(this.diskSettings.imageFile);
        }
        if (this.fileChooser.showOpenDialog(this) == 0) {
            this.diskSettings.imageFile = this.fileChooser.getSelectedFile();
            this.cbMount.setSelected(true);
        }
        if (this.diskSettings.imageFile != null) {
            this.jtfFileName.setText(this.diskSettings.imageFile.getPath());
        }
    }

    public DiskMountPanel(String title, MachineConfiguration.Disk theDiskSettings) {
        this.diskSettings = theDiskSettings;
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title));
        this.setLayout(new BoxLayout(this, 1));
        Box box = Box.createHorizontalBox();
        this.cbMount = new OnOffBox(this.diskSettings.doMount);
        box.add(this.cbMount);
        this.cbReadOnly = new OnOffBox(this.diskSettings.readOnly);
        box.add(this.cbReadOnly);
        box.add(Box.createHorizontalGlue());
        this.add(box);
        box = Box.createHorizontalBox();
        this.jtfFileName = new SlickTextField(theDiskSettings.imageFile == null ? "" : theDiskSettings.imageFile.getAbsolutePath(), PathStrings.diskImagesPath.length() + 32);
        this.jtfFileName.setEditable(false);
        box.add(this.jtfFileName);
        box.add(Box.createRigidArea(new Dimension(10, 1)));
        JButton jbBrowse = new JButton("Browse");
        jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiskMountPanel.this.showSelectImageDialog();
            }
        });
        box.add(jbBrowse);
        this.add(box);
    }
}

