/*
 * Decompiled with CFR 0.152.
 */
package bk2010.sound;

import bk2010.sound.SoundProvider;
import java.util.Arrays;

public final class AY8910
implements SoundProvider {
    private double cps;
    private double recCps;
    private int cycles = 0;
    private int keep = 0;
    private int[] ayRegs = new int[16];
    private int selectedReg = -1;
    private static final int[] vol;
    private int[] tones = new int[3];
    private int[] toneCntrs = new int[3];
    private int[] toneToggles = new int[3];
    private int envelopePeriod;
    private int envelopeCntr;
    private int envelope;
    private int negEnvelope;
    private boolean sustain;
    private int noiseSR = 65535;
    private int noisePeriod;
    private int noiseCntr;
    private int mix;
    protected static final int REG_A_FINE = 0;
    protected static final int REG_A_COARSE = 1;
    protected static final int REG_B_FINE = 2;
    protected static final int REG_B_COARSE = 3;
    protected static final int REG_C_FINE = 4;
    protected static final int REG_C_COARSE = 5;
    protected static final int REG_NOISE = 6;
    protected static final int REG_MIXER = 7;
    protected static final int REG_AMP_A = 8;
    protected static final int REG_AMP_B = 9;
    protected static final int REG_AMP_C = 10;
    protected static final int REG_ENV_FINE = 11;
    protected static final int REG_ENV_COARSE = 12;
    protected static final int REG_ENV_SHAPE = 13;
    protected static final int ENV_HOLD = 1;
    protected static final int ENV_ALTERNATE = 2;
    protected static final int ENV_ATTACK = 4;
    protected static final int ENV_CONTINUE = 8;

    static {
        int[] nArray = new int[16];
        nArray[1] = 836;
        nArray[2] = 1212;
        nArray[3] = 1773;
        nArray[4] = 2619;
        nArray[5] = 3875;
        nArray[6] = 5397;
        nArray[7] = 8823;
        nArray[8] = 10392;
        nArray[9] = 16706;
        nArray[10] = 23339;
        nArray[11] = 29292;
        nArray[12] = 36969;
        nArray[13] = 46421;
        nArray[14] = 55195;
        nArray[15] = 65535;
        vol = nArray;
    }

    public AY8910(float cyclesPerSample) {
        this.cps = Math.round(cyclesPerSample);
        this.recCps = 1.0 / this.cps;
        Arrays.fill(this.toneToggles, 0);
    }

    private void updateNoise() {
        if ((this.noiseSR & 1) != 0) {
            this.noiseSR ^= 0x12000;
        }
        this.noiseSR >>= 1;
    }

    public void nextCycle() {
        int oldcycles;
        int changed;
        if (((changed = (oldcycles = this.cycles++) ^ this.cycles) & 0x10) != 0) {
            int i = 0;
            while (i < 3) {
                int tmp = this.toneCntrs[i] - 1;
                if (tmp <= 0) {
                    tmp = this.tones[i];
                    int n = i;
                    this.toneToggles[n] = ~this.toneToggles[n];
                }
                this.toneCntrs[i] = tmp;
                ++i;
            }
            --this.noiseCntr;
            if (this.noiseCntr <= 0) {
                this.noiseCntr = this.noisePeriod;
                this.updateNoise();
            }
            if ((changed & 0x10) != 0 && --this.envelopeCntr <= 0) {
                this.envelopeCntr = this.envelopePeriod;
                if (!this.sustain) {
                    ++this.envelope;
                    if ((this.envelope &= 0xF) == 0) {
                        int shape = this.ayRegs[13];
                        if ((shape & 8) == 0) {
                            this.sustain = true;
                            this.negEnvelope = 0;
                        } else {
                            if ((shape & 2) != 0) {
                                this.negEnvelope ^= 0xF;
                            }
                            if ((shape & 1) != 0) {
                                this.sustain = true;
                                this.negEnvelope ^= 0xF;
                            }
                        }
                    }
                }
            }
            this.mix = 0;
            int chan = 0;
            while (chan < 3) {
                int amp;
                int isOn = -1;
                if ((this.ayRegs[7] & 1 << chan) == 0) {
                    isOn = this.toneToggles[chan];
                }
                if ((this.ayRegs[7] & 8 << chan) == 0 && (this.noiseSR & 1) == 0) {
                    isOn = 0;
                }
                amp = ((amp = this.ayRegs[8 + chan]) & 0x10) == 0 ? (amp &= 0xF) : this.envelope ^ this.negEnvelope;
                this.mix += vol[amp] & isOn;
                ++chan;
            }
        }
    }

    @Override
    public int nextSample() {
        int acc = 0;
        int i = 0;
        while ((double)i < this.cps) {
            this.nextCycle();
            acc += this.mix;
            ++i;
        }
        acc = this.keep + (int)((double)(acc * 16) * this.recCps);
        this.keep = acc & 0xFF;
        return acc >> 8;
    }

    public void setRegIndex(int reg) {
        this.selectedReg = reg;
    }

    public void writeReg(byte data) {
        if (this.selectedReg >= 0 && this.selectedReg < 16) {
            this.ayRegs[this.selectedReg] = data & 0xFF;
            if (this.selectedReg >= 0 && this.selectedReg <= 5) {
                int i = 0;
                while (i < 3) {
                    this.tones[i] = (this.ayRegs[2 * i] | this.ayRegs[2 * i + 1] << 8) & 0xFFF;
                    ++i;
                }
            } else if (this.selectedReg == 12 || this.selectedReg == 11) {
                this.envelopePeriod = this.ayRegs[11] | this.ayRegs[12] << 8;
            } else if (this.selectedReg == 6) {
                data = (byte)(data & 0x1F);
                this.noisePeriod = data * 2;
            } else if (this.selectedReg == 13) {
                this.envelope = 0;
                this.negEnvelope = (data & 4) == 0 ? 15 : 0;
                this.sustain = false;
                this.envelopeCntr = this.envelopePeriod;
            }
        }
    }

    public static void main(String[] args) {
        int shape = 0;
        while (shape < 16) {
            System.out.print(String.valueOf(Integer.toHexString(shape)) + ": ");
            int envelope = 0;
            int negEnvelope = (shape & 4) == 0 ? 15 : 0;
            boolean sustain = false;
            int i = 0;
            while (i < 32) {
                System.out.print(Integer.toHexString(envelope ^ negEnvelope));
                System.out.append(' ');
                if (!sustain) {
                    ++envelope;
                    if ((envelope &= 0xF) == 0) {
                        if ((shape & 8) == 0) {
                            sustain = true;
                            negEnvelope = 0;
                        } else {
                            if ((shape & 2) != 0) {
                                negEnvelope ^= 0xF;
                            }
                            if ((shape & 1) != 0) {
                                sustain = true;
                                negEnvelope ^= 0xF;
                            }
                        }
                    }
                }
                ++i;
            }
            System.out.println();
            ++shape;
        }
    }
}

