/*
 * Decompiled with CFR 0.152.
 */
package bk2010;

import bk2010.gui.BK2010DisplayPanel;
import bk2010.gui.DiskChangeDialog;
import bk2010.gui.LauncherHWConfigurationDialog;
import bk2010.gui.debugger.DebuggerFrame;
import bk2010.hardware.BaseBK001x;
import bk2010.hardware.TimeScaler;
import bk2010.hardware.TimeSource;
import bk2010.hardware.bus.registers.FDDController;
import bk2010.hardware.cpu.K1801VM1;
import bk2010.io.FakeTape;
import bk2010.io.FloppyDisk;
import bk2010.io.JoystickMapper;
import bk2010.io.KeyMapper;
import bk2010.preferences.MachineConfiguration;
import bk2010.preferences.PathStrings;
import bk2010.preferences.ScreenSizes;
import bk2010.sound.AY8910;
import bk2010.sound.NoSoundException;
import bk2010.sound.SoundRenderer;
import bk2010.sound.StreamOutput;
import bk2010.sound.WaveReader;
import bk2010.sound.WaveWriter;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public final class Emulator {
    static final int maxSkippedFrames = 4;
    long cyclesPerFrame;
    static boolean isSilent = true;
    static int screenshots = 0;
    protected DebuggerFrame debugger;
    protected boolean debuggerOn;
    protected MachineConfiguration hwConf;
    protected BK2010DisplayPanel panel;
    protected BaseBK001x machine;
    protected K1801VM1 cpu;
    protected AY8910 synth;
    protected TimeSource clock12MHz;
    protected FloppyDisk driveA;
    protected FloppyDisk driveB;
    protected byte[] frameBuffer;
    protected byte[] afFrame1;
    protected byte[] afFrame2;
    protected byte[] afFrame3;
    protected byte[][] afFrames;
    protected int afToggle;
    protected boolean antiFlicker;
    protected boolean fakeTape;
    protected boolean cfg11M;
    BufferedImage display;
    SoundRenderer sr;
    StreamOutput so;

    public Emulator(long CPUfreq, MachineConfiguration hwc, BK2010DisplayPanel bdp) throws IOException {
        block19: {
            boolean cfgDiskBasic;
            this.afToggle = 0;
            this.antiFlicker = false;
            this.hwConf = hwc;
            this.panel = bdp;
            String machineConf = this.hwConf.machine.getSelectedName();
            boolean cfgDisk = machineConf.indexOf("DISK") >= 0;
            boolean bl = cfgDiskBasic = cfgDisk && machineConf.indexOf("BASIC") >= 0;
            if (machineConf.indexOf("11M") >= 0) {
                cfgDisk = true;
                cfgDiskBasic = false;
                this.cfg11M = true;
            } else {
                this.cfg11M = false;
            }
            if (this.cfg11M) {
                CPUfreq = 4000000L;
            }
            this.cyclesPerFrame = CPUfreq / 50L;
            this.machine = new BaseBK001x();
            this.cpu = new K1801VM1(this.machine);
            this.machine.timer.setTimeSource(this.cpu);
            this.clock12MHz = new TimeScaler(this.cpu, (int)(12000000L / CPUfreq));
            this.machine.setTimeSource(this.clock12MHz, 12000000);
            if (cfgDisk) {
                this.driveA = new FloppyDisk(CPUfreq);
                this.driveB = new FloppyDisk(CPUfreq);
                FDDController fdc = new FDDController(this.driveA, this.driveB, this.cpu);
                this.machine.attach(fdc);
                if (this.hwConf.diskA.doMount.getState()) {
                    this.driveA.mountImage(this.hwConf.diskA.imageFile, this.hwConf.diskA.readOnly.getState());
                }
                if (this.hwConf.diskB.doMount.getState()) {
                    this.driveB.mountImage(this.hwConf.diskB.imageFile, this.hwConf.diskB.readOnly.getState());
                }
                this.machine.setFDD10Model();
                if (cfgDiskBasic) {
                    fdc.setMemorySelector(this.machine);
                }
                if (this.cfg11M) {
                    this.machine.setFDD11MModel();
                } else {
                    this.machine.writeWord(-24576, (short)95);
                    this.machine.writeWord(-24574, (short)-8192);
                }
            }
            this.fakeTape = hwc.fakeTape.getState();
            if (hwc.readTape.useTape.getState()) {
                this.machine.setTapeReader(new WaveReader(hwc.readTape.tapeFile));
            }
            if (!hwc.noSound.getState()) {
                try {
                    this.so = new StreamOutput();
                    this.sr = new SoundRenderer(this.so, this.cpu, (float)((double)CPUfreq / 48000.0));
                    this.sr.setFilterEnable(hwc.filterSound.getState());
                    if (hwc.AY.getSelected() != 0) {
                        this.synth = new AY8910(62.5f);
                        this.machine.setSynth(this.synth);
                        this.sr.setSynth(this.synth);
                    }
                    this.machine.setSoundRenderer(this.sr);
                    this.machine.setCovoxMode(hwc.Covox.getSelected());
                    isSilent = false;
                    if (!hwc.writeTape.useTape.getState()) break block19;
                    try {
                        this.so.setWaveWriter(new WaveWriter(hwc.writeTape.tapeFile));
                    }
                    catch (IOException e1) {
                        System.out.println("Can't write to the tape file " + hwc.writeTape.tapeFile.getCanonicalPath());
                    }
                }
                catch (NoSoundException e1) {
                    System.out.println("Cannot initialize audio");
                    isSilent = true;
                }
            } else {
                isSilent = true;
            }
        }
        this.display = new BufferedImage(512, 256, 13, BK2010DisplayPanel.getBGR233Model());
        this.panel.setDisplay(this.display);
        this.frameBuffer = new byte[131072];
        if (this.antiFlicker) {
            this.afFrame1 = new byte[131072];
            this.afFrame2 = new byte[131072];
            this.afFrame3 = new byte[131072];
            this.afFrames = new byte[3][];
            this.afFrames[0] = this.afFrame1;
            this.afFrames[1] = this.afFrame2;
            this.afFrames[2] = this.afFrame3;
            this.machine.setRaster(this.afFrame1);
        } else {
            this.machine.setRaster(this.frameBuffer);
        }
        this.cpu.reset();
        this.debugger = new DebuggerFrame(this.cpu);
    }

    /*
     * Unable to fully structure code
     */
    public void runEmulator() {
        cycles = 0L;
        skippedFrames = 0;
        expectedTime = Emulator.isSilent != false ? System.currentTimeMillis() : this.so.timeMillis() - 100L;
        frame = 0;
        while (!Thread.interrupted()) {
            block36: {
                slack = expectedTime - (Emulator.isSilent != false ? System.currentTimeMillis() : this.so.timeMillis());
                if (slack < -30L && skippedFrames <= 4) {
                    ++skippedFrames;
                    System.out.append('.');
                } else {
                    skippedFrames = 0;
                    this.machine.updateRaster();
                    if (this.antiFlicker) {
                        this.afToggle = (this.afToggle + 1) % 3;
                        this.machine.setRaster(this.afFrames[this.afToggle]);
                        af1 = this.afFrames[this.afToggle];
                        af2 = this.afFrames[(this.afToggle + 1) % 3];
                        af3 = this.afFrames[(this.afToggle + 2) % 3];
                        i = 0;
                        while (i < 131072) {
                            tmp1 = af1[i];
                            tmp2 = af2[i];
                            tmp3 = af3[i];
                            if (tmp1 != tmp2 && tmp2 != tmp3) {
                                tmp1 &= 255;
                                tmp2 &= 255;
                                tmp3 &= 255;
                                tmp1 |= tmp1 << 9;
                                tmp2 |= tmp2 << 9;
                                tmp3 |= tmp3 << 9;
                                tmp1 &= 28871;
                                tmp1 = tmp1 + (tmp2 &= 28871) + tmp2 + (tmp3 &= 28871) & 115484;
                                this.frameBuffer[i] = (byte)(tmp1 >> 2 | tmp1 >> 11);
                            } else {
                                this.frameBuffer[i] = (byte)tmp2;
                            }
                            ++i;
                        }
                    }
                    this.display.getRaster().setDataElements(0, 0, 512, 256, this.frameBuffer);
                    slack = expectedTime - (Emulator.isSilent != false ? System.currentTimeMillis() : this.so.timeMillis());
                }
                if (slack < -100L) {
                    expectedTime -= slack;
                    System.out.printf("\nStalled for %d us", new Object[]{(int)(-slack)});
                } else if (slack > 20L && Emulator.isSilent) {
                    try {
                        if (!Emulator.isSilent) {
                            System.out.append('z');
                        }
                        Thread.sleep(slack);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                if (skippedFrames == 0) {
                    this.panel.forceUpdate();
                }
                if (!this.cfg11M) ** GOTO lbl76
                while (this.cpu.getCycles() - cycles <= this.cyclesPerFrame) {
                    if (this.debuggerOn) {
                        this.debuggerOn = this.debugger.invokeDebugger();
                        if (!this.debuggerOn) {
                            this.panel.requestFocus();
                        }
                    }
                    this.cpu.exec_insn();
                    if (!this.fakeTape || (this.cpu.regs[7] & 65535) != 55692) continue;
                    FakeTape.fakeTape(this.machine, this.cpu.regs, true);
                }
                break block36;
lbl-1000:
                // 1 sources

                {
                    if (this.debuggerOn) {
                        this.debuggerOn = this.debugger.invokeDebugger();
                        if (!this.debuggerOn) {
                            this.panel.requestFocus();
                        }
                    }
                    this.cpu.exec_insn();
                    if (!this.fakeTape || (this.cpu.regs[7] & 65535) != 39998) continue;
                    FakeTape.fakeTape(this.machine, this.cpu.regs, false);
lbl76:
                    // 3 sources

                    ** while (this.cpu.getCycles() - cycles <= this.cyclesPerFrame)
                }
            }
            if (this.cfg11M && this.machine.timerEnabled()) {
                this.cpu.irq();
            }
            if (!Emulator.isSilent) {
                this.sr.push();
            }
            cycles += this.cyclesPerFrame;
            expectedTime += 20L;
            keyMapper = this.panel.getKeyMapper();
            key = keyMapper.pollKey();
            if (key > -1) {
                this.machine.keyboard.punch((byte)key);
            } else {
                this.machine.keyboard.setKeyDown(keyMapper.pollKeyHold());
            }
            key = keyMapper.pollEvents();
            if ((key & 512) != 0 && this.driveA != null && !(dc = this.hwConf.diskA).equals(ndc = DiskChangeDialog.doIt("Drive A:", dc))) {
                this.hwConf.diskA = ndc;
                this.driveA.unmountImage();
                if (ndc.doMount.getState()) {
                    this.driveA.mountImage(ndc.imageFile, ndc.readOnly.getState());
                }
            }
            if ((key & 1024) != 0 && this.driveB != null && !(dc = this.hwConf.diskB).equals(ndc = DiskChangeDialog.doIt("Drive B:", dc))) {
                this.hwConf.diskB = ndc;
                this.driveB.unmountImage();
                if (ndc.doMount.getState()) {
                    this.driveB.mountImage(ndc.imageFile, ndc.readOnly.getState());
                }
            }
            if ((key & 1) != 0) {
                this.cpu.nmi();
            }
            if ((key & 2) != 0) {
                this.machine.cycleVideomodes();
            }
            if ((key & 4) != 0) {
                this.cpu.reset();
            }
            if ((key & 16) != 0) {
                this.takeScreenShot();
            }
            if (this.hwConf.debugger.getState()) {
                if ((key & 8) != 0) {
                    this.cpu.trace ^= true;
                }
                if ((key & 256) != 0) {
                    this.debuggerOn = true;
                }
            }
            if ((key & 65536) != 0) {
                System.out.printf("\nRendered %d frames\n", new Object[]{frame});
                break;
            }
            this.machine.joystick.setState(keyMapper.getJoystickState());
            ++frame;
        }
    }

    void takeScreenShot() {
        System.out.println("\nSaving screenshot");
        File shotdir = new File(PathStrings.screenshotsPath);
        if (shotdir.exists() && shotdir.isDirectory() || shotdir.mkdir()) {
            File shot;
            do {
                if (screenshots <= 9999) continue;
                System.out.println("Maximum screenshot count (10000) exceeded");
                shot = new File(String.valueOf(PathStrings.screenshotsPath) + "shot.png");
                break;
            } while ((shot = new File(String.format(String.valueOf(PathStrings.screenshotsPath) + "shot%04d.png", screenshots++))).exists());
            try {
                ImageIO.write((RenderedImage)this.display, "png", shot);
            }
            catch (IOException e) {
                System.out.println("Error saving screenshot");
            }
        }
    }

    public static void main(String[] args) throws IOException {
        MachineConfiguration hwConf = LauncherHWConfigurationDialog.doIt();
        if (!hwConf.doLaunch) {
            System.exit(0);
        }
        JoystickMapper joyMapper = new JoystickMapper();
        KeyMapper keyMapper = new KeyMapper(joyMapper);
        int screenSizeIndex = hwConf.screenSize.getSelected();
        BK2010DisplayPanel panel = new BK2010DisplayPanel(keyMapper, ScreenSizes.sizes[screenSizeIndex][0], ScreenSizes.sizes[screenSizeIndex][1]);
        boolean interpolated = false;
        switch (hwConf.interpolateWhen.getSelected()) {
            case 1: {
                break;
            }
            case 2: {
                interpolated = screenSizeIndex < 3;
                break;
            }
            case 3: {
                interpolated = screenSizeIndex < 5;
                break;
            }
            case 4: {
                interpolated = screenSizeIndex != 5;
                break;
            }
            default: {
                interpolated = true;
            }
        }
        panel.setInterpolate(interpolated);
        BK2010DisplayPanel.SimpleFrame jframe = new BK2010DisplayPanel.SimpleFrame(panel);
        jframe.setDefaultCloseOperation(3);
        Dimension winsize = jframe.getSize();
        Dimension scrsize = jframe.getToolkit().getScreenSize();
        jframe.setLocation((scrsize.width - winsize.width) / 2, (scrsize.height - winsize.height) / 2);
        jframe.setTitle(hwConf.machine.getSelectedName());
        jframe.setIconImage(ImageIO.read(Emulator.class.getResource("/resources/icon_filled.bmp")));
        jframe.setVisible(true);
        Emulator emu = new Emulator(3000000L, hwConf, panel);
        emu.runEmulator();
        System.exit(0);
    }
}

