/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger;

import bk2010.gui.debugger.DisasmPanel;
import bk2010.gui.debugger.MemoryModel;
import bk2010.gui.debugger.RegistersPanel;
import bk2010.hardware.BaseBK001x;
import bk2010.hardware.TimeSource;
import bk2010.hardware.cpu.K1801VM1;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import javax.swing.JFrame;

public class DebuggerFrame
extends JFrame
implements KeyListener {
    K1801VM1 cpu;
    DisasmPanel disasmPanel;
    RegistersPanel registersPanel;
    private static final int DBG_OFF = 0;
    private static final int DBG_TRACE = 1;
    private static final int DBG_LOCK = 2;
    volatile int dbgState = 0;

    public DebuggerFrame(K1801VM1 cpu) {
        super("Debugger");
        this.cpu = cpu;
        this.disasmPanel = new DisasmPanel(new MemoryModel(cpu.machine));
        this.add((Component)this.disasmPanel, "Center");
        this.registersPanel = new RegistersPanel(cpu);
        this.add((Component)this.registersPanel, "East");
        this.pack();
        this.setFocusable(true);
        this.addKeyListener(this);
        this.setDefaultCloseOperation(1);
    }

    public void resync() {
        this.disasmPanel.setPC(this.cpu.regs[7]);
    }

    public boolean invokeDebugger() {
        this.resync();
        this.dbgState = 2;
        this.setVisible(true);
        this.repaint();
        while (this.dbgState == 2) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (this.isVisible()) continue;
            this.dbgState = 0;
        }
        return this.dbgState == 1;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.dbgState == 2) {
            switch (e.getKeyCode()) {
                case 71: {
                    this.dbgState = 0;
                    break;
                }
                case 32: {
                    this.dbgState = 1;
                    break;
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public static void main(String[] args) throws IOException {
        BaseBK001x machine = new BaseBK001x();
        TimeSource stillTime = new TimeSource(){

            @Override
            public long getCycles() {
                return 0L;
            }
        };
        machine.setTimeSource(stillTime, 1000000);
        machine.timer.setTimeSource(stillTime);
        K1801VM1 cpu = new K1801VM1(machine);
        DebuggerFrame fr = new DebuggerFrame(cpu);
        fr.setDefaultCloseOperation(3);
        fr.resync();
        fr.setVisible(true);
    }
}

