/*
 * Decompiled with CFR 0.152.
 */
package bk2010.sound;

import bk2010.sound.NoSoundException;
import bk2010.sound.WaveWriter;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public final class StreamOutput {
    private static final AudioFormat af = new AudioFormat(48000.0f, 16, 1, true, false);
    private SourceDataLine line;
    protected WaveWriter waveOutFile;

    public StreamOutput() throws NoSoundException {
        try {
            this.line = AudioSystem.getSourceDataLine(af);
            this.line.open(af, 8192);
        }
        catch (LineUnavailableException e) {
            throw new NoSoundException();
        }
        this.line.start();
    }

    public void setWaveWriter(WaveWriter wave) {
        this.waveOutFile = wave;
    }

    public void pushSamples(byte[] buf, int off, int len) {
        if (!this.line.isRunning()) {
            System.out.append('$');
        }
        if (this.line.write(buf, off, len) != len) {
            System.out.append('%');
        }
        if (this.waveOutFile != null) {
            this.waveOutFile.append(buf, off, len);
        }
    }

    public long timeMillis() {
        return this.line.getMicrosecondPosition() / 1000L;
    }
}

