/*
 * Decompiled with CFR 0.152.
 */
package bk2010.sound;

import bk2010.sound.WaveWriter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WaveReader {
    protected RandomAccessFile wf;
    protected long len;
    protected long start;
    protected int channels;
    protected int bytes;
    protected int avg = 32768;
    protected int last;
    protected boolean en = true;

    public WaveReader(File file) throws IOException {
        this.wf = new RandomAccessFile(file, "r");
        this.len = this.wf.length();
        this.start = 44L;
        if (!this.validateWave()) {
            this.wf.close();
            this.en = false;
            this.wf = null;
            return;
        }
        this.wf.seek(this.start);
        if (this.bytes > 2) {
            this.wf.skipBytes(this.bytes - 2);
            this.start += (long)(this.bytes - 2);
        }
    }

    private static boolean compareBA(byte[] a, int ofsa, byte[] b, int ofsb, int length) {
        if (a == null) {
            return b == null;
        }
        if (ofsa + length > a.length || ofsb + length > b.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (a[ofsa + i] != b[ofsb + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean validateWave() throws IOException {
        byte[] buf = new byte[100];
        if (this.len < 100L) {
            return false;
        }
        this.wf.read(buf, 0, 100);
        if (!WaveReader.compareBA(buf, 0, WaveWriter.waveHeader, 0, 4)) {
            return false;
        }
        if (!WaveReader.compareBA(buf, 8, WaveWriter.waveHeader, 8, 8)) {
            return false;
        }
        int cs = buf[16] & 0xFF;
        this.channels = buf[22];
        this.bytes = buf[34] + 7 >> 3;
        if (!WaveReader.compareBA(buf, 20 + cs, WaveWriter.waveHeader, 36, 4)) {
            return false;
        }
        this.start = 20 + cs + 8;
        return true;
    }

    public int nextSample() {
        if (!this.en) {
            this.last = -1;
            return -1;
        }
        int acc = 0;
        try {
            int val = 0;
            int i = 0;
            while (i < this.channels) {
                val = this.wf.read();
                if (val == -1) {
                    i = 0;
                    acc = 0;
                    this.wf.seek(this.start);
                    System.out.append("<rewind>");
                    val = this.wf.read();
                }
                val = this.bytes > 1 ? (val |= (this.wf.read() + 128 & 0xFF) << 8) : (val <<= 8);
                if (this.bytes > 2) {
                    this.wf.skipBytes(this.bytes - 2);
                }
                acc += val;
                ++i;
            }
        }
        catch (IOException e) {
            this.en = false;
            this.last = -1;
            return -1;
        }
        this.avg += ((acc /= this.channels) - this.avg) / 16;
        this.last = this.avg < acc ? -1 : 0;
        return this.last;
    }

    public int lastSample() {
        return this.last;
    }
}

