/******************************************************************************/
/*                                  SLIST.HPP                                 */
/*                                                                            */
/*  The SList module defines the members for the singly linked list classes.  */
/*  Note that these classes are the minimum necessary for the example code    */
/*  and would need expansion before any serious use.                          */
/*                                                                            */
/*  Sean Wilson, 1/Feb/1993                                                   */
/******************************************************************************/
#include "slist.hpp"

/******************************************************************************/
/* The Link class defines the basic element of a singly-linked List, it is    */
/* intended to provide the base class for an application specific link type.  */
/******************************************************************************/

Link::Link()
{   next    = (Link *)0;                // There is no next link yet
}

int Link::operator<(const void *tryLink)
{   return 0;
}

/******************************************************************************/
/* The List class provides a base class for an application specific singly-   */
/* linked list.                                                               */
/******************************************************************************/

List::List()
{   head    = (Link *)0;                // Initialise everyting to 0
    curr    = (Link *)0;
}

List::~List()
{   while (head)                        // Kill the list
    {   curr = head->next;
        delete head;
        head = curr;
    }
}

void List::operator+=(Link *link)       // Add in a Link in order
{   Link *prev = (Link *)0;
    Link *curr = head;

    if (curr)                           // If List exists ...
    {   while (curr)                    // iterate through it
        {   if ((Link &)(*curr) < link) // to find an insert position
            {   prev = curr;
                curr = curr->next;
            }
            else
                break;
        }

        if (prev)                       // Insert the new link
        {   link->next  = prev->next;
            prev->next  = link;
        }
        else
        {   link->next  = head;
            head        = link;
        }
    }
    else                                // If the List didn't exist
    {   link->next  = head;             // start it off.
        head        = link;
    }
}

Link *List::operator++(int i)
{   if (!curr)                          // Return the next Link in the
        curr = head;                    // List.  If the List has not
    else                                // yet been queried, the next
        curr = curr->next;              // Link is the head.

    return curr;
}


Link *List::operator--(int i)
{   Link *link = head;

    if (head)                           // Return the first Link in the
    {   head        = head->next;       // List and remove it.
        curr        = (Link *)0;
        link->next  = (Link *)0;
    }

    return link;
}

void List::restart()                    // Allow processing to start at
{   curr = (Link *)0;                   // the head of the List again.
}
