#!ĴTemplate SegmentĿ
#!                               CD31.TPL                 Version: 3102.000
#!ĴContentsĴ
#!Structure             Type       Description                              
#!    ĳ
#!-None-                PROGRAM    Standard Procedure Code                  
#!-None-                MODULE     Standard Module Code                     
#!Ĵ
#! CD31.TPL is the first of a chain of template files that contain the      
#! standard Clarion procedure templates.  These templates generate CUA      
#! compliant, text-based applications.  Other files in the template chain   
#! are PullDown.TPD, Menu.TPD, and so forth.                                
#!                                                                          
#! Initial screen, report, and action images are contained in corresponding 
#! application files with an extension of .APP (e.g. CD31.APP).             
#!                                                                          
#! Template Listing (In CHAIN Order)                                        
#!                                                                          
#!   Clarion.TPL     Module       Initialize a module                       
#!                   Program      Initialize a program                      
#!   PullDown.TPD    Pulldown     Execute a procedure from a pulldown menu  
#!   Menu.TPD        Menu         Execute a procedure from a pop-up menu    
#!   Browse.TPD      Browse       Browse records directly from a file       
#!   List.TPD        List         List a file's records from a memory queue 
#!   Form.TPD        Form         Update a record with a form               
#!   MultiPg.TPD     MultiPage    Update a file with a multiple page entry  
#!   PageOf.TPD      PageOf       Data entry 'Page' used with the MultiPage 
#!   Child.TPD       Child        Update a batch of Child records           
#!   Report.TPD      Report       Print a report                            
#!   Print.TPD       Print        Print a report from memory                
#!   Redirect.TPD    Redirect     Select destination for a report           
#!   View.TPD        View         View a selected text file in a listbox    
#!   Batch.TPD       Batch        Sequential record processing of a file.   
#!   File.TPD        File         Select a file from a directory listing    
#!   Screen.TPD      Screen       Process any screen                        
#!   Source.TPD      Source       Process any source code                   
#!   External.TPD    External     Document external procedure call          
#!   ToDo.TPD        Todo         Undefined procedure code                  
#!   FileCtrl.TPD    #GROUPs      Associated with File Opening/Closing      
#!   Relation.TPD    #GROUPs      Associated with R/I Changes/Deletes       
#!   ScrnFlds.TPD    #GROUPs      Associated with Screen Edit/Setup Code    
#!   GPBrowse.TPD    #GROUPs      Associated with BROWSE type procedures    
#!   GPChild.TPD     #GROUPs      Associated with CHILD procedures          
#!   GPForm.TPD      #GROUPs      Associated with FORM type procedures      
#!   GPCD31.TPD      #GROUPs      Used in various places in the CHAIN       
#!   GPREPORT.TPD    #GROUPs      Associated with REPORT type procedures    
#!   Warnings.TPD    #GROUPs      WARNINGS issued (for easy customization)  
#!   CPD21.TPD       Form21       Version 2.1-Style Form Procedure          
#!                   Table21      Version 2.1-Style Table Procedure         
#!   CP21GRP.TPD     #GROUPs      Used in various places with the 2.1 procs 
#!ĴCommentsĴ
#!Version   Comments                                                        
#!  ĳ
#!3101.000  Version CFD 3.1 Release 3101 Templates                          
#!3102.000  Version CFD 3.1 Release 3102 Templates                          
#!
#!
#PROGRAM,FILES
#!
#!Ŀ
#!                                #PROGRAM                Version: 3102.000
#!ĴDescriptionĴ
#!The Program template generates the PROGRAM statement, MAP structure, FILE 
#!structures, and global declarations for a Clarion program.  This template 
#!also blanks the screen and calls the first procedure.  There is only one  
#!#PROGRAM segment in a template file chain.                                
#!ĴCommentsĴ
#!Version   Comments                                                        
#!  ĳ
#!3101.000  Version CFD 3.1 Release 3101 Templates                          
#!3102.000  Version CFD 3.1 Release 3102 Templates                          
#!
#!
#PROMPT('Enable Mouse Support',CHECK),%MouseSupport
#PROMPT('Enhanced &Background',CHECK),%EnhancedBackground
#PROMPT('Close Unused &Files',CHECK),%CloseFiles
#DISPLAY('Add the EXTERNAL() Flag for Template Declared...')
#PROMPT('G&lobal Data',CHECK),%ExternalData
#DISPLAY('Declare Template Standard Functions as...')
#PROMPT('E&xternal Functions',CHECK),%ExternalFunc
#PROMPT('APPs &Return Value',@s127),%GloRetVal
#PROMPT('Intellidate Value',@s3),%IntelliDateValue
#DISPLAY(' ')
#PROMPT('Program &Author',@S30),%Author
#DISPLAY(' ')
#BUTTON('Com&patibility'),HLP('GLOBALCOMPAT')
  #PROMPT('C&DD 3.0',CHECK),%Compatibility30
  #ENABLE(%Compatibility30)
    #PROMPT('Enable &Shared Files',CHECK),%SharedFiles
    #PROMPT('If &File Not Found',OPTION),%FileNotFound
    #PROMPT('Create',RADIO)
    #PROMPT('Halt',RADIO)
  #ENDENABLE
  #PROMPT('C&PD 2.1',CHECK),%Compatibility21
  #ENABLE(%Compatibility21)
    #PROMPT('Global &ACTION',CHECK),%GlobalAction
    #PROMPT('&Global OpenFiles',CHECK),%GOpen
    #PROMPT('&Reject Key',KEYCODE),%RejectKey
    #PROMPT('&Accept Key',KEYCODE),%AcceptKey
  #ENDENABLE
  #DISPLAY('')
  #DISPLAY('NOTE: Please read the template help concerning')
  #DISPLAY('the 3.0 and 2.1 Compatibility switches.')
#ENDBUTTON
#BUTTON('&GUI Settings'),HLP('GLOBALGUI')
  #PROMPT('&Enable GUI Mode',CHECK),%GloGUIModeON
  #ENABLE(%GloGUIModeON)
    #DISPLAY(' Global Defaults ')
    #PROMPT('Generate Global Code',CHECK),%GloGUIGenCodeON
    #DISPLAY('')
    #PROMPT('&Border Settings',OPTION),%GloGUIBorder
    #PROMPT('GUI Borders      ',RADIO)
    #PROMPT('Fancy GUI Borders',RADIO)
    #PROMPT('No GUI Borders   ',RADIO)
    #DISPLAY('Other Settings:')
    #PROMPT('Display &Title Bars',CHECK),%GloGUITitleDefaultON
    #PROMPT('&Use Field Colors  ',CHECK),%GloGUIFieldColorsON
    #PROMPT('Display Button Icons',CHECK),%GloGUIButtonIconsON
    #PROMPT('Enable &Status Lines',CHECK),%GloGUIMsgDefaultON
    #ENABLE(%GloGUIMsgDefaultON)
      #BUTTON(' Status &Lines'),HLP('GLOBALGUISTATUSLINES')
        #PROMPT('&Show at Top of Loop',CHECK),%GloGUIStatAreaShow
        #DISPLAY(' Area 1 ')
        #PROMPT('Length of Area',@s3),%GloGUIStatArea1Len
        #PROMPT('Display Value',@s254),%GloGUIStatArea1Val
        #ENABLE(%GloGUIStatArea1Len > 0)
          #DISPLAY(' Area 2 ')
          #PROMPT('Length of Area',@s3),%GloGUIStatArea2Len
          #PROMPT('Display Value',@s254),%GloGUIStatArea2Val
          #ENABLE(%GloGUIStatArea2Len > 0)
            #DISPLAY(' Area 3 ')
            #PROMPT('Length of Area',@s3),%GloGUIStatArea3Len
            #PROMPT('Display Value',@s254),%GloGUIStatArea3Val
            #ENABLE(%GloGUIStatArea3Len > 0)
              #DISPLAY(' Area 4 ')
              #PROMPT('Length of Area',@s3),%GloGUIStatArea4Len
              #PROMPT('Display Value',@s254),%GloGUIStatArea4Val
            #ENDENABLE
          #ENDENABLE
        #ENDENABLE
      #ENDBUTTON
    #ENDENABLE
    #DISPLAY('')
  #ENDENABLE
#ENDBUTTON
#!

#IF(%GloGUIModeON)                             #! GUI Mode
  #INSERT(%GloGUIInitTplGrp)                   #! GUI Mode
  #PROJECT('%clapfx%XGUI.OBJ')                 #! GUI Mode
  #MAP('GUI.INC')                              #! GUI Mode
#ENDIF                                         #! GUI Mode

#SET(%True,(1))
#SET(%False,(0))
#IF(%Compatibility30)
  #IF(%SharedFiles)
    #SET(%AccessMode,'42h')
  #ELSE
    #SET(%AccessMode,'22h')
  #ENDIF
#ENDIF
                TITLE('%Program')
 OMIT('')
ͻ
  Program - %Program                          #<!                           
  Author  - %Author                           #<!                           
ͼ
                 PROGRAM

                 INCLUDE('KEYCODES.EQU')
                 INCLUDE('CLARION.EQU')
                 INCLUDE('ERRORS.EQU')
#IF(%Compatibility21)
                 INCLUDE('C21KEYS.EQU')
#ENDIF
                 MAP
#IF(%GloGUIModeON)                             #! GUI Mode
                   #INSERT(%GloGUIMapEntryGrp) #! GUI Mode
#ENDIF                                         #! GUI Mode
#IF(%ExternalFunc)
                   MODULE('External Standard 3.1 Template Functions')
#ELSE
                   ! Standard 3.1 Template Functions
#ENDIF
#IF(%Compatibility21 AND %GOpen)
                     G_OPENFILES
                     G_OPENFILES2(FILE)
#ELSE
  #IF(%CloseFiles)
                     CheckOpen(FILE,<BYTE>,<BYTE>),BYTE
  #ELSE
                     CheckOpen(FILE,<BYTE>,<BYTE>)
  #ENDIF
#ENDIF
                     DiskError(<STRING>),BYTE
                     ShowWarning
                     ConfirmedProcess,SHORT
#IF(%ExternalFunc)
                   END
#ENDIF
                   %ModuleStructures
                   #EMBED('Inside Global MAP')
                 END

                 EJECT('File Layouts')

#EMBED('Before AppGen Global Data')
%GlobalData
#EMBED('After AppGen Global Data')
#EMBED('Before File Declarations')

#FOR(%AppFiles)
  #FIX(%File,%AppFiles)
 OMIT('')
Ŀ
File:   %File                                 #<!                           
Prefix: %FilePre                              #<!                           
  #IF(%FileDescription)
Desc:   %FileDescription                      #<!                           
  #ENDIF
Driver: %FileType                             #<!                           
  #IF(%FileTypeParameter)
  Code: %FileTypeParameter                    #<!                           
  #ENDIF
  #IF(%FileOwner)
Owner:  %FileOwner                            #<!                           
  #ENDIF
  #IF(%FileCreate)
File Create On                                #<!                           
  #ELSE
File Create Off                               #<!                           
  #ENDIF
  #FOR(%Key)
Ĵ
    #IF(%Key=%FilePrimaryKey)
Key:    %Key (Primary)                        #<!                           
    #ELSE
Key:    %Key                                  #<!                           
    #ENDIF
    #IF(%KeyDescription)
Desc:   %KeyDescription                       #<!                           
    #ENDIF
    #IF(%KeyAuto)
Auto Increment                                #<!                           
    #ENDIF
    #IF(%KeyDuplicate)
Key ALLOWS Duplicates                         #<!                           
    #ELSE
Key DOES NOT Allow Duplicates                 #<!                           
    #ENDIF
    #FOR(%KeyField)
      #IF(%KeyFieldSequence = 'ASCENDING')
Field (Ascending):  %KeyField                 #<!                           
      #ELSE
Field (Descending): %KeyField                 #<!                           
      #ENDIF
    #ENDFOR
  #ENDFOR

%FileStructure
#ENDFOR

IntelliDateValue        SHORT,NAME('_IntelliDateValue'),EXTERNAL
#IF(%ExternalData)
GlobalRequest           LONG,EXTERNAL          #<!  Request Action Flag
GlobalResponse          LONG,EXTERNAL          #<!  Response Action Flag
#ELSE
GlobalRequest           LONG                   #<!  Request Action Flag
GlobalResponse          LONG                   #<!  Response Action Flag
#ENDIF
#IF(%Compatibility21)
  #IF(%GlobalAction)
#IF(%ExternalData)
Action                  SHORT,EXTERNAL
#ELSE
Action                  SHORT
#ENDIF
  #ENDIF
  #IF(%RejectKey)
REJECT_KEY              EQUATE(%RejectKey)
  #ENDIF
  #IF(%AcceptKey)
ACCEPT_KEY              EQUATE(%AcceptKey)
  #ENDIF
#ENDIF
RequestCancelled        EQUATE(1)              !    Process Completed
RequestCompleted        EQUATE(2)              !    Process Aborted
InsertRecord            EQUATE(1)              !    Add a record to table
ChangeRecord            EQUATE(2)              !    Change the current record
DeleteRecord            EQUATE(3)              !    Delete the current record
SelectRecord            EQUATE(4)              !    Select the current record
CheckRecord             EQUATE(5)              !    Select the current record
Record:OK               EQUATE(0)              !  Record passes range and filter
Record:OutOfRange       EQUATE(1)              !  Record fails range test
Record:Filtered         EQUATE(2)              !  Record fails filter tests

ReadOnly                EQUATE(0)
WriteOnly               EQUATE(1)
ReadWrite               EQUATE(2)
DenyAll                 EQUATE(10h)
DenyWrite               EQUATE(20h)
DenyRead                EQUATE(30h)
DenyNone                EQUATE(40h)
FCBMode                 EQUATE(0)
#IF(%GloGUIModeON)                             #! GUI Mode
#INSERT(%GloGUIDataGrp)                        #! GUI Mode
#ENDIF                                         #! GUI Mode
#EMBED('Data Section')

  CODE
  #IF(%IntelliDateValue)
  IntelliDateValue = %IntelliDateValue         #<!Initialize for entire APP
  #ENDIF
  #EMBED('Setup Program')
  #IF(%GloGUIModeON)                           #! GUI Mode
  #INSERT(%GloGUICodeGrp)                      #! GUI Mode
  #ELSE                                        #! GUI Mode
  LOADSYMBOLS                                  #<!Display graphic mouse
  #ENDIF                                       #! GUI Mode
  #IF(%EnhancedBackground)
  SETNOBLINK                                   #<!Enable enhanced colors
  #ENDIF
  #IF(%HelpFile)
  HELP('%HelpFile')                            #<!Open the help file
  #ENDIF
  #IF(%StyleFile )
  GETSTYLES('%StyleFile')                      #<!Open the style file
  #ENDIF
  #IF(%MouseSupport)
  SETMOUSE(1,1)                                #<!Turn on mouse
  #ENDIF
  SETCOLOR(WhiteOnBlack)                       #<!Set white on black
  BLANK                                        #<!Clear the screen
  SETCOLOR                                     #<!Turn off override color
  #IF(%Compatibility21 AND %GOpen)
  G_OPENFILES
  #ENDIF
  #EMBED('Before First Procedure Call')

  %FirstProcedure                              #<!Call the first procedure

  #EMBED('Before return to DOS')
  #IF(%GloRetVal)                              #!IF global return value
  HALT(%GloRetVal)                             #<!Return with specific value
  #ELSE
  HALT(0)                                      #<!Default return
  #ENDIF

#IF(NOT %ExternalFunc)                         #!IF NOT %ExternalFunc
#IF(%Compatibility21 AND %GOpen)
G_OPENFILES  PROCEDURE                           !OPEN FILES & CHECK FOR ERROR
  CODE
  #FOR(%AppFiles)
  IF SEND(%AppFiles,'RECOVER=120').              !HOLDS TIMEOUT IN 120 SECONDS
  G_OPENFILES2(%AppFiles)
  IF SEND(%AppFiles,'RECOVER=0').                !HOLDS TIMEOUT IN 120 SECONDS
  #ENDFOR
  BLANK                                          !BLANK THE SCREEN

G_OPENFILES2 PROCEDURE(G_FILE)                   !OPEN EACH FILE & CHECK ERROR
FILE_NAME    STRING(64)

  CODE
  SETCOLOR(MAKECOLOR(7,0))
  FILE_NAME = NAME(G_FILE)                       !SAVE THE NAME FOR DISPLAY
  SHOW(25,1,CENTER('SHARING FILE: ' & CLIP(FILE_NAME),80)) !DISPLAY FILE NAME
  SHARE(G_FILE)                                  !OPEN THE FILE IN SHARED MODE
  IF ERROR()                                     !OPEN RETURNED AN ERROR
    CASE ERRORCODE()                             ! CHECK FOR SPECIFIC ERROR
    OF BadKeyErr                                 !  KEYS NEED TO BE REBUILT
      SETCOLOR(MAKECOLOR(0,7))
      SHOW(25,1,CENTER('REBUILDING KEY FILES FOR ' & CLIP(FILE_NAME),80))
      CLOSE(G_FILE)                              !  CLOSE THE FILE
      OPEN(G_FILE)                               !  TRY TO GET EXCLUSIVE ACCESS
      IF ERRORCODE() = 0 OR ERRORCODE() = BadKeyErr! IF KEYS NEED TO BE REBUILT
        BUILD(G_FILE)                            !    CALL THE BUILD PROCEDURE
        IF ERROR()                               !    IF ERROR
          LOOP                                   !      STOP EXECUTION
            STOP('Cannot Build ' & FILE_NAME & ' - Error: ' & ERROR())
        . .
        SETCOLOR(MAKECOLOR(7,0))
        BLANK(25,1,1,80)                         !    BLANK THE MESSAGE
        CLOSE(G_FILE)                            !    CLOSE UNSHARED FILE
        SHARE(G_FILE)                            !    OPEN FILE SHARED
        IF ERROR()                               !    IF ERROR
          LOOP                                   !      STOP EXECUTION
            STOP('Cannot Share ' & FILE_NAME & ' - Error: ' & ERROR())
        . .
        SETCOLOR(MAKECOLOR(7,0))
        BLANK(25,1,1,80)                         !    BLANK THE MESSAGE
      ELSE                                       !    ANY OTHER ERROR
        LOOP                                     !      STOP EXECUTION
          STOP('Cannot Share ' & FILE_NAME & ' - Error: ' & ERROR())
      . .
    OF MemoMissing                               ! MEMO FILE NOT FOUND
      LOOP                                       !  STOP EXECUTION
        STOP('Cannot Open Memo File for ' & FILE_NAME & ERROR())
      .
    OF NoFileErr                                 !IF NOT FOUND,
      CREATE(G_FILE)                             !  THEN CREATE
      IF ERROR()                                 !STOP ON UNNEXPECTED ERROR
        LOOP
          STOP('Cannot Create ' & FILE_NAME & ' - Error: ' & ERROR())
      . .
      CLOSE(G_FILE)                              !  CLOSE IT SO IT CAN
      SHARE(G_FILE)                              !    BE OPENED SHARED
      IF ERROR()                                 !STOP ON UNNEXPECTED ERROR
        LOOP
          STOP('Cannot Share ' & FILE_NAME & ' - Error: ' & ERROR())
      . .
    ELSE                                         ! ANY OTHER ERROR
      LOOP                                       !  STOP EXECUTION
        STOP('Cannot Share ' & FILE_NAME & ' - Error: ' & ERROR())
      .
  . .
  SETCOLOR()

#ELSE
 OMIT('')

Ĵ Function Ŀ
                                 CheckOpen              Version: 3100.00
ĴCommentsĴ
Version   Comments                                                        
  ĳ
3100.00  Release of CDD3 version 3100 templates                          


  #IF(%CloseFiles)                              #!Generate function for close
CheckOpen         FUNCTION(File,OverrideCreate,OverrideOpenMode)
  #ELSE
CheckOpen         PROCEDURE(File,OverrideCreate,OverrideOpenMode)
  #ENDIF
LOC::ReturnVal    BYTE(0)
CurrentOpenMode   SHORT

  CODE
  #EMBED('CheckOpen: Setup Procedure')
  #IF(%Compatibility30)
  OPEN(File,%AccessMode)                       #<!Attempt to open the file
  #ELSE
  IF OMITTED(3)
    OPEN(File,42h)                             #<!Attempt to open the file
  ELSE
    OPEN(File,OverrideOpenMode)                #<!Attempt to open the file
  END
  #ENDIF
  CASE ERRORCODE()                             #<! and check for errors
  OF NoError                                   #<!Return opened flag
    #EMBED('CheckOpen: No Error')
    LOC::ReturnVal = True
    DO ProcedureReturn                           ! signal successful open
  OF IsOpenErr                                 #<! or if already open.
    #EMBED('CheckOpen: File Open Error')
    DO ProcedureReturn
  #IF(%Compatibility30)
    #IF(%FileNotFound <> 'Halt')
  OF NoFileErr                                 #<!If file was not found
    #EMBED('CheckOpen: No File Error')
    CREATE(File)                               #<!Create the file
    IF ERRORCODE()
      #INSERT(%CreateFailureMsg)
    END
    OPEN(File,%AccessMode)                     #<! then open it
    IF ~ERRORCODE()                            #<!  And return if it opened
      LOC::ReturnVal = True
      DO ProcedureReturn                         ! signal successful open
    ELSE
      HALT(ERRORCODE())
    END
    #ENDIF
  #ELSE
  OF NoFileErr                                 #<!If file was not found
    #EMBED('CheckOpen: No File Error')
    IF OMITTED(2)
      CREATE(File)                             #<!Create the file
      IF ERRORCODE()
        #INSERT(%CreateFailureMsg)
      END
      IF OMITTED(3)
        OPEN(File,42h)                         #<! then open it
      ELSE
        OPEN(File,OverrideOpenMode)
      END
      IF ~ERRORCODE()                          #<!  And return if it opened
        LOC::ReturnVal = True
        DO ProcedureReturn                       ! signal successful open
      ELSE
        HALT(ERRORCODE())
      END
    ELSIF OverrideCreate
      CREATE(File)                             #<!Create the file
      IF ERRORCODE()
        #INSERT(%CreateFailureMsg)
      END
      IF OMITTED(3)
        OPEN(File,42h)                         #<! then open it
      ELSE
        OPEN(File,OverrideOpenMode)
      END
      IF ~ERRORCODE()                          #<!  And return if it opened
        LOC::ReturnVal = True
        DO ProcedureReturn                       ! signal successful open
      ELSE
        HALT(ERRORCODE())
      END
    END
  #ENDIF
  OF InvalidFileErr                            #<!Invalid Record Declaration
    #EMBED('CheckOpen: Invalid File Error')
    #INSERT(%InvalidFileMsg)
    HALT(InvalidFileErr)
  OF BadKeyErr                                 #<!Key Files must be rebuilt
    #EMBED('CheckOpen: Bad Key Error')
    #INSERT(%BadKeyMsg)
    OPEN(File,12H)                               !Open for exclusive access
    BUILD(File)                                  !Rebuild the key files
    IF ERRORCODE()
      #INSERT(%KeyBuildErrorMsg)
      HALT(BadKeyErr)
    ELSE
      CLOSE(File)                                !Close
      OPEN(File,%AccessMode)                   #<! then re-open it
      LOC::ReturnVal = True
      DO ProcedureReturn                         ! signal successful open
    END
  END                                          #<!End of Case Structure
  IF DiskError(CLIP(NAME(File)) & ' File could not be opened') THEN HALT(0). #<!Cannot resume
  DO ProcedureReturn
ProcedureReturn ROUTINE
  #EMBED('CheckOpen: Directly before return')
  #IF(%CloseFiles)                              #!Generate function for close
  RETURN(LOC::ReturnVal)
  #ELSE
  RETURN
  #ENDIF
#ENDIF
OMIT('')

Ĵ Function Ŀ
                                DiskError               Version: 3102.00 
ĴDescriptionĴ
 Function called to post errors if a disk related error has occurred.     


DiskError        FUNCTION(Cause)
StopMsg::        STRING(180)
LOC::ReturnVal   BYTE(0)

  CODE
  CLEAR(StopMsg::)
  #EMBED('DiskErr: Setup Procedure')
  IF ~ERRORCODE() THEN DO ProcedureReturn.     #<!Return with no error
  IF ~OMITTED(1)                               #<!If a cause was given
    StopMsg:: = 'Cause: ' & Cause & LF:CR      #<!  Display it
  END                                          #<!End IF
  IF ERRORFILE()                               #<!If error involves a file
    StopMsg:: = CLIP(StopMsg::) & 'File : '  | #<!  display the file
              & ERRORFILE() & LF:CR
  END                                          #<!End IF
  StopMsg:: = CLIP(StopMsg::) & 'Error: '    | #<!Display the error code
            & ERRORCODE() & ' - '            | #<!  and the error message
            & ERROR() & LF:CR

  STOP(StopMsg::)                              #<!Stop with message
  LOC::ReturnVal = True                        #<!Return with error
  DO ProcedureReturn

ProcedureReturn ROUTINE
  #EMBED('DiskErr: Directly before return')
  RETURN(LOC::ReturnVal)

 OMIT('')
ͻ
  Display a warning message using 3 Global message variables.               
ͼ
ShowWarning      PROCEDURE

SaveStyle        STRING(256)

Screen           SCREEN(10,53),PRE(SCR),CENTER,SHADOW,CUA,COLOR(112)
                   ROW(1,1)    STRING('{53}'),COLOR(116)
                   ROW(10,1)   STRING('{51}'),COLOR(116)
                               REPEAT(8)
                   ROW(2,1)      STRING(''),COLOR(116)
                   ROW(2,53)     STRING(''),COLOR(116)
                               .
                   ROW(3,5)    ENTRY(@S45),USE(GLO:Message1),INS,SKIP,COLOR(112,112,112)
                   ROW(4,5)    ENTRY(@S45),USE(GLO:Message2),INS,SKIP,COLOR(112,112,112)
                   ROW(5,5)    ENTRY(@s45),USE(GLO:Message3),INS,SKIP,COLOR(112,112,112)
                   ROW(7,24)   BUTTON('  &Ok  |'),SHADOW,USE(?Ok),COLOR(23,71,24,31,79)
                 .

  CODE
  #EMBED('ShowWarning: Setup Procedure')
  SaveStyle = STYLES()                         #<!Save current style
  GETSTYLES('')                                #<!Turn off Styles
  GLO:Message1 = CENTER(GLO:Message1,SIZE(GLO:Message1))
  GLO:Message2 = CENTER(GLO:Message2,SIZE(GLO:Message2))
  GLO:Message3 = CENTER(GLO:Message3,SIZE(GLO:Message3))
  #EMBED('ShowWarning: Before Screen Opening')
  OPEN(Screen)
  DISPLAY
  ACCEPT                                       #<!Enable keyboard and mouse
  #EMBED('ShowWarning: After Accept')
  CLEAR(GLO:MessageGroup)                      #<!Blank out message fields
  SETSTYLES(SaveStyle)                         #<!Restore user styles
  DO ProcedureReturn
ProcedureReturn ROUTINE
  #EMBED('ShowWarning: Directly before return')
  RETURN

 OMIT('')
ͻ
  Display a confirmation message using 3 Global message variables.          
  Function will return 1 for confirming process.                            
  Function will return 0 for aborting process.                              
ͼ
ConfirmedProcess FUNCTION

SaveStyle      STRING(256)
RetVal         SHORT

Screen           SCREEN(10,53),PRE(SCR),CENTER,SHADOW,CUA,COLOR(112)
                   ROW(1,1)    STRING('{53}'),COLOR(116)
                   ROW(10,1)   STRING('{51}'),COLOR(116)
                               REPEAT(8)
                   ROW(2,1)      STRING(''),COLOR(116)
                   ROW(2,53)     STRING(''),COLOR(116)
                               .
                   ROW(3,5)    ENTRY(@S45),USE(GLO:Message1),INS,SKIP,COLOR(112,112,112)
                   ROW(4,5)    ENTRY(@S45),USE(GLO:Message2),INS,SKIP,COLOR(112,112,112)
                   ROW(5,5)    ENTRY(@s45),USE(GLO:Message3),INS,SKIP,COLOR(112,112,112)
                   ROW(7,16)   BUTTON('  &Ok  |'),SHADOW,KEY(EnterKey),USE(?Ok),COLOR(23,71,24,31,79)
                     COL(29)   BUTTON(' &Cancel '),SHADOW,KEY(EscKey),USE(?Cancel),COLOR(23,71,24,31,79)
                 .

  CODE
  #EMBED('ConfirmProcess: Setup Procedure')
  SaveStyle = STYLES()                         #<!Save current style
  GETSTYLES('')                                #<!Turn off Styles
  GLO:Message1 = CENTER(GLO:Message1,SIZE(GLO:Message1))
  GLO:Message2 = CENTER(GLO:Message2,SIZE(GLO:Message2))
  GLO:Message3 = CENTER(GLO:Message3,SIZE(GLO:Message3))
  #EMBED('ConfirmProcess: Before Screen Opening')
  OPEN(Screen)
  DISPLAY
  LOOP
   ACCEPT                                      #<!Enable keyboard and mouse
   CASE KEYCODE()
   #EMBED('ConfirmProcess: After Accept')
   OF EnterKey
      RetVal = 1
      BREAK
   OF EscKey
      RetVal = 0
      BREAK
   END
  END
  CLEAR(GLO:MessageGroup)                      #<!Blank out message fields
  SETSTYLES(SaveStyle)                         #<!Restore user styles
  DO FunctionReturn
FunctionReturn ROUTINE
  #EMBED('ConfirmProcess: Directly before return')
  RETURN(RetVal)
#ENDIF                                         #!ENDIF NOT %ExternalFunc
#IF(%GloGUIModeON)                             #! GUI Mode
#INSERT(%GloGUIResetProcGrp)                   #! GUI Mode
#ENDIF                                         #! GUI Mode

#!
#MODULE
#!
#!Ŀ
#!                                 #MODULE                Version: 3102.000
#!ĴDescriptionĴ
#!The Module template generates the MEMBER statement, and module level data 
#!declarations for a source module of a Clarion program.  There is only one 
#!#MODULE segment in a template file chain.                                 
#!
#!
                MEMBER('%Program')
 OMIT('')
ͻ
   %Module - %ModuleDescription               #<!                           
ͼ
%ModuleData
#EMBED('Data Section')
#!
#CHAIN('PullDown.tpd')
