/* Copyright (C) 1992 Pete Chown.

   Here is my latest adventure game, Napoleon (see the documentation
   if you don't know why it's called that).  Have fun... (don't cheat,
   even though you've got the source :-) ).

   This game is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The game is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   675 Mass Ave, Cambridge, MA 02139, USA. */

#include "adv.h"

static const char *filehead = "Napoleon " VERSION;
static int numobjects;

extern void loadgame(void)
{
  FILE *infile;
  char *name,buffer [128];

  name = getline("Filename >",LINE_NO_HISTORY);
  infile = fopen(name,"rb");
  if(infile == 0) {
    format("Sorry, can't open that file.\n");
    return;
  }
  fread(buffer,strlen(filehead),1,infile);
  if(strncmp(buffer,filehead,strlen(filehead))) {
    format("Sorry, that file is not a Napoleon saved game, or it is a Napole"
"on saved game from a different version of the program.\n");
  } else {
    fread(flags,sizeof(flags),1,infile);
    fread(objects,sizeof(object),numobjects,infile);
  }
  fclose(infile);
  resumscore();
  descr = TRUE;
}

extern void savegame(void)
{
  FILE *outfile;
  char *name;

  name = getline("Filename >",LINE_NO_HISTORY);
  outfile = fopen(name,"wb");
  if(outfile == 0) {
    format("Sorry, can't open that file.\n");
    return;
  }
  fwrite(filehead,strlen(filehead),1,outfile);
  fwrite(flags,sizeof(flags),1,outfile);
  fwrite(objects,sizeof(object),numobjects,outfile);
  fclose(outfile);
}

extern void initialise(void)
{
  int i;

  for(numobjects = 0;intobjects [numobjects].examine != (char *) 1;numobjects++);
  numobjects++;

  if(objects == 0) objects = xmalloc(numobjects * sizeof(object));

  memcpy(objects,intobjects,numobjects * sizeof(object));

  player = -1;
  for(i = 0;;i++)
  {
    if(objects [i].objtype.player) {
      player = i;
      break;
    }
  }
  if(player == -1) fail();

  for(i = 0;i < 128;i++) flags [i] = 0;
}
