/* Copyright (C) 1992 Pete Chown.

   Here is my latest adventure game, Napoleon (see the documentation
   if you don't know why it's called that).  Have fun... (don't cheat,
   even though you've got the source :-) ).

   This game is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The game is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   675 Mass Ave, Cambridge, MA 02139, USA. */

#include "adv.h"

static void showboard(char *board)
{
  printf("The board currently contains:\n\n   |   |\n %c | %c | %c\n   |   |"
"\n---+---+---\n   |   |\n %c | %c | %c\n   |   |\n---+---+---\n   |   |\n %c"
" | %c | %c\n   |   |\n",board [0],board [1],board [2],board [3],board [4],board [5],board [6],board [7],board [8]);
}

static void playersmove(char *board,char playerch)
{
  char *line;
  signed char square;

  printf("\nPlease enter your move:\n");
  for(;;)
  {
    line = getline(">",LINE_NO_HISTORY);
    square = atoi(line) - 1;
    if(square < 0 || square > 8 || ! isdigit(board [square])) format("The Gr"
"andmaster says, 'You are not allowed to play there, my friend.'"); else break;
  }
  board [square] = playerch;
}

#define ROW(a,b,c) \
  if(board [a] == 'X' && board [b] == 'X' && board [c] == 'X') return 'X';\
  if(board [a] == 'O' && board [b] == 'O' && board [c] == 'O') return 'O'

static int whowon(char *board)
{
  ROW(0,1,2);
  ROW(3,4,5);
  ROW(6,7,8);
  ROW(0,3,6);
  ROW(1,4,7);
  ROW(2,5,8);
  ROW(0,4,8);
  ROW(2,4,6);

  return 0;
}

static int movecomputer(char *board,char compch,int nummoves,bool undomove)
{
  char goodmoves [9],numgoodmoves = 0,otherch = compch == 'X' ? 'O' : 'X',winner,i;
  signed char score = 2;

  if(nummoves == 0) {
    board [rnd(9)] = compch;
    return 0;
  }

  winner = whowon(board);
  if(winner == compch) return 1;
  if(winner == otherch) return -1;
  if(nummoves == 9) return 0;

  for(i = 0;i < 9;i++)
  {
    if(isdigit(board [i])) {
      signed char thisposition;

      board [i] = compch;
      thisposition = movecomputer(board,otherch,nummoves + 1,TRUE);
      board [i] = i + '1';

      if(thisposition < score) {
        score = thisposition;
	numgoodmoves = 0;
      }
      if(thisposition == score) {
	goodmoves [(int) numgoodmoves++] = i;
      }
    }
  }

  if(numgoodmoves == 0 || score == 2) fail();
  if(! undomove) board [goodmoves [rnd(numgoodmoves)]] = compch;

  return -score;
}

static int doagame(bool playerstarts)
{
  char board [] = "123456789",nummoves = 0,winner,playerch,compch;
  bool playergo = playerstarts;

  if(playerstarts) {
    playerch = 'X';
    compch = 'O';
  } else {
    playerch = 'O';
    compch = 'X';
  }

  while(whowon(board) == 0 && nummoves < 9)
  {
    showboard(board);
    if(playergo) playersmove(board,playerch); else {
      format("The Grandmaster ponders for a while, and then makes his move:\n");
      more();
      movecomputer(board,compch,nummoves,FALSE);
    }
    playergo = ! playergo;
    nummoves++;
  }

  winner = whowon(board);
  if(winner == 'X' && playerstarts) return 1;
  if(winner == 'O' && playerstarts) return 0;
  if(winner == 'X') return 0;
  if(winner == 'O') return 1;
  return 2;
}

/* playnoughts() returns 0 for a drawn match (the computer should never lose, at least), 1 for a
   match the player just lost, and 2 for a match the player lost by a big margin.  */

extern int playnoughts(void)
{
  int computer = 0,player = 0,drawn = 0;
  bool playerstarts = TRUE;

  while(computer + player + drawn < 3)
  {
    switch(doagame(playerstarts))
    {
    case 0:
      format("The Grandmaster says, 'Noughts and Crosses is a fine game, do "
"you not agree?'");
      computer++;
      break;
    case 1:
      format("The Grandmaster looks a little bit crestfallen, and wipes out "
"the board ready for his next game.");
      player++;
      break;
    case 2:
      format("The Grandmaster says, 'Would you believe, some people think th"
"at it is always possible to force a draw at noughts and crosses?'");
      drawn++;
      break;
    }
    playerstarts = ! playerstarts;
  }

  if(drawn == 2 && computer == 1) return 1;
  if(computer <= player) return 0;
  return 2;
}
