/* Copyright (C) 1992 Pete Chown.

   Here is my latest adventure game, Napoleon (see the documentation
   if you don't know why it's called that).  Have fun... (don't cheat,
   even though you've got the source :-) ).

   This game is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The game is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   675 Mass Ave, Cambridge, MA 02139, USA. */

#include "adv.h"

static bool showcourt(char *court,char ball,char *expected)
{
  char input1 [2] = " ",input2 [2] = " ",*input;

  format("Here is the current state of the court.  The Ps represent the othe"
"r players, the Y is you, and the arrow indicates the direction the ball is c"
"urrently moving in.\n\n"
"       |         \n"
"   %c   %c   %c   \n"
"       |         \n"
"---%c---+---%c---\n"
"       |         \n"
"   %c   %c   %c   \n"
"       |         \n\n",court [0],ball == '<' ? '<' : '|',court [1],ball == 'v' ? 'v' : '-',ball == '^' ? '^' : '-',court [2],ball == '>' ? '>' : '|',court [3]);

  format("Enter 'h' if you want to hit the ball this turn, or 'r' if you wan"
"t to run somewhere.  Just press return if you don't want to do anything.\n");
  do {
    input = getline(">",LINE_NO_HISTORY);
    input1 [0] = input [0];
    input1 [1] = 0;
    *input1 = tolower(*input1);
  } while(strlen(input1) > 1 || (*input1 != 'r' && *input1 != 'h' && *input1 != 0));
  if(*input1 != 0) {
    format("\nEnter the direction you want%s to go, as n, s, e or w.\n",*input1 == 'r' ? "" : " it");
    do {
      input = getline(">",LINE_NO_HISTORY);
      input2 [0] = input [0];
      input2 [1] = 0;
      *input2 = tolower(*input2);
    } while(strlen(input2) > 1
	    || (*input2 != 'n' && *input2 != 's' && *input2 != 'w' && *input2 != 'e'));
  }
  if(*expected == 0 && *input1 == 0) return TRUE;
  if(*input1 != *expected) return FALSE;
  if(*input2 != expected [1]) return FALSE;
  return TRUE;
}

extern bool quadruples(void)
{
  if(! showcourt("PPY ",'<',"")) return FALSE;
  if(! showcourt("P YP",'v',"he")) return FALSE;
  if(! showcourt(" PYP",'>',"rn")) return FALSE;
  if(! showcourt("YP P",'^',"")) return FALSE;
  if(! showcourt("YPP ",'<',"hs")) return FALSE;
  if(! showcourt("Y PP",'v',"re")) return FALSE;
  return TRUE;
}
