/* start baby */
               
alley: room
  sdesc = "Alley"
  ldesc = {
    "A filthy place, mongrels and predators scurry and skulk about the edges of
    your vision, seemingly self-satisfied in their hidden snark just beyond your focus.\b
    The alley wall behind you rises until it seems that you shall never grow tall
    enough to surpass it.  It melts away in its own acclivity, merging into a
    starless night.  ";
    if (!self.seen) {
      self.seen := true;
      "Walls to both sides reflect a build of age and accompanying
      deterioration. Your skin crawls with the sensations of spying from some
      <i>things</i>, some group of denizens choosing themselves to be, as of yet,
      unrevealed. ";
    }
    else {
      "\bWalls to both sides reflect a build of age and accompanying deterioration. ";
    }
    "\bFogging spoils your far sight to the west, while it reveals your sole path
    for this continued evening venture. ";
  }
  smelldesc = "You are deep within the slaughterhouse district. You can trace scents of
              blood, butchery and decay. Bits of excrement and trash are smeared into
              the street, they mix to form an additional unpleasantry. "
  listendesc = {
    if (!alley3.seen)
      "The occasional chirp of a nearby salesman can be heard to the west. ";
    else
      "Eerie silence. ";
  }
  noexit = { "But you can proceed only west from here. "; }
  west = alley2
  isOutside = true
  genericHint = true
/*  down = forestPath
  up = {
    snake.moveInto(Me);
    earlobe.moveInto(Me);
    vial.moveInto(Me);
    heart.moveInto(Me);
    return closeEdge;
  }
*/
;

mongrels: fixeditem
  sdesc = "mongrels and predators"
  noun = 'mongrels' 'predators'
  ldesc = "You try to look at them directly, but they never seem to be there. "
  location = alley
  dobjGen(a, v, i, p) = {
    "They are nowhere, yet here. ";
    exit;
  }
  iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

alleyItem: fixeditem
  sdesc = "alley"
  noun = 'alley'
  adesc = "an alley"
  ldesc = { alley.ldesc; }
  location = alley
  takedesc = "It's firmly attached. "
;

walls: fixeditem
  sdesc = "walls"
  noun = 'walls'
  adjective = 'brick'
  location = alley
  ldesc = "They are of brick construct. They would seem to form a shell for
          housing, but no windows allow sights within and no stairs allow travel within. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
  verDoClimb(actor) = { "The walls are too high. "; }
  verDoClimbover(actor) = { "The walls are too high. "; }
  verDoClimbup(actor) = { "The walls are too high. "; }
  isThem = true
;

wall: fixeditem
  sdesc = "alley wall"
  noun = 'wall'
  adjective = 'alley'
  location = alley
  ldesc = "Though dwarfed by the brick on either side of it, it still somehow
          seems taller and more imposing than anything on either side. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
  verDoClimb(actor) = { "The wall is too high. "; }
  verDoClimbover(actor) = { "The wall is too high. "; }
  verDoClimbup(actor) = { "The wall is too high. "; }
;

street: fixeditem, floatingItem
  sdesc = "street"
  noun = 'street'
  adjective = 'filthy'
  location = { if (Me.location.isOutside) return Me.location; }
  ldesc = "A sticky mess, to walk about it fills you with cold revulsion. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached to the planet. "
;

fog: fixeditem, floatingItem
  sdesc = "fog"
  noun = 'fog'
  adjective = 'thick'
  location = { if (Me.location.isOutside) return Me.location; }
  ldesc = "So thick...\ it continually swirls, you are unable to see through it
          to the street beyond. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> is not that thick. "
  verDoLookthru(actor) = { "It's too thick to see through. "; }
;

sky: decoration, floatingItem
  sdesc = "sky"
  noun = 'sky'
  adjective = 'overcast'
  location = { if (Me.location.isOutside) return Me.location; }
  ldesc = "An overcast sky tonight. "
;


moon: fixeditem, floatingItem, distantItem
  sdesc = "moon"
  location = { if (Me.location.isOutside) return Me.location; }
  noun = 'moon' 'lunar'
  ldesc = "There is no moon, seemingly no light source, with which to light your
          way tonight, child. "
  verDoJump(actor) = { "You're not a cow.  "; }
  takedesc = "You've got to jump over it first. "
;

alley2: room
  sdesc = "Alley"
  ldesc = {
    "Before you is the door to a home, a crumbling dwelling lost in the alley.
    The air here is thick, as if you are uncomfortably supporting it and
    propping it up. The glow of a gas streetlight throws flickery shadows upon
    the lone window of the slum apartment. The alleyway street is still quite
    sticky here, and each footstep concludes in release from an audible 'glop.'\b
    The alley continues into further fog to the west and east and to the north
    is the rotting apartment. ";
    if (!self.seen) {
      self.seen := true;
      self.count := 0;
      setdaemon(alleyTextDaemon,nil);
    }
  }
  smelldesc = "You are deep within the slaughterhouse district. You can trace scents of
              blood, butchery and decay. Bits of excrement and trash are smeared into
              the street, they mix to form an additional unpleasantry. "
  listendesc = {
    if (!alley3.seen) {
      "The occasional chirp of a nearby salesman can be heard to the west. ";
      alley3.skipChirp := true;
    }
    else
      "Eerie silence. ";
  }
  west = {
    "The alley opens into a thicker white fog.\b";
    return alley3;
  }
  north = { alleyHouse.doEnter(Me); } 
  east = alley
  in = (self.north)
  isOutside = true
  genericHint = true
;

alleyTextDaemon: function(parm)
{
  if (Me.location <> alley2) return;
  switch (alley2.count++) {
    case 0:
    case 3:
    case 6:
      if (!alley3.seen and !alley3.skipChirp)
        "\bThe occasional chirp of a nearby salesman can be heard to the west. ";
      if (alley2.count = 6) alley2.count := 3;           // enter here every third turn.
      break;
    case 1:
      "\bYou hear a cry from behind the door!\b
      A woman's voice, struggling:\ <q>O...\ Murder!</q>\b
      Further sounds of thrashing emote from within. You hear something wet and sticky
      strike the other side of the door and fall. ";
      break;
    case 2:
      fakeRat.moveInto(alley2);
      "\bA wiry, black rat wriggles its way out from underneath the door and scurries away
      to the alley to the west. ";
      break;
  }
}

alley2Item: fixeditem
  sdesc = "alley"
  noun = 'alley'
  adesc = "an alley"
  ldesc = { alley2.ldesc; }
  location = alley2
  takedesc = "It's firmly attached. "
;

streetLight: fixeditem
  sdesc = "gas streetlight"
  noun = 'streetlight' 'light'
  adjective = 'gas'
  location = alley2
  ldesc = "The streetlight throws flickery shadows upon the window. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
  verDoturnoff(actor) = { "You can't do that. "; }
  verDoturnon(actor) = { "The light is already on. "; }
  verDoClimb(actor) = { "You're too small in stature. "; }
  verDoClimbup(actor) = { "You're too small in stature. "; }
;

alleyHouse: fixeditem
  sdesc = "apartment"
  noun = 'apartment' 'house' 'home' 'dwelling' 'slum'
  location = alley2
  ldesc = "The apartment is rotting before you, its construction as poor as its likely tenants. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> far too heavy. "
  verDoBoard(actor) = {}
  doBoard(actor) = { self.doEnter(actor); }
  verDoEnter(actor) = {}
  doEnter(actor) = {
    if (!Me.small) {
      if (!potion.drank)
        "The door is locked. "; 
      else
        "There seems to be one way in, but you are too tall to fit. ";
    }
    else {
      "Being quite small in size, you run under the door and into the apartment...\b ";
      remdaemon(alleyTextDaemon,nil);
      Me.travelTo(apartment);
    }
  }
;

shattered: fixeditem
  sdesc = "bits of glass"
  noun = 'glass' 'beaker'
  adjective = 'bits' 'shattered'
  ldesc = "The shattered beaker is spread all over the ground. "
  takedesc = "The <<self.sdesc>> are too numerous to pick up. "
  isThem = true
;

theWindow: fixeditem
  noun = 'window' 
  adjective = 'large'
  sdesc = "window"
  ldesc = "It is covered in crusted filth from the opposite side. The window frame is painted
          shut, albeit with flaking and leaden paint. "
  location = alley2
  doSynonym('Lookin') = 'Lookthru'
  verDoLookin(actor) = { "Dark grime prevents you from seeing anything on the other
                         side of the window. "; }
  verDoOpen(actor) = { "There is no way to open it from this side. "; }
  verDoClose(actor) = { "The window is already closed. "; }
  verDoBreak(actor) = { " You lack the strength. "; }
  verDoKnock(actor) = { "You knock on the window. Eerie silence. "; }
  verDoAttack(actor) = { "You are too small in stature to do that. "; }
  takedesc = "Not possible. "
  verDoClean(actor) = { "It won't help -- the grime is permanent. "; }
  verDoWash(actor) = { "It won't help -- the grime is permanent. "; }
  
;

theDoor: lockableDoorway
  sdesc = "door"
  noun = 'door'
  adjective = 'withered'
  ldesc = "The door appears withered, yet is locked from within quite forcibly. \b
          A bit of light escapes from the door underneath. "
  location = alley2
  isopen = nil
  isListed = nil
  islocked = true
  verDoOpen(actor) = { "The door is locked. "; }
  verDoClose(actor) = { "The door is already closed. "; }
  verDoLock(actor) = { "The door is already locked. "; }
  verDoUnlock(actor) = { "There seems to be no key. "; }
  verDoKnock(actor) = { "You knock on the door.  Eerie silence. "; }
  verDoBreak(actor) = { "You lack the strength. "; }
  verDoAttack(actor) = { "It doesn't budge. "; }
  verDoLookunder(actor) = {
    "There is four inches of space in between the bottom edge of the door
    and the road. You peer as best you can into the apartment itself and
    see little, save for the motions of one in light footwear skirting
    around a positioned bed. ";
  }
;

fakeRat: fixeditem
  sdesc = "black rat"
  noun = 'rat'
  adjective = 'wiry' 'black'
  ldesc = "The rat has scurried far away by now. "
  dobjGen(a, v, i, p) = {
    "The rat has scurried far away by now. ";
    exit;
  }
  iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

alley3: room
  sdesc = "Alley"
  ldesc = {
    "You are at the western edge of what was once a filthy, urban
    alley. It has morphed into a quieter, nigh angelic scene. Thick
    clouds have touched down and billow endlessly, within continual
    waves defined by their own soft motion. The alleyway stretches
    away until it, seemingly hundreds of yards away, bubbles away
    into the night into an effervescent rise of environmental content. ";
    if (Me.size > 1 and !self.said) {    
      self.said := true;
      "\bJohn and his cart are no longer here. ";
    }
    if (!self.seen) {
      self.seen := true;
      setdaemon(johnTalkDaemon,nil);                   // two turns before John talks
    }
  }
  smelldesc = "You are deep within the slaughterhouse district. You can trace scents of
              blood, butchery and decay. Bits of excrement and trash are smeared into
              the street, they mix to form an additional unpleasantry. "
  listendesc = "Eerie silence. "
  noexit = "The only exit is east, back toward the rotting apartment. "
  east = {
    "The thick white fog dissipates and you wander back to...\b";
    return alley2;
  }
  isOutside = true
  genericHint = true
;

john: Actor
  sdesc = "man"
  noun = 'man' 'john' 'salesman'
  takedesc = "I don't think he would appreciate that. "
  isHim = true
  ldesc = "His inherent, learned honesty betrays any possibility of The Ruse. "
  location = alley3
  actorDesc = {
    "A man stands nearby, smiling vacantly, shifting his weight from foot to foot. ";
  }
  count = 0                             // used for daemon to trigger talk
  verDoSearch(actor) = { "<q>Hey!</q>\ he protests, moving away from you. "; }
  verDoHug(actor) = { "<q>What a sweet little girl.</q> "; }
  verDoKiss(actor) = { "<q>What a sweet little girl.</q> "; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = {
    if (v.isTravelVerb) {
      "<q>I'm not going anywhere right now.  I have to sell my wares.</q> ";
      exit;
    }
    switch(v) {
      case noVerb:
      case yesVerb:
      case helloVerb:
        break;
      case wearVerb:
        "<q>I'm comfortable with what I'm already wearing.</q> ";
        exit;
      default:
        "<q>That's not likely, now is it?</q>\ says the man. ";
        exit;
    }
  }  
  verDoTellAbout(actor, io) = { self.verDoAskAbout(actor, io); }
  doTellAbout(actor, io) = { 
    "You wonder what he has to say instead, so you ask him about it.\b";
    self.doAskAbout(actor, io); 
  }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = ""
  dontKnow = {
    local msg := [
      '<q>I don\'t know much about that,</q> says '
      '<q>I don\'t really know,</q> states '
      '<q>You probably know as much as I do,</q> quips '
      '<q>Were you talking to me?</q>\ questions '
      '<q>Sorry, not my area of expertise,</q> exclaims '
      '<q>Um... Did you say something?</q>\ asks '
      'A shrug is all you get from '
    ];
    say(msg[rand(length(msg))]);
  }
  askWord(word, lst) = {
    switch(substr(word, 1, 7)) {
      case 'me':
      case 'myself':
        "<q>You look delightful,</q> says John. ";
        break;
      case 'quota':
        "<q>Hum, indeed,</q> he says adding simple math inside his head. <q>I have
        but one more ware to sell tonight!</q> ";
        return true;
        break;
      case 'purchas':
      case 'ware':
      case 'wares':
      case 'liquid':
      case 'beaker':
        "<q>They are quite delightful,</q> says John. 
        <q>Not much call for them nowadays, though. Oh, well.</q> ";
        return true;
        break;
      case 'alley':
        "<q>I try not to think about the alley,</q> says John. <q>Then again, wouldn't you?</q> ";
        return true;
        break;
      case 'apartme':
      case 'house':
      case 'home':
      case 'slum':
      case 'door':
        "<q>Always such a bother coming from in there!</q> ";
        return true;
        break;
      case 'ruse':
        "He just grins. ";
        return true;
        break;
      case 'potion':
        "<q>Something wonderful is sure to happen, usually your prayers will be answered
        in kind.  Just be certain of your intentions and faith, for if you react with a
        curse or a whine, these wares of mine are liable...\ to get all mixed up!</q> ";
        return true;
        break;
      default:
        dontKnow; "John. ";
        return nil;
      }
  }
  doAskAbout(actor, iobj) = {
    switch(iobj) {
      case himself:
        "<q>Me? My name is John. I just sell wares.</q> ";
        break;
      default:
        /* we didn't find anything special; use the default behavior */
        inherited.doAskAbout(actor, iobj);
    }
  }
  doHello = { 
    if (!self.helloSaid) {
      "<q>Hello, little one,</q> he says. <q>My name is John.</q> ";
      john.helloSaid := true;
      remdaemon(johnTalkDaemon, nil);
    }
    else
      "John smiles at you, probably wondering why you insist on repeating a greeting. ";
  }
  verDoTurnon(actor) = { "I'm sure you can think of something else to do, no? 
                         Besides, why would you want to alienate <<self.sdesc>>. "; }
  verDoAttack(actor) = { }
  doAttack(actor) = { "John poses no threat. "; }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doListenTo(actor) = { "\^<<self.sdesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = { "John politely refuses your offer. "; }
  verDoTalkTo(actor) = {}
  doTalkTo(actor) = { 
    if (!self.helloSaid) {
      "<q>Hello, little one,</q> he says. <q>My name is John.</q> ";
      john.helloSaid := true;
      remdaemon(johnTalkDaemon, nil);
    }
    else if (!ware.purchased) {
      if (!self.wareSaid) {
        self.wareSaid := true;
        "<q>I have many wares to peddle, still, little one. Perhaps there will
        be time for chatting after I have met my quota. </q> ";
      }
      else
        "<q>I have many wares to peddle, still, little one. Perhaps there will
        be time for chatting after I have met my quota. </q>\bJohn mumbles something
        about just one more purchase tonight... ";
    }      
    else
      "<q>Thank you for your business, oh precious one!</q> ";
  }
;

ruse: item
  noun = 'ruse' 'purchase'
;

johnTalkDaemon: function(parm)
{
  if (Me.location <> alley3) return;
  if (john.count++ = 1) {
    if (!ware.purchased)
      "\b<q>Hello, little one,</q> he says. <q>My name is John.</q> ";
    john.helloSaid := true;
    remdaemon(johnTalkDaemon, nil);
  }     
}     

ware: fixeditem
  sdesc = "ware"
  noun = 'ware' 'wares' 'beaker' 'liquid' 'potion' 'quota'
  adjective = 'ultraviolet'
  location = cart
  ldesc = "There is a single beaker sitting upon a wooden cart. An ultraviolet
          liquid fills about half of the beaker. "
  verDoTake(actor) = {}
  doTake(actor) = { self.doDrink(actor); }
  verDoDrink(actor) = {}
  doDrink(actor) = {
    if (!self.drink) {
      self.drink := true;
      "<q>Now, now, little one,</q> says John. <q>I have but one more beaker of
      faith to distribute tonight! I can't have you drinking it on me!
      That certainly wouldn't be right.</q> ";
    }
    else
      "<q>Well, maybe you can have it, if your credit is good...</q>\ muses John, mostly to himself. ";
  }
  verDoBuy(actor) = {}
  doBuy(actor) = {
    "John bends his brittle frame over, to speak to you eye-to-eye.\b
    <q>Do you know what this is? What's contained within? Alright. I'll tell
    you. But where to begin? I can see you have no coin or copper, but
    I'll presume your credit's good. It can be our little secret, if we 
    like, and I definitely suspect, even...\ that we <i>should.</i></q>\b
    John brings down the potion and hands it to you.\b
    <q>Something wonderful is sure to happen, usually your prayers will be
    answered in kind. Just be certain of your intentions and faith, for 
    if you react with a curse or a whine, these wares of mine are 
    liable...\ to get all <i>mixed up!</i></q> ";
    self.moveInto(nil);
    potion.moveInto(Me);
    self.purchased := true;
  }
;

prayCurseDaemon: function(parm)
{
  if (ware.hintCnt++ = 8) {
    remdaemon(prayCurseDaemon, nil);
    if (Me.location <> alley3)
      "\bAs you wander around the alley, you ";
    else
      "\bYou ";
    "reflect back to what John had to say about the potion...\b
    <q>Something wonderful is sure to happen, usually your <i>prayers</i> will be
    answered in kind. Just be certain of your intentions and faith, for 
    if you react with a <i>curse</i> or a whine, these wares of mine are 
    liable...\ to get all <i>mixed up!</i></q> ";
  }
}

cart: fixeditem
  sdesc = "wooden cart"
  noun = 'cart'
  adjective = 'wooden'
  location = alley3
  ldesc = "The wooden cart is silent, and quite broken down. It's what John uses to peddle his wares. "
  takedesc = "<q>Believe me, you're better off without it, little one,</q> says John. 
             <q>Consider that professional counseling.</q> "
;

potion: item
  sdesc = "potion"
  noun = 'potion' 'beaker'
  adjective = 'purple'
  ldesc = "The potion looks quite pure, no suspended particles of any kind.\b It is purple. "
  verDoDrop(actor) = {"You need it. ";}
  doThrowOut(actor, io) = { self.doThrowAt(actor, io); }
  doThrowThru(actor, io) = { self.doThrowAt(actor, io); }
  doThrowAt(actor, io) = { "You really shouldn't do that. "; }
  verDoDrink(actor) = {}
  doDrink(actor) = {
    "Gulp! ";
    self.moveInto(nil);
    beaker.moveInto(Me);
    self.drank := true;
    ware.hintCnt := 0;
    setdaemon(prayCurseDaemon, nil);
  }
;

beaker: item
  sdesc = "beaker"
  noun = 'beaker'
  ldesc = "The beaker is empty. "
  verDoDrink(actor) = { self.ldesc; }
  doTake(actor) = {
    if (Me.size > 2)
      "It's too heavy. ";
    else
      inherited.doTake(actor);
  }
;

apartment: room
  sdesc = "Apartment"
  ldesc = {
    "You are within a cramped apartment, no greater than 12 feet square.  
    Directly across from the front door is a fireplace, full of deep
    soot and organs. To your right is a compact board table, adjacent
    to a bed propped approximately one foot high by a secondary, mildewey mattress. ";
    if (!self.seen) {
      self.seen := true;
      "\bA human-sized, upright Hare breaks from ripping the intestines of a 
      bound, human woman and carefully peers at your entrance.  \b
      The woman moans -- a strained wail -- her head slumped over and eyes appearing dead. ";
      setdaemon(hareDaemon,nil);                   // two turns before John talks
    }
    else {
      if (hare.location = apartment)
        "\bThere is a hare here, ripping open a prostitute. ";
      "\nThere is a prostitute here, tied up, shredded and destitute. ";
    }
  }
  noexit = { "Something changed! That way no longer seems possible! "; }
  in = { fireplaceItem.doBoard(Me); }
  genericHint = true
;
   
organs: fixeditem, floatingItem
  sdesc = "organs"
  noun = 'organs' 'organ'
  location = { if (Me.location = apartment or Me.location = fireplace) return Me.location; }
  ldesc = "Ruptured, leaking, and disgusting! "
  takedesc = "You try, but they are not remotely whole, and slip out of your hands. "
  isThem = true
;

apartmentDoor: fixeditem
  sdesc = "door"
  noun = 'door'
  location = apartment
  ldesc = "The <<self.sdesc>> has been absorbed by the wall and is no longer a functioning door. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> now part of the wall. "
;

apartmentItem: fixeditem
  sdesc = "Apartment"
  noun = 'apartment'
  ldesc = { apartment.ldesc; }
  location = apartment
  takedesc = "No chance. "
;

fireplace: room
  sdesc = "Apartment, in the fireplace"
  ldesc = "The fireplace is filled with organs, sweat, blood and soot. Looking
          up, it appears to get lighter at the other end, not darker. "
  out = apartment
  up = { "You are not tall enough. "; }
;

fireplaceItem2: fixeditem
  sdesc = "fireplace"
  noun = 'fireplace'
  location = fireplace
  ldesc = "The fireplace is filled with organs, sweat, blood and soot. Looking
          up, it appears to get lighter at the other end, not darker. "
  verDoEnter(actor) = { self.verDoBoard(actor); }
  doEnter(actor) = { self.doBoard(actor); }
  verDoBoard(actor) = {}
  doBoard(actor) = {
    "You are not tall enough. ";
  }
  verDoUnboard(actor) = {}
  doUnboard(actor) = {
    "You exit the fireplace.\b";
    actor.travelTo(apartment);
  }
  
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
;

fireplaceItem: fixeditem
  sdesc = "fireplace"
  noun = 'fireplace'
  location = apartment
  ldesc = "The fireplace is filled with organs, sweat, blood and soot. Looking
          within it, it appears to get lighter at the other end, not darker. "
  verDoEnter(actor) = { self.verDoBoard(actor); }
  doEnter(actor) = { self.doBoard(actor); }
  verDoBoard(actor) = {}
  doBoard(actor) = {
    if (!hare.entered)
      "The Hare kicks you away from the fireplace! ";
    else {
      "You make your way into the <<self.sdesc>>.\b ";
      actor.travelTo(fireplace);
      
    }
  }
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
;

hare: Actor
  sdesc = "Hare"
  noun = 'hare' 'rabbit'
  takedesc = "I don't think he would appreciate that. "
  isHim = true
  ldesc = "He is wearing a glossy top hat, a mirrored monocle over his left eye, and a 
          swashbuckler's vest. His nose twitches irregularly, as if a symptom of a spastic, 
          involuntary syndrome. His white fur is stained crimson in splashes, where the 
          woman's blood and flesh has splattered and soaked into it. "
  location = apartment
  actorDesc = nil
  count = 0                             // used for daemon to trigger action
  verDoSearch(actor) = { "<q>Hey!</q>\ he protests, moving away from you. "; }
  verDoHug(actor) = {"The Hare snickers deeply at such a thought. "; }
  verDoKiss(actor) = {"The Hare despises your affection. "; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = {
    if (v.isTravelVerb) {
      "<q>I'm not going anywhere right now.</q> ";
      exit;
    }
    switch(v) {
      case noVerb:
      case yesVerb:
      case helloVerb:
        break;
        exit;
      case saveVerb:
        "But the Hare thinks he <i>is.</i> ";
        abort;
        break;
        exit;
      default:
        "<q>The Hare refuses. </q> ";
        exit;
    }
  }  
  verDoTellAbout(actor, io) = { self.verDoAskAbout(actor, io); }
  doTellAbout(actor, io) = { 
    "You wonder what it has to say instead, so you ask him about it.\b";
    self.doAskAbout(actor, io); 
  }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = ""
  askWord(word, lst) = {
    switch(substr(word, 1, 7)) {
      case 'me':
      case 'myself':
        "The Hare smiles momentarily, yet cruelly. ";
        break;
      case 'woman':
      case 'lady':
        "The Hare offers no opinion to you about the woman. ";
        return true;
        break;
      case 'alley':
        "The Hare pauses momentarily, but offers no reply. ";
        return true;
        break;
      case 'apartme':
      case 'house':
      case 'home':
      case 'slum':
      case 'door':
        "The Hare responds by throwing a chunk of the woman's flesh on the walls of the apartment. ";
        return true;
        break;
      case 'firepla':
        "The Hare slams the prostitute's head into the wall in response to your query! ";
        return true;
        break;
      case 'juewess':
      case 'juwess':
        "The Hare stares intently at you and doesn't say a word. ";
        return true;
        break;
      default:
        "The hare doesn't respond. ";
        return nil;
      }
  }
  doAskAbout(actor, iobj) = {
    switch(iobj) {
      case himself:
        "The Hare laughs and continues splashing flesh. ";
        break;
      default:
        /* we didn't find anything special; use the default behavior */
        inherited.doAskAbout(actor, iobj);
    }
  }
  doHello = { "The Hare twitches his nose. "; }
  verDoTurnon(actor) = { "I'm sure you can think of something else to do, no? 
                         Besides, why would you want to alienate <<self.sdesc>>. "; }
  verDoAttack(actor) = { }
  doAttack(actor) = { "You are much too small and insignificant to hurt the Hare. "; }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doListenTo(actor) = { "\^<<self.sdesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = { "The Hare ignores you. "; }
  verDoTalkTo(actor) = {}
  doTalkTo(actor) = { 
    if (!self.talked) {
      self.talked := true;
      "The Hare speaks with a guttural masque of cockney. \b
      <q>Not again, they'll never catch me. Not the juewess, not ever!</q> ";
    }
    else
      "The Hare twitches his nose and says nothing. ";
  }
;

hareTopic: item
  sdesc = "juwess"
  noun = 'juwess' 'juewess'
;

monocle: fixeditem
  sdesc = "monocle"
  noun = 'monocle' 'eyewear'
  location = hare
  ldesc = "It is a mirrored bit of eyewear that the Hare possesses. "
  takedesc = "The Hare won't let you have it. "
;

vest: fixeditem
  sdesc = "vest"
  noun = 'vest'
  location = hare
  ldesc = "The Hare looks quite good in it. "
  takedesc = "The Hare won't let you have it. "
;

tophat: fixeditem
  sdesc = "top hat"
  noun = 'hat'
  adjective = 'top'
  location = hare
  ldesc = "It compliments the Hare nicely. "
  takedesc = "The Hare won't let you have it. "
;

fur: fixeditem
  sdesc = "fur"
  noun = 'fur'
  location = hare
  ldesc = "The fur is mostly a cream white, although some bits of it are covered in the deep crimson
          splash of prostitute haemoglobin. "
  takedesc = "The Hare won't let you have it. "
;

woman: Actor
  sdesc = "woman"
  noun = 'woman' 'lady' 'prostitute' 'mary' 'kelly'
  takedesc = "The chains hold her tight. "
  isHim = nil
  isHer = true
  ldesc = "She is a wisp of a woman, approximately 5'7\" and slight of build. She
          is laying in tattered clothes on a stinking mattress, her hands and 
          left leg bound to the apartment walls with thick chain. She has been
          viciously ripped from just below her neck straight down toward her
          pelvis, Her internal organs are scattered about her gaping chest cavity,
          although some have leaked over to the bed and others smear the walls, 
          slowly crawling down to the floor. Her long blonde hair is matted with
          blood and pulp into the sheets upon her bed, and she seems unable
          to focus, articulate her horror, or die. "
  location = apartment
  actorDesc = nil
  count = 0                             // used for daemon to trigger action
  verDoHug(actor) = { "There is not much left to hug! "; }
  verDoKiss(actor) = { "You attempt to, but cannot identify where her lips are."; }
  actorAction(v, d, p, i) = {
    "She is dead. ";
    exit;
  }  
  verDoTouch(actor) = { "You decide to leave her be. "; }
  verDoHelp(actor) = { "It's too late for help. "; }
  verDoTellAbout(actor, io) = { "She is dead. "; }
  doTellAbout(actor, io) = { self.doAskAbout(actor, io); }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = "She is dead. "
  doHello = { "She is dead. "; }
  verDoAttack(actor) = { }
  doAttack(actor) = { "She is dead. "; }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doListenTo(actor) = { "\^<<self.sdesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = { "She is dead. "; }
  verDoTalkTo(actor) = {"She is dead. ";}
;

hareDaemon: function(parm)
{
  if (hare.count > 0) "\b";
  switch(hare.count++) {
    case 1:
      "The hare rips away a purplish, engorged organ and some fleshy, meaty 
      sections of the woman's stomach. He hurls these parts at the left 
      wall, splashing her blood everywhere and he does so with meticulous
      strain and patience.\b
      The woman cries forth with cursing, swearing, and explicatives that you
      have never, ever heard before in your life. ";
      curseVerb.growOK := true;
      break;
    case 2:
      "The Hare snaps off a piece of intestine and throws it at you!\b
      The intestine shifts into an ugly garden snake mid-flight, and 
      snares itself around your neck!\b
      The woman's eyes close, a terrible wheeze of air leaves her esophagus. ";
      snake.moveInto(Me);
      snake.chatCnt := 0;
      setdaemon(snakeChatDaemon,nil);
      break;
    case 3:
      "The Hare snaps the neck of the woman. ";
      break;
    case 4:
      "The Hare squats down and enters the fireplace. It leaps once,
      and appears to have left the apartment completely. ";
      hare.entered := true;
      hare.moveInto(nil);
      break;
    case 5:
      "<q>Sing another song for me, sweetie, and I shall certainly return myself
      to sleep and slumber,</q> says the snake. ";
      remdaemon(hareDaemon,nil);
  }
}
;

snakeChatDaemon: function(parm)
{
  switch(snake.chatCnt++) {
    case 12:
      "\bThe snake flashes briefly animate for a moment to tighten its grip. <q>Snug, isn't 
      it, my lovely?</q> he whispers before quieting once again. ";
      break;
    case 32:
      "\bThe snake tightens its grip around your neck once more. <q>Not too tight just 
      yet, I hope,</q> he mutters.  The snake returns, quickly, to its pseudo-slumber. ";
      break;
    case 60:
      "\bYou choke, suddenly! The snake arises for mere moments, to simply increase the pressure around your neck. ";
      break;
    case 95:
      "\b<q>I think,</q> says the snake, <q>that I'd like to play a quick game. I'll swallow my own 
      tail!</q> The snake gets tighter around your neck, but makes a show of failing to bite its 
      end. <q>Oh, sorry, my lovely. I'll just have to get closer, later!</q>\b
      The snake returns to its sleep once more. ";
      break;
    case 133:
      "\bThe snake flashes to awareness again. <q>I feel so close to you,</q> it whispers, <q>but I 
      could feel a little closer, as well...</q>\ right before falling back into its slumber 
      it again tightens its grip. ";
      break;
    case 196:
      Me.winnable := nil;  // five turns left before you die -- close enough, I guess... 
    case 201:
      "\bThe snake flashes awake once more. It slowly licks the side of one of your ears.\b
      <q>One of us, my love,</q> it hisses, <q>has run out of time. And one of us has
      all the time that is left...</q> The snake quickly stabs twin fangs into your
      cheek and injects a salivatory paralysis into you...\ it squeezes, beyond
      what you could have ever expected from it, and you pass out, falling for
      the final time... ";
      die();
      break;
  }
}

//Song is with you all the time.
song: fixeditem, floatingItem
  sdesc = "song"
  noun = 'song'
  location = { return Me.location; }
  ldesc = "I don't understand what you're trying to accomplish. "
  verDoSingTo(actor) = {
    if (snake.isIn(Me)) 
      "You begin to sing but the snake just tightens its grip. ";
    else
      "You hum softly to yourself. ";
  }
  dobjGen(a, v, i, p) = {
    if (v <> singToVerb) {
      "I don't understand that sentence. ";
      exit;
    }
  }
  iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

snake: item
  sdesc = "snake"
  noun = 'snake'
  adesc = "a snake (wrapped around your neck)"
  ldesc = "The snake chortles deeply and tightens itself slightly around your neck. 
          Though as small as yourself, it frustrates all attempts at discovery, 
          exploration, and conversation. "
  verDoCut(actor) = { 
    if (!knife.isIn(Me) and (!sword.isIn(Me)))
      "You have nothing sharp enough to cut the snake with. ";
  }
  doCut(actor) = { 
    if (knife.isIn(Me)) {
      "(with the killing knife)\n";
      knife.ioCutWith(actor, self); 
    }
    else {
      "(with the sword)\n";
      "The blade of the sword is not sharp enough to cut the snake. ";
    }
  }
  verDoAttack(actor) = {
    if (!knife.isIn(Me) and (!sword.isIn(Me)))
      "You have nothing sharp enough to kill the snake with. ";
  }
  doAttack(actor) = { self.doCut(actor); }
  verDoAttackWith(actor, iobj) = {}
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  verDoDrop(actor) = { "The snake is wrapped too tightly. "; }
  verDoPull(actor) = { "You're afraid it will just make it tighter. "; }
  verDoTear(actor) = { "You lack the strength. "; }
  verDoTalkTo(actor) = { "It ignores you. "; }
  verDoSingTo(actor) = { "The snake flashes animate once more, and begins to join your song. In between 
                         slurred humming, he says, <q>I understand, you know, your clever, clever ruse. 
                         Really! I do! But, my love, I am no savage beast to be beaten with a song. I feel 
                         our love can't quite continue like this for very long. For I am your special friend 
                         this eve, and I am very, <i>very</i> wrong.</q> "; }
  verDoAskAbout(actor, io) = { "The snake just hisses... "; }
  verDoTake(actor) = { "The snake would never dream of letting you do such a thing. "; }
  verIoShowTo(actor) = {}
  ioShowTo(actor, dobj) = { 
    if (dobj = knife)
      "Somehow -- though it is quite physically impossible -- the snake gulps. ";
    else
      "The snake isn't impressed. ";
  }
;

table: fixeditem
  sdesc = "compact board table"
  noun = 'table'
  adjective = 'compact' 'board'
  location = apartment
  ldesc = "The compact board table is quite small and covered in dried blood. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
;

bedApartment: fixeditem
  sdesc = "bed"
  noun = 'bed'
  location = apartment
  ldesc = "The body of a slain woman is on the bed. "
  verDoEnter(actor) = { self.verDoBoard(actor); }
  verDoBoard(actor) = { "The bed is full. "; }    
  verDoLookunder(actor) = { "There's nothing hiding under the bed. "; }
;

mattress: fixeditem
  sdesc = "mattress"
  noun = 'mattress'
  adjective = 'mildewey'
  location = bedApartment
  ldesc = "The <<self.sdesc>> <<self.isntdesc>> important. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
  verDoEnter(actor) = { self.verDoBoard(actor); }
  verDoBoard(actor) = { bedApartment.verDoBoard(actor); }
  verDoLookunder(actor) = { if (self.looked) "Nothing. "; }
  doLookunder(actor) = {
    self.looked := true;
    "A vintage 1958 issue of Playboy!\b [Author's note:\ I'm tired and needed a memisis
    break from coding.  I now return you to your regularly scheduled IF programming.] "; 
  }
;

chains: fixeditem
  sdesc = "chains"
  noun = 'chains' 'chain'
  location = apartment
  ldesc = "The chains are thick, and hold the woman tight. "
  takedesc = "The chains are securely attached to the wall. "
  verDoPull(actor) = { "The chains are securely attached to the wall. "; }
  isThem = true
;

wallsApartment: fixeditem
  sdesc = "walls"
  noun = 'walls' 'wall'
  location = apartment
  ldesc = "The walls all covered in frescoes of blood, and spilled trails of organs. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached to the apartment. "
  isThem = true
;

blood: fixeditem
  sdesc = "blood"
  noun = 'blood'
  location = apartment
  ldesc = "It's everywhere. "
  takedesc = "What a concept! "
;

study: room
  sdesc = "Study"
  ldesc = {
    "This is a long, open drawing room evidently used for study and soft research.
    A rich, teak desk sits in solitude, equidistant from the west wall (upon
    which hangs a set of somber oil paintings) and the east wall";
    if (stainGlass.location = self)
      " (almost completely defined by stained glass). ";
    else
      ". ";
    "Near the desk is Rumford fireplace, the same portal from which you arrived. Toward the far wall 
    is an ornament stand, and wire stairs that lead up to an in-house second level and black door. ";
  }
  up = { climbUpStairs(); }
  in = { "Trying to go back into the fireplace? "; }
  genericHint = true
;

blackDoorDistant: distantItem
  sdesc = "black door"
  noun = 'door'
  adjective = 'black'
  location = study
  isopen = nil
  ldesc = {
    "It is black. ";
    if (self.isopen)
      "It is open. ";
    else
      "It is shut. ";
  }
;

studyFireplace: fixeditem
  sdesc = "Rumford fireplace"
  noun = 'fireplace'
  adjective = 'rumford'
  location = study
  ldesc = "The Rumford fireplaces is tall and shallow, which probably allows it to reflect 
          more heat.  Odd, the portal is no longer there. "
  verDoEnter(actor) = { "That's not possible. "; }
  verDoBoard(actor) = { "That's not possible. "; }
  verDoLookin(actor) = { "You don't see anything in it. "; }
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached to the wall. "
;

studyItem: fixeditem
  sdesc = "study"
  noun = 'study'
  ldesc = { study.ldesc; }
  location = study
  takedesc = "It's firmly attached to the rest of the house. "
;

deskItem: fixeditem
  sdesc = "teak desk"
  noun = 'desk'
  adjective = 'teak'
  location = study
  ldesc = "Of an expensive, expansive proportion...\ it takes up nearly the length of an entire wall.\b
          Upon the desk is some papers. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> too heavy. "
;

papers: fixeditem
  sdesc = "papers"
  noun = 'papers' 'paper'
  location = deskItem
  ldesc = "They are written in script, which you cannot read. The letters are arranged in
          flowery, careful craftsmanship. "
  takedesc = "You pick up the papers and try to decipher their meaning.  You give up and
             put them back on the desk. "
  verDoRead(actor) = { self.ldesc; }
  isThem = true
;              

battleStand: fixeditem
  sdesc = "ornament stand"
  noun = 'stand'
  adjective = 'ornament'
  location = study
  ldesc = "The ornament stand is right before a door that leads, presumably, outside. It has two
          legs, sits two feet high and two feet across. The tabletop has been buffed
          and polished to a satiny sheen. \b On the ornament stand is a battle scene. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> too heavy. "
;

battleScene: fixeditem
  sdesc = "battle scene"
  noun = 'scene'
  adjective = 'battle'
  location = battleStand
  ldesc = {
    "A tiny, yet exquisitely detailed figurine made up of several different 
    autonomous pieces that, together, depicts a swordsman";
    if (!sword.missing) 
      " brandishing a steel blade against several cornered beasties. ";
    else
      ".  His sword is missing. ";
  }
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached to the tabletop, though the
             sword on the figurine looks detachable. "
;

swordsman: fixeditem
  sdesc = "swordsman"
  noun = 'swordsman' 'figurine'
  location = battleScene
  ldesc = {
    if (!sword.missing)
      "His sword is raised high, it seems as if merely displaying it is enough
      to give such magnificent, yet foul creatures pause. ";
    else
      "He is missing his sword. ";
  }
  takedesc = "The <<self.sdesc>> <<self.isdesc>> is firmly attached to the battle scene. "
;

sword: item
  sdesc = "sword"
  noun = 'sword' 'blade'
  location = swordsman
  size = 3
  ldesc = {
    if (!sword.missing) 
      "It is about the length of the swordsman's torso. The sword would appear to be detachable. ";
    else {
      switch (self.size) {
        case 1:
          "The sword is tiny. ";
          break;
        case 2:
          "The sword is very small. ";
          break;
        case 3:
          "The sword is small in size. ";
          break;
        case 4:
          "The sword is average in size. ";
          break;
        case 5:
          "The sword is large. ";
          break;
        case 6:
          "The sword is very large. ";
          break;
      }
    }
  }
  verDoSwing(actor) = { "You take a swing with the sword -- it has a nice balance, indeed! "; }
  doSynonym('Take') = 'Detach'
  isListed = nil
  doTake(actor) = {
    if (Me.size > 2 and self.size > 4) {
      "The sword is too heavy for you to pick up. ";
      return nil;
    }
    inherited.doTake(actor);
    if (!self.isListed) {
      self.isListed := true;
      self.missing := true;
      "\bIt is terribly small. ";
    }
  }
  verIoAttackWith(actor) = {
    if (!self.isIn(Me))
      if (Me.size > 2 and self.size > 4)
        "You reach down and try to pick up the sword, but it's too heavy. ";
  }
  ioAttackWith(actor, dobj) = {
    if (!self.isIn(Me)) {
      "You reach down and grab the sword.\b ";
      self.moveInto(Me);
    }     
    if (dobj = jabberwock) {
      if (Me.size > 0)
        "You are too small in size to cause any damage. ";
      else if (self.size < 5)
        "The sword is too small and does no damage. ";
      else {
        "You unleash the sword in a quick, wide arc, ripping through its
        stinking flesh with an audible 'snicker-snack!' Its eyes convulse
        and burn away as it settles into a heap of seared entrails besides
        a gawking maw. ";
        jabberwock.moveInto(nil);
        deadJabberwock.moveInto(Me.location);
        remdaemon(jabberwockDaemon, nil);
      }
    }
    else if (dobj = snake)
      "Seeing as the snake is wrapped tighly around your neck, you decide that wouldn't be a good idea. ";
    else
      "There's no reason to attack the <<dobj.thedesc>>. ";
  }
  verIoCutWith(actor) = { self.verIoAttackWith(actor); }
  ioCutWith(actor, dobj) = { 
    if (!self.isIn(Me)) {
      "You reach down and grab the sword.\b ";
      self.moveInto(Me);
    }     
    if (dobj = jabberwock) {
      if (Me.size > 0)
        "You are too small in size to cause any damage. ";
      else if (self.size < 5)
        "The sword is too small and does no damage. ";
      else {
        "You unleash the sword in a quick, wide arc, ripping through its
        stinking flesh with an audible 'snicker-snack!' Its eyes convulse
        and burn away as it settles into a heap of seared entrails besides
        a gawking maw. ";
        jabberwock.moveInto(nil);
        deadJabberwock.moveInto(Me.location);
        remdaemon(jabberwockDaemon, nil);
        Me.winnable := true;  // force flag to be in sync... Damn Lone Cleric!  :)
      }
    }
    else if (dobj = snake)
      "The blade of the sword is not sharp enough to cut the snake. ";
    else
      "There's no reason to cut the <<dobj.thedesc>>. ";
  }
;

oilPainting: fixeditem
  sdesc = "oil paintings"
  noun = 'paintings' 'painting'
  adjective = 'oil'
  location = study
  ldesc = "The paintings depict a magical beast of hushed tones and great wonder. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached to the wall. "
  verDoLookbehind(actor) = { "You cannot -- they are firmly attached to the wall. "; }
  isThem = true
;

stainGlass: fixeditem
  noun = 'glass' 
  adjective = 'stained'
  sdesc = "stained glass"
  ldesc = "Everything seems much larger while looking through the glass. "
  location = study
  doSynonym('Lookin') = 'Lookthru'
  verDoLookin(actor) = { "Everything seems much larger while looking through the glass. "; }
  verDoOpen(actor) = { "It's not that kind of glass. "; }
  verDoClose(actor) = { "It's not that kind of glass. "; }
  verDoBreak(actor) = {}
  doBreak(actor) = { 
    "You shatter the glass into thousands of tiny fragments. "; 
    self.moveInto(nil);
  }
  verDoKnock(actor) = { "You don't hear a thing..."; }
  verDoAttack(actor) = { "You are too small in stature to do that. "; }
  takedesc = "Not possible. "
;

terraceStairs: fixeditem
  sdesc = "stairs"
  noun = 'stairs' 'steps' 'step'
  ldesc = "The stairs descend toward darkness. "
  location = terrace
  verDoClimb(actor) = {}
  doClimb(actor) = { climbDownStairs(); }
  verDoClimbdown(actor) = {}
  doClimbdown(actor) = { climbDownStairs(); }
  verDoStep(actor) = {}
  doStep(actor) = { climbDownStairs(); }
  verDoStepOn(actor) = {}
  doStepOn(actor) = { climbDownStairs(); }
  isThem = true
;    

studyStairs: fixeditem
  sdesc = "stairs"
  noun = 'stairs' 'steps' 'step'
  ldesc = "The stairs ascend toward a small terrace above.  "
  location = study
  verDoClimb(actor) = {}
  doClimb(actor) = { climbUpStairs(); }
  verDoClimbdown(actor) = {}
  doClimbdown(actor) = { climbUpStairs(); }
  verDoStep(actor) = {}
  doStep(actor) = { climbUpStairs(); }
  verDoStepOn(actor) = {}
  doStepOn(actor) = { climbUpStairs(); }
  isThem = true
;    

climbDownStairs: function
  {
    "You descend the stairs carefully.\b ";
    Me.moveInto(study);
    if (global.verbose)
      Me.location.lookAround(true);
    else
      "<b><<Me.location.sdesc>></b>";
  }
;     

climbUpStairs: function
  {
    if (jabberwock.location = study) {
      "The jabberwock is blocking your path. ";
      return;
    }
    "You slowly ascend the stairs.\b ";
    Me.moveInto(terrace);
    if (!Me.location.isseen) {
      Me.location.lookAround(true);
      Me.location.isseen := true;
    }
    else if (global.verbose)
      Me.location.lookAround(true);
    else
      "<b><<Me.location.sdesc>></b>";
  }
;     

terrace: room
  sdesc = "Terrace"
  ldesc = "This platform looks over the study below. Before you, to the west, is a black door. "
  in = {
    if (blackDoor.isopen) 
      blackDoor.doBoard(Me);
    else {
      "(opening the door first)\n";
      if (!blackDoor.seen) {
        blackDoor.doOpen(Me);
        "The beast now blocks your path. ";
      }
      else
        blackDoor.doBoard(Me);
    }
  }
  west = (self.in)
  down = { climbDownStairs(); }
  genericHint = true
;

terraceItem: fixeditem
  sdesc = "Terrace"
  noun = 'terrace'
  ldesc = { terrace.ldesc; }
  location = terrace
  takedesc = "It's firmly attached. "
;

terraceStudy: fixeditem
  sdesc = "Study"
  noun = 'study'
  ldesc = "It's a long, open drawing room evidently used for study and soft research. "
  location = terrace
  verDoEnter(actor) = {}
  doEnter(actor) = { self.doBoard(actor); }
  verDoBoard(actor) = {}
  doBoard(actor) = { climbDownStairs(); }
;

blackDoor: fixeditem
  sdesc = "black door"
  noun = 'door'
  adjective = 'black'
  location = terrace
  isopen = nil
  ldesc = {
    "It is black. ";
    if (self.isopen)
      "It is open. ";
    else
      "It is shut. ";
  }
  verDoOpen(actor) = { if (self.isopen) "The door is already open. "; }
  doOpen(actor) = {
    self.isopen := true;
    if (!self.seen) {
      self.seen := true;
      "Fog, of makeup you have seen before, spills out from the locale
      beyond and into yours. A slavering roar splits your eardrums --
      a terrible gyre and gimble that nearly knocks you down! \b
      Emerging from the clouded beyond is a single monstrosity, a
      grotesque jabberwock with jaws that bite and claws that
      catch! Its beady, squinty eyes ooze thick pus as it contorts
      its vision in order to find you. ";
      jabberwock.moveInto(terrace);
      setdaemon(jabberwockDaemon, nil);
// Not enough time to slay the beast.      
      if (sword.size < 5)
        Me.winnable := nil;
    }
    else
      "Done. ";
  }
  verDoClose(actor) = { if (!self.isopen) "The door is already closed. "; }
  doClose(actor) = { "It doesn't budge. "; }
  verDoEnter(actor) = { self.verDoBoard(actor); }
  doEnter(actor) = { self.doBoard(actor); }
  verDoBoard(actor) = { if (!self.isopen) "The door is shut. "; }
  doBoard(actor) = {
    if (jabberwock.location = Me.location)
      "The jabberwock blocks your path. ";
    else {
      local itemRem, thisItem;
      "You alone enter the fog and clouds, your possessions are shunted behind you...\b";
      itemRem := parserGetMe().contents;
      while (car(itemRem)) {
        thisItem := car(itemRem);
        thisItem.moveInto(nil);
        itemRem := cdr(itemRem);
      }
      Me.winnable := true;
      snake.moveInto(Me);
      morePrompt();
      actor.travelTo(forestPath);
    }
  }
;

jabberwock: Actor
  sdesc = "Jabberwock"
  noun = 'jabberwock' 'monster' 'beast' 'beastie' 'jabberwocky'
  adjective = 'grotesque'
  takedesc = "Not a chance. "
  isHim = true
  ldesc = "A grotesque beastie with jaws that bite and claws that catch! It
          leaks sickly pus and fluid from every possible pore and shuffles
          about with a hunched-over gait to protect its soft underbelly. "
  actorDesc = "A grotesque beastie is lurking about. "
  count = 0                             // used for daemon to trigger action
  verDoSearch(actor) = { "It swats you away. "; }
  verDoHug(actor) = {"There is no defined torso to hug. "; }
  verDoKiss(actor) = {"O, what a glorious maw! "; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = {
    switch(rand(3)) {
      case 1:
        "<q>Rogga tu spi!</q>\ it bellows. ";
        break;
      case 2:
        "<q>Veezi un kie!</q>\ screams <<self.thedesc>>. ";
        break;
      case 3:
        "\^<<self.thedesc>> growls and stares right through you. ";
        break;
    }
    exit;
  }  
  verDoTellAbout(actor, io) = { "It growls. "; }
  doTellAbout(actor, io) = { self.doAskAbout(actor, io); }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = ""
  dontKnow = {
    local msg := [
      '<q>Rogga tu spi!</q>\ bellows '
      '<q>Veezi un kie!</q>\ screams ' 
      'A growl and a death stare is all you get from '
    ];
    say(msg[rand(length(msg))]);
  }
  askWord(word, lst) = {
    dontKnow; "<<self.thedesc>>. ";
    return nil;
  }
  doHello = { 
    if (!self.helloSaid) {
      "<q>Grrr...</q>\ snorts <<self.thedesc>>. ";
      self.helloSaid := true;
    }
    else
      "\^<<self.sdesc>> stares intently at you. ";
  }
  verDoAttack(actor) = { if (!sword.isIn(Me)) "You pose no threat -- no damage is done. "; }
  doAttack(actor) = { 
    "(with the sword)\n";
    sword.ioAttackWith(actor, self); 
  }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { sword.ioAttackWith(actor, iobj); }
  verDoCut(actor) = { if (!sword.isIn(Me)) "You have nothing to cut it with. "; }
  doCut(actor) = { 
    "(with the sword)\n";
    sword.ioAttackWith(actor, self); 
  }
  doListenTo(actor) = { "\^<<self.sdesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = { "It growls at you. "; }
  verDoTalkTo(actor) = { "The magnificent beast does not comprehend, does not reply. "; }
  verDoSingTo(actor) = { "The beastie snorts at you. "; }
;

fakeJabberwock: distantItem
  sdesc = "Jabberwock"
  noun = 'jabberwock' 'monster' 'beast' 'beastie' 'jabberwocky'
  adjective = 'grotesque'
  takedesc = "Not a chance. "
  isHim = true
  ldesc = "A grotesque beastie with jaws that bite and claws that catch! It
          leaks sickly pus and fluid from every possible pore and shuffles
          about with a hunched-over gait to protect its soft underbelly. 
          It's perched at the top of the terrace, staring intently at you. "
;

jabberwockDaemon: function(parm)
{
  if (jabberwock.count > 0) "\b";
  switch(jabberwock.count++) {
    case 1:
      if (Me.location = terrace)
        "The jabberwock gives you a once over...\ but the beast displays no intelligent
        cunning whatsoever. ";
      else {
        "The jabberwock looks down from the terrace and gives you a once over...\ but 
        the beast displays no intelligent cunning whatsoever. ";
        fakeJabberwock.moveInto(study);
      }
      break;
    case 2:
      if (Me.location = terrace) {
        "The jabberwock wails a mournful tune! ";
        if (sword.isIn(Me)) {
          "The jabberwock knocks the sword from your hand! It goes flying to the floor below,
          beneath the stairs! ";
          sword.moveInto(study);
        }
      }
      else {
        "The jabberwock looks down from the terrace, spying you intently. ";
        fakeJabberwock.moveInto(study);
      }
      break;
    case 3:
      if (Me.location = terrace) {
        "The jabberwock pounces!\b
        The jabberwock devours you. \b
        Its wail, mournful, no more. ";
        remdaemon(jabberwockDaemon, nil);
        Me.undoOK := true;
        die();
      }
      "The jabberwock follows you! It slithers down the stairs, almost matching your speed! ";
      jabberwock.moveInto(study);
      fakeJabberwock.moveInto(nil);
      break;
    case 4:
      "The jabberwock wails its mournful tune yet again! ";
      break;
    case 5:
      "The jabberwock pounces!\b
      The jabberwock devours you. \b
      Its wail, mournful, no more. ";
      remdaemon(jabberwockDaemon, nil);
      Me.undoOK := true;
      die(); 
      break;
  }
}
;

deadJabberwock: Actor
  sdesc = "Jabberwock"
  noun = 'jabberwock' 'monster' 'entrails' 'maw' 'beast' 'beastie' 'jabberwocky'
  adjective = 'grotesque'
  takedesc = "The jabberwock is far, far too large to be carried about. "
  isHim = true
  ldesc = "A formerly grotesque beastie with jaws that bit and claws that caught. It leaks
          sickly pus and fluid from every possible pore, but especially from the severe
          gash you inflicted upon it. "
  actorDesc = "The last of the great beasts, the jabberwock, lies slain upon the floor. "
  count = 0                             // used for daemon to trigger action
  verDoSearch(actor) = { "You decide to leave it alone. "; }
  verDoHug(actor) = { "You decide to leave it alone. "; }
  verDoKiss(actor) = { "You decide to leave it alone. "; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = { "You decide to leave it alone. "; }
  verDoTellAbout(actor, io) = { self.verDoAskAbout(actor, io); }
  doTellAbout(actor, io) = { self.doAskAbout(actor, io); }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = "You decide to leave it alone. "
  doHello = { "You decide to leave it alone. "; }
  verDoAttack(actor) = { }
  doAttack(actor) = { "Your work there is done. "; }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doListenTo(actor) = { "\^<<self.sdesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = { "It's dead. "; }
  verDoTalkTo(actor) = { "It's dead. "; }
;

forestPath: room
  sdesc = "Forest path"
  ldesc = {
    if (!self.seen) {
      self.seen := true;
      "The Hare witnesses your emergence and blitzes down the path, three steps
      for every one of yours. Sufficiently in the lead, he pauses for a moment
      and produces a shiny timepiece from one of the pockets of his leather
      vest. Wiping its brow (and streaking crusts of haemoglobin <i>everywhere!</i>)\ the 
      Hare does a backflip and gives you a wave. Though a vial drops from
      its half-jacket, it fails to notice and immediately continues its sprint
      until the path meets with the horizon. ";
    }
    "You are centered within a dark forest path. The lit, full moon provides
    more than ample light with which to comport yourself in your usual angelic sway. \b
    The plant-life and vegetation all carry a healthy glow around them, they
    grow thick amongst each other, intertwining to prevent passage in all
    directions except those that please them. ";
    if (!vial.isListed)
      "You spot a vial at the edge of the forest path. ";
    "\bThe path seems to lead in all directions, yet none appear inviting. ";
  }
  dirForward = nil
  noexit = { 
    if (self.dirForward = nil)
      "There is no passage there. "; 
    else
      "The only path is <<self.dirForward>>, toward the clearing. ";
  }
  north = { forestPathTaken(1, 'north', 'south'); }
  ne    = { forestPathTaken(2, 'northeast', 'southwest'); }
  east  = { "There is no passage there. "; }
  se    = { forestPathTaken(4, 'southeast', 'northwest'); }
  south = { forestPathTaken(5, 'south', 'north'); }
  sw    = { forestPathTaken(6, 'southwest', 'northeast'); }
  west  = { forestPathTaken(7, 'west', 'east'); }
  nw    = { forestPathTaken(8, 'northwest', 'southeast'); }
  out = { "Please specify a direction. "; }
  in = (self.out)
  genericHint = true
  isOutside2 = true
;

moonForest: fixeditem, floatingItem, distantItem
  sdesc = "moon"
  location = { if (Me.location.isOutside2) return Me.location; }
  noun = 'moon' 'lunar'
  ldesc = "The moon is providing just enough light to guide you tonight. "
  verDoJump(actor) = { "You're not a cow.  "; }
  takedesc = "You've got to jump over it first. "
;

babyPath: fixeditem, floatingItem
  sdesc = "path"
  noun = 'path'
  location = { if (Me.location.isOutside2) return Me.location; }
  ldesc = "There is nothing remarkable about the path. "
  verDoFollow(actor) = { "Please specify a direction. "; }
  verDoBoard(actor) = { "Please specify a direction. "; }
;

forestBaby: fixeditem, floatingItem
  sdesc = "forest"
  noun = 'forest' 'trees' 'tree'
  location = { if (Me.location.isOutside2) return Me.location; }
  ldesc = "There is nothing remarkable about the forest. "
  verDoEnter(actor) = { "Please specify a direction. "; }
  verDoBoard(actor) = { "Please specify a direction. "; }
;

vegetationBaby: fixeditem
  sdesc = "vegetation and plant life"
  noun = 'vegetation' 'life' 'plant-life'
  adjective = 'plant' 'plants'
  location = forestPath
  ldesc = "It's thick and uninviting. "
  takedesc = "It's too intertwined. "
  isThem = true
  verDoBoard(actor) = { "Please specify a direction. "; }
  verDoEnter(actor) = { "Please specify a direction. "; }
;

// The directions in the last scene are created dynamically in that the player will decide the path, 
// not the game.  There are some limitations but for the most part, all directions should work.
forestPathTaken: function(dir, forward, back)
{
  if (!forestPath.pathTaken) {
    forestPath.whichDir := dir;
    forestPath.pathTaken := true;
    "You follow the forest path a ways, it winds about, and eventually leads to a clearing...\b";
    forestPath.dirForward := forward;
    clearing.dirBack := back;
    Me.travelTo(clearing);
  }
  else if (forestPath.whichDir = dir)
    Me.travelTo(clearing);
  else
    "The only path is <<forestPath.dirForward>>, toward the clearing. ";
}

vial: item
  sdesc = "vial"
  noun = 'vial'
  location = forestPath
  ldesc =  "Inside the vial is fermented pickle juice and a half-kidney. "
  isListed = nil
  doTake(actor) = {
    self.isListed := true;
    inherited.doTake(actor);
  }
  verDoOpen(actor) = { "You struggle with all your might, but aren't mighty enough! "; }
  verDoClose(actor) = { "It's already closed. "; }
;

kidney: fixeditem
  sdesc = "kidney"
  noun = 'kidney' 'half-kidney'
  location = vial
  ldesc = "Half a human kidney, delightfully torn apart, of course -- there is no
          smooth or even jagged cutting lines to be found! "
  verDoDrop(actor) = {}
  doDrop(actor) = { vial.doDrop(actor); }
  verDoTake(actor) = {}
  doTake(actor) = { vial.doTake(actor); }
;

juice: fixeditem
  sdesc = "juice"
  noun = 'juice'
  adjective = 'fermented' 'pickle'
  location = vial
  ldesc = "The light of the moon causes it to glow with a shimmery ultraviolet. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> inside the vial. "
;

clearing: room
  sdesc = "Clearing"
  ldesc = {
    "Fine, powdery dust and shards make up a solid foundation for this out-of-the-way
    little vortex in the forest. The clearing is in the shape of an oval,
    and twenty yards across. ";
    if (!self.seen) {
      self.seen := true;
      "Two creatures bicker back and forth. They are little more than giant heads
      with distended, ugly feet attached to them.\b
      <q>I'll devour you, Oaf!</q>\ says one. <q>I'll munch upon that ugly face, bite
      by tantalizing bite and you shall witness it all, for the <i>last</i>
      morsel will be that pinched, sickly eye!</q>\b
      <q>Not before I, Roaf!</q>\ exclaims the other one. <q>You may bark and wheeze
      in your misguided, pathetic attempts to frighten, but I shall skewer you
      into meaty, tasty strips and use that ridiculous eyewear to magnify
      the light and heat them!</q> ";
      setdaemon(roafOafDaemon, nil);
    }
  }
  dirForward = nil
  noexit = { 
    if (self.dirForward = nil)
      "The only path leads <<self.dirBack>>, toward the forest path. "; 
    else
      "Possible paths lead <<self.dirForward>>, into another clearing and <<self.dirBack>>, back into the forest. ";
  }
  north = { clearingPathTaken(5, 'north', 'south'); }
  ne    = { clearingPathTaken(6, 'northeast', 'southwest'); }
  east  = { clearingPathTaken(7, 'east', 'west'); }
  se    = { clearingPathTaken(8, 'southeast', 'northwest'); }
  south = { clearingPathTaken(1, 'south', 'north'); }
  sw    = { clearingPathTaken(2, 'southwest', 'northeast'); }
  west  = { clearingPathTaken(3, 'west', 'east'); }
  nw    = { clearingPathTaken(4, 'northwest', 'southeast'); }
  out = { "Please specify a direction. "; }
  in = (self.out)
  genericHint = true
  isOutside2 = true
;

clearingPathTaken: function(dir, forward, back)
{
  if (forestPath.whichDir = dir)
    Me.travelTo(forestPath);
  else if (!clearing.pathTaken) {
    if (!roaf.choosen) {
      if (oaf.blocks) {
        "Oaf blocks your path! ";
        oaf.blocks := nil;
      }
      else {
        "Roaf blocks your path! ";
        oaf.blocks := true;
      }
    }
    else {
      clearing.whichDir := dir;
      clearing.pathTaken := true;
      "You make your way into the vegetation and come to a clearing...\b";
      clearing.dirForward := forward;
      clearing2.dirBack := back;
      Me.travelTo(clearing2);
    }
  }
  else if (clearing.whichDir = dir)
    Me.travelTo(clearing2);
  else {
    if (clearing.dirForward = nil)
      "The only path leads <<clearing.dirBack>>, toward the forest path. "; 
    else
      "Possible paths lead <<clearing.dirForward>>, into another clearing 
      and <<clearing.dirBack>>, back into the forest. ";
  }
}

// According to Robb, Roaf is the offensive lineman for the NO Saints.  :)
roaf: Actor
  sdesc = "Roaf"
  noun = 'roaf' 'head' 'heads'
  adjective = 'creature' 'creatures' 'giant'
  takedesc = "Not a chance. "
  location = clearing
  isHim = true
  thedesc = "Roaf"
  adesc = "Roaf"
  ldesc = "He is a darkened, malformed head, shadowed in tint, with fuzzy black hair
          and oversized eyewear. Two mangled, twisted feet poke out from neath
          his chin.  He possesses no torso, arms, or legs. "
  actorDesc = {
    if (!self.seen)
      self.seen := true;
    else
      "Roaf and Oaf are waddling about. ";
  }
  count = 0                             // used for daemon to trigger action
  verDoChoose(actor) = { if (!roaf.chooseOK) "But why? "; }
  doChoose(actor) = {
    "Roaf gasps!\b
    Oaf pounces, with quickness like a cobra, onto Roaf and begins savagely 
    tearing away his features. Roaf kicks, flails, rolls... anything to 
    scatter and free himself. Oaf snares the eyewear with his teeth and 
    crunches them into powdered dust. \b
    Roaf's horrible howls cause you to drop to your knees and cover your
    ears. Rather than watch the consumption, you bury your head until
    the wailing and screaming stops.\b
    With the return of the forest's eerie silence, you look up again.
    Oaf chews on something with excessive pantomime, before meeting
    eyes with you and spitting a wad of flesh onto the ground.\b
    Oaf wanders off the way you came before finally disappearing. ";
    earlobe.moveInto(clearing);
    oaf.moveInto(nil);
    self.moveInto(nil);
    self.choosen := true;
    remdaemon(roafOafDaemon, nil);
  }
  verDoHug(actor) = { self.verDoKiss(actor); }
  verDoKiss(actor) = {"<q>That is rather kind of you,</q> says Roaf. <q>She likes me!</q>"; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = {
    "<q>Don't tell me what to do!</q>\ exclaims Roaf. ";
    exit;
  }  
  askWord(word, lst) = {
    switch(substr(word, 1, 7)) {
      case 'oaf':
        "<q>A terrible, kniving snitch,</q> says Roaf. ";
        return true;
        break;
      case 'game':
        "<q>Choose the winner!</q>\ quips Roaf. ";
        return true;
        break;
      default:
        "Roaf would be shrugging if Roaf could shrug. ";
        return nil;
    }
  }
  verDoTellAbout(actor, io) = { self.verDoAskAbout(actor, io); }
  doTellAbout(actor, io) = { 
    "You wonder what <<self.thedesc>> has to say instead, so you ask him about it.\b";
    self.doAskAbout(actor, io); 
  }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = "<q>Don't tell me what to do!</q>\ exclaims Roaf. "
  doHello = { 
    if (!self.helloSaid) {
      "<q>Hi,</q>\ replies <<self.thedesc>>. ";
      self.helloSaid := true;
    }
    else
      "\^<<self.sdesc>> stares intently at you. ";
  }
  verDoAttack(actor) = { }
  doAttack(actor) = { "Roaf doesn't like that very much. "; }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doListenTo(actor) = { "\^<<self.sdesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = { "Roaf has no hands to accept your offer. "; }
  verDoTalkTo(actor) = { "<q>It is a difficult path at first,</q> says Roaf, <q>but I will make
                         it all worthwhile.</q> "; }
;

oaf: Actor
  sdesc = "Oaf"
  noun = 'oaf' 'head' 'heads'
  adjective = 'creature' 'creatures' 'giant'
  takedesc = "Not a chance. "
  location = clearing
  isHim = true
  thedesc = "Oaf"
  adesc = "Oaf"
  ldesc = "He is a flighty, wavy head, bright in tone, with wavy auburn hair and
          a lone, suspicious eyeball. Two mangled, twisted feet poke out from
          neath his chin. He possesses no torso, arms or legs. "
  actorDesc = {
    if (!self.seen)
      self.seen := true;
  }
  verDoChoose(actor) = { if (!roaf.chooseOK) "But why? "; }
  doChoose(actor) = {
    "<q>Delightful,</q> muses Roaf.\b
    Roaf thrusts himself over toward Oaf and knocks him into the ground. He strikes,
    quick as a cobra, and sits atop him, his teeth gnawing and biting away chunks 
    of Oaf's face. He rips shredded specks of skin and flesh and spits them out to 
    one side.\b
    Oaf howls, a cry more of defeated agony than that of rage or directed anger.\b
    Roaf finishes his meal. Ultimately, not a scrap of Oaf remains. \b
    His hunger unsatiated, he then jumps on you and continues to enjoy
    his repast. ";
    Me.undoOK := true;                  // allow undo here
    die();
  }
  count = 0                             // used for daemon to trigger action
  verDoHug(actor) = { "<q>Ah, delectable,</q> muses Oaf. "; }
  verDoKiss(actor) = { "<q>Ah, delectable,</q> muses Oaf. "; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = {
    "<q>Please don't tell me what to do!</q>\ replies Oaf. ";
    exit;
  }  
  askWord(word, lst) = {
    switch(substr(word, 1, 7)) {
      case 'oaf':
        "<q>A disgusting, blobby lurker, with unkept hair and a shambling gait,</q> confides Oaf. ";
        return true;
        break;
      case 'game':
        "<q>Choose the winner,</q>\ says Roaf. ";
        return true;
        break;
      default:
        "Oaf would be shrugging if Oaf could shrug. ";
        return nil;
    }
  }
  verDoTellAbout(actor, io) = { self.verDoAskAbout(actor, io); }
  doTellAbout(actor, io) = { 
    "You wonder what <<self.thedesc>> has to say instead, so you ask him about it.\b";
    self.doAskAbout(actor, io); 
  }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = "<q>Don't tell me what to do!</q>\ exclaims Oaf. "
  doHello = { 
    if (!self.helloSaid) {
      "<q>Hi,</q>\ replies <<self.thedesc>>. ";
      self.helloSaid := true;
    }
    else
      "\^<<self.sdesc>> stares intently at you. ";
  }
  verDoAttack(actor) = { }
  doAttack(actor) = { "Oaf cries! "; }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doListenTo(actor) = { "\^<<self.sdesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = { "Oaf has no hands to accept your offer. "; }
  verDoTalkTo(actor) = { "<q>I would be so good for you,</q> muses Oaf. "; }
;

oafRoafTopic: item
  sdesc = "game"
  noun = 'game'
;

earlobe: item
  sdesc = {
    if (!self.inspected)
      "wad";
    else
      "earlobe";  
  }
  noun = 'wad' 'lobe' 'earlobe' 'flesh'
  ldesc = {
    if (!self.inspected) {
      "It is an earlobe. ";
      self.inspected := true;
    }
    else
      "It is a stringy, squooshy chunk of fleshy lobe. ";
  }
  adesc = {
    if (!self.inspected)
      "a wad";
    else
      "an earlobe";  
  }
  lisendesc = { "The earlobe seems to listen right back. "; }
;

roafOafDaemon: function(parm)
{
  if (Me.location <> clearing) return;
  switch(roaf.count++) {
    case 1:
      "\b<q>Oh, why look, Roaf!</q>\ exclaims Oaf. <q>A little girl has wandered into
      our little stead! Why hello there, little one! Would you care to
      stay for a meal?</q>\b
      <q>You're ruining it, you great, stupid Oaf!</q>\ screeches Roaf. <q>A mindless,
      blue-skinned deafened mute could see through your terrible ruse!</q> ";
      break;
    case 2:
      "\b<q>Why surely her daddy has yet to inform her of the seductive stylings
      of strangers,</q> says Oaf. <q>Besides, she has a nasty little pusher around
      her neck. Her time runs negative toward forward!</q>\b
      <q>Oh no, praytell,</q> states Roaf. <q>I have it on positively smashing authority
      that her daddy knows all about you and I, my witless and quite stupid chum! 
      He truckles up to them like a suckling leech, pulling away their spirit and cares!</q> ";
      break;
    case 3:
      "\b<q>Are your fatted lobes growing larger, Roafie old boy?</q>\ asks Oaf. <q>They look
      positively delectable. I think I would enjoy chewing them like flavoured
      rubber for the better part of the upcoming fortnight. Or perhaps basted
      in a rich creme sauce!</q>\b
      <q>Mind your manners, you,</q> mutters Roaf, while staring you up and down. Saliva
      glistens and drips off his teeth, and he grins a positively...\ <i>Cheshire</i>
      grin! <q>I think it would be best if we let the hopeless little venger choose.</q>\b
      <q>Choose what, Roaf?</q>\ asks Oaf. <q>Surely you mustn't let fair play get in the
      way. Not now, not ever! <I>What</i> ever do you mean?</q>\b
      <q>All I mean is that I ache for the completed set,</q> says Roaf. <q>Don't you
      see? It is this way in which I may have it all.</q> He refuses to look at anyone
      or anything but you. <q>Go ahead, my light-hearted friend,</q> whispers Roaf.
      <q>Choose the loser of the game.</q> ";
      roaf.chooseOK := true;
      break;
    case 5:
      "\bRoaf looks at you in anticipation. ";
      break;
    case 7:
      "\b<q>Afraid to choose, are we?</q>\ muses Roaf, <q>let me see if I can help!</q>\b
      Roaf thrusts himself over toward Oaf and knocks him into the ground. He strikes,
      quick as a cobra, and sits atop him, his teeth gnawing and biting away chunks 
      of Oaf's face. He rips shredded specks of skin and flesh and spits them out to 
      one side.\b
      Oaf howls, a cry more of defeated agony than that of rage or directed anger.\b
      Roaf finishes his meal. Ultimately, not a scrap of Oaf remains. \b
      His hunger unsatiated, he then jumps on you and continues to enjoy
      his repast. ";
      Me.undoOK := true;                  // allow undo here
      die();
      break;
  }
}
;

clearing2: room
  sdesc = "Clearing"
  ldesc = {
    if (brokenWall.location = clearing2)
      "Before you is a pile of crumbled bricks and a small table. ";
    else {
      "Before you is a brick wall that extends into perilous overgrowth.
      The wall is several times your height and quite impassable.
      There is a small table set before the wall itself. ";
      if (!self.seen) {
        self.seen := true;
        "\bYou notice a single meter-high creature swinging back and forth
        on a brass bell that emerges from the top two layers of the wall. ";
        setdaemon(humptySpeakDaemon,nil);
      }
      else
        "An egg, swinging back and forth on a brass bell, is perched high up on the wall. ";
    }
  }
  dirForward = nil
  noexit = { 
    if (self.dirForward = nil)
      "The only path leads <<self.dirBack>>, toward another clearing. "; 
    else
      "Possible paths lead <<self.dirForward>> and <<self.dirBack>>, back into another clearing. ";
  }
  north = { clearing2PathTaken(1, 'north', 'south'); }
  ne    = { clearing2PathTaken(2, 'northeast', 'southwest'); }
  east  = { clearing2PathTaken(3, 'east', 'west'); }
  se    = { clearing2PathTaken(4, 'southeast', 'northwest'); }
  south = { clearing2PathTaken(5, 'south', 'north'); }
  sw    = { clearing2PathTaken(6, 'southwest', 'northeast'); }
  west  = { // need to keep one sane direction!
    if (clearing2.dirBack = 'west')
      return clearing;
    else if (clearing2.dirForward = nil)
      "That passage does not exist; you do see a footpath leading <<clearing2.dirBack>>, back toward a clearing. ";
    else
      "Possible paths lead <<clearing2.dirForward>> and <<clearing2.dirBack>>, back into another clearing. ";
  }
  nw    = { clearing2PathTaken(8, 'northwest', 'southeast'); }
  out = { "Please specify a direction. "; }
  in = (self.out)
  genericHint = true
  isOutside2 = true
;

clearing2PathTaken: function(dir, forward, back)
{
  if (clearing.whichDir = dir)
    Me.travelTo(clearing);
  else if ((brokenWall.location = clearing2) and 
           (!clearing2.pathTaken)) {
    clearing2.whichDir := dir;
    clearing2.pathTaken := true;
    "You climb passed the fallen bricks and enter the plains beyond it. \b";
    clearing2.dirForward := forward;
    closeEdge.dirBack := back;
    Me.travelTo(closeEdge);
  }  
  else if (clearing2.whichDir = dir)
    Me.travelTo(closeEdge);
  else {
    if (clearing2.dirForward = nil)
      "The only path leads <<clearing2.dirBack>>, toward another clearing. "; 
    else
      "Possible paths lead <<clearing2.dirForward>> toward the edge of the clearing and <<clearing2.dirBack>>, back into another clearing. ";
  }
}

humptyWall: fixeditem
  sdesc = "brick wall"
  noun = 'wall'
  adjective = 'brick'
  location = clearing2
  ldesc = "It is several times your height and quite impassable. It is made up of 
          foreboding rows of pasted lines of brickery. "
  takedesc = "What a concept! "
  verDoClimb(actor) = { "The wall is much too tall for you to climb. "; }
  verDoClimbover(actor) = { "The wall is much too tall for you to climb. "; }
  verDoClimbup(actor) = { "The wall is much too tall for you to climb. "; }
  verIoThrowAt(actor) = {}
  ioThrowAt(actor, dobj) = {
    if (!dobj.isIn(parserGetMe())) {
      "You don't have <<dobj.thedesc>>. ";
      return nil;
    }
    else
      "You miss. ";
    if (isclass(dobj, stoneItem))
      dobj.moveInto(humptyTable);
    else
      dobj.moveInto(clearing2);
  }
  verDoAttack(actor) = { "The wall resists your violent advances. "; }
  verDoBreak(actor) = { "The wall resists your violent advances. "; }
;

humptyTable: fixeditem, surface
  sdesc = "table"
  noun = 'table'
  location = clearing2
  ldesc = {
    "On the table are numerous stones, with single-digit numbers upon most of them. ";
  }  
  verDoLookin(actor) = { self.ldesc; }
  takedesc = "The table is far too heavy for you to lift. "
;

class stoneItem: item
  noun = 'stone' 'stones'
  ldesc = {
    "It is a tiny, rounded stone";
    if (self.stoneNum = '0') 
      ". ";
    else
      " with the number <<self.stoneNum>> painted upon it. ";
  }
  isListed = {
    if (self.location = humptyTable)
      return nil;
    else
      return true;
  }
  location = humptyTable
  isStone = true
;

stone1: stoneItem
  sdesc = "one stone"
  adjective = 'one' '1'
  stoneNum = '1'
;

stone9: stoneItem
  sdesc = "nine stone"
  adjective = 'nine' '9'
  stoneNum = '9'
;

stone2: stoneItem
  sdesc = "two stone"
  adjective = 'two' '2'
  stoneNum = '2'
;

stone8: stoneItem
  sdesc = "eight stone"
  adjective = 'eight' '8'
  stoneNum = '8'
;

stone3: stoneItem
  sdesc = "three stone"
  adjective = 'three' '3'
  stoneNum = '3'
;

stone7: stoneItem
  sdesc = "seven stone"
  adjective = 'seven' '7'
  stoneNum = '7'
;

stone4: stoneItem
  sdesc = "four stone"
  adjective = 'four' '4'
  stoneNum = '4'
;

stoneBlank: stoneItem
  sdesc = "blank stone"
  adjective = 'blank'
  stoneNum = '0'
;

stone5: stoneItem
  sdesc = "five stone"
  adjective = 'five' '5'
  stoneNum = '5'
;

stone6: stoneItem
  sdesc = "six stone"
  adjective = 'six' '6'
  stoneNum = '6'
;

humptySpeakDaemon: function(parm)
{
  if (humpty.count++ > 1 and Me.location = clearing2) {
    remdaemon(humptySpeakDaemon,nil);
    "\bThe egg speaks:\b
    <q>I thought I saw a little girl \n
    Free from the black murder: \n
    I looked again and found it was \n
    Covered in filthy burr.\n
    Have we have met once before my child?\n
    How old ja say joo were?</q>\b
    The creature holds out one of its hands. The other holds tightly to the bell, 
    and it continues to swing back and forth. ";
  }
}

jams: fixeditem
  sdesc = "jams"
  noun = 'jams'
  adjective = 'fuzzy'
  location = humpty
  ldesc = "They are quite fuzzy. "
  takedesc = "You can't reach him. "
  isThem = true
;

humpty: Actor
  sdesc = "creature"
  noun = 'creature' 'humpty' 'egg'
  takedesc = "He's up too high. "
  isHim = true
  ldesc = "It is an animate, swinging egg. A completely blank face, it has
          four impossible limbs arranged like that of a person's, and is
          clad in fuzzy jams. "
  location = humptyWall
  actorDesc = {
    if (!self.seen)
      self.seen := true;
    else
      "An egg, swinging back and forth on a brass bell, is before you. ";
  }
  count = 0                             // used for daemon to trigger action
  verDoSearch(actor) = { "You can't reach him. "; }
  verDoHug(actor) = {"He's up too high. "; }
  verDoKiss(actor) = {"You can't reach him. "; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = {
    if (v.isTravelVerb) {
      "<q>I'm staying right here!</q> ";
      exit;
    }
    switch(v) {
      case noVerb:
      case yesVerb:
      case helloVerb:
        break;
      case wearVerb:
        "<q>I'm comfortable with what I'm already wearing.</q> ";
        exit;
      default:
        "The egg ignores you. ";
        exit;
    }
  }  
  verDoTellAbout(actor, io) = { self.verDoAskAbout(actor, io); }
  doTellAbout(actor, io) = { 
    "You wonder what <<self.thedesc>> has to say instead, so you ask him about it.\b";
    self.doAskAbout(actor, io); 
  }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = ""
  askWord(word, lst) = {
    switch(substr(word, 1, 7)) {
      case 'me':
      case 'myself':                                                           
        "The egg speaks:\b";
        "<q>A little girl, so wonderful\n
        It has to make you pause.\n
        A world she never cared to see,\n
        I wonder, what's the cause?\n
        Work her way through destiny, or \n
        Fall to a million maws?</q> ";
        break;
      case 'hare':
        "The egg speaks:\b";
        "<q>His heart is filled with hatred, and\n
        The Hatred are his trades,\n
        He listens like a spectre, but\n
        The Hatred never fades.\n
        A cleansing never helps the Hare,\n
        You cannot wipe 'way Hades!</q>\b
        The egg sees you wrinkle your nose at how he blew that last line. He hops up on 
        top of the bell for a moment in order to shrug.\b
        The egg returns to swinging to and fro on the bell. ";
        return true;
        break;
      case 'wall':
        "The egg speaks:\b";
        "<q>The wall will never fall my love,\n
         Lest you whack it away,\n
         And though I give you but one chance\n
         To say what you must say,\n
         If you think this through properly\n
         You'll no doubt save the day!</q> ";
        return true;
        break;
      case 'table':
        "The egg speaks:\b";
        "<q>I hate it so, it mocks me so!\n
        I love it, quick with rage!\n
        Too far to fall nicely upon!\n
        I hear it, quick with rage!\n
        Pick soon and end this hateful ruse\n
        I cleanse it, quick with rage!</q> ";
        return true;
        break;
      case 'stone':
      case 'stones':
        "The egg speaks:\b";
        "<q>You must pick one and give to me:\n
        Stone upon the table\n
        Your choice reflects your path in this,\n
        Telling of the fable.\n
        So careful -- pick! With measured care -- \n
        Win!\ ...If you are able ...</q> ";
      case 'wad':
      case 'ear':
      case 'lobe':
      case 'earlobe':
        "The egg performs a mid-air somersault to hurl itself on top of the bell. It smiles devilishly 
        and tugs at its own earlobes.  It pantomimes great concern before dissolving in a flurry
        of giggles and launching itself again into acrobatics that allow it to swing from the bell. ";
        return true;
        break;
      case 'heart':
        "The egg performs a gymnastic and hurls itself into a ovalled ball that sets upon the top of 
        the bell. It giggles deep and puts one hand across its heart. It fakes a look of thoughtful
        concern before launching itself into another roll and swinging, again, from the bell. ";
        return true;
        break;
      case 'kidney':
      case 'vial':
      case 'pickle':
      case 'juice':
        "The egg starts to urinate through its pants. It holds one finger up to its lips as if to 
        relate how naughty it is before laughing a cold and spastic giggle.  ";
        return true;
        break;
      default:
        "The egg hops up on top of the bell, shrugs, and then resumes swinging back and forth. ";
        return nil;
      }
  }
  doAskAbout(actor, iobj) = {
    switch(iobj) {
      case himself:
        "<q>I am the one before you, child,\n
        Though fragile is my stake.\n
        In this I am the taunting man!\n
        A stone I think you'll take!\n
        Choose well, though, for when guts I spill\n
        They fill a crimson lake!</q> ";
        break;
      default:
        /* we didn't find anything special; use the default behavior */
        inherited.doAskAbout(actor, iobj);
    }
  }
  doHello = { "<q>Hello,</q> he says. "; }
  verDoAttack(actor) = { }
  doAttack(actor) = { "He's too far away. "; }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doListenTo(actor) = { "\^<<self.sdesc>> isn't making much noise right now. "; }
//  ioSynonym('GiveTo') = 'ShowTo'
  verIoShowTo(actor) = {}
  ioShowTo(actor, dobj) = {
    if (dobj.isStone) {
      "You hand <<dobj.thedesc>> to the egg. \b ";
      self.ioGiveTo(actor,dobj);
    }
    else
      "The egg looks away. ";
  }
  ioGiveTo(actor, dobj) = {
    switch(dobj) {
      case stone1:
      case stone2:
      case stone3:
      case stone4:
      case stone5:
      case stone8:
      case stone9:
        if (!self.warned) {
          self.warned := true;
          "The egg speaks: \b
          <q>I thought I saw a little girl\n
          Who understood my ruse.\n
          She liked to play and listen to\n
          Her helpful, dimwit muse.\n
          Joo wish to pick just one more time?\n
          'Cos as of now, you lose!</q> ";
        }
        else {
          "The egg speaks:\b
          <q>I thought I knew a little girl\n
          More clever though, was she.\n
          She walked a trail to my abode,\n
          O, horrors did she see!\n
          Twice she answered wrong my riddle,\n
          But only once she fleed!</q>\b
          The egg releases himself from the bell!\b
          The egg burrows himself into the ground, leaving only his knickers behind. Flanked
          by the wall on one side, the forest creeps oh-so claustrophobically around you, holding your
          arms close with its fear, locking your legs together with its horrific delight... The egg
          revels in slowly unearthing itself from the forest ground. His fragile, fractured hand
          grabs hold both ends of the inanimate snake around your neck and he pulls.\b
          Pulls until the pressure splits your head apart. ";
          Me.undoOK := true;                  // allow undo here
          die();
        }
        break;
      case stone6:
        "<q>Know yourself before your quest,\n
        Whatever will you do?\n
        You cannot look, you cannot read\n
        When random chance'll do.\n
        'The unfair egg gobbled me whole!'\n
        State <i>this</i> in your review!</q>\b
        The egg releases its hold on the bell, and drops to the ground!\b
        The egg tumbles toward you and knocks you 'round! \b
        The egg sniggers with glee, sets the bricks upon you and flees,
        and the wall comes a-crashing down! ";
        Me.undoOK := true;                  // allow undo here
        die();
        break;
      case stone7:
        "<q>I thought I saw a little girl,\n
        Upon her final day.\n
        Eager to play my riddles and\n
        Friendly all the way.\n
        And though we'd never met, your age\n
        Is what you'll <i>never</i> say!</q>\b
        The egg releases its handhold on the bell!\b
        The egg tumbles toward you, and knocks you down!\b
        The egg hops back up into the air and with a somersault and twist, grabs the bell once again.\b
        He then promptly eats the seven stone. ";
        stone7.moveInto(nil);
        exit;
        break;
      case stoneBlank:
        "The egg speaks:\b
        <q>My heart, my heart, oh hateful day!\n
        You've never <i>said</i> before!\n
        Your age is quite foreign to me,\n
        Quite clever, mi amour.\n
        And though we've never met, my heart \n
        Just leaps upon the floor!</q>\b
        The creature shifts violently to one side and rings the bell. The sounding of it
        sends a audial wave that knocks you back into tumbles for several meters. \b
        As you slowly right yourself you see the egg cracked open with a beating heart
        left behind, and that the wall has been broken into crumbly bits, allowing passage. ";
        self.moveInto(nil);
        heart.moveInto(clearing2);
        humptyWall.moveInto(nil);
        deadHumpty.moveInto(clearing2);
        brokenWall.moveInto(clearing2);
        remdaemon(humptySpeakDaemon,nil);
        stoneBlank.moveInto(nil);
        exit;
        break;
      case snake:
        "The snake is wrapped around your neck tightly. ";
        break;
      default:
        "The egg looks suitably impressed by your generosity, but makes a show of 
        needing each hand to hold the bell. ";
        break;
    }
    if (dobj.isStone)
      "\bThe egg drops the stone and it lands on the small table. ";
  }
  verDoTalkTo(actor) = {}
  doTalkTo(actor) = { 
    "The egg speaks:\b";
    "<q>You must pick one and give to me:\n
    Stone upon the table\n
    Your choice reflects your path in this,\n
    Telling of the fable.\n
    So careful -- pick! With measured care -- \n
    Win!\ ...If you are able ...</q> ";
  }
  verIoThrowAt(actor) = {}
  ioThrowAt(actor, dobj) = {
    if (!dobj.isIn(parserGetMe())) {
      "You don't have <<dobj.thedesc>>. ";
      return nil;
    }
    else
      "You miss. ";
    if (isclass(dobj, stoneItem))
      dobj.moveInto(humptyTable);
    else
      dobj.moveInto(clearing2);
  }
  verDoSwing(actor) = { "The egg dodges out of the way. "; }
;

deadHumpty: Actor
  sdesc = "creature"
  noun = 'creature' 'humpty' 'pieces' 'piece'
  takedesc = "You attempt to, but the pieces! So unwieldy and encumbering. You fail, and feel that you could not 
             do so even if you had the help of a royal garrison and their corresponding mounts. "
  isHim = true
  ldesc = "It appears as if he had a great fall. "
  actorDesc = ""
  count = 0                             // used for daemon to trigger action
  verDoSearch(actor) = { "You decide to leave it alone. "; }
  verDoHug(actor) = { "You decide to leave it alone. "; }
  verDoKiss(actor) = { "You decide to leave it alone. "; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = { "You decide to leave it alone. "; }
  verDoTellAbout(actor, io) = { self.verDoAskAbout(actor, io); }
  doTellAbout(actor, io) = { self.doAskAbout(actor, io); }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = "You decide to leave it alone. "
  doHello = { "You decide to leave it alone. "; }
  verDoAttack(actor) = { }
  doAttack(actor) = { "You decide to leave it alone. "; }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doListenTo(actor) = { "\^<<self.sdesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = { "It's dead. "; }
  verDoTalkTo(actor) = { "About it, much later, seems more likely. "; }
;

brokenWall: fixeditem
  sdesc = "pile of bricks"
  noun = 'bricks' 'brick'
  adjective = 'pile'
  ldesc = "The bricks are now quite crumbly. "
  takedesc = "Even the smallest chunk of brick is too large and heavy for you to move. "
  isThem = true
;

humptyBell: distantItem
  sdesc = "brass bell"
  noun = 'bell'
  adjective = 'brass' 'shiny'
  location = humptyWall
  ldesc = "It is quite shiny! "
  verDoPush(actor) = { "It's out of reach! It is too tall for you. "; }
;

heart: item
  sdesc = "heart"
  noun = 'heart'
  ldesc = {
    "The heart is about the size of two of your fists. It beats slowly,
    to a steady, hollow beat. ";
  }
  verDoListenTo(actor) = {}
  doListenTo(actor) = {
    "You do so...\ you find it quite soothing. ";
    "<SOUND SRC=\"ntts.mp3\" LAYER=\"FOREGROUND\">";
  }
;

closeEdge: room
  sdesc = "The Close Edge of the Plane"
  ldesc = {
    "The forest ends on this side of the wall. Grassy, lushy plains, spread from
    feathered jade slip beneath your toes. Once more, a brilliant fog cuts
    off your view of the horizon. Fifteen meters east of the ruins of the once-brick
    wall (and in the middle of the plains) is a sandy circle.\b
    You can see and hear the Hare here, he mumbles and meeps in spastic seizures,
    tossing a killing knife from hand to hand. He is far away from you, however,
    and shows no signs of getting closer. ";
    if (!self.seen) {
      self.seen := true;
      "The snake becomes animate once again. It buzzes in your ear. ";
      snake.hareCnt := 0;
      setdaemon(snakeHareDaemon,nil);
    }
  }
  noexit = { "The only path is <<self.dirBack>>, toward the clearing or you can enter 
              the circle by going east. "; }
  north = { closeEdgePathTaken(5); }
  ne    = { closeEdgePathTaken(6); }
  east =  { enterCircle(); }
  se    = { closeEdgePathTaken(8); }
  south = { closeEdgePathTaken(1); }
  sw    = { closeEdgePathTaken(2); }
  west  = { closeEdgePathTaken(3); }
  nw    = { closeEdgePathTaken(4); }
  in = (self.east)
  genericHint = true
  isOutside2 = true
;

edgeForest: decoration
  sdesc = "forest"
  noun = 'forest'
  location = closeEdge
  ldesc = "The forest is behind you, now. "
;

edgePlains: decoration
  sdesc = "plains"
  noun = 'plains'
  location = closeEdge
  ldesc = "They are lush, vibrant, green...\ so soft, and slightly covered with dew. "
;

edgeFog: decoration
  sdesc = "fog"
  noun = 'fog'
  location = closeEdge
  ldesc = "The night-time air is heavy and thick with the all encompassing fog. "
;

edgeHorizon: decoration
  sdesc = "horizon"
  noun = 'horizon'
  location = closeEdge
  ldesc = "It is difficult to make out the horizon, impossible, almost...\ it is covered in a dense quantity of fog. "
;

closeEdgePathTaken: function(dir)
{
  if (clearing2.whichDir = dir)
    Me.travelTo(clearing2);
  else
    "The only path is <<clearing2.dirBack>>, toward the clearing or you can enter the circle by going east. ";
}

farHare: distantItem
  sdesc = "hare"
  noun = 'hare' 'rabbit'
  location = closeEdge
  ldesc = "<<hare.ldesc>>"
  verIoThrowAt(actor) = {}
  ioThrowAt(actor, dobj) = {
    if (!dobj.isIn(parserGetMe())) {
      "You don't have <<dobj.thedesc>>. ";
      return nil;
    }
    else if (dobj = snake) 
      "You tug at the snake, but it tightens further around your neck. ";
    else {
      "You miss. The <<dobj.sdesc>> falls into the circle. ";
      dobj.moveInto(sandyCircle);
    }
  }
;

farKnife: fixeditem
  sdesc = "knife"
  noun = 'knife' 
  location = farHare
  ldesc = "<<knife.ldesc>>"
  dobjGen(a, v, i, p) = {
    if (v <> askVerb and v <> tellVerb and v <> inspectVerb and v <> takeVerb) {
      "\^<<self.itisdesc>> too far away. ";
      exit;
    }
  }
  iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
  verDoTake(actor) = { "The Hare would never let you have that, without something in return at least. "; }
;

snakeHareDaemon: function(parm)
{
  if (snake.hareCnt++ > 0 and Me.location = closeEdge) {
    snakeHareText();
    remdaemon(snakeHareDaemon,nil);
  }
}

snakeHareText: function
{
  "\bThe snake whispers into your ear:\b
  <q>Do you see him, little one? I think he wants to make a trade. There are
  three fleshy artifacts that you have encountered, and no I am not one. But
  do not feel inclined to play his game, all you have to do is take me to
  him, together. For together we can stop this charade!</q> ";
  Me.heardSnake := true;
}

sandyCircleItem: fixeditem
  sdesc = "sandy circle"
  noun = 'circle'
  adjective = 'sandy'
  location = closeEdge
  ldesc = {
    "It appears to be a flattened sphere of sand.\b ";
    if (itemcnt(sandyCircle.contents) > 0) {
      caps(); self.thedesc; " contains "; listcont(sandyCircle);
    }
    else
      " There is nothing in the circle";
    ". ";
  }
  verDoEnter(actor) = { self.verDoBoard(actor); }
  doEnter(actor) = { self.doBoard(actor); }
  verDoBoard(actor) = {}
  doBoard(actor) = { enterCircle(); }
  verIoPutIn(actor) = {}
  ioPutIn(actor, dobj) = {
    if (!dobj.isIn(Me)) 
      "You're not carrying <<dobj.thedesc>>. ";
    else
      "The circle it too far away. ";
  }
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
;

enterCircle: function
{
  if (!Me.heardSnake) {
    "As you head toward the circle, the snake abruptly tightens around your neck -- you stop.";
    snakeHareText();
    remdaemon(snakeHareDaemon,nil);
    return;
  }
  if (heart.isIn(Me) and earlobe.isIn(Me) and vial.isIn(Me) ) {
    "<q>You're not going to make this trade, are you?</q>\ meekly queries the hateful snake.\b ";
    Me.travelTo(sandyCircle);
    farHare.moveInto(sandyCircle);
  }
  else {
    "You head off toward the circle, when alas strikes the snake!\b
    <q>Did you feel you could trust me, then? I almost never get that!
    But I cannot help what I am, and <i>certainly</i> since ripper's cleaver
    got me into this mess in the first place, I want, <i>certainly</i>, no part of it.</q>\b
    The snake, now at its strongest, tightens its grip around your neck and
    sinks its fangs into your neck. ";
    Me.undoOK := true;                  // allow undo here
    die();
  }
}

sandyCircle: room
  sdesc = "Sandy Circle"
  ldesc = {
    "This is naught but a flattened sphere of sand, free from foul contaminates. ";
    if (!self.seen) {
      self.seen := true;
      "\bThere is nothing in the circle. ";
      setdaemon(hareSandDaemon,nil);
    }
  }
  north = { circlePathTaken(1, 'north', 'south'); }
  ne    = { circlePathTaken(2, 'northeast', 'southwest'); }
  east  = { circlePathTaken(3, 'east', 'west'); }
  se    = { circlePathTaken(4, 'southeast', 'northwest'); }
  south = { circlePathTaken(5, 'south', 'north'); }
  sw    = { circlePathTaken(6, 'southwest', 'northeast'); }
  west = {
    if (!snake.dead and hare.hasItems) {
      "The snake laughs in glee!\b
      <q>So close you were, my dear!</q>\b
      The snake, content and amused by your actions, wraps itself tightly around your
      heart, causing you to pass out -- uninvited to your own final meal. ";
      Me.undoOK := true;                  // allow undo here
      die();
    }
    else if (hare.hasItems)
      "You reconsider returning to the forest, where the Hare could trap you. ";
    else {
      farHare.moveInto(closeEdge);
      return closeEdge;
    }
  }
  nw    = { circlePathTaken(8, 'northwest', 'southeast'); }
  in = { "Please specify a direction. "; }
  out = (self.west)
  genericHint = true
  isOutside2 = true
;

circlePathTaken: function(dir, forward, back)
{
  if (!hare.hasItems) 
    "The Hare won't let you. ";
  else if (!snake.dead) {
    "The snake laughs in glee!\b
    <q>So close you were, my dear!</q>\b
    The snake, content and amused by your actions, wraps itself tightly around your
    heart, causing you to pass out -- uninvited to your own final meal. ";
    Me.undoOK := true;                  // allow undo here
    die();
  }
  else {
    "You run, far away from the Hare! \b
    The eyes of the Hare contract, then immediately bug out in ecstasy. \b
    <q>Run, run, run!</q>\ it says! <q>For now I'm going...\ to feast on you!</q>\b ";
    farEnd.dirBack := back;
    farHare.moveInto(farEnd);
    Me.travelTo(farEnd);
  }
}

sandyCircleItem2: fixeditem
  sdesc = "sandy circle"
  noun = 'circle'
  adjective = 'sandy'
  ldesc = { 
    sandyCircle.ldesc;
    "\b";
    if (itemcnt(sandyCircle.contents) > 0) {
      caps(); self.thedesc; " contains "; listcont(sandyCircle);
    }
    else
      " There is nothing in the circle";
    ". ";
  }
  location = sandyCircle
  takedesc = "What a concept!"
  verIoPutIn(actor) = {}
  ioPutIn(actor, dobj) = {
    if (!dobj.isIn(Me)) 
      "You're not carrying <<dobj.thedesc>>. ";
    else {
      "You drop <<dobj.thedesc>> in the circle. ";
      dobj.moveInto(sandyCircle);
    }
  }
;

sand: fixeditem
  sdesc = "sand"
  noun = 'sand'
  location = sandyCircle
  ldesc = "The sand is smooth and quite comfortable to the touch. "
  takedesc = "It slips through your fingers, alas. "
  touchdesc = "The sand is smooth and quite comfortable to the touch. "
  verDoDig(actor) = { "You dig for a bit, but find nothing. "; }
  verIoDigWith(actor) = { "You dig for a bit, but find nothing. "; }
  verDoDigWith(actor, dobj) = { "You dig for a bit, but find nothing. ";}
  verIoPutIn(actor) = {}
  ioPutIn(actor, dobj) = {
    if (!dobj.isIn(Me)) 
      "You're not carrying <<dobj.thedesc>>. ";
    else {
      "You drop <<dobj.thedesc>> in the circle. ";
      dobj.moveInto(sandyCircle);
    }
  }
;

hareSandDaemon: function(parm)
{
  if (Me.location <> sandyCircle) return;
  if (earlobe.location <> sandyCircle)
    "\bThe Hare spies you and tugs upon its ear! ";
  if (heart.location <> sandyCircle)
    "\bThe Hare spies you and beats upon its chest! ";
  if (vial.location <> sandyCircle)
    "\bThe Hare spies you and chortles while holding its sides! ";
  if ((earlobe.location = sandyCircle) and (heart.location = sandyCircle) and
      (vial.location = sandyCircle)) {
    remdaemon(hareSandDaemon,nil);
    "\bThe Hare leaps from the other side of the plains, and into the circle with you!\b
    The Hare sniffs and collects the items in the circle.
    It holds them within its hands, and regards you with a cruel, guttural sounding.\b
    <q>I laughed myself into fits over that foul juwess. The last job,
    well, was nice and clean but not this one (I love it, so.) Where
    to find a Christmas box, then? I suppose I will have to give you a 
    running start as I fit myself the box instead.</q>\b
    The Hare drops the killing knife.\b
    The snake twists its head until it is in your vision. It does not look very content. ";
    earlobe.moveInto(hare);
    heart.moveInto(hare);
    vial.moveInto(hare);
    hare.moveInto(sandyCircle);
    knife.moveInto(sandyCircle);
    hare.itemsCnt := 1;
    farHare.moveInto(nil);
    hare.hasItems := true;
    setdaemon(hareItemsDaemon,nil);
  }
}

hareItemsDaemon: function(parm)
{
  switch(hare.itemsCnt++) {
    case 1:
      "\bThe Hare rips apart the earlobe and sets each piece within his furry ears. ";
      earlobe.moveInto(nil);
      break;
    case 2:
      "\bThe Hare rips open a bit of its flesh, right above the hip, and inserts the kidney. ";
      vial.moveInto(nil);
      break;
    case 3:
      if (Me.location = sandyCircle or Me.location = farEnd)
        "\bThe Hare swallows the heart! ";
      heart.moveInto(nil);
      break;
    case 4:
      if (Me.location = sandyCircle)
        hareCaughtYou();
      else if (Me.location = farEnd)
        "\bThe Hare is chasing you. ";
      else if (Me.location = oneE)
        "\bYou look over your shoulder in horror -- it appears as if the Hare has entered through the Portal. ";
      break;
    case 5:
      if (Me.location = sandyCircle or Me.location = farEnd)
        hareCaughtYou();
      remdaemon(hareItemsDaemon,nil);
      hare.chaseCnt := 0;
      setdaemon(hareChaseDaemon, nil);
      Me.searchMsgCnt := 1;
      Me.catchhMsgCnt := 1;
      Me.hareChasing := true;
      "\bThe Hare rushes at you, from far away, but is knocked down by something in the fog! ";
      break;
  }
}
hareChaseDaemon: function(parm)
{
  "\b"; // every turn prints something so force blank line here...
//  "cnt = <<hare.chaseCnt>>\b";
  switch(hare.chaseCnt++) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      displaySearchMessage();
      break;
    case 5:
      if (!Me.catch1shown) {
        Me.catch1shown := true;
        "You cannot see the Hare, but you can detect his scent -- he is not
        particularly far away, of course, but he did just seem to get closer. ";
      }
      else
        "The Hare spots you! He's coming closer! ";
      break;
    case 6:
      if (!Me.catch2shown) {
        Me.catch2shown := true;
        "You're overcome by the filthy stench of foul murder!\b
        The Hare's scent has grown more powerful. He is nowhere to be seen,
        but he is quite close to you. ";
      }
      else
        "The Hare is still on your trail! He's not letting up for even a moment! ";
      break;
    case 7:
      if (!Me.catch3shown) {
        Me.catch3shown := true;
        "You can feel hoarse breath upon your shoulders. As your eyes dart
        from side to side, you see snippets of the terrible Hare, quietly now, stalking you,
        moving close, smug within its stealth... ";
      }
      else
        "The Hare jumps upon a square and giggles in glee -- he is now closing in on you! ";
      break;
    case 8:
      hareCaughtYou();
      break;
  }
}

displaySearchMessage: function
{
  switch(Me.searchMsgCnt++) {
    case 1:
      "You spot the Hare, for just a moment, but he is far behind you. ";
      break;
    case 2:
      "The Hare twitches loudly -- you pinpoint his location, and he is far away. ";
      break;
    case 3:
      "The Hare mewls just for a bit, but long enough for you to place his position...\ and it is not very close. ";
      break; 
    case 4:
      "The Hare brushes away fog in an attempt to find you. He is several squares away. ";
      break; 
    case 5:
      "The Hare pops up from the fog for a moment, luckily he is nowhere near you.";
      break; 
    case 6:
      "You hear nothing, now, out of the ordinary. ";
      break; 
    case 7:
      "The Hare has apparently lost your trail. ";
      break; 
    case 8:
      "Everything seems still. Not <i>too</i> still...\ no, simply a perfect, tranquil still. ";
      break; 
    case 9:
      "You sniff the air, for just a trace of the Hare...\ but detect nothing. ";
      break; 
    case 10:
      "The Hare cannot quite stop his stomach from rumbling. You hear it, but it is off into the distance. ";
      break; 
    case 11:
      "The scent of congealed blood and damp fur is still present, but quite faint. ";
      break; 
    default:
      hare.chaseCnt := 5;      // force to chasing messages
      Me.catch1shown := true;  // first 'catching' message is below
      "You cannot see the Hare, but you can detect his scent -- he is not
      particularly far away, of course, but he did just seem to get closer. ";
      break; 
  }
}

hareCaughtYou: function
{
  "\bThe Hare catches up to you, finally, and holds you within its grasp.\b
  Without turning you around, he speaks softly into your ear...\b
  <q>Was not that jolly a scare, eh? I laughed myself into fits over that
  woman, for I have got a jolly lot of false whiskers and fur in my own
  black bag. The last job was nice and clean -- I carried away three
  parts of her (conundrum try to find what parts, lo I guess you did). \b
  I am going to do another on Friday & shall give the johnnies and dons
  a running on and about once more...</q>\b
  Its break is hot, it reeks of salted iron, of strong scented sweat.\b
  Struggles result in only further pressing, and you pass out...\ and that
  is for the best, for now. ";
  Me.undoOK := true;
  die();
}

knife: item
  sdesc = "killing knife"
  noun = 'knife'
  adjective = 'killing'
  ldesc = "It is a sleek knife, with a finely-honed cutting blade. "
  doTake(actor) = {
    if (!self.taken) {
      self.taken := true;
      "As you pick up the knife, the snake coils in fear.\b
      <q>No!</q> hisses the snake, <q>Together we can be so much stronger!</q> The
      snake tightens itself around you. <q>Besides, fat lot of good that will do!</q> ";
      self.moveInto(Me);
    }
    else
      inherited.doTake(actor);
  }
  verIoAttackWith(actor) = {}
  ioAttackWith(actor, dobj) = { self.ioCutWith(actor, dobj); }
  verIoCutWith(actor) = {}
  ioCutWith(actor, dobj) = {
    if (!self.isIn(Me))
      "You're not carrying <<self.thedesc>>. ";
    if (dobj = fakeCord)
      "What cord? ";
    else if (dobj = snake) {
      "The snake squeals in an icy indelight! \b
      You cut the snake to pieces with the killing knife. You find your breathing
      to be much less constricted. ";
      snake.moveInto(nil);
      remdaemon(snakeChatDaemon,nil);
      snake.dead := true;
    }
    else if (dobj = hare) {
      switch (rand(5)) {
        case 1:
          "The Hare parries your thrust! ";
          break;
        case 2:
          "The Hare blocks your thrust with the weapon! ";
          break;
        case 3:
          "The Hare dodges! ";
          break;
        case 4:
          "The Hare snickers at your feeble attempts at combat.  ";
          break;
        case 5:
          "You slice the Hare, but his wound seals instantly. He seems to have that quality about him. ";
          break;
      }
    }
    else if (dobj = Me)
      "The snake squeals in an icy indelight!\b
      <q>No, fool!</q>\ exclaims the snake, <q>You will only kill us both!</q> ";
    else 
      "You can't cut <<dobj.thedesc>> with <<self.thedesc>>. ";
  }
;

fakeCord: fixeditem
  sdesc = "cord"
  noun = 'cord' 'umbilical'
  location = snake
  ldesc = "What cord?"
  dobjGen(a, v, i, p) = {
    "What cord? ";
    exit;
  }
  iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

farEnd: room
  sdesc = "The Far End of the Plane"
  ldesc = {
    "Twisting through fog, you come to the beginnings of a cavern -- an
    approachable Portal through a rocky hill.  You can enter the cavern to the north. ";
    if (!self.seen) {
      self.seen := true;
      "\bYou look back to see the Hare spin round, as if looking for you. He then freezes;
      shocked that you are no longer here. ";
    }
  }
  noexit = { "The only path leads into the Portal. "; }
  north = { enterPortal(); }
  in = (self.north)
  isOutside2 = true
;

sandyCircleItem3: fixeditem
  sdesc = "Sandy Circle"
  noun = 'circle'
  adjective = 'sandy'
  location = farEnd
  ldesc = "It appears to be a flattened sphere of sand. "
  verDoEnter(actor) = { self.verDoBoard(actor); }
  doEnter(actor) = { self.doBoard(actor); }
  verDoBoard(actor) = {}
  doBoard(actor) = { enterCircle(); }
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
;

portal: fixeditem
  sdesc = "portal"
  noun = 'portal' 'cavern'
  location = farEnd
  ldesc = "The Portal is wide enough for your entry -- and possibly someone a little larger. "
  verDoEnter(actor) = {}
  doEnter(actor) = { self.doBoard(actor); }
  verDoBoard(actor) = {}
  doBoard(actor) = { enterPortal(); }
  verDoLookin(actor) = { "In the distance, inside the cavern, you see tiles. "; }
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached to the rocky hill. "
;

portalTiles: distantItem
  sdesc = "tiles"
  noun = 'tiles' 'tile'
  location = farEnd
  ldesc = "The <<self.sdesc>> <<self.isntdesc>> are in the cavern. "
  isThem = true
;

rockyHill: fixeditem
  sdesc = "rocky hill"
  noun = 'hill'
  adjective = 'rocky'
  location = farEnd
  ldesc = "The hill extends several miles above your head... Tufts of mountain flakes and rock
          form the outer exterior -- certainly, climbing it would be far beyond your abilities. "
  verDoClimb(actor) = { "It is too expansive for you to climb. "; }
  verDoClimbover(actor) = { "It is too expansive for you to climb. "; }
  verDoClimbup(actor) = { "It is too expansive for you to climb. "; }
;

enterPortal: function
{
  "You enter the Portal and walk through a very slight, open chasm. After a few feet of this,
  the Portal opens up and you find yourself within a gaping, endlessly high, foul cavern. 
  Stalagmites rise from the cave's floor, but you can see no corresponding rocky growths from
  above -- whatever ceiling that is available is shrouded in shimmering light and silky vapour.\b
  The exit is to the north, on the other side of the Portal, that you can plainly see.\b
  Sixty-four squares, arranged in a flat 8 by 8 grid with an alternating black and
  white color scheme are in your way, covering the ground between entrance and exit. You see
  that a fair number of them -- at least a dozen -- are occupied by unmoving figures
  before more fog descends upon you.\b
  You pause for just a moment and hear echoes of the Hare's voice.\b
  The Hare is begging you -- desperately pleading with you -- from far away to please, please share a square.
  His ruse in that, though, is pathetically transparent and you instinctively feel him repulsed by this place.\b ";
  Me.undoOK := true;  // allow UNDO for all deaths
  Me.travelTo(oneE);
  Me.noWinnableVerb := true; // disable for rest of game.
}

class chessRoom: room
  ldesc = {
    if (!self.seen) {
      "You have moved onto a square. It is ";
      self.seen := true;
    }
    else 
      "You are standing in the middle of a square.  It is ";
    if (self.isBlack) "black"; else "white";
    ".\b  <<self.paths>> ";
    if (self.nearPawn) 
      "\bTo the <<self.pawnWhere>> is an inanimate render of a warrior footsman.";
    if (self.nearRook) 
      "\bA towering, foreboding castle is to the <<self.rookWhere>>. ";
    if (self.nearKnight) 
      "\bTo the <<self.knightWhere>> is a knight on horseback, frozen in time. ";
    if (self.nearBishop) 
      "\bTo the <<self.bishopWhere>> is a mild statue, depicting a sneering, bookish, fundamentalist. ";
    if (self.nearQueen) 
      "\bFoul, ultraviolet strobes of light illuminate your way, coming from the pelt-wrapped and slender overlord to the <<self.queenWhere>>. ";
    if (self.nearKing) 
      "\bShimmering, majestic light sprays outwards in a rainbow of colors from the statue of the cruel overlord to the <<self.kingWhere>>. ";
  }
  noexit = { "There is no path in that direction. "; }  //NE, SW, SE, NW, UP and DOWN
;

pawnDeathRoom: room
  sdesc = "Footsman's Square"
  dispParagraph = "\b"
  ldesc = {
    "There does not seem to be enough space for both you and the footsman on the square. 
    The footsman moves in flashes -- you see static images in a strobe effect of it 
    attempting to move backwards, and to the side, but it cannot.\b 
    Out of desperation for its own self, the footsman buries its pike into your chest. 
    You fall into a crumpled, broken heap upon the slick tile. ";
    die();
  }
;

rookDeathRoom: room
  sdesc = "The Castle's Square"
  dispParagraph = "\b"
  ldesc = {
    "The castle topples!\b
    The castle falls upon you, crushing you underneath tons of thick, horrible stone! ";
    die();
  }
;

knightDeathRoom: room
  sdesc = "Knight's Square"
  dispParagraph = "\b"
  ldesc = {
    "The handsome, parfait knight never worries, never lacks\n
    Strength of courage, or convictions -- these are the things he backs\n
    And to demonstrate this mettle, he strikes you with his green axe\n ";
    die();
  }
;

bishopDeathRoom: room
  sdesc = "Overlord's Square"
  dispParagraph = "\b"
  ldesc = {
    "You attempt to enter the square that the overlord has already claimed.\b
    The statue makes no sound. It does not engage in motion. Nothing supernatural happens in the least. \b
    ...\ which does nothing to alleviate the shock of your death. ";
    die();
  }
;

queenDeathRoom: room
  sdesc = "Queen's Square"
  dispParagraph = "\b"
  ldesc = {
    "You step into the square of the queen. There is no horror, there is no beast ready to rip you apart
    and splash your entrails upon the tiles.\b
    Only peace. And it is wonderful, of course, and it fills you with complete content...\b
    But it is in no way life. It never could be. ";
    die();
  }
;

kingDeathRoom: room
  sdesc = "King's Square"
  dispParagraph = "\b"
  ldesc = {
    "The lion comes to life.\b
    He gently picks you up and places you ontop of his broad shoulders. With a powerful, musical keen
    he shakes away the exterior to the cavern. Various other statues crumble into dust. He begins a slight
    trot -- on air itself!\ -- and carries you up, into the air, through swirling, purple clouds, into a 
    kingdom only of love, free from any kind of want.\b
    And it is all you ever know. ";
    die();
  }
;

class chessPiece: distantItem, floatingItem
  dobjGen(a, v, i, p) = {
    if (v <> inspectVerb) {
      "The <<self.sdesc>> is too far away. ";
      exit;
    }
  }
  iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

footsman: chessPiece
  sdesc = "footsman"
  noun = 'footsman' 'pawn' 'soldier'
  adjective = 'warrior' 'small' 'light'
  location = { if (Me.location.nearPawn) return Me.location; }
  ldesc = "The footsman render is that of a small, light soldier. He holds light armor and a small pike. "
;

footsmanItems: chessPiece
  sdesc = "armor and small pike"
  noun = 'pike'
  adjective = 'armor' 'small'
  ldesc = "It belongs to the footsman. "
  location = { if (Me.location.nearPawn) return Me.location; }
;  

castle: chessPiece
  sdesc = "castle"
  noun = 'castle' 'rook'
  location = { if (Me.location.nearRook) return Me.location; }
  ldesc = "The castle seems to reach the top of the cavern, but it takes up no more space
          than the surface area of a single square. "
;

bishop: chessPiece
  sdesc = "statue"
  noun = 'statue' 'bishop'
  adjective = 'mild'
  location = { if (Me.location.nearBishop) return Me.location; }
  ldesc = "You see that the overlord is simply a lifelike statue, like many of the denizens
          that exist in the cavern. He is dressed in flowing white robes, has a slight pair
          of glasses resting on the bridge of his nose, and both hands carry a thick, ivory tome. "
;

bishopItems: chessPiece
  sdesc = "bishop's possessions"
  noun = 'robes' 'robe' 'glasses' 'nose' 
  adjective = 'white' 'flowing' 'bridge'
  ldesc = "That's just a part of the statue. "
  location = { if (Me.location.nearBishop) return Me.location; }
  dobjGen(a, v, i, p) = {
    if (v <> inspectVerb) {
      "The <<self.sdesc>> are too far away. ";
      exit;
    }
  }
  iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;  

bishopTome: chessPiece
  sdesc = "ivory tome"
  noun = 'tome'
  adjective = 'ivory'
  location = { if (Me.location.nearBishop) return Me.location; }
  ldesc = "The tome has a title that simply reads 'PERSECUTION'. "
  verDoRead(actor) = { self.ldesc; }
;

knight: chessPiece
  sdesc = "knight"
  noun = 'knight' 'horse' 'horseback'
  location = { if (Me.location.nearKnight) return Me.location; }
  ldesc = "He is 'A handsome, parfait knight, great-muscled, fit and slim.\n
          Almost a giant in height, and long and straight of limb.\n
          Clad all in green is he, and green his skin and hair.\n
          His eyebrows are mossy, bright emerald his stare.\n
          No shield, helm or plastron, nor bright chain mail has he.\n
          Of armour he has none. Just, in one hand, holly.\n
          Storm-like and strong, he seems. And swift to strike and stun.\n
          Dreadful his blows, one deems. Once dealt, true death has come.' "
;

king: chessPiece
  sdesc = "king"
  noun = 'king' 'lion'
  adjective = 'cruel'
  location = { if (Me.location.nearKing) return Me.location; }
  ldesc = "He is a glorious, golden lion, ruling every being within his realm. "
;

queen: chessPiece
  sdesc = "queen"
  noun = 'queen'
  adjective = 'slender'
  location = { if (Me.location.nearQueen) return Me.location; }
  ldesc = "She is here, but not in tangible form. She is the mother, she is the earth, she is caretaker of 
          this world. She is an idea, a concept that has just now chosen to manifest itself. "
;

class chessRoomBlack: chessRoom
  sdesc = "Black Square"
  isBlack = true
;

class chessRoomWhite: chessRoom
  sdesc = "White Square"
  isWhite = true
;

blackSquare: fixeditem, floatingItem
  sdesc = "black square"
  noun = 'square'
  adjective = 'black'
  location = { if (Me.location.isBlack) return Me.location; }
  ldesc = "It is black. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
;

whiteSquare: fixeditem, floatingItem
  sdesc = "white square"
  noun = 'square'
  adjective = 'white'
  location = { if (Me.location.isWhite) return Me.location; }
  ldesc = "It is white. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
;

oneA: chessRoomBlack
  noSouth = true
  noWest = true
  east = oneB
  north = {
    checkLevel2();
    return twoA;
  }
  paths = 'Paths lead north and east. '
;

oneB: chessRoomWhite
  noSouth = true
  west = oneA
  east = oneC
  north = {
    checkLevel2();
    return twoB;
  }
  paths = 'Paths lead north, east and west. '
;

oneC: chessRoomBlack
  dieNorth = true
  north = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'north'
  noSouth = true
  east = oneD
  west = oneB
  paths = 'Paths lead east and west. '
;

oneD: chessRoomWhite
  dieNorth = true
  north = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'north'
  noSouth = true
  east = oneE
  west = oneC
  paths = 'Paths lead east and west. '
;

oneE: chessRoomBlack
  dieNorth = true
  north = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'north'
  south = { "That way is no longer possible. "; }
  east = oneF
  west = oneD
  paths = 'Paths lead east and west. '
;

oneF: chessRoomWhite
  dieNorth = true
  north = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'north'
  noSouth = true
  east = oneG
  west = oneE
  paths = 'Paths lead east and west. '
;
  
oneG: chessRoomBlack
  noSouth = true
  east = oneH
  north = {
    checkLevel2();
    return twoG;
  }
  west = oneF
  paths = 'Paths lead north, east and west. '
;

oneH: chessRoomWhite
  noSouth = true
  noEast = true
  north = {
    checkLevel2();
    return twoH;
  }
  west = oneG
  paths = 'Paths lead north and west. '
;

twoA: chessRoomWhite
  noWest = true
  east = twoB
  north = {
    checkLevel3();
    return threeA;
  }
  south = oneA
  paths = 'Paths lead north, east and south. '
;

twoB: chessRoomBlack
  dieEast = true
  east = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'east'
  west = twoA
  north = {
    checkLevel3();
    return threeB;
  }
  south = oneB
  paths = 'Paths lead north, west and south. '
;

twoG: chessRoomWhite
  dieWest = true
  west = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'west'
  south = oneG
  north = {
    checkLevel3();
    return threeG;
  }
  east = twoH
  paths = 'Paths lead north, east and south. '
;

twoH: chessRoomBlack
  noEast = true
  north = {
    checkLevel3();
    return threeH;
  }
  west = twoG
  south = oneG
  paths = 'Paths lead north, west and south. '
;

threeA: chessRoomBlack
  dieNorth = true
  nearRook = true
  north = rookDeathRoom
  rookWhere = 'north'
  noWest = true
  east = threeB
  south = twoA
  paths = 'Paths lead east and south. '
;

threeB: chessRoomWhite
  west = threeA
  east = threeC
  north = {
    checkLevel4();
    return fourB;
  }
  south = twoB
  paths = 'Paths lead north, south, east and west. '
;

threeC: chessRoomBlack
  dieSouth = true
  south = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'south'
  east = threeD
  west = threeB
  north = {
    checkLevel4();
    return fourC;
  }
  paths = 'Paths lead north, east and west. '
;

threeD: chessRoomWhite
  dieSouth = true
  south = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'south'
  east = threeE
  west = threeC
  north = {
    checkLevel4();
    return fourD;
  }
  paths = 'Paths lead north, east and west. '
;

threeE: chessRoomBlack
  dieSouth = true
  south = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'south'
  east = threeF
  west = threeD
  north = {
    checkLevel4();
    return fourE;
  }
  paths = 'Paths lead north, east and west. '
;

threeF: chessRoomWhite
  dieSouth = true
  south = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'south'
  east = threeG
  west = threeE
  north = {
    checkLevel4();
    return fourF;
  }
  paths = 'Paths lead north, east and west. '
;

threeG: chessRoomBlack
  west = threeF
  east = threeH
  north = {
    checkLevel4();
    return fourG;
  }
  south = twoG
  paths = 'Paths lead north, south, east and west. '
;

threeH: chessRoomWhite
  dieNorth = true
  north = rookDeathRoom
  nearRook = true
  rookWhere = 'north'
  noEast = true
  west = threeG
  south = twoH
  paths = 'Paths lead west and south. '
;

fourB: chessRoomBlack
  dieNorth = true
  north = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'north'
  dieWest = true
  west = rookDeathRoom
  nearRook = true
  rookWhere = 'west'
  east = fourC
  south = threeB
  paths = 'Paths lead east and south. '
;

fourC: chessRoomWhite
  north = {
    checkLevel5(true);
    return fiveC;
  }
  east = fourD
  west = fourB
  south = threeC
  paths = 'Paths lead north, south, east and west. '
;

fourD: chessRoomBlack
  north = {
    checkLevel5(nil);
    return fiveD;
  }
  east = fourE
  west = fourC
  south = threeD
  paths = 'Paths lead north, south, east and west. '
;                                  

fourE: chessRoomWhite
  north = {
    checkLevel5(true);
    return fiveE;
  }
  east = fourF
  west = fourD
  south = threeE
  paths = 'Paths lead north, south, east and west. '
;

fourF: chessRoomBlack
  north = {
    checkLevel5(nil);
    return fiveF;
  }
  east = fourG
  west = fourE
  south = threeF
  paths = 'Paths lead north, south, east and west. '
;

fourG: chessRoomWhite
  dieNorth = true
  north = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'north'
  dieEast = true
  east = rookDeathRoom
  nearRook = true
  rookWhere = 'east'
  west = fourF
  south = threeG
  paths = 'Paths lead west and south. '
;

fiveA: chessRoomBlack
  dieEast = true
  east = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'east'
  dieSouth = true
  south = rookDeathRoom
  nearRook = true
  rookWhere = 'south'
  noWest = true
  north = sixA
  paths = 'You have reached a dead end.  The only path is back north. '
;

fiveC: chessRoomBlack
  dieWest = true
  west = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'west'
  south = fourC
  north = {
    checkLevel6();
    return sixC;
  }
  east = fiveD
  paths = 'Paths lead north, east and south. '
;

fiveD: chessRoomWhite
  dieNorth = true
  north = queenDeathRoom
  nearQueen = true
  queenWhere = 'north'
  east = fiveE
  west = fiveC
  south = fourD
  paths = 'Paths lead east, west and south. '
;

fiveE: chessRoomBlack
  dieNorth = true
  north = kingDeathRoom
  nearKing = true
  kingWhere = 'north'
  east = fiveF
  west = fiveD
  south = fourE
  paths = 'Paths lead east, west and south. '
;

fiveF: chessRoomWhite
  dieEast = true
  east = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'east'
  south = fourF
  north = {
    checkLevel6();
    return sixF;
  }
  west = fiveE
  paths = 'Paths lead north, west and south. '
;

fiveH: chessRoomWhite
  dieWest = true
  west = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'west'
  dieSouth = true
  south = rookDeathRoom
  nearRook = true
  rookWhere = 'south'
  noEast = true
  north = sixH
  paths = 'You have reached a dead end.  The only path is back north. '
;

sixA: chessRoomWhite
  dieNorth = true
  north = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'north'
  noWest = true
  east = sixB
  south = fiveA
  paths = 'Paths lead east and south. '
;

sixB: chessRoomBlack
  dieSouth = true
  south = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'south'
  east = sixC
  west = sixA
  north = {
    checkLevel7();
    return sevenB;
  }
  paths = 'Paths lead north, east and west. '
;

sixC: chessRoomWhite
  dieEast = true
  east = queenDeathRoom
  nearQueen = true
  queenWhere = 'east'
  west = sixB
  north = {
    checkLevel7();
    return sevenC;
  }
  south = fiveC
  paths = 'Paths lead north, west and south. '
;

sixF: chessRoomBlack
  dieWest = true
  west = kingDeathRoom
  nearKing = true
  kingWhere = 'west'
  east = sixG
  north = {
    checkLevel7();
    return sevenF;
  }
  south = fiveF
  paths = 'Paths lead north, east and south. '
;

sixG: chessRoomWhite
  dieSouth = true
  south = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'south'
  east = sixH
  west = sixF
  north = {
    checkLevel7();
    return sevenG;
  }
  paths = 'Paths lead north, east and west. '
;

sixH: chessRoomBlack
  dieNorth = true
  north = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'north'
  noEast = true
  west = sixG
  south = fiveH
  paths = 'Paths lead west and south. '
;

sevenB: chessRoomWhite
  dieNorth = true
  north = knightDeathRoom
  nearKnight = true
  knightWhere = 'north'
  dieWest = true
  west = pawnDeathRoom
  pawnWest = true
  east = sevenC
  south = sixB
  paths = 'Paths lead east and south. '
;

sevenC: chessRoomBlack
  dieNorth = true
  north = bishopDeathRoom
  nearBishop = true
  bishopWhere = 'north'
  east = sevenD
  west = sevenB
  south = sixC
  paths = 'Paths lead south, east and west. '
;

sevenD: chessRoomWhite
  dieSouth = true
  south = queenDeathRoom
  nearQueen = true
  queenWhere = 'south'
  north = {
    checkLevel8();
    return eightD;
  }
  east = sevenE
  west = sevenC
  paths = 'Paths lead north, east and west. '
;

sevenE: chessRoomBlack
  dieSouth = true
  south = kingDeathRoom
  nearKing = true
  kingWhere = 'south'
  north = {
    checkLevel8();
    return eightE;
  }
  east = sevenF
  west = sevenD
  paths = 'Paths lead north, east and west. '
;

sevenF: chessRoomWhite
  dieNorth = true
  north = bishopDeathRoom
  nearBishop = true
  bishopWhere = 'north'
  east = sevenG
  west = sevenE
  south = sixF
  paths = 'Paths lead south, east and west. '
;

sevenG: chessRoomBlack
  dieNorth = true
  north = knightDeathRoom
  nearKnight = true
  knightWhere = 'north'
  dieEast = true
  east = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'east'
  west = sevenF
  south = sixG
  paths = 'Paths lead west and south. '
;

eightD: chessRoomBlack
  dieWest = true
  west = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'west'
  south = sevenD
  north = farSide
  east = eightE
  paths = 'Paths lead north, west and south. '
;

eightE: chessRoomWhite
  dieEast = true
  east = pawnDeathRoom
  nearPawn = true
  pawnWhere = 'east'
  south = sevenE
  north = farSide
  west = eightD
  paths = 'Paths lead north, west and south. '
;

endFarPortal: fixeditem, floatingItem
  sdesc = "Portal"
  noun = 'portal' 
  location = { if (Me.location = eightD or Me.location = eightE) return Me.location; }
  ldesc = "The Portal is to the north. "
  verDoEnter(actor) = { "It's too far away. "; }
  verDoBoard(actor) = { "It's too far away. "; }
  verDoLookin(actor) = { "You can't make anything out. "; }
  takedesc = "The <<self.sdesc>> <<self.isdesc>> is beyond your grasp. "
;

//No, not the cartoon
farSide: room
  sdesc = "Far Side of the Portal"
  ldesc = {
    if (!self.seen) {
      self.seen := true;
      "You take the final step off the layer of tiles and onto the far Portal side. \b
      The Hare begins to wail: a shivering, desperate keen fueled by its horrible capacity for the hunt. It
      has failed, it has lost. It begins tearing fur from its body in thick clumps and patches, throwing them
      helter-skelter around the tiles, until the craggy flesh beneath is revealed.\b
      With a moaning sound of 'o' it hunches over, falls to one knee, and sets a sliding hand out in
      a vain attempt to keep itself from knocking against the polished tile...\ it collapses and
      makes no further movement.\b ";
      remdaemon(hareChaseDaemon, nil);
    }
    "The Portal continues here, into nothingness. ";
  }
  noexit = { "You float about in that direction for a little bit, but are drawn against your will to this very spot. "; }
  in = (endPortal.doBoard(Me))
;

endPortal: fixeditem
  sdesc = "Portal"
  noun = 'portal' 
  location = farSide
  ldesc = "The Portal is wide enough for your entry -- but just barely. "
  verDoEnter(actor) = {}
  doEnter(actor) = { self.doBoard(actor); }
  verDoBoard(actor) = {}
  doBoard(actor) = { win(); }
  verDoLookin(actor) = { "You can't make anything out. "; }
  takedesc = "The <<self.sdesc>> <<self.isdesc>> is beyond your grasp. "
;

checkLevel2: function
{
  if (!Me.seenL2) {
    Me.seenL2 := true;
    "Fog concealing the Portal to the far side shifts for a moment. Fragments of images
    play upon the revealed backdrop. A timeslash of your father arriving home, removing his 
    tie -- up only for a moment. It cuts away to your mother mixing paint. Your parents
    meet, embrace. Your father paints a red clown's nose upon your mother, she letters,
    slowly, 'MINE' upon your father's body, a clever smirk upon her lips... you see them 
    laugh, you see them simply enjoying the company of one another and play before the fog returns 
    anew and all images fade. \b";
  }
}

checkLevel3: function
{
  if (!Me.seenL3) {
    local shotType;
    Me.seenL3 := true;
    game.handle := fopen('pc1.glf', 'r');
    if (game.handle = nil)
      shotType := 'W';
    else {
      shotType := fread(game.handle);
      fclose(game.handle);
    }
    "You see a static scene in the swirling fog -- your father striking a small projectile ";
    if (shotType = 'W')
      "straight on. The fog morphs to a second, animated, scene:\ a ball ripping through 
      the heart of a foul beast.\b
      You can hear the Hare yell in pain to the south, and turn to look briefly back. ";
    else if (shotType = 'H')
      "that has been shunted to the left. The fog morphs to a second, now animated, scene:\ a ball
      ripping through the ears of a foul beast.\b
      You can hear the Hare yell in agony to the south, and turn to look briefly back. ";
    else 
      "that has been shunted to the right. The fog morphs to a second, now animated, scene:\ a ball
      ripping through the body of a foul beast, just off-center.\b
      You can hear the Hare exclaim in a stunted shock of pain to the south, and turn to look back. ";
    "\bYou are unable to find the Hare, and returning your view to the north, you see that the fog
    is no longer forming moving pictures.\b";
  }
}

checkLevel4: function
{
  if (!Me.seenL4) {
    Me.seenL4 := true;
    "Appearing directly before you is a phantom of your mother, no more than a shimmering curtain of
    light. Her eyes are cast downwards to her belly, where you still grow.\b
    <q>You can't possibly want another one,</q> she says softly.\b
    BUT MOTHER I CAN!\b
    The scene resets, it plays again.\b
    <q>You can't possibly want another one,</q> she says softly.\b
    I'M NOT A BUTCHER!\b
    The scene resets one final time, and again it plays.\b
    <q>You can't possibly want another one,</q> she says softly.\b
    CUT, IN HARE TOMB! CUT, IN HARE TOMB! \b
    The words struggle to find audience, none seems apparent. \b
    The phantom of light switches quickly into the ether, the nothingness.\b";
  }
}

checkLevel5: function(squareBlack)
{
  if (!Me.seenL5) {
    Me.seenL5 := true;
    if (squareBlack)
      "The white squares rise up from the floor. Fog smears upon the tiles to form depth, and you 
      see a the slight outline of a snowing man.  The tiles shift to form the symbol for a 'heart' 
      before violently falling back where they were, upon the ground. \b";
    else
      "The white squares (all but yours) rise up from the floor. Fog smears upon the tiles to form 
      depth, and you see a the slight outline of a snowing man.  The tiles shift to form the symbol 
      for a 'heart' before violently falling back where they were, upon the ground.\b ";
  }
}

checkLevel6: function
{
  if (!Me.seenL6) {
    Me.seenL6 := true;
    "A pretty, spectacled nurse, seemingly whole and real, arrives from behind
    and places two fingers against the pulse in your neck. She attempts a soothing
    coo when a growing mound of snow, a horrible, sentient mass of winter staggers
    towards her with blood-soaked, crimson-dripping paws. She runs away to the north,
    rapidly shunting herself and her pursuer into and out of your reality...\b";
  }
}

checkLevel7: function
{
  if (!Me.seenL7) {
    Me.seenL7 := true;
    "The fog is brighter, now. It forms grayscaled sights of a man, a healer,
    at least a decade older than your own father, bringing down a terrible demon
    with a wave of his hands...\ he fells wave after wave of similar horrors in 
    what seems no time at all before dropping dead as he first locks eyes with 
    a biting, clawing, fatted jabberwocky...\b";
  }
}

checkLevel8: function
{
  if (!Me.seenL8) {
    Me.seenL8 := true;
    "And you feel so close! And your body feels so warm, your blood so full of vibrant life! 
    And the fog draws back like a commanded curtain; seven and six men are revealed! 
    And they wave their hands in menacing manner, so aloof of this world. \b
    Three earthly organs make up their sacrifice -- a scanned ultrasound in the center of 
    their circle. One holds a gleaming, leathered sphere of his own, scratching notes upon it, 
    as a chanting jack builds from the others into a gushing crescendo. \b
    The orb is cast from their circle, and the fog is gone forever. \b
    The Portal is now before you, one step to the north.\b";
  }
}

win: function
{
  "You take leave and jump yourself into the Portal. You feel a light sensation of freefall through complete
  darkness before the tears overtake you...\ everything shifts to warmth, to light...\b";
  "<b>Operating Room</b>\b
  <q>She's going to -- I think that, yes...</q>\ says the Doctor.\b
  The nurse adjusts her frames and peers onto the operating table. <q>Oh, my, look at her neck -- </q>\b
  <q>It just split, I barely touched it with the scalpel,</q> whispers the Doctor. <q>Never quite...\ well,
  fortunate, nonetheless.</q> He gently brings the baby up and lifts away the umbilical cord. He
  motions over to you.\b
  You break out of your stunned stupor and shamble over to the operating table.\b
  <q>Mr.\ Scott,</q> says the Doctor, <q>I think that both your wife and the baby are going to be alright
  after all...</q> He seems temporarily distant to you, what with his deep sweating and cool demeanor.\b
  <q>Everything is...\ everything is okay?</q>\ you ask.\b
  <q>Kieron -- it's Kieron, correct?</q> You nod. <q>I have to say it was touch and go there for a while, I wasn't
  particularly optimistic...</q>\ his voice softens to a near mumble, as he studies one edge of the umbilical
  cord. <q>And it certainly wasn't a break, I don't think, it was so smooth if so, and...</q>\ the doctor sees you
  fretting again and displays a hearty, genuine smile. \b
  <q>Congratulations,</q> he says. <q>It's a girl.</q>\b
  You cradle your still-unconscious wife in your arms with your little baby girl by her side for just a moment
  before the nurse begs you away so that Charlise can get her stitches. Charlise is going to be so happy when 
  she recovers, you think. \b
  You look upon your daughter, ";
  switch(rand(3)) {
    case 1:
      "Callista Jayne Scott";
      break;
    case 2:
      "Tessa Elizabeth Scott";
      break;
    case 3:
      "Talia Elizabeth Scott";
      break;
  }
  ", seven pounds six ounces. Has her mother's eyes alright, and
  a few stringy wisps of yellow hair. And right before she, too, is whisked away so they can ensure that she 
  is going to be alright, you swear to yourself that in between catches of newfound tears you see her sigh 
  contentedly for what seems like ever, smile knowingly and let out a tiny, ecstatic squeal. ";
  Me.finished := true;
  updateGameState('A');
// Allow AMUSING verb to work from now on.  
  game.handle := fopen('ntts.won', 'w'); 
  fwrite(game.handle, ' ');
  fclose(game.handle);
  amusingVerb.allowed := true;
  die();
}

