/*
No Time To Squeal.  Main file.

Copyright Mike J. Sousa 9/28/2001, 3/17/03.  ALL RIGHTS RESERVED

The source code is made available "as is", use at your own risk. 

NOTE: Not all of the source code is contained in the ZIP file.  I did not include
ADV.T and STD.T (even though a couple of things were modified there) and I did not
include NTTS_INI.T which contains the verbs/actions and meta-commands for NTTS.
Finally, none of the excellent ALT Library files are included.  If you have any
questions, etc, give me a shout.  -- Mike 3/17/03  
*/

#define USE_HTML_STATUS                 // Needs to be setup 
#define USE_HTML_PROMPT                 // Needs to be setup 

/* Constants for gettimesys */          // Using Kevin Forchione's routine from the ALT library
#define TS_DAY 'day'
#define TS_DATE 'date'
#define TS_TIME 'time'
#define TS_ELAPSE 'elapse'


#include <ntts_ini.t>                   // custom init code
#include <timesys.t>                    // use TIME not TURNS
#include <debug.t>                      // used for debuging (taken from archive)
#include <kieron.t>                     // 1st PC - Kieron
#include <charlise.t>                   // 2nd PC - Charlise
#include <nurse.t>                      // 3rd PC - Nurse
#include <doctor.t>                     // 4th PC - Doctor
#include <baby.t>                       // 3rd PC - Baby


game: object
  sdesc = "<b>No Time to Squeal</b>"
  handle = 0
  state = nil
;

// We need to figure out which character to start with.  Game defaults to Kieron.

getVersion: function
{
// open file for reading; file must already exist 
  game.handle := fopen('ntts.pc', 'r');
  if (game.handle = nil) { 
// create a new file for reading and writing; 
// the file is deleted if it already exist
    game.handle := fopen('ntts.pc', 'w'); 
    fwrite(game.handle, 'A');
    game.state := 'A';
    fclose(game.handle);
  }
  else {
    game.state := fread(game.handle);
    fclose(game.handle);
  }
  game.vernumb := 'Release 1.3 / Serial number 031703 / TADS 2.55';
  game.sdesc := '<b>No Time To Squeal</b>';
  showIntro(game.state);                     // display intro according to game state
  switch (game.state) {
    case 'A':
      Me.name := 'Kieron Scott';
      Me.display := Me.name;
      Me.whoDesc := 'You are an agent within the field of professional
                    sports, and just starting out with your own business. You are in your late 
                    twenties, are about 5\'10\", 175lbs and have blue eyes and black hair. ';
      golfClub.moveInto(Me);
      hiddenGolfBall.moveInto(Me);
      settimesys( '11:44 a.m.', 1, 2001, 10, 01 );
      parserGetMe().location := fairway;     // move player to initial location
      break;
    case 'B':
      Me.name := 'Charlise Scott';
      Me.display := Me.name;
      Me.whoDesc := 'Ordinarily you are 5\'7\" tall and slight of build, but since you are presently 
                    nine months pregnant your current figure is a little larger than that. You have 
                    light brown hair (quite like poured honey) and green eyes. ';
      settimesys( '09:40 a.m.', 1, 2001, 10, 01 );
      parserGetMe().location := comfyChair;  // move player to initial location
      dog.moveInto(bedroom);                 // move Watson to bedroom with Charlise
      intensity.moveInto(Me);                // move Dean Koontz book to inventory
      baby.moveInto(Me);
      break;
    case 'C':
      Me.name := 'Sarah Thompson, a registered nurse for the Saint Columbia Veteran\'s Hospital';
      Me.display := 'Sarah Thompson';
      Me.whoDesc := 'You\'re 24 years old and have dark hair and brown eyes beneath circular, Lennon-esque frames.'; 
      settimesys( '1:17 p.m.', 1, 2001, 10, 01 );
      parserGetMe().location := breakRoom;  // move player to initial location
      evian.moveInto(Me);
      chips.moveInto(Me);
      uniform.moveInto(Me);
      break;
    case 'D':
      Me.name := 'David McKinney, M.D';
      Me.display := 'A lost soul';
      Me.whoDesc := 'You are also, technically, a shade damned to existing within a classical Christian afterlife. ';
      settimesys( '3:15 a.m.', 1, 2017, 04, 30 );
      parserGetMe().location := hell;     // move player to initial location
      break;
    case 'E':
      Me.size := 0;                        // default to normal size
      Me.Ecnt := 1;                        // used for examine me (it changes -- see setBabyName()
      Me.name := 'Baby Scott';
      Me.display := 'A little girl';
      settimesys( '3:28 a.m.', 1, 2001, 10, 01 );
      parserGetMe().location := alley;     // move player to initial location
      break;
    default:
      "There is an internal error processing data.  Email the author. "; // should never happen
  }
// Only allow amusing verb to work if game has been won before    
    amusingVerb.handle := fopen('ntts.won', 'r');
    if (amusingVerb.handle <> nil) {
      amusingVerb.allowed := true;
      fclose(amusingVerb.handle);
    }
  
}
;
// Only used when PC is the baby
setBabyName: function
{     
  switch(Me.Ecnt++) {
    case 1:
      Me.whoDesc := 'A beautiful seven year old girl! ';
      break;
    case 2:
      Me.whoDesc := 'A beautiful seven year old girl!\n
      How old did you say you were? Six months, seven years? ';
      break;
    case 3:
      Me.whoDesc := 'A beautiful seven year old girl!\n
      How old did you say you were? Six months, seven years?\n
      With hair of striking auburn and flow of such slight curl? ';
      break;
    case 4:
      Me.whoDesc := 'A beautiful seven year old girl!\n
      How old did you say you were? Six months, seven years?\n
      With hair of striking auburn and flow of such slight curl?\n
      Innocence of brilliance, a slave to all my fears! ';
      Me.Ecnt := 1; // wrap around
      break;
  }
}

updateGameState: function(newState)             // Game has advanced, go to next game state
{
// create a new file for reading and writing; 
// the file is deleted if it already exist
  game.handle := fopen('ntts.pc', 'w'); 
  fwrite(game.handle, newState);
  game.state := newState;
  fclose(game.handle);
}

showIntro: function(whichState)                 // display opening scene, depending on game state
{      
  switch (whichState) {
    case 'A':
      "\tWhat sucks, about being the pro agent for a sociopathic defensive tackle like Tavarian Pittman, is the never-ending,
      ulcer-inducing, cloud of dark dread that seems to follow him and those that associate with him. Tavarian is a chiseled 
      6'4\", 313lb athletic monster -- he can run the 40 yard dash in 4.33 seconds, and can throw opposing players around
      the football field with ease. While playing, he is a whirling dervish of rage. Unfortunately, Tavarian displays that
      same kind of restraint in everyday life. \b
      \tFour months ago, he celebrated winning an award at the Nokia Sugar Bowl by crashing an off-campus party and proceeded to
      get roaring drunk with his friends. It was a theme party -- a pre-med student hosting it had a cadaver on display
      as the party's centerpiece. After drinking himself into an almost criminal level of intoxication, Tavarian and his friends
      started throwing the corpse around the house as if it were an old softball. Tavarian punched a hole through the back of
      the thing's neck and started a ventriloquist act in extremely poor taste.  \b
      \tAn attending film studies student had brought his camcorder with him and recorded the entire thing.\b
      \tIt made national headlines:\ Tavarian was called out by sports writers everywhere, denounced as an archdemon, and the
      summation of What's Wrong With Collegiate Sports. His nickname soon became 'The Ripper' when one beat writer wondered
      if his next act was in writing <q>Dear Boss</q> letters to the local paper. Tavarian had already declared for the NFL Pro Draft,
      so he had no option of returning to school and laying low until the incident blew over. He was likely to go completely undrafted,
      as no professional team could afford the PR hit they would take by selecting him. \b
      \tYou'd been trying to make it on your own as a sports agent for a while now. You love the independence of being your own boss, 
      you'd always loved sports and you wanted to be able to provide an affluent living for your wife and the baby that was 
      on the way...\ but it hasn't been easy. Becoming successful on your own has been a complete Catch-22 -- you need to sign a high-profile 
      client in order to make any real money, but no normal athlete wants to risk being your first big contract. \b
      \tTavarian was looking for an agent when you met him while scouting a winter baseball game a few months back. You had managed to 
      win a huge arbitration case for the backup shortstop on the Red Sox -- no small prize, considering the perennial all-star he 
      plays behind -- and you started to generate whispers that perhaps you had a talent for working miracles. Tavarian, who was in need of one,
      introduced both himself and his girlfriend Theresa during the game. You in turn introduced your wife, Charlise. Both girls were five 
      months pregnant with their first child and they completely hit it off. Charlise practically sold you herself, painting a glorious 
      picture of how hard you work and what a good soul you are -- essentially depicting you in the kind, glowing terms that she sees 
      you with everyday. \b
      \tTavarian expressed to you his desire to turn his life around and get drafted by an NFL team in April, and ultimately hired you that
      day.  Since then you have been working the circuit, trying to bend the ear of the 32 NFL general managers. It hasn't been easy -- 
      being away from your wife for most of the time has been excruciating, really -- and it didn't help when Tavarian spent a night 
      in jail after going berserk on some pizza delivery guy while Theresa was visiting her parents...\ but with a calming influence around 
      him 24/7 ever since, there have been no other problems. \b
      \tReally, he doesn't seem to be the psychotic harbinger of death that the media has painted him out to be. Not when you really get 
      to know him. ";
      break;
    case 'B':
      "<q>You can't possibly want another one.</q>\b
      <i>But Mother, I can!</i>\b
      <q>Oh, you *are* the fickle one, aren't you, Sweet Pea?</q>\b
      <i>O, I'm dainty!</i>\b
      <q>If I can not put up a reasoned, well-thought out resistance as to why we 
      should not be waddling our way over to the refrigerator and consuming yet 
      another batch of old-fashioned brined dill pickles, then how on earth am I 
      going to have the parental confidence to tackle such inevitable topics like 
      The Truth Behind Santa Claus, Braces & Social Ostracization, and The Senior Prom?</q>\b
      <i> . . . </i>\b
      <q>Exactly. Although there is no manual, per se, on any of this, I'm fairly 
      confident that brazenly conforming to your every wish and desire is probably the 
      wrong way to tackle parenting.</q>\b
      <q>Though... they *would* be quite tasty.</q>\b ";
      break;
    case 'C':
      "Another enormously hectic day at the Saint Columbia Veteran's Hospital, but hectic in a 
      good way -- there's a palatable energy in the air with the recent flood of newborns and
      the successful bypass surgery of a minor (although, incredibly talented and quite gracious) 
      celebrity having been recently completed. \b
      Your friend -- and fellow nurse -- Jessica has been talking up a double-blind date that the 
      two of you are to be going on this weekend, which will at least be interesting if nothing else. 
      Last time the two of you tried this, she found a couple guys from an Internet Go Server. While 
      they were definitely amusing, (and definitely available) they were a little too preoccupied 
      with moving stones around a monitor screen. \b
      Trying to get them out of the house again proved to be almost excruciatingly difficult. So 
      Jess has things planned with some other guys she met over Relay Chat. \b
      <q>They are into something,</q> Jess said, <q>called Magic:\ The Gathering. See? That implies
      that they are into social get-togethers and <i>gatherings</i>. It's all been taken care of. Plus, they
      sent me gifs of themselves and they have that David Copperfield meets Harry Houdini thing going
      on, as all magicians do. Trust me!</q>\b
      Well, you seem to recall something about that being a card game, but why not give her the 
      benefit of the doubt? It's good to get out and mix things up socially again, especially since 
      the last creep you dated finally got the message and stopped coming around the hospital. \b
      You can't help but notice the clock -- 1:17pm. Still another thirteen 
      minutes left of this break. Excellent. ";
      break;
    case 'D':
      "The shrieking squeals of the damned bring you back into a hazy consciousness. As you begin 
      to soak in the unbearable ambiance around, you attempt to shake off your rising awareness
      for a few moments more of self-ignorance. \b
      Your jailer enters from the palpable darkness; all business this morn(?). It checks the integrity
      of your shackles, in a horrible pantomime of surface world care. Where does it expect you to go? 
      Where does it suspect you will scurry to? His actions relating to internal security only bring 
      forth a dull hope into your mind, a hope that he will torture away without expression. ";
   break;
    case 'E':
      "Where did all this fog come from? "; // MJS
      break;
  }
  morePrompt();                           // wait for any key
  clearscreen();                          // Clear the screen
  setAboutBox();                          // Clear screen resets this
}  
