/* cvlocs.h
 *    include file for adventure locations
 *********************************************************************/

#define	DUNGEON	81

struct rtr {
    int top, mid, bot, drop, rug;
};

extern struct rtr rtrav[];

struct hint {
    int turns, points, quest, hmsg, bit, lc, hinted;
};

extern struct hint hints[];

#define	IF_HAVE		1
#define	IF_NHAVE	2
#define	IF_WITH		3
#define	IF_NWITH	4
#define	IF_PROP		5
#define	IF_NPROP	6

struct cvtrav {
    int word;
    unsigned int l:10;		/* location / message */
    unsigned int n:8;		/* probability / object */
    unsigned int v:4;		/* prop # / flag */
    unsigned int m:3;		/* type */
    unsigned int s:1;		/* continue flag */
};

struct cvloc {
    long flags;
    struct cvtrav *travel;
    char *sdesc, *ldesc;
    int abb;
    struct conn atloc;
};

extern struct cvloc *loc;

#define	BOATPLC	(&(cvloc[32]))
extern struct cvloc cvloc[];
extern struct cvloc *newloc, *oldloc, *knfloc, *oldlc2;
extern int tally, tally2;

#define DEAD	(struct cvloc *) 0

#define	LAMPLOC	(&(cvloc[2]))
#define	SEARSL	(&(cvloc[78]))
#define	CHLOC	(&(cvloc[87]))
#define	DALTLC	(&(cvloc[84]))
#define OFFICE	(&(cvloc[149]))
#define	REPOS	(&(cvloc[150]))

#define	FORCED(lpt)	((lpt)->flags == C_FORCED)
#define	LIQLOC(lpt)	(((lpt)->flags & C_WINE) \
				? (((lpt)->flags & C_WINE) == C_WINE ? _WINE : _WATER) : 0 )
#define	DARKRM	(((loc->flags & LIGHT) == 0) \
				&& ((LAMP->prop == 0) || !HERE(LAMP)))
#define	DARK	(DARKRM && ((UNICRN->prop == 0) || !HERE(UNICRN)))
#define BADPLC(lpt)	((lpt)->flags & ESCAPE)
#define	LNUM(lpt)	((lpt) - cvloc)
#define	INMAZE(lpt)	((lpt)->flags & (HINT3 | HINT4))

#define	LIGHT	1		/* light here always */
#define	LIQUID	4		/* there's something liquid here */
#define	C_WATER	LIQUID		/* it's water */
#define	C_WINE	(LIQUID+2)	/* it's wine */
#define	C_FORCED	2	/* special: loc with forced motion */
#define	ESCAPE	8		/* you can avoid some dwarves here */
#define	HINT1	16		/* trying to find the cave? */
#define	HINT2	32		/* trying to find the real adventure? */
#define	HINT3	64		/* lost in time maze */
#define	HINT4	128		/* trying to get back to time maze */
#define	HINT5	256		/* trying to get out of the woods? */
#define HINT6	512		/* trying to get down the hole */
#define	SECRET	1024		/* secret passage here */
#define	RANGER	2048		/* ranger rick annoys you here */
#define	DROWN	4096		/* don't drop boat or carpet here! */
