/* $Id: cave.t 1.15 2001/08/16 19:18:52 mol Exp $
 * --------------------------------------------------------------
 * Cave locations for Aayela 1.2
 *
 * This file is a part of the source distribution of
 *
 * Aaylea - an Interactive Vision, release 1.2
 *
 * Copyright 1996-2001 by Magnus Olsson (mol@pobox.com).
 * All rights reserved.
 *
 * THIS CODE MAY BE DISTRIBUTED FREELY AS LONG AS IT IS NOT MODIFIED
 * IN ANY WAY, NO FEE IS CHARGED EXCEPT FOR DISTRIBUTION COST, AND
 * THIS COPYRIGHT NOTICE IS NOT ALTERED OR DELETED.
 * You may use the code, classes and algorithms as part of your
 * own programs as long as the following conditions are met:
 *
 * 1) No use of the characters, plot or text of the game
 *    "Aayela" are used in the derivative work (i.e. you may
 *    write another game set in darkness using this code, but
 *    you may not publish an "improved" version of Aayela)
 *    without the author's permission.
 * 2) The use of this code, and its origin, are acknowledged in 
 *    the derivative work.
 *
 * This version is tested with the Linux TADS compiler v2.5.5
 * --------------------------------------------------------------
 */

below_manhole : darktunnel 
    noun = 'below-manhole'
    sdesc = "Below Manhole"
    darkldesc = "There is hardly room to breathe down here;
	the rungs of the ladder press into your back and your hands 
	brush against rough stone walls in all directions. Except to
	the southeast, down at the floor, where there seems to be
	a narrow opening in the wall."
    up = sandy_tunnel
    se = opening
    out = sandy_tunnel
    in = opening
    
    wallobj = nil // opening serves as wall here.
;

ladder : fixeditem
    noun = 'ladder' 'rung' 'rungs'
    adjective = 'metal'
    sdesc = "ladder"
    touchdesc = "It is firmly fastened to the rock wall."
    darkReachable(verb, actor) = {
        return true;
    }
    verDoClimb(actor) = { }
    doClimb(actor) = {
        actor.travelTo(self.location.up);
    }
    verDoStandon(actor) = {
        "That would be rather pointless.";
    }
    location = below_manhole
;    

opening : fixeditem, obstacle
    noun = 'opening' 'hole' 'tunnel' 'wall' 'walls'
    adjective = 'narrow' 'jagged' 'rock'
    sdesc = "opening"
    touchdesc = "Down by the floor, there is a jagged opening in the
        wall, just barely wide enough for you to enter. It is impossible
	to tell how deep it is or where it leads."
    
    darkReachable(verb, actor) = {
        return true;
    }

    verDoEnter(actor) = { }
    doEnter(actor) = {
        actor.travelTo(self.destination);
    }
    
    destination = {
        "You manage to squeeze into the opening, feet first, and
	make some awkward progress, sliding painfully on your back across
	the rock floor.\b";
	return confined;
    }
    location = below_manhole
;

confined : darktunnel
    noun = 'confined-space'
    sdesc = "Confined Space"
    darkldesc = "The passage is so tight that you have great difficulty 
        squeezing through. It's a good thing you aren't wearing armour.
	And to make things worse the tunnel bends 
	sharply here, from the northwest to the south."
	
    ldesc = "The tunnel bends sharply from the northwest to the south.
        Faint light shines in from the southern end; the other end of
	the tunnel is almost completely dark."	
	
    islit = {
        return stone.isActive;
    }
    
    nw = below_manhole
    south = {    
	if (stone.isActive)
  	    return endgame;
	else {
	    "Somehow, you manage to pass the bend. 
	    It gets easier once you're past it; the tunnel rapidly becomes 
	    wider and taller, and soon you can walk upright again.
	    A few more twists and turns, and then, suddenly, the 
	    walls recede.\b";

	    return cave_north;
	}
    }
;    


class caveroom : darktunnel
    shout(actor) = {
        "It is like shouting in a cathedral: your voice reverberates
	through vast spaces around and above you, echoing back and forth, 
	distorted. ";
	if (not self.islit)
	   "Quite frightening in the dark. ";
    }

    nrmLkAround(verbosity) = {
        if (self.islit)
	    pass nrmLkAround;

	if (not spark.isActive)
	    "\nIt is too dark to see anything.";
	    
	if (verbosity and defined(self, &darkldesc))
            "\b<< self.darkldesc >>";

	if (spark.isActive) {
	    "\b";
	    self.sparkmessage;
	}
    }
    floorobj = cavefloor
;

cavefloor : floor
    noun = 'floor' 'ground'
    adjective = 'stone' 'marble'
    sdesc = "floor"
    touchdesc = "It is made of hard, polished stone."
    ldesc = "It is made of polished marble."
 
    ioThrowAt(actor, dobj) = {
        if (dobj = stone)
	    dobj.doThrowAt(actor, self);
	else
	    pass ioThrowAt;
    }
    ioSynonym('ThrowAt') = 'ThrowTo'
;
    
class wallroom : caveroom   
    // A "generic" room description. The side property is a string
    // telling which side of the room we're on.
    darkldesc = {
        "You are at the edge of a large, open space. There is a wall
	within reach to the << self.side >>; on all other sides, just
	empty darkness.";
    }
	
    // The following list contains the rooms we've walked to from here
    destinations = []
    follow_wall(dest, direction) = {
        if (find(self.destinations, dest) = nil) {
	    self.destinations += dest;
   	    "You start walking with one hand touching the wall; 
	    the best way not to get lost in the dark. It is very
	    smooth, like polished marble, and curves toward
	    the << say(direction) >>.\b";
	}
	else {
	    "You follow the curvature of the wall towards
	    the << say(direction) >>.\b";
	}
	return dest;
    }
    wallobj = cave_wall
    sparkmessage = "You can see a tiny, bluish spark of light
        in the darkness."
;
    
cave_wall : wall
    noun = 'wall' 'walls'
    adjective = 'cave' 'rock'
    sdesc = "wall"
    touchdesc = {
        local loc := self.location;
	
        "\^<< self.thedesc >> is smooth to the touch, like
        polished marble. At this point it runs in a";
	if (loc = cave_west or loc = cave_east)
	    " north-south ";
	else
	    "n east-west ";
	"direction, but it curves inward like the inside of a
	cupola. ";
    }
;

cave_north : wallroom
    noun = 'cave-north'
    sdesc = "North Wall"
    darkldesc = "The tunnel opens out into darkness: you can sense
        the wall to the north, but only open space to the south. "
	
    side = "north"
    
    firstdarkseen = {
        notify(music, &daemon, 0);
    }
        
    north = {
        if (music.state < 12)
	    return confined;
	else {
	    "Somehow, the music draws you back; you find that you
	    can't leave as long as it is playing.";
	    return nil;
	}
    }
    
    west = {
        return self.follow_wall(cave_west, 'south');
    }
    east = {
        return self.follow_wall(cave_east, 'south');
    }
    south = cave
    se = cave
    sw = cave
;

cave_west : wallroom
    noun = 'cave-west' 
    sdesc = "West Wall"
    side = "west"

    north = {
        return self.follow_wall(cave_north, 'east');
    }
    south = {
        return self.follow_wall(cave_south, 'east');
    }
    east = cave
    se = cave
    ne = cave
;       

cave_south : wallroom
    noun = 'cave-south' 
    sdesc = "South Wall"
    side = "south"

    west = {
        return self.follow_wall(cave_west, 'north');
    }
    east = {
        return self.follow_wall(cave_east, 'north');
    }
    north = cave
    nw = cave
    ne = cave
;       

cave_east : wallroom
    noun = 'cave-west' 
    sdesc = "East Wall"
    side = "east"
	
    north = {
        return self.follow_wall(cave_north, 'west');
    }
    south = {
        return self.follow_wall(cave_south, 'west');
    }
    west = cave
    sw = cave
    nw = cave
;       

cave : caveroom
    noun = 'cave'
    sdesc = "Open Space"
    darkldesc = "You are walking across a hard, level surface, the sound
        of your footsteps disappearing in the dark emptiness around you. 
	The cave - if it is a cave -
	must be enormous; you have a feeling of vast spaces on all
	sides. Anything could hide in the dark, and you
	could just walk past it without ever noticing."

    walk(dest) = {
        if (rand(100) > 70 and not spark.isActive)
	    return self;
	else 
	    return dest;
    }
    north = { 
        return self.walk(cave_north);
    }
    south = { 
        return self.walk(cave_south);
    }
    east = { 
        return self.walk(cave_east);
    }
    west = { 
        return self.walk(cave_west);
    }
    ne = {
        return self.walk(rand(100) < 50 ? cave_north : cave_east);
    }
    nw = {
        return self.walk(rand(100) < 50 ? cave_north : cave_west);
    }
    se = {
        return self.walk(rand(100) < 50 ? cave_south : cave_east);
    }
    sw = {
        return self.walk(rand(100) < 50 ? cave_south : cave_west);
    }
    
    wallobj = nil // No walls reachable from here!
    sparkmessage = "A tiny, bluish spark of light hangs in front of
        your eyes, as if a star had been brought underground."
;


