/*
** GndHaus2.t defines the first floor of the house where all of the
** action takes place.
**
** Copyright (c) 1999, Stephen Granade. All rights reserved.
*/

#pragma C+

#define MAX_SEARCH_TIME 12

living_room: houseRm
    j_sdesc = "Living Room"
    f_sdesc = "Den"
    d_sdesc = "Living Room"
    j_ldesc = "When you're not in your room you usually hang
	       here, watching TV from the couch. Frank sometimes works
	       at a little desk he's got in here, but he's
	       normally pretty cool with you watching TV while he works.
	       There are stairs to
	       the south. You can get to the kitchen to the northeast and
	       the front door and hallway are northwest. "
    f_ldesc = "You've got the desk where you work pushed up against
	       one wall, over by an old stereo you keep meaning to fix.
	       The only thing you can see from the desk is the kitchen
	       to the northeast, but at least your back's to the
	       TV. A worn banister and stairs to the south go up to the
	       second floor. "
    d_ldesc = "The living room is starting to look a little dusty, the
	       TV especially. There are two paths worn in the green shag
	       carpet, one going from the stairs to the front door, the
	       other from the stairs to the kitchen, right by Frank's desk
	       and the row of family pictures. The door to the carport
	       is east. "
    exits = {
	if (actorObject == debMe)
	    return 'northeast, northwest, east, and up';
	return 'northeast, northwest, and up';
    }
    leaveList = [ tv ]  // The TV wants to know when someone tries to leave
    leaveRoom(actor) = {   // Keep track of Jeanie leaving
	if (actor == jeanieMe)
	    frankMe.queueAction('L');  // 'L' for leaving
	pass leaveRoom;
    }
    enterRoom(actor) = {
	if (actor == jeanieMe)
	    frankMe.queueAction('E');  // 'E' for entering
	pass enterRoom;
    }
    firstseen = {
	if (actorObject() == jeanieMe) {
	    "\bAs you come down the stairs, Frank looks up at you.
	     <q>Goin' out tonight too, huh?</q> Is his speech slurred
	     again? ";
	    jeanieMe.beenDownstairs = true;
	    jeanieMe.setResponse(&mutterAboutLeaving, frank);
	    notify(jeanieMe, &startBillfoldHunt, 35);
	    frankMe.acceptingActions = true;
	    frankMe.queueAction('*H');     // Frank says 'Hi'
	}
	else if (actorObject() == frankMe)
	    "\bYou hear Jeanie clomping around upstairs. Probably getting
	     ready to go out again tonight. ";
    }
    south = (self.up)
    east = {
	local actor = actorObject();

	if (actor == frankMe)
	    "There's nothing out in the garage but more stuff for you to
	     work on. ";
	else if (actor == debMe)
	    "You just came from there, and with all those groceries.
	     No sense in going back out again. ";
	else if (actor == jeanieMe) {
	    if (actor.hornCount == 0) {
		"You stick your head into the garage, but you can't see
		 the road. ";
	    }
	    else {
		"You start to go out the garage, but decide instead to go
		 out the front. ";
		jeanieMe.grabMyBagOnTheWayOut;
		" slam the door shut on your way out, heading for
		 April's car.\b";
		prepareForFrank();
	    }
	}
	return nil;
    }
    ne = kitchen
    nw = hallway
    up = {
	if (actorObject() == debMe) {
	    "Not until after you put away the groceries. ";
	    return nil;
	}
	"You head up the stairs.\b";
	return second_story_hall;
    }
;

old_stereo: fixeditem
    noun = 'stereo'
    adjective = 'old' 'broken'
    j_sdesc = "broken stereo"
    f_sdesc = "old stereo"
    d_sdesc = "broken stereo"
    j_ldesc = "That stereo's been broken for as long as you can
	       remember. "
    f_ldesc = {
	"You think there's just a wire loose inside it, but
	 other projects keep cropping up, and the stereo's
	 just not that important. ";
	if (stereo_power_cord.isIn(self))
	    "Its power cord dangles off the back. ";
    }
    d_ldesc = "If only Frank would throw that piece of junk away. "
    verDoTurnon(actor) = {
	if (actor == jeanieMe)
	    "Why bother? It doesn't work. ";
	else if (actor == frankMe)
	    "You click the stereo on and off, but nothing happens. ";
	else if (actor == debMe)
	    "You don't really have time to waste playing with broken
	     electronics. ";
    }
    verDoOpen(actor) = {
	if (actor == frankMe)
	    "Trying to fix the stereo will have to wait until you've
	     fixed the toaster, and maybe the upstairs light. ";
	else "%You% %do%n't know how to open the stereo. ";
    }
    verIoUnscrewFrom(actor) = {
	if (!stereo_power_cord.isIn(self))
	    pass verIoUnscrewFrom;
    }
    ioSynonym('UnscrewFrom') = 'DetachFrom'
    verIoScrewTo(actor) = {}
    ioSynonym('ScrewTo') = 'AttachTo'
;

shag_carpet: fixeditem
    noun = 'carpet' 'carpeting'
    adjective = 'green' 'shag' 'worn' 'old'
    location = living_room
    j_sdesc = "green carpet"
    f_sdesc = "green carpet"
    d_sdesc = "green shag carpet"
    j_ldesc = "The carpet's this icky green color that must've
	       been real popular in the 70's. "
    f_ldesc = "That carpet's not your fault&mdash;it was here when
	       you married Deb. "
    d_ldesc = "There are two paths worn in the old shag carpet. "
    doSiton -> theFloor
    doLieon -> theFloor
    ioPutOn -> theFloor
    ioPutIn -> theFloor
    ioThrowAt -> theFloor
;

carpet_paths: decoration
    isThem = true
    noun = 'path' 'paths'
    adjective = 'two' 'worn'
    sdesc = "two paths"
    j_ldesc = "The two paths appeared so gradually that you're just now
	       noticing them. "
    d_ldesc = "You've had your eye on those paths for some time, and
	       they're just getting worse. "
;

tv: fixeditem
    isActive = nil
    leaveOff = nil          // True if Frank's said not to turn on the TV
    commercialShowing = nil // True if a commercial is on
    currentBand = 1
    onCounter = 0           // How many times the TV's been turned on
    bandList = [ 'Bon Jovi' 'Madonna' 'Guns n\' Roses' ]
    noun = 'tv' 'teevee' 'telly' 'television' 'tube'
    location = living_room
    j_sdesc = "TV"
    f_sdesc = (self.j_sdesc)
    d_sdesc = "television"
    j_ldesc = {
	"The TV's pretty old&mdash;it puts a green halo around
	 stuff&mdash;but it still works. ";
	if (self.isActive) {
	    "Right now a ";
	    if (self.commercialShowing)
		"commercial is on. ";
	    else "<<self.bandList[self.currentBand]>> video is on. ";
	}
    }
    f_ldesc = "That TV's so old, you should probably get a new one
	       sometime soon. It's hard enough to watch the Cubs play
	       even without them being tinted green. "
    d_ldesc = "The TV is looking a little dusty. "
    // leaving is called by living_room's leaveRoom() whenever someone
    // tries to leave (imagine!). Check to see if the TV's on and, if
    // so, chide the actor into turning it off. Returns nil so that it
    // never is removed from living_room's leaveList.
    leaving(actor) = {
	local stat;

	if (!self.isActive || actor != jeanieMe)
	    return nil;
	"As you head out of the room Frank says, <q>You going to leave
	 that TV on?</q> Muttering under your breath, you turn it off before
	 leaving.\b";
	frankMe.queueAction('*Tl');   // Frank said switch off the TV
	global.pauseRecorder = true;  // Don't record the execCommand
	execCommand(actor, turnOffVerb, self, nil, nil, EC_HIDE_SUCCESS |
		    EC_HIDE_ERROR);
	global.pauseRecorder = nil;
	return nil;
    }
    takedesc = {
	if (actorObject() == jeanieMe)
	    "What would you do with it? ";
	else if (actorObject() == frankMe)
	    "With your back like it is, that's out of the question. ";
	else "You certainly can't imagine picking that up by
	      yourself! ";
    }
    verDoSwitch(actor) = {
	if (self.isActive)
	    self.verDoTurnoff(actor);
	else self.verDoTurnon(actor);
    }
    doSwitch(actor) = {
	if (self.isActive)
	    self.doTurnoff(actor);
	else self.doTurnon(actor);
    }
    verDoTurnon(actor) = {
	if (actor == frankMe)
	    "Maybe later. You've got too much on your mind right
	     now. ";
	else if (actor == debMe)
	    "Not until those groceries are put away. ";
	else if (self.leaveOff) {
	    if (jeanie.gotYelledAtAboutTV || jeanie.gotYelledAtAboutMoney)
		"You'd do it, just to show him, but you've
		 just got to get out of the house tonight. You don't
		 need to be grounded just now. ";
	    else "Better not. Frank gets in a pissy mood if you annoy him
		  too much. ";
	}
	else if (self.isActive)
	    "It's already on. ";
    }
    doTurnon(actor) = {
        self.isActive = true;
	frankMe.queueAction('T1');        // 'T1' for TV on
	tv_video.moveInto(living_room);
	// This first condition covers turning off the TV just as it
	// advances too far or Jeanie turning the TV on & off 4 times.
	if (self.currentBand > length(self.bandList) ||
	    self.onCounter > 4) {
	    "As you click on the TV, Frank turns to look at you. <q>If
	     you're gonna keep turning that thing on and off, just
	     leave it off.</q>";
	    self.forcedShutOff;
	    frankMe.queueAction('*Ts');   // Frank said switch off the TV
	}
	else {
	    self.onCounter++;
	    "You click on the TV. It hums into life, showing a ";
	    if (self.commercialShowing)
		"commercial. ";
	    else "green-tinged <<self.bandList[self.currentBand]>> video. ";
	    if (getfuse(self, &fuseAdvance) == nil)
		notify(self, &fuseAdvance, 3 + _rand(2));
	}
    }
    verDoTurnoff(actor) = {
        if (!self.isActive)
            "The TV isn't on. ";
    }
    doTurnoff(actor) = {
        self.isActive = nil;
	frankMe.queueAction('T0');        // 'T0' for TV off
	tv_video.moveInto(nil);
        "The TV shuts off, its hum fading away. ";
    }
    verDoTurnup(actor) = {
	if (!self.isActive)
	    "The TV isn't on. ";
    }
    doTurnup(actor) = {
	"If you turn it up any louder, Frank'll complain. ";
    }
    verDoTurndown(actor) = (self.verDoTurnup(actor))
    doTurndown(actor) = {
	"Any lower and you won't be able to hear. ";
    }
    verDoWatch(actor) = {
	if (actor == frankMe || actor == debMe)
	    self.verDoTurnon(actor);  // Use the same excuse as 'turn on'
	else if (!self.isActive)
	    "Yeah, the TV's real exciting when it's off. ";
    }
    doWatch(actor) = {
	if (self.commercialShowing)
	    "You watch a bit of the commercial that's on, but
	     it's not really interesting or anything. ";
	else switch(self.currentBand) {
	  case 1:   // Bon Jovi
	    "Bon Jovi's pretty cool, but their latest video is
	     all grainy for some reason. ";
	    if (!actor.mentionedDream) {
		actor.mentionedDream = true;
		"You're gonna be in one of their videos some day. ";
	    }
	    break;

	  case 2:   // Madonna
	    "Madonna's such a slut. The way she dresses, no wonder
	     all the boys you know get woodies when they hear her
	     name. ";
	    if (!actor.mentionedDream) {
		actor.mentionedDream = true;
		"Still, being in a video, even one of hers, would be
		 a great way to get noticed. Isn't that how
		 whats-her-name got started before she got on Family
		 Ties? ";
	    }
	    break;

	  case 3:   // Guns n' Roses
	    "All of their videos rock hard, just like this one. ";
	    if (!jeanieMe.mentionedTown) {
		jeanieMe.mentionedTown = true;
		"You'd kill to be in one of their videos, but it's not
		 like they'd ever come here. Backwoods Mississippi's
		 not a big concert stop. ";
		if (!actor.mentionedDream) {
		    actor.mentionedDream = true;
		    "Guess you'd have to go to them. ";
		}
	    }
	    else "You'd dance, but Frank's in the room. ";
	    break;
	}
    }
    // Called by the fuse which wants us to advance what's on TV
    fuseAdvance = {
	self.advance(!self.isActive);
	if (self.isActive)
	    notify(self, &fuseAdvance, 2 + _rand(2));
    }
    // Advance what's on TV. If quiet is true, doesn't print any messages
    advance(quiet) = {
	local stat1;
	if (quiet)                  // If we're to be quiet, hide output
	    stat1 = outhide(true);

	if (self.commercialShowing) {
	    self.commercialShowing = nil;
	    "\bThe commercial goes off, replaced by a <<
	     self.bandList[self.currentBand]>> video. ";
	}
	else {
	    self.currentBand++;
	    // A commercial will come on before the final video
	    if (self.currentBand == length(self.bandList)) {
		self.commercialShowing = true;
		"\bThe video ends and a bunch of commercials come on. ";
	    }
	    // Note that we don't set forcedShutOff if quiet is true
	    else if (self.currentBand > length(self.bandList)) {
		"\bFrank turns around and says, <q>That's enough
		 TV for now. Turn it off.</q>";
		if (!quiet) {
		    self.forcedShutOff;
		    frankMe.queueAction('*Tt');
		    frankMe.addAction; // We have to force this action to
		                       //  be recorded since it happens
		                       //  in the middle of a daemon.
		}
	    }
	    else "\bThe <<tv.bandList[self.currentBand - 1]>> video ends and <<
		  self.bandList[self.currentBand]>> comes on. ";
	}

	if (quiet)
	    outhide(stat1);
    }
    // Frank's making us turn the TV off. Note that, before calling this
    // function, you need to print what Frank says first.
    forcedShutOff = {
	"\b<q>But Frank&mdash;</q>
	 \b<q>Turn it off, Jeanie. I'm trying to work
	 here.</q> You ";
	if (jeanieMe.location == couch)
	    "get up and ";
	"shut off the TV";
	if (jeanieMe.location == couch)
	    " before collapsing back on the couch with a loud sigh";
	". Just another one of
	 his shitty moods. ";
	jeanieMe.setResponse(&complainAboutTV1, frank);
	self.isActive = nil;
	self.leaveOff = true;
	global.pauseRecorder = true;   // Don't record the execCommand
	execCommand(jeanieMe, turnOffVerb, self, nil, nil, EC_HIDE_SUCCESS |
		    EC_HIDE_ERROR);
	global.pauseRecorder = nil;
    }
;

tv_video: intangible
    noun = 'video' 'jovi' 'madonna' 'roses' 'mtv' 'commercial' 'commercials'
    adjective = 'guns' 'n' 'n\'' 'and' 'bon'
    sdesc = "video"
    ldesc = {
	tv.doWatch(actorObject());
    }
    doSwitch -> tv
    doTurnoff -> tv
    doWatch -> tv
;

remote: item
    isListed = {
	return ((self.location != couch) ||
		(actorObject().location == couch));
    }
    noun = 'remote' 'control' 'clicker'
    adjective = 'tv' 'remote'
    location = couch
    sdesc = "TV remote"
    ldesc = "The remote's got three buttons:\ power, channel, and
	     volume. "
    doPutOn(actor, io) = {
	if (io == couch)
	    "You stick the remote back between the couch cushions. ";
	else "Done. ";
	self.moveInto(io);
    }
    // The remote only works if the TV is around and, unless power was
    // pressed, is on. If powerPressed is true, we only check to see if
    // the TV is in the room; otherwise, the TV must also be on. Note
    // that this routine also prints the appropriate error message.
    // Returns true if all requirements are met, nil if not.
    checkForTV(actor, powerPressed) = {
	if (!(actor.isIn(tv.location))) {
	    "The remote doesn't work that far away. %You%'ll
	     have to be closer to the TV for it to work. ";
	    return nil;
	}
	if (!(powerPressed || tv.isActive)) {
	    "%You%'ll have to turn the TV on first. ";
	    return nil;
	}
	return true;
    }
;

power_button: buttonitem
    adjective = 'power'
    location = remote
    sdesc = "power button"
    ldesc = "It turns the TV on and off. "
    verDoPush(actor) = {
	if (remote.checkForTV(actor, true))
	    tv.verDoSwitch(actor);
    }
    doPush(actor) = (tv.doSwitch(actor))
    doSynonym('Push') = 'Switch'
;

channel_button: buttonitem
    adjective = 'channel' 'channels'
    location = remote
    sdesc = "channel button"
    ldesc = "For changing the channel. "
    verDoPush(actor) = { remote.checkForTV(actor, nil); }
    doPush(actor) = {
	if (tv.commercialShowing) {
	    tv.advance(true);
	    "You flip channels for a minute. When you get
	     back to MTV, the commercial's gone, replaced by a <<
	     tv.bandList[tv.currentBand]>> video. ";
	}
	else "You flip channels for a while, but there's nothing
	      interesting on besides MTV. ";
    }
    doSynonym('Push') = 'Change' 'Flip'
;

volume_button: buttonitem
    adjective = 'volume'
    location = remote
    sdesc = "volume button"
    ldesc = "It controls the TV volume, or would if it weren't
	     broken. "
    verDoPush(actor) = {
	"It won't matter how much you push, or even if the TV's
	 on. The volume's broken. ";
    }
    doSynonym('Push') = 'Turnup' 'Turndown'
;

couch: chairitem
    // I've hacked reachable so that TV can be turned on from couch if
    // actor is holding the TV remote
    reachable = {
	if (remote.isIn(actorObject()))
	    return ([ tv ] + couch_cushions + self);
	return ([couch_cushions] + self);
    }
    statusPrep = "on"
    outOfPrep = "off of"
    noun = 'sofa' 'couch'
    adjective = 'green' 'puke-green'
    location = living_room
    j_sdesc = "couch"
    f_sdesc = "sofa"
    d_sdesc = "couch"
    j_ldesc = {
	local flag = nil;

	"The couch may be puke-green but it's about the most comfy
	 thing you've ever sat on. ";
	if (remote.location == self) {
	    flag = true;
	    "The TV remote is wedged between two cushions. ";
	}
	if (itemcnt(self.contents)) {
	    if (flag)
		"Also on";
	    else "On";
	    " the couch is <<listcont(self)>>. ";
	}
    }
    f_ldesc = "The green of the sofa almost matches
	       the green of the TV and the green of the carpet. "
    d_ldesc = "The green of the couch was a good match for the carpet,
	       at least before the sun faded the couch. "
    roomDrop(obj) = {
	if (obj == remote) {
	    "You stick the remote back between the couch cushions. ";
	    obj.moveInto(self);
	}
	else pass roomDrop;
    }
    cantReachRoom(otherRoom) = {
	"%You%'ll have to get up first. ";
    }
    verDoSiton(actor) = {
	if (actor == debMe)
	    "Not until those groceries are put away. ";
	else if (actor.isIn(self))
	    "You're already on the couch. ";
    }
    doSiton(actor) = {
	if (actor == jeanieMe) {
	    "You flop onto the couch";
	    if (remote.location == self)
		", then move over to keep the TV remote from poking you
		 in the butt";
	    ". ";
	    frankMe.queueAction('s');  // 's' for sitting on couch
	}
	else if (actor == frankMe)
	    "You sink into the couch. ";
	actor.moveInto(self);
    }
    doSynonym('Siton') = 'Enter'
    enterRoom(actor) = {
	if (actor == jeanieMe)
	    frankMe.queueAction('s');  // 's' for sitting on couch
	pass enterRoom;
    }
    leaveRoom(actor) = {
	if (actor == jeanieMe)
	    frankMe.queueAction('S');  // 'S' for standing
	pass leaveRoom;
    }
    verDoSearch(actor) = {
	if (actor == frankMe)
	    "The remote's probably down in there, but so is a bunch
	     of dirt, and if you go rooting around in there and pull that
	     dirt out, Deb'll have you vacuuming in here. ";
	else if (actor == debMe)
	    "You'd rather not put your hands down in there.
	     There's no telling what Frank and Jeanie have dropped
	     down there. ";
	else {
	    if (actor.lookingForBillfold)
		"There's just no way your billfold got down there. And
		 as nasty as the couch is, you're not going to stick your
		 hand down there. ";
	    else "As nasty as the couch is? No thanks. ";
	}
    }
    verDoLookunder(actor) = {
	if (actor == jeanieMe && actor.lookingForBillfold)
	    "There's just no way your billfold got down there. ";
	else pass verDoLookunder;
    }
;

couch_cushions: fixeditem
    isThem = true
    noun = 'cushion' 'cushions'
    adjective = 'couch'
    location = living_room
    sdesc = "couch cushions"
    j_ldesc = "The cushions are really soft. You tend to slide down a
	       bunch when you sit on them. "
    f_ldesc = "For some reason, the cushions are almost a different
	       shade of green than the rest of the couch. "
    d_ldesc = "You really should have had those cushions cleaned a while
	       ago. "
    takedesc = {
	local actor = actorObject();

	if (actor == jeanieMe)
	    "Lug those nasty things around? Forget that. ";
	else if (actor == frankMe)
	    "You don't even pick those things up to vacuum them. ";
	else "You can't, not while you have the groceries. ";
    }
    doBoard -> couch
    doSiton -> couch
    doLieon -> couch
    doSearch -> couch
    ioPutOn -> couch
;

family_pictures: fixeditem
    isThem = true
    noun = 'row'
    adjective = 'family' 'pictures' 'portraits'
    location = living_room
    sdesc = "family pictures"
    j_ldesc = "Check out mom's seventies 'do in that old picture. And
	       Frank's tie is wide and paisley. "
    f_ldesc = "You sigh as you look at the pictures&mdash;they remind you
	       of how fat Deb's gotten. "
    d_ldesc = "There's a series of pictures hanging on the wall. In the
	       oldest picture Jeanie is only seven, and Frank looks a lot
	       thinner than he does now. "
;

little_desk: fixeditem, surface
    noun = 'desk'
    adjective = 'frank\'s' 'my' 'little'
    location = living_room
    j_sdesc = "Frank's little desk"
    f_sdesc = "your desk"
    d_sdesc = "Frank's desk"
    adesc = (self.sdesc)
    thedesc = (self.sdesc)
    j_ldesc = "The desk is covered with broken appliances that Frank
	       swears he's going to fix. "
    f_ldesc = {
	"You spend a lot of time at that desk, fixing different broken
	 appliances. ";
	if (itemcnt(self.contents))
	    "Right now on the desk you see <<listcont(self)>>. ";
    }
    d_ldesc = "Frank's obviously working on that old toaster again. "
    verIoPutOn(actor) = {
	if (actor == jeanieMe)
	    "Frank gets mad if %you% put%s% things on his desk. ";
	else if (actor == debMe)
	    "You tend to leave Frank's desk alone. He won't
	     even let you dust it. ";
    }
    doSiton -> franks_chair
;

franks_chair: chairitem
    standAttempts = 1
    reachable = ([little_desk, jeanie, old_stereo] + self)
    noun = 'chair'
    adjective = 'small' 'wooden'
    location = living_room
    j_sdesc = "small chair"
    f_sdesc = "wooden chair"
    d_sdesc = (self.f_sdesc)
    j_ldesc = "The chair's so small, it's hard to believe Frank can
	 balance his fat ass in it, like he's doing now. "
    f_ldesc = {
	"The chair's not all that comfortable, but it fits under
	 the desk, which is the main thing. ";
	self.list_contents;
    }
    d_ldesc = "You and Frank found that chair at a garage sale a while
	       ago. Right now Frank is balanced on it. "
    takedesc = { self.verDoPull(actorObject()); }
    cantReachRoom(otherRoom) = {
	"%You%'ll have to get up first. ";
    }
    list_contents = {
	if (itemcnt(self.contents))
	    "On the chair %you% see%s% <<listcont(self)>>. ";
    }
    // I've modified frankMe's moveInto() to turn on advanceJResponses
    // if and when he sits in his chair. Similarly:
    enterRoom(actor) = {
	if (actor == frankMe && !frankMe.respondingToJeanie) {
	    frankMe.respondingToJeanie = true;
	    notify(frankMe, &advanceJResponses, 0);
	}
	pass enterRoom;
    }
    verDoSiton(actor) = {
	if (actor.location == self)
	    "%You're% already in the chair. ";
	else if (actor == jeanieMe)
	    "There's no room&mdash;Frank more than fills that chair. ";
	else if (actor == debMe)
	    "Not while Frank is sitting there. ";
	else if (length(self.contents) > 0)
	    "The chair's not empty. ";
    }
    verIoPutOn(actor) = {
	if (actor == jeanieMe)
	    "There's no room&mdash;Frank more than fills that chair. ";
	else if (actor == debMe)
	    "Not while Frank is sitting there. ";
	else if (actor.location == self)
	    "That's kinda hard to do while you're sitting there. ";
    }
    doUnboard(actor) = {
	if (actor == frankMe) {
	    // Frank can only get up if he's fixed the toaster, and then
	    // he'll just realize that Jeanie has left the building
	    if (toaster.fixed) {
		"You stand and stretch, hands kneading the small of your
		 back. You're glad to have that chore done. ";
		actor.realizeJeanieLeft;
		return;
	    }
	    switch (self.standAttempts) {
	      case 1:
		"You start to stand up, but glance at the toaster. You've
		 got to be close to fixing it. It shouldn't take you too
		 much longer. ";
		break;
	      case 2:
		"With a start you realize that you've been staring at the
		 wall for the past few minutes. Better do at least a little
		 more work on the toaster before you give up. ";
		break;
	      case 3:
		"You rise, then sit back down. You're so close to having
		 that toaster finished, you can't stand to leave it any
		 longer. ";
		break;
	      default:
		"You're not going to leave this toaster until it's fixed.
		 You're not. Not after you promised Deb. ";
		break;
	    }
	    frankMe.speedUpActions;
	    self.standAttempts++;
	}
	else pass doUnboard;
    }
    verDoPull(actor) = {
	if (actor.location == self)
	    "Not while you're sitting on it. ";
	else if (actor == jeanieMe)
	    "There's no way your scooting that chair while Frank's in
	     it. ";
	else if (actor == debMe)
	    "Better not disturb Frank right now, since it looks like he's
	     making progress on that toaster. ";
	else "You scoot the chair around a little bit. ";
    }
    doSynonym('Pull') = 'Push'
;

broken_appliances: fixeditem
    isThem = true
    noun = 'appliance' 'appliances' 'junk'
    adjective = 'broken'
    location = little_desk
    sdesc = "broken appliances"
    ldesc = "He's been <q>working</q> on some of that junk for
	     years. "
    dobjGen(a, v, i, p) = {
        if (v != inspectVerb && !v.issysverb) {
            "You know better than that. ";
            exitobj;
        }
    }
    iobjGen(a, v, d, p) = {
	if (!v.issysverb) {
	    "You know better than that. ";
	    exitobj;
	}
    }
;

broken_toaster: fixeditem
    noun = 'toaster' 'insides' 'box'
    adjective = 'broken'
    location = little_desk
    sdesc = "broken toaster"
    j_ldesc = "The toaster's lying open, its insides pulled out all over the
	     desk. "
    d_ldesc = "Hopefully Frank can fix it. "
    dobjGen(a, v, i, p) = {
        if (v != inspectVerb && !v.issysverb) {
            "You know better than to mess with Frank's projects. ";
            exitobj;
        }
    }
    iobjGen(a, v, d, p) = {
	if (!v.issysverb) {
	    "You know better than to mess with Frank's projects. ";
	    exitobj;
	}
    }
;

banister: fixeditem
    noun = 'banister' 'bannister'
    adjective = 'worn' 'oak'
    location = living_room
    sdesc = "banister"
    j_ldesc = "When you were little you used to slide down the banister and
	       dad would catch you at the bottom. "
    f_ldesc = "The varnish's been rubbed off the banister over time,
	       leaving the oak bare. "
    d_ldesc = "The banister, like everything else in the house, is dusty.
	       At least Jeanie hasn't draped her clothes over it tonight. "
;

stairs_up: fixeditem
    isThem = true
    noun = 'stairs' 'step' 'staircase'
    plural = 'steps'
    location = living_room
    sdesc = "stairs"
    ldesc = "They lead up. "
    verDoClimb(actor) = {}
    doClimb(actor) = {
	local dest;

	dest = actor.location.up;
	if (dest != nil)
	    actor.travelTo(dest);
    }
    doSynonym('Climb') = 'Enter'
;

hallway: houseRm
    j_sdesc = "Hall"
    f_sdesc = "Hallway"
    d_sdesc = (self.f_sdesc)
    j_ldesc = "The hallway goes between the kitchen to the east and the
	       front door to the west. There's a bathroom to the
	       north. You can slip around the wall of the hallway and
	       into the living room to the southwest. "
    f_ldesc = "It's not so much a hallway as a panelled wall between
	       the bathroom to the north and the den. The kitchen is east,
	       and you can get to the den to the southwest. "
    d_ldesc = "The hallway's so dark, you wish Frank would install
	       more lighting. At least you don't have to come this
	       way that often, since you don't ever use the guest
	       bathroom to the north. "
    exits = 'north, east, and southwest'
    north = ground_bath_door_hall
    south = {
	"The wall's in the way. You can go around it to the southwest or
	 east. ";
	return nil;
    }
    east = kitchen
    west = {
	local actor;

	actor = actorObject();
	if (!(actor == jeanieMe && jeanieMe.hornCount != 0))
	    return front_door;
	front_door.doOpen(actor);
	return nil;
    }
    sw = living_room
    se = living_room
    out = (self.west)
;

front_door: doorway
    isopen = nil
    noAutoOpen = true
    noun = 'door'
    adjective = 'front' 'big' 'heavy' 'walnut' 'thick' 'oak' 'west'
    location = hallway
    sdesc = "front door"
    j_ldesc = "A big heavy door that goes outside. "
    f_ldesc = "A thick walnut door that goes outside. "
    d_ldesc = "A heavy oak door that goes outside. "
    verDoOpen(actor) = {}
    doOpen(actor) = {
	if (actor == frankMe)
	    "You're not paying to cool the whole outdoors. ";
	else if (actor == debMe)
	    "You really need to take care of those groceries first. ";
	else if (actor.hornCount == 0)
	    "You open the front door a little and peek outside, but
	     April's not here yet. ";
	else { // Don't mention "front door" here, since this is also
	       // called if Jeanie exits to the garage
	    "You yank open the door. Sure enough, there's April in
	     her old Mustang. ";
	    jeanieMe.grabMyBagOnTheWayOut;
	    " slam the door shut on your way out, heading for her car.\b";
	    prepareForFrank();
	}
    }
;

ground_bath_door_hall: autoDoor
    doordest = first_story_bath
    adjective = 'bathroom' 'north'
    location = hallway
    sdesc = "bathroom door"
;

first_story_bath: houseRm
    isBathroom = true
    sinkObj = first_story_sink
    j_sdesc = "Bathroom"
    f_sdesc = "Spare Bathroom"
    d_sdesc = "Half Bath"
    j_ldesc = "An extra bathroom, with a john and sink. "
    f_ldesc = "You guess the spare bathroom was put in for visitors, but
	       you'll be damned if you can figure out why the
	       builders put it here. "
    d_ldesc = "The bathroom only holds a sink and a toilet. Draped over
	       the sink is a blue towel. "
    exits = 'south'
    south = ground_bath_door_bath
    out = ground_bath_door_bath
;

first_story_sink: fixeditem
    noun = 'sink'
    adjective = 'porcelain'
    location = first_story_bath
    sdesc = "porcelain sink"
    j_ldesc = "The sink's pretty clean since mom had you clean this
	       bathroom last weekend. "
    f_ldesc = "A porcelain sink. "
    d_ldesc = (self.f_ldesc)
    verDoTurnon(actor) = {
	if (actor == jeanieMe)
	    "No way you're going to risk splashing water on you. ";
	else if (actor == frankMe)
	    "Nah. Your hands aren't that dirty. ";
	else "Might as well wait until you're ready to fix supper
	      before you wash your hands. ";
    }
    verDoTurnoff(actor) = { "The sink's not on. "; }
    doSynonym('Turnon') = 'Use'
;

first_story_mirror: fixeditem
    noun = 'mirror'
    location = first_story_bath
    sdesc = "mirror"
    j_ldesc = "You look about as ready as you're going to be for
	       tonight. "
    f_ldesc = "From the looks of things, you need more sleep. "
    d_ldesc = "Perhaps it's just the lights in here, but you look...old. "
    verDoLookin(actor) = {}
    doLookin(actor) = (self.ldesc)
    verDoClean(actor) = {
	if (actor == jeanieMe)
	    "Maybe later. Then again, maybe never. ";
	else "You've got enough stuff to do around the house as it
	      is without volunteering for more. ";
    }
;

towel: fixeditem
    noun = 'towel'
    adjective = 'ratty' 'old' 'blue' 'faded'
    location = first_story_bath
    sdesc = "towel"
    j_ldesc = "A ratty old towel. "
    f_ldesc = "A blue towel. "
    d_ldesc = "A faded blue towel. "
    takedesc = {
	local currentMe = actorObject();

	if (currentMe == jeanieMe)
	    "Ick. No thanks. ";
	else if (currentMe == frankMe)
	    "The towel's old enough to be a grease rag for you, but
	     Deb still likes it. ";
	else "There's really no need. ";
    }
;

first_story_toilet: fixeditem
    noun = 'toilet' 'crapper' 'john' 'loo'
    adjective = 'porcelain'
    location = first_story_bath
    j_sdesc = "john"
    f_sdesc = "john"
    d_sdesc = "toilet"
    ldesc = "A porcelain toilet. "
    verDoEnter(actor) = {
	"You don't have to go right now. ";
    }
    doSynonym('Enter') = 'Siton' 'Use' 'Open'
    verDoFlush(actor) = {
	if (actor == debMe)
	    "You haven't gone to the bathroom. ";
	else "You flush it and watch the water swirl around. ";
    }
;

// So the player can use the bathroom
first_story_bathroom: decoration
    noun = 'bathroom'
    location = first_story_bath
    sdesc = "bathroom"
    ldesc = {
	execCommand(actorObject(), lookVerb);
    }
    doUse -> first_story_toilet
    doEnter -> first_story_toilet
;

ground_bath_door_bath: autoDoor
    islocked = nil
    doordest = hallway
    location = first_story_bath
    noun = 'bathroom'
    sdesc = "door"
    verDoLock(actor) = {}
;

kitchen: houseRm
    searchCounter = 0
    sdesc = "Kitchen"
    j_ldesc = "Mom's been bugging you about learning how to cook, so
	       you've been avoiding the kitchen as much as possible
	       when she's around. There're counters and cabinets
	       along the walls and a table on one side of the
	       kitchen. The hallway's to the west and the living
	       room is southwest. "
    f_ldesc = "You'd think you never ate, as hungry as you get every
	       time you go in the kitchen. But you promised Deb no snacks,
	       so the cabinets are off-limits for you. Good thing
	       drinks from the fridge are okay. The den is southwest. "
    d_ldesc = "After several rounds of remodelling you finally got the
	       kitchen laid out fairly well, with the range near the cabinets
	       and with plenty of counter space. If only the table
	       weren't between the range and refrigerator. The living
	       room is to the southwest. "
    exits = 'west and southwest'
    enterRoom(actor) = {
	inherited.enterRoom(actor);
	if (actor == jeanieMe)
	    debMe.queueAction('E');    // 'E' for entering
	else if (actor == debMe) {
	    "\b<q>Hey, mom,</q> Jeanie says as you walk in. ";
	    actor.setResponse(&askJeanieForHelp, jeanie);
	}
    }
    leaveRoom(actor) = {   // Keep track of Jeanie leaving
	if (actor == jeanieMe)
	    debMe.queueAction('L');  // 'L' for leaving
	pass leaveRoom;
    }
    leaveList = [ refrigerator ]
    checkForDeb = {
	// Don't let Deb leave once she gets in the kitchen
	if (actorObject() == debMe) {
	    if (carried_groceries.location == debMe)
		"You've just got to set these groceries down before you
		 hurt your back. ";
	    else if (groceries.location == nil) { // Deb's done w/groceries
		debMe.kludgyFlagIClear = nil;     // (don't print "\b")
		debMe.frankAsksAboutJeanie;
	    }
	    else "It won't take long to put up the groceries. No sense
		  in leaving it for later, especially since the
		  ice cream would melt. ";
	    return nil;
	}
	return true;
    }
    west = {
	if (self.checkForDeb)
	    return hallway;
	return nil;
    }
    sw = {
	if (self.checkForDeb)
	    return living_room;
	return nil;
    }
    out = (self.sw)
    roomAction(a, v, d, p, i) = {
	if (a == jeanieMe && a.lookingForBillfold) {
	    searchCounter++;
	    if (searchCounter > MAX_SEARCH_TIME)
		notify(deb, &enterKitchenWithGroceries, 1);
	}
	pass roomAction;
    }
;

kitchen_counters: fixeditem, surface
    isThem = true
    noun = 'counter' 'counters'
    adjective = 'kitchen' 'cluttered' 'formica'
    location = kitchen
    j_sdesc = "kitchen counters"
    f_sdesc = "counters"
    d_sdesc = "cluttered counters"
    j_ldesc = {
	if (jeanieMe.lookingForBillfold)
	    "You glance at the counters, but there's no sign of
	     your billfold on them. ";
	else {
	    "A bunch of cluttered counters. ";
	    if (itemcnt(self.contents))
		"Besides the usual shit %you% see%s% <<listcont(self)>>. ";
	}
    }
    f_ldesc = {
	"Some old formica counters. ";
	if (itemcnt(self.contents))
	    "On them %you% see%s% <<listcont(self)>>. ";
    }
    d_ldesc = {
	"It's been a while since you tidied up in here, and the counters
	 are filled with clutter. ";
	if (itemcnt(self.contents))
	    "Among the clutter %you% see%s% <<listcont(self)>>. ";
    }
    verDoLookunder(actor) = {
	"There's nothing under the counters but cabinets. ";
    }
    verDoLookin(actor) = {
	"You can't look in the counters. ";
    }
;

kitchen_range: fixeditem
    noun = 'range' 'stove' 'oven'
    location = kitchen
    j_sdesc = "stove"
    f_sdesc = "stove"
    d_sdesc = "range"
    j_ldesc = "Mom's determined to teach you how to use that thing. "
    f_ldesc = "It's not much use to you, seeing as how you never learned
	       how to cook. "
    d_ldesc = "The range works pretty well, though sometimes it cooks
	       a little unevenly. "
    verDoOpen(actor) = {
	if (actor == jeanieMe || actor == frankMe)
	    "There's nothing in there. ";
	else if (actor == debMe)
	    "You'll cook once you've got the groceries put away. ";
    }
    verDoClose(actor) = {
	"It's already closed. ";
    }
    verDoTurnon(actor) = {
	if (actor == jeanieMe)
	    "You're trying to not learn how to use it, remember? ";
	else if (actor == frankMe)
	    "It's a little late to start trying to cook. ";
	else if (actor == debMe)
	    "You'll cook once you've got the groceries put away. ";
    }
    verDoTurnoff(actor) = {
	"It's not on. ";
    }
;

kitchen_sink: fixeditem
    noun = 'sink'
    adjective = 'kitchen'
    location = kitchen
    sdesc = "kitchen sink"
    j_ldesc = "It's the kitchen sink. "
    f_ldesc = (self.j_ldesc)
    d_ldesc = "If only it had a garbage disposal built in. "
    verDoTurnon(actor) = {
	if (actor == jeanieMe)
	    "No way you're going to risk splashing water on you. ";
	else if (actor == frankMe)
	    "Nah. Your hands aren't that dirty. ";
	else "Might as well wait until you're ready to fix supper
	      before you wash your hands. ";
    }
    verDoTurnoff(actor) = { "The sink's not on. "; }
    doSynonym('Turnon') = 'Use'
;

kitchen_cabinets: fixeditem, openable
    isThem = true
    isopen = nil
    checkedForBillfold = nil    // Has Jeanie checked cabinets for billfold?
    noun = 'cabinet' 'cabinets'
    adjective = 'kitchen' 'off-limit'
    location = kitchen
    j_sdesc = "kitchen cabinets"
    f_sdesc = "cabinets"
    d_sdesc = "cabinets"
    j_ldesc = "There are cabinets all around the kitchen. "
    f_ldesc = "Just looking at them is enough to make you want to grab a
	       snack. "
    d_ldesc = "The cabinets are <<self.wordDesc>>. "
    verDoOpen(actor) = {
	if (actor == frankMe)
	    "If you open them you'll get a snack, and you're
	     not going to get a snack, so you're not going to open
	     them. ";
	else pass verDoOpen;
    }
    doOpen(actor) = {
	if (actor == jeanieMe) {
	    if (actor.lookingForBillfold) {
		if (!self.checkedForBillfold) {
		    "Why would your billfold be in there? You
		     check inside the cabinets anyway, and sure enough,
		     it's not there. ";
		    self.checkedForBillfold = true;
		}
		else "Just in case, you take another look in the cabinets,
		      but your billfold's still not in there. ";
	    }
	    else "You rummage through the cabinets, but you're not
		  all that hungry right now. ";
	}
	else pass doOpen;
    }
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) = {
	if (dobj != groceries && !self.isopen) {
	    "The cabinets are closed. ";
	    return;
	}
	pass ioPutIn;
    }
;

kitchen_table: fixeditem, surface
    lookedUnderBefore = nil     // Has J looked under table before?
    noun = 'table'
    adjective = 'small' 'white' 'little'
    location = kitchen
    j_sdesc = "table"
    f_sdesc = "table"
    d_sdesc = "table"
    j_ldesc = {
	if (jeanieMe.lookingForBillfold)
	    "You kinda remember leaving your billfold on the table,
	     but you sure don't see it there now. ";
	else {
	    "A small white table. Sometimes mom makes you and Frank eat
	     dinner here instead of in front of the TV. ";
	    if (itemcnt(self.contents))
		"There's <<listcont(self)>> on it. ";
	}
    }
    f_ldesc = {
	"That little table was supposed to be temporary, just until you
	 and Deb found a real table. These days it's looking more
	 and more permanent. ";
	if (itemcnt(self.contents))
	    "There's <<listcont(self)>> on it. ";
    }
    d_ldesc = {
	"Looking at the table reminds you how long it's been since
	 you, Frank and Jeanie ate around it as a family. ";
	if (itemcnt(self.contents))
	    "On it %you% see%s% <<listcont(self)>>. ";
    }
    verDoLookunder(actor) = {
	if (actor == jeanieMe) {
	    if (!actor.lookingForBillfold) {
		"You look under the table but don't see anything. ";
		// Normally you shouldn't change game state in a ver
                // routine, but it'll be okay in this case
		self.lookedUnderBefore = true;
	    }
	}
	else if (actor != frankMe)
	    pass verDoLookunder;
    }
    doLookunder(actor) = {
	if (actor == frankMe) {
	    "Huh. Jeanie's billfold is under there. ";
	    actor.sawBillfold = true;
	    return;
	}
	"You glance under the table, then get down on your hands
	 and knees. There that stupid thing is! ";
	if (self.lookedUnderBefore)
	    "You can't believe you didn't see it the first time you
	     looked under here. ";
	"You grab the billfold and stand up";
	if (roll_of_bills.takenBills) {
	    ", shoving the money you...found upstairs into it";
	    billfold.addedBills = true;
	}
	". ";
	billfold.moveInto(actor);
	stolen_money.moveInto(nil);
	jeanieMe.lookingForBillfold = nil;
	if (deb.location == nil)
	    deb.enterKitchenWithGroceries;
    }
    doSynonym('Lookunder') = 'Search'
    verDoBoard(actor) = {
	if (actor == jeanieMe)
	    "You used to climb on the table when you were little. You're
	     not little any more. ";
	else if (actor == frankMe)
	    "You'd just as soon not go climbing tables. ";
	else "Frank usually reaches those dishes that you keep on
	      the high shelves of the cabinets. ";
    }
    doSynonym('Board') = 'Standon'
;

refrigerator: fixeditem, openable
    isopen = nil
    checkedForBillfold = nil    // Has player checked fridge for billfold?
    noun = 'refrigerator' 'fridge'
    adjective = 'off-white' 'white'
    location = kitchen
    j_sdesc = "off-white refrigerator"
    f_sdesc = "fridge"
    d_sdesc = (self.j_sdesc)
    ldesc = {
	self.(parserGetMe().ldesc_pointer);
    }
    j_ldesc = "The refrigerator makes this nasty coughing sound from time
	       to time. Why can't mom and Frank buy any decent
	       shit? "
    f_ldesc = {
	"The fridge is humming louder than it used to. It may need a new
	 charge of freon. ";
	if (self.isopen)
	    "Right now it's open, letting out its cold air. Inside
	     it is a bunch of food, some Coke, and some Bud. ";
    }
    d_ldesc = {
	"You and Frank found this refrigerator at a garage sale right
	 before you got married. ";
	if (self.isopen)
	    "It's sitting open, showing its contents to the
	     kitchen. ";
    }
    heredesc = {
	if (!self.isopen) return;
	if (actorObject() == frankMe)
	    "\n\tThe fridge door is open, letting out its cold air. ";
	else "\n\tYou've left the refrigerator door standing open. ";
    }
    // leaving() will be called when someone tries to leave the kitchen.
    // If the fridge door is open, complain. Return nil so that the
    // fridge is never removed from kitchen's leaveList.
    leaving(actor) = {
	if (!self.isopen)
	    return nil;
	if (actor == frankMe)
	    "On your way out you lightly kick the door of the fridge,
	     closing it.\b";
	else "You nudge shut the refrigerator door. ";
	execCommand(actor, closeVerb, self, nil, nil, EC_HIDE_SUCCESS |
		    EC_HIDE_ERROR);
	return nil;
    }
    verDoLookin(actor) = {
	if (actor == jeanieMe)
	    self.doOpen(actor);
	else if (!self.isopen)
	    "It's not open. ";
    }
    doLookin(actor) = {
	if (actor == frankMe)
	    "The main thing you're interested in is the Coke and
	     Bud. ";
	else "There's enough food in there for the rest of the week. ";
    }
    doOpen(actor) = {
	if (actor == jeanieMe) {
	    if (actor.lookingForBillfold) {
		if (!self.checkedForBillfold) {
		    "That'd be just like mom or Frank, hiding your billfold
		     in the fridge to teach you a <q>lesson about
		     responsibility.</q> But when you yank open the fridge
		     you don't see the stupid thing in there, so you close
		     it again. ";
		    self.checkedForBillfold = true;
		}
		else "Haven't you already looked in the fridge? Just
		      in case, you take another brief look
		      inside. Nothing. ";
	    }
	    else "You yank open the fridge. Nothing but healthy food and
		  Frank's beer. Ick. You close it again. ";
	    return;
	}
	self.isopen = true;
	if (actor == frankMe)
	    "Inside the fridge, nestled among the food, are several cans
	     of Coke and Bud. ";
	else if (actor == debMe)
	    "You pull the refrigerator open. ";
    }
    verDoKick(actor) = {
	if (actor != frankMe || !self.isopen)
	    pass verDoKick;
    }
    doKick(actor) = {
	"You nudge the door closed with your foot. ";
	self.isopen = nil;
    }
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) = {
	if (dobj != groceries && !self.isopen) {
	    "The cabinets are closed. ";
	    return;
	}
	pass ioPutIn;
    }
    verDoEnter(actor) = {
	if (actor == jeanieMe)
	    "You can see the headline now. <b>Stupid Kid Dies In
	     Refrigerator.</b> ";
	else if (actor == frankMe)
	    "There's no way you'd fit in there, even if you wanted to
	     get it in. ";
	else "That's just silly. ";
    }
;

// The garage et. al. is only ever seen by Deb.
garage: insideRm
    sdesc = "Carport"
    ldesc = "The carport's in bad need of a cleaning, what with all of
	     the supplies for fixing the cars lining the sides and
	     spilling out almost into the middle. It's getting so you
	     can't hardly find space for the station wagon, though you
	     managed to squeeze it in somehow. And you're beginning
	     to think that you might as well get rid of the bikes.
	     The side door to the house is to the west. "
    exits = 'west'
    south = {
	"Right now all you want to do is get the groceries in the house. ";
	return nil;
    }
    west = house_door
    in = house_door
;

supplies: fixeditem
    isThem = true
    noun = 'supplies'
    location = garage
    sdesc = "supplies"
    ldesc = "There's milk jugs full of used oil, greasy rags, a box of
	     Sorb-It&mdash;all kinds of stuff. "
    takedesc = "You don't need&mdash;or want&mdash;any of it. "
;

used_oil: fixeditem
    isThem = true
    noun = 'oil' 'jug' 'jugs'
    adjective = 'used' 'milk'
    location = garage
    sdesc = "milk jugs of used oil"
    ldesc = "The milk jugs are full of used oil. Frank keeps saying
	     he'll take it to a recycling center soon. "
    takedesc = "You'd just as soon not. "
    verDoOpen(actor) = { "You'd just as soon not. "; }
;

greasy_rags: fixeditem
    isThem = true
    noun = 'rag' 'rags'
    adjective = 'greasy' 'gray'
    location = garage
    sdesc = "greasy rags"
    ldesc = "There's no telling what color they used to be. Now they're
	     mostly gray. "
    takedesc = "What would you do with them? "
;

sorb_it: fixeditem
    noun = 'sorb-it' 'box' 'sorb'
    location = garage
    sdesc = "box of Sorb-It"
    ldesc = "Frank bought it to sprinkle on any oil he spilt on the
	     concrete. Maybe you can get him to use it while he's
	     cleaning the carport this weekend. "
    takedesc = "Leave it for Frank. "
;

bikes: fixeditem
    isThem = true
    noun = 'bike' 'bikes'
    location = garage
    sdesc = "bikes"
    ldesc = "It's just as well Frank hung them out of the way. You
	     bought them when Jeanie was about ten, and the three of
	     you used to ride together. Then Jeanie gave up bikes and
	     started wanting a car. "
    dobjGen(a, v, i, p) = {
        if (v != askVerb and v != tellVerb and v != inspectVerb)
        {
            "Frank hung the bikes up so high you can't reach them. ";
            exit;
        }
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

house_door: lockableDoorway
    isopen = nil
    noAutoOpen = true
    mentionLocked = nil   // At first, don't let player know it's locked
    unlockedBefore = nil  // Has Deb tried to unlock the house door before?
    doordest = {
	"You manage to get through the door with the groceries and
	 close it behind you.\b";
	return living_room;
    }
    mykey = key_ring
    noun = 'door'
    adjective = 'house' 'side'
    location = garage
    sdesc = "side door"
    ldesc = {
	"The side door to the house. ";
	if (self.islocked && self.mentionLocked)
	    "Right now it's locked. ";
    }
    verDoOpen(actor) = {}
    doOpen(actor) = {
	if (station_wagon.isopen)
	    "Better close the car door before you go in. ";
	else if (self.isopen)
	    "It's already open. ";
	else if (self.islocked) {
	    "It's locked. ";
	    if (!self.mentionLocked) {
		self.mentionLocked = true;
		"Frank must've locked it when he got home. ";
	    }
	}
	else {
	    "You almost drop a sack doing it, but you eventually
	     manage to get the side door open. You go through it and
	     close it behind you.\b";
	    actor.travelTo(living_room);
	}
    }
    verDoUnlockWith(actor, io) = {
	if (!io.isIn(actor))
	    "You've got to be holding <<io.thedesc>> to unlock the door. ";
	else pass verDoUnlockWith;
    }
    doUnlockWith(actor, io) = {
	if (!self.unlockedBefore) {
	    self.unlockedBefore = true;
	    "You pull your key ring out, but drop it before you can
	     unlock the door. <q>Shit!</q>\ you exclaim, then look
	     around. Looks like no one heard you. ";
	    if (station_wagon.closedBefore) // Have we had trouble w/car?
		"\bIt's just not your night. ";
	    io.moveInto(garage);
	}
	else {
	    "You fumble with your keys and finally manage to get the
	     door unlocked. ";
	    self.setIslocked(nil);
	}
    }
    doKnock(actor) = {
	"Frank must be busy, because he doesn't come to the door. ";
    }
;

station_wagon: fixeditem, keyedLockable
    doorIsAjar = nil           // Is the door open just a little bit?
    contentsVisible = true
    contentsReachable = { return (self.isopen && !self.doorIsAjar); }
    isopen = true
    closedBefore = nil         // Has Deb tried to close the car before?
    mykey = key_ring
    noun = 'wagon' 'car'
    adjective = 'station' 'panel' 'paneled' 'panelled'
    location = garage
    sdesc = "station wagon"
    ldesc = {
	"It's an old panel station wagon. Still gets decent gas
	 mileage. Of course, Jeanie hates to be seen in it. ";
	if (self.isopen) {
	    if (self.doorIsAjar)
		"The door's just a little bit open, enough so that
		 the dome light's still on. ";
	    else "Its door's open. ";
	}
    }
    heredesc = {
	if (!self.isopen) return;
	if (self.doorIsAjar)
	    "\n\tThe station wagon's door is still ajar the tiniest
	     bit. ";
	else "\n\tThe station wagon's door is wide open. ";
    }
    verIoPutIn(actor) = {
	"You're more interested in getting things out of the car. ";
    }
    verDoBoard(actor) = {
	"Seeing as how you just got back from the store, you don't
	 really need to go anywhere right now. ";
    }
    doSynonym('Board') = 'Enter' 'Siton' 'Turnon'
    verDoOpen(actor) = {
	if (self.isopen) {
	    "It's already open. ";
	    if (self.doorIsAjar)
		"Mostly. ";
	}
	else if (self.islocked)
	    "It's locked. ";
    }
    doOpen(actor) = {
	self.isopen = true;
	"You adjust the groceries and manage to pull open the car
	 door. ";
    }
    doClose(actor) = {
	if (!self.closedBefore) {
	    self.closedBefore = true;
	    "You bump the door closed with your hip, but it doesn't
	     quite make it. It stops short, leaving the dome light on. ";
	    self.doorIsAjar = nil;
	    return;
	}
	if (self.doorIsAjar) {
	    "You bump the door again with your hip and manage to shut
	     it. ";
	    self.doorAjar = nil;
	}
	else "You hit the door pretty hard with your hip. It closes. ";
	self.isopen = nil;
    }
;

car_door: fixeditem
    noun = 'door'
    adjective = 'car'
    location = garage
    sdesc = "car door"
    ldesc = {
	if (station_wagon.isopen) {
	    if (station_wagon.doorIsAjar)
		"The door's still just the tiniest bit open. ";
	    else "The door's wide open. ";
	}
	else "You've finally shut the car door. ";
    }
    doOpen -> station_wagon
    doClose -> station_wagon
    doUnlock -> station_wagon
    doLock -> station_wagon
    doUnlockWith -> station_wagon
    doLockWith -> station_wagon
;

dome_light: fixeditem
    noun = 'light'
    adjective = 'dome'
    location = station_wagon
    sdesc = "dome light"
    ldesc = {
	if (station_wagon.isopen)
	    "The dome light's on. ";
	else "It's off now. ";
    }
;
