/*
** GndJean.t holds all the definitions etc. for Jeanie
**
** Copyright (c) 1999, Stephen Granade. All rights reserved.
*/

#pragma C+

#define MAX_IDLE_TIME 7
#define IMPATIENCE_TIME 3

jeanieMe: basicMe
    blushOn = nil          // Wearing blush?
    eyeshadowOn = nil      // Wearing eyeshadow?
    mascaraOn = nil        // Wearing mascara?
    makeupDone = nil       // Done putting on makeup?
    hurriedMakeup = nil    // Did Jeanie hurry up her makeup?
    billfoldTriggered = nil     // Have we been told to look for billfold?
    lookingForBillfold = nil    // Looking for her billfold?
    mentionedKitchenAgain = nil // For when I'm looking upstairs for billfold
    beenDownstairs = nil   // Been downstairs yet?
    franksBeenSarky = nil  // Has Frank made his crack about my billfold?
    expressedImpatience = nil // Have I drummed my fingers yet?
    frankCurrentTalk = 1   // Which possible conversation thread w/Frank
                           // are we on?
    debCurrentTalk = 1     // Ditto with Deb
    waitCount = 0          // Keep track of successive "wait" commands
    hornCount = 0          // How many times has April honked?
    helpCount = 0          // How many times have I helped mom w/groceries?
    kissedDeb = nil        // Have I kissed mom?
    mentionedTown = nil    // Have I mentioned that I live in a small town?
    mentionedDream = nil   // have I mentined that I want to be in a video?
    // frankTalkList is the list of conversation threads w/Frank
    frankTalkList = [ &conversationf1a, &conversationf2a, &conversationf3a ]
    // ditto momTalkList
    debTalkList = [ &conversationd1a, &conversationd2a ]
    j_sdesc = "you"
    j_ldesc = "You've gone with your jean cut-offs and a plaid
	       shirt tonight. Nothing fancy, but then it doesn't
	       really need to be. "
    // Use roomCheck to keep track of successive "wait" commands
    // (only when the TV isn't on, and not while Jeanie hunts a billfold or
    // while she's first upstairs)
    roomCheck(v) = {
	if (v == waitVerb && isclass(uberloc(self), houseRm) &&
	    !(tv.isActive || self.lookingForBillfold ||
	      !self.beenDownstairs)) {
	    self.waitCount++;
	    if (self.waitCount > IMPATIENCE_TIME &&
		!self.expressedImpatience) {
		self.expressedImpatience = true;
		"You stop yourself from <<self.location == couch ?
		 'drumming your fingers on the couch' : 'tapping your foot'
		 >>. You so can't wait to be out of here. ";
		return nil; // This aborts the command, but that won't
	    }               // really matter. The player'll never notice
	    if (self.waitCount > MAX_IDLE_TIME) {
		if (self.billfoldTriggered) { // We must've found the billfold
		    unnotify(self, &hearHorn);
		    notify(self, &hearHorn, 1);
		}
		else {
		    unnotify(self, &startBillfoldHunt);
		    notify(self, &startBillfoldHunt, 1);
		}
	    }
	}
	else self.waitCount = 0;
	pass roomCheck;
    }
    talkTo(person) = {
	if (self.makeResponse(person)) return;
	if (person == frank) {
	    if (self.lookingForBillfold && !self.franksBeenSarky) {
		if (jeanie.gotYelledAtAboutTV ||
		    jeanie.gotYelledAtAboutMoney)
		    "You'd ask him about your billfold, but Frank
		     never knows where anything is. Besides, he'd
		     just snap your head off again. ";
		else {
		    "<q>Hey, Frank, you know where my billfold is?</q>
		     \bHe snorts. <q>Like I'm your billfold's keeper.</q>
		     He seems to think that's real funny. ";
		    frankMe.queueAction('*Cb');
		    self.franksBeenSarky = true;
		}
	    }
	    else if (jeanie.gotYelledAtAboutTV ||
		jeanie.gotYelledAtAboutMoney) {
		"After he raked you over the coals for ";
		if (jeanie.gotYelledAtAboutTV)
		    "wanting to watch a little TV";
		else "asking for a little money";
		"? Fuck that. ";
	    }
	    else if (self.frankCurrentTalk > length(self.frankTalkList))
		"Frank's absorbed in his work again. You talking
		 to him more's only likely to make him mad. ";
	    else {
		// If Deb's arrived from the store, there's no reason
		// why Jeanie would ask Frank where she went. So skip
		// that bit of conversation.
		if (self.frankCurrentTalk == 2 && deb.location != nil)
		    self.frankCurrentTalk++;
		self.(self.frankTalkList[self.frankCurrentTalk]);
		self.frankCurrentTalk++;
	    }
	}
	else if (person == deb) {
	    if (self.debCurrentTalk > length(self.debTalkList)) {
		if (debMe.toldJAboutRoast)
		    "There's not much else you wanna say to her. ";
		else "Why bother? She never really listens anyway. ";
	    }
	    else {
		self.(self.debTalkList[self.debCurrentTalk]);
		self.debCurrentTalk++;
	    }
	}
	else if (person == ticket_guy)
	    "You go to talk to the ticket guy, but he looks up at
	     you and what you were going to say gets stuck in your
	     throat. ";
	else if (person == fake_bus_driver)
	    "He frowns. Maybe he can't hear you over the bus engine. ";
	else if (person == bus_driver) {
	    if (ticket.isIn(person))
		"<q>Siddown,</q> he tells you. <q>We got a schedule.</q> ";
	    else {
		"<q>You gonna give me your ticket or what?</q> ";
		bus.jeanieJustTalked = true;
		notify(bus, &clearJustTalkedFlag, 1);
	    }
	}
	else if (person == self)
	    "Only your science teacher mutters to himself. ";
	else "Hey! How come you can talk to <<person.sdesc>>?
	      <i>{Error}</i>. ";
    }
    mutterAboutLeaving = {
	"<q>Like you give a rat's ass,</q> you mutter to
	 Frank.
	 \b<q>What?</q> he says.
	 \b<q>Nothing,</q> you say. ";
	if (!self.mentionedTown) {
	    self.mentionedTown = true;
	    "It's not like there's much to do in this shitty little
	     town anyway. ";
	}
	self.clearResponse;
	return true;
    }
    complainAboutTV1 = {
	"<q>Frank, I'm gonna be leaving in a few. Why can't I
	 watch TV?</q>
	 \bFrank doesn't even turn around. <q>Because I said so.</q> ";
	frankMe.queueAction('!Cc1');
	self.setResponse(&complainAboutTV2, frank);
	return true;
    }
    complainAboutTV2 = {
	"<q><q>I said so</q>? What kind of stupid reason is that?</q>
	 \bWith a heavy sigh Frank twists in his chair. <q>Look, I had a
	 rough day at work and your mom's been on my case about
	 fixing this thing. I want to finish up here before she gets home,
	 and the TV was distracting me.</q> He turns back to his desk. ";
	frankMe.queueAction('!Cc2');
	self.setResponse(&complainAboutTV3, frank);
	return true;
    }
    complainAboutTV3 = {
	"You frown at him. <q>I'll turn the volume down real low,
	 you won't even hear&mdash;</q>
	 \b<q>I said I wanted the TV off and it's goddamned going to
	 stay off, you hear?</q> Frank yells. <q>So shut your trap and
	 quit bugging me!</q> All you can do is stare at him and
	 imagine ripping chunks of hair from his head. ";
	frankMe.queueAction('!Cc3');
	jeanie.gotYelledAtAboutTV = true;
	self.clearResponse;
	return true;
    }
    conversationf1a = {
	local stat;

	"You wander over to Frank's desk and look at the jumble on
	 it. <q>What'cha working on?</q>
	 \b<q>Toaster,</q> he says, staring at the inside of a chrome-plated
	 box. ";
	if (self.location == couch) {
	    stat = outhide(true);
	    couch.doUnboard(self);
	    outhide(stat);
	}
	frankMe.queueAction('*C1a');
	jeanie.askedAboutWork1 = true;
	self.setResponse(&conversationf1b, frank);
	return true;
    }
    conversationf1b = {
	"<q>Toaster, huh? What's wrong with it?</q>
	 \b<q>Thought it was the heater element shorting, but that
	 wasn't it.</q> He goes on a while about the toaster, almost
	 makes you wish you hadn't asked. Finally he gets to the
	 point. <q>Anyway, the power cord's shot, so now
	 I'm replacing it.</q>";
	frankMe.queueAction('*C1b');
	self.setResponse(&conversationf1c, frank);
	return true;
    }
    conversationf1c = {
	"You take a couple of steps away from Frank. <q>Gotta have
	 toast, huh?</q> But he's not even listening. ";
	self.clearResponse;
	return true;
    }
    conversationf2a = {
	"<q>Hey, Frank, where'd mom go?</q>
	 \b<q>Groceries.</q> He leans his head from side to side, trying
	 to loosen tense muscles. <q>Piggly Wiggly. Hope you told her what
	 you wanted this week.</q> ";
	frankMe.queueAction('*C2a');
	self.setResponse(&conversationf2b, frank);
	return true;
    }
    conversationf2b = {
	if (frank.jeanieTriedToRubMe)  // If J massaged F, skip this
	    return nil;
	"<q>Nah,</q> you say, shaking your head. <q>Doesn't matter.</q>
	 \b<q>Well, okay,</q> he says. ";
	frankMe.queueAction('*C2b');
	self.clearResponse;
	return true;
    }
    conversationf3a = {
	"<q>By the way, could you spot me a couple of bucks for tonight?</q>
	 you ask as casually as you can.
	 \bHe sighs and runs a hand through what's left of his hair.
	 <q>You know money's tight this month.</q> ";
	frankMe.queueAction('!C3a');
	self.setResponse(&conversationf3b, frank);
	return true;
    }
    conversationf3b = {
	if (frank.massageHappenedRecently) {
	    frank.massageHappenedRecently = nil;
	    "<q>Okay, okay, I won't,</q> you tell Frank. You pause
	     for a second. <q>You sure I can't have some money? I
	     know money's tight, but it's not like I'm asking for
	     much. ";
	}
	else "<q>I know. But it's not like I'm asking for much. ";
	if (!self.mentionedTown) {
	    self.mentionedTown = true;
	    "I mean, there's not a lot of places to spend money around
	     here 'cept the Sonic. ";
	}
	"All's I need is like a ten or something.</q>
	 \b<q>Look, I told you already. Money's tight, and I don't
	 have any to give you. Now quit yapping
	 about it.</q> Frank pointedly turns back to the toaster. ";
	frankMe.queueAction('!C3b');
	self.setResponse(&conversationf3c, frank);
	return true;
    }
    conversationf3c = {
	local stat;

	if (frank.massageHappenedRecently) {
	    frank.massageHappenedRecently = nil;
	    "<q>Okay, okay, I won't,</q> you tell Frank, moving around
	     his desk and standing where he has to look at you. <q>But
	     why can't I have any money? It's not like I'm asking you to
	     give blood here!</q> ";
	}
	else "You go to Frank's desk and stand so he has to look at you.
	 <q>C'mon, Frank! I'm not asking you to give blood
	 here!</q> ";
	"\bHe looks up, his hands grabbing at the toaster like he'd
	 like to throw it. <q>Do you ever know when to shut up? I'm
	 working myself to death and all I hear is <q>Gimme! Gimme!
	 Gimme!</q> You want money? Spend more time at Hardee's
	 and less time pissing me off.</q> He goes back to work. You flip
	 him off behind his back as you walk away. ";
	if (self.location == couch) {
	    stat = outhide(true);
	    couch.doUnboard(self);
	    outhide(stat);
	}
	frankMe.queueAction('!C3c');
	jeanie.gotYelledAtAboutMoney = true;
	self.clearResponse;
	return true;
    }
    conversationd0 = {
	// If we've already put up some groceries, skip this conversation
	if (self.helpCount > 0)
	    return nil;
	"You start to say no, but end up saying, <q>Um, if I\'ve got
	 enough time.</q> ";
	debMe.queueAction('C0');
	self.clearResponse;
	return true;
    }
    conversationd1a = {
	"<q>What'd you get at the store?</q> you ask mom.
	 \b<q>Right, uh-huh. The usual. Oh,</q> she says, pulling a
	 box out of a sack and showing it to you. <q>I got Wheat
	 Thins for you.</q> She puts the box away. ";
	debMe.queueAction('C1');
	self.clearResponse;
	return true;
    }
    conversationd2a = {
	"<q>Don't forget I won't be here for supper,</q> you
	 tell mom.
	 \b<q>Right, uh-huh, right,</q> mom says. She sighs. <q>I wish
	 you'd eat supper here a little more often.</q> ";
	debMe.queueAction('C2a');
	self.setResponse(&conversationd2b, deb);
	return true;
    }
    conversationd2b = {
	"<q>I <i>do</i> eat here!</q> you say. <q>At least a couple nights
	 a week, like you asked!</q>
	 \b<q>Uh-huh, right, right.</q> Mom nods vigorously. <q>You do
	 eat with us sometimes. I just like it when we eat as a family.</q> ";
	debMe.queueAction('C2b');
	self.setResponse(&conversationd2c, deb);
	return true;
    }
    conversationd2c = {
	"You grimace. <q>Well, I can't be here all the time,
	 okay?</q>
	 \b<q>Right, uh-huh, yeah,</q> mom says sadly. ";
	debMe.queueAction('C2c');
	self.clearResponse;
	return true;
    }
    conversationd3 = {
	"<q>I'll be back when I can,</q> you tell mom. ";
	debMe.queueAction('C3');
	self.clearResponse;
	return true;
    }
    conversationdr = {                // Say thanks for roast
	"<q>Um, thanks.</q>\b<q>Right, right, you're welcome.</q> ";
	debMe.jRespondedToRoast = true;
	self.clearResponse;
	return true;
    }
    startBillfoldHunt = {
	if (self.billfoldTriggered)   // Suspenders & belt -- this shouldn't
	    return;                   // be necessary, but just in case....
	"\bYour billfold! You";
	if (roll_of_bills.takenBills)
	    " could use more money for";
	else "'ll definitely need your money";
	" tonight. It better still be in ";
	if (self.isIn(kitchen))
	    "here";
	else "the kitchen";
	" where you left it after school. ";
	self.lookingForBillfold = true;
	self.billfoldTriggered = true;
    }
    hearHorn = {
	if (jeanieMe.location == nil) // We're on to the next section
	    return;
	unnotify(self, &hearHorn);    // I'm getting double fuses from
	self.hornCount++;             // somewhere, hence this narsty
	switch (self.hornCount) {     // unnotify() workaround
	    case 1:
	    "\bYou hear a car horn being honked outside in front of the
	     house. Must be April. ";
	    if (deb.location == self.location) {
		"Your mom stops putting up groceries and smiles sadly at
		 you. <q>Right, right, you have a good time
		 tonight, okay, dear? Don't be out too late.</q> ";
		jeanieMe.setResponse(&conversationd3, deb);
		debMe.queueAction('H0');  // H0 takes precedence
	    }
	    else debMe.queueAction('H1');
	    notify(self, &hearHorn, 3 + _rand(2));
	    break;

	    case 2:
	    "\bYou hear the horn honk again a couple of times. You'd
	     better get going or else April'll leave you. ";
	    debMe.queueAction('H2');
	    notify(self, &hearHorn, 2 + _rand(2));
	    break;

	    case 3:
	    "\bApril really leans on the horn this time. ";
	    self.grabMyBagOnTheWayOut;
	    " yank open the front door. Sure enough, there's April
	     in her old Mustang. You slam the door shut on your way out
	     and head for her car.\b";
	    debMe.queueAction('H3');
	    prepareForFrank();           // This'll write the action
	    break;
	}
    }
    // This is the logic which deals with Jeanie getting her bag when
    // she leaves. It prints a string which looks something like
    // "You pick up your bag and". The string ends w/Jeanie in the hallway
    // (or living room, assuming she's going out the door)
    grabMyBagOnTheWayOut = {
	"You ";
	if (!flowerdy_bag.isIn(self)) {
	    if (flowerdy_bag.isIn(self.location))
		"pick up your bag";
	    else "go grab your bag";
	    if (flowerdy_bag.location != hallway) {
		", run ";
		if (self.location == hallway) "back ";
		"to the hallway,";
	    }
	    " and";
	}
	else if (self.location != hallway)
	    "run to the hallway and";
	debMe.queueAction('B');        // Tell Deb that Jeanie's left
    }
    // Jeanie will play w/ticket in the bus station as she tries to
    // decide about staying or going
    playWithTicket = {
	"\bYou ";
	if (!ticket.isIn(self)) {
	    "shift from one foot to another as you wait. Now that
	     you're actually here, will you go through with it? I mean,
	     what if you only make things worse? ";
	    return;
	}
	if (ticket.isIn(flowerdy_bag))
	    "take the ticket out of the bag and turn it";
	else "turn your ticket";
	" over and over, looking first at one side, then the other. LA.
	 It's so far away. Surely you'll be an actress, right? ";
    }
;

cut_offs: item
    isListed = nil
    noun = 'shorts' 'cut-offs' 'jeans'
    adjective = 'jean' 'short'
    location = jeanieMe
    j_sdesc = "jean cut-offs"
    f_sdesc = "short shorts"
    d_sdesc = "jean shorts"
    j_ldesc = "They're starting to fray a little around the edges, but
	       they're still good. "
    f_ldesc = "They're about as short as they can be and still cover
	       all the important parts. "
    d_ldesc = "She must be cold in those shorts of hers. "
    verifyRemove(actor) = {
	if (actor == jeanieMe)
	    "Geez, don't you get enough flak from people without running
	     around in your skivvies? ";
	else if (actor == frankMe)
	    "Good God, no! ";
	else if (actor == debMe)
	    "It's been a long time since you've dressed or undressed
	     Jeanie. ";
    }
    verDoWear(actor) = {
	if (actor == jeanieMe)
	    "You're already wearing them. ";
	else "You'd have to have them first. ";
    }
    verDoUnwear(actor) = (self.verifyRemove(actor))
    doSynonym('Unwear') = 'Unboard'
    verDoLookunder(actor) = {
	if (actor == jeanieMe)
	    "It's full of you. ";
	else if (actor == frankMe)
	    "Sure, look up her shorts. That'd be good. ";
	else "Why? ";
    }
;

plaid_shirt: item
    isListed = nil
    noun = 'shirt'
    adjective = 'plaid'
    location = jeanieMe
    sdesc = "plaid shirt"
    j_ldesc = "It keeps getting more comfy the older it is. "
    f_ldesc = "If she's going to wear that shirt, couldn't she at least
	       untie it? "
    d_ldesc = "You're glad that plaid shirt of hers'll keep her warm. "
    verifyRemove(actor) = {
	if (actor == jeanieMe)
	    "Geez, don't you get enough flak from people without running
	     around in your skivvies? ";
	else if (actor == frankMe)
	    "Good God, no! ";
	else if (actor == debMe)
	    "It's been a long time since you've dressed or undressed
	     Jeanie. ";
    }
    verDoWear(actor) = {
	if (actor == jeanieMe)
	    "You're already wearing it. ";
	else "You'd have to have it first. ";
    }
    verDoUnwear(actor) = (self.verifyRemove(actor))
    doSynonym('Unwear') = 'Unboard'
    verDoLookunder(actor) = {
	if (actor == jeanieMe)
	    "It's full of you. ";
	else if (actor == frankMe)
	    "Sure, look up her shirt. That'd be good. ";
	else "Why? ";
    }
;

jeanies_hair: item
    isListed = nil
    noun = 'hair'
    adjective = 'your' 'blond' 'blonde' 'bleached'
    location = jeanieMe
    sdesc = "hair"
    adesc = "your hair"
    thedesc = "your hair"
    ldesc = "It's been a while since you bleached it, and you know your
	     roots are starting to show. It'll be okay for another few
	     days, though. "
    verifyRemove(actor) = {
	if (actor == jeanieMe)
	    "Yeah. Right. ";
	else "You shouldn't have seen this. Let Stephen know, willya?
	      <i>{Error}</i> ";
    }
    verDoTake(actor) = {
	self.verifyRemove(actor);
    }
    dobjGen(a, v, i, p) = {
        if (!v.issysverb && v.touch) {
            "You spent so much time getting your hair ready, you're
	     not going to do anything to mess it up. ";
            exitobj;
        }
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a,v,d,p); }

;

jeanie: Actor
    isHer = true
    // Conversation flags
    askedAboutWork1 = nil
    gotYelledAtAboutTV = nil
    gotYelledAtAboutMoney = nil
    onCouch = nil
    noun = 'jeanie' 'daughter'
    sdesc = "Jeanie"
    adesc = "Jeanie"
    f_ldesc = "She's obviously going out tonight: she's all made up and
	       wearing those short shorts of hers. And if she tied that
	       plaid shirt of hers any higher her boobs'd fall out the
	       bottom. "
    d_ldesc = {
	"Jeanie doesn't normally wear too much makeup, but tonight she's
	 got a lot of it on. Could she be dating someone and not telling
	 you or Frank? ";
	if (flowerdy_bag.location == self)
	    "She's carrying her flowery bag over one shoulder. ";
    }
    actorDesc = {
	local currentMe = parserGetMe();

	if (currentMe == frankMe) {
	    if (self.onCouch)
		"Jeanie is sprawled out on the couch, staring at the TV.";
	    else "Jeanie's wandering around the room, occasionally looking
		  over to see what you're doing. ";
	}
	else if (currentMe == debMe)
	    "Standing in the middle of the kitchen is Jeanie. ";
    }
    takedesc = {
	"You haven't been able to hold Jeanie like that since she was
	 eight. ";
    }
    verDoKiss(actor) = {
	if (actor == frankMe)
	    "She probably'd take it the wrong way. ";
	else if (actor == debMe)
	    "She doesn't like it much when you do that now. ";
	else "That's just wacky. ";
    }
    verDoScrew(actor) = {
	if (actor == frankMe)
	    "Good God, no! ";
	else if (actor == debMe)
	    "Such thoughts! ";
    }
    verDoTouch(actor) = {
	if (actor == frankMe)
	    "She'd definitely take that the wrong way. ";
	else if (actor == debMe)
	    "She seems a little distant tonight. ";
	else pass verDoTouch;
    }
    doSynonym('Touch') = 'Rub'
    ioGiveTo(actor, dobj) = {
	if (actor == frankMe)
	    "She'd probably just rip your head off. ";
	else if (actor == debMe)
	    "She doesn't seem to want anything from you any more. ";
    }
    ioSynonym('GiveTo') = 'ThrowTo'
    verDoAttack(actor) = {
	if (actor == frankMe)
	    "No! No. She may bug the hell out of you, but actually
	     hit her? No. ";
	else if (actor == debMe)
	    "Hurt Jeanie? Never. ";
    }
    doSynonym('Attack') = 'Kick' 'Push' 'Pull' 'Poke'
    verIoThrowAt(actor) = ( self.verDoAttack(actor))
;

// Time to tidy up stuff for Jeanie's final scene
reprepareForJeanie: function
{
    debMe.moveInto(nil);              // Just in case
    parserSetMe(jeanieMe);
    jeanieMe.moveInto(bus_station_counter_room);

    // Move Jeanie's stuff back
    cut_offs.moveInto(jeanieMe);
    plaid_shirt.moveInto(jeanieMe);
    new_bag.moveInto(jeanieMe);

    morePrompt();
    clearscreen();
    if (global.canDoGraphics)
	gprintf('four.png', 'alt="Four"');
    else "\(Four\)\n";
    "\nApril asked if you wanted her to wait with you, but you told her
     nah and so she just dropped you off at the station.
     \bIt was real easy to buy a ticket. You were afraid they'd want to
     see ID or maybe a letter from mom or <i>something</i>, but the
     guy just took your money and didn't say nothing.
     \bThis all seems unreal, somehow.\b";
    execCommand(jeanieMe, lookVerb, nil, nil, nil, 0);
}

flowerdy_bag: item
    noun = 'bag'
    adjective = 'flowerdy' 'flowery'
    location = jeanie_bedroom
    j_sdesc = "flowerdy bag"
    f_sdesc = "flowery bag"
    d_sdesc = "flowery bag"
    j_ldesc = {
	"You sometimes wonder if you should replace it, but
	 you really like the flowers printed on it. Most
	 everything you need's in it";
	if (jeanieMe.lookingForBillfold)
	    "&mdash;everything but your billfold, that is";
	if (itemcnt(self.contents) != 0) {
	    if (jeanieMe.lookingForBillfold)
		"&mdash;";
	    else ", ";
	    "including <<listcont(self)>>";
	}
	". ";
    }
    f_ldesc = "Jeanie's always toting that thing around. "
    d_ldesc = "It's been Jeanie's favorite bag for about a year. "
    frankDisavow = "Jeanie'd just get mad at you for messing with her bag. "
    debDisavow = "Jeanie never likes you messing with her bag. "
    dobjGen(a, v, i, p) = {
	if (v.touch && a != jeanieMe) {
	    if (a == frankMe)
		self.frankDisavow;
	    else self.debDisavow;
	    exitobj;
	}
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
    moveInto(obj) = {
	// First, note if Jeanie drops the bag where Frank or Deb can see
	if (self.location == jeanieMe) {
	    if (obj == living_room)
		frankMe.queueAction('DL');
	    else if (obj == couch)
		frankMe.queueAction('DC');
	    else if (obj == kitchen)
		debMe.queueAction('DK');
	    else if (obj == kitchen_table)
		debMe.queueAction('DT');
	    else if (obj == kitchen_counters)
		debMe.queueAction('DC');
	}
	// Second, note if she picks up the bag in front of Deb or Frank
	else if (obj == jeanieMe) {
	    if (self.location == living_room ||
		self.location == couch)
		frankMe.queueAction('P');
	    else if (self.location == kitchen ||
		     self.location == kitchen_table ||
		     self.location == kitchen_counters)
		debMe.queueAction('P');
	}
	pass moveInto;
    }
    verOpen(actor) = {
	if (actor == frankMe)
	    self.frankDisavow;
	else if (actor == debMe)
	    self.debDisavow;
	else "The bag's pretty much always open. ";
    }
    verClose(actor) = (self.verOpen(actor))
    verIoPutIn(actor) = {
	if (actor == frankMe)
	    "No sense in doing that&mdash;Jeanie would just get mad. ";
	else if (actor == debMe)
	    self.debDisavow;
    }
    ioPutIn(actor, dobj) = {
	if (dobj == remote) {
	    "No sense carting that thing around with you. ";
	    return;
	}
	else if (dobj == makeup) {
	    "You put all of your makeup into your bag. ";
	    makeup.allMove(flowerdy_bag);
	}
	else {
	    "You drop <<dobj.thedesc>> into your bag. ";
	    dobj.moveInto(self);
	}
    }
    verDoLookin(actor) = {
	if (actor == frankMe)
	    "There's all kinds of junk in there. Why does Jeanie have to
	     lug all of it around? You'd think she was going camping. ";
	else if (actor == debMe)
	    "She has her necessities in it. ";
	else {
	    "It's got what you need for tonight";
	    if (jeanieMe.lookingForBillfold)
		"&mdash;everything but your billfold, that is";
	    if (itemcnt(self.contents) != 0) {
		if (jeanieMe.lookingForBillfold)
		    "&mdash;";
		else ", ";
		"including <<listcont(self)>>";
	    }
	    ". ";
	}
    }
    doSynonym('Lookin') = 'Search'
;

// The simpler bag which Jeanie will use at the end
new_bag: item
    noun = 'bag'
    adjective = 'flowerdy' 'flowery'
    sdesc = "flowerdy bag"
    ldesc = {
	"Most everything you need's in the bag: <<listcont(self)>>. ";
    }
    verOpen(actor) = { "The bag's pretty much always open. "; }
    verClose(actor) = (self.verOpen(actor))
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) = {
	"You drop <<dobj.thedesc>> into your bag. ";
	dobj.moveInto(self);
    }
    verGrab(obj) = {
	if (obj != ticket)
	    "Might as well leave <<obj.isThem ? 'them' : 'that'>> in
	     there. ";
    }
    verDoLookin(actor) = {}
    doLookin(actor) = (self.ldesc)
    doSynonym('Lookin') = 'Search'
;

change_of_clothes: item
    noun = 'clothes'
    adjective = 'change'
    location = new_bag
    sdesc = "change of clothes"
    ldesc = "It's a change of clothes for later. "
;

extra_underwear: item
    noun = 'underwear'
    adjective = 'extra'
    location = new_bag
    sdesc = "extra underwear"
    ldesc = "Some extra underwear, so you won't have to wash clothes
	     so much. "
    adesc = "some <<self.sdesc>>"
;

billfold: item
    addedBills = nil   // Are the bills from Frank's drawer inside me?
    noun = 'billfold' 'wallet'
    adjective = 'my'
    sdesc = "billfold"
    ldesc = {
	"All the money you've made the last month at Hardee's";
	if (self.addedBills)
	    " plus what you took from Frank's stash";
	" is jammed in there. ";
	if (isclass(jeanieMe.location, busRm))
	    "Well, all but what you used to buy the ticket. ";
    }
    verDoOpen(actor) = {
	"You pop it open and take a quick look. ";
	if (isclass(jeanieMe.location, busRm))
	    "Most all of";
	else "All";
	" your Hardee's money from the last month";
	if (self.addedBills)
	    "&mdash;plus what you took from Frank's stash&mdash;";
	else " ";
	"is in there. ";
    }
    verDoPutIn(actor, io) = {
	if (io != flowerdy_bag)
	    pass verDoPutIn;
	else if (self.location == io)
	    "\^<<self.thedesc>>'s already in <<io.thedesc>>. ";
    }
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) = {
	if (dobj != change)
	    "\^<<dobj.thatdesc>> <<dobj.doesdesc>>n't go in the
	     billfold. ";
	else {
	    "You slide your change into the billfold. ";
	    change.moveInto(nil);
	}
    }
    verifyRemove(actor) = {
	"Nuh-uh. Now that you found it, you're not gonna risk
	 losing it again. ";
    }
;

billfold_money: item
    isListed = nil
    noun = 'money'
    adjective = 'hardee' 'hardees' 'hardee\'s'
    location = billfold
    sdesc = "money"
    ldesc = {
	"It's ";
	if (isclass(jeanieMe.location, busRm))
	    "most all of ";
	"what you made at Hardee's the last month";
	if (billfold.addedBills)
	    ", plus what you took from Frank's dresser";
	". ";
    }
    verifyRemove(actor) = {
	"Nuh-uh. Now that you found it, you're not gonna risk
	 losing it again. ";
    }
;

stolen_money: item
    isListed = nil
    noun = 'money' 'bill' 'bills'
    adjective = 'stolen'
    sdesc = "stolen money"
    ldesc = "You pat the money you took from Frank. It's still where
	     you hid it. "
    verDoCount(actor) = {
	if (frank.isIn(uberloc(actor)))
	    "Not in front of Frank! ";
    }
    doCount(actor) = "You pull it out and count it before putting it
		      away again. There's about eighty dollars there. "
    verifyRemove(actor) = {
	"No way. Either keep it or put it back where you found it. ";
    }
    verDoPutIn(actor, io) = {
	if (io != nightstand && io != nightstand_drawer &&
	    io != roll_of_bills)
	    pass verDoPutIn;
        if (io == self)
	    "You can't put the money in itself. ";
        else if (io.isIn(self))
            self.circularMessage(io);
    }
    doPutIn(actor, io) = {
	"You put the bills back where they came from. ";
	self.moveInto(nil);
	roll_of_bills.takenBills = nil;
    }
;

// A fake 'makeup' object, to handle 'wear makeup' and 'take makeup'
makeup: item
    isListed = nil
    notakeall = true
    makeupList = [ foundation blush eye_shadow mascara ]
    noun = 'makeup'
    location = jeanie_vanity
    sdesc = "makeup"
    adesc = "makeup"
    ldesc = "You normally wear foundation, blush, eye shadow, and
	     mascara. "
    allIn(loc) = {
	local i;

	for (i = 1; i <= length(self.makeupList); i++)
	    if (self.makeupList[i].location != loc)
		return nil;
	return true;
    }
    allMove(loc) = {
	local i;

	for (i = 1; i <= length(self.makeupList); i++)
	    self.makeupList[i].moveInto(loc);
    }
    doTake(actor) = {
	local list = [], i;

	for (i = 1; i <= length(self.makeupList); i++) {
	    if (execCommand(actor, takeVerb, self.makeupList[i], nil,
			     nil, EC_HIDE_ERROR | EC_HIDE_SUCCESS) == 0 &&
		self.makeupList[i].isIn(actor))
		list += self.makeupList[i];
	}
	if (length(list) == 0)
	    "You've already taken all the makeup you can reach. ";
	else {
	    "You grab ";
	    for (i = 1; i <= length(list); i++) {
		if (i > 1) {
		    if (i < length(list))
			", ";
		    else if (i == 2)
			" and ";
		    else ", and ";
		}
		list[i].thedesc;
	    }
	    ". ";
	}
    }
    verDoApply(actor) = {
	if (actor.makeupDone)
	    "You're done with your makeup. ";
    }
    doApply(actor) = {
	if (!actor.blushOn)
	    blush.doApply(actor);
	else if (!actor.eyeshadowOn)
	    eye_shadow.doApply(actor);
	else mascara.doApply(actor);
    }
    doSynonym('Apply') = 'Wear'
;

foundation: makeupItem
    noun = 'foundation' 'special' 'container'
    adjective = 'maybelline' 'k-mart' 'special' 'round'
    location = jeanie_vanity
    sdesc = "foundation"
    adesc = (self.sdesc)
    ldesc = "Good old Maybelline K-Mart special in its round container. "
    verDoApply(actor) = { "You've already put on foundation. "; }
;

blush: makeupItem
    noun = 'blush' 'container'
    adjective = 'maybelline' 'pink' 'square' 'squarish'
    location = jeanie_vanity
    sdesc = "pink blush"
    adesc = (self.sdesc)
    ldesc = "The blush is in a squarish container labelled
	     <q>Maybelline</q>. "
    makeupdesc = "blush"
    applyDesc = "You pop open the blush container and take the brush.
		 Staring in the mirror, you rub the pink blush along your
		 cheekbones with quick strokes. Satisfied, you put the
		 brush back and close the container. "
    appliedProp = &blushOn
;

eye_shadow: makeupItem
    noun = 'shadow' 'eye-shadow'
    adjective = 'eye' 'revlon' 'lavender'
    location = jeanie_vanity
    sdesc = "eye shadow"
    adesc = (self.sdesc)
    ldesc = "The eye shadow is a lavender shade by Revlon. "
    makeupdesc = "eye shadow"
    applyDesc = "A couple of careful passes with the eye shadow brush and
		 your eyelids turn a pretty lavender. "
    appliedProp = &eyeshadowOn
;

mascara: makeupItem
    noun = 'mascara' 'tube' 'stuff'
    adjective = 'pink' 'green' 'pink-and-green'
    location = jeanie_vanity
    sdesc = "mascara"
    adesc = (self.sdesc)
    ldesc = "The mascara's that stuff in the pink and green tube. "
    makeupdesc = "mascara"
    applyDesc = {
	if (!jeanieMe.eyeshadowOn)
	    "You normally put eye shadow on before mascara, but what the
	     hell. ";
	"You twist the tube of mascara and pull out the brush. It's
	 still difficult not to blink, even after all this time,
	 but you do a passable job of getting it on without it
	 clumping. ";
    }
    appliedProp = &mascaraOn
;
