// AdvDebug.cpp : debugger
//
//  Private functions:
//

#include "stdafx.h"
#include "string.h"

#include "AdvIO.h"
#include "AdvDebug.h"
#include "AdvUtil.h"

/////////////////////
// Forward references
void displayDebugMenu();
void dbgCheckPlace (AdvGlobalContext& gc);
void dbgCheckObject (AdvGlobalContext& gc);
void dbgCheckMessage (AdvGlobalContext& gc);
void dbgCheckVocab (AdvGlobalContext& gc);
void dbgTravel (AdvGlobalContext& gc);
void dbgGetObject (AdvGlobalContext& gc);
void dbgMoveObject (AdvGlobalContext& gc);
void dbgDisplayVariables (AdvGlobalContext& gc);
void dbgTreasuresToBuilding (AdvGlobalContext& gc);
long getIndex (char* szPrompt, long nMinIndex, long nMaxIndex);

///////////////////
// Public functions

void advDebug
  (AdvGlobalContext& gc)   // global context
//
//  Debugger.
//
{
  displayDebugMenu();
  do
  {
    char  szCommand [255];  // command

    printf ("\nDebug> ");
    gets (szCommand);
    char ch = toupper (szCommand [0]);
    switch (ch)
    {
      case 'P':
        dbgCheckPlace (gc);
        break;
      case 'O':
        dbgCheckObject (gc);
        break;
      case 'S':
        dbgCheckMessage (gc);
        break;
      case 'V':
        dbgCheckVocab (gc);
        break;
      case 'T':
        dbgTravel (gc);
        break;
      case 'G':
        dbgGetObject (gc);
        break;
      case 'M':
        dbgMoveObject (gc);
        break;
      case 'D':
        dbgDisplayVariables (gc);
        break;
      case 'B':
        dbgTreasuresToBuilding (gc);
        break;
      case 'X':
        return;
      default:
        displayDebugMenu();
        break;
    }
  }
  forever;
}

////////////////////
// Private functions

void displayDebugMenu()
//
//  Displays the debugger menu.
//
{
  printf ("Adventure Debugger\n");
  printf ("  P - place checker\n");
  printf ("  O - object checker\n");
  printf ("  S - message checker\n");
  printf ("  V - vocabulary checker\n");
  printf ("  T - travel to a location\n");
  printf ("  G - get an object\n");
  printf ("  M - move an object\n");
  printf ("  D - display variables\n");
  printf ("  B - transport all treasures to building\n");
  printf ("  X - exit debugger\n");
}

void dbgCheckPlace
  (AdvGlobalContext& gc)   // global context
//
//  Displays information about a location.
//
{
  do
  {
    // Get location index
    long  nIndex = getIndex ("Location", 0, gc.m_nPlaces);
    if (nIndex == (-1))
       return;

    // Display short and long descriptions
    printf ("------\n");
    describePlace (gc, nIndex, false);
    printf ("------\n");
    describePlace (gc, nIndex, true);
  }
  forever;
}

void dbgCheckObject
  (AdvGlobalContext& gc)   // global context
//
//  Displays information about a location.
//
{
  do
  {
    // Get object index
    long  nIndex = getIndex ("Object", 1, gc.m_nObjects);
    if (nIndex == (-1))
       return;

    // Display inventory description, current state and location
    printf ("Inventory: ");
    describeObjectInven (gc, nIndex);
    printf ("Current state: %d\n", gc.m_nState [nIndex]);
    describeObject (gc, nIndex, gc.m_nState [nIndex]);
    printf ("Location = %d\n", gc.m_nWhereIs [nIndex]);
    describePlace (gc, gc.m_nWhereIs [nIndex], 0);
  }
  forever;
}

void dbgCheckMessage
  (AdvGlobalContext& gc)   // global context
//
//  Displays a message.
//
{
  do
  {
    // Get message index
    long  nIndex = getIndex ("Message", 1, gc.m_nMessages);
    if (nIndex == (-1))
       return;

    // Display message
    sayMessage (gc, nIndex);
  }
  forever;
}

void dbgCheckVocab
  (AdvGlobalContext& gc)   // global context
//
//  Displays information about a vocabulary word.
//
{
  printf ("Not implemented\n");
}

void dbgTravel
  (AdvGlobalContext& gc)   // global context
//
//  Changes the current location.
//
{
  printf ("Not implemented\n");
}

void dbgGetObject
  (AdvGlobalContext& gc)   // global context
//
//  Gets an object.
//
{
  printf ("Not implemented\n");
}

void dbgMoveObject
  (AdvGlobalContext& gc)   // global context
//
//  Moves an object to a location.
//
{
  printf ("Not implemented\n");
}

void dbgDisplayVariables
  (AdvGlobalContext& gc)   // global context
//
//  Displays the values of all global variables.
//
{
  getScore (gc);

  printf ("Dwarf count   = %d\n", gc.m_nDwarfCount);
  printf ("Lamp life     = %d\n", gc.m_nLampLife);
  printf ("Safe password = %d\n", gc.m_nPassword);
  printf ("Strength      = %d\n", gc.m_nStrength);
  printf ("Score         = %d\n", gc.m_nScore);
  printf ("Turns         = %d\n", gc.m_nTurns);
}

void dbgTreasuresToBuilding
  (AdvGlobalContext& gc)   // global context
//
//  Transports all treasures to the building
//
{
  printf ("Not implemented\n");
}

long getIndex
  (char*  szPrompt,   // prompt
   long   nMinIndex,  // minimum index
   long   nMaxIndex)  // maximum index
//
//  Displays a prompt and requests a numeric index.  Returns
//  -1 if the user quits.
//
{
long  nIndex;             // selected index
char  szResponse [255];   // user's response

  do
  {
    printf ("\n%s (%d - %d): ", szPrompt, nMinIndex, nMaxIndex);
    gets (szResponse);
    if (strlen (szResponse) == 0)
       return (-1);
    if (sscanf (szResponse, "%d", &nIndex) == 1)
       if ((nIndex >= nMinIndex) && (nIndex <= nMaxIndex))
          return (nIndex);
  }
  forever;
}
