// Pour.cpp : Handler for pouring action
//

#include "stdafx.h"
#include "string.h"

#include "AdvIO.h"
#include "AdvMain.h"
#include "AdvUtil.h"
#include "Pour.h"

/////////////////////
// Forward references
void pourWater (AdvGlobalContext& gc);
void pourOil (AdvGlobalContext& gc);

///////////////////
// Public functions

void pourProc
  (AdvGlobalContext& gc)   // global context
//
//  Handles pouring liquids.
//
{
  // First, the obvious situations ...
  if (gc.m_nCmdWords == 1)
     {
       gc.m_nContext = pour;
       sayMessageWord (gc, clarify, pour);
       return;
     }
  if (!isObject (gc.m_nArg2))
     {
       sayMessage (gc, what);
       return;
     }

  // Bottle, water and oil all imply using the bottle to pour
  if ((gc.m_nArg2 == water) || (gc.m_nArg2 == oil) || (gc.m_nArg2 == bottle))
     {
       if (!near (bottle))
          {
            sayMessageWord (gc, youdonthave, bottle);
            return;
          }
       else
          if (gc.m_nState [bottle] == 1)
             {
               sayMessage (gc, emptybottle);
               return;
             }

       // He wants to pour whatever's in the bottle
       if (gc.m_nArg2 == bottle)
          if (gc.m_nState [bottle] == 0)
             pourWater (gc);
          else
             pourOil (gc);
       else

          // He wants to pour water
          if (gc.m_nArg2 == water)
             if (gc.m_nState [bottle] == 0)
                pourWater (gc);
             else
                sayMessageWord (gc, notinbottle, water);
           else

               // He wants to pour oil
               if (gc.m_nState [bottle] == 2)
                  pourOil (gc);
               else
                  sayMessageWord (gc, notinbottle, oil);

       return;
     }

  // Default pour action
  if (!near (gc.m_nArg2))
     {
       sayMessageWord (gc, idontsee, gc.m_nArg2);
       return;
     }
  if (gc.m_mortal [gc.m_nArg2])
     {
       sayMessage (gc, hah);
       return;
     }
  sayMessage (gc, cantpour);
}

////////////////////
// Private functions

void pourWater
  (AdvGlobalContext& gc)   // global context
//
//  Handles pouring water.
//
{
  apport (water, limbo);
  gc.m_nState [bottle] = 1;
  if (near (plant))
     {
       gc.m_nState [plant]++;
       describeObject (gc, plant, gc.m_nState [plant]);   // describe effect of water
       gc.m_nState [plant]++;                             // new state (2, 4, 6)

       if (gc.m_nState [plant] == 6)                      // overwatered
          {
            gc.m_nState [plant] = 0;                      // shrink back to tiny size
            gc.m_invisible [plant2] = true;               // can't see anything sticking out
          }
       else
           gc.m_invisible [plant2] = false;	              // visible from top of pit
       gc.m_nState [plant2] = gc.m_nState [plant];
     }
  else
     if (near (door))
        {
          sayMessage (gc, hinges_rust);
          gc.m_nState [door] = 0;
        }
     else
        sayMessage (gc, pourwater);
}

void pourOil
  (AdvGlobalContext& gc)   // global context
//
//  Handles pouring oil.
//
{
  apport (oil, limbo);
  gc.m_nState [bottle] = 1;
  if (near (plant))
     sayMessage (gc, oil_plant);
  else
     if (near (door))
        {
          sayMessage (gc, oil_door);
          gc.m_nState [door] = 1;
        }
     else
        sayMessage (gc, pourwater);
}
