/*
 * Polyadventure
 *
 * A remake of the various versions of the classic Adventure game by Don
 * Woods and Willie Crowther, based on their sources.  Currently, the 350,
 * 550, and 551-point versions are implemented.  See the file "ccr-help.t"
 * for more information.
 *
 * Please document all changes in the history so we know who did what.
 *
 * This source code is copylefted under the terms of the GNU Public
 * License.  Essentially, this means that you are free to do whatever
 * you wish with this source code, provided you do not charge any
 * money for it or for any derivative works.
 *
 *
 * Contributors (see history.t for current e-mail addresses)
 *
 *      551-point extensions:
 *      djp     In real life:   David J. Picton
 *
 *      Chaser code:
 *      bjs     In real life:   Bennett J. Standeven
 *
 * Modification History
 *
 * AD551
 * =====
 *
 * 16-Oct-98    djp     Moved the code for all NPC's into this file.
 *
 * 14-Apr-99    djp     Initial release of Adventure 551 (1.01)
 *
 * 23-Apr-99    djp     New release (1.10) of Adventure 551.
 *
 * 30-Apr-99    djp     New release (1.11) of Adventure 551.
 *                      Changes since version 1.10:
 *                      *  Changed some responses to the 'rub' verb.
 *                      *  Allowed ring to be put back on Wumpus.
 *                      *  Supplied missing verIoGiveTo method for Bees.
 *                      *  Referred to the Wumpus consistently as 'he'.
 *
 * 15-Jul-99    djp     New release (2.00)
 *                      Changes in this version:
 *                      * Reworked the ldesc of the Wumpus, which now makes
 *                        reference to the gold ring if you've seen all the
 *                        pits.  It now gives a different description after
 *                        the Wumpus has been woken.
 *                      * Added a dummy object for the elves.
 *
 * 9-Nov-99     djp     New release - Version 2.10
 *              djp     * Incorporated Bennett Standeven's Chaser class.
 *
 * POLYADV
 * =======
 *
 * 24-Aug-99    bjs     Pre-release version 0.00
 *              bjs     Split file into three parts; one for each version.
 *
 *          djp+bjs     Incorporated ad551 mods up to 2.20
 *
 * 3-Mar-00     djp     Initial beta release - Version 1.00
 *              djp     Changes since ad551 v2.20:
 *                      * Defined doCount method for the bees.
 *                      * Fixed broken code for attacking the bees.
 *                      * Reworked attacking code to use the new
 *                        weapon class where appropriate.
 *                      * Various bugfixes to attacking/throwing/giving
 *                        to the Wumpus and Dog.  Bugs allowing inappropriate
 *                        interaction with a sleeping or dead Wumpus, or
 *                        a sleeping Dog, have been fixed.
 *                      * Reworked the code for 'throw x to enemy'.  When
 *                        weapons get trapped if they land close to the
 *                        enemy (e.g. the Bear), 'throw weapon TO enemy'
 *                        is the same as 'throw weapon AT enemy' but 'throw
 *                        other at enemy' resolves to 'give other to enemy'.
 *                        In other cases the latter choice is made for all
 *                        items. (exception: the Djinn)
 *                      * Ensured that giving methods are inherited from
 *                        'feedable' rather than 'Actor' by adjusting the
 *                        order of classes (feedable comes before Actor etc)
 *                      * Tidied up NPC interaction code to follow the
 *                        order:
 *                        Attacking
 *                        Kicking
 *                        Throwing
 *                        Giving
 *                        Feeding
 *                        Other
 *
 * 4-Apr-00     djp     Version 1.01: bugfix release
 *                      Changes in this version
 *                      * Minor change to Wumpus code so that
 *                        'attack wumpus with hands' is consistent with
 *                        'attack wumpus' (when no weapon is held).
 *                      * Further correction to Dog code for attacking
 *                        with a non-weapon and for case when axe is thrown
 *                        at the sleeping Dog.
 *                      * Changed bees to Bees for consistency (fixed items
 *                        and rooms should all start with an uppercase letter)
 *                      * Changed the code for waking the Wumpus - for the
 *                        case when the horn is blown in the dark.
 *
 * 4-May-00     djp     Version 1.02: bugfix release
 *                      Changes in this version
 *                      * Added missing sdesc for Bees.
 *                      * Made the mushrooms re-grow after the dog has
 *                        eaten them.
 *
 * 18-Sep-00    djp     Version 2.00: New version with 701-point game
 *                      Changes in this version:
 *                      * Added provision for singing sword where needed.
 *              
 * 20-Dec-00    djp     Version 2.02: bugfix release
 *                      Changes in this version:
 *                      * Added verification methods for rubbing NPCs. (N.B.
 *                        chasers already have a default)
 *
 * 8-Jun-01     djp     Version 2.05: bugfix release
 *                      Changes in this version:
 *                      * Added code for giving liquids to NPCs.
 *
 * 17-Aug-01    djp     Version 2.06: bugfix release with e-mail address update
 *                      Changes in this version:
 *                      * Regrow mushroom if dog eats it.
 *
 * 12-Aug-03    bjs     Version 2.11: added 580-point mode.
 *
 * 23-Aug-03    djp     Version 2:12 
 *                      * In the 701-point game, removed the statement that
 *                        the dead Wumpus might be hiding something.  This
 *                        will be true in the new 701+ mode, but there's
 *                        nothing more to find in the plain 701-point game.
 *
 * 23-Jul-04    djp     Version 3.00.  Addition of a new game mode (701+).
 *                      * Changes to the Wumpus code for the 701+ point game.
 */

/*
 * This file handles non-player character movement and characteristics.
 *
 * Be sure to update exitlist and/or npclist if you add any new travel
 * verbs to CCR_Room.
 */

/* NPCs for the 551-point version */

Wumpus: searchHider, feedable, Chaser
    sdesc = "Wumpus"
    ldesc = {
        if(self.isasleep) {
            "He's a huge, hairy creature, renowned for his appetite for
            Adventurers.  Whatever you do, don't wake him!   He can
            outrun the fastest humans, and despite his size can squeeze
            through the narrowest passages!  Even magic words won't
            help you to escape, because the Wumpus is good at imitating
            them!";
            if (Cloak_Pit_1.isseen and Cloak_Pit_2.isseen and
            Cloak_Pit_3.isseen) {
                P();
                "Something occurs to you.  Two of the Featureless Pits
                contained a ring, but someone seems to have visited
                the south pit before you.  Someone with very large
                feet.  Unfortunately the position in which the Wumpus
                is lying prevents you from seeing whether he has the
                missing ring. ";
            }
        }
        else if (not self.isdead) {
            "He's a huge, hairy creature, renowned for his appetite for
            Adventurers like you.  You're in desperate trouble now that
            you've woken him,  and no-one has found a way to outrun him,
            even using magic words. ";
        }
        else {
            "He's not a pretty sight now. ";
        }
    }
    moveinc = 1
    stayinc = 1

    actorDesc = {  // used only when asleep
        if (self.isasleep) {
            "In the corner, a Wumpus is sleeping peacefully.";
        }
    }

    heredesc = {  // used when dead; heredesc is used instead of actorDesc
                  // to ensure that the Wumpus appears before the ring
                  // in the room description.
        if (self.isdead) {
            P(); I();
            "Nearby is the smashed body of a defunct Wumpus.";
        }
    }
    noun = 'wumpus' 'monster'
    adjective = 'large' 'hairy' 'sleeping'
    location = Cloakroom

    isasleep = true
    isdead = nil
    ischasing = nil

    deadmess = "For crying out loud, the poor thing is dead!"
    ridicule = "Don't be ridiculous!"

    // ATTACKING
    verDoAttack(actor) = {
        if ((not axe.isIn(Me)) and (not sword.isIn(Me)) and
        (not singing_sword.isIn(Me)))
            self.ridicule;
    }
    doAttack(actor) = {
        // By default, attack with the axe ...
        if (axe.isIn(actor)) {
            "\n(with the axe)\n";
            self.doAttackWith(actor, axe);
        }
        // or the singing sword ...
        else if (singing_sword.isIn(actor)) {
            "\n(with the sword)\n";
            self.doAttackWith(actor, sword);
        }
        // or the sword ...
        else if (sword.isIn(actor)) {
            "\n(with the sword)\n";
            self.doAttackWith(actor, sword);
        }
    }

    verDoAttackWith(actor, io) = {if(self.isdead)self.deadmess;}
    doAttackWith(actor, io) = {
        //
        // If the player throws the axe at the sleeping Wumpus, the
        // axe misses and becomes inaccessible.  (Doh!)
        if (self.isdead) {
            self.deadmess;
            if(global.saidthrow)global.saidthrow := nil;
        }
        else if (io = axe and self.isasleep) {
            if (not global.saidthrow)
                "\n(throwing the axe)\n";
            global.saidthrow := nil;
            "You can't even hit a sleeping Wumpus!  It wasn't your
            fault, though; your axe was well aimed, but
            it swerved away from the Wumpus as if deflected by a strong
            magnetic field!  The axe is now lying on the far side
            of the Wumpus, and you'd be trapped if he woke up while
            you were retrieving it.";
            axe.moveInto(self.location);
            axe.nograb := true;
        }
        // An even worse outcome is in store if the Wumpus is
        // awake ...
        else if(io = axe) {
            if (not global.saidthrow)
                "\n(throwing the axe)\n";
            global.saidthrow := nil;
            "The Wumpus grabs the axe, stops and picks his teeth with
            it for a few moments while looking thoughtfully at you.
            When he finishes picking his teeth, he eats the axe,
            belches, farts... and starts after you again!";
            axe.moveInto(nil);
            // N.B. in this port the axe will reappear when the player next
            // encounters a dwarf!  We could call it a bug, but I'll choose
            // to regard it as a feature - DJP.
        }
        else if(io = sword) {
            if (not global.saidthrow)
                "\n(throwing the sword)\n";
            global.saidthrow := nil;
            sword.throwsmash;
        }
        else if (io = singing_sword) {
            if (not global.saidthrow)
                "\n(throwing the sword)\n";
            global.saidthrow := nil;
            if (self.location = On_Ladder) {
                "The sword misses, bounces off the wall of the shaft, and
                lands in the room below. ";
                singing_sword.moveInto(Cloak_Pits);
            }
            else {
                "The sword misses, bounces off the wall, and
                lands at your feet. ";
                singing_sword.moveInto(self.location);
            }
        }
        else if(io = Hands) self.ridicule;
        else if(self.isasleep) self.doWake(actor);
        else "Somehow I doubt that'll be very effective.";
    }


    // KICKING
    verDoKick(actor) = {
        if(self.isdead)self.deadmess;
        else if(not self.isasleep) self.ridicule;
    }

    doKick(actor) = { self.doWake(actor);}


    // THROWING
    verIoThrowAt(actor) = { if (self.isdead)self.deadmess; }
    ioThrowAt(actor, dobj) = {
        if(isclass(dobj,fooditem))self.ioGiveTo(actor,dobj);
        else if(isclass(dobj,weapon)) {
            global.saidthrow := true;
            self.doAttackWith(actor,dobj);
        }
        else pass ioThrowAt;
    }

    verIoThrowTo(actor) = { if (self.isdead) "There's no point in throwing
        anything to a dead Wumpus!"; }
    ioThrowTo(actor, dobj) = {
        if (isclass(dobj,weapon))
             self.ioThrowAt(actor, dobj);
        else self.ioGiveTo(actor, dobj);
    }

    // GIVING
    verIoGiveTo(actor) = {
        if(self.isasleep)"You can't do that while he's asleep!";
        else if(self.isdead)self.deadmess;
    }

    // added isasleep, isdead checks for cases where other methods call
    // ioGiveTo
    ioGiveTo(actor, dobj) = {
        if(self.isasleep)"You can't do that while he's asleep!";
        else if(self.isdead)self.deadmess;
        else if(isclass(dobj,contliquid) and ((dobj.myflag = &haswater) or
        (dobj.myflag = &haswine))){
            self.doFeedWith(actor,dobj);
        }
        else if(isclass(dobj,fooditem)) {
            self.doFeedWith(actor,dobj);
        }
        else {
            "The Wumpus isn't very interested in "; dobj.thedesc;
            ".";
        }
    }

    // FEEDING
    verDoFeed(actor) = {
        if(self.isasleep)
            "You can't feed the Wumpus without waking him, and that
            would be a very bad idea.";
        else if(self.isdead)
            "Dead Wumpi, as a rule, are light eaters.  Nothing happens.";
        else pass verDoFeed;
    }
    doFeed(actor) = {
        if (tasty_food.isReachable(Me)) {
            "(trying ";tasty_food.thedesc;")\n";
            self.doFeedWith(actor,tasty_food);
        }
        else if (honeycomb.isReachable(Me)) {
            "(trying ";honeycomb.thedesc;")\n";
            self.doFeedWith(actor,honeycomb);
        }
        else if (mushrooms.isReachable(Me)) {
            "(trying ";mushrooms.thedesc;")\n";
            self.doFeedWith(actor,mushrooms);
        }
        else
            "There is nothing here that the Wumpus would want to
            eat, except *YOU*!";
    }
    verDoFeedWith(actor,io) = {
    if(self.isasleep)
        "You can't feed the Wumpus without waking him, and that
        would be a very bad idea.";
    else if (self.isdead)
        "Dead wumpi, as a rule, are light eaters.  Nothing happens.";
    else pass verDoFeedWith;
    }
    doFeedWith(actor,io) = {
        if (isclass(io,fooditem)) {
        "The Wumpus looks at <<io.thedesc>> with distaste.  He
        looks at *YOU* with relish!";
        }
        else pass doFeedWith;
    }

    // OTHER (actor, verb; wake; Chaser methods)
    verDoRub(actor) = {
        if (self.isdead) pass verDoRub;
        else if(not self.isasleep) self.ridicule;
    }
    doRub(actor) = {
        if (self.isdead) pass doRub;
        "You carefully rub the Wumpus.  He remains fast
        asleep.";
    }
    actorAction( v, d, p, i ) = {
        if(self.isasleep) {
            "He won't be doing anything while he's asleep!";
            exit;
        }
        if(self.isdead) {
            self.deadmess;
            exit;
        }
        else pass actorAction;
    }
    verDoWake(actor) = {
        if(not self.isasleep) "He's not asleep.";
        else if (self.isdead) self.deadmess;
    }
    doWake(actor) = {
        if(actor.location.islit) {
            "You turkey!!!  Now you've done it!  It took some effort, but you
            woke up the Wumpus.  He slowly opens one red eye, and then another,
            and then one more (!!), and looks at you sleepily.  He had been
            dreaming of a late snack.  If you don't act quickly, you'll
            be a *late* adventurer! ";
        }
        else {
            "You hear the sound of someone - something - stirring.  You
            fool!  I think you've woken the Wumpus.  He had been
            dreaming of a late snack.  If you don't act quickly, you'll
            be a *late* adventurer! ";
        }
        self.summon;
    }
    verDoSearch(actor) = {
        if(not self.isdead)
            "Getting so close to a live Wumpus is far too dangerous. ";
        else if(not global.game701p)
            "The Wumpus is not a pretty sight, and an overwhelming feeling
            of revulsion prevents you from searching his body. ";
    }
    verDoLookin(actor) = {self.verDoSearch(actor);}
    doSearch(actor) = {
        if (not self.searchedonce) {
            if (gold_ring.moved)
                "The Wumpus is not a pretty sight, but you suspect that he
                may be hiding something important.  You therefore overcome 
                your squeamishness, and thoroughly search him for hidden 
                possessions";
            else
                "The Wumpus is not a pretty sight, but you realize - in a 
                flash of intuition which also gives you a strange sense of
                foreboding - that he may be hiding something important.  
                You therefore overcome 
                your squeamishness, and thoroughly search him for hidden 
                possessions";
        }
        if (global.game701p) {
            if (not self.searchedonce)
                ". ";
            inherited.doSearch(actor);
        }
        else {
            if (self.searchedonce)
                ", but you ";
            else
                "You ";
            "find nothing of interest. ";
        }
        self.searchedonce := true;
    }
    doLookin(actor) = {self.doSearch(actor);}
    summon(...) = {
        self.isasleep := nil;
        // Resurrect the Wumpus for the Summon command
        if(self.isdead) {
            self.isdead := nil;
            delword (self,&noun,'body');
            delword (self,&adjective,'dead');
            delword (self,&adjective,'defunct');
            if (not gold_ring.moved) {
                    gold_ring.moveInto(nil);
                    gold_ring.moved := nil;
            }
        }
        delword (self,&adjective, 'sleeping');
        self.ischasing := true;
        if (argcount > 0)
            self.moveInto(getarg(1));
        self.prevloc := nil;  // needed to avoid false backtrackAct calls
        notify(self, &move, 0);
    }
    MagicMsg() = {
        P(); I();
        "Something catches the corner of your eye.  To your horror,
        you realize that the Wumpus has materialized right
        behind you!  Evidently he's good at imitating magic words -
        in fact, he probably knows them all. ";
    }
    SlippMsg() = {
        P(); I();
        "As you clicked your heels, the Wumpus did the same.  He
        has no slippers, so he shouldn't - ";

        P(); I();
        "Sorry.  The Wumpus is right behind you!  He's now so close that
        you notice a small detail which eluded you until now.  He is wearing
        a gold ring.  As you may already have realized, many of the rings
        you may find in the cave have magic powers... ";
        gold_ring.deducedmagic := true;
      
        P(); I();
        // give the player a hint for free if he's been trying this
        // hard to escape the Wumpus. (proved changed to proven in 
        // accordance with American preferences)
        "You've proven conclusively that you can't simply use magic to
        escape from the Wumpus, so you'll need to try another tack.  Maybe
        there's another way to use magic against him.  With the aid of a little
        low cunning, you might be able to set a little trap ... ";
    }
    backtrackAct() = {
        P(); I();
        "You fool!  You've run straight into the Wumpus ....";
        chase := 9;
    }
    ChaseMsg() = { P(); I(); 
        if (self.isIn(Octagonal_Room) and 
        Trans_Room_Door.isIn(self.location) and not self.upset) {
            self.upset := true;
            "I've never known the Wumpus to be concerned with anything but
            his next meal, but something seems to be distracting his attention
            here.  For some reason he seems to be unhappy about your 
            discovery of the door.  I wonder if he knows something about it? ";
            P();
            chase := 3;
            chasehold := 4;
        }
        switch (self.chase) {
          default: break;
          case 1: case 2:
            "A sleepy Wumpus is ambling towards you.  He wants to invite
            you to dinner.  He wants you to *be* the dinner!"; break;
          case 3: case 4:
            "The Wumpus is still on your trail!  And he's getting
            closer!!"; break;
          case 5: case 6:
            "The Wumpus is only a few steps behind you!  All this exercise
            is making him veerrrrry hungry!"; break;
          case 7: case 8:
            "The Wumpus almost has you in his grasp!  You can feel his hot
            breath on your neck!"; break;
          case 9: case 10:
            " \"Chomp, chomp.\"  Crunch!  Chew!  Slurp!  Smack!  Yum!!!";
            break;
        }
        if(chase >= 9) {
            die(); // die routine puts Wumpus back asleep
        }
    }
    banish() = { // Put the Wumpus back to bed
        Wumpus.moveInto(Cloakroom);
        Wumpus.prevloc := nil;
        Wumpus.isasleep := true;
        addword(self, &adjective, 'sleeping');
        Wumpus.ischasing := nil;
        Wumpus.chase := -1;
        unnotify(Wumpus,&move);
    }
    demise = { // The end of the Wumpus
        P();
        "As the bridge disappears, the Wumpus scrambles frantically to
        reach your side of the fissure.  He misses by inches, and with a
        horrible shriek plunges to his death in the depths of the
        fissure!";
        self.moveInto(Lost_Canyon_End);
        gold_ring.moveInto(Lost_Canyon_End);
        gold_ring.moved := nil;
        self.chase := -1;
        self.ischasing := nil;
        self.isasleep := nil;
        self.isdead := true;
        addword (self,&adjective,'dead');
        addword (self,&adjective,'defunct');
        addword (self,&noun,'body');
        self.prevloc := nil;
        if(axe.nograb and axe.isIn(Cloakroom))axe.nograb := nil;
        unnotify(self,&move);
    }
    verIoPutOn (actor) = {
        if(not self.isdead) "Don't be ridiculous. ";
    }
    ioPutOn (actor, dobj) = {
        if (dobj = gold_ring) {
            "You put the ring back on the Wumpus' finger. ";
            gold_ring.moveInto(self.location);
            gold_ring.moved := nil;
        }
        else "In general, I don't see the point of trying to put things onto
        a Wumpus. ";
    }
    doSummon(actor) = {
        if (not self.ischasing) {
            P();
            if (Wumpus.location <> toplocation(actor))
                "The Wumpus suddenly comes into view! ";
            else if (self.isdead)
                "The Wumpus suddenly comes back to life! ";
            else
                "The Wumpus suddenly wakes up! ";
            P();
        }
        pass doSummon;
    }
;

Bees: fixeditem, feedable
    isThem = true
    sdesc = "bees"
    adesc = "bees"
    ldesc = {
        if(not self.arefed) "The bees swarm protectively around the hive.";
        else "The bees are swarming around the fresh flowers.";
    }
    noun = 'swarm' 'bees'
    adjective = 'swarm'
    location = Flower_Room

    // GIVING
    ioGiveTo(actor, dobj) = {
        if(dobj = flowers)
            self.doFeedWith(actor,dobj);
        else if(isclass(dobj,contliquid) and ((dobj.myflag = &haswater) or
        (dobj.myflag = &haswine))){
            self.doFeedWith(actor,dobj);
        }
        else
            {"The bees wouldn't be interested in ";dobj.thedesc;".";}
    }

    // ATTACKING
    verDoAttack(actor) = {"That would only enrage the bees!";}

    verDoAttackWith(actor,io) = {self.verDoAttack(actor);}

    // KICKING
    verDoKick(actor) = {self.verDoAttack(actor);}

    // THROWING
    verIoThrowAt(actor) = { self.verIoGiveTo(actor); }
    ioThrowAt(actor, dobj) = {
        if(dobj = flowers)self.ioGiveTo(actor,dobj);
        else "That would only enrage the bees!";
    }
    verIoThrowTo(actor) = { self.verIoGiveTo(actor); }
    ioThrowTo(actor, dobj) = { self.ioGiveTo(actor, dobj); }

    // FEEDING
    doFeed(actor) = {
        askio (withPrep);
    }

    doFeedWith(actor,io) = {
        if (self.arefed)"You've already fed the bees.";
        else if (io = flowers) {
            if(testtake(actor,io)) {
                "The bees swarm over the fresh flowers, leaving the hive
                 unguarded and revealing a sweet honeycomb.";
                flowers.moveInto(self.location);
                self.arefed := true;
                honeycomb.moveInto(hive);
            }
        }
        else pass doFeedWith;
    }

    // OTHER (verb defaults)
    verDoRub(actor) = {
        "Don't be ridiculous. ";
    }
    verDoCount(actor) = {
        "You couldn't possibly count the bees! ";
    }
    dobjGen(a, v, i, p) =
    {
        if ((v <> inspectVerb) and (v <> gonearVerb) and (v <> feedVerb)
        and (v <> countVerb))
        {
            "The hum of the bees rises to an angry buzz as you move
                towards the "; if (self.arefed) "flowers"; else "hive";
                ". "; exit;
        }
    }
    iobjGen(a, v, d, p) = {
        if (v = askVerb or v = tellVerb or v = waveVerb)return;
        self.dobjGen(a, v, d, p);
    }

;

Dog: feedable, Actor
    isasleep = nil

    sdesc = "hideous dog"
    ldesc = {
        "The hideous black dog looks like a hound from Hell.  Calling
        him a \"nice doggie\" would be a big mistake.";
        if(self.isasleep)
        "  However, he's now fast asleep.  You'd best let
        sleeping dogs lie.";
    }

    actorDesc = {
        if (not self.isasleep)
            "A hideous black dog bares his teeth and growls at your
            approach.";
        else
            "Nearby, a large black dog is in a deep slumber.";
    }

    noun = 'hideous' 'black' 'dog'
    adjective = 'hideous' 'black'

    location = River_Styx_Approach

    sleeplie = "You'd better let sleeping dogs lie."

    // ATTACKING
    suicide = "Trying to attack this dog would be tantamount to suicide.
        %You% might be able to calm him down, though. "

    verDoAttack(actor) = {
        if (self.isasleep) self.sleeplie;
        else if ((not axe.isIn(actor)) and (not sword.isIn(actor)) and
        (not singing_sword.isIn(actor)))
            self.verDoKick(actor);
    }
    doAttack(actor) = {
        // By default, attack with the axe ...
        if (axe.isIn(actor)) {
            "\n(with the axe)\n";
            self.doAttackWith(actor, axe);
        }
        // or the singing sword ...
        else if (singing_sword.isIn(actor)) {
            "\n(with the sword)\n";
            self.doAttackWith(actor, sword);
        }
        // or the gleaming sword ...
        else if (sword.isIn(actor)) {
            "\n(with the sword)\n";
            self.doAttackWith(actor, sword);
        }
    }


    verDoAttackWith(actor, io) = {if (self.isasleep) self.sleeplie;}
    doAttackWith(actor, io) = {
        //
        // If the player throws the axe at the dog, the
        // axe misses and becomes inaccessible.  (Doh!)
        if (io = axe) {
            if (not global.saidthrow)
                "\n(throwing the axe)\n";
            global.saidthrow := nil;
            "The axe misses and lands near the dog where
            you can't get at it.";

            axe.moveInto(self.location);
            axe.nograb := true;         // little hack
        }
        else if (io = sword) {
            if (not global.saidthrow)
                "\n(throwing the sword)\n";
            global.saidthrow := nil;
            sword.throwsmash;
        }
        else if (io = singing_sword) {
            if (not global.saidthrow)
                "\n(throwing the sword)\n";
            "The sword misses, bounces off the wall, and
            lands at your feet. ";
            singing_sword.moveInto(self.location);
        }
        else self.suicide;
    }


    // KICKING
    verDoKick(actor) = {
        if(self.isasleep)self.sleeplie;
        else self.suicide;
    }
    doKick(actor) = {}

    // THROWING
    verIoThrowAt(actor) = {}
    // check for sleeping changed so that THROW AXE will find the dog
    // by default
    ioThrowAt(actor, dobj) = {
        if(self.isasleep)self.sleeplie;
        else if(isclass(dobj,fooditem))
            self.ioGiveTo(actor,dobj);
        else if(isclass(dobj,weapon)) {
            global.saidthrow := true;
            self.doAttackWith(actor,dobj);
        }
        else pass ioThrowAt;
    }
    verIoThrowTo(actor) = { self.verIoGiveTo(actor); }
    ioThrowTo(actor, dobj) = {
        if (isclass(dobj,weapon))
             self.ioThrowAt(actor, dobj);
        else self.ioGiveTo(actor, dobj);
    }

    // GIVING
    verIoGiveTo(actor) = {if(self.isasleep)self.sleeplie;}
    // added isasleep check for cases where other methods call ioGiveTo
    ioGiveTo(actor, dobj) = {
        if(self.isasleep)self.sleeplie;
        else if(isclass(dobj,contliquid) and ((dobj.myflag = &haswater) or
        (dobj.myflag = &haswine))){
            self.doFeedWith(actor,dobj);
        }
        else if(isclass(dobj,fooditem)) {
            self.doFeedWith(actor,dobj);
        }
        else {
            "The dog isn't very interested in "; dobj.thedesc;
            ".";
        }
    }

    // FEEDING
    verDoFeed(actor) = {
        if(self.isasleep)self.sleeplie;
        else pass verDoFeed;
    }
    doFeed(actor) = {
        if (tasty_food.isReachable(Me)) {
            "(with ";tasty_food.thedesc;")\n";
            self.doFeedWith(actor,tasty_food);
        }
        else if (honeycomb.isReachable(Me)) {
            "(with ";honeycomb.thedesc;")\n";
            self.doFeedWith(actor,honeycomb);
        }
    /* don't feed the mushrooms automatically */
        else if (mushrooms.isReachable(Me)) {
            askio (withPrep);
        }
        else
            "%You% %have% nothing the dog wants to eat.";
    }
    verDoFeedWith(actor,io) = {
        if (self.isasleep) self.sleeplie;
        else pass verDoFeedWith;
    }
    doFeedWith(actor,io) = {
        if (io = mushrooms) {
            if(testtake(actor,io)) {
                "The dog wolfs (natch) down the mushrooms.  Then it
                starts to grow larger!  Within a few seconds, it
                towers over you, almost filling the chamber.
                Unfortunately, you don't manage to get away before the
                dog makes *YOU* part of its meal.";
                io.moveInto(nil);
                notify(mushrooms,&regrow,mushrooms.growtime);
                die();
            }
        }
        // cakes need not be considered (dog must be asleep)
        else if (isclass(io,fooditem)) {
            if(testtake(actor,io)) {
                "The dog wolfs (natch) down ";io.thedesc;" and looks
                around hungrily for more.  However, he does not appear
                to be any better disposed towards your presence.";
                io.moveInto(nil);
                if(io = mushroom)notify(mushroom,&regrow,mushroom.growtime);
            }
        }
        else pass doFeedWith;
    }

    // OTHER
    verDoRub(actor) = {
        if (self.isasleep) self.sleeplie;
        else "Trying to pet the dog would be suicidal!";
    }

    verDoWake(actor) = {
        if (self.isasleep)self.sleeplie;
        else pass verDoWake;
    }
    actorAction( v, d, p, i) = {
        if ((v=stayVerb) and (d=nil) and (p=nil) and (i=nil))
             return;
        if (self.isasleep) {
             self.sleeplie;
             exit;
        }
        else pass actorAction;
    }
    listendesc = {
        if (self.isasleep) pass listendesc;
        else "The dog is growling at you.  I wouldn't go any closer. ";
    }
    stay = {
        if(self.isasleep) 
             "He's fast asleep, so he's unlikely to do anything but stay where
             he is. ";
        else
             "The dog stays where he is.  Perhaps because he didn't have any 
             intentions of moving in the first place! ";
    }
;

// Dummy object
Elf: Actor
    sdesc = "elf"
    noun = 'elf' 'elves'
    adjective = 'tiny'
;
