C GAME- MAIN COMMAND LOOP FOR DUNGEON
C
C COPYRIGHT 1980, INFOCOM COMPUTERS AND COMMUNICATIONS, CAMBRIDGE MA. 02142
C ALL RIGHTS RESERVED, COMMERCIAL USAGE STRICTLY PROHIBITED
C WRITTEN BY R. M. SUPNIK
C
C DECLARATIONS
C
      SUBROUTINE GAME
      IMPLICIT INTEGER (A-Z)
      LOGICAL RMDESC,VAPPLI,RAPPLI,AAPPLI
      LOGICAL F,PARSE,FINDXT,XVEHIC,LIT
      INTEGER*1 SECHO(4),GDTSTR(3)
C
C PARSER OUTPUT
C
      LOGICAL PRSWON
      COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
C
C GAME STATE
C
      LOGICAL TELFLG
      COMMON /PLAY/ WINNER,HERE,TELFLG
      COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
     *	LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
C
C MISCELLANEOUS VARIABLES
C
      INTEGER*1 INLINE
      COMMON /INPUT/ INLNT,INLINE(78)
      COMMON /CHAN/ INPCH,OUTCH,DBCH
C
C ROOMS
C
      COMMON /ROOMS/ RLNT,RDESC2,RDESC1(200),REXIT(200),
     *	RACTIO(200),RVAL(200),RFLAG(200)
      INTEGER RRAND(200)
      EQUIVALENCE (RVAL,RRAND)
C
      COMMON /RINDEX/ WHOUS,LROOM,CELLA
      COMMON /RINDEX/ MTROL,MAZE1	
      COMMON /RINDEX/ MGRAT,MAZ15	
      COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
      COMMON /RINDEX/ STREA,EGYPT,ECHOR
      COMMON /RINDEX/ TSHAF	
      COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
      COMMON /RINDEX/ CAROU	
      COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
      COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
      COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
      COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
      COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
      COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
      COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
      COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
      COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
      COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
      COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
      COMMON /RINDEX/ CPANT,CPOUT,CPUZZ
C
C OBJECTS
C
      COMMON /OBJCTS/ OLNT,ODESC1(220),ODESC2(220),ODESCO(220),
     *	OACTIO(220),OFLAG1(220),OFLAG2(220),OFVAL(220),
     *	OTVAL(220),OSIZE(220),OCAPAC(220),OROOM(220),
     *	OADV(220),OCAN(220),OREAD(220)
C
      COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
     *	NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
     *	TOOLBT,TURNBT,ONBT
      COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
     *	WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
     *	TCHBT,VEHBT,SCHBT
C
      COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
      COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
      COMMON /OINDEX/	LEAVE,TROLL,AXE
      COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
      COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
      COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
      COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
      COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
      COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
      COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
      COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
      COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
      COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
      COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
      COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
      COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
      COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
      COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
      COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
      COMMON /OINDEX/ WARNI,CSLIT,GCARD,STLDR
      COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
      COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
C
C ADVENTURERS
C
      COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
     *	AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
C
      COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
C
C VERBS
C
      COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
      COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
      COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
      COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
      COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
      COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
      COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
      COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
      COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
      COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
      COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
      COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
      COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
C
C FLAGS
C
      LOGICAL*1 TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
      LOGICAL*1 DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
      LOGICAL*1 MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
      LOGICAL*1 EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
      LOGICAL*1 GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
      LOGICAL*1 GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
      LOGICAL*1 MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
      LOGICAL*1 FOLLWF,SPELLF,CPOUTF,CPUSHF
      COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
     *	DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
     *	MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
     *	EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
     *	GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
     *	GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
     *	MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
     *	FOLLWF,SPELLF,CPOUTF,CPUSHF
      COMMON /FINDEX/ BTIEF,BINFF
      COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
      COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
      COMMON /FINDEX/ MDIR,MLOC,POLEUF
      COMMON /FINDEX/ QUESNO,NQATT,CORRCT
      COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL,CPHERE
C
C FUNCTIONS AND DATA
C
      DATA SECHO/'E','C','H','O'/
      DATA GDTSTR/'G','D','T'/
C GAME, PAGE 2
C
C START UP, DESCRIBE CURRENT LOCATION.
C
      CALL RSPEAK(1)				!WELCOME ABOARD.
      F=RMDESC(3)				!START GAME.
C
C NOW LOOP, READING AND EXECUTING COMMANDS.
C
100	WINNER=PLAYER				!PLAYER MOVING.
      TELFLG=.FALSE.				!ASSUME NOTHING TOLD.
      IF(PRSCON.LE.1) CALL RDLINE(INLINE,INLNT,1) !READ COMMAND.
C
      DO 150 I=1,3				!CALL ON GDT?
        IF(INLINE(I+PRSCON-1).NE.GDTSTR(I)) GO TO 200
150	CONTINUE
      CALL GDT				!YES, INVOKE.
      GO TO 100				!ONWARD.
C
200	MOVES=MOVES+1
      PRSWON=PARSE(INLINE,INLNT,.TRUE.)	!PARSE INPUT, NORMAL MODE.
      IF(.NOT.PRSWON) GO TO 400		!PARSE LOSES?
      IF(XVEHIC(1)) GO TO 400			!VEHICLE HANDLE?
C
      IF(PRSA.EQ.TELLW) GO TO 2000		!TELL?
300	IF((PRSO.EQ.VALUA).OR.(PRSO.EQ.EVERY)) GO TO 900
      IF(.NOT.VAPPLI(PRSA)) GO TO 400		!VERB OK?
350	IF(.NOT.ECHOF.AND.(HERE.EQ.ECHOR)) GO TO 1000
      F=RAPPLI(RACTIO(HERE))
C
400	CALL XENDMV(TELFLG)			!DO END OF MOVE.
      IF(.NOT.LIT(HERE)) PRSCON=1
      GO TO 100
C
900	CALL VALUAC(VALUA)
      GO TO 350
C GAME, PAGE 3
C
C SPECIAL CASE-- ECHO ROOM.
C IF INPUT IS NOT 'ECHO' OR A DIRECTION, JUST ECHO.
C
1000	CALL RDLINE(INLINE,INLNT,0)		!READ LINE.
      MOVES=MOVES+1				!CHARGE FOR MOVES.
      DO 1100 I=1,4				!INPUT = ECHO?
        IF(INLINE(I).NE.SECHO(I)) GO TO 1300
1100	CONTINUE
C
      DO 1200 I=5,78				!REST BLANK?
        IF(INLINE(I).NE.ICHAR(' ')) GO TO 1300
1200	CONTINUE
C
      CALL RSPEAK(571)			!KILL THE ECHO.
      ECHOF=.TRUE.
      OFLAG2(BAR)=OFLAG2(BAR).AND. .NOT.SCRDBT !LET THIEF STEAL BAR.
      PRSWON=.TRUE.				!FAKE OUT PARSER.
      PRSCON=1				!FORCE NEW INPUT.
      GO TO 400
C
1300	PRSWON=PARSE(INLINE,INLNT,.FALSE.)	!PARSE INPUT, ECHO MODE.
      IF(.NOT.PRSWON .OR. (PRSA.NE.WALKW))
     *	GO TO 1400			!WALK?
      IF(FINDXT(PRSO,HERE)) GO TO 300		!VALID EXIT?
C
1400	WRITE(OUTCH,1410) (INLINE(J),J=1,INLNT)	!ECHO INPUT.
1410	FORMAT(1X,78A1)
      TELFLG=.TRUE.				!INDICATE OUTPUT.
      GO TO 1000				!MORE ECHO ROOM.
C GAME, PAGE 4
C
C SPECIAL CASE-- TELL <ACTOR>, NEW COMMAND
C NOTE THAT WE CANNOT BE IN THE ECHO ROOM.
C
2000	IF((OFLAG2(PRSO).AND.ACTRBT).NE.0) GO TO 2100 !ACTOR?
      CALL RSPEAK(602)			!CANT DO IT.
      GO TO 350				!VAPPLI SUCCEEDS.
C
2100	WINNER=OACTOR(PRSO)			!NEW PLAYER.
      HERE=AROOM(WINNER)			!NEW LOCATION.
      IF(PRSCON.LE.1) GO TO 2700		!ANY INPUT?
      IF(PARSE(INLINE,INLNT,.TRUE.)) GO TO 2150	!PARSE COMMAND.
2700	I=341					!FAILS.
      IF(TELFLG) I=604			!GIVE RESPONSE.
      CALL RSPEAK(I)
2600	WINNER=PLAYER				!RESTORE STATE.
      HERE=AROOM(WINNER)
      GO TO 350
C
2150	IF(AAPPLI(AACTIO(WINNER))) GO TO 2400	!ACTOR HANDLE?
      IF(XVEHIC(1)) GO TO 2400		!VEHICLE HANDLE?
      IF((PRSO.EQ.VALUA).OR.(PRSO.EQ.EVERY)) GO TO 2900
      IF(.NOT.VAPPLI(PRSA)) GO TO 2400	!VERB HANDLE?
2350	F=RAPPLI(RACTIO(HERE))
C
2400	CALL XENDMV(TELFLG)			!DO END OF MOVE.
      GO TO 2600				!DONE.
C
2900	CALL VALUAC(VALUA)			!ALL OR VALUABLES.
      GO TO 350
C
      END
C XENDMV-	EXECUTE END OF MOVE FUNCTIONS.
C
C DECLARATIONS
C
      SUBROUTINE XENDMV(FLAG)
      IMPLICIT INTEGER(A-Z)
      LOGICAL F,CLOCKD,FLAG,XVEHIC
C
C PARSER OUTPUT
C
      LOGICAL PRSWON
      COMMON /PRSVEC/ PRSA,PRSO,PRSI,PRSWON,PRSCON
C
C VILLAINS AND DEMONS
C
      LOGICAL THFFLG,SWDACT,THFACT
      COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT,SWDSTA
C
      IF(.NOT.FLAG) CALL RSPEAK(341)		!DEFAULT REMARK.
      IF(THFACT) CALL THIEFD			!THIEF DEMON.
      IF(PRSWON) CALL FIGHTD			!FIGHT DEMON.
      IF(SWDACT) CALL SWORDD			!SWORD DEMON.
      IF(PRSWON) F=CLOCKD(X)			!CLOCK DEMON.
      IF(PRSWON) F=XVEHIC(2)			!VEHICLE READOUT.
      RETURN
      END
C XVEHIC- EXECUTE VEHICLE FUNCTION
C
C DECLARATIONS
C
      LOGICAL FUNCTION XVEHIC(N)
      IMPLICIT INTEGER(A-Z)
      LOGICAL OAPPLI
C
C GAME STATE
C
      LOGICAL TELFLG
      COMMON /PLAY/ WINNER,HERE,TELFLG
C
C OBJECTS
C
      COMMON /OBJCTS/ OLNT,ODESC1(220),ODESC2(220),ODESCO(220),
     *	OACTIO(220),OFLAG1(220),OFLAG2(220),OFVAL(220),
     *	OTVAL(220),OSIZE(220),OCAPAC(220),OROOM(220),
     *	OADV(220),OCAN(220),OREAD(220)
C
C ADVENTURERS
C
      COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
     *	AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
C
      XVEHIC=.FALSE.				!ASSUME LOSES.
      AV=AVEHIC(WINNER)			!GET VEHICLE.
      IF(AV.NE.0) XVEHIC=OAPPLI(OACTIO(AV),N)
      RETURN
      END
