#include <stdlib.h>
#include <stdio.h>

#include "map.h"
#include "magic.h"
#include "runtime.h"

char * get_input ();

int curRoom = 0;
int justEnteredRoom = 1;
#define MAXINVENT 4
int freeinv = MAXINVENT;
int inv[MAXINVENT];

struct room * rooms;
struct object * objects;
char ** strings;

void
myread(char *buf, int size,FILE * f) {
  int i;

  for (i = 0; i < size; i++) {
    buf[i] = getc(f) ^ 0xff;
  }
}

void
sigread(char *buf, int size,FILE * f) {
  int i;

  for (i = 0; i < size; i++) {
    buf[i] = getc(f);
  }
}

void
loadstring (char **buf, FILE * f) {
  int ldl;

  ldl = getw(f);
  *buf = malloc(ldl);
  myread(*buf,ldl,f);
}

int nr, nobj, nstr;

void loadMAP () {
  FILE*f;
  int i, j, ldl, ver;
  char sig[9];

  f = fopen("GAMEDATA","r");
  if (f == NULL)
    fatal("ERROR LOADING GAMEDATA FILE");

  sigread(sig,8,f);
  sig[8] = '\0';
  if (strcmp(sig,SIGNATURE) != 0)
    fatal("INVALID DATA FILE");

  ver = getw(f);
  if (ver != VERSION)
    fatal("INCORRECT DATA FILE VERSION");

  nr = getw(f);
  rooms = (struct room *) malloc(nr * sizeof(struct room));
  nobj = getw(f);
  objects = (struct object *) malloc(nobj * sizeof(struct object));
  nstr = getw(f);
  strings = (char **) malloc(nstr * sizeof(char *));

  /* Load rooms */
  for (i = 0; i < nr; i++) {
    loadstring(&rooms[i].longDesc,f);
    rooms[i].dirs[NORTH] = getw(f);
    rooms[i].dirs[SOUTH] = getw(f);
    rooms[i].dirs[EAST ] = getw(f);
    rooms[i].dirs[WEST ] = getw(f);
    rooms[i].dirs[UP   ] = getw(f);
    rooms[i].dirs[DOWN ] = getw(f);
    rooms[i].freeinv = OBJSLOTS;
    for (j = 0; j < OBJSLOTS; j++) {
      rooms[i].objs[j] = getw(f);
      if (rooms[i].objs[j] != -1)
	rooms[i].freeinv--;
    }
  } 

  /* Load objects */
  for (i = 0; i < nobj; i++) {
    loadstring(&objects[i].name,f);
    loadstring(&objects[i].shortDesc,f);
    loadstring(&objects[i].longDesc,f);
    objects[i].pickupable = (char) getc(f);
  }

  /* Load string table */
  for (i = 0; i < nstr; i++) {
    loadstring(&strings[i],f);
  }

  fclose(f);
}

void go (int DIR) {
  /* Check if magic code will let us exit. */
  if (magicEXIT(DIR)) {
    if (rooms[curRoom].dirs[DIR] == -1)
      printf ("You can't go that way!\n");
    else {
      curRoom = rooms[curRoom].dirs[DIR];
      justEnteredRoom = 1;
    }
  }
}

void doEXIT () 
{
  playMSG(1);
  exit(0);
}

int
seq (char *s1, char *s2) {
  return (strcmp(s1,s2) == 0);
}

void doGET (char * args)
{
  char *p1;
  int curobj, i, j;

  /* IGNORE ALL BUT FIRST WORD */
  p1 = args;
  while (*p1 != '\0' && *p1 != ' ') p1++;
  if (*p1 == ' ') *p1 = '\0';
  p1 = args;
  while (*p1 != '\0') {
    *p1 = toupper(*p1);
    p1++;
  }
  
  if (strlen(args) == 0) {
    printf("You didn't tell me what to get.\n");
    return;
  }
  
  /* SEARCH IN CURRENT ROOM FOR THIS OBJECT (LINEAR SEARCH) */
  for (i = 0; i < OBJSLOTS; i++) {
    curobj = rooms[curRoom].objs[i];
    
    if (curobj != -1) {
      if(seq(objects[curobj].name,args)) {
	if (!objects[curobj].pickupable) {
	  printf("You can't pick up %s.\n", objects[curobj].shortDesc);
	  return;
	}

	if (freeinv == 0) {
	  printf("You are carrying too much!\n");
	  return;
	}

	freeinv--;
	/* FIND FREE INVENTORY SLOT */
	for (j = 0; j < MAXINVENT; j++) {
	  if (inv[j] == -1) {
	    inv[j] = curobj;
	    break;
	  }
	}
	
	/* REMOVE FROM CURRENT ROOM */
	rooms[curRoom].objs[i] = -1;
	rooms[curRoom].freeinv++;

	printf("You picked up %s.\n", objects[curobj].shortDesc);
	return;
      }      
    }
  }
  
  printf("I see no %s here.\n", args);
  return;
}

void doDROP (char * args)
{
  char *p1;
  int curobj, i, j;

  /* IGNORE ALL BUT FIRST WORD */
  p1 = args;
  while (*p1 != '\0' && *p1 != ' ') p1++;
  if (*p1 == ' ') *p1 = '\0';
  p1 = args;
  while (*p1 != '\0') {
    *p1 = toupper(*p1);
    p1++;
  }
  
  if (strlen(args) == 0) {
    printf("You didn't tell me what to drop.\n");
    return;
  }
  
  /* SEARCH IN INVENTORY FOR THIS OBJECT (LINEAR SEARCH) */
  for (i = 0; i < MAXINVENT; i++) {
    curobj = inv[i];
    
    if (curobj != -1) {
      if(seq(objects[curobj].name,args)) {
	if (rooms[curRoom].freeinv == 0) {
	  printf("There is no room left on the floor for you to drop it!\n");
	  return;
	}

	rooms[curRoom].freeinv--;
	/* FIND SPACE ON FLOOR */
	for (j = 0; j < OBJSLOTS; j++) {
	  if (rooms[curRoom].objs[j] == -1) {
	    rooms[curRoom].objs[j] = curobj;
	    break;
	  }
	}
	
	/* REMOVE FROM INVENTORY */
	inv[i] = -1;
	freeinv++; 

	printf("You dropped %s.\n", objects[curobj].shortDesc);
	magicDROP(curobj);
	return;
      }      
    }
  }
  
  printf("I see no %s among your possessions.\n", args);
  return;
}

void
doINV () {
  int i;

  if (freeinv == MAXINVENT) {
    printf("You aren't carrying anything right now.\n");
    return;
  }

  printf("You are carrying:\n");
  for (i = 0; i < MAXINVENT; i++) {
    if (inv[i] != -1) {
      printf("\t%s\n", objects[inv[i]].shortDesc);
    }
  }
}

void
doLOOK (char * args) {
  int i, curobj;
  char *p1;

  /* IGNORE ALL BUT FIRST WORD */
  if (args != NULL) {
    p1 = args;
    while (*p1 != '\0' && *p1 != ' ') p1++;
    if (*p1 == ' ') *p1 = '\0';
    p1 = args;
    while (*p1 != '\0') {
      *p1 = toupper(*p1);
    p1++;
    }
  }
  /* No argument -- examine current room */
  if (args == NULL || strlen(args) == 0) {
    printf("%s",rooms[curRoom].longDesc);
    for (i = 0; i < OBJSLOTS; i++) {
      if (rooms[curRoom].objs[i] != -1) {
	printf("%c%s is here.\n",
	       toupper(*objects[rooms[curRoom].objs[i]].shortDesc),
	       objects[rooms[curRoom].objs[i]].shortDesc + 1);
      }
    }
    magicLOOK();
  }

  /* Argument -- examine object named in argument */
  else {
    /* SEARCH IN CURRENT ROOM FOR THIS OBJECT (LINEAR SEARCH) */
    for (i = 0; i < OBJSLOTS; i++) {
      curobj = rooms[curRoom].objs[i];
      
      if (curobj != -1) {
	if(seq(objects[curobj].name,args)) {
	  /* Look at that object */
	  fputs(objects[curobj].longDesc,stdout);
	  return;
	}
      }
    }

    /* REQUESTED OBJECT NOT IN CURRENT ROOM, TRY INVENTORY INSTEAD */
    /* SEARCH IN INVENTORY FOR THIS OBJECT (LINEAR SEARCH) */
    for (i = 0; i < MAXINVENT; i++) {
      curobj = inv[i];
      
      if (curobj != -1) {
	if(seq(objects[curobj].name,args)) {
	  /* Look at that object */
	  fputs(objects[curobj].longDesc,stdout);
	  return;
	}
      }
    }

    /* Requested object not in room or inventory. */
    printf("I see no %s here.\n", args);
    return;
  }
}


void doKILL (char * args)
{
  char *p1;
  int curobj, i, j;

  /* IGNORE ALL BUT FIRST WORD */
  p1 = args;
  while (*p1 != '\0' && *p1 != ' ') p1++;
  if (*p1 == ' ') *p1 = '\0';
  p1 = args;
  while (*p1 != '\0') {
    *p1 = toupper(*p1);
    p1++;
  }
  
  if (strlen(args) == 0) {
    printf("Kill who?\n");
    return;
  }
  
  /* SEARCH IN CURRENT ROOM FOR THIS OBJECT (LINEAR SEARCH) */
  for (i = 0; i < OBJSLOTS; i++) {
    curobj = rooms[curRoom].objs[i];
    
    if (curobj != -1) {
      if(seq(objects[curobj].name,args)) {
	if (objects[curobj].pickupable) {
	  printf("You can't kill %s.\n", objects[curobj].shortDesc);
	  return;
	}
	magicKILL(curobj);
	return;
      }      
    }
  }
  
  printf("I see no %s here.\n", args);
  return;
}

void doSAVE (char * args) {
  int i, j;
  char *p1;
  FILE *f;

  /* IGNORE ALL BUT FIRST WORD */
  p1 = args;
  while (*p1 != '\0' && *p1 != ' ') p1++;
  if (*p1 == ' ') *p1 = '\0';
  p1 = args;
  
  if (strlen(args) == 0) {
    printf("No file specified.\n");
    return;
  }

  /* WRITE TO THIS FILE */
  f = fopen(args,"w");
  fputs("SAVEGAME",f);
  putw(VERSION,f);
  putw(curRoom,f);
  putw(freeinv,f);
  putw(wc_state,f);
  putw(pc_state,f);
  putw(hc_state,f);
  putw(drunkLevel,f);
  for (i = 0; i < MAXINVENT; i++) {
    putw(inv[i],f);
  }
  for (i = 0; i < nr; i++) {
    for (j = 0; j < OBJSLOTS; j++) {
      putw(rooms[i].objs[j],f);
    }
  }
  fclose(f);
  printf("Game saved.\n");
}

void doLOAD (char * args) {
  int i, j, ver;
  char *p1;
  FILE *f;
  char sig[9];

  /* IGNORE ALL BUT FIRST WORD */
  p1 = args;
  while (*p1 != '\0' && *p1 != ' ') p1++;
  if (*p1 == ' ') *p1 = '\0';
  p1 = args;
  
  if (strlen(args) == 0) {
    printf("No file specified.\n");
    return;
  }

  /* READ FROM THIS FILE */
  f = fopen(args,"r");
  if (f == NULL) {
    fprintf(stderr,"CAN'T OPEN FILE %s\n", args);
    return;
  }
  sigread(sig,8,f);
  sig[8] = '\0';
  if (strcmp(sig,"SAVEGAME") != 0) {
    fprintf(stderr,"INVALID SAVEGAME FILE\n");
    return;
  }
  ver = getw(f);
  if (ver != VERSION) {
    fprintf(stderr,"INCORRECT SAVEGAME FILE VERSION\n");
    return;
  }

  curRoom = getw(f);
  freeinv = getw(f);
  wc_state = getw(f);
  pc_state = getw(f);
  hc_state = getw(f);
  drunkLevel = getw(f);
  for (i = 0; i < MAXINVENT; i++) {
    inv[i] = getw(f);
  }
  for (i = 0; i < nr; i++) {
    for (j = 0; j < OBJSLOTS; j++) {
      rooms[i].objs[j] = getw(f);
    }
  }
  fclose(f);
  justEnteredRoom = 1;
  printf ("Game loaded.\n\n");
}

int main ()
{
  char * buf;
  char cmd[9];
  char *p1, *args;
  int i, tmp, curobj;

  loadMAP();
  playMSG(0);
  
  /* INITIALISE INVENTORY */
  for (i = 0; i < MAXINVENT; i++)
    inv[i] = -1;

  while (1) {
    if (justEnteredRoom == 1) {
      doLOOK(NULL);
      justEnteredRoom = 0;
      magicENTER();
    }
    printf("> ");
    buf = get_input();
    if (buf == NULL) {
      printf("\n");
      doEXIT();
    }
    while (*buf != '\0' && *buf == ' ')
      buf++;
    p1 = buf;
    i = 0;
    while (*p1 != '\0' && *p1 != ' ' && i < 8) {
      cmd[i++] = *p1++;
    }
    cmd[i] = '\0';
    args = p1;
    while (*args != ' ' && *args != '\0') args++;
    while (*args == ' ') args++;

    /* TRANSLATE COMMAND TO UPPERCASE FOR APPLICATION OF LOOKUP TABLE */
    for (i = 0; i < 9; i++)
      cmd[i] = toupper(cmd[i]);

    /* LOOKUP COMMAND (USES A LINEAR SEARCH!)
     * ADD YOUR COMMANDS HERE
     */
    if (seq(cmd,"EXIT") || seq(cmd,"DIE") || seq(cmd,"QUIT")) {
      doEXIT();
    }
    else if (seq(cmd,"NORTH") || seq(cmd,"N")) {
      go(NORTH);
    }
    else if (seq(cmd,"SOUTH") || seq(cmd,"S")) {
      go(SOUTH);
    }
    else if (seq(cmd,"EAST") || seq(cmd,"E")) {
      go(EAST);
    }
    else if (seq(cmd,"WEST") || seq(cmd,"W")) {
      go(WEST);
    }
    else if (seq(cmd,"UP") || seq(cmd,"U")) {
      go(UP);
    }
    else if (seq(cmd,"DOWN") || seq(cmd,"D")) {
      go(DOWN);
    }
    else if (seq(cmd,"GET")) {
      doGET(args);
    }
    else if (seq(cmd,"DROP")) {
      doDROP(args);
    }
    else if (seq(cmd,"INV") || seq(cmd,"INVENTORY")) {
      doINV();
    }
    else if (seq(cmd,"LOOK")) {
      doLOOK(args);
    }
    else if (seq(cmd,"TALK")) {
      magicTALK();
    }
    else if (seq(cmd,"BUY")) {
      magicBUY(args);
    }
    else if (seq(cmd,"KILL")) {
      doKILL(args);
    }
    else if (seq(cmd,"SAVE")) {
      doSAVE(args);
    }
    else if (seq(cmd,"LOAD")) {
      doLOAD(args);
    }
    else if (seq(cmd,"HELP")) {
      printf("I know the following commands:\n");
      printf("\tEXIT\n"
	     "\tNORTH\n"
	     "\tSOUTH\n"
	     "\tEAST\n"
	     "\tWEST\n"
	     "\tUP\n"
	     "\tDOWN\n"
	     "\tGET <name of object>\n"
	     "\tDROP <name of object>\n"
	     "\tINVENTORY\n"
	     "\tLOOK\n"
	     "\tLOOK <name of person or object>\n"
	     "\tTALK\n"
	     "\tBUY\n"
	     "\tKILL <person to kill>\n"
	     "\tSAVE <filename>\n"
	     "\tLOAD <filename>\n");
    }
    else {
      printf("I don't know how to do that.\n");
    }

    /*printf("CMD (%s) ARGS (%s)\n", cmd, args);*/
  }
}

#define _INPBUFSIZE 128
char _inpbuf[_INPBUFSIZE];

char * 
get_input ()
{
  int i = 0;
  char ch;

  if (feof(stdin))
    return NULL;

  do {
    ch = getchar();

    if (ch == -1 && i == 0)
      return NULL;
    if (ch == '\n' || ch == -1)
      break;
    else
      _inpbuf[i++] = ch;
  }
  while (i < _INPBUFSIZE-1);
  
  _inpbuf[i] = '\0';
  return _inpbuf;
}

int
objInRoom (int obj, int room) {
  int i;

  for (i = 0; i < OBJSLOTS; i++) {
    if (rooms[room].objs[i] == obj)
      return 1;
  }
  return 0;
}

int
hasObj (int obj) {
  int i;

  for (i = 0; i < MAXINVENT; i++) {
    if (inv[i] == obj)
      return 1;
  }
  return 0;
}

void
addInv (int obj) {
  int i;

  for (i = 0; i < MAXINVENT; i++) {
    if (inv[i] == -1) {
      inv[i] = obj;
      freeinv--;
      return;
    }
  }
}

void
playMSG (int msg) {
  fputs(strings[msg],stdout);
}

char *
getMSG (int msg) {
  return strings[msg];
}

void
fatal (char *s) {
  fprintf(stderr,"FATAL: %s\n",s);
  exit(1);
}

char *
dirToText (int dir) {
  switch (dir)
    {
    case NORTH:
      return "north";
    case SOUTH:
      return "south";
    case EAST: 
      return "east"; 
    case WEST: 
      return "west"; 
    case UP:   
      return "up";   
    case DOWN:  
      return "down";  
    default:
      fatal("GAME INTERNAL ERROR - invalid direction");
    }
}

void
addObj (int obj, int room) {
  int i;

  for (i = 0; i < OBJSLOTS; i++) {
    if (rooms[room].objs[i] == -1) {
      rooms[room].objs[i] = obj;
      rooms[room].freeinv--;
      return;
    }
  }
}

void
removeObj (int obj, int room) {
  int i;

  for (i = 0; i < OBJSLOTS; i++) {
    if (rooms[room].objs[i] == obj) {
      rooms[room].objs[i] = -1;
      rooms[room].freeinv++;
      return;
    }
  }
}
