/* FIRST THINGS FIRST - verbs.t
 *  Copyright (c) 1996, 1997, 1999, 2000, 2001 by J. Robinson Wheeler. All Rights Reserved. */

/*
 *				****	NEW VERB DEFINITIONS	****
 */

/*  Modified verbs */

modify lookVerb
    action(actor) =
    {
	  if ( parserGetMe() = CYOA_Me )
        {
		"\t";
		CYOA_Me.location.desc;
        }
        else pass action;
    }
;

modify undoVerb
    undoMove(actor) =
    {
	  if ( parserGetMe() = CYOA_Me )
	  {
		if ( undo() && undo() ) {
			"(Undoing one command.)\b\t";
			CYOA_Me.location.desc;
		} else {
			"No more undo information available.\b";
		}
	  }
	  else pass undoMove;
    }
;

modify quitVerb
    quitGame(actor) =
    {
        local yesno;

	  if ( parserGetMe() = CYOA_Me )
	  {
		"\bDo you really want to quit this CYOA story? (YES or NO) > ";
        }
	  else
	  {
        	scoreRank();
		"\bDo you really want to quit? (YES or NO) > ";
        }
	  yesno := yorn();
        "\b";
        if (yesno = 1)
        {
		if ( parserGetMe() = CYOA_Me )
		{
			endgame.desc;
			CYOA_quit();
			return;
            }
            terminate();    // allow user good-bye message
            quit();
        }
        else
        {
            "Okay. ";
        }
    }
;

modify restartVerb
    restartGame(actor) =
    {
        local yesno;
        while (true)
        {
		if ( parserGetMe() = CYOA_Me )
		{
			"\bAre you sure you want to restart this CYOA story? (YES or NO) > ";
	      }
		else
		{
            	"Are you sure you want to start over? (YES or NO) > ";
            }
		yesno := yorn();
            if (yesno = 1)
            {
		    if ( parserGetMe() = CYOA_Me )
		    {
			  "\b";
			  CYOA_Me.location := startplace;
			  CYOA_Me.location.desc;
			  return;
		    }
                "\n";
                scoreStatus(0, 0);
                restart(initRestart, global.initRestartParam);
                break;
            }
            else if (yesno = 0)
            {
                "\nOkay.\n";
                break;
            }
        }
    }
;

modify travelVerb
	action( actor ) = 
	{
		if ( PLaura.daemonCount > 0 )
		{
			if ( PLaura.walkPathCount > 0 )
			{
				if ( self.travelDir( actor ) = PLaura.walkPath[PLaura.walkPathCount + 1] )
					"You decide to let Laura take the lead. ";
			}
			else
				"Something tells you to stick with Laura for a while instead of
				wandering off. ";
		}
		else actor.travelTo( self.travelDir( actor ) );
	}
;

replace eVerb: travelVerb
    verb = 'e' 'east' 'go east'
    travelDir(actor) = { return actor.location.east; }
;
replace sVerb: travelVerb
    verb = 's' 'south' 'go south'
    travelDir(actor) = { return actor.location.south; }
;
replace nVerb: travelVerb
    verb = 'n' 'north' 'go north'
    travelDir(actor) = { return actor.location.north; }
;
replace wVerb: travelVerb
    verb = 'w' 'west' 'go west'
    travelDir(actor) = { return actor.location.west; }
;
replace neVerb: travelVerb
    verb = 'ne' 'northeast' 'go ne' 'go northeast'
    travelDir(actor) = { return actor.location.ne; }
;
replace nwVerb: travelVerb
    verb = 'nw' 'northwest' 'go nw' 'go northwest'
    travelDir(actor) = { return actor.location.nw; }
;
replace seVerb: travelVerb
    verb = 'se' 'southeast' 'go se' 'go southeast'
    travelDir(actor) = { return actor.location.se; }
;
replace swVerb: travelVerb
    verb = 'sw' 'southwest' 'go sw' 'go southwest'
    travelDir(actor) = { return actor.location.sw; }
;
replace inVerb: travelVerb
    verb = 'in' 'go in' 'enter' 'go to' 'go into'
    sdesc = "enter"
    doAction = 'Enter'
    travelDir(actor) = { return actor.location.in; }
    ioAction(onPrep) = 'EnterOn'
    ioAction(inPrep) = 'EnterIn'
    ioAction(withPrep) = 'EnterWith'
;
replace outVerb: travelVerb
    verb = 'out' 'go out' 'exit' 'leave'
    travelDir(actor) = { return actor.location.out; }
;
replace dVerb: travelVerb
    verb = 'd' 'down' 'go down'
    travelDir(actor) = { return actor.location.down; }
;
replace uVerb: travelVerb
    verb = 'u' 'up' 'go up'
    travelDir(actor) = { return actor.location.up; }
;

modify askVerb
	verb = 'question' 'query'
	ioAction( forPrep )='AskFor'
;

replace attackVerb: deepverb
	verb = 'attack' 'hit' 'strike' 'punch' 'pummel' 'smash' 'slap' 'swat'
	sdesc = "attack"
	prepDefault = withPrep
	ioAction(withPrep) = 'AttackWith'
	doAction = 'Attack'
;

modify boardVerb
	verb = 'climb in' 'climb into' 'hop in' 'hop into' 'jump in' 'jump into'
		'leap in' 'leap into'
	disambigDobj(actor, prep, iobj, verprop, wordlist, objlist, flaglist,
		numberWanted, isAmbiguous, silent) =
	{
		if ( ( isAmbiguous ) && 
			( Me.location = platform.location ) )
			return( [ DISAMBIG_DONE platform ] );
				return ( [ DISAMBIG_CONTINUE ] + objlist );
	}
;

modify breakVerb
	verb = 'rip' 'shred' 'tear'
;

modify cleanVerb
	verb = 'clean up' 'clean off'
;

modify climbVerb
	verb = 'climb up' 'ascend' 'shimmy up' 'scale' 'scale up' 'crawl up' 
		'shimmy on' 'shimmy along' 'shimmy across' 'shimmy forward on' 
		'crawl on' 'crawl along' 'crawl across' 'crawl forward on' 
		'climb along' 'climb across'
;

modify dVerb
	doAction = 'GoDown'
;

modify deepverb
	allowall = nil
	doDefault( actor, prep, iobj ) =
	{
		if ( self.allowall = nil )
		{
			if ( objwords( 1 ) = [ 'A' ] )
			{
				global.allMessage := 'You can\'t use \'all\' with that verb.';
				return [];
			}
			pass doDefault;
		}
		else pass doDefault;
	}
;

modify digVerb
	verb = 'dig up'
	ioDefault( actor, prep ) =
	{
		if ( shovel.deepIsIn( Me ) || shovel.deepIsIn( Me.location ) ) 
			return( [ shovel ] );
		return actor.contents + actor.location.contents;
	}
;

modify dropVerb
	allowall = true
	action( actor ) = 
	{
		if ( isclass( Me.location, FtreeRoom ) )
			brokenTrunk.doLetGo( actor );
		else askdo;
	}
	ioAction( outPrep ) = 'ThrowOut'
	ioAction( onPrep ) = 'PutOn'
	ioAction( downPrep ) = 'PutIn'
	ioAction( inPrep ) = 'PutIn'
;

modify eVerb
	verb = 'right' 'go right'
;

modify followVerb
	verb = 'chase' 'tail'
;

modify getOutVerb
	verb = 'climb out' 'climb outof' 'hop out' 'hop off' 'hop offof' 'hop outof'
			'disembark'
;

modify giveVerb
	allowall = nil
	verb = 'feed'
;

modify helloVerb
	verb = 'hey' 'hallo' 'greets' 'greet' 'hiya' 'hola' 'howdy' 'heya'
		   'heyas' 
	replace action( actor ) =
	{
		if ( self.switcher )
		{
			"Nice weather we've been having. ";
			self.switcher := nil;
		}
		else
		{
			"Greetings. ";
			self.switcher := true;
		}
	}
	doAction = 'Hello'
;

modify iVerb
	verb = 'dir'
	action( actor ) =
	{
		if ( isclass( actor.location, FtreeRoom ) && 
			( actor.location != FmidTree && actor.location != trunk1 ) )
			"You are holding onto the trunk with both hands. ";
		pass action;
	}
;

modify inspectVerb
	verb = 'ls'
;

modify inVerb
	verb = 'ahead' 'straight' 'forward' 'fore' 
		'shimmy n' 'shimmy north' 'shimmy forward' 'shimmy ahead' 
		'crawl n' 'crawl north' 'crawl forward' 'crawl ahead' 
		'climb n' 'climb north' 'climb forward' 'climb ahead' 
;

replace jumpVerb: deepverb
	verb = 'jump' 'jump over' 'jump off' 'jump to' 'jump down' 'jump up' 'jump downfrom'
		'jump out' 'leap' 'leap over' 'leap off' 'leap to' 'leap down' 'leap for'
		'leap up' 'leap out' 'hop' 'hop over' 'hop to' 'hop down' 'hop up'
		'drop off' 'drop offof' 'drop downfrom' 'leap downfrom' 'jump across' 
		'leap across' 'hop across'
	sdesc = "leap to"
	doAction = 'LeapTo'
	action( actor ) =
	{
		switch ( actor.location )
		{
			case FProck:
			case Prock:
			case rock:
			case Frock:
			case NFrock:
				actor.location.doUnboard( actor );
				break;
			case platform: 
				platform.doUnboard( actor );
				break;
			case platform2:
				platform2.doUnboard( actor );
				break;
			case northRoof: 
			case southRoof: 
			case FnorthRoof: 
			case FsouthRoof: 
				"That's a dangerous thing to do when you're thirty feet
				up on a slippery roof. ";
				break;
			case midTree:
				"You leap out of the tree and plummet to the ground. 
				Fortunately, you land on your feet, none the worse for wear. \b";
				actor.travelTo( southOfHouse );
				break;
			case FmidTree:
				"It is too dangerous to be jumping when the rain has slickened
				the tree and the ground. ";
				break;
			case trunk1:
			case trunk2:
			case pointOfNoReturn:
			case trunkMidway:
			case trunk4:
				"It is too dangerous to jump off the tree from here. The 
				ground is farther away than you first imagined. ";
				break;	
			case hangingForDearLife:
				brokenTrunk.doLetGo( Me );
				break;
			case endOfTrunk:
				Me.travelTo( Me.location.in );
				break;
			case topOfTree:
				"You are too high up in the tree. If you jump you'll break
				your ankle. ";
				break;
			case attic:
				"The tree is too far away to risk leaping back. If you jump 
				you'll break your ankle. ";
				break;
			case dangling:
				"You leap from the tire swing and land with cat-like grace. A clumsy, 
				two-legged cat, but there you go.\b";
				actor.travelTo( southOfHouse );
				break;
			case southOfHouse:
				if ( southOfHouseWindow.examined )
					southOfHouseWindow.doLeap( Me );
				else
					"You leap. It feels good to exercise your legs. ";
				break;
			case ledgeSouth:
				"You jump across to the north side of the gap. ";
				Me.moveInto( ledgeNorth );
				break;
			case ledgeNorth:
				"You jump across to the south side of the gap. ";
				Me.moveInto( ledgeSouth );
				break;
			case P2ndFloor:
				if ( Architect.location = P2ndFloor )
					"The architect cautions you, \"Please be careful. 
					It's not safe to jump around in a construction area.\" ";
				else
					"You jump, taking care not to fall down through the 
					floor. ";
				break;
			default:
				"You leap. It feels good to exercise your legs. ";
				break;
		}
	}
;

modify knockVerb
	verb = 'bang' 'bang on' 'pound' 'pound on'
;

modify lieVerb
	action( actor ) =
	{
		askdo;
	}
;

modify lookInVerb
	verb = 'look down'
;

modify moveVerb
	ioAction( onPrep ) = 'PutOn'
;

modify megaVerb
	action( actor ) =
	{
		if ( not global.wizard )
			"You have to be a wizard to do that. ";
		else pass action;
	}
;

modify openVerb
	ioAction( withPrep ) = 'OpenWith'
	prepDefault = withPrep
;

modify outVerb
	verb = 'go back' 'shimmy s' 'shimmy south' 'shimmy back' 'shimmy backwards' 
		'shimmy backward' 'shimmy aft' 'aft' 'crawl s' 'crawl south' 
		'crawl back' 'crawl backwards' 'crawl backward' 'crawl aft'
		'crawl off' 'shimmy off' 'retreat'
;

modify pokeVerb
	verb = 'stab' 'prick' 'inject'
	ioAction( withPrep ) = 'StabWith'
	prepDefault = withPrep
;

modify pullVerb
	verb = 'yank'
;

modify pushVerb
	verb = 'shove'
	ioAction( onPrep ) = 'PutOn'
	disambigDobj( actor, prep, iobj, verprop, wordlist, objlist, flaglist,
		numberWanted, isAmbiguous, silent ) =
	{
		if ( isAmbiguous ) 
		{
			if ( Me.location = platform || Me.isIn( platform.location ) )
				return( [ DISAMBIG_DONE timeButton ] );
			if ( Me.location = platform2 || Me.isIn( platform2.location ) )
				return( [ timeButton2 ] );
			if ( Me.location = inGarage )
				return( [ DISAMBIG_DONE wallOpener ] );
		}
		return ( [ DISAMBIG_CONTINUE ] + objlist );
	}
	doDefault( actor, prep, io ) =
	{
		if ( Me.location = platform || Me.isIn( platform.location ) )
			return( [ timeButton ] );
		if ( Me.location = platform2 || Me.isIn( platform2.location ) )
			return( [ timeButton2 ] );
		if ( Me.location = inGarage )
			return( [ wallOpener ] );
		return actor.contents + actor.location.contents;
	}
;

modify putVerb
	allowall = true
	verb = 'plant'
	ioAction( underPrep ) = 'PutUnder'
	ioAction( outPrep ) = 'PutIn'
	doDefault(actor, prep, io) =
	{
		return( actor.contents );
	}
;

modify sayVerb
	verb = 'state'
	validDo(actor, obj, seqno) = { return(seqno = 1); }
;

modify scriptVerb
	verb = 'script on'
;

modify searchVerb
	verb = 'browse' 'browse through' 'browse in'
;

modify sleepVerb
	verb = 'turn in'
	action( actor ) = { goToSleep(); }
;

modify showVerb
	validIoList( actor, prep, dobj ) = ( global.NPC_list );
;

modify sitVerb
	verb = 'sit up' 'sit upon'
	action( actor ) = { askdo; }
;

modify snarfVerb
	doAction = 'Snarf'
;

modify standVerb
	doAction = 'StandUp'
;

modify standOnVerb
	verb = 'step on'
;

modify takeVerb
	verb = 'pick' 'pluck' 'fetch'
	action( actor ) = { askdo; }
	allowall = true
;

modify throwVerb
	ioAction( inPrep ) = 'ThrowIn'
	ioAction( outPrep ) = 'ThrowOut'
	doAction = 'Throw'
;

modify touchVerb
	verb = 'feel' 'fondle' 'pet' 'pat'
	sdesc = "touch"
	doAction = 'Touch'
;

modify turnVerb
	verb = 'set'
	ioAction( inPrep ) = 'TurnIn'
;

modify typeVerb
	ioDefault( actor, prep ) =
	{
		if ( Me.location = stripMall ) return( [ ATMkeypad ] );
		return actor.contents + actor.location.contents;
	}
;

modify unMegaVerb
	action( actor ) =
	{
		if ( not global.wizard )
			"You have to be a wizard to do that. ";
		else pass action;
	}
;

modify unscriptVerb
	verb = 'script off'
;

modify uVerb
	doAction = 'GoUp'
;

modify wVerb
	verb = 'left' 'go left'
;

replace yellVerb: deepverb
	verb = 'yell' 'shout' 'scream' 'holler' 
			'yell at' 'shout at' 'scream at' 'holler at'
	sdesc = "yell"
	doAction = 'YellAt'
	action( actor ) =
	{
		if ( Me.location = hangingForDearLife )
			rescue.doYellFor( actor );
		else
			"%Your% throat is a bit sore now. ";
	}
;


/*	New verb definitions  */

aboutVerb: sysverb
	sdesc = "about"
	verb = 'about' 'info'
	showAbout( actor ) = 
	{
		if ( parserGetMe() = CYOA_Me )
			aboutTheCYOAGame.sdesc;
		else
			aboutTheGame.sdesc;
	}
	action(actor) =
	{
		self.showAbout( actor );
		abort;
	}
;

actLikeVerb: deepverb
	verb = 'act like' 'mimic' 'copy' 'ape' 'imitate' 'impersonate'
	sdesc = "act like"
	doAction = 'ActLike'
	validDo(actor, obj, seqno) = { return(seqno = 1); }
	validDoList(actor, prep, iobj) = ( acorn )
;

addVerb: deepverb
	verb = 'add'
	sdesc = "add"
	ioAction( toPrep ) = 'AddTo'
	prepDefault = toPrep
;

badVerb: deepverb
	sdesc = "bad"
	verb = 'bad'
	action( actor ) = 
	{
		"Sorry. ";
	}
	doAction = 'Bad'
;

biteVerb: deepverb
	verb = 'bite' 'bite on' 'gnaw' 'gnaw on' 'chew' 'chew on' 'chomp' 'chomp on'
	sdesc = "bite"
	doAction = 'Bite'
;

blinkVerb: deepverb
	verb = 'blink'
	sdesc = "blink"
	action( actor ) = { "You blink. "; }
;

blowVerb: deepverb
	verb = 'blow'
	sdesc = "blow"
	doAction = 'Blow'
;

blowOnVerb: deepverb
	verb = 'blow on'
	sdesc = "blow on"
	doAction = 'BlowOn'
;

blowUpVerb: deepverb
	verb = 'blow up' 'inflate' 'pump up' 'pump'
	sdesc = "blow up"
	prepDefault = withPrep
	ioAction( withPrep ) = 'BlowUp'
;

bribeVerb: deepverb
	verb = 'bribe'
	sdesc = "bribe"
	doAction = 'Bribe'
	ioAction( withPrep ) = 'BribeWith'
	prepDefault = withPrep
;

buyVerb: deepverb
	verb = 'buy' 'purchase' 'pay for' 'order' 'invest' 'invest in'
	sdesc = "buy"
	doAction = 'Buy'
	ioAction( fromPrep ) = 'BuyFrom'
;

callVerb: deepverb
	verb = 'call'
	sdesc = "call"
	doAction = 'Call'
;

callOnverb: deepverb
	verb = 'call on' 'dial on'
	sdesc = "call on"
	prepDefault = onPrep
	ioAction( onPrep ) = 'CallOn'
	validDo( actor, obj, seqno ) =
	{
		if ( obj.isPhone )
			return( not obj.isReachable( actor ) );
		return( true );
	}
	validDoList = nil
;

catchVerb: deepverb
	sdesc = "catch"
	verb = 'catch' 'nab' 'trap' 'snare'
	doAction = 'Catch'
;

changeVerb: deepverb
	verb = 'change' 'modify' 'alter' 'adjust'
	sdesc = "change"
	doAction = 'Change'
;

checkVerb: deepverb
	allowall = true
	verb = 'check'
	sdesc = "check"
	ioAction( withPrep ) = 'CheckWith'
	prepDefault = withPrep
	disambigIobj( actor, prep, iobj, verprop, wordlist, objlist, flaglist,
		numberWanted, isAmbiguous, silent ) =
	{
		if ( isAmbiguous ) 
		{
			return( [ DISAMBIG_DONE detector ] );
		}
				return ( [ DISAMBIG_CONTINUE ] + objlist );
	}
;

climbdownVerb: deepverb
	verb = 'climb down' 'descend' 'shimmy down' 'crawl down' 'shimmy south on'
		'shimmy back on' 'shimmy s on' 'shimmy d on' 'crawl s on' 'crawl south on'
		'crawl back on' 'climb back down' 'climb back on' 'climb s on' 'climb south on'
	sdesc = "climb down"
	doAction = 'ClimbDown'
;

consultVerb: deepverb
	verb = 'consult'
	sdesc = "consult"
	prepDefault = aboutPrep
	ioAction( onPrep ) = 'ConsultAbout'
	ioAction( aboutPrep ) = 'ConsultAbout'
	validDoList( actor, prep, iobj ) = ( [ timeManual libraryBook rareBook fernBook ] +
		global.NPC_list )
	validIo(actor, obj, seqno) = { return(seqno = 1); }
	validIoList(actor, prep, iobj) = (nil)
;

countVerb: deepverb
	verb = 'count'
	sdesc = "count"
	doAction = 'Count'
	action( actor ) = { "Time passes... "; }
;

crawlVerb: deepverb
	verb = 'crawl'
	sdesc = "crawl"
	action( actor ) = 
	{
		if ( actor.location.isTreeRoom )
			actor.travelTo( actor.location.north );
		else
			"There is no need to crawl here. ";
	}
;

creditsVerb: sysverb
	verb = 'credit' 'credits'
	sdesc = "credits"
	showCredits( actor ) = 
	{
		if ( parserGetMe() = CYOA_Me )
			CYOA_credits.sdesc;
		else
			credits.sdesc;
	}
	action(actor) =
	{
		self.showCredits( actor );
		abort;
	}
;

crossVerb: deepverb
	verb = 'cross' 'go across'
	sdesc = "cross"
	doAction = 'Cross'
;

cryVerb: deepverb
	sdesc = "cry"
	verb = 'cry'
	doAction = 'YellFor'
	action( actor ) = 
	{
		if ( isclass( Me.location, FtreeRoom ) )
			rescue.doCry( actor );
		else
			"You let loose some pent-up tears, and feel a bit better. ";
	}
	validDo(actor, obj, seqno) = { return(seqno = 1); }
	validDoList(actor, prep, iobj) = ( wolf )
;

cutVerb: deepverb
	verb = 'cut' 'slice' 'chop' 'hack' 'hack through' 'cut through'
		'chop through' 'slice through'
	sdesc = "cut"
	ioAction( withPrep ) = 'HackWith'
	prepDefault = withPrep
	disambigIobj( actor, prep, dobj, verprop, wordlist, objlist, flaglist,
		numberWanted, isAmbiguous, silent ) =
	{
		if ( ( isAmbiguous ) && machete.isIn( Me ) )
				return( [ DISAMBIG_DONE machete ] );
				return ( [ DISAMBIG_CONTINUE ] + objlist );
	}
	ioDefault( actor, prep ) =
	{
		if ( machete.deepIsIn( Me ) || machete.deepIsIn( Me.location ) ) 
			return( [ machete ] );
		return actor.contents + actor.location.contents;
	}
;

danceVerb: deepverb
	verb = 'dance' 'jiggy' 'jig'
	sdesc = "dance"
	action( actor ) = 
	{
		"You trot out a couple of your best steps. ";
		
		if ( Fred.location = Me.location )
			"\bFred smirks and says, \"Hey, not bad.\" ";
		else if ( FFred.location = Me.location )
			"\b\^<<FFred.thedesc>> looks at you and says, \"Dang fool kid.\" ";
		else if ( Laura.location = Me.location )
			"\bLaura laughs and says, \"You sure are exuberant today.\" ";
		else if ( FLaura.location = Me.location )
			"\bLaura glares at you and says, \"I don't appreciate your
			flippancy.\" ";
		else if ( FFLaura.location = Me.location )
			"\bLaura gives you an icy stare. ";
		else if ( Architect.location = Me.location )
			"\bThe architect says, \"Do you mind doing that somewhere else? I am 
			trying to work here.\" ";
		else if ( workers.location = Me.location )
			"The workers laugh and clap. ";
		else if ( antiqueMerchant.location = Me.location )
			"\bThe merchant gives you a sideways look and says, \"Ahem. This
			is a respectable establishment. Kindly stifle your muse, charming
			though it might be.\" ";
		else if ( squirrel.location = Me.location )
			"The squirrel looks at you quizzically, and only finally seems
			to show some sign of amusement when you nearly lose your footing
			on the roof. ";
		else
			"Hopefully, no one was watching. ";
	}
;

depositVerb: deepverb
	verb = 'deposit'
	sdesc = "deposit"
	doAction = 'Deposit'
	ioAction( inPrep ) = 'DepositIn'
	prepDefault = inPrep
;

drawOnVerb: deepverb
	verb = 'draw' 'write' 'scrawl' 'sketch' 'doodle' 'engrave'
	sdesc = "engrave on"
	prepDefault = onPrep
	ioAction( onPrep ) = 'DrawOn'
	ioAction( inPrep ) = 'DrawOn'
	validDo(actor, obj, seqno) = { return(seqno = 1); }
	validDoList(actor, prep, iobj) = ( secretDoor )
;

drawOnWithVerb: deepverb
	verb = 'draw on' 'write on' 'scrawl on' 'sketch on' 'doodle on'
			'draw in' 'write in' 'scrawl in' 'sketch in' 'doodle in'
	sdesc = "draw on"
	prepDefault = withPrep
	ioAction( withPrep ) = 'DrawOnWith'
;

driveVerb: deepverb
	verb = 'drive' 'drive north' 'drive n' 'drive south' 'drive s'
		'drive east' 'drive e' 'drive west' 'drive w'
		'drive northeast' 'drive ne' 'drive northwest' 'drive nw'
		'drive southeast' 'drive se' 'drive southwest' 'drive sw'
		'drive up' 'drive u' 'drive down' 'drive d'
		'steer' 'steer north' 'steer n' 'steer south' 'steer s'
		'steer east' 'steer e' 'steer west' 'steer w'
		'steer northeast' 'steer ne' 'steer northwest' 'steer nw'
		'steer southeast' 'steer se' 'steer southwest' 'steer sw'
		'steer up' 'steer u' 'steer down' 'steer d'
	sdesc = "drive"
	doAction = 'Drive'
;

emptyVerb: deepverb
	sdesc = "empty"
	verb = 'empty' 'empty out' 'clean out' 'unclog' 'dump' 'dump out'
	doAction = 'Empty'
	ioAction( inPrep ) = 'PourIn'
	ioAction( onPrep ) = 'PourIn'
	prepDefault = onPrep
;

excreteVerb: deepverb
	sdesc = "excrete"
	verb = 'piss' 'piss in' 'piss on' 'pee' 'pee in' 'pee on' 
			'crap' 'crap in' 'crap on' 'shit' 'shit in' 'shit on'
	doAction = 'ExcreteIn'
	action( actor ) = 
	{
		if ( Me.location.isBathroom )
			Me.location.myToilet.doExcreteIn( actor );
		else
			"Oh! How unseemly. ";
	}
;

exitsVerb: deepverb
	verb = 'exits' 'xits'
	sdesc = "exits"
	action( actor ) =
	{
		if ( actor.location.xdesc )
		{
			"\n";
		}
		else
			"\nThere don't seem to be any visible exits from this location. ";
	}
;

fillVerb: deepverb
	verb = 'fill'
	sdesc = "fill"
	doAction = 'Fill'
	action( actor ) = { askdo; }
	ioAction( withPrep ) = 'FillWith'
	prepDefault = withPrep
;

findVerb: deepverb
	verb = 'find' 'locate'
	sdesc = "find"
	doAction = 'Find'
;

fixVerb: deepverb
	verb = 'fix' 'repair' 'tighten'
	sdesc = "fix"
	ioAction( withPrep ) = 'FixWith'
	prepDefault = withPrep
;

flushVerb: deepverb
	verb = 'flush'
	sdesc = "flush"
	doAction = 'Flush'
;

/* fullscore:  print a list of what the player did to earn points so far */
fullscoreVerb: deepverb
	verb = 'f' 'ful' 'full' 'fullscore'
	action( actor ) =
	{
		scoreRank();
		if ( global.score > 0 )
		{
			local temp;
			
			"You have earned the following:\b";
			
			for ( temp:=1; temp<=27; temp++ )
			{
				if ( global.scoreCard[ temp ] != 0 )
				switch( temp )
				{
					case 1: "\n\ 5 points for finding the garage door opener ";
						break;
					case 2: "\n\ 4 points for climbing onto the roof the first time ";
						break;
					case 3: "\n10 points for getting to the end of the junk in the garage ";
						break;
					case 4: "\n\ 5 points for stepping onto the platform the first time ";
						break;
					case 5: "\n\ 5 points for arriving in the far past the first time ";
						break;
					case 6: "\n\ 5 points for arriving in the past the first time ";
						break;
					case 7: "\n\ 5 points for arriving in the future the first time ";
						break;
					case 8: "\n\ 4 points for giving the bad shingle to the architect ";
						break;
					case 9: "\n\ 3 points for cleaning out the drainpipe ";
						break;
					case 10: "\n\ 4 points for making it through the maze to the stream ";
						break;
					case 11: "\n\ 6 points for planting the acorn in the hole ";
						break;
					case 12: "\n\ 2 points for fixing the wheel with the screwdriver ";
						break;
					case 13: "\n\ 3 points for pouring a second jug of miracle-gro ";
						break;
					case 14: "\n\ 5 points for pouring a fifth jug of miracle-gro ";
						break;
					case 15: "\n10 points for leaping to the attic ";
						break;
					case 16: "\n\ 1 point for using the tire to break your fall from the attic ";
						break;
					case 17: "\n\ 5 points for giving a piping hot sandwich to the architect ";
						break;
					case 18: "\n\ 5 points for entering the secret passage the first time ";
						break;
					case 19: "\n\ 7 points for opening a new bank account ";
						break;
					case 20: "\n\ 7 points for showing Fred his future self ";
						break;
					case 21: "\n\ 4 points for installing the lightning rod ";
						break;
					case 22: "\n\ 5 points for buying DibbleBits stock ";
						break;
					case 23: "\n\10 points for giving Laura the sealed envelope";
						break;
					case 24: "\n\ 5 points for arriving in the new far future for the first time ";  
						break;
					case 25: "\n\ 5 points for grinding a duplicate front door key ";
						break;
					case 26: "\n\ 1 point for putting the duplicate key under the doormat ";
						break;
					case 27: "\n";
							if ( global.scoreCard[ temp ] < 10 )
								"\ ";
							"<<global.scoreCard[ temp ]>> points for finding
							various items ";
						break;
				}
			}
		}
	}
;

goodVerb: deepverb
	verb = 'good' 'great' 'neat' 'neato' 'keen' 'nice'
	sdesc = "good"
	action( actor ) =
	{
		"Thanks. ";
	}
	doAction = 'Good'
;

hackDirVerb: deepverb
	verb = 'hack n' 'hack north' 'hack s' 'hack south' 'hack e' 'hack east' 'hack w'
		'hack west' 'hack nw' 'hack northwest' 'hack ne' 'hack northeast' 'hack sw'
		'hack southwest' 'hack se' 'hack southeast'
	sdesc = "cut"
	action( actor ) = { "You can only hack objects, not directions. "; }
	ioAction( withPrep ) = 'HackDirWith'
	prepDefault = withPrep
	disambigIobj( actor, prep, dobj, verprop, wordlist, objlist, flaglist,
		numberWanted, isAmbiguous, silent ) =
	{
		if ( ( isAmbiguous ) && machete.isIn( Me ) )
				return( [ DISAMBIG_DONE machete ] );
				return ( [ DISAMBIG_CONTINUE ] + objlist );
	}
	ioDefault( actor, prep ) =
	{
		if ( machete.deepIsIn( Me ) || machete.deepIsIn( Me.location ) ) 
			return( [ machete ] );
		return actor.contents + actor.location.contents;
	}
;

headVerb: deepverb
	verb = 'head'
	sdesc = "hit"
	doAction = 'Head'
;

helpVerb: sysverb
	verb = 'help' 'aid'
	sdesc = "help"
	doAction = 'Help'
	action( actor ) = 
	{
		if ( parserGetMe() = CYOA_Me )
		{
			"This CYOA story does not accept standard interactive commands.
			Instead, it presents you with a situation and a number of
			choices to make. You can choose one of the options given,
			or you may enter one of the following:\n
			\thelp\tThis help message.\n
			\tquit\tQuit out of the CYOA story (abbr: 'q').\n
			\tlook\tRe-display the description of the situation (abbr: 'l').\n
			\tundo\tUndo the previous command (abbr: 'u').\n
			\tsave\tSave the current game in progress.\n
			\trestore\tRestore a previously saved game.\n
			\trestart\tRestart the game from the beginning.\n";
			abort;
		}
		if ( isclass( Me.location, FtreeRoom ) )
			rescue.doYellFor( actor );
		else
		{
			helpSystem.ldesc;
			abort;
		}
	}
;

hintVerb: sysverb
	verb = 'hint'
	sdesc = "hint"
	giveHint( actor ) =
	{
		thinkVerb.action( actor );
	}
	action( actor ) =
	{
//		self.giveHint( actor );
		"No hints available. ";
		abort;
	}
;

holdOnVerb: deepverb
	sdesc = "hold onto"
	verb = 'hold on' 'hold onto' 'grab' 'grab hold of' 'grab on' 'grab onto' 
			'grip' 'grip on' 'grip onto' 'hang on' 'hang onto' 'reach' 
			'reach for' 'strain' 'strain for'
	doAction = 'HoldOn'
	action( actor ) = 
	{
		if ( isclass( Me.location, FtreeRoom ) )
			brokenTrunk.doHoldOn( actor );
		else askdo;
	}
;

honkVerb: deepverb
	verb = 'honk' 'beep'
	sdesc = "honk"
	doAction = 'Honk'
	action( actor ) = { "Honk! Honk! "; }
;

hugVerb: deepverb
	verb = 'hug'
	sdesc = "hug"
	doAction = 'Hug'
;

jumpOnVerb: deepverb
	verb = 'jump on' 'jump onto' 'leap on' 'leap onto' 'stomp on'  'hop on' 'hop onto'
	sdesc = "jump on"
	doAction = 'JumpOn'
;

kickVerb: deepverb
	verb = 'kick' 'punt'
	sdesc = "kick"
	doAction = 'Kick'
;

killVerb: deepverb
	verb = 'kill' 'hate' 'murder' 'frag'
	sdesc = "kill"
	action( actor ) = { "I know exactly how you feel. "; }
	ioAction( withPrep ) = 'KillWith'
	doAction = 'Kill'
	ioDefault( actor, prep ) =
	{
		if ( machete.deepIsIn( Me ) || machete.deepIsIn( Me.location ) ) 
			return( [ machete ] );
		return actor.contents + actor.location.contents;
	}
;

kissVerb: deepverb
	verb = 'kiss' 'embrace'
	sdesc = "kiss"
	action( actor ) = { "Mwah. "; }
	doAction = 'Kiss'
;

laughVerb: deepverb
	verb = 'ha' 'ha ha' 'ha ha ha' 'hah' 'hee' 'heh' 'ho' 'ho ho' 'ho ho ho' 'har'
			'laugh' 'laugh at' 'laff' 'laff at' 'mock' 'snicker' 'snicker at'
			'chortle' 'chortle at' 'giggle' 'giggle at' 'guffaw' 'guffaw at'
			'scoff at' 'flip off' 'tease' 'chuckle' 'chuckle at' 'snirk' 'snort'
			'snort at' 'hee hee' 'hee hee hee' 'lol'			
	sdesc = "laugh"
	action( actor ) = { "That's a real knee-slapper, all right! "; }
	doAction = 'LaughAt'
;

letGoVerb: deepverb
	verb = 'let go' 'let goof' 'fall' 'fall off' 'fall offof'
	sdesc = "let go of"
	doAction = 'LetGo'
	action( actor ) = 
	{
		if ( isclass( Me.location, FtreeRoom ) )
			brokenTrunk.doLetGo( actor );
		else askdo;
	}
;

lickVerb: deepverb
	verb = 'lick'
	sdesc = "lick"
	doAction = 'Lick'
;

liftVerb: deepverb
	verb = 'lift' 'raise'
	sdesc = "lift"
	doAction = 'Lift'
	ioAction( withPrep ) = 'PryWith'
	prepDefault = withPrep
;

listenVerb: deepverb
	verb = 'listen' 'listen to' 'hear'
	sdesc = "listen to"
	action( actor ) = { say( actor.location.listenDesc ); }
	doAction = 'Listen'
;

modify lookThruVerb
	verb = 'look out' 'l out'
;

lookupVerb: deepverb
	verb = 'look up' 'read about' 'read abotu'
	sdesc = "look up"
	action( actor ) = { askdo; }
	ioAction( inPrep ) = 'LookupIn'
	prepDefault = inPrep
	validDo(actor, obj, seqno) = { return(seqno = 1); }
	validDoList(actor, prep, iobj) = (nil)
	validIoList( actor, prep, dobj ) = ( [ timeManual libraryBook 
		rareBook fernBook directoryDisplay ] )
	ioDefault( actor, prep ) =
	{
		if ( timeManual.deepIsIn( Me ) || timeManual.deepIsIn( Me.location ) ) 
			return( [ timeManual ] );
		return actor.contents + actor.location.contents;
	}
;

loveVerb: deepverb
	verb = 'love' 'adore' 'admire' 'like' 'i love' 'i adore' 'i admire' 'i like'
	sdesc = "love"
	doAction = 'Love'
	action( actor ) = { "How sweet. "; }
	validDo(actor, obj, seqno) = { return(seqno = 1); }
	validDoList(actor, prep, iobj) = (nil)
;

lowerVerb: deepverb
	verb = 'lower'
	sdesc = "lower"
	doAction = 'Lower'
;

makeVerb: deepverb
	verb = 'make' 'create' 'imagine' 'ideate' 'conjure'
	sdesc = "make"
	doAction = 'Make'
	validDo(actor, obj, seqno) = { return(seqno = 1); }
	validDoList(actor, prep, iobj) = (nil)
;

class yesNoMaybeVerb: deepverb
	action( actor ) = 
	{
		if ( FFLaura.speechDaemonCount != 0 )
			return;
		else if ( youngMan.justAskedYesOrNoQuestion )
			youngMan.yesOrNoAnswer( self );
		else if ( actor.query )
		{
			"I meant that rhetorically. ";
			actor.query := nil;
		}
		else self.response;
	}
;

maybeVerb: yesNoMaybeVerb
	verb = 'maybe' 'perhaps' 'possibly' 'dunno' 'shrug'
	sdesc = "maybe"
	response = "You need to be more decisive. "
;

noVerb: yesNoMaybeVerb
	verb = 'no' 'nope' 'nah' 'nyet' 'nein' 'non'
	sdesc = "no"
	repsonse = "You sound rather negative. "
;

noteVerb: sysverb
	verb = 'note'
	sdesc = "note"
	doAction = 'Note'
; 

notifyVerb: sysverb
	verb = 'notify'
	sdesc = "notify"
	doNotify( actor ) = 
	{
		if( global.notifie )
		{
			"[ Score notification is now OFF. ] ";
			global.notifie := nil;
		}
		else 
		{
			"[ Score notification is now ON. ] ";
			global.notifie := true;
		}
	}
	action( actor ) =
	{
		self.doNotify( actor );
		abort;
	}
;

offVerb: deepverb
	sdesc = "off"
	verb = 'off'
	action( actor ) = 
	{
		if ( Me.location = platform || Me.location = platform2 || Me.location = rock )
		{
			Me.location.doUnboard( Me );
		}
		else
			"You aren't on anything at the moment. ";
	}
;

payVerb: deepverb
	sdesc = "pay"
	verb = 'pay'
	doAction = 'Pay'
;

playVerb: deepverb
	verb = 'play'
	sdesc = "play"
	action( actor ) = { "Whee! "; }
	doAction = 'Play'
	ioAction( withPrep ) = 'Play_With'
;

playWithVerb: deepverb
	verb = 'play with'
	sdesc = "play with"
	doAction = 'PlayWith'
;	

ploverVerb: deepverb
	verb = 'plover' 'plugh' 'gnusto' 'frotz' 'rezrov' 'blorb' 'floo' 'nitfol'
	sdesc = "do"
	doAction = 'Plover'
	action( actor ) =
	{
		"Nothing happens. ";
	}
;

pointVerb: deepverb
	allowall = true
	verb = 'point' 'point at' 'aim'
	sdesc = "point"
	doAction = 'Point'
	ioAction( atPrep ) = 'PointAt'
	ioAction( withPrep ) = 'Point_atWith'
;

pourVerb: deepverb
	sdesc = "pour"
	verb = 'pour'
	doAction = 'Pour'
	ioAction( inPrep ) = 'PourIn'
	ioAction( onPrep ) = 'PourIn'
	prepDefault = onPrep
;

prayVerb: deepverb
	sdesc = "pray"
	verb = 'pray' 'pray for'
	action( actor ) = 
	{
		if ( isclass( Me.location, FtreeRoom ) )
			rescue.doPrayFor( actor );
		else
		{
			"You bow your head for a few moments of solemn prayer. ";
		}
	}
	doAction = 'PrayFor'
;

pryVerb: deepverb
	verb = 'pry' 'prise' 'prize' 'jimmy' 'jimmi' 'lever' 'force'
	sdesc = "pry"
	ioAction( withPrep ) = 'PryWith'
	prepDefault = withPrep
	ioDefault( actor, prep ) =
	{
		if ( crowbar.deepIsIn( Me ) || crowbar.deepIsIn( Me.location ) ) 
			return( [ crowbar ] );
		return actor.contents + actor.location.contents;
	}
;

relaxVerb: deepverb
	sdesc = "relax"
	verb = 'relax' 'ease up' 'ease off' 'ease offof' 'ease upon'
	doAction = 'Relax'
	action( actor ) = 
	{
		if ( Me.location = hangingForDearLife )
			brokenTrunk.doRelax( actor );
		else
			"You take a long breath and relax. ";
	}
;

rollVerb: deepverb
	sdesc = "roll"
	verb = 'roll' 'roll over'
	action( actor ) =
	{
		askdo;
	}
	doAction = 'Roll'
;

rubVerb: deepverb
	verb = 'rub' 'polish' 'shine' 'massage'
	sdesc = "rub"
	action( actor ) = 
	{
		"Aye, there's the rub. What did you want to rub?";
	}
	doAction = 'Rub'
;

scratchVerb: deepverb
	verb = 'scratch'
	sdesc = "scratch"
	doAction = 'Scratch'
;

sellVerb: deepverb
	verb = 'sell'
	sdesc = "sell"
	doAction = 'Sell'
	prepDefault = toPrep
	ioAction( toPrep ) = 'SellTo'
	doDefault(actor, prep, io) =
	{
		return( actor.contents );
	}
;

shimmyVerb: deepverb
	verb = 'shimmy'
	sdesc = "shimmy"
	action( actor ) = 
	{
		if ( actor.location.isTreeRoom )
			actor.travelTo( actor.location.north );
		else
			"You shimmy. ";
	}
;

singVerb: deepverb
	sdesc = "sing"
	verb = 'sing' 'hum'
	doAction = 'Sing'
	action( actor ) = 
	{
		"You don't have much ability for that, but you feel plucky and
		warble out a few bars of one of your favorite tunes. ";
		
		if ( Fred.location = Me.location )
			"\bFred tries not to wince and says, \"Not bad, but don't give 
			up the day job.\" ";
		else if ( FFred.location = Me.location )
			"\b\^<<FFred.thedesc>> looks at you and says, \"You've got a
			voice like I've got a life.\" ";
		else if ( Laura.location = Me.location )
			"\bLaura smiles and says, \"That was nice, but I think the
			other people who are trying to work would like for you to
			keep it down.\" ";
		else if ( FLaura.location = Me.location )
			"\bLaura glares at you and says, \"I can see that trying to
			talk to you sensibly is a losing proposition.\" ";
		else if ( FFLaura.location = Me.location )
			"\bLaura gives you an icy stare. ";
		else if ( Architect.location = Me.location )
			"\bThe architect says, \"Do you mind doing that somewhere else? I am 
			trying to work here.\" ";
		else if ( workers.location = Me.location )
			"The workers laugh and hoot. Somewhere, a dog howls. ";
		else if ( antiqueMerchant.location = Me.location )
			"\bThe merchant gives you a sideways look and says, \"Ahem. This
			is a respectable establishment. Kindly stifle your muse, willful
			though it might be.\" ";
		else if ( squirrel.location = Me.location )
			"The squirrel regards your performance quizzically. ";
		else
			"Hopefully, no one was listening. ";
	}
	validDo(actor, obj, seqno) = { return(seqno = 1); }
	validDoList(actor, prep, iobj) = ( melody )
;

smileVerb: deepverb
	verb = 'smile' 'smile at' 'smirk' 'smirk at'
	sdesc = "smile at"
	action( actor ) = 
	{
		"You smile. ";
		if ( rand( 4 ) = 4 )
			"Funny, it makes you feel a bit better. "; 
	}
	doAction = 'Smile'
;

smellVerb: deepverb
	verb = 'smell' 'sniff'
	sdesc = "smell"
	doAction = 'Smell'
	action( actor ) =
	{
		air.smellDesc;
	}
;

sprayVerb: deepverb
	verb = 'spray'
	sdesc = "spray"
	ioAction( withPrep ) = 'SprayWith'
	ioAction( onPrep ) = 'SprayOn'
	prepDefault = withPrep
;

startVerb: deepverb
	verb = 'start'
	sdesc = "start"
	ioAction( withPrep )= 'StartWith'
	prepDefault = withPrep
	action( actor ) = 
	{
		restartVerb.action( actor );
	}
;

strongVerb: deepverb
	verb = 'fuck' 'damn' 'dammit' 'damnit' 'fucker' 'fuckit'
	sdesc = "curse"
	action( actor ) = 
	{
		"I don't know that word. At least, that's my story and I'm
		sticking to it. ";
	}
;

swimInVerb: deepverb
	sdesc = "swim in"
	verb = 'swim' 'swim in'
	doAction = 'SwimIn'
;

swingVerb: deepverb
	verb = 'swing' 'swing on'
	sdesc = "swing on"
	doAction = 'Swing'
	action( actor ) = 
	{
		"Wheeeee! ";
	}
;

talkToVerb: deepverb
	verb = 'talk' 'talk to' 'speak' 'speak to' 'beg'
	sdesc = "talk to"
	action( actor ) = 
	{
		"You'll have to say whom you want to speak to. (Better yet, use
		ASK or TELL.) ";
	}
	doAction = 'TalkTo'
;

tasteVerb: deepverb
	verb = 'taste'
	sdesc = "taste"
	doAction = 'Taste'
;

thankVerb: deepverb
	verb = 'thank' 'thanks'
	sdesc = "thank"
	action( actor ) = 
	{
		"You're welcome. ";
	}
	doAction = 'Thank'
	validDo(actor, obj, seqno) = { 
		if ( isclass( obj, Topic ) )
			return( true );
		return( obj.isReachable( actor ) );
	}
;

thinkVerb: deepverb
	sdesc = "think about"
	verb= 'think' 'think about' 'think on' 'meditate' 'meditate about' 
			'meditate on' 'muse' 'muse about' 'muse on' 'ruminate' 
			'ruminate about' 'ruminate on' 'hm' 'hmm' 'hmmm' 'hmmmm'
			'hmmmmm'
	doAction = 'ThinkAbout'
	action( actor ) = 
	{
		"Hmmmmmm. ";
/*
		local topic;
		
		topic := chooseTopic( Me );
		
		if ( Me.location = rock )
		{
			"You take a deep breath, and begin to think clearly. You 
			recall the issues that are facing you at the moment: ";
			
			listIssues( global.scoreCard );
			
			"\nPerhaps you should think about one of these in particular,
			now that you've found a quiet moment and a good spot. ";
		}
		else
		{
			"This is not the most conducive spot for deep thinking. 
			However, one issue springs most readily to mind: \b";
			
			provideHint( topic );
		}
*/
	}
	validDo(actor, obj, seqno) = { return(seqno = 1); }
	validDoList(actor, prep, iobj) = (nil)
;

tickleVerb: deepverb
	sdesc = "tickle"
	verb = 'tickle'
	doAction = 'Tickle'
	ioAction( withPrep ) = 'TickleWith'
;

tieVerb: deepverb
	sdesc = "tie"
	verb = 'tie'
	prepDefault = toPrep
	ioAction( toPrep ) = 'TieTo'
;

timeVerb: deepverb
	verb = 'time'
	sdesc = "time"
	action( actor ) = { "It is "; timeOfDay( global.timeLoc ); ". ";}
	doAction = 'Time'
	validDo(actor, obj, seqno) = { return(seqno = 1); }
	validDoList(actor, prep, iobj) = ( timeTravel )
;

untieVerb: deepverb
	sdesc = "untie"
	verb = 'untie'
	doAction = 'Untie'
;

useVerb: deepverb
	sdesc = "use"
	verb = 'use'
	doAction = 'Use'
	ioAction( onPrep ) = 'UseOn'
	ioAction( withPrep ) = 'UseWith'
	ioAction( inPrep ) = 'UseIn'
;

verbsVerb: sysverb
	sdesc = "verbs"
	verb = 'verbs'
	showAllVerbs( actor ) = 
	{
		local resp;
		
		"Show all game verbs? (It is a long list.) Are you sure? \b>";
		
		resp := yorn();
		
		if ( resp = 1 )
		{
			local o, verblist;
			
			"\nListing all game verbs: \b";
			
			o := firstobj( deepverb );
			verblist := [];
			
			for (o := firstobj( deepverb ) ; o ; o := nextobj( o, deepverb ) )
				verblist += o;
			for ( o:=1; o<=length(verblist); o++ )
			{
				local p, vocab;
				vocab := getwords( verblist[o], &verb );
				"\n";
				for ( p:=1; p<=length(vocab); p++ )
				{
					say( vocab[p] ); ".\ ";
				}
			}
/*
			"\n";
			if ( defined( verblist[o], &sdesc ) )
				verblist[o].sdesc;
			else
			{
				local vocab;
				vocab := getwords( verblist[o], &verb );
				say( car( vocab ) );
			}
*/
		}
		else
			"Ok. ";
	}
	action(actor) =
	{
		self.showAllVerbs( actor );
		abort;
	}
;

waitForVerb: deepverb
	sdesc = "wait for"
	verb = 'wait for' 'wait on'
	actor( action ) = { askdo; }
	doAction = 'WaitFor'
	validDo(actor, obj, seqno) = { return(seqno = 1); }
//	validDoList(actor, prep, iobj) = ( nil )
	doDefault( actor, prep, iobj ) =
	{
		return actor.contents + actor.location.contents;
	}
;

walkVerb: deepverb
	verb = 'walk'
	doAction = 'Walk'
	action( actor ) = { "To walk in a direction, simply type the direction. "; }
;

wadeInVerb: deepverb
	sdesc = "wade in"
	verb = 'wade' 'wade in'
	doAction = 'WadeIn'
;

waylayVerb: deepverb
	verb = 'waylay'
	sdesc = "waylay"
	doAction = 'Waylay'
	action( actor ) = { "Oh, come now. "; }
;

whatIsVerb: deepverb
	verb = 'what is' 'whats' 'what\'s' 'what are'
	sdesc = "what is"
	action( actor ) = 
	{
		"You'll have to be more specific with that question. ";
	}
	doAction = 'WhatIs'
	validDo( actor, obj, seqno ) =
	{
		return( true );
	}
	validDoList = nil
;

whereIsVerb: deepverb
	verb = 'where is' 'wheres' 'where\'s' 'where are'
	sdesc = "where is"
	action( actor ) = 
	{
		"You'll have to be more specific with that question. ";
	}
	doAction = 'WhereIs'
	validDo( actor, obj, seqno ) =
	{
		return( true );
	}
	validDoList = nil
;

whoIsVerb: deepverb
	verb = 'who is' 'whos' 'who\'s' 'who are'
	sdesc = "who is"
	action( actor ) = 
	{
		"You'll have to be more specific with that question. ";
	}
	doAction = 'WhoIs'
	validDo( actor, obj, seqno ) =
	{
		return( true );
	}
	validDoList = nil
;

whoAreYouVerb: deepverb
	sdesc = "ask who are you"
	verb = 'who areyou'
	action( actor ) = 
	{
		"You'll have to direct that question to someone. ";
	}
	doAction = 'WhoAreYou'
;

whatAreYouVerb: deepverb
	sdesc = "ask what are you"
	verb = 'what areyou'
	action( actor ) = 
	{
		"I believe I'm known as \"the parser.\" ";
	}
	doAction = 'WhoAreYou'
;

whereAmIVerb: deepverb
	sdesc = "ask where am I"
	verb = 'where ami'
	action( actor ) =
	{
		actor.location.lookAround( true );
	}
	doAction = 'WhoAmI'
;

whoAmIVerb: deepverb
	sdesc = "ask who am I"
	verb = 'who ami' 'what ami'
	action( actor ) =
	{
		Me.doWhoIs( actor );
	}
	doAction = 'WhoAmI'
;

whistleVerb: deepverb
	sdesc = "whistle"
	verb = 'whistle'
	action( actor ) =
	{
		"You whistle. ";
	}
	doAction = 'Whistle'
	validDo(actor, obj, seqno) = { return(seqno = 1); }
	validDoList(actor, prep, iobj) = ( melody )
;

withdrawVerb: deepverb
	sdesc = "withdraw"
	verb = 'withdraw'
	doAction = 'Withdraw'
	ioAction( fromPrep ) = 'WithdrawFrom'
	prepDefault = fromPrep
;

wizardVerb: deepverb
	sdesc = "wizard"
	verb = 'kertimetravel'
	action( actor ) =
	{
		if ( not global.wizard )
		{
			"You invoke the magic word to turn into a rich wizard. ";
			global.wizard := true;
			megaVerb.action( actor );
			handleMoneyTrade( playerCash, 500 );
		}
		else
		{
			"You invoke the magic word to turn back into a mere player. ";
			unMegaVerb.action( actor );
			global.wizard := nil;
		}
	}
;

wowVerb: deepverb
	verb = 'wow' 'gosh' 'golly' 'gee' 'yow' 'whoa' 'yay' 'yowza' 'yowie' 
	sdesc = "wow"
	action( actor ) =
	{
		"Glad you liked it! ";
	}
;

whoopsVerb: deepverb
	verb = 'um' 'urk' 'erk' 'er' 'umm' 'yikes' 'yeek' 'eek' 'whoops' 'yargh' 'egad'
		'cripes' 'arg' 'argh' 'doh' 'd\'oh' 'gah' 'aiieee' 'aieee' 'agh'
		'eeeagh' 'eeagh' 'grr' 'gr' 'grrr' 'grrrr' 'grrrrr'
	sdesc = "whoops"
	action( actor ) =
	{
		"Whoops! I hope that was supposed to happen. ";
	}
;

xquitVerb: sysverb
	verb = 'xquit' 'quity'
	sdesc = "xquit"
	action( actor ) = 
	{
		quit();
	}
;

xyzzyVerb: deepverb
	verb = 'xyzzy'
	sdesc = "xyzzy"
	action( actor ) = 
	{
		if ( actor.islit )
			acornHole.ioPutIn( actor, acorn );
		else
			"Nothing happens. ";
	}
	doAction = 'Xyzzy'
;

yellForVerb: deepverb
	verb = 'yell for' 'shout for' 'cry for' 'scream for' 'call for'
	sdesc = "yell for"
	doAction = 'YellFor'
	validDo(actor, obj, seqno) = { return(seqno = 1); }
	validDoList(actor, prep, iobj) = ( rescue )
;

yesVerb: yesNoMaybeVerb
	verb = 'yes' 'y' 'yep' 'yeah' 'oui' 'ja' 'si' 'decide' 'deal' 'done' 'agreed'
	sdesc = "yes"
	response = "You sound rather positive. "
;

yohoVerb: deepverb
	verb = 'arr' 'arrr' 'arrrr' 'yoho' 'yo ho ho' 'ahoy' 'shiver me timbers'
	sdesc = "arr"
	doAction = 'Plover'
	action( actor ) = { "Arr! Yo ho ho! Avast! Shiver me timbers! Ahoy! "; }
;

zapToVerb: deepverb
	sdesc = "zap"
	verb = 'zap'
	prepDefault = toPrep
	ioAction( toPrep ) = 'ZapTo'
	validDo(actor, obj, seqno) = { return(seqno = 1); }
	validDoList(actor, prep, iobj) = ( nil )
	validIo(actor, obj, seqno) = { return(seqno = 1); }
	validIoList(actor, prep, dobj) = (nil)
;

modify aboutPrep
	preposition = 'for'
;

modify inPrep
	preposition = 'inside'
;

arePrep: Prep
	preposition = 'are'
	sdesc = "are"
;

youPrep: Prep
	preposition = 'you'
	sdesc = "you"
;
areyouPrep: Prep
	preposition = 'areyou'
	sdesc = "are you"
;

amiPrep: Prep
	preposition = 'ami'
	sdesc = "am I"
;

isPrep: Prep					// Preposition for "what/where/who is" verbs
	preposition = 'is'
	sdesc = "is"
;

forPrep: Prep
	preposition = 'for'
	sdesc = "for"
;

lovePrep: Prep
	preposition = 'love' 'adore' 'admire' 'like'
	sdesc = "love"
;

goPrep: Prep
	preposition = 'go'
	sdesc = "go"
;

hoPrep: Prep
	preposition = 'ho'
	sdesc = "ho"
;

acrossPrep: Prep
	preposition = 'across'
	sdesc = "across"
;

alongPrep: Prep
	preposition = 'along'
	sdesc = "along"
;

downPrep: Prep
	preposition = 'down'
	sdesc = "down"
;

backPrep: Prep
	preposition = 'back' 'backward' 'backwards' 'aft'
	sdesc = "back"
;

modify aboutPrep
	preposition = 'abotu'
;

compoundWord 'go' 'of' 'goof';
compoundWord 'are' 'you' 'areyou';
compoundWord 'am' 'i' 'ami';
compoundWord 'down' 'from' 'downfrom';

/* eof */
