BEGIN {
	count = 255
}

{
	t = $1
	token[t] = count
	count--
	if (length(t) > 1)
		print "constant TOKEN_" toupper(t) " " token[t] ";"
}

END {
	print "[ token_decode t;"
	print "switch(t) {"
	for (i in token)
		print token[i] ": return \"" i "\";"
	print "}"
	print "return 0;"
	print "];"

	print "[ token_encode p d;"
	for (i in token) 
	{
		if (length(i) > 1)
		{
			print "if ("
			for (j=1; j<=length(i); j++)
				print "(p->" (j-1) " == '" substr(i, j, 1) "') &&"
			print " token_invalidchar(p->" (j-1) ")) { d->0 =" token[i] "; return " length(i) "; }"
		}
		else
			print "if (p->0 == '" i "') { d->0 = " token[i] "; return 1; }"
	}
	print "return 0;"
	print "];"
}


