/* Murmellius Adventure II*/

#include <adv.t>
#include <murmstd.t>

class Equip: item
  value=1
  seen=nil
  doTake(a)=
  { if (not seen) {incscore(self.value);seen:=true;}
    pass doTake;}
;
class MurmRoom: room
enterRoom(a)=
{ if (not isseen) incscore(1);pass enterRoom;}
;
startroom: MurmRoom
  sdesc="Hall"
  ldesc="You are in the large central hall of the Gymnasium.  There are 
    hallways leading south and east, and doors to the north and north-east.
    Large passageways go south-east and west, and in addition there is a
    broad staircase leading up.  A large aquarium has been placed against 
    one of the walls."
  north=rectorR
  ne=clavR
  west=museum
  south=FrenchHall
  se=copyroom
  east=PhysicsHall
  up=UpHall
  exits=['n' 'ne' 'e' 'w' 's' 'se' 'u']
;
aquarium: fixeditem,qcontainer
  location=startroom
  sdesc="aquarium"
  ldesc={"It's a large, well-maintained tank. It contains ";
    listcont(self);". ";}
  noun='aquarium' 'tank' 
  adjective = 'fish'
;
fish: item
  location=aquarium
  sdesc="fish"
  thedesc="fish"
  adesc="fish"
  ldesc="The tank is full of colorful fish, and you can't help but notice
    how their facial expression matches that of the average pupil.  In
    fact, that one, there in the corner, doesn't it just look like you 
    yourself...? "
  noun='fish'
  doTake(a)={"Unexpectedly, the fish turn out to be piranhas, the pet
    animals of the Rector. They visciously bite your fingers
    and tear out small pieces of flesh. The water colors red
    as you hastily retract your hand. Nailcuts are no longer 
    necessary. ";}
;
rectorR: MurmRoom
  sdesc="Rector's Room"
  ldesc={"You are in the Rector's office - the Holy of Holies.  It's a 
    somewhat dark place.  A large desk stands in the center";
    if (chairR.location=self) ", with a large chair behind it. "; else ". ";
    "A door leads south. ";}
  south=startroom
  out=startroom
  exits=['s']
;
deskR: surface, fixeditem
  location=rectorR
  sdesc="Rector's desk"
  ldesc="It's a huge oak desk, overflowing with books and papers, all in
    utter chaos."
  noun='desk' 'table'
  adjective='huge' 'oak' 'rector\'s'
;
papers: item
  location=deskR
  sdesc="bunch of papers"
  ldesc="They are scribbled in a completely illegible handwriting that has
    the additional feature of becoming smaller and even less legible near 
    the edge of the paper.  The final words are scribbled sideways on the
    very edge. "
  noun='paper' 'papers' 
  adjective='rector\'s'
  bulk=2
  verDoBurn(a)={}
  doBurn(a)=
  { if ((lighter.location=Me and self.location=Me) or
          (Bunsen.location=Me.location and Bunsen.burning))
    {"You carefully burn the papers until there's only dusty ash left.
      Well, let's just hope the Rector doesn't find out about it... ";
      self.moveInto(nil);}
    else "There's nothing to burn them with. ";}
;
chairR: chairitem
  location=rectorR
  sdesc="Rector's chair"
  ldesc="It's a large, executive-type swivel chair, made out of expensive
    crocodile leather.  The Rector's initials are embossed on the back.
    It certainly looks like a comfortable place to sit.  There's a small
    green button on the armrest. "
  noun='chair'
  adjective='swivel' 'leather' 'rector\'s'
  doSiton(a)=
    {"As you sit down in the wide chair, you experience a hint of what it
    must be like to be a real, regal, Rector. ";
    Me.moveInto(self);}
;
ChairButton: buttonitem
  location=chairR
  sdesc="green button"
  ldesc="It's a small green button, labeled \"INSTANT RELAXATION\". "
  noun='button'
  adjective='green' 'chair'
  pushed=nil
  doPush(a)=
  { if (chairR.location=rectorR)
    { chairR.moveInto(Tower3);
      if (Me.location=chairR)
      { "Suddenly, soft music begins to sound, and, to your amazament, the 
        chair slowly rises up in the air.  At the same time a hole in the
        ceiling opens, and you find yourself moving up through it.  Surrounded
        by Mozart your strange upward journey continues for about half a minute,
        until you emerge in the Clock Room.\n\t";
        if (not Tower3.isseen) Tower3.ldesc;
        "The chair slowly rotates, to give you a good view of the 
          surroundings outside the windows, and then comes to a slow stop.
          You realize that this is how the Rector relaxes during his busy
          work.  You are in the\n";Tower3.lookAround(nil);
        if (not pushed) {incscore(1);pushed:=true;}}
      else
      { "Mozart begins to sound through the room, and you see the chair
        slowly rise, pushed up by a gigantic hydraulic system, and disappear 
        through a hole in the ceiling. ";}}
    else
    { chairR.moveInto(rectorR);
      if (Me.location=chairR)
      { "Quiet music envelops you, as you slowly descend, and find yourself
        back in the\n";rectorR.lookAround(nil);}
      else
      {"While soft string music sounds through the room, the chair slowly
        sinks out of sight. ";}}}
;  
clavR: MurmRoom
  sdesc="Claviger's office"
  ldesc="You are in the claviger's office.  It's a small place, discordant
    with the man's importance in the school.  There's a small desk and a
    chair here."
  sw=startroom
  out=startroom
  exits=['sw']
;
keys:keyItem, Equip
  location=deskC
  sdesc="keyring"
  ldesc="It's a keyring with a single, large key on it, undoubtedly giving
    access to some room in the school where pupils should not go."
  noun='key' 'keys' 'keyring' 'ring'
  adjective='key'
  bulk=2
;
deskC:surface,fixeditem
  location=clavR
  sdesc="desk"
  ldesc="It's a very ordinary desk."
  noun='desk' 'table'
  adjective='claviger\'s'
;
chair:chairitem
  location=clavR
  sdesc="chair"
  ldesc="It's simple, and looks a tad unconfortable."
  noun='chair'
  adjective='claviger\'s'
;
museum: MurmRoom
  sdesc="Museum"
  ldesc="You are in an area that looks like a tiny museum.  At least, a few
    dusty glass cabinets with objects give that impression.  On the other
    hand, the space also features several tables, sticky with old coffee,
    on which are some incomplete chess sets.  A coffee machine is attached
    to the wall.  Looking east, you see the main hall.  High above you there
    seems to be a balcony."
  east=startroom
  out=startroom
  up=
    {"It's way too high to jump.  You'll have to look for another way to
    get there.";
    return(nil);}
  exits=['e']
;
cabinets: decoration
  location=museum
  sdesc="glass cabinets"
  ldesc="The glass is very dusty, but inside you make out some stones,
    a few things that might be arrow points, and a few old wooden models
    of Roman equipment.  Nothing, in short, that could interest you, and
    from the dust it seems clear that it doesn't seem to interest the pupils
    either."
  noun='cabinets' 'cabinet'
  adjective='glass'
;
tablesM: decoration
  location=museum
  sdesc="tables"
  adesc="tables"
  ldesc="They are old and wobbly, and generally covered with a sticky
    layer of old, dried-up coffee."
  noun='table' 'tables'
; 
chessSet: decoration
  location=museum
  sdesc="incomplete chess sets"
  ldesc="They are old, some of the pieces are broken, and the sets are
    clearly incomplete.  Pretty useless."
  noun='chess set' 'set' 'chess'
  adjective='chess' 'incomplete'
  verDoTake(a)="It's no use taking incomplete chess sets..."
;
coffeemachine: fixeditem, qcontainer
  location=museum
  sdesc="coffee machine"
  ldesc={"It's a modern Buurmatic coffee machine. It features a large
    picture of the Buurman, saying: \"Only the finest ingredients go into
    Buurmatic Coffee - and that's my personal guarantee!  Haha!\".  There's 
    a slot on it to insert money, and a sign reads \"f 1 coins only.  
    Other coins or paper money will not be returned.  No change given.
    The Buurman, Inc. will not be responsible for any injuries or illnesses
    resulting from the use of our products.\"  There\'s a small compartment
    where a cup can be placed, but you note a red light above the sentence:
    \"cup supply empty\".";
    if (cup.location=coffeemachine)
      {"  Nonetheless, there is a cup in the compartment.  It\'s ";
        if (cup.full) "full of coffee."; else "empty.";}}
  noun='coffee machine' 'machine'
  adjective='coffee'
  ioPutIn(a,d)=
    {if (isclass(d,Coin))
      {randPut(d);
      if (cup.location=coffeemachine)
        {if (cup.full)
          "Coffee spills over the already full cup, and drains away.";
          else
          {"There are grinding noises, and the cup fills with black fluid,
            apparently coffee.";
            cup.full:=true;coffee.moveInto(cup);}}
      else {"Black liquid spills into the empty compartment and      
        drains away.";}}
    else if (d=cup)
      {"You place the cup in the compartment.";
         cup.moveInto(coffeemachine);}
    else {"It won\'t fit.";}}
;
cup: container
  location=coffeemachine
  full=nil
  type=nil
  sdesc="coffee cup"
  ldesc={"It's a cheap plastic coffee cup, of the type that tends to burn
    your hands when filled with hot coffee. ";
    if (full) "Unfortunately, the coffee that's in it now is of
      room temperature. "; else "It's empty.";}
  noun='cup' 
  adjective='coffee'
  bulk=2
  ioPutIn(a,b)=
  { if (b.bulk>1) {"Sorry, it doesn't fit... ";} else
    if (self.full)
    { "Hissing and bubbling noises are emitted from the point of contact 
        between ";b.thedesc;" and the black liquid. To your horror you observe
        that ";b.thedesc;" completely dissolves. "; 
      b.moveInto(nil);}
    else pass ioPutIn;}
  verDoEmpty(a)={if (not full) "It's already empty! ";}
  doEmpty(a)={"You pour the coffee on the floor, where it seeps away
    between the stones. ";full:=nil;}
  verDoFill(a)=
  { if (full) "It's already full! ";}
  doFill(a)=
  { if (Me.location=ChemPrac or Me.location=BioLab or Me.location=Crafts)
    { "As the liquid flows from the dispenser into the cup, the thin
      plastic dissolves completely. ";cup.moveInto(nil);}
    else "There's nothing here to fill it with! ";}
;
coffee: fooditem,fixeditem
  sdesc="coffee"
  ldesc="This cold, viscous fluid with a sheen of oil on top is not quite what 
    you hoped for, but admittedly, it's black, and might even be sweet."
  noun='coffee'
  doTake(a)="You can't take it out of the cup."
  verDoDrink(a)={}
  doDrink(a)=
    {"After some hesitation, you gulp down the black liquid. It doesn't 
      taste any better than it looked, but at least it will supply you
      with some energy for a while.";
      cup.full:=nil;self.moveInto(nil);
      global.lastMealTime:=global.lastMealTime-100;}
  verIoPutIn(a)={}
  ioPutIn(a,b)={cup.ioPutIn(a,b);}
;  
class Coin:item,Equip
  ldesc=
  { "It's a regular coin, worth f1, and featuring a picture 
    of the Buurman and the sentence \'E Buribus Unum\'. ";}
  noun='coin'
;
coin1:Coin
  sdesc="shiny coin"
  location=deskC
  adjective='shiny'
;
coin2: Coin
  sdesc="old coin"
  location=Crafts
  adjective='old'
;
coin3: Coin
  sdesc="worn coin"
  location=Drawing
  adjective='worn'
;
copyroom:MurmRoom
 sdesc="Copy Room"
 ldesc="This is the copy room. A small stuffy, hot room, littered with
        paper. A noisy copy machine spits out paper, while red emergency
        lights are flashing. You notice the accumulation of physics
        handouts into a tray, which is more than full, and the 
        consequential spill-out over the floor. A dark grey metal 
        door is on the west wall, covered with outdated information on
        school activities. The exit to the hall is to the northwest. "
 west=stookholdeur                                                          
 nw=startroom
 exits=['nw']
; 
copymachine: decoration
  location=copyroom
  sdesc="copy machine"
  ldesc="It's a large copier, and it seems to be rather overheated.  Wisps
    of smoke emerge from the inside.  Maybe the fact that the copy number
    has been set to 2000 has something to do with this. "
  noun='copier' 'machine'
  adjective='copy'
;
copies: decoration
  location=copyroom
  sdesc="physics handout"
  ldesc="It's a messy pile of paper.  Apparently, the copier has run out
    of ink a while ago, and whatever comes out now is blank... "
  noun='paper, handout' 'handouts'
  adjective='physics'
;
stookholdeur:lockableDoorway
 location=copyroom
 sdesc="metal door"
 ldesc="This door is obviously closed most of the time. Cheaply copied
        announcements of volleyball games, and of a performance of the
        Kakophonia from Rigor Mortis by the Music Teacher are pasted on 
        to it.  It looks like someone has tried to open the lock with a
        screwdriver, for it appears rather damaged.  In fact, it's
        doubtful whether it would still open with a key.  Then you notice,
        above the door, a sign reading \"Lasciate ogni speranza, voi 
        ch'entrate!\". Involuntarily you shudder as you read it..."
 doordest=stookhol
 noun='door'
 adjective='metal'
 mykey=Throne /* just a dummy item that he can never have around*/
 otherside=copyroomdeur
;
stookhol:MurmRoom
 sdesc="Furnace Room"
 ldesc="A red hot furnace glows in a pitch dark cave. Spider webs hang
        down and soon cover your hair. The heat is intense, and your
        sensation of fear is enhanced by the echoing roar of the
        flames inside the closed metal furnace. In the corner, faintly
        illuminated by the dancing waves, rests an old skeleton. There's 
        a door to the east. "
 east=copyroomdeur
 out=copyroomdeur
;
furnace: decoration
  location=stookhol
  sdesc="furnace"
  ldesc="It's a large, heavy furnace.  You attempt vainly to open its
    huge cast-iron door, but its's too hot and heavy for mortals to 
    handle."
  noun='furnace'
;
webs: decoration
  location=stookhol
  sdesc="web"
  noun='web' 'webs' 
  adjective='spider'
;
skeleton: decoration
  location=stookhol
  sdesc="skeleton"
  ldesc="It's old and dusty.  You wonder what happened to this poor guy.
    Maybe he was a teacher once, and got trapped in this infernal place... "
  noun='skeleton'
;
copyroomdeur: lockableDoorway
  location=stookhol
  sdesc="metal door"
  ldesc="It's a heavy metal door, covered over the years with a thick layer
    of black soot. "
  doordest=copyroom
  noun='door'
  adjective='metal'
  otherside=stookholdeur
  mykey=keys
  opened=nil
  doUnlock(a)={if (not opened) {incscore(3);opened:=true;} pass doUnlock;};
;
Distiller: Equip
  location=stookhol
  sdesc="glass distiller"
  ldesc="It's one of those spiral glass tubes contained in a glass container.
    The idea is that the container is flushed with cold water to cool the 
    spiral, resulting in condensation of the vaporized fluid passing 
    through the spiral tube.  It looks rather fragile. "
  noun='distiller' 'spiral'
  adjective='glass' 'fragile'
  bulk=3
  verDoTake(a)=
  { if (Chemistry.hot and not Glove.isworn) 
      "You would only burn your hands if you tried to take the distiller. ";
    else pass verDoTake;}
  verDoTouch(a)=self.verDoTake(a);
;
PhysicsHall: MurmRoom
  sdesc="Physics Hallway"
  ldesc="You are in the physics hallway.  To the west, it
    opens on a large hall.  There is a door to the north, and a dark exit
    leads east. "
  north=Physics
  west=startroom
  east=SmokeHall
  exits=['n' 'w' 'e']
;
Physics: MurmRoom
  intact=true
  sdesc="Physics Classroom"
  ldesc=
  { if (intact)
    "You are in the physics classroom.  It's dominated by an enormous
    van der Waals machine.  A door leads south. ";
    else "You are in what used to be the physics classroom.  In
    the center you see wreckage of what must have been a huge machine.  The
    scarred remains still smoke a little.  Fragments litter the floor, and
    the walls and ceiling are black with smoke and badly damaged.  A
    doorway, the door blown out, leads south. ";}
  out=PhysicsHall
  south=PhysicsHall
  exits=['s']
;
Waals: fixeditem
  location=Physics
  sdesc="van der Waals machine"
  ldesc="It's an enormous machine, more then 10 feet high, topped by a
    shiny metal ball several feet in diameter.  There's a big red button on
    the base, with a little sign next to it. "
  noun='machine'
  adjective='van der Waals' 'Waals'
;
WaalsSign: readable, fixeditem
  location=Physics
  sdesc="sign"
  ldesc="It reads: \n\tTHE BUURMAN MEMORIAL VAN DER WAALS MACHINE\n\tTo activate,
    press button.  WARNING: Do not depress for more than 10 seconds.  
    Overcharging of machine will result in irreparable damage, and 
    replacement costs will be deducted from your paycheck.  Also, personal
    injury may result. "
   noun='sign'
;
WaalsButton: buttonitem
  location=Waals
  sdesc="button"
  noun='button'
  adjective='big' 'red'
  doPush(a)=
  { "You press the button, and immediately the huge machine comes to life.
    Several colored lamps glow up on the side, and a large electric motor
    begins to drive a belt from the base to the metal ball.  A high-pitched
    whine screams through the room, the pitch increasing as the speed of
    the motor picks up. You can almost visualize the electrons moving up, 
    charging the ball at the top.\n\tUnfortunately, when you release the 
    button after a few seconds, you notice that it remains stuck in its 
    seat. You try to dislodge it, but to no avail. ";
    setfuse(WaalsFuse,2,nil);}
;
WaalsFuse: function(d)
{ if (Me.location=Physics)
  { "The screaming pitch of the machine rises higher and higher, until it
    hurts your ears.  Then, with a thunderous explosion, the massive 
    structure bursts apart.  You feel yourself torn back by the 
    enormous force, hurled through the room like a leaf in the wind.  The
    last thing you know is the sickening feeling of being crashed into 
    something hard, then you pass out ...\b* * *\b\tWhen you recover your 
    senses, you find yourself against a wall, blackened and hurting.  You
    note that the van der Waals machine has completely disintegrated, but
    that some items that some idiot, undoubtedly a pupil, had put inside it,
    can now be seen. ";incscore(-1);}
  else "A thunderous explosion vibrates through the hall.  The door of the
    physics classroom is blown out of its hinges with enormous force, and
    smoke bellows out of the remains of the doorway... ";
  Physics.intact:=nil;Physics.isseen:=nil;Tripod.moveInto(Physics);
  String.moveInto(Physics);Waals.moveInto(nil);WaalsSign.moveInto(nil);
  WaalsButton.moveInto(nil);incscore(4);}
;  
Tripod: Equip
  location=nil
  sdesc="tripod"
  ldesc="It's an old metal tripod.  For unclear reasons a long string, 
    now ripped off and reduced to scarred black thread, was tied to the 
    ring. "
  noun='tripod' 'ring'
  adjective='metal' 'old'
  bulk=2
  value=5
  verDoTake(a)=
  { if (Chemistry.hot) "It's very, very hot! ";
    else pass verDoTake;}
  verDoTouch(a)=self.verDoTake(a)
;
String: item
  location=nil
  sdesc="string"
  ldesc="It's badly burned by the explosion, and virtually disintegrates
    in your hands.  I doubt that you could use it for anything.  From
    the place you found it, you cleverly deduce that it had been stuck
    in the button on the van der Waals machine, preventing the button from 
    popping back. Sure looks like someone played a little joke on you here, 
    doesn't it? "
  noun='string'
  adjective='thin' 'burned'
;
UpHall: MurmRoom
  sdesc="Upper Hall"
  ldesc="You are in the upper hall.  There are doors to the north and 
    northeast, and a stairwell leading up.  To the west is a little 
    balustrade, from where you look down on a few tables below.  At the other 
    side of the hall a broad stairwell sweeps down.  Hallways lead south 
    and east. "
  west=
  { "You climb over the balustrade and jump down.  It's a deep jump, but
    you manage to land on your feet.\n";return(museum);}
  east=ChemHall
  south=LatinHall
  down=startroom
  north=Teachers
  ne=Tower1
  up=CraftHall
  exits=['e' 'd' 's' 'u' 'n' 'ne']
;
balustrade: decoration
  location=UpHall
  sdesc="balustrade"
  ldesc=
  { "It's a simple metal balustrade.  Beyond it you look down on a 
    floor with some cabinets and tables. ";
    if (Piet.location=museum) "You see Piet down there. ";
    if (Dirk.location=museum) "You see Dirk down there. ";
    if (Rector.location=museum) "You see the Rector down there. ";}
  noun='balustrade'
  adjective='little'
;
Utables: decoration
  location=UpHall
  sdesc="tables below"
  adesc="tables below"
  ldesc="They're kind of hard to see from here. "
  noun='table' 'tables'
;
Ucabinets: decoration
  location=UpHall
  sdesc="cabinets below"
  adesc="cabinets below"
  ldesc="You'd better go down to look at them. "
  noun='cabinet' 'cabinets'
;
Teachers: MurmRoom
  sdesc="Teachers' Room"
  ldesc="You are in the teachers' room, a rather bare place.  There is a 
    large table in the center, surrounded by chairs.  At the head of the 
    table stands an enormous throne. A door leads south. "
  south=UpHall
  out=UpHall
  exits=['s']
;
Throne: chairitem
  location=Teachers
  sdesc="throne"
  ldesc="It's an enormous throne. It rises high above the table, and steps 
    lead up to its lofty seat. As you look at it, you are delighted by its
    artistic design and crafty execution.  You note with rapturous delight 
    the gilded, twisted pillars bearing the roof, and the embroidered silk 
    cushions covering the seat. But then you see a small sign on the base:
    \"Rector only.  And I mean it!\" "
  noun='throne'
  adjective='enormous'
  doSiton(a)=
  { "With awe, you go up the steps, and carefully sit down on the soft
    cushion.  Below you, you see the table and surrounding chairs, and it
    is only too easy to imagine how the Rector directs the faculty meetings
    from this lofty viewpoint.\n\tHowever, at that moment the pressure 
    sensor in the seat determines that you do not have the correct weight of
    a true Rector.  Before you can jump off, the seat folds away, and you
    disappear in the base of the throne.  In the dark, you feel how you
    glide down, with ever increasing speed, through a narrow tube.  In vain,
    you try to get a grip on the metal walls, as your body rounds the
    curves in the tube.  Finally, you pop out of the end, and land with
    a thump on the floor. Somewhat shaken, you look around, and find
    yourself in the...\n";Me.travelTo(stookhol);
    incscore(2);if (keys.location<>Me) setfuse(stookFuse,10,nil);}
;
stookFuse: function(d)
{ "Sure looks like you got yourself in trouble, doesn't it?  Next time you
  try this, better find something to open that door with...  For now, the
  unfortunate results of your explorations is death from lack of water...\n";
  die();}
;
TeachTable: decoration
  location=Teachers
  sdesc="long table"
  ldesc="It's a low, rather wobbly-looking table. "
  noun='table'
  adjective='large' 'long'
;
TeachChairs: chairitem
  location=Teachers
  sdesc="chairs"
  adesc="chairs"
  ldesc="Just regular chairs, that's all. "
  noun='chair' 'chairs'
;
CraftHall: MurmRoom
  sdesc="Crafts Hallway"
  ldesc="You are in the crafts hallway.  Stairs lead down, and there are
    doors to the north and east. "
  down=UpHall
  north=Conr1
  east=Crafts
  exits=['d' 'n' 'e']
;
Conr1: MurmRoom
  sdesc="First Conrector's Office"
  ldesc="You are in the office of the first conrector.  It's a very organized
    place. Doors lead south and west. "
  south=CraftHall
  west=MessyAttic
  exits=['s' 'w']
;
MessyAttic: darkroom, MurmRoom
  sdesc="Messy Attic"
  ldesc="You are in a very messy attic.  There is all kind of junk spread
    out all over the place.  There are doors to the north and east and a 
    dark opening leads south. "
  east=Conr1
  south=DrawAttic
  north=Tower2
  exits=['e' 's' 'n']
;
junk: decoration
  location=MessyAttic
  sdesc="junk"
  ldesc="It's bits and pieces of everything: old, broken chemistry equipment,
    remains of books, partially eaten by the rats that undoubtedly live
    here, devotional pictures of the Buurman, etc. etc.  Really nothing
    that's of importance. "
  noun='junk'
;
Flask: Equip,container
  location=MessyAttic
  full=nil
  type=nil
  sdesc="distillation flask"
  ldesc=
  { "It's a regular, one-liter, clear glass chemistry flask. ";
    if (full) "It contains liquid. "; else "It's empty. ";}
  noun='flask'
  adjective='distillation'
  bulk=3
  value=5
  verDoFill(a)=
  { if (full) "It's already full! ";}
  doFill(a)=
  { local D;
    if (Me.location=ChemPrac) D:=Disp1;
    else if (Me.location=BioLab) D:=Disp2;
    else if (Me.location=Crafts) D:=Disp3;
    else D:=nil;
    if (D=nil) "There's nothing here you can fill it with. ";
    else
    { "You fill the flask with liquid from the dispensing bottle. ";
      full:=true;type:=D.type;}}
  verDoEmpty(a)=
  { if (not full) "There's nothing in it! ";}
  doEmpty(a)=
  { "You pour the contents of the flask on the ground, where they
    bubble and evaporate into steam. ";full:=nil;}
  verDoTake(a)=
  { if (Chemistry.hot) "It's very, very hot! ";
    else pass verDoTake;}
  verDoTouch(a)=self.verDoTake(a)
;
fillVerb: deepverb
  verb='fill'
  sdesc="fill"
  doAction='Fill'
;
emptyVerb: deepverb
  verb='empty' 'pour'
  sdesc="empty"
  ioAction(inPrep)='EmptyIn'
  doAction='Empty'
;
DrawAttic: darkroom, MurmRoom
  sdesc="Drawing Attic"
  ldesc="You are in an attic full of drawing utensils.  There is a dark exit
    to the north and a door to the south. "
  north=MessyAttic
  south=Drawing
  exits=['n' 's']
;
utensils: decoration
  location=DrawAttic
  sdesc="art utensils"
  adesc="art utensils"
  ldesc="It's a variety of old art equipment.  You see lots of old brushes,
    dried-out paint, half-finished paintings and sketches, several poorly
    executed nude studies of the Buurman.  Lots of stuff, but nothing
    that's any good. "
  noun='utensil' 'utensils' 'equipment'
  adjective='drawing' 'art'
;
Drawing: MurmRoom
  sdesc="Drawing Classroom"
  ldesc="You are in the drawing classroom, a large room splattered with
    paint.  It seems like people have been throwing paint around in this
    place. On the wall is written in large, messy letters: \"The Rector 
    is Crazy\".  There are doors to the north and south. "
  north=DrawAttic
  south=DrawHall
  exits=['n' 's']
;
DrawHall: MurmRoom
  sdesc="Drawing Hallway"
  ldesc="You are in the drawing hallway.  There are doors to the north, east
  and south, and stairs lead down. "
  north=Drawing
  south=TheaterAttic
  east=Conr2
  down=MathHall
  exits=['n' 'e' 's' 'd']
;
Conr2: MurmRoom
  sdesc="Second Conrector's Office"
  ldesc="You are in the office of the second conrector.  It's a very small
    office, featuring a personal computer.  A door leads west. "
  west=DrawHall
  out=DrawHall
  exits=['w']
;
computer: fixeditem
  location=Conr2
  sdesc="computer"
  ldesc="It's a personal computer, and it appears obsolete. On the screen
    you see a rather coarse rendition of PacMan. "
  noun='computer' 'keyboard'
  adjective='personal'
  verIoTypeOn(a)={}
  ioTypeOn(a,d)=  
  { "You play around with it a little while, but come to the conclusion
    that it only features a few rather boring games.  Disappointing, but
    that's how it is. ";}
;
pacman: decoration
  location=Conr2
  sdesc="PacMan"
  adesc="PacMan"
  thedesc="PacMan"
  ldesc="PacMan is a rather old video arcade game.  It doesn't have
    anything to do with your chemistry experiment... "
  noun='pacman' 'game'
;
TheaterAttic: darkroom,MurmRoom
  sdesc="Theater Attic"
  ldesc="You are on an attic full with old theater clothes.  There's an
    exit north. "
  north=DrawHall
  out=DrawHall
  exits=['n']
;
clothes: decoration
  location=TheaterAttic
  sdesc="clothes"
  adesc="clothes"
  ldesc="There are all kinds of clothes here, from Roman legionair's outfits
    to futuristic space suits.  You are sorely tempted to try some of them
    on, but the realization that you need to finish your experiment, and
    even more that you would look rather ridiculous wearing them, makes you
    change your mind. "
  noun='clothes'
  adjective='theater' 'old'
;
Bottle: Equip,container
  location=TheaterAttic
  cooled=nil
  sdesc="green bottle"
  ldesc={"It's a large green bottle, that would serve perfectly for
    collecting, say, distilled chemicals. ";
    if (full) "In fact, it's full of distilled liquid. ";}
  noun='bottle' 'archimandrite' 'naax'
  adjective='green' 'large' 'collection' 'sodium'
  bulk=3
  value=5
  verDoFill(a)={"The bottle has a small, special opening to connect to the
    distiller, and you are unable to fill it. ";}
  verDoEmptyIn(a,o)={if (not full) "The bottle is already empty! ";}
  verDoEmpty(a)={if (not full) "The bottle already empty! ";}
  doEmpty(a)={"You empty the contents of the bottle on the floor.  Noxious
    green vapor spreads through the room, but dissipates quickly. ";
    full:=nil;}
  verDoTake(a)=
  { if (Chemistry.hot and not Glove.isworn) 
      "You burn your hand when you try to touch the bottle... ";
    else pass verDoTake;}
  verDoTouch(a)=self.verDoTake(a)
  verDoPutIn(a,i)=
  { if (Chemistry.hot and i=FumeHood and not cooled) 
    { incscore(5);cooled:=true;}}
;
Crafts: MurmRoom
  sdesc="Crafts Classroom"
  ldesc="You are in the crafts classroom.  It's a big room, filled with all
    kinds of crafts equipment.  In the center stands a large statue.  The 
    floor is covered with wood fragments. In the corner stands a large 
    liquid dispenser.  There are doors to the east and west. "
  east=HistHall
  west=CraftHall
  exits=['e' 'w']
;
Disp3: fixeditem
  location=Crafts
  sdesc="dispenser"
  ldesc="It's a huge glass flask, filled with clear liquid.  There's a 
    small faucet on the side that can be used to fill other containers. 
    A few remnants of glue indicate that there used to be a label on it,
    but some pupil must have ripped it off.  Very funny. "
  noun='dispenser'
  type=1
  verDoTake(a)={"It's way too heavy to lift. ";}
;
Faucet3: fixeditem
  location=Crafts
  sdesc="faucet"
  noun='faucet'
  adjective='small'
  verDoOpen(a)={"If you open the faucet, fluid will pour on the floor, and
    the Rector would not appreciate that.  If you want to fill a container
    with the liquid, just do so. ";}
;
equipment: decoration
  location=Crafts
  sdesc="equipment"
  noun='equipment'
  adjective='crafts'
;
wood: decoration
  location=Crafts
  sdesc="fragments"
  noun='fragment' 'fragments'
  adjective='wood'
;
statue: decoration
  location=Crafts
  sdesc="statue"
  ldesc="It's a large wood carving of the Buurman.  It rises almost to the
    ceiling, and you note the amazing likeness of his sardonic grin.  The 
    pupils must have worked hard for many weeks to produce this piece of
    artwork. "
  noun='statue'
  adjective='large'
;
HistHall: MurmRoom
  sdesc="History Hallway"
  ldesc="You are in the history hallway.  There are doors to the west and
    south, and a stairwell leads down. "
  west=Crafts
  south=History
  down=BalconyHall
  exits=['w' 's' 'd']
;
History: MurmRoom
  sdesc="History Classroom"
  ldesc="You are in the history classroom.  Your attention is drawn by
    a peculiar decoration on the wall.  There's an exit to the north. "
  north=HistHall
  out=HistHall
  exits=['n']
;
timeline: decoration
  location=History
  sdesc="time line"
  ldesc="When you look closely, you see to your amazement that someone has 
    drawn a complete time line on the wall, starting in prehistoric times,
    and ending after the second world war.  Detailed information on events,
    personalities, inventions, art, and ancestors of the Buurman is given
    for each year.  This large map of history covers all walls, and is, 
    of course, written in a meticulous, tiny handwriting. "
  noun='decoration' 'wall' 'line' 'timeline'
  adjective='time' 'peculiar'
;
ChemBook: readable
  location=History
  sdesc="chemistry book"
  ldesc="It's a chemistry book, or, to be more precise, book IV a 2 b (c)
    of 'Chemistry for VWO'.  With little interest you leaf through it, and
    when you hit on a paragraph about pH (\"...pH, the negative logarithm of
    hydrogen ion concentration, is a measure of acidity.  Neutral water
    has a pH of 7, acids (such as hydrochloric acid) have a pH less than
    7, and bases (such as sodium hydroxide) have a pH above 7...\") you
    give up in disgust. "
  noun='book'
  adjective='chemistry'
  doBurn(a)=
  { if ((lighter.location=Me and self.location=Me) or
          (Bunsen.location=Me.location and Bunsen.burning))
    {"You carefully burn the book until there's only dusty ash left. ";
      self.moveInto(nil);}
    else "There's nothing to burn it with. ";}
;
SmokeHall: darkroom,MurmRoom
  sdesc="Smoke Hallway"
  ldesc="You are in a very smokey hallway.  This is the place where students
    who wish to smoke are supposed to go.  As a result, it's so dark you
    can't see without a light.  Stairs lead up, there is a hallway to the
    west, and doors lead east and north. "
  up=BalconyHall
  west=PhysicsHall
  east=Aula
  north=Coffee
  exits=['u' 'w' 'e' 'n']
;
Coffee: MurmRoom
  sdesc="Coffee Room"
  ldesc="This is the coffee room.  The floor is a little sticky here
    because all the coffee that has been spilled on the floor.  In fact,
    it's rather difficult to walk here.  There's a door to the south. "
  south=SmokeHall
  out=SmokeHall
  exits=['s']
;
Aula: MurmRoom
  sdesc="Aula"
  ldesc="You are in the aula.  It's a lofty place, high and wide, with a 
    nice wooden floor.  There's a door to the west, and a large stage to 
    the east. "
  west=SmokeHall
  east=Stage
  up=Stage
  exits=['w' 'e']
;
stage: decoration
  location=Aula
  sdesc="stage"
  ldesc="You better go over there to look. "
  noun='stage'
;
Stage: MurmRoom
  sdesc="Stage"
  ldesc="You are on the stage, overlooking the aula to the west.  It's easy 
    to imagine how it would feel to stand here in the limelight, performing, 
    with that large hall dark and filled with hundreds of faces.  Steps lead
    down. "
  west=Aula
  down=Interpres
  exits=['w' 'd']
;
Interpres: darkroom,MurmRoom
  sdesc="Interpres Office"
  ldesc="You are in the office of Interpres, the school newspaper.  Piles of
    old newspapers are found everywhere around, and a few old typewriters
    stand idle.  Steps lead up, and there's a wooden door to the west. "
  up=Stage
  out=Stage
  west=InterpresDoor
  exits=['u']
;
newspapers: decoration
  location=Interpres
  sdesc="newspapers"
  adesc="newspapers"
  ldesc="They're very, very old, and Interpres was never that much fun
    to read anyway. "
  noun='papers' 'newspapers'
  adjective='old' 'news'
;
typewriters: decoration
  location=Interpres
  sdesc="typewriters"
  adesc="typewriters"
  ldesc="They are old, and on closer examination turn out to be broken. "
  noun='typewriter' 'typewriters'
  adjective='old'
;
InterpresDoor: lockableDoorway
  location=Interpres
  sdesc="wooden door"
  ldesc="It's an old wooden door, remarkably narrow.  Despite its age, 
    it looks very sturdy. "
  noun='door'
  adjective='sturdy' 'wooden' 'narrow'
  otherside=DentatalDoor
  doordest=Dentatal
  mykey=DentKey
;
Dentatal: darkroom,MurmRoom
  sdesc="Dentatal Factory"
  ldesc="You walk down a dark tunnel, and arrive in a in the secret VDSB 
    Dentatal Plus toothpaste factory.  It's an enormous hall carved out 
    between the foundations of the school.  The ceiling is so high you can
    barely see it.  Massive machines stand here, huge engines, and enormous
    brass containers filled with white paste.  In another section you see the
    filling machines, elaborate devices to fill tubes with paste.  At the end
    of the hall even stranger machines loom over you. One of them has a 
    wide funnel on its side, with a label \"NaAx\".  What really surprises 
    you is that all the machines are off.  Nothing moves. Everything is 
    silent.  Against the wall is a control console.  You note a large 
    button, labeled \"MASTER START\", and a blinking red light, labeled 
    \"NaAx supply empty\".  There is a door leading east. " 
  east=DentatalDoor
  out=DentatalDoor
;
engines: decoration
  location=Dentatal
  sdesc="engines"
  adesc="engines"
  ldesc="They are enormous, and way too complex for you to understand. "
  noun='engine' 'engines' 'machine' 'machines'
;
containers: decoration
  location=Dentatal
  sdesc="containers"
  noun='container' 'containers'
;
Funnel: fixeditem, qcontainer
  location=Dentatal
  sdesc="NaAx funnel"
  ldesc="It's a filling device, apparently for sodium archimandrite. "
  noun='funnel' 'device'
  adjective='filling'
  full=nil
  verIoEmptyIn(a)={}
  ioEmptyIn(a,o)=
  { if (o<>Bottle) "Listen, it says 'NaAx'! ";
    else 
    { "You pour the purified archimandrite into the funnel. It disappears
      into the bowels of the enormous machine. ";
      Bottle.full:=nil;full:=true;}}
  verIoPutIn(a)="It doesn't fit. "
;
Dlight: decoration
  location=Dentatal
  sdesc="blinking light"
  ldesc="It's blinking nervously. "
  noun='light'
  adjective='blinking'
;
Dbutton: buttonitem
  location=Dentatal
  sdesc="Master Start button"
  adjective='master' 'start'
  doPush(a)=
  { if (Funnel.full)
    {"As you push the button, the hall suddenly comes to life.  Lights flash
    on on the console, and behind you there is a roar of machinery revving
    up.  You turn around, and see how the Dentatal factory is suddenly in
    full motion.  Enormous metal arms mix the paste, and there is a giant 
    sucking sound as large tubes transfer it from the mixing chambers to the 
    filling machines.  In the fillers you see hundreds of the colorful
    Dentatal tubes shooting by, to be delivered in neat piles at the packing
    machinery.\n\tSuddenly, there is a sound of footsteps: Dirk and Piet,
    alarmed by the noise of their factory, run in.  When they realize what
    has happened they burst out laughing in their usual silly manner, and
    pump your hand to thank you for the archimandrite.\n\tBut then there 
    is another sound.  It comes from the door.  Listening carefully, you 
    hear: \"Help, I'm stuck!  Get me out!\"  It's the Rector!  He must have 
    heard the noise as well, and has come to investigate.  For a moment,
    you are close to panic.  But Piet, still laughing, explains that they 
    have made the door to the factory so narrow that the Rector could never 
    enter here... \b\tAnd so, with your experiment done and Piet and Dirk 
    happy, your adventure in the Murmellius Gymnasium comes to a joyful 
    conclusion.\b";incscore(15);scoreRank();terminate();quit();abort;}
  else "Nothing happens. ";} 
;
DentatalDoor: lockableDoorway
  location=Dentatal
  sdesc="wooden door"
  ldesc="It's an old, narrow, but heavy wooden door. "
  noun='door'
  adjective='wooden' 'heavy'  'narrow'
  otherside=InterpresDoor
  doordest=Interpres
  mykey=Throne /* jsut so he can't close it on the Rector */
;
Tower1: MurmRoom
  sdesc="Tower Base"
  ldesc="You are at the bottom of stairs, leading up high into what must be
    some kind of tower.  There is a door to the southwest. "
  sw=UpHall
  up=Tower2
  exits=['sw' 'u']                                    
;
Tower2: MurmRoom
  sdesc="Tower"
  ldesc="You are in the tower.  The narrow stairs lead up and down, and there
    is a door to the south. "
  up=Tower3
  down=Tower1
  south=MessyAttic
  exits=['u' 'd' 's']
;
Tower3: MurmRoom
  sdesc="Clock Room"
  ldesc={"You are in the top of the tower.  There are windows in all
    directions.  In the center of the small room stands a large clock. 
    Stairs lead down. ";if (chairR.location=self) "There is a large
    chair here. ";}
  down=Tower2
  exits=['d']
;
windows: fixeditem
  location=Tower3
  sdesc="windows"
  ldesc="You have a magnificent view of Alkmaar from here.  The weather
    is nice, and you can see for many miles around.  The sky is a dark
    blue, highlighted by a few scattered clouds, and the city looks like
    a miniature world from this height.  Particularly noticeable
    are the 'Molen van Dirk', and the enormous complex of the Buurman
    Toothpaste Industries, further in the distance. "
  thrudesc=self.ldesc
  verDoLookthru(a)={}
  doLookthru(a)=self.ldesc
  noun='window' 'windows'
;
molen: decoration
  location=Tower3
  sdesc="molen"
  noun='molen'
;
industries: decoration
  location=Tower3
  sdesc="Buurman Toothpaste Industries"
  noun='toothpaste' 'industry' 'industries'
;
clock: decoration
  location=Tower3
  sdesc="clock"
  ldesc="It's a large, mostly copper, drive work that runs the clocks on the
    outside of the tower.  Loud ticks emerge from it at a slow pace.  It 
    looks horribly complex, and I seriously think you better keep your 
    hands off it. "
  noun='clock'
;
ChemHall: MurmRoom
  sdesc="Chemistry Hall"
  ldesc="You are in the chemistry hallway, which opens onto a large hall 
    to the west. There are doors to the north, northeast and northwest. 
    The hallway itself continues east. "
  west=UpHall
  north=Chemistry
  nw=Lunch
  ne=ChemPrac
  east=BalconyHall
  exits=['w' 'nw' 'e']
;
Lunch: MurmRoom
  sdesc="Lunch Room"
  ldesc="This is the lunchroom.  It's very smokey here, and you can barely
    see the other side of the room.  When you carefully walk through the
    mist, you note that the floor is littered with all kind of 
    non-descript junk.  It almost looks like there's been a fight here...  A
    door leads south-east. "
  out=ChemHall
  se=ChemHall
  exits=['se']
;
lunchjunk: decoration
  location=Lunch
  sdesc="junk"
  ldesc="It's not really suitable to give a description of this floor
    in mixed company. Let's just say it's quite non-descript. "
  noun='junk'
  adjective='non=descript'
;
WaalsNote: readable
  location=Lunch
  sdesc="piece of paper"
  ldesc="It's a small piece of paper.  Scribbled on it is a short note:
    \"Dirk, don't mess with the VDW machine.  I bugged it! - Piet\" "
  noun='paper' 'note'
  adjective='piece of' 'small'
  verDoBurn(a)={}
  doBurn(a)=
  { if ((lighter.location=Me and self.location=Me) or
          (Bunsen.location=Me.location and Bunsen.burning))
    {"You carefully burn the paper until there's only dusty ash left. ";
      self.moveInto(nil);}
    else "There's nothing to burn them with. ";}
;
Chemistry: MurmRoom
  sdesc="Chemistry Classroom"
  ldesc=
  { "You are in the Chemistry Classroom.  There is a large bench in
    the front of the class, where experiments can be demonstrated.  A 
    periodic table graces the wall. ";
    if (self.distil) "On the bench, a distillation is in progress.
      Liquid in the flask bubbles violently, and drops of the purified
      material drip into the collection bottle. ";
    if (self.base or self.done) "On the bench is a distillation apparatus, and it 
      looks like the distillation is finished. ";
    "Doors lead south and east. ";}
  east=ChemPrac
  south=ChemHall
  distil=nil
  done=nil 
  hot=nil
  Jopie=true
;
PerTable: fixeditem, readable
  location=Chemistry
  sdesc="periodic table"
  ldesc="It's a periodic table of the chemical elements.  Your knowledge
    of chemistry allows you to deduce that this means it was probably
    prepared from periodic acid, or a similar compound.  To your surprise,
    you note several novel elements on the table: Jopium, Omatium and
    Burium, all rare earths, and also the halogen Archimandrium, were 
    unknown to you.  Glad that you have learned something new, you continue 
    your adventure. "
  noun='table'
  adjective='periodic'
;
Therm: readable, Equip
  location=Chemistry
  sdesc="thermometer"
  ldesc=
  { "It's a laboratory thermometer.  It reads ";
    if (self.location=Bottle) say(cvtstr(global.Temp)); 
    else if (self.location=stookhol) "35";
    else "20";
    " C. ";}
  noun='thermometer'
  adjective='lab'
;
ChemBench: surface, fixeditem
  location=Chemistry
  sdesc="bench"
  ldesc="It's an old, black chemistry bench, and its many spots tell stories of 
    many an experiment performed here. There's a bell button on the side,
    with a little note next to it. "
  noun='bench'
  adjective='old' 'large'
;
Bunsen: fixeditem
  location=ChemBench
  sdesc="Bunsen burner"
  ldesc={"It's an old-fashioned bunsen burner, a little rusted. "; 
    if (burning) "It's burning merrily. "; else "But it sure
    looks like it might work. ";}
  noun='burner'
  adjective='bunsen'
  burning=nil
  verDoLight(a)=
  { if (burning) "It's already burning! ";}
  doLight(a)=
  { if (lighter.location=Me) 
    { "Using the cigarette lighter, you light the Bunsen burner.  The air
      inlet needs a bit of adjustment, but after that it burns beautifully. ";
      burning:=true;incscore(2);}
      else "You don't have anything to light it with! ";}
;
Litmus: item, Equip
  location=ChemBench
  sdesc="pH paper"
  ldesc="It's a piece of pH sensitive paper.  On the back it says: \"
    GREEN: pH>9, BLUE: 5<pH<9, RED: pH<5\" "
  noun='paper'
  adjective='litmus' 'pH'
  used=nil
  value=5
  doPutIn(a,o)=
  { if (o=aquarium) "You dip the paper in the aquarium, and it immediately
        turns blue. ";
    else if (o=Flask)
    { if (not o.full) "There's nothing in there to check the pH of. ";
      else {"You dip the paper in the flask, and immediately it turns ";
        if (o.type=2) "red. "; else "green. ";
        if (not used) {incscore(2);used:=true;}}}
    else if (o=Bottle)
    { if (not o.full) "The bottle is empty. ";
      else "You dip the paper in the bottle, and it immediately turns 
      green. ";}
    else if (o=cup and not cup.full) 
      "There's nothing in the cup to check the pH of! ";
    else pass doPut;}
  doBurn(a)=
  { if ((lighter.location=Me and self.location=Me) or
          (Bunsen.location=Me.location and Bunsen.burning))
    {"You carefully burn the paper until there's only dusty ash left. ";
      self.moveInto(nil);}
    else "There's nothing to burn it with. ";}
;
BenchBell: buttonitem
  location=Chemistry
  sdesc="bell"
  ldesc="It's a bell button, with a piece of paper next to it: \"Press to
    call amanuensis.  (ONLY when you've got all your stuff ready!)\""
  noun='bell' 'button' 'note'
  doPush(a)=
  { if (Chemistry.done)  
    { switch (Flask.type)  
    { case 1: {"Jopie emerges.  \"Good, good\", he mumbles, as he starts to 
      take apart the setup, protecting his hand with a thick lab glove. But 
      then he sniffs the collection bottle.  \"Hey man!  This
      isn't archimandrate!  It's sodium hydroxide! Did you check the pH?\"  
      Shaking his head in disgust, he empties the collection bottle and 
      leaves. ";Chemistry.done:=nil;Bottle.full:=nil;break;}
      case 2: { "Jopie takes a while to show up, but when he emerges, he looks happy.
      \"Good work, dude!\", he says, as he takes apart the setup, protecting 
      his hand with a thick lab glove, \"I'll make
      sure to report that you did the experiment successfully.\"  He leaves
      only the bottle with distilled sodium archimandrite, and clears the
      bench.  Before he leaves, he turns once more to you.
      \"You know, after this stuff has cooled, you might consider taking
      some to Dirk and Piet's toothpaste factory.  I heard they are out of
      archimandrite completely.\"  He winks. \"It might gain you a few
      extra points...  Well, don't call me any more, I'm out of here!\"
      He throws the glove on the bench, and disappears. ";incscore(10);
      Chemistry.done:=nil;Chemistry.Jopie:=nil;ChemBench.contents:=[];
      Glove.moveInto(ChemBench);Bottle.moveInto(ChemBench);
      global.Smoke:=1;setdaemon(hotDaemon,nil);}}}
    else if (Chemistry.distil or not Chemistry.Jopie)
      {"The bell rings, but nothing happens. ";}
    else
    { "A loud bell sounds through the room.  After a few seconds, you hear
      some noises underneath the bench, and a yawning figure emerges.  Much
      to your surprise, it turns out to be Jopie Buurman!  Dressed as usual in
      faded jeans and leather jacket, and brushing his long, greasy hair out
      of his eyes, he stares at you, then at the bench.  ";
      if (Tripod.location=ChemBench and Bunsen.burning and 
          Distiller.location=ChemBench and 
          Bottle.location=ChemBench and 
          Flask.location=ChemBench and Flask.full)
      { "Then, with surprising rapidity, he assembles the equipment: he puts
        the tripod over the Bunsen burner, puts the flask on top, attaches
        it to the distiller, and connects the bottle to the other end. 
        Then he hooks the distiller to the watersupply for cooling.  Finally 
        he turns to you again.  \"Don't touch a thing, and call me when it's 
        done... Oh, and don't worry about Piet and Dirk, I'll make sure they
        don't touch anything either.\" Before you know it, he has disappeared 
        again. ";Chemistry.distil:=true;setfuse(distilFuse,20,nil);
        Chemistry.hot:=true;}
      else 
      { "He shakes his head:  \"Sorry dude, you ain't got it together yet.
        Didn't read the note on the bell, huh?  This is going to cost you 
        points, just look at the status line...\"  And he's gone again. ";
        incscore(-1);}}} 
;
distilFuse: function(d)
{ Chemistry.distil:=nil;
  if (Me.location=Chemistry) 
  { "There are a few crackling sounds as the last drops in the flask
    evaporate.  It looks like the distillation is done. ";}
    Chemistry.done:=true;Flask.full:=nil;Bottle.full:=true;
    global.Temp:=100;}
;  
hotDaemon: function(d)
{ if (Bottle.isReachable(Me) and 
      not (Bottle.location=FumeHood and HoodSwitch.isActive))
  { switch (global.Smoke)
    { case 1: {"Green smoke emerges from the bottle with hot archimandrite.
        It smells very unpleasant. ";break;}
      case 2: {"The smoke terribly irritates your airways.  Your eyes start
        to tear, and you feel a little drowsy. ";break;}
      case 3: {"The green archimandrite vapors are clearly affecting you.
        You feel very weak and drowsy, and you have trouble keeping your
        eyes open. ";break;}
      case 4: {"You can barely stay on your feet.  Your eyes are tearing,
        you are coughing, and you realize with trepidation that you will
        pass out if you stay any longer around these noxious archimandrite
        fumes... ";break;}
      case 5: {"Intoxicated by the archimandrite vapor, you sink to the floor,
        and loose consciousness.  You can no longer tell how much time has
        passed.  Sometimes, there seem to be footsteps around you, and once,
        you think you heard a voice, close by: \"Piet, I have the
        archimandrite!\" - or was it just a dream?  Finally, you regain
        consciousness.  Still weak, you struggle to your feet. ";
        Bottle.moveInto(Dirk);Chemistry.hot:=nil;remdaemon(hotDaemon,nil);}}}
    else global.Smoke:=0;
    --global.Temp;
    if (global.Temp=40) {Chemistry.hot:=nil;global.Smoke:=0;}
    if (global.Temp=20) remdaemon(hotDaemon,nil);
    if (Chemistry.hot) ++global.Smoke;}
;
Glove: clothingItem
  location=nil
  sdesc="lab glove"
  ldesc="It's one of those heavy gloves, used to pick up hot items in
    laboratories.  The backside carries a small picture of the Buurman. "
  noun='glove'
  adjective='lab' 'heavy'
  verDoUnWear(a)=
  { if (Bottle.location=Me and Chemistry.hot)
      "You can't!  The bottle you are carrying is still very hot. ";
    else pass verDoUnWear;}
;
ChemPrac: MurmRoom
  sdesc="Chemistry Lab"
  ldesc="You're in the chemistry lab.  There are several benches here,
    with assorted equipment on it.  It appears that pupils here primarily
    involve themselves with titrations.  In one of the corners is a 
    fume hood, with a large liquid dispenser next to it.  Doors lead west 
    and south. "
  west=Chemistry
  south=ChemHall
  exits=['w' 's']
;
PracBench: decoration
  location=ChemPrac
  sdesc="benches"
  adesc="benches"
  ldesc="They're pretty regular-looking chemistry benches. "
  noun='bench' 'benches'
;
PracEquip: decoration
  location=ChemPrac
  sdesc="equipment"
  ldesc="It's a variety of mostly old titration stuff and other pieces of
    chemistry equipment.  It doesn't appear very interesting. "
  noun='equipment'
  adjective='assorted' 'chemistry'
;
FumeHood: fixeditem, container
  location=ChemPrac
  sdesc="fume hood"
  ldesc=
  { "It's an old, large fume hood, bearing the stains of spilled acid. 
    There's a switch on the side.  ";
    if (HoodSwitch.isActive) "The ventilator in the hood is on, ";
    else "The hood is off. ";}
  noun='hood' 'fumehood'
  adjective='fume'
;
HoodSwitch: switchItem
  location=ChemPrac
  sdesc="ON/OFF switch"
  noun='switch'
  adjective='hood'
;
Disp1: fixeditem
  location=ChemPrac
  sdesc="dispenser"
  ldesc="It's a huge glass flask, filled with clear liquid.  There's a 
    small faucet on the side that can be used to fill other containers. 
    There is no label on the dispenser. "
  noun='dispenser'
  type=1
  verDoTake(a)={"It's way too heavy to lift. ";}
;
Faucet1: fixeditem
  location=ChemPrac
  sdesc="faucet"
  noun='faucet'
  adjective='small'
  verDoOpen(a)={"If you open the faucet, fluid will pour on the floor, and
    the Rector would not appreciate that.  If you want to fill a container
    with the liquid, just do so. ";}
;
BalconyHall: MurmRoom
  sdesc="Balcony Hall"
  ldesc="You are in the balcony hall.  Stairs lead up and down, and there
    is a hallway to the west.  To the east, you see a balcony. "
  up=HistHall
  down=SmokeHall
  west=ChemHall
  east=Balcony
  exits=['d' 'u' 'w' 'e']
;
Balcony: MurmRoom
  sdesc="Balcony"
  ldesc="You are on a balcony.  There's a door to the west, and to the
    east, you could attempt to jump down, which would bring you into a
    very large hall. "
  west=BalconyHall
  east={ "You gather your courage and jump...\n";return(Aula);}
  exits=['w']
;
FrenchHall: MurmRoom
  sdesc="French Hallway"
  ldesc="You are in the French hallway.  To the north it 
    opens onto a large hall.  South it continues as a hallway.  There are 
    doors to the east, west and south-east. "
  north=startroom
  west=RectorWC
  east=AmanR
  se=French
  south=BioHall
  exits=['n' 'w' 'e' 'se' 's']
;
RectorWC: MurmRoom
  sdesc="Rector's toilet"
  ldesc="You are in the Rector's toilet.  There is thick carpet on the 
    ground, the mirror is gilded, and the toilet itself reflects 
    the highest quality workmanship."
  out=FrenchHall
  east=FrenchHall
  exits=['e']
;
flushVerb: deepverb
  verb='flush'
  sdesc="flush"
  doAction='Flush'
;
toilet: chairitem
  location=RectorWC
  sdesc="toilet"
  ldesc="It's a marvelous piece of work, carved completely out of jade,
    its beauty enhanced by oriental sculpture, and with a pull chain 
    hammered out of what seems to be pure gold."
  noun='toilet'
  flushed=nil
  verDoFlush(a)={}
  doFlush(a)={"You pull the chain, and immediately Handel's 'Water Music'
    sounds through the small room, subtly mixing with the refreshing sounds 
    of splashing, cool water.";
    if (not flushed) {incscore(1);flushed:=true;}}
;
mirror: fixeditem
  location=RectorWC
  sdesc="mirror"
  noun='mirror'
  adjective='gilded'
  ldesc="It's a beautiful, gilded mirror."
;
chain: fixeditem
  location=RectorWC
  sdesc="pull chain"
  ldesc="It's made out of fine, fire-proofed gold."
  noun='chain' 'pullchain'
  adjective='toilet' 'pull'
  verDoPull(a)={}
  doPull(a)=toilet.doFlush(a)
;
carpet: decoration
  location=RectorWC
  sdesc="carpet"
  noun='carpet'
  adjective='thick'
;
AmanR: MurmRoom
  sdesc="Amanuensis room"
  ldesc="You are in the workplace of the amanuensis.  As a student of the
    classics you immediately realize that this word derives from
    the Latin 'a' (meaning 'not') and 'manu' (meaning 'handy').  An
    amanuensis is therefore an unhandyman.  The place is messy, as expected. " 
   out=FrenchHall 
   west=FrenchHall
   exits=['w']
;
lighter: lightsource,Equip
  location=AmanR
  sdesc="cigarette lighter"
  islit=nil
  noun='lighter'
  adjective='cigarette'
  verDoLight(a)={}
  doLight(a)=
    {"It has a nice, bright flame.  You almost feel sorry you don't
      have any cigarettes. ";}
;
lightVerb: deepverb
  verb='light'
  sdesc="light"
  doAction='Light'
;
French: MurmRoom
  sdesc="French classroom"
  ldesc="You are in the French classroom.  It has the standard picture of
    the Eiffel tower on the wall, and is otherwise an unremarkable place."
  out=FrenchHall
  nw=FrenchHall
  exits=['nw']
;  
Instruct: readable
  location=French
  sdesc="instruction booklet"
  ldesc="It's the instruction booklet for one of the pupil's chemistry
    experiments.  In fact, as you look at the front page, you note it's yours!  
    And you hadn't even noticed you had lost it.  You lucky devil, you...\n\t
    It reads:\b\tDISTILLATION OF SODIUM ARCHIMANDRITE\b1. Collect 
    distillation apparatus: tripod, flask with NaAx, glass distiller, 
    and collection bottle. Careful: NaAx is highly acidic!\n
    2. Have amanuensis assemble it on bench in chemistry classroom 
    (BuurSchools, Inc. rules specifically prohibit students from assembling
    expensive glassware).\n
    3. Heat over flame until evaporated.\n 
    4. Cool bottle with purified NaAx in fume hood.  Careful! Fumes of hot
    NaAx are very noxious!\b\t
    BuurSchools, Inc. takes not even a bit of responsibility for the severe 
    injuries that regularly occur during chemistry experiments."
  noun='book' 'booklet'
  adjective='instruction'
  verDoBurn(a)={}
  doBurn(a)=
  {if (lighter.location=Me)
    {"Using the cigarette lighter, you burn the instruction booklet until
      only a few ashes remain.  You are left with the feeling that you
      just have done something very stupid... ";
      self.moveInto(nil);}
    else if (Bunsen.location=Me.location and Bunsen.burning)
    { "You burn the instruction booklet with the Bunsen burner.  As it
      goes up in smoke, you start to realize you just did something 
      very stupid... ";self.moveInto(nil);}
    else "Come on, you have nothing to burn it with. ";}
;
burnVerb: deepverb
  verb='burn'
  sdesc="burn"
  doAction='Burn'
;
tower: fixeditem
  location=French
  sdesc="Eiffel tower picture"
  ldesc="It's the usual picture of the Eiffel tower.  There is a little red
    arrow pasted onto it, indicating the top lookout, with a text that reads:
    \"Our Beloved Rector\".  And indeed, you can just make out the small, 
    fat, ugly figure. "
  noun='tower' 'picture'
  adjective='eiffel'
;
BioHall: MurmRoom
  sdesc="Biology Hallway"
  ldesc="You are in the biology hallway.  The hallway itself
    continues north, and there are doors to the south and south-east.  Stairs
    lead up. "
  north=FrenchHall
  south=Biology
  se=BioLab
  up=MathHall
  exits=['n' 's' 'se' 'u']
;
Biology: MurmRoom
  sdesc="Biology Classroom"
  ldesc="You are in the biology classroom.  On the walls are large, rather
    unappetizing plates of the insides of animals and humans.  There are 
    exits to the north and east. "
  north=BioHall
  east=BioLab
  exits=['n' 'e']
;
plates: decoration
  location=Biology
  sdesc="plates"
  adesc="plates"
  ldesc="I already told you they were rather disgusting. "
  noun='plates'
;
BioLab: MurmRoom
  sdesc="Biology Lab"
  ldesc="You are in the biology laboratory.  Remains of a recent dissection
    are on the tables.  Against the wall you see a large liquid dispenser.  
    Doors lead north and west. "
  north=BioHall
  west=Biology
  exits=['n' 'w']
;
dissection: decoration
  location=BioLab
  sdesc="dissection remains"
  ldesc="Overcoming your repulsion, you look at the remains, and, rather
    surprising, discover that they are, in fact, the leftovers of a chicken
    dinner that has been eaten here recently. "
  noun='remains' 'dissection'
  adjective='dissection'
;
biotables: decoration
  location=BioLab
  sdesc="tables"
  adesc="tables"
  ldesc="They are ordinary tables. "
  noun='table' 'tables'
;

Disp2: fixeditem
  location=BioLab
  sdesc="dispenser"
  ldesc="It's a huge glass flask, filled with clear liquid.  There's a 
    small faucet on the side that can be used to fill other containers. 
    Unfortunately, there is no label on the dispenser to indicate its
    contents. "
  noun='dispenser'
  type=1
  verDoTake(a)={"It's way too heavy to lift. ";}
;
Faucet2: fixeditem
  location=BioLab
  sdesc="faucet"
  noun='faucet'
  adjective='small'
  verDoOpen(a)={"If you open the faucet, fluid will pour on the floor, and
    the Rector would not appreciate that.  If you want to fill a container
    with the liquid, just do so. ";}
;
MathHall: MurmRoom
  sdesc="Math Hallway"
  ldesc="You are in the math hallway.  Stairs lead down and up.  There is
    a door to the south, and a hallway leads north. "
  down=BioHall
  south=Math
  north=LatinHall
  up=DrawHall
  exits=['d' 'n' 's' 'u']
;
Math: MurmRoom
  sdesc="Math Classroom"
  ldesc="You are in the math classroom.  Main feature here is a enormous
    slide rule fixed to the blackboard.  A door leads north. "
  north=MathHall
  out=MathHall
  exits=['n']
;
rule: decoration
  location=Math
  sdesc="slide rule"
  adesc="slide rule"
  ldesc="It's a huge teaching tool, but you are a little surprised to find
    it here, as slide rules are no longer used in school. "
  noun='rule' 'sliderule'
  adjective='slide' 'enormous'
;
blackboard: decoration
  location=Math
  sdesc="blackboard"
  ldesc="It's a regular blackboard. "
  noun='blackboard' 'board'
  adjective='black'
;
LatinHall: MurmRoom
  sdesc="Latin Hall"
  ldesc="You are in the Latin hallway.  It continues to the north and south,
    and there are doors to the east and west. "
  north=UpHall
  south=MathHall
  east=Latin
  west=Toilet
  exits=['n' 's' 'e' 'w']
;
Latin: MurmRoom
  sdesc="Latin Classroom"
  ldesc="You are in the Latin classroom.  A faint smell of smoke is 
    noticeable here. A door leads west. "
  west=LatinHall
  out=LatinHall
  exits=['w']
;
FlashLight: lightsource
  location=Latin
  sdesc="flashlight"
  noun='light' 'flashlight'
  verDoTurnon(a)={if (self.islit) "It's already on! ";}
  doTurnon(a)={"The flashlight is now on. ";self.islit:=true;} 
  verDoTurnoff(a)={if (not self.islit) "It's not on. ";}
  doTurnoff(a)={"Okay, the flashlight is off. ";self.islit:=nil;}
  bulk=2
;
Toilet: MurmRoom
  sdesc="Pupils' Toilet"
  ldesc="You are in the pupils' toilet.  It's a rather messy place, with
    all kinds of graffiti scibbled on the wall.  The door, which you
    probably want to use as quickly as possible, is to the east. "
  east=LatinHall
  out=LatinHall
  exits=['e']
;
Ptoilet: decoration
  location=Toilet
  sdesc="toilet"
  ldesc="It's not a pleasant sight to behold... Funny enough, there are
    two pull chains, a large one and a small one. "
  noun='toilet'
;
Lchain: fixeditem
  location=Toilet
  sdesc="large pull chain"
  verDoPull(a)={}
  doPull(a)={"Nothing happens...  It must be broken. ";}
  noun='chain' 'pullchain'
  adjective='large' 'pull'
;
Schain: fixeditem
  location=Toilet
  sdesc="small pull chain"
  verDoPull(a)={}
  doPull(a)={"Nothing happens.  Maybe that explains the unpleasant
    state of the toilet. ";}
  noun='chain' 'pullchain'
  adjective='small' 'pull'
;
Twall: readable, fixeditem
  location=Toilet
  sdesc="wall with graffiti"
  ldesc="There's a lot of graffiti on the wall.  You note a few sentences
    in careful script that read: \"FOR SMALL FLUSH USE THE SMALL CHAIN; FOR
    LARGE FLUSH USE THE LARGE CHAIN\".  Underneath is scribbled: \"When in
    doubt, consult the Rector.\"  On another place you read: \"Dirk - Can
    you distill some NaAx?  We're completely out! P.\", and another message:
    \"Piet: Need more distillation equipment.  Let's look for it and meet 
    in the factory.\" "
  noun='wall' 'graffiti'
;
Rector: Actor
  location=rectorR
  sdesc="the Rector"
  adesc="the Rector"
  thedesc="The Rector"
  ldesc="The Rector shows a remarkable similarity with the Buurman.  His
    eyes are tiny and protrude on little stalks.  His head is round and
    bald, framed by large cauliflower ears.  He does not at all look 
    friendly. "
  noun='rector' 'buurman'
  hehehe=nil
;
class VDSB: Actor
;
Dirk: VDSB
  location=Math
  sdesc="Dirk"
  adesc="Dirk"
  thedesc="Dirk"
  ldesc={"Dirk is one of the pupils at the school.  It's not quite clear
    what he is doing here on a Saturday, as he's usually nowhere to be
    found during the schoolweek. ";
    if (self.contents<>[]) {"He carries ";listcont(self);". ";}}
  noun='dirk'
;
DentKey: keyItem
  location=Dirk
  sdesc="rusty key"
  ldesc="It's a small, rusty key.  Attached is a note reading: 
    \"Dentatal\". "
  noun='key'
  adjective='rusty'
;
Piet: VDSB
  location=History
  sdesc="Piet"
  thedesc="Piet"
  adesc="Piet"
  ldesc=
  { "Piet is probably the worst pupil of the whole school.  Most of
    the teachers don't even know what he looks like, as he is never 
    around.  In fact, some of them think he does not even really exist.  
    But here he is!  And on a Saturday. Very surprising... ";
    if (self.contents<>[]) {"He carries ";listcont(self);". ";}}
  noun='piet'
;
moveActor: function(a,n)
{ local elist,i,D,Dir;
  if (rand(n)=1)
  { elist:=a.location.exits;
    i:=elist[rand(length(elist))];
    switch(i)
    { case 'n': {D:=a.location.north;Dir:='north';break;}
      case 'e': {D:=a.location.east;Dir:='east';break;}
      case 's': {D:=a.location.south;Dir:='south';break;}
      case 'w': {D:=a.location.west;Dir:='west';break;}
      case 'ne': {D:=a.location.ne;Dir:='northeast';break;}
      case 'se': {D:=a.location.se;Dir:='southeast';break;}
      case 'sw': {D:=a.location.sw;Dir:='southwest';break;}
      case 'nw': {D:=a.location.nw;Dir:='northwest';break;}
      case 'u': {D:=a.location.up;Dir:='up';break;}
      case 'd': {D:=a.location.down;Dir:='down';}}
    if (a.isVisible(Me.location) and Me.location.islit) 
    { caps();a.sdesc;" leaves ";say(Dir);". ";}
    a.moveInto(D);
    if (a.isVisible(Me.location) and Me.location.islit) 
    { caps();a.sdesc;" enters. ";}}}
;
RectorDaemon: function(d)
{ if (Me.isVisible(rectorR) and Rector.location=rectorR)
  { "The Rector explodes with anger, and bellows: \"What do you think you are doing here in my
      office, you miserable worm!\"  With an terrific kick he throws you
      out the door, and slams it shut.  You find yourself, painfully, on 
      the floor in the Central Hall. ";Me.moveInto(startroom);incscore(-1);}
  else if (Me.location=RectorWC and Rector.location=RectorWC)
  { "The Rector notes you and turns red.  \"What are you doing here, you...  you...\"
      , he hisses.  After these eloquent statements he grabs you in the neck 
      and slings you out into the hall.  The door closes, and you can only
      deduce the activities going on inside. ";Me.moveinto(FrenchHall);}
  else if (rand(2)=1 and Rector.location=RectorWC)
  { "Suddenly, the first bars of Handel's 'Water Music' sound softly through
      the school... ";Rector.moveInto(FrenchHall);
     if (Me.location=FrenchHall) 
      "The Rector enters, closing the zipper of his pants. ";}
   else if ((Piet.location=Rector.location or Dirk.location=Rector.location)
              and rand(4)=1)
   { if (Me.location=Rector.location and Me.location.islit)
     { "The Rector notices ";
       if (Piet.location=Rector.location) "Piet"; else "Dirk"; 
       " and grunts: \"Hehehe!\". ";}
     else "A deep \"Hehehe!\" echoes through the halls... ";
     Rector.hehehe:=true;}
   else moveActor(Rector,3);}
;
VDSBDaemon: function (N)
{ local itemRem,thisItem;
  if (Rector.hehehe or (Me.hehehe and N.isVisible(Me.location)))
  { if (Me.location=N.location and Me.location.islit)
    { N.sdesc;" jumps when he hears ";
      if (Rector.hehehe) "the Rector"; else "you";
      if (Me.hehehe and rand(2)=1)
        ", but then turns to you and relaxes. \"You, a Rector...?\",
        he smiles ironically. ";
      else
      { if (length(N.contents)>0) ", and drops all he's carrying. "; 
        else ". ";
        itemRem:=N.contents;
        while (car(itemRem))
        { thisItem:=car(itemRem);
          if (not thisItem.isworn) thisItem.moveInto(N.location);
          itemRem:=cdr(itemRem);}}
      moveActor(N,1);
    if (Rector.hehehe) Rector.hehehe:=nil; else Me.hehehe:=nil;}}
  else if (N.location=Interpres and (DentKey.location=N 
            or not InterpresDoor.islocked)) 
    { if (Me.location=Interpres and Interpres.islit)
      { N.sdesc;
        if (InterpresDoor.islocked) " unlocks the wooden door and leaves west. ";
        else " enters the wooden door to the west. ";
        "After a little while he returns";
        if (InterpresDoor.islocked) ", locks the door";
        " and leaves up. ";}
      if (Me.location=Dentatal and Dentatal.islit)
      { N.sdesc;" enters.";}
      itemRem:=N.contents;
      while (car(itemRem))
      { thisItem:=car(itemRem);
        if (isclass(thisItem,Equip)) thisItem.moveInto(Dentatal);
        if (Me.location=Dentatal)
        { N.sdesc;" drops ";thisItem.thedesc;". ";}
        itemRem:=cdr(itemRem);}
      N.travelTo(Stage);
      if (Me.location=Dentatal) "Then he leaves again. ";}
  else 
  { itemRem:=N.location.contents;
    while (car(itemRem))
    { thisItem:=car(itemRem);
      if (isclass(thisItem,Equip))
      { thisItem.moveInto(N);
        if (N.location=Me.location and Me.location.islit)
          { N.sdesc;" takes ";thisItem.thedesc;", and yells: \"";}
        else "A loud voice calls out: \"";
        if (N=Dirk) "Piet"; else "Dirk";
        "! I have ";thisItem.thedesc;"!\" ";
        N.location.contents:=N.location.contents-thisItem;}
      itemRem:=cdr(itemRem);}
    moveActor(N,3);}}
;
