; STAR PORTAL
; Game and Text Copyright 1988 by Michael Detlefsen


; FLAGS *********
; Flag 1 is off until white thing is met, then set to ON.
; Flag 2 is off when flashlight is off, and on when light is on.
; Flag 3 is off if player lacks direction finder, and on if present.
; Flag 4 is off is air is NOT breathable, and on if breathable.
; Flag 5 is off when there is VACUUM, on when not a vacuum.
; Flag 6 is off at start of game and ON after initialization
; Flag 7 is off until the guy enters room 5 for the first time.
; flag 8 is is for Odie's bubble.
; flag 9 is off when the first room is entered, on thereafter.
; flag 10 is set ON when daar is awakened.
; flag 11 is set when daar has told his story.
; flag 12 is set when lizards have left planet.
; flag 13 is set ON if daar is on shore at quicksand.
; flag 14 is set when trash picked up
; flag 15 is off until ice wall breached
; flag 16 is off unless first time back to camp portal
; flag 17 is off until daar and odie meet
; flag 18 is off until rope found
; flag 19 is off until device is found
; flag 20 is off until Odie's quicksand save
; flag 21 is off until scare lizard
; flag 22 is off until in rock room
; flag 23 is off until nw orn turned
; flag 24 is off until sw orn turned
; flag 25 is off until flagstone is pushed down
; flag 26 is turned on after OZ's first statement
; flag 27 is turned on when door kicked and player gets second chance.
; flag 28 off until try to leave oz room
; flag 29 set ON when player hit bottom of stairs (room 145)
; flag 30 is on if odie in room next to quicksand room
; flag 31 is for rope points
; flag 32 is for lens points
; flag 33 is for key points
; flag 34 is for gun points
; flag 35 is for light points
; flag 36 is for rock points
; flag 37 is for trash points
; flag 38 is for shovel points
; flag 39 is for battery in device points
; flag 40 is off until oz asks riddle in treasure room
; flag 41 is turned on when first question about riddles is asked
; flag 42 is turned on when riddle is answered 
; flag 43 is turned on when wire is taken from antenna
; flag 44 is set when been in twisty trail first time
; flag 45 is set when darkness hint given
; flag 46 is off when no light source is present on bridge
; flag 47 is set when rope tied to bridge at west end
; flag 48 is set if rope tied to other location on bridge
; flag 49 gets set when odie gives his talk
; flag 50 gets set when OZ detached from group and sent to loc. 108
; flag 51 is on when altar open


; Variables **************
; variable 1 counts turns in poisonous atm. with suit off
; variable 2 counts turns in vacuum with suit off
; variable 3 counts turns in room with white thing
; variable 4 counts turns in snowstorm
; variable 5 keeps track of sequence of events at riddle room
; variable 6 keeps track of where player is on the long stairs
; variable 7 keeps track of flashlight strength
 
; Counters *************
; counter 1 counts turns till shuttle is launched
; counter 2 counts turns till shuttle grounds
; counter 3 counts turns in quicksand
; counter 4 counts turns since encountered lizards
; counter 5 counts turns wearing contact lens
; counter 6 counts turns while OZ figures out how to speak English
; counter 7 sets limit on how long flare will last (10 turns)
; counter 8 keeps track of how long you've been in the dark on the bridge

; -------------------------------------------------------------

COMMAND anybody, any any
not namepresent ; nobody here
printmessage 130 ; nobody here
donewithturn
END_COMMAND

COMMAND ANY
newlife ; (was flagoff 6) if flag is off, then do this
turnflagon 5 ; starts game not in a vacuum
setvariableto 1 4
setvariableto 2 2
setvariableto 3 4
setvariableto 4 0
not present 213
putincurrentroom 213
destroy 215
putincurrentroom 214
END_COMMAND

COMMAND any
newlife
sendtoroom 302 0 ; if resurrected, put others back where they belong
sendtoroom 304 0
sendtoroom 307 0
END_COMMAND

COMMAND any
atlocation 5
destroy 201 ; key shows up in room 141 for some reason
END_COMMAND

COMMAND any
ison 208 ; light on?
addtovariable 7 1 ; increment counter
turncounteroff 8
END_COMMAND

COMMAND any
variableequals 7 125 ; at 125 turns with light on
present 208 ; light here?
printmessage 234 ; getting dim
END_COMMAND

COMMAND any
variablegt 7 175 ; 175 turns with light on
present 208 ; and it's here
printmessage 233 ; light's out!
swaplocations 208 212 ; bring dead one here
getit 212 ;pick it up
END_COMMAND

COMMAND any
counterequals 7 10 ; 10 turns since lit flare
iscarrying 289 ; lit flare
printmessage 218 ; flare goes out
swaplocations 289 288 ; bring unlit one back 
END_COMMAND

COMMAND any 
counterequals 8 0
not ison 208 ; light off
atlocationgt 148 ; east end of bridge
atlocationlt 154 ; west end of bridge
turncounteron 8 ; start counter
END_COMMAND

COMMAND any 
counterequals 8 2 ; 2nd turn
atlocationgt 148 ; east end of bridge
atlocationlt 154 ; west end of bridge
printmessage 209 ; 'player is in the dark!'
END_COMMAND

COMMAND any 
counterequals 8 4 ; 4th turn
atlocationgt 148 ; east end of bridge
atlocationlt 154 ; west end of bridge
printmessage 210 ; 'player is in the dark!'
END_COMMAND

COMMAND any 
counterequals 8 6 ; 6th turn
atlocationgt 148 ; east end of bridge
atlocationlt 154 ; west end of bridge
printmessage 211 ; 'oooohhh, it glows!'
END_COMMAND

COMMAND any
flagoff 45
atlocation 150 ; on bridge
printmessage 207 ; old memories
turnflagon 45
END_COMMAND


COMMAND any
not present 281 ; door not here?
atlocation 132 ; on stairs?
flagon 25 ; stone down?
changepassageway 3 141 ; open to construction room
printmessage 193 ; what?  a door?
putincurrentroom 281 ; bring door here
donewithturn
END_COMMAND

COMMAND ANY
present 302 ; daar here
present 304 ; odie here
turnflagon 17
END_COMMAND

COMMAND any
atlocation 69 ; room beside quicksand
present 302 ; if daar present
turnflagon 13
END_COMMAND

COMMAND any
atlocation 69 ; room beside q.s.
not present 302 ; daar not here
turnflagoff 13 ; turn off
END_COMMAND

COMMAND any
atlocation 69 ; odie at quicksand?
present 304
turnflagon 30
END_COMMAND

COMMAND any
atlocation 69 ; odie not at quicksand
not present 304
turnflagoff 30
END_COMMAND


COMMAND any
flagon 50 ; if oz been detached
present 307 ; oz here?
printmessage 167 ; fare-thee-well
destroy 307 ; oz fades away
END_COMMAND

COMMAND any
counterequals 6 3 ; wait
atlocation 139 ; in riddle hall
present 307 ; oz here 
not present 304 ; if odie not here
printmessage 151 ; give spiel
donewithturn
END_COMMAND

COMMAND any
counterequals 6 3 ; wait
atlocation 139 ; in riddle hall
present 307 ; oz here
present 304 ; if odie here
printmessage 152 ; give spiel
donewithturn
END_COMMAND

COMMAND ANY
atlocationgt 96 ; outside snow portal
atlocationlt 101 ; outside ice cave
addtovariable 4 1 ; increment snowstorm
END_COMMAND

COMMAND ANY
atlocationgt 96 ; here in 
atlocationlt 101 ; snow country
variablelt 4 11 ; for less than 10 turns
printmessage 94 ; snowstorm around player
END_COMMAND

COMMAND ANY
atlocationgt 96 ; here in 
atlocationlt 101 ; snow country
variableequals 4 11 ; for more than 10 turns
printmessage 95 ; snowstorm quits
END_COMMAND

COMMAND ANY
atlocation 4 ; if at door to portal place
turnflagoff 7 ; make sure you say you have not been inside before
END_COMMAND

COMMAND ANY
atlocation 27 ; in fire portal
iscarrying 251 ; carrying fresh branch?
swaplocations 251 252 ; make it a dry branch
printmessage 106 ; steamamatic
END_COMMAND

COMMAND ANY
atlocation 70 ; in quicksand
counterlt 3 1 ; less than 1?
turncounteron 3 ; start the count-down
END_COMMAND

COMMAND ANY
atlocation 70 ; in quicksand
flagon 30 ; odie here?
counterequals 3 4 ; for five turns
turncounteroff 3 ; reset it
printmessage 118 ; uh-oh
sendtoroom 69; put back on bank
addtogroup 304 ; heeere's Odie!
flagon 20 ; set flag
donewithturn
END_COMMAND

COMMAND ANY
atlocation 70 ; in qs?
flagon 13 ; if daar on shore
counterequals 3 4 ; almost dead
printmessage 61 ; save him
gotoroom 69 ; back to shore
addtogroup 302 ; put daar back in group
addtogroup 304 ; put odie back in group
turncounteroff 3 ; reset quicksand counter
donewithturn
END_COMMAND


COMMAND ANY
atlocation 70 ; in quicksand
flagon 20 ; and if stupid enough to do it twice
printmessage 119 ; how could you!
gotoroom 146
killplayer ; fix him good
donewithturn
END_COMMAND

COMMAND ANY
atlocation 70 ; in quicksand
counterequals 3 5 ; for five turns
printmessage 49 ; uh-oh
gotoroom 146
killplayer
donewithturn
END_COMMAND

COMMAND ANY
present 300 ; if white thing is here
addtogroup 300 ; sticks like crazy
END_COMMAND

COMMAND ANY
present 300 ; if thing is here
subtractfromvariable 3 1 ; decrement counter
END_COMMAND

COMMAND ANY
present 300 ; if creature is here
variableequals 3 3 ; and counter = 3
or
variableequals 3 2 ; or counter = 2
printmessage 34 ; print this message
END_COMMAND

COMMAND ANY
present 300 ; if thing is here
variableequals 3 1 ; and counter = 1
printmessage 35 ; print this
END_COMMAND

COMMAND ANY
present 300 ; thing here?
variableequals 3 0 ; counter 3 = 0
printmessage 36 ; tell player the good news
gotoroom 146
killplayer ; kill him
donewithturn
END_COMMAND


COMMAND ANY
ATLOCATION 5 ; if in room 5
iswearing 213 ; and wearing the suit
flagoff 7 ; and is in room 5 for the first time
dropit 213 ; take it off, throw it on the floor
turnflagon 4 ; air in here can be breathed
turnflagon 7 ; flag to indicate not first time in room
TURNFLAGoff 1 ; set flag to say the suit is off
dropit 215
END_COMMAND


COMMAND ANY
atlocation 20 ; if at second portal (canyon planet)
turnflagoff 4 ; not breathable
turnflagon 5 ; but not a vacuum
END_COMMAND

COMMAND ANY
atlocation 21 ; if at stars portal (third)
turnflagoff 5 ; is a vacuum
turnflagon 4 ; not poisonous air
END_COMMAND

COMMAND ANY
atlocation 22 ; if at swamp portal (fourth)
turnflagon 5 ; not a vacuum
turnflagon 4 ; air is breathable
END_COMMAND

COMMAND ANY
atlocation 23 ; at forest portal
turnflagon 5 ; not a vacuum
turnflagon 4 ; air is breathable
END_COMMAND

COMMAND ANY
atlocation 24 ; blankness outside
turnflagon 5 ; not a vacuum
turnflagoff 4 ; air not breathable
END_COMMAND

COMMAND ANY
atlocation 25 ;  at snowstorm portal
turnflagon 5 ; not a vacuum
turnflagon 4 ; air is breathable
END_COMMAND

COMMAND ANY
atlocation 26 ;  at -open area with buildings-
turnflagon 5 ; not a vacuum
turnflagon 4 ; air is breathable
END_COMMAND

COMMAND ANY
atlocation 27 ; near star
turnflagoff 5 ; definitely a vacuum
turnflagon 4 ; air not poisonous (don't want both messages!)
END_COMMAND

COMMAND ANY
atlocation 28 ; museum planet
turnflagon 5 ; not a vacuum
turnflagon 4 ; air breathable
END_COMMAND

COMMAND ANY
atlocation 29 ; footpath planet
turnflagon 5 ; not a vacuum
turnflagon 4 ; air breathable
END_COMMAND

COMMAND any
verbisdirection ; going to leave
atlocation 69 ; in room before quicksand
iscarrying 239 ; rope is still tied to tree
printmessage 247
donewithturn
END_COMMAND

COMMAND ANY
counterequals 4 0 ; lizards not here
atlocationGT 84 ; player not in portal
atlocationLT 96 ; player not in museum
chance 20 ; 20% chance lizards show up this turn
printmessage 70 ; tell about lizards
putincurrentroom 305 ; bring lizards here
addtogroup 305 ; add 'em to group
turncounteron 4 ; start the process
donewithturn
END_COMMAND

COMMAND ANY
present 305 ; lizards here?
printmessage 71 ; get the nets ready!
END_COMMAND


COMMAND ANY
present 305 ; lizards here?
counterequals 4 8 ; lizards in same room for 8 turns? (cumulative)
printmessage 72 ; bears bad news
endgame
donewithturn
END_COMMAND

COMMAND ANY
atlocation 96 ; in museum
counterGT 4 0 ; lizards chased you there
counterLT 4 10 ; but not after they left
printmessage 73 ; gobble, gobble
END_COMMAND

COMMAND ANY
atlocation 96 ; in museum
counterequals 4 10 ; get ready!
printmessage 76 ; --they're gone--
sendtoroom 305 0 ; dump lizards
sendtoroom 242 92 ; put carton in street
donewithturn
END_COMMAND

COMMAND ANY
iswearing 213 ; if wearing suit
setvariableto 1 4 ; re- init  poison
setvariableto 2 2 ; and vacuum counters
END_COMMAND

COMMAND ANY
variableequals 1 0 ; if in poison and counter =0
printmessage 10 ; print this
turnflagoff 6 ; do reinit in first room
gotoroom 146
killplayer ; kill him
donewithturn
END_COMMAND

COMMAND ANY
variableequals 2 0 ; if in vacuum and counter=0
printmessage 11 ; print this
turnflagoff 6 ; do reinit in first room
gotoroom 146
killplayer ; kill him
donewithturn
END_COMMAND


COMMAND ANY
flagoff 4 ; if air not breathable
not iswearing 213 ; and suit is not worn
printmessage 6 ; tell the poor guy he's in trouble
subtractfromvariable 1 1
END_COMMAND

COMMAND ANY
flagoff 5 ; if in a vacuum
not iswearing 213 ; and suit not worn
subtractfromvariable 2 1
printmessage 7 ; tell him he's going to explode
END_COMMAND

COMMAND ANY
present 215 ; if GREEN atd is here
flagoff 4 ; and no air
or
present 215 ; if GREEN adt is here
flagoff 5 ; and bad air
swaplocations 215 214 ; swap GREEN for the RED one
END_COMMAND

COMMAND ANY
present 214 ; if the RED atd is here
flagon 4 ; and no vacuum
flagon 5 ; and good air
swaplocations 214 215 ; then swap the RED for the GREEN
END_COMMAND


COMMAND ANY
atlocation 107 ; if at end of road
firstvisittoroom 107 ; for the first time
turnflagon 16 ; fix things up to give message when goes into the portal
END_COMMAND

COMMAND ANY
atlocation 74
counterequals 1 10 ; if counter gets to 9
or
counterGT 1 10 ; or greater than 9
changepassageway 11 0 ; close passage (shuttle is gone)
END_COMMAND

COMMAND ANY
atlocationLT 84 ; make sure he
atlocationGT 73 ; is still on ship
counterequals 1 20 ; if counter gets to 20
or
counterGT 1 20 ; or gets greater than 20
printmessage 40 ; bad news
gotoroom 146
killplayer ; bang
donewithturn
END_COMMAND


COMMAND ANY
flagoff 11 ; if this is off
atlocation 65 ; in shuttle
present 302 ; daar is here
printmessage 39 ; daar's spiel about burning up
turnflagon 11 ; don't go through it again
turncounteroff 1 ; zero it
turncounteron 2 ; start in-shuttle count
END_COMMAND

COMMAND ANY
atlocation 65 ; in shuttle
counterequals 2 5 ; for 5 turns
printmessage 45 ; print landing message
addtogroup 302 ; add daar to group
changepassageway 12 63 ; open passage to outside
END_COMMAND

COMMAND ANY
present 304 ; odie here
flagoff 8 ; field not on
flagoff 4 ; vacuum
or 
flagoff 5 ; poison
turnflagon 8 ; force field flag
printmessage 86 ; odie's got an out!
END_COMMAND

COMMAND ANY
present 304 ; Odie here
flagon 8 ; field on
flagon 4 ; not a vacuum
flagon 5 ; not poison
printmessage 87 ; pop!
turnflagoff 8 ; field off
END_COMMAND

COMMAND ANY
atlocation 21 ; stars
iscarrying 249
or
atlocation 27 ; furnace
iscarrying 249 ; got burning item?
printmessage 114
swaplocations 245 249 ; make it quit burning
END_COMMAND
 
COMMAND ANY
atlocation 21 ; stars
iscarrying 252
or
atlocation 27 ; furnace
iscarrying 252 ; got burning item?
printmessage 114
swaplocations 252 251 ; make it quit burning
END_COMMAND


COMMAND ANY
flagoff 22
atlocation 120 ; finally got here
firstvisittoroom 120 ; for first time
printmessage 124 ; congrats
turnflagon 22
END_COMMAND

COMMAND ANY
iswearing 205 ; wear lens?
counterequals 5 6 ; for six turns
printmessage 136 ; first warning
END_COMMAND

COMMAND ANY
iswearing 205 ; wear lens?
counterequals 5 7 ; for seven turns
printmessage 137 ; second warning
END_COMMAND

COMMAND ANY
iswearing 205 ; wear lens?
counterequals 5 8 ; for eight turns
printmessage 138 ; third warning
END_COMMAND

COMMAND ANY
iswearing 205 ; still wearing it?
counterequals 5 9 ; for nine turns
printmessage 139 ; last chance
donewithturn
END_COMMAND

COMMAND ANY
iswearing 205
counterequals 5 10 ; doom
printmessage 141 ; gobble, gobble
gotoroom 146
killplayer
donewithturn
END_COMMAND

COMMAND any
atlocation 51 ; first room of forest
iscarrying 219 ; and carrying active device
printmessage 52 ; tell him it's blinking
END_COMMAND


COMMAND any
atlocation 52
iscarrying 219
or
atlocation 53
iscarrying 219
or
atlocation 58
iscarrying 219
printmessage 53 ; first level of beeps
END_COMMAND

COMMAND any
atlocation 55
iscarrying 219
or
atlocation 54
iscarrying 219
or
atlocation 59
iscarrying 219
printmessage 54 ; second level of beeps
END_COMMAND

COMMAND any
atlocation 56
iscarrying 219
or
atlocation 60
iscarrying 219
or
atlocation 61
iscarrying 219
or
atlocation 57
iscarrying 219
printmessage 55 ; third level of beeps
END_COMMAND

COMMAND any
atlocation 62
iscarrying 219
printmessage 56 ; they're here
END_COMMAND

COMMAND eat any
printmessage 198 ; can't eat anything
donewithturn
END_COMMAND

COMMAND drink any
printmessage 198 ; can't drink anything
donewithturn
END_COMMAND

COMMAND talk to daar
not present 302 ; if not here
printmessage 131 ; then say so
donewithturn
END_COMMAND

COMMAND talk to odie
not present 304
printmessage 131
donewithturn
END_COMMAND

COMMAND talk to odie
present 304
randommessage 83 85
donewithturn
END_COMMAND

COMMAND ask daar about any any
not present 302
printmessage 131
donewithturn
END_COMMAND

COMMAND ask daar about the knife
present 302 ; if he's here and you've got a knife variation
iscarrying 263
or
present 302
iscarrying 277
or
present 302
iscarrying 278
or
present 302
iscarrying 279
or
present 302
iscarrying 280
printmessage 192 ; swiss army knives from outer space!
donewithturn
END_COMMAND

COMMAND ask daar about the sign
atlocation 141 ; in sign room
present 274 ; sign here
printmessage 202 ; under cons
donewithturn
END_COMMAND


COMMAND ask daar about the handle
present 302 ; here?
atlocation 141 ; in construction room
present 276 ; handle here?
printmessage 182 ; 'push the button, Max!'
donewithturn
END_COMMAND

COMMAND ask daar about markings
present 302 ; is he here?
atlocation 116 ; at marked rock?
printmessage 120 ; spiel
donewithturn
END_COMMAND

COMMAND ask daar about the markings
present 302 ; is he here?
atlocation 116 ; at marked rock?
printmessage 120 ; spiel
donewithturn
END_COMMAND


COMMAND ask daar about himself
present 302
printmessage 41
donewithturn
END_COMMAND

COMMAND ask daar about merrivale
present 302
printmessage 42
donewithturn
END_COMMAND

COMMAND ask daar about pilot
present 302 ; if he is here
printmessage 43
donewithturn
END_COMMAND

COMMAND ask daar about odie
present 302 ; if daar is here
present 304 ; if odie here
printmessage 111 ; oh, oh, something is going on here
donewithturn
END_COMMAND

COMMAND ask daar about odie
flagon 17 ; if met odie
present 302 ; if daar here
printmessage 112 
donewithturn
END_COMMAND

COMMAND ask daar about portal
present 302 ; here?
printmessage 115
donewithturn
END_COMMAND

COMMAND ask daar about the riddle
flagon 40
present 302
printmessage 196
donewithturn
END_COMMAND

COMMAND ask daar ANY
nounpresent
present 302 ; if he is here
randommessage 80 82 ; print one of these
donewithturn
END_COMMAND

COMMAND ask odie any
present 304 ; is he here?
randommessage 83 85 ; what did you expect?
donewithturn
END_COMMAND

COMMAND ask oz about daar
present 307
printmessage 164
donewithturn
END_COMMAND

COMMAND ask oz about odie
present 307
printmessage 163
donewithturn
END_COMMAND

COMMAND ask oz about the riddle
present 307 ; here ?
atlocation 142 ; in altar room ?
printmessage 170 ; repeat it
donewithturn
END_COMMAND

COMMAND ask oz any any
present 307
printmessage 165 ; sorry don't know
donewithturn
END_COMMAND

COMMAND Odie, stay
present 304 ; here?
removefromgroup 304 ; stays here
printmessage 84 ; nap time
donewithturn
END_COMMAND

COMMAND Odie, come
present 304 ; here?
addtogroup 304 ; glue 
printmessage 85 ; lick, lick
donewithturn
END_COMMAND

COMMAND help
atlocation 70 ; in quicksand
islocated 302 69 ;if daar on shore
printmessage 61 ; save him
gotoroom 69 ; back to shore
addtogroup 302 ; put daar back in group
addtogroup 304 ; put odie back in group
turncounteroff 3 ; reset quicksand counter
turnflagoff 13 ; reset this in case returns without daar
donewithturn
END_COMMAND

COMMAND show rope to daar
atlocation 69 ; if at right place
present 302 ; if daar here
present 224 ; rope is here
printmessage 63  
swaplocations 224 239 ; swap rope for end of rope
donewithturn
END_COMMAND

COMMAND show rope to daar
atlocation 69 ; if at right place
present 302 ; if daar here
present 239 ; knotted rope is here
printmessage 246  
swaplocations 239 224 ; swap end of rope for rope
donewithturn
END_COMMAND

COMMAND show device to daar
present 302 ; if daar here
present 218 ; act device
or
present 302
present 219 ; inact device
printmessage 44
donewithturn
END_COMMAND

COMMAND examine glow
countergt 8 0 ; lights out
printmessage 215 ; see it glow
donewithturn
END_COMMAND

COMMAND examine glow
counterequals 8 0 ; if lights on
printmessage 216 ; can't see glow in light
donewithturn
END_COMMAND

COMMAND examine antenna
atlocation 84 ; quicksand island
putincurrentroom 284
END_COMMAND

COMMAND examine floor
redirectto examine flagstones
donewithturn
END_COMMAND

COMMAND examine flagstones
atlocation 145 ; end of stairs
flagoff 25 ; flagstone up
printmessage 145  ; now you see it!
putincurrentroom 268 ; zip stone
describething 268 ; see if this will do it!
donewithturn
END_COMMAND

COMMAND examine flagstone
atlocation 145 ; end of stairs
flagon 25 ; already pushed f.s.
printmessage 145 ; sort of flat
donewithturn
END_COMMAND

COMMAND examine flagstones
atlocation 111 ; on porch
printmessage 181 ; nice floor you have here.....
donewithturn
END_COMMAND

COMMAND examine shrubs
atlocation 62 ; are they around?
printmessage 178 ; generic shubs
donewithturn
END_COMMAND


COMMAND Examine Rubble
flagoff 18 ; first time
atlocation 50 ; in right room
printmessage 22 ; print descr
putincurrentroom 224 ; put rope in room
turnflagon 18 ; not again
donewithturn
END_COMMAND

COMMAND Examine rubble
flagon 18 ; not first time
atlocation 50 ; right room
printmessage 117 ; nothing here
donewithturn
END_COMMAND


COMMAND examine porch
atlocation 111 ; are you there?
printmessage 146 ; descr.
donewithturn
END_COMMAND

COMMAND examine ornaments
atlocation 111 ; at right room?
printmessage 142 ; describe
putincurrentroom 265
putincurrentroom 266
donewithturn
END_COMMAND

COMMAND examine markings
atlocation 116
printmessage 128
donewithturn
END_COMMAND

COMMAND Examine trash
atlocation 90 ; in trash room
putincurrentroom 246 ; bring it here
describething 246
donewithturn
END_COMMAND

COMMAND Examine circle
printmessage 32 ; generic circle message
donewithturn
END_COMMAND

COMMAND Examine flashlight
present 208 ; if light here
ison 208 ; if it's on
printmessage 88 ; yep, it's on 
donewithturn
END_COMMAND

COMMAND Examine Wall
flagoff 15 ; not through wall
atlocation 102 ; in ice wall room
present 208
ison 208
printmessage 92 ; tell about opening 
donewithturn
END_COMMAND

COMMAND Examine opening
flagoff 15 ; not through wall
atlocation 102
present 208
ison 208
printmessage 93 ; give hint about other side
donewithturn
END_COMMAND

COMMAND examine door
atlocation 4
printmessage 239
donewithturn
END_COMMAND

COMMAND examine door
atlocation 139 ; in riddle hall
or
atlocation 142 ; in altar room
printmessage 197 ; describe door
donewithturn
END_COMMAND

COMMAND examine rock
atlocation 120 ; in rock room
present 223 ; rock here?
printmessage 232
donewithturn
END_COMMAND

COMMAND examine lock
atlocation 177 ; in wooden door room?
printmessage 237 ; just an old-fashioned lock <doo-dah, doo-dah>
donewithturn
END_COMMAND

COMMAND light flare
iscarrying 289 ; got unlit flare
printmessage 184 ; flash!
swaplocations 289 288 ; switch for lit flare
turncounteron 7
donewithturn
END_COMMAND


COMMAND light branch
atlocationgt 99 ; only can light
or
atlocationlt 97 ; on snow planet when snow stopped (arbitrary, but....)
printmessage 113 ; nope
donewithturn
END_COMMAND

COMMAND Light Branch
variablelt 4 11 ; still snowing
iscarrying 244 ; got branch?
iscarrying 205 ; got lens
printmessage 96 ; no deal
donewithturn
END_COMMAND

COMMAND Light Branch
variablegt 4 10 ; snow stopped?
iscarrying 244 ; got branch?
iscarrying 205 ; got lens
printmessage 105 ; doesn't burn (heh,heh)
donewithturn
END_COMMAND

COMMAND Light Branch
variablelt 4 11 ; still snowing
iscarrying 245 ; got branch?
iscarrying 205 ; got lens
printmessage 96 ; no deal
donewithturn
END_COMMAND

COMMAND Light Branch
variablegt 4 10 ; snow stopped?
iscarrying 245 ; got branch?
iscarrying 205 ; got lens
printmessage 97 ; flame it!
swaplocations 245 249 ; bring lit branch here.
donewithturn
END_COMMAND

COMMAND Light Branch
variablelt 4 11 ; still snowing
iscarrying 251 ; got branch?
iscarrying 205 ; got lens
printmessage 96 ; no deal
donewithturn
END_COMMAND

COMMAND Light Branch
variablegt 4 10 ; snow stopped?
iscarrying 251 ; got branch?
iscarrying 205 ; got lens
printmessage 97 ; flame it!
swaplocations 251 252 ; bring lit branch here.
donewithturn
END_COMMAND


COMMAND Burn trash
iscarrying 249 ; got lit wood?
atlocation 102
iscarrying 246
or
iscarrying 252 ; got branch?
atlocation 102 ; in ice wall room?
iscarrying 246 ; carrying trash?
printmessage 100 ; warn player
donewithturn
END_COMMAND


COMMAND Burn trash
iscarrying 249 ; got lit wood?
atlocation 102 ; in ice wall room?
present 246 ; trash here?
printmessage 98 ; burn trash
destroy 246 ; destroy the rubbish
destroy 249 ; dump burning wood
changepassageway 11 103 ; open hole to room 103
putincurrentroom 247 ; put opening here
plusscore 25
donewithturn
END_COMMAND

COMMAND Burn trash 
present 246 ; trash here?
not iscarrying 249 ; not got burning wood
or
present 246
not iscarrying 252
printmessage 99 ; not good enough
donewithturn
END_COMMAND


COMMAND Look at sparkle
atlocation 69 ; before quicksand
printmessage 48 ; sees sparkle
donewithturn
END_COMMAND

COMMAND up
atlocation 145 ; at b. of stairs
gotoroom 144 ; go up one flight
lookatroom
donewithturn
END_COMMAND

COMMAND up
atlocation 144 ; on stairs
variableequals 6 0 ; back at zero point
gotoroom 143 ; top of stairs
donewithturn
END_COMMAND

COMMAND up
atlocation 144 ; on stairs
subtractfromvariable 6 1 ; go up a level
printmessage 201
donewithturn
END_COMMAND

COMMAND down
atlocation 144 ; in-between
variableequals 6 25 ; if hit 25 times down
gotoroom 145 ; now at bottom of stairs
printmessage 177
turnflagon 29
donewithturn
END_COMMAND

COMMAND down
flagoff 29 ; print message after 5 turns on stairs
atlocation 144
variableequals 6 5
printmessage 172
lookatroom
END_COMMAND

COMMAND down ; print message after 12 turns on stairs
flagoff 29
atlocation 144
variableequals 6 12
printmessage 174
lookatroom
END_COMMAND

COMMAND down
flagoff 29 ; print message after 18 turns on stairs
atlocation 144
variableequals 6 18
printmessage 175
lookatroom
END_COMMAND

COMMAND down
flagoff 29 ; print message after 21 turns on stairs
atlocation 144
variableequals 6 21
printmessage 176
lookatroom
END_COMMAND


COMMAND down
atlocation 144 ; on stairs?
addtovariable 6 1 ; down one more level
printmessage 201
donewithturn
END_COMMAND


COMMAND Down
not iscarrying 223 ; if not carrying the rock
atlocation 41 ; in the pool
printmessage 19
donewithturn
END_COMMAND

COMMAND Down
not iscarrying 223 ; if not carrying the rock
atlocation 48 ; in the pool
printmessage 19
donewithturn
END_COMMAND

COMMAND north
atlocationgt 148 ; if player stupid enough to walk off bridge,
atlocationlt 154 ; give him what he/she deserves.
present 304 ; odie here
present 304
printmessage 228
donewithturn
END_COMMAND


COMMAND north
atlocationgt 148 ; if player stupid enough to walk off bridge,
atlocationlt 154 ; give him what he/she deserves.
printmessage 219
removefromgroup 302 ; daar  too smart to follow
gotoroom 146
killplayer
donewithturn
END_COMMAND


COMMAND north
flagoff 44
atlocation 103 ; cavern, about to go to twisty trail
printmessage 204 ; grow up!
clearscreen
printmessage 208
turnflagon 44
END_COMMAND

COMMAND north
atlocation 62 ; in forest at shrubs
iscarrying 219 ; and carrying the active locator
printmessage 58 ; tell the guy about it
changepassageway 1 63
gotoroom 63
donewithturn
END_COMMAND

COMMAND North
atlocation 49 ; in room with rocky ledge
iscarrying 223 ; and carrying the rock
printmessage 108 ; neutral bouyancy
gotoroom 48 ; jump in pool
changepassageway 10 47 ; player now can go down
donewithturn
END_COMMAND


COMMAND north
atlocation 24 ; if player has walked off cliff
printmessage 16 ; remind him he can't fly
turnflagoff 6 ; allow reinit routine
removefromgroup 302
removefromgroup 304
gotoroom 146
killplayer ; smush him up a bit
donewithturn
END_COMMAND

COMMAND north
atlocation 21 ; player was stupid and walked off into space
printmessage 15 ; tell him to eat space
turnflagoff 6 ; set for reinit at first room
removefromgroup 302
removefromgroup 304
gotoroom 146
killplayer ; kill him
donewithturn
END_COMMAND

COMMAND north
atlocation 62 ; at room before craft
not iscarrying 219 ;  and not carrying active device
printmessage 57 ; print message 
donewithturn
END_COMMAND

COMMAND north
atlocation 27 ; at nova gate
printmessage 29 ; you did a stupid thing, amigo
removefromgroup 302
removefromgroup 304
gotoroom 146
killplayer ; squish
donewithturn
END_COMMAND

COMMAND north
atlocation 79 ; in n/s corr
flagon 10 ; is daar awake?
gotoroom 83 ; then send to room with open doors
donewithturn
END_COMMAND

COMMAND North
atlocation 93 ; in front of museum
present 305 ; lizards pursuing
printmessage 74 ; print reprieve  (door closes)
removefromgroup 305 ; detach lizards
END_COMMAND

COMMAND North
atlocation 93 ; front of museum
counterequals 4 0 ; before liz
or 
atlocation 93
counterGT 4 15 ; after liz
printmessage 77 ; door closes
END_COMMAND

COMMAND west
atlocation 73 ; in alligator room
not present 301 ; alligator not here
gotoroom 72 ; go past stubborn AGT program (why does it DO this?)
END_COMMAND


COMMAND west
atlocation 81 ; in crowded room
flagon 10 ; daar awake?
gotoroom 83 ; send to alternate corridor end
donewithturn
END_COMMAND

COMMAND west
atlocation 83 ; in alt corridor
gotoroom 82
firstvisittoroom ; for the first time
present 302
printmessage 38 ; time to panic
sendtoroom 302 65 ; send to daar to lifeboat
turncounteron 1 ; start count-down to lifeboat departure
donewithturn
END_COMMAND

COMMAND west
atlocation 69 ; b4 quicksand
present 302 ; if daar is here
printmessage 59 ; he's smarter than you
removefromgroup 302
turnflagon 13 ; set so he can help you
END_COMMAND

COMMAND west
atlocation 69 ; b4quicksand
present 304 ; if odie is here
printmessage 60 ; even odie isn't that dumb
removefromgroup 304
END_COMMAND


COMMAND west
atlocation 138 ; hallway before riddle room
present 307 ; got oz with you?
printmessage 166 ; oz waits
removefromgroup 307 ; doesn't go to riddle room
END_COMMAND

COMMAND west
variableequals 5 2 ; at right sequence
atlocation 139 ; in riddle room
addtogroup 307 ; add oz to group
present 307 ; oz here
gotoroom 142 ; send through door even tho not really open
addtovariable 5 1 ; should equal 3
donewithturn
END_COMMAND

COMMAND east
flagoff 49
atlocation 180 ; in front of final portal
present 302 ; daar here
present 304 ; odie here
printmessage 227 ; bye-bye
turnflagon 49
removefromgroup 304 ; detach odie
sendtoroom 304 0 ; send odie away
donewithturn
END_COMMAND

COMMAND east
flagoff 49
atlocation 180 ; in front of the portal
not present 304 ; odie not here
printmessage 230 ; can't do it
donewithturn
END_COMMAND

COMMAND east
atlocation 138 ; before riddle room
present 307 ; oz here?
addtogroup 307 ; make sure he goes with others
donewithturn
END_COMMAND

COMMAND east
flagoff 42
atlocation 139 ; in riddle hall
flagon 41 ; oz shown up?
printmessage 194 ; can't go yet
donewithturn
END_COMMAND

COMMAND east
flagoff 40 ; asked before?
present 307 ; oz here?
atlocation 142 ; in altar room
printmessage 168 ; oz speaks
printmessage 170 ; riddle
turnflagon 40
donewithturn
END_COMMAND

COMMAND east
flagoff 28 ; not done this before
flagon 42 ; answered riddle?
atlocation 139  ; riddle room (hall)
present 307 ; oz here
printmessage 160 ; can oz come and play?
turnflagon 28 ; ask only once
donewithturn
END_COMMAND

COMMAND east
atlocation 113 ; in hall?
flagon 23 ; turned?
flagon 24 ; other turned also?
gotoroom 140 ; zip to next room
donewithturn
END_COMMAND

COMMAND east
flagoff 21
atlocation 117 ; in narrow place
printmessage 122 ; scare lizard
sendtoroom 119 ; shoot over to right place
turnflagon 21
END_COMMAND

COMMAND SE
atlocation 38 ; in pool room
present 302 ; daar is here
addtogroup 302 ; add him to group
END_COMMAND

COMMAND SE
atlocation 38 ; in pool room
present 304 ; Odie is here
addtogroup 304 ; add him to group
END_COMMAND

COMMAND south
atlocation 85 ; in front of the Portal
present 305 ; lizards here
removefromgroup 305 ; they won't go in the Portal
turncounteroff 4 ; reset lizard scenario
printmessage 91 ; say that
END_COMMAND


COMMAND south
atlocationgt 148 ; player walks off south end of east/west bridge
atlocationlt 154 ; not too bright!
present 304 ; odie here
present 304
printmessage 228
donewithturn
END_COMMAND



COMMAND south
atlocationgt 148 ; player walks off south end of east/west bridge
atlocationlt 154 ; not too bright!
printmessage 220
removefromgroup 302 ; daar declines
gotoroom 146
killplayer
donewithturn
END_COMMAND



COMMAND south
atlocation 96 ; in museum
counterGT 4 0 ; after liz seen
counterLT 4 10 ; before liz left
printmessage 75 ; don't do it!
donewithturn
END_COMMAND

COMMAND south
atlocation 96 ; museum
counterequals 4 0 ; b4 liz
or 
atlocation 96
counterGT 4 10 ; after liz
printmessage 78 ; door opens just fine
END_COMMAND

COMMAND south
flagoff 12 ; only if not happened before
atlocation 85 ; before portal
counterGT 4 10 ; make sure lizards have left
printmessage 79 ; fireworks
turnflagon 12 ; make sure doesn't repeat message
END_COMMAND

COMMAND South
atlocation 105 ; in front of portal
flagon 16 ; been down to room 107 looking around?
printmessage 104 ; philosophy, yet!
turnflagoff 16 ; don't give message again (borrring)
END_COMMAND

COMMAND pull antenna
flagoff 43 ; not done yet
atlocation 84 ; at quicksand island
printmessage 199 ; you got the wire!
putincurrentroom 283 ; send wire here
getit 283 ; put it in his hand
turnflagon 43
donewithturn
END_COMMAND

COMMAND pull handle
not present 287 ; compartment not here already
atlocation 141 ; construction room
present 276 ; handle here?
printmessage 183 ; open panel
putincurrentroom 287 ; bring open compartment here
plusscore 15
donewithturn
END_COMMAND

COMMAND push flagstone
present 268 ; stone here?
atlocation 145 ; end of stairs?
printmessage 148 ; see!
destroy 268 ; send it away
turnflagon 25 ; stone down
sendtoroom 181 132 ; put door in room
donewithturn
END_COMMAND

COMMAND Push circle
iscarrying 219 ; device
atlocation 63 ; at lb
printmessage 132 ; nothing happens here
donewithturn
END_COMMAND

COMMAND Push circle
iscarrying 219 ; device
atlocation 64 ; in lb
printmessage 132 ; nothing happens here
donewithturn
END_COMMAND

COMMAND Push circle
iscarrying 219 ; device
atlocation 65 ; in lb
printmessage 132 ; nothing happens here
donewithturn
END_COMMAND

COMMAND Push circle
iscarrying 218 ; device
atlocation 63 ; at lb
printmessage 132 ; nothing happens here
donewithturn
END_COMMAND

COMMAND Push circle
iscarrying 218 ; device
atlocation 64 ; in lb
printmessage 132 ; nothing happens here
donewithturn
END_COMMAND

COMMAND Push circle
iscarrying 218 ; device
atlocation 65 ; in lb
printmessage 132 ; nothing happens here
donewithturn
END_COMMAND

COMMAND Push Circle
printmessage 132
donewithturn
END_COMMAND


COMMAND Push door
atlocation 4 ; outside bldg
printmessage 109 ; can't be pushed
donewithturn
END_COMMAND

COMMAND push door
redirectto open door
END_COMMAND

COMMAND push altar
redirectto move altar
END_COMMAND

COMMAND Push Key
atlocation 4 ; outside house
swaplocations 214 215 ; swap red and green atd
plusscore 10
END_COMMAND

COMMAND Push lever 
atlocation 28 ; in the plaza portal
sendtoroom 305 0 ; make sure lizards are sent away
END_COMMAND

COMMAND push lever
atlocation 29 ; footpath portal
present 307 ; OZ is here
removefromgroup 307  ; detach him/her/it
sendtoroom 307 108 ; send to end of path
turnflagon 50 ; set the flag
END_COMMAND

COMMAND Push Lever
ATLOCATION 9 ; at first portal
not iswearing 213 ; and is wearing the suit
printmessage 8 ; everything falls apart
gotoroom 146
removefromgroup 302
removefromgroup 304
killplayer
donewithturn
END_COMMAND

COMMAND Push Lever
ATLOCATION 9 ; at first portal
iswearing 213 ; and is wearing the suit
printmessage 9 ; everything OK
turnflagoff 4 ; tell agt that the air is bad
swaplocations 215 214
gotoroom 24
donewithturn
END_COMMAND

COMMAND Push Lever
atlocationgt 19 ; if player is in a portal
atlocationlt 30 ; somewhere
removefromgroup 307 ; is oz here, detach him
gotorandomroom 20 29 ; send him to room 20 through twenty whatever
donewithturn
END_COMMAND

COMMAND Push Lever
atlocation 104 ; in final portal
printmessage 101 ; final message
plusscore 25
wingame
donewithturn
END_COMMAND

COMMAND Wear lens
iscarrying 205 ; got lens?
not iswearing 213 ; only if not wearing the suit
printmessage 110 ; OK, for a while 
wearit 205 ; put it on
turncounteron 5 ; start counting before have to take it off
donewithturn
END_COMMAND

COMMAND Wear lens
iscarrying 205
iswearing 213 ; go suit on?
printmessage 135 ; don't do it!
donewithturn
END_COMMAND

COMMAND wear suit
present 213 ; if suit present 
wearit 213  ; put it on
turnflagon 1 ;flag on - suit is worn
PRINTMESSAGE 1
donewithturn
END_COMMAND

COMMAND remove suit
iswearing 213 ; if suit is being worn
removeit 213 ; drop suit
getit 213 ; pick it up, don't leave it here!
turnflagoff 1 ; flag 1 off - suit not worn
PRINTMESSAGE 2
donewithturn
END_COMMAND

COMMAND Remove lens
iswearing 205 ; lens?
iswearing 213 ; suit?
printmessage 140 ; small detail
donewithturn
END_COMMAND

COMMAND Remove Battery from Device
iscarrying 219 ; if carrying the active device
swaplocations 219 218 ; then swap device for the inactive one
sendtoroom 216 1 ; send battery to inactive device
printmessage 51
donewithturn
END_COMMAND

COMMAND put key in door
atlocation 4
iscarrying 201
printmessage 250
donewithturn
END_COMMAND

COMMAND put battery in device
flagoff 39
present 216 ; got battery
present 218 ; got device
plusscore 25
turnflagon 39
END_COMMAND


COMMAND put battery in device
iscarrying 218 ; if carrying the inactive device
swaplocations 218 219 ; swap it for the active one
sendtoroom 216 219 ; send the battery with it
printmessage 50
donewithturn
END_COMMAND


COMMAND WHISTLE
PRINTMESSAGE 5
DONEWITHTURN
END_COMMAND

COMMAND HUM
PRINTMESSAGE 5
DONEWITHTURN
END_COMMAND

COMMAND think
randommessage 157 159
donewithturn
END_COMMAND

COMMAND move altar
atlocation 142 ; altar room
not present 302 ; daar not here
printmessage 195 ; can't
donewithturn
END_COMMAND


COMMAND move altar
flagoff 51 ; not open
atlocation 142
present 302 ; daar here
printmessage 173 ; uncovered passage
changepassageway 10 143 ; open up way to stairs
turnflagon 51 ; open flag
donewithturn
END_COMMAND

COMMAND move altar
flagon 51 ; if it's open
atlocation 142 ; and here
present 302 ; daar here
printmessage 179 ; close it
changepassageway 10 0 ; close passage
turnflagoff 51 ; close flag
donewithturn
END_COMMAND

COMMAND Move Skeleton
flagoff 19 ; not done before
atlocation 38 ; in room with it
printmessage 17 ; something devious this way comes
putincurrentroom 218 ; here it is!
plusscore 10
turnflagon 19 ; make sure not happen again
donewithturn
END_COMMAND

COMMAND Move Skeleton
flagon 19 ; if already have the device
atlocation 38 ; in right place
printmessage 116 ; heh, heh
donewithturn
END_COMMAND

; section to add points when player gets a particular item first time


COMMAND get lens
flagoff 32
present 205
plusscore 5
turnflagon 32
END_COMMAND

COMMAND get rope
flagoff 31 
present 224
plusscore 25
turnflagon 31
END_COMMAND


COMMAND get key
flagoff 33
present 201
plusscore 5
turnflagon 33
END_COMMAND

COMMAND get gun
flagoff 34
present 209
plusscore 5
turnflagon 34
END_COMMAND

COMMAND get flashlight
flagoff 35
present 208
plusscore 5
turnflagon 35
END_COMMAND


COMMAND get trash
flagoff 37
present 246
plusscore 10
turnflagon 37
END_COMMAND

COMMAND get shovel
flagoff 38
present 256
plusscore 10
turnflagon 38
END_COMMAND

; end of section to give player points for getting things

COMMAND get rope
present 296 ; tied rope here?
printmessage 236
donewithturn
END_COMMAND

COMMAND get rock
atlocation 121 ; in right room?
printmessage 127 ; sorry
donewithturn
END_COMMAND

COMMAND get sword
atlocation 142 in altar room?
present 264 ; is it here?
getit 264 ; pick it up
swaplocations 264 263 ; swap it
printmessage 156 ; oops, my mistake
donewithturn
END_COMMAND


COMMAND Get Pebble
atlocation 117 ; only if there
present 306 ; pebble here?
printmessage 126 ; move it
donewithturn
END_COMMAND

COMMAND Get trash
atlocation 90 ; in trash room
flagoff 14 ; not gotten trash before
printmessage 90 ; get trash
putincurrentroom 246 ; send it here
iscarrying 246 ; pick it up
turnflagon 14 ; trash can't be picked up twice 
donewithturn
END_COMMAND

COMMAND get Battery 
iscarrying 219 ; if carrying the active device
swaplocations 219 218 ; then swap device for the inactive one
sendtoroom 216 1 ; send battery to player
printmessage 51
donewithturn
END_COMMAND

COMMAND drop rock
iscarrying 223 ; only if player has it
atlocation 41 ; in first pool?
sendtoroom 223 42 ; rock goes to bottom of pool
donewithturn
END_COMMAND

COMMAND drop rock
iscarrying 223 ; got rock
atlocation 48 ; in second pool?
sendtoroom 223 47 ; rock goes to bottom of pool
donewithturn
END_COMMAND

COMMAND Drop Rock
atlocation 42 ; if at bottom of pool
iscarrying 223 ;  and carrying rock
printmessage 20 ; zoooom
dropit 223 ; drop rock
gotoroom 41 ; go up
changepassageway 10 0 ; close passageway
donewithturn
END_COMMAND

COMMAND Drop Rock
atlocation 47 ; at end passage
iscarrying 223 ; carrying it?
printmessage 20 ; zooooom
dropit 223 ; dropped
gotoroom 48 ; zip to surface
changepassageway 10 0 ; close passage
donewithturn
END_COMMAND

COMMAND Drop Rock
atlocationgt 42 ; if in intermediate passage
atlocationlt 47 ; ditto
iscarrying 223 ; and carrying rock
printmessage 21 ; tsk,stk, what *have* you done?
gotoroom 146
killplayer ; drown player
donewithturn
END_COMMAND

COMMAND drop rock in pool
atlocation 38 ; in first pool room
iscarrying 223 ; got rock?
sendtoroom 223 42 ; send it to bottom of pool
donewithturn
END_COMMAND

COMMAND drop rock in pool
atlocation 49 ; in second pool room
iscarrying 223 ; got rock?
sendtoroom 223 47 ; send it to bottom of pool
donewithturn
END_COMMAND

COMMAND drop flare
iscarrying 288 ; got flare?
atlocationgt 148 ; on lighted
atlocationlt 154 ; bridge
printmessage 217 ; show opening
destroy 288 ; dump flare
turncounteroff 7
donewithturn
END_COMMAND

COMMAND drop flare
iscarrying 288 ; got flare?
atlocationgt 157 ; on dark
atlocationlt 163 ; bridge
printmessage 217 ; show opening
destroy 288 ; dump flare
turncounteroff 7
donewithturn
END_COMMAND

COMMAND drop any
atlocationgt 148 ; if player
atlocationlt 154 ; is on bridge
printmessage 206 ; takes a long time to hit bottom (or whatever)
destroynoun ; get rid of object
donewithturn
END_COMMAND

COMMAND drop any
atlocationgt 157 ; if player
atlocationlt 163 ; is on bridge
printmessage 206 ; takes a long time to hit bottom (or whatever)
destroynoun ; get rid of object
donewithturn
END_COMMAND


COMMAND Search Rubble
redirectto examine rubble
END_COMMAND

COMMAND Search trash
redirectto examine trash
END_COMMAND


COMMAND Touch Panel
counterequals 2 0 
atlocation 64 ; first time touch panel
printmessage 23 ; !
tone 440 100
delay 5
printmessage 24 ; !!!?
tone 440 100
tone 1000 200
delay 5
printmessage 25 ; zooooom
tone 2000 200
END_COMMAND

COMMAND Touch Panel
counterequals 2 0 
atlocation 64 ; first time touch panel
gotoroom 65 ; to room 65
dropeverything ; butterfingers....
donewithturn
END_COMMAND

COMMAND Touch Shape
counterequals 2 0
atlocation 65 ; in craft
firstvisittoroom ; first time
printmessage 31 ; goes to mother ship
tone 440 100
changepassageway 12 74 ; opens airlock
swaplocations 227 233 ; change command panel to dead one
donewithturn
END_COMMAND

COMMAND Touch Shape
atlocation 81 ; if in box room
flagoff 10 ; and daar isn't up yet
turnflagon 10 ; flip bit
printmessage 37 ; tell about daar waking up
sendtoroom 302 82 ; send daar to control room
swaplocations 235 237 ; put open box at this location
donewithturn
END_COMMAND



COMMAND Touch Circle with Device
counterequals 2 0 ; hasn't made trip yet
atlocation 63 ; in shrubs
printmessage 26
changepassageway 11 64 ; open enter passage to shuttle
donewithturn
END_COMMAND

COMMAND Touch Circle with Device
counterequals 2 0
atlocation 64 ; in shuttle
printmessage 28 
changepassageway 12 63 ; open exit passage to shrub
donewithturn
END_COMMAND


COMMAND Touch Device to Circle
counterequals 2 0 ; hasn't made trip yet
atlocation 63 ; in shrubs
printmessage 26 
changepassageway 11 64 ; open door to shuttle
donewithturn
END_COMMAND

COMMAND Touch Device to Circle
counterequals 2 0
atlocation 64 ; in shuttle
printmessage 28
changepassageway 12 63 ; opens exit passage
donewithturn
END_COMMAND

COMMAND touch circle
printmessage 133
donewithturn
END_COMMAND

COMMAND Scream
atlocation 73 ;  if in croc room
present 301 ; if croc is here
printmessage 30 ; print screaming head off stuff
swaplocations 301 304 ; get odie here
addtogroup 304 ; add Odie to group
plusscore 10 ; give player some paltry reward
donewithturn
END_COMMAND

COMMAND Scream
atlocation 70 ; in quicksand
present 302 ; if daar here
printmessage 61 ; save him
gotoroom 69 ; back to shore
addtogroup 302 ; put daar back in group
addtogroup 304 ; put odie back in group
END_COMMAND

COMMAND scream
flagoff 27
atlocation 139 ; riddle room , brings oz back
redirectto kick door 
donewithturn
END_COMMAND

COMMAND Enter
counterequals 2 0 ; not made trip yet
atlocation 63 ; at shrub
printmessage 27
gotoroom 64 ; go into shuttle
donewithturn
END_COMMAND

COMMAND Enter 
atlocation 38 ; in room with skeleton and pool
present 302 ; daar is here
printmessage 46 
removefromgroup 302
END_COMMAND

COMMAND Enter
atlocation 38 ; in room with skeleton and pool
present 304 ; and Odie is here
printmessage 67 ; no fool, he!
removefromgroup 304
END_COMMAND

COMMAND Enter
atlocation 38 ; in room with skeleton and pool
iscarrying 223 ; and carrying the rock
printmessage 108 ; neutral bouyancy
gotoroom 41 ; jump in pool
changepassageway 10 42 ; player now can go down
donewithturn
END_COMMAND

COMMAND Enter
atlocation 49 ; in room with rocky ledge
iscarrying 223 ; and carrying the rock
printmessage 108 ; neutral bouyancy
gotoroom 48 ; jump in pool
changepassageway 10 47 ; player now can go down
donewithturn
END_COMMAND

COMMAND Throw rock at thing
present 300 ; thing here?
iscarrying 223 ; got rock?
printmessage 33 ; squish
swaplocations 300 234
dropit 223
donewithturn
END_COMMAND

COMMAND Throw Rock At Wall
atlocation 102 ; in right place?
iscarrying 223 ; got it?
printmessage 107 ; bounce....
donewithturn
END_COMMAND

COMMAND attack daar
present 302
randommessage 240 245
donewithturn
END_COMMAND

COMMAND attack odie
present 304
randommessage 240 245
donewithturn
END_COMMAND

COMMAND attack OZ
present 307
randommessage 240 245
donewithturn
END_COMMAND

COMMAND kill daar
present 302
randommessage 240 245
donewithturn
END_COMMAND

COMMAND kill odie
present 304
randommessage 240 245
donewithturn
END_COMMAND

COMMAND kill OZ
present 307
randommessage 240 245
donewithturn
END_COMMAND


COMMAND Kill thing with rock
redirectto throw rock at thing
donewithturn
END_COMMAND

COMMAND climb tree
atlocation 69 ; at edge of quicksand
printmessage 62 ; can't
END_COMMAND

COMMAND climb rope
atlocation 69
iscarrying 239
or
atlocation 84
iscarrying 239
printmessage 238
donewithturn
END_COMMAND


COMMAND climb down rope
present 224 ; rope here
flagon 47
or
present 224
flagon 48
redirectto down
END_COMMAND

COMMAND swing on rope
atlocation 69 ; at edge
iscarrying 239 ; carrying end of rope
removefromgroup 302 ; dump daar
removefromgroup 304 ; dump odie
printmessage 64
gotoroom 84
donewithturn
END_COMMAND

COMMAND swing on rope
atlocation 84 ; at other edge
iscarrying 239 ; carrying end
printmessage 65
gotoroom 69 ; other side of q-sand
addtogroup 302
addtogroup 304
swaplocations 239 224 ; get rest of rope back 
putincurrentroom 245 ; put short branch here
donewithturn
END_COMMAND

COMMAND swing on rope
atlocation 185 ; on rope but at wrong place
printmessage 223 ; go ahead and swing
donewithturn
END_COMMAND

COMMAND swing on rope
atlocation 184 ; on rope at right place
printmessage 226
donewithturn
END_COMMAND

COMMAND Shoot ANY
iscarrying 209 ; carrying gun?
islocated 216 209 ; battery in gun?
printmessage 68 ; make funny noise
donewithturn
END_COMMAND

COMMAND Shoot ANY
iscarrying 209 ; got gat?
not islocated 216 209 ; battery not in gun
printmessage 69 ; nothing happens
donewithturn
END_COMMAND

COMMAND dig any
not present 273 ; passage not open yet
atlocation 119 ; is he here?
iscarrying 256 ; got shovel?
printmessage 123 ; dig, dug
changepassageway 3 120 ; open it
putincurrentroom 273 ; put passage description in room
donewithturn 
END_COMMAND

COMMAND dig any
atlocation 119 ; in passage location
present 273 ; passage already open
iscarrying 256 ; got shovel
printmessage 231 ; already done it!
donewithturn
END_COMMAND

COMMAND dig any
atlocation 102 ; in ice room
iscarrying 256 ; got shovel?
printmessage 125 ; not in ice
donewithturn
END_COMMAND

COMMAND dig any
atlocation 94 ; in sand dunes
or
atlocation 89 ; in other sand dunes
printmessage 129
donewithturn
END_COMMAND

COMMAND dig any
iscarrying 256 ; shovel?
printmessage 121 ; har, har
donewithturn
END_COMMAND

COMMAND dig any
not iscarrying 256 ; not got tool
printmessage 134 ; need tool
donewithturn
END_COMMAND

COMMAND read markings
atlocation 116
printmessage 128
donewithturn
END_COMMAND

COMMAND open knife
iscarrying 277
or
iscarrying 278
or
iscarrying 279
or
iscarrying 280
printmessage 191 ; one at a time!
donewithturn
END_COMMAND

COMMAND open blade
iscarrying 263
swaplocations 263 280
printmessage 189 ; blade is out
donewithturn
END_COMMAND

COMMAND open corkscrew
iscarrying 263
swaplocations 263 278
printmessage 187 ; corkscrew is out
donewithturn
END_COMMAND

COMMAND open scissors
iscarrying 263
swaplocations 263 277
printmessage 186 ; scissors are out
donewithturn
END_COMMAND

COMMAND open opener
iscarrying 263
swaplocations 263 279
printmessage 188 ; ready to open bottles!
donewithturn
END_COMMAND


COMMAND open door
flagoff 26 ; first time
atlocation 139 ; in riddle hall
printmessage 150 ; wait
turnflagon 26 ; one-shot
putincurrentroom 307 ; zap OZ in
turncounteron 6 ; start counting turns
turnflagon 41 ; flag to keep player in room until he answers
donewithturn
END_COMMAND

COMMAND open door
atlocation 139 ; in riddle hall
redirectto kick door
donewithturn
END_COMMAND

COMMAND open door
atlocation 4 ; door with blue hole
printmessage 248 ; locked
donewithturn
END_COMMAND

COMMAND open suit
present 213 ; only blue suit around
not present 203 ; raggedy suit not here
redirectto remove suit
END_COMMAND


COMMAND turn ornament
nounisnumber 266
atlocation 111 ; at porch
printmessage 144 ; click
toggleflag 24 
donewithturn
END_COMMAND

COMMAND turn ornament
nounisnumber 265
atlocation 111 ; at porch
printmessage 143 ; click
toggleflag 23
donewithturn
END_COMMAND

COMMAND oz
printmessage 180 ; not complete sentence
donewithturn
END_COMMAND

COMMAND oz, no
atlocation 139 ; in riddle room
present 307 ; oz here
not iscarrying 263 ; not got knife
countergt 6 3 ; has asked if want to try riddles
printmessage 153 ; take a hike
destroy 307 ; send oz away
turnflagoff 41 ; let him leave
donewithturn
END_COMMAND

COMMAND oz, yes
variableequals 5 0 ; initiate sequence
atlocation 139 ; riddle room?
present 307 ; oz here
not iscarrying 263 ; don't have s-a knife
countergt 6 3 ; counter going?
printmessage 155 ; give chance to back out
addtovariable 5 1 ; increment - should now equal 1
donewithturn
END_COMMAND

COMMAND oz, yes
variableequals 5 1 
atlocation 139
present 307
not iscarrying 263
printmessage 169 ; huh? never happened before
addtovariable 5 1 ; should now equal 2
donewithturn
END_COMMAND

COMMAND oz, yes
atlocation 139
present 307
iscarrying 263 ; got it?
flagon 28 ; ask to come
printmessage 161 ; thanks
addtogroup 307 ; add oz to group
donewithturn
END_COMMAND

COMMAND oz, no
atlocation 139
present 307
iscarrying 263 ; knife
flagon 28 ; asked to come
printmessage 162 ; tsk
minusscore 25 ; serves you right
destroy 307 ; get rid of the poor thing
donewithturn
END_COMMAND

COMMAND oz, candle
flagoff 42 ; if not answered before
changepassageway 3 139 ; open it!
printmessage 171 ; congrats
turnflagon 42
plusscore 25 
donewithturn
END_COMMAND

COMMAND kick door
flagoff 27
atlocation 139 ; in riddle room
not iscarrying 263 ; knife
not present 307 ; oz not here
countergt 6 5 ; oz *was* here
printmessage 154 ; came crawling back, eh?
putincurrentroom 307 ; bring back oz
turnflagon 27
donewithturn
END_COMMAND

COMMAND kick door
printmessage 200 ; Bang. Feel better?
donewithturn
END_COMMAND

COMMAND hit door
redirectto kick door
donewithturn
END_COMMAND


COMMAND unscrew sign with knife
atlocation 141 ; in cons. room
not iscarrying 279 ; not carrying screwdriver
printmessage 203 ; are you crazy?
donewithturn
END_COMMAND

COMMAND unscrew sign with knife
atlocation 141 ; in construction room
iscarrying 279 ; got right knife?
printmessage 185 ; ok, you open the panel
swaplocations 274 275 ; bring open recess here
donewithturn
END_COMMAND

COMMAND unscrew sign with opener
redirectto unscrew sign with knife
donewithturn
END_COMMAND

COMMAND close knife
iscarrying 277
or
iscarrying 278
or
iscarrying 279
or
iscarrying 280
printmessage 190
destroy 277
destroy 278
destroy 279
destroy 280
putincurrentroom 263
getit 263
donewithturn
END_COMMAND

COMMAND close scissors
redirectto close knife
END_COMMAND

COMMAND close opener
redirectto close knife
END_COMMAND

COMMAND close corkscrew
redirectto close knife
END_COMMAND

COMMAND close blade
redirectto close knife
END_COMMAND

COMMAND give rope to daar
redirectto show rope to daar
donewithturn
END_COMMAND

COMMAND tie rope to bridge
atlocation 153 ; west end of bridge
iscarrying 224 ; got rope
printmessage 221 ; rope tied to bridge
turnflagon 47 ; set flag
changepassageway 10 184
dropit 224
swaplocations 224 296 ; zip rope
donewithturn
END_COMMAND

COMMAND tie rope to bridge
atlocationgt 148 ; on
atlocationlt 153 ; the 
printmessage 221
turnflagon 48
changepassageway 10 185
dropit 224
swaplocations 224 296 ; get fixed rope
donewithturn
END_COMMAND

COMMAND untie rope
present 296 ; is it even here?
atlocationgt 148 ; on
atlocationlt 154 ; the bridge
printmessage 222 ; ok, it is untied
swaplocations 296 224 ; bring back rope
getit 224
turnflagoff 47
turnflagoff 48
changepassageway 10 0
donewithturn
END_COMMAND

COMMAND pick lock with wire
atlocation 177 ; in cavern with door
iscarrying 283 ; got wire?
printmessage 229 ; OK, it's unlocked
swaplocations 291 292 ; swap locked door for open one
changepassageway 3 178 ; open doorway to tunnel
plusscore 20
donewithturn
END_COMMAND

COMMAND unlock door with wire
redirectto pick lock with wire
donewithturn
END_COMMAND

COMMAND unlock door with key
atlocation 4 ; door with blue hole
iscarrying 201 ; got key
printmessage 250 ; not that simple
donewithturn
END_COMMAND

COMMAND unlock door
atlocation 4 ; door with blue hole
printmessage 249 ; with what?
donewithturn
END_COMMAND


rem *******************  debug stuff

COMMAND ziproom 
getnumberinput 0 0 ; ask for a number
numberequals 84
gotoroom 84
END_COMMAND

COMMAND ziproom 
numberequals 85
gotoroom 85
END_COMMAND

COMMAND ziproom 
numberequals 134
gotoroom 134
END_COMMAND

COMMAND ziproom 
numberequals 74
gotoroom 74
END_COMMAND

COMMAND ziproom 
numberequals 105
gotoroom 105
END_COMMAND

COMMAND ziproom 
numberequals 62
gotoroom 62
END_COMMAND

COMMAND ziproom 
numberequals 37
gotoroom 37
END_COMMAND

COMMAND ziproom 
numberequals 2
gotoroom 2
END_COMMAND

COMMAND ziproom 
numberequals 103
gotoroom 103
END_COMMAND

COMMAND ziproom
numberequals 148
gotoroom 148
END_COMMAND

COMMAND ziproom
numberequals 143
gotoroom 143
END_COMMAND

COMMAND ziproom
numberequals 145
gotoroom 145
END_COMMAND

COMMAND ziproom 
numberequals 164
gotoroom 164
END_COMMAND

COMMAND ziproom 
numberequals 111
gotoroom 111
donewithturn
END_COMMAND

COMMAND zipobj
getnumberinput 0 0
numberequals 205 ; lens
putincurrentroom 205
END_COMMAND

COMMAND zipobj
numberequals 208 ; flashlight
putincurrentroom 208
END_COMMAND

COMMAND zipobj
numberequals 216 ; battery
putincurrentroom 216
END_COMMAND

COMMAND zipobj
numberequals 218 ; device w/o battery
putincurrentroom 218
END_COMMAND

COMMAND zipobj
numberequals 223 ; rock
putincurrentroom 223
END_COMMAND

COMMAND zipobj
numberequals 224 ; rope
putincurrentroom 224
END_COMMAND

COMMAND zipobj
numberequals 256 ; shovel
putincurrentroom 256
END_COMMAND

COMMAND zipobj
numberequals 263 ; knife
putincurrentroom 263
END_COMMAND

COMMAND zipobj
numberequals 289 ; flare
putincurrentroom 289
END_COMMAND


COMMAND zipobj
numberequals 283 ; wire
putincurrentroom 283
donewithturn
END_COMMAND

COMMAND zipcreat
getnumberinput 0 0
numberequals 302 ; daar
putincurrentroom 302 
addtogroup 302
END_COMMAND

COMMAND zipcreat
numberequals 304 ; odie
putincurrentroom 304
addtogroup 304
END_COMMAND

COMMAND zipcreat
numberequals 307 ; OZ
putincurrentroom 307
donewithturn
addtogroup 307
END_COMMAND




REM END ****************************

END OF FILE
