#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>


// Allow the use of a switch to flip between normal game names and copy paranoid game names.
// Trademark searches were done using the free trademark tool at: 
//     http://www.mycorporation.com/trademarks/onlinesearch.htm
copyparanoid : object

	//
	// abandoned or nonexistent trademarks
	//

	// The term "Duck Hunt" did not come up at all in the trademark search.
	name_duckHunt_real = 'Duck Hunt'
	name_duckHunt_fake = 'Goose Hunt'
	name_duckHunt = name_duckHunt_fake
	
	// abandoned trademark, so I can use it.
	name_pong_real = 'Pong'
	name_pong_fake = 'Ping'
	name_pong = name_pong_fake

	// This trademark exists, but it applies only to Space Invaders machines (coin operated or not)
	// and doesn't apply to software that's not part of a specific video game machine.
	name_spaceInvaders_real = 'Space Invaders'
	name_spaceInvaders_fake = 'Space Intruders'
	name_spaceInvaders = name_spaceInvaders_fake
	

	
	//
	// current valid trademarks
	//
	
	// Tetris is a registered trademark of Elorg Corporation
	name_tetris_real = 'Tetris'
	name_tetris_fake = 'Quad Blocks'
	name_tetris = name_tetris_fake

	// Frogger is a registered trademark of KONAMI CO., LTD. CORPORATION.
	name_frogger_real = 'Frogger'
	name_frogger_fake = 'Toader'
	name_frogger = name_frogger_fake
		
		
	beParanoid() {
		name_tetris = name_tetris_fake;
		name_frogger = name_frogger_fake;
		name_duckHunt = name_duckHunt_fake;
		name_pong = name_pong_fake;
		name_spaceInvaders = name_spaceInvaders_fake;
	}
	
	dontBeParanoid() {
		name_tetris = name_tetris_real;
		name_frogger = name_frogger_real;
		name_duckHunt = name_duckHunt_real;
		name_pong = name_pong_real;
		name_spaceInvaders = name_spaceInvaders_real;
	}
;



stopPlayVar : object {
	numGamesPlayed = 0
}

class VideoGameMachine : Heavy
	dobjFor(Play) {
		verify() {
			if(!powerSwitch.isOn) {
				"The machine doesn't appear to be powered on. ";
				exit;
			}
			
			if(creditsRemaining < creditsRequired) {
				"<<creditsRemaining>> credit<<creditsRequired!=1?'s':''>> remaining.
				This game requires <<creditsRequired>>
				credit<<creditsRequired!=1?'s':''>> to play. ";
				exit;
			}
		}
		
		action() {
			if(whenPlayedMsg!=nil) {
				"<<whenPlayedMsg>>";
			} else {
				if(whenPlayed!=nil) {
//					if(stopPlayVar.numGamesPlayed < 3) {
						"Remember that you can <FONT color=red><q>stop playing</q></FONT> at any time. ";
						++stopPlayVar.numGamesPlayed;
//					} else {
//						"Remember that you can <q>stop playing</q> at any time. ";
//					}
					replaceAction(TravelVia, whenPlayed);
				} else {
					"It doesn't seem to be working. ";
				}
			}
		}
	}

/*	
	iobjFor(PutIn) {
		action() {
			nestedAction(PutIn,gDobj,tokenSlot);
		}
	}
*/
	
	isListed = true

	// This is the number of credits currently in the game.
	creditsRemaining = 0
	// This is the number of credits required to play the game.
	creditsRequired = 0
	
	machine = self
	

	learnTrueName() {
		if(properName!=nil) {
			if(!realNameLearned) {
				realNameLearned = true;
				
				name = name +' ('+ properName +')';
				initializeVocabWith(properName);
			}
		}
	}
	
	realNameLearned = nil
	properName = nil
	internalName = nil
	
	wasWon = nil
	
	// If specified, only this is called when the player tries to play this machine.
	whenPlayedMsg = nil
	
	credits() {
		if(creditsName!=nil) {
			if(realNameLearned) {
				"<<creditsName>>";
			} else {
				"*** NOT YET DISCOVERED ***";
			}
		}
	}
;

/*
class VideoGameMachineTokenSlot : Component
	iobjFor(PutIn) {
		verify() {
			if(gDobj!=nil && !gDobj.ofKind(TokenType)) {
				"You can't put that in there.";
				exit;
			}
		}
//		check() {}
		action() {
			if(powerSwitch.isOn) {
				"The token goes into the machine with a clink.";
				gDobj.moveInto(nil);
				if(machine.creditsRemaining==nil)
					machine.creditsRemaining = 1;
				else
					++machine.creditsRemaining;
				exit;
			} else {
				"The token goes into the machine with a clink, but it comes back out into the token return. ";
				gDobj.moveInto(tokenReturn);
				exit;
			}
		}
	}
;

class VideoGameMachineTokenReturn : RestrictedContainer, Component
	validContents = [token]
;
*/

class TokenType : Thing 'token/coin*tokens*coins' 'token'
	"This is a token for playing video games. It has a picture of a happy smiling Pac-Man on it
	giving you the thumbs up. How inviting! "
	isEquivalent = true
	collectiveGroup = tokenGroup
;

tokenGroup : CollectiveGroup 'token*tokens' 'tokens'
	"These are some tokens for playing video games. They all have pictures of a happy smiling
	Pac-Man on them which is giving you the thumbs up. How inviting! "
;

token : TokenType;


class WinningTicket : Thing, InitObject
	execute {
		name=whichMachine.identifier +' ticket';
		initializeVocabWith( whichMachine.identifier +' ticket*tickets' );
	}
	desc = "This is {a dobj/he} which you got for winning <<whichMachine.properName>>. "
	
	execBeforeMe = [adv3LibInit]
	
	winTicket() {
		if(!hasBeenWon) {
			moveInto(gPlayerChar);
			"A new ticket has appeared in your pocket. ";
			hasBeenWon = true;
		}
	}
	
	hasBeenWon = nil
	
	dobjFor(Feed) {
		verify() {}
		check() {}
		action() {
			if(gPlayerChar.canSee(highscoreBoard)) {
				replaceAction(PutIn,gDobj,highscoreBoard);
			} else {
				"There's nothing here that you can feed the ticket into. ";
				exit;
			}
		}
	}

	// This doesn't need to do anything. It just makes it ok for the board to handle the feeding.	
	dobjFor(FeedInto) {
		verify() {}
		check() {}
		action() {}
	}
;



class VideoGameMachinePortal : VideoGameMachine, InitObject
	execute {
		name=identifier +' video game machine';
		initializeVocabWith( identifier +' video game videogame machine*games*videogames*machines' );
	}

	location = arcade
	
	desc {
		machineDesc;
	
		if(powerSwitch.isOn) {
			"It has a bright screen that's inviting you to play this game. ";
			if(creditsRequired==0) {
				"It appears to be in free play mode. ";
			}
		} else {
			"It is a machine bereft of life. No one likes to see a lifeless game machine.
			On is the state in which all game machines should always be. ";
		}
	}
	
	execBeforeMe = [adv3LibInit]
	
	machineDesc = "This is {a dobj/he}. It doesn't have any identifying markings. "


	dobjFor(TurnOn) {
		verify() {}
		check() {}
		action() {
			"You don't need to turn it on or off. It is controlled by a central power switch. ";
		}
	}
	dobjFor(TurnOff) asDobjFor(TurnOn)
;




/*
OTHER COLORS TO USE:
	white
	maroon
	purple
	fuchsia
	lime
	olive
	yellow
	navy
	teal
	beige
	almond
	bisque
	violet
	coral
	cyan
	salmon
	pink
	ivory
	khaki
	lavender
	orchid	
*/


videoGameGlobalInfo : PreinitObject {
	countGamesInBasement = 0
	countGamesInArcadeUpstairs = 0

	execute {
		{
			local cur = firstObj(VideoGameMachinePortal);
			while(cur != nil) {
				if(cur.location==arcadeBasement)
					++videoGameGlobalInfo.countGamesInBasement;
				else if(cur.location==arcade)
					++videoGameGlobalInfo.countGamesInArcadeUpstairs;
				
				cur = nextObj(cur,VideoGameMachinePortal);
			}
		}
	}
	execBeforeMe = [adv3LibPreinit]
}

