/* $Id: daemon.t 1.8 2001/08/16 19:18:52 mol Exp $
 * --------------------------------------------------------------
 * Music daemon function for Aayela 1.2
 *
 * This file is a part of the source distribution of
 *
 * Aaylea - an Interactive Vision, release 1.2
 *
 * Copyright 1996-2001 by Magnus Olsson (mol@pobox.com).
 * All rights reserved.
 *
 * THIS CODE MAY BE DISTRIBUTED FREELY AS LONG AS IT IS NOT MODIFIED
 * IN ANY WAY, NO FEE IS CHARGED EXCEPT FOR DISTRIBUTION COST, AND
 * THIS COPYRIGHT NOTICE IS NOT ALTERED OR DELETED.
 * You may use the code, classes and algorithms as part of your
 * own programs as long as the following conditions are met:
 *
 * 1) No use of the characters, plot or text of the game
 *    "Aayela" are used in the derivative work (i.e. you may
 *    write another game set in darkness using this code, but
 *    you may not publish an "improved" version of Aayela)
 *    without the author's permission.
 * 2) The use of this code, and its origin, are acknowledged in 
 *    the derivative work.
 *
 * This version is tested with the Linux TADS compiler v2.5.5
 * --------------------------------------------------------------
 */

music : item, floatingItem
    noun = 'music' 'chord' 'harmony' 'melody' 'tune'
    sdesc = "music"

    state = 0
    nomessage = nil 

    darkReachable(verb, actor) = {
        return true;
    }
    
    // Time spent in cave
    cavetime = 0
    // Time spent in cave since music got hopeful
    cavetime2 = 0
    
    // Daemon started first time player enters cave.
    daemon = {
        local loc := outerLoc(Me);
	local incave := isclass(loc, caveroom);

	if (incave) {
  	    ++self.cavetime;
            if (self.cavetime = 10 and self.state < 10) {
	        self.state := 10;
		"\bIt has started like the whisper of a breeze;
		only after a while do you realize that the music
		has started again. A single chord hovers in the 
		air around you,	incredibly faint, just above the 
		limit of audibility.\n";
		self.nomessage := nil; // Just in case...
		return;
	    }
	}
	
	if (self.nomessage) {
	    // The last command printed something about the music,
	    // so there's no reason to go on about it.
	    self.nomessage := nil;
	    return;
	}
	
	switch (self.state) {
 	    case 10:
	    case 11:
	        if (incave)
                    "\bStrange, unearthly music fills the air around you.\n";
		else
		    "\bThe music can still be heard from somewhere far
		    away in the dark.\n";
	        break;
		
	    case 12:      
	        if (not incave or ++self.cavetime2 < 4) {
	            "\bThe air around you is filled with music; an 
		    almost tangible texture of sound.\n";
		    break;
		}
		"\bThe mood of the music suddenly changes: the
		sadness and resignation are gone, the feeling of hope
		intensifies and is joined by voices of joy and resolution,
		calling out wordlessly to you, compelling you 
		to join them.\b
		For the first time, you can clearly locate the source
		of the music: a point at the centre of the vast darkness.
		You find yourself drawn closer to it, step by step,
		the music growing more and more intense until you can almost
		\(see\) it.\b
		And then you realize that you really are seeing something:
		a tiny, bluish spark right in front of you, pulsating in
		time to the music.\b
		
		The music ends in a triumphant cadence,
		leaving you in silence once again; only the spark of light 
		remains.\b";
		
		setit(stone);
		self.state := 4;
		unnotify(self, &daemon);

		spark.isActive := true;
		stone.moveInto(cave);
		Me.travelTo(cave);

		break;
	    }
    }	    

    
    // The following method is called when the hero plays the whistle.
    respond(location) = {
        local meloc := outerLoc(Me);
        self.nomessage := true;
	switch (self.state) {
	    case 1:    
		"\bYou are startled by the response:
		from somewhere in the darkness, strange music can be
		heard; music of such beauty that you forget
		your tune and stop playing; not really a melody, but
		harmony ever
		modulating, shimmering in your ears unlike any human voice,
		yet \(singing\), wordlessly: a song of infinite sadness, of
		times beyond comprehension...
		\bFinally, it slowly fades into silence; you 
		release your breath, realizing that you've been holding it 
		for quite some time. ";

		self.state := 2;
		break;
		
	    case 2:
	        if (isclass(location, caveroom)) {
 	            "As soon as you start playing, there is a response:
		    music that starts out infinitely soft, but then
		    grows louder, more definite, more urging, as if someone 
		    was encouraging you to continue playing. ";
		    self.state := 11;
		}
		else {
	            "You play a few notes on the whistle, and again the 
		    strange music responds from somewhere far away in 
		    the dark: a single, lonesome chord of sadness. ";
		    self.state := 3;
		    notify(self, &turnoff, 2);
		}
		break;
		
	    case 3: 
	    case 12:
	        "You start playing along with the music, but it feels
		inappropriate; like whistling to a hymn in chapel.";
	        break;

	    case 4:
	        if (meloc = outerLoc(heliax))
		    heliax.musicresponse;
		else if (meloc = outerLoc(stone))
		    stone.musicresponse;
		else 
	            "You play a few notes on your pipe, hoping that 
		    the strange music will return. 
		    Nothing happens, though.";
		break;
		
	    case 10:
	        "As soon as you start playing, the music changes: it 
		gets louder, more definite, more urging, as if someone 
		was encouraging you to continue playing. ";
		self.state := 11;
		break;
		
	    case 11: 
	        "The music gets louder, swelling out until it fills
		the air around you; an almost tangible texture of sound.
		And now there is rhythm to it, and melody: an oddly
	        hopeful melody against a backdrop of sadness and despair.";
		
		self.state := 12;
		break;
	}
    }

    doListento(actor) = {
        local pos := outerLoc(actor);
	
	self.nomessage := true;
        switch (state) {
	    case 0:
	        "You can't hear any music here.";
		break;

	    case 3:
		if (not isclass(pos, caveroom)) {
		    "A faint chord, like a whispered question, from 
		    somewhere far away in the dark.";
		    break;
		}
		// else fall through

	    case 10:
	        "It's all around you: an incredible faint chord, like
		a whispered question.";
		break;

	    case 11:
	        "The music is still just a single chord, but it seems to
		be urging you on, to join it with more music.";
		break;
		
	    case 12:
	        "The air around you is filled with an almost tangible texture 
		of sound. There is rhythm to it, and melody: a melody that
		speaks not just of sadness, but of hope.";
		break;
		
	    default:
                "You can't hear it right now. ";
 	}
    }
    
    turnoff = {
        if (self.state = 3) {
            "\bThe music stops again.\n";
	    self.state := 2;
	}
    }
        		 
    verDoListento(actor) = { }
    doSynonym('Listento') = 'Inspect'
    
    verDoFollow(actor) = {
        "You must tell me in which direction you want to go. ";
    }

    dobjGen(a, v, i, p) = {
        if (v <> inspectVerb and v <> listenVerb and v <> followVerb) {
            "I don't know how to << v.sdesc >> << self.thedesc >>.";
            exit;
        }
    }
    iobjGen(a, v, d, p) = { 
        "How could you << v.sdesc >> anything << p.sdesc >> ";
	"<< self.thedesc >>?";
        exit;
    }
    location = {
        return Me.location;
    }
;

modify listenVerb
    action(actor) = {
        if (music.state < 3 or music.state = 4)
	    "You strain your ears, trying to pick up some sound, but
	    all you can hear is your own pulse. ";
	else {
	    "(to the music)\n";
	    music.doListento(actor);
	}
    }
;
    
