/* Room processors for DUNGEON */

/* COPYRIGHT 1980, 1990, INFOCOM COMPUTERS AND COMMUNICATIONS, CAMBRIDGE MA. */
/* ALL RIGHTS RESERVED, COMMERCIAL USAGE STRICTLY PROHIBITED */
/* WRITTEN BY R. M. SUPNIK */
/* Translated from Fortran to C by Andrew Plotkin <erkyrath@netcom.com>
   on 10/4/98. */

/* 11-Sep-94     RMS     Fixed bugs in Tree, Slide, Cave2, Magnet, object */
/*                       substitution.  Added Puzzle Anteroom. */
/* 30-Jun-92     RMS     Changed file names to lower case. */

#include "glk.h"
#include "miscfort.h"
#include "funcs.h"
#include "commons.h"

/* RAPPLI- Room routines */

/* Declarations */

/* Subroutine */ int rappli_(integer *ri)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    logical f;
    integer i__;
    integer j;


/* Functions and data */


    if (*ri == 0) {
        return 0;
    }
/* return if naught. */
    switch (*ri) {
        case 1:  goto L1000;
        case 2:  goto L2000;
        case 3:  goto L3000;
        case 4:  goto L4000;
        case 5:  goto L5000;
        case 6:  goto L6000;
        case 7:  goto L7000;
        case 8:  goto L8000;
        case 9:  goto L9000;
        case 10:  goto L10000;
        case 11:  goto L11000;
        case 12:  goto L12000;
        case 13:  goto L13000;
        case 14:  goto L14000;
        case 15:  goto L15000;
        case 16:  goto L16000;
        case 17:  goto L17000;
        case 18:  goto L18000;
        case 19:  goto L19000;
        case 20:  goto L20000;
        case 21:  goto L21000;
        case 22:  goto L22000;
        case 23:  goto L23000;
        case 24:  goto L24000;
        case 25:  goto L25000;
        case 26:  goto L26000;
        case 27:  goto L27000;
        case 28:  goto L28000;
        case 29:  goto L29000;
        case 30:  goto L30000;
        case 31:  goto L31000;
        case 32:  goto L32000;
        case 33:  goto L33000;
        case 34:  goto L34000;
        case 35:  goto L35000;
        case 36:  goto L36000;
        case 37:  goto L37000;
        case 38:  goto L38000;
        case 39:  goto L39000;
        case 40:  goto L40000;
        case 41:  goto L41000;
        case 42:  goto L42000;
        case 43:  goto L43000;
        case 44:  goto L44000;
        case 45:  goto L45000;
        case 46:  goto L46000;
        case 47:  goto L47000;
        case 48:  goto L48000;
        case 49:  goto L49000;
        case 50:  goto L50000;
        case 51:  goto L51000;
        case 52:  goto L52000;
        case 53:  goto L53000;
        case 54:  goto L54000;
        case 55:  goto L55000;
        case 56:  goto L56000;
        case 57:  goto L57000;
        case 58:  goto L58000;
        case 59:  goto L59000;
        case 60:  goto L60000;
        case 61:  goto L61000;
        case 62:  goto L62000;
        case 63:  goto L63000;
        case 64:  goto L64000;
    }
    bug_(&c__1, ri);
/* RAPPLI, PAGE 2 */

/* R1--  East of house */

L1000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    i__ = 13;
/* assume closed. */
    if ((objcts_1.oflag2[c__63 - 1] & 8) != 0) {
        i__ = 12;
    }
/* if open, ajar. */
    rspsub_(&c__11, &i__);
/* describe. */
    return 0;

/* R2--  Kitchen */

L2000:
    if (prsvec_1.prsa != 119) {
        goto L2100;
    }
/* look? */
    i__ = 13;
/* assume closed. */
    if ((objcts_1.oflag2[c__63 - 1] & 8) != 0) {
        i__ = 12;
    }
/* if open, ajar. */
    rspsub_(&c__14, &i__);
/* describe. */
    return 0;

L2100:
    if (prsvec_1.prsa != 6 || findex_1.deadf || ! findex_1.broc1f || 
            findex_1.broc2f) {
        return 0;
    }
    cevent_1.cflag[24] = TRUE_;
/* send for brochure. */
    cevent_1.ctick[24] = 3;
    return 0;

/* R3--  Living Room */

L3000:
    if (prsvec_1.prsa != 119) {
        goto L3500;
    }
/* look? */
    i__ = 15;
/* assume no hole. */
    if (findex_1.magicf) {
        i__ = 16;
    }
/* if magicf, cyclops hol */
    rspeak_(&i__);
/* describe. */
    i__ = findex_1.orrug + 17;
/* assume initial state. */
    if ((objcts_1.oflag2[c__66 - 1] & 8) != 0) {
        i__ += 2;
    }
/* door open? */
    rspeak_(&i__);
/* describe. */
    return 0;

/* Not a look word, reevaluate trophy case. */

L3500:
    if (prsvec_1.prsa != 132 && (prsvec_1.prsa != 144 || prsvec_1.prsi != 9)) 
            {
        return 0;
    }
/* take or put in? */
    advs_1.ascore[play_1.winner - 1] = play_1.rwscor;
/* score trophy case. */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* retain raw score as we */
        j = i__;
/* find out if in case. */
L3550:
        j = objcts_1.ocan[j - 1];
/* trace ownership. */
        if (j == 0) {
            goto L3600;
        }
        if (j != 9) {
            goto L3550;
        }
/* do all levels. */
        advs_1.ascore[play_1.winner - 1] += objcts_1.otval[i__ - 1];
L3600:
        ;
    }
    scrupd_(&c__0);
/* see if endgame trig. */
    return 0;
/* RAPPLI, PAGE 3 */

/* R4--  Cellar */

L4000:
    if (prsvec_1.prsa != 119) {
        goto L4500;
    }
/* look? */
    rspeak_(&c__21);
/* describe cellar. */
    if ((objcts_1.oflag2[c__66 - 1] & 8) != 0) {
        rspeak_(&c__623);
    }
/* describe trap door if */
    return 0;

L4500:
    if (prsvec_1.prsa != 6) {
        return 0;
    }
/* walkin? */
    if ((objcts_1.oflag2[65] & 12) != 8) {
        return 0;
    }
    objcts_1.oflag2[65] = (objcts_1.oflag2[65] | 4) & -9;
    rspeak_(&c__22);
/* slam and bolt door. */
    return 0;

/* R5--  Grating Room */

L5000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    rspeak_(&c__23);
/* describe. */
    i__ = 24;
/* assume locked. */
    if (findex_1.grunlf) {
        i__ = 26;
    }
/* unlocked? */
    if ((objcts_1.oflag2[c__65 - 1] & 8) != 0) {
        i__ = 25;
    }
/* open? */
    rspeak_(&i__);
/* describe grate. */
    return 0;

/* R6--  Clearing */

L6000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    rspeak_(&c__27);
/* describe. */
    i__ = 0;
/* assume no grating. */
    if (findex_1.rvclr != 0) {
        i__ = 28;
    }
/* leaves moved? */
    if ((objcts_1.oflag2[c__65 - 1] & 8) != 0) {
        i__ = 29;
    }
/* grate open? */
    rspeak_(&i__);
/* describe grate. */
    return 0;
/* RAPPLI, PAGE 4 */

/* R7--  Reservoir south */

L7000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    i__ = 31;
/* assume full. */
    if (findex_1.lwtidf) {
        i__ = 32;
    }
/* if low tide, empty. */
    rspeak_(&i__);
/* describe. */
    rspeak_(&c__33);
/* describe exits. */
    return 0;

/* R8--  Reservoir */

L8000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    i__ = 34;
/* assume full. */
    if (findex_1.lwtidf) {
        i__ = 35;
    }
/* if low tide, emtpy. */
    rspeak_(&i__);
/* describe. */
    return 0;

/* R9--  Reservoir north */

L9000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    i__ = 36;
/* you get the idea. */
    if (findex_1.lwtidf) {
        i__ = 37;
    }
    rspeak_(&i__);
    rspeak_(&c__38);
    return 0;

/* R10-- Glacier Room */

L10000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    rspeak_(&c__39);
/* basic description. */
    i__ = 0;
/* assume no changes. */
    if (findex_1.glacmf) {
        i__ = 40;
    }
/* partial melt? */
    if (findex_1.glacrf) {
        i__ = 41;
    }
/* complete melt? */
    rspeak_(&i__);
/* describe. */
    return 0;

/* R11-- Forest Room */

L11000:
    if (prsvec_1.prsa != 6) {
        return 0;
    }
    cevent_1.cflag[15] = TRUE_;
/* if walk in, birdie. */
    cevent_1.ctick[15] = -1;
    return 0;

/* R12-- Mirror Room */

L12000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    rspeak_(&c__42);
/* describe. */
    if (findex_1.mirrmf) {
        rspeak_(&c__43);
    }
/* if broken, nasty remar */
    return 0;
/* RAPPLI, PAGE 5 */

/* R13-- Cave2 */

L13000:
    if (prsvec_1.prsa != 6) {
        return 0;
    }
/* walkin? */
    if (prob_(&c__50, &c__20) || objcts_1.oadv[47] != play_1.winner || ! ((
            objcts_1.oflag1[c__48 - 1] & 1) != 0)) {
        return 0;
    }
/* blow em out? */
    objcts_1.oflag1[47] = objcts_1.oflag1[47] & -2;
/* yes. */
    rspeak_(&c__47);
/* tell of winds. */
    cevent_1.cflag[4] = FALSE_;
/* halt candle countdown. */
    if (! lit_(&play_1.here)) {
        rspeak_(&c__406);
    }
/* now pitch black. */
    return 0;

/* R14-- Boom Room */

L14000:
    j = objcts_1.odesc2[47];
/* assume candle. */
    if (objcts_1.oadv[47] == play_1.winner && (objcts_1.oflag1[c__48 - 1] & 1)
             != 0) {
        goto L14100;
    }
    j = objcts_1.odesc2[33];
/* assume torch. */
    if (objcts_1.oadv[33] == play_1.winner && (objcts_1.oflag1[c__34 - 1] & 1)
             != 0) {
        goto L14100;
    }
    j = objcts_1.odesc2[50];
    if (objcts_1.oadv[50] == play_1.winner && (objcts_1.oflag1[c__51 - 1] & 1)
             != 0) {
        goto L14100;
    }
    return 0;

/* safe */
L14100:
    if (prsvec_1.prsa != 123 && prsvec_1.prsa != 137) {
        goto L14200;
    }
/* turn on or burn? */
    rspsub_(&c__294, &j);
/* boom! */
    jigsup_(&c__44);
    return 0;

L14200:
    if (prsvec_1.prsa != 6) {
        return 0;
    }
/* walkin? */
    rspsub_(&c__295, &j);
/* boom! */
    jigsup_(&c__44);
    return 0;

/* R15-- No-objs */

L15000:
    findex_1.empthf = TRUE_;
/* assume true. */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* see if carrying. */
        if (objcts_1.oadv[i__ - 1] == play_1.winner) {
            findex_1.empthf = FALSE_;
        }
/* L15100: */
    }

    if (play_1.here != 76 || ! lit_(&play_1.here)) {
        return 0;
    }
    scrupd_(&play_1.ltshft);
/* score light shaft. */
    play_1.ltshft = 0;
/* never again. */
    return 0;
/* RAPPLI, PAGE 6 */

/* R16-- Machine Room */

L16000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    i__ = 46;
/* assume lid closed. */
    if ((objcts_1.oflag2[c__7 - 1] & 8) != 0) {
        i__ = 12;
    }
/* if open, open. */
    rspsub_(&c__45, &i__);
/* describe. */
    return 0;

/* R17-- Bat Room */

L17000:
    if (prsvec_1.prsa != 119) {
        goto L17500;
    }
/* look? */
    rspeak_(&c__48);
/* describe room. */
    if (objcts_1.oadv[1] == play_1.winner) {
        rspeak_(&c__49);
    }
/* bat holds nose. */
    return 0;

L17500:
    if (prsvec_1.prsa != 6 || objcts_1.oadv[1] == play_1.winner || 
            findex_1.deadf) {
        return 0;
    }
/* garlic or dead? */
    rspeak_(&c__50);
/* time to fly, jack. */
    f = moveto_(&misc_1.batdrp[rnd_(&c__9)], &play_1.winner);
/* select random dest. */
    f = rmdesc_(&c__0);
/* new room description. */
    prsvec_1.prscon = 0;
/* kill parser. */
    return 0;

/* R18-- Dome Room */

L18000:
    if (prsvec_1.prsa != 119) {
        goto L18500;
    }
/* look? */
    rspeak_(&c__51);
/* describe. */
    if (findex_1.domef) {
        rspeak_(&c__52);
    }
/* if rope, describe. */
    return 0;

L18500:
    if (prsvec_1.prsa == 91) {
        jigsup_(&c__53);
    }
/* did he jump??? */
    return 0;

/* R19-- Torch Room */

L19000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    rspeak_(&c__54);
/* describe. */
    if (findex_1.domef) {
        rspeak_(&c__55);
    }
/* if rope, describe. */
    return 0;

/* R20-- Carousel Room */

L20000:
    if (prsvec_1.prsa != 119) {
        goto L20500;
    }
/* look? */
    rspeak_(&c__56);
/* describe. */
    if (! (findex_1.caroff || findex_1.deadf)) {
        rspeak_(&c__57);
    }
/* if not flipped, spin. */
    return 0;

L20500:
    if (prsvec_1.prsa == 6 && findex_1.carozf && ! findex_1.deadf) {
        jigsup_(&c__58);
    }
/* walked in, zoom, not d */
    return 0;
/* RAPPLI, PAGE 7 */

/* R21-- Land of the Living Dead */

L21000:
    if (prsvec_1.prsa != 119) {
        goto L21100;
    }
/* look? */
    rspeak_(&c__59);
/* describe. */
    if (! findex_1.lldf) {
        rspeak_(&c__60);
    }
/* if not vanished, ghost */
    return 0;

L21100:
    if (findex_1.lldf || prsvec_1.prsa != 87 || prsvec_1.prso != 46) {
        goto L21200;
    }
/* ring bell? */
    findex_1.exorbf = TRUE_;
/* set exorcism bell flag */
    newsta_(&c__46, &c__0, &c__0, &c__0, &c__0);
/* vanish bell. */
    newsta_(&c__190, &c__967, &play_1.here, &c__0, &c__0);
/* insert hot bell. */
    if (prssta_1.lastit == 46) {
        prssta_1.lastit = 190;
    }
/* fix last it reference. */
    if (! ((objcts_1.oflag1[c__48 - 1] & 1) != 0) || objcts_1.oadv[47] != 
            play_1.winner) {
        goto L21150;
    }
/* carrying lit candles? */
    newsta_(&c__48, &c__968, &play_1.here, &c__0, &c__0);
/* drop and go out. */
    objcts_1.oflag1[47] = objcts_1.oflag1[47] & -2;
    cevent_1.cflag[4] = FALSE_;
/* disable candle timer. */
L21150:
    cevent_1.cflag[27] = TRUE_;
/* start bell timer. */
    cevent_1.ctick[27] = 6;
    cevent_1.cflag[29] = TRUE_;
/* start cooling timer. */
    cevent_1.ctick[29] = 20;
    return 0;

L21200:
    if (! findex_1.exorbf || findex_1.exorcf || objcts_1.oadv[47] != 
            play_1.winner || (objcts_1.oflag1[47] & 1) == 0) {
        goto L21300;
    }
    findex_1.exorcf = TRUE_;
/* set exorcism candle fl */
    rspeak_(&c__969);
    cevent_1.cflag[27] = FALSE_;
/* turn off bell timer. */
    cevent_1.cflag[28] = TRUE_;
/* turn on candle timer. */
    cevent_1.ctick[28] = 3;
    return 0;

L21300:
    if (! findex_1.exorcf || prsvec_1.prsa != 100 || prsvec_1.prso != 47) {
        goto L21400;
    }
/* read book? */
    newsta_(&c__42, &c__63, &c__0, &c__0, &c__0);
/* exorcism complete. */
    findex_1.lldf = TRUE_;
/* set flag. */
    cevent_1.cflag[28] = FALSE_;
/* turn off candle timer. */
    return 0;

L21400:
    if (prsvec_1.prsa != 105) {
        return 0;
    }
/* trying exorcism? */
    if (findex_1.lldf) {
        goto L21600;
    }
/* trying again? */
    if (objcts_1.oadv[45] == play_1.winner && objcts_1.oadv[46] == 
            play_1.winner && objcts_1.oadv[47] == play_1.winner && (
            objcts_1.oflag1[c__48 - 1] & 1) != 0) {
        goto L21500;
    }
    rspeak_(&c__62);
/* not equipped. */
    return 0;

L21500:
    rspeak_(&c__1044);
/* must do it the hard wa */
    return 0;

L21600:
    jigsup_(&c__61);
/* twice, exorcise you. */
    return 0;
/* RAPPLI, PAGE 7A */

/* R22-- Land of the Living Dead interior */

L22000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    rspeak_(&c__64);
/* describe. */
    if (findex_1.onpolf) {
        rspeak_(&c__65);
    }
/* on pole? */
    return 0;

/* R23-- Dam Room */

L23000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    rspeak_(&c__66);
/* describe. */
    i__ = 67;
    if (findex_1.lwtidf) {
        i__ = 68;
    }
    rspeak_(&i__);
/* describe reservoir. */
    rspeak_(&c__69);
/* describe panel. */
    if (findex_1.gatef) {
        rspeak_(&c__70);
    }
/* bubble is glowing. */
    return 0;

/* R24-- Tree Room */

L24000:
    if (prsvec_1.prsa != 119) {
        goto L24300;
    }
/* look? */
    rspeak_(&c__660);
/* describe. */
    i__ = 661;
/* set flag for below. */
    i__1 = objcts_1.olnt;
    for (j = 1; j <= i__1; ++j) {
/* describe obj in fore3. */
        if (! qhere_(&j, &c__33) || j == 145) {
            goto L24200;
        }
        rspeak_(&i__);
/* set stage, */
        i__ = 0;
        rspsub_(&c__502, &objcts_1.odesc2[j - 1]);
/* describe. */
L24200:
        ;
    }
    return 0;

L24300:
    if (prsvec_1.prsa != 6) {
        goto L24400;
    }
/* walk in? */
    cevent_1.cflag[15] = TRUE_;
/* start forest noise tim */
    cevent_1.ctick[15] = -1;
    return 0;

L24400:
    if (prsvec_1.prsa != 145 && prsvec_1.prsa != 148 && prsvec_1.prsa != 121) 
            {
        return 0;
    }
/* drop, throw, shake? */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* loop through objects */
        if (i__ == 144 || i__ == 153 || ! qhere_(&i__, &play_1.here)) {
            goto L24600;
        }
/*  is it here? */
        if (i__ == 154) {
            goto L24500;
        }
/* egg? */
        newsta_(&i__, &c__0, &c__33, &c__0, &c__0);
/* no, drop to forest flo */
        rspsub_(&c__659, &objcts_1.odesc2[i__ - 1]);
        goto L24600;

L24500:
        newsta_(&c__154, &c__0, &c__0, &c__0, &c__0);
/* vanish egg. */
        newsta_(&c__155, &c__658, &c__33, &c__0, &c__0);
/* insert broken egg. */
        if (prssta_1.lastit == 154) {
            prssta_1.lastit = 155;
        }
/* fix last it reference. */
        objcts_1.otval[154] = 2;
        if (objcts_1.ocan[156] != 154) {
            goto L24550;
        }
/* canary inside? */
        objcts_1.otval[157] = 1;
        goto L24600;
L24550:
        newsta_(&c__158, &c__0, &c__0, &c__0, &c__0);
/* no, vanish broken cana */
L24600:
        ;
    }
    return 0;
/* RAPPLI, PAGE 8 */

/* R25-- Cyclops Room */

L25000:
    if (prsvec_1.prsa != 119) {
        goto L25100;
    }
/* look? */
    rspeak_(&c__606);
/* describe. */
    i__ = 607;
/* assume basic state. */
    if (findex_1.rvcyc > 0) {
        i__ = 608;
    }
/* >0?  hungry. */
    if (findex_1.rvcyc < 0) {
        i__ = 609;
    }
/* <0?  thirsty. */
    if (findex_1.cyclof) {
        i__ = 610;
    }
/* asleep? */
    if (findex_1.magicf) {
        i__ = 611;
    }
/* gone? */
    rspeak_(&i__);
/* describe. */
    return 0;

L25100:
    if (prsvec_1.prsa != 6 || findex_1.rvcyc == 0 || findex_1.deadf) {
        return 0;
    }
    cevent_1.cflag[25] = TRUE_;
/* walked in, restart tim */
    cevent_1.ctick[25] = -1;
    return 0;

/* R26-- Bank Box Room */

L26000:
    if (prsvec_1.prsa != 6) {
        return 0;
    }
/* surprise him. */
    for (i__ = 1; i__ <= 8; i__ += 2) {
/* scolrm depends on */
        if (screen_1.fromdr == screen_1.scoldr[i__ - 1]) {
            screen_1.scolrm = screen_1.scoldr[i__];
        }
/* L26100: */
    }
/* entry direction. */
    return 0;

/* R27-- Treasure Room */

L27000:
    if (prsvec_1.prsa != 6 || findex_1.deadf || ! hack_1.thfact) {
        return 0;
    }
/* walkin, thief active? */
    if (objcts_1.oroom[60] != play_1.here) {
        newsta_(&c__61, &c__82, &play_1.here, &c__0, &c__0);
    }
/* no, materialize him. */
    hack_1.thfpos = play_1.here;
/* reset search pattern. */
    objcts_1.oflag2[60] = objcts_1.oflag2[60] | 256;

/* Vanish everything in room. */

/* he's angry. */
    j = 0;
/* assume nothing to vani */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
        if (i__ == 59 || i__ == 61 || ! qhere_(&i__, &play_1.here)) {
            goto L27200;
        }
/* here? */
        j = 83;
/* flag byebye. */
        objcts_1.oflag1[i__ - 1] = objcts_1.oflag1[i__ - 1] & -32769;
/* away it goes. */
L27200:
        ;
    }
    rspeak_(&j);
/* describe. */
    return 0;

/* R28-- Cliff Room */

L28000:
    findex_1.deflaf = objcts_1.oadv[89] != play_1.winner;
/* true if not carrying. */
    return 0;
/* RAPPLI, PAGE 9 */

/* R29-- Rivr4 Room */

L29000:
    if (findex_1.buoyf || objcts_1.oadv[93] != play_1.winner) {
        return 0;
    }
    rspeak_(&c__84);
/* give hint, */
    findex_1.buoyf = TRUE_;
/* then disable. */
    return 0;

/* R30-- Overfalls */

L30000:
    if (prsvec_1.prsa != 119) {
        jigsup_(&c__85);
    }
/* over you go. */
    return 0;

/* R31-- Slide Ledge */

L31000:
    if (prsvec_1.prsa != 6) {
        return 0;
    }
/* walk in? */
    cevent_1.cflag[26] = FALSE_;
/* disable slippery rope. */
    return 0;

/* R32-- Slide */

L32000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    rspeak_(&c__1012);
/* describe. */
    if (findex_1.ttie == 0) {
        return 0;
    }
/* timber tied? */
    if (objcts_1.oroom[findex_1.ttie - 1] == play_1.here) {
        rspsub_(&c__1013, &objcts_1.odesc2[findex_1.ttie - 1]);
    }
    return 0;

/* R33-- Aragain Falls */

L33000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    rspeak_(&c__96);
/* describe. */
    i__ = 97;
/* assume no rainbow. */
    if (findex_1.rainbf) {
        i__ = 98;
    }
/* got one? */
    rspeak_(&i__);
/* describe. */
    return 0;
/* RAPPLI, PAGE 10 */

/* R34-- Ledge Room */

L34000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    rspeak_(&c__100);
/* describe. */
    i__ = 102;
/* assume safe room ok. */
    if ((rooms_1.rflag[134] & 256) != 0) {
        i__ = 101;
    }
/* if munged, room gone. */
    rspeak_(&i__);
/* describe. */
    return 0;

/* R35-- Safe Room */

L35000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    rspeak_(&c__104);
/* describe. */
    i__ = 105;
/* assume ok. */
    if (findex_1.safef) {
        i__ = 106;
    }
/* blown? */
    rspeak_(&i__);
/* describe. */
    return 0;

/* R36-- Magnet Room */

L36000:
    if (prsvec_1.prsa != 119) {
        goto L36500;
    }
/* look? */
    rspeak_(&c__107);
/* describe. */
    return 0;

L36500:
    if (prsvec_1.prsa != 6 || findex_1.deadf || ! findex_1.caroff) {
        return 0;
    }
/* walkin? */
    if (findex_1.carozf) {
        goto L36600;
    }
/* zoom? */
    if (play_1.winner == 1) {
        rspeak_(&c__108);
    }
/* no, spin his compass. */
    return 0;

L36600:
    i__ = 58;
/* spin his insides. */
    if (play_1.winner != 1) {
        i__ = 99;
    }
/* spin robot. */
    jigsup_(&i__);
/* dead. */
    return 0;

/* R37-- Cage Room */

L37000:
    if (findex_1.cagesf) {
        f = moveto_(&c__140, &play_1.winner);
    }
/* if solved, move. */
    return 0;
/* RAPPLI, PAGE 11 */

/* R38-- Mirror D Room */

L38000:
    if (prsvec_1.prsa == 119) {
        lookto_(&c__166, &c__164, &c__0, &c__682, &c__681);
    }
    return 0;

/* R39-- Mirror G Room */

L39000:
    if (prsvec_1.prsa == 6) {
        jigsup_(&c__685);
    }
    return 0;

/* R40-- Mirror C Room */

L40000:
    if (prsvec_1.prsa == 119) {
        lookto_(&c__164, &c__162, &c__683, &c__0, &c__681);
    }
    return 0;

/* R41-- Mirror B Room */

L41000:
    if (prsvec_1.prsa == 119) {
        lookto_(&c__163, &c__161, &c__0, &c__0, &c__681);
    }
    return 0;

/* R42-- Mirror A Room */

L42000:
    if (prsvec_1.prsa == 119) {
        lookto_(&c__162, &c__0, &c__0, &c__684, &c__681);
    }
    return 0;
/* RAPPLI, PAGE 12 */

/* R43-- Mirror C East/West */

L43000:
    if (prsvec_1.prsa == 119) {
        ewtell_(&play_1.here, &c__683);
    }
    return 0;

/* R44-- Mirror B East/West */

L44000:
    if (prsvec_1.prsa == 119) {
        ewtell_(&play_1.here, &c__686);
    }
    return 0;

/* R45-- Mirror A East/West */

L45000:
    if (prsvec_1.prsa == 119) {
        ewtell_(&play_1.here, &c__687);
    }
    return 0;

/* R46-- Inside Mirror */

L46000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    rspeak_(&c__688);

/* Now describe pole state. */

/* Cases 1,2--   MDIR=270 & MLOC=MRB, pole is up or in hole */
/* Cases 3,4--   MDIR=0 V MDIR=180, pole is up or in channel */
/* Case 5--      Pole is up */

/* describe */
    i__ = 689;
/* assume case 5. */
    if (findex_1.mdir == 270 && findex_1.mloc == 162) {
        i__ = min(findex_1.poleuf,1) + 690;
    }
/* cases 1,2. */
    if (findex_1.mdir % 180 == 0) {
        i__ = min(findex_1.poleuf,1) + 692;
    }
/* cases 3,4. */
    rspeak_(&i__);
/* describe pole. */
    i__1 = findex_1.mdir / 45 + 695;
    rspsub_(&c__694, &i__1);
/* describe arrow. */
    return 0;
/* RAPPLI, PAGE 13 */

/* R47-- Mirror Eye Room */

L47000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    i__ = 704;
/* assume beam stop. */
    i__1 = objcts_1.olnt;
    for (j = 1; j <= i__1; ++j) {
        if (qhere_(&j, &play_1.here) && j != 171) {
            goto L47200;
        }
/* L47100: */
    }
    i__ = 703;
L47200:
    rspsub_(&i__, &objcts_1.odesc2[j - 1]);
/* describe beam. */
    lookto_(&c__161, &c__0, &c__0, &c__0, &c__0);
/* look north. */
    return 0;

/* R48-- Inside Crypt */

L48000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    i__ = 46;
/* crypt is open/closed. */
    if ((objcts_1.oflag2[c__119 - 1] & 8) != 0) {
        i__ = 12;
    }
    rspsub_(&c__705, &i__);
    return 0;

/* R49-- South Corridor */

L49000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    rspeak_(&c__706);
/* describe. */
    i__ = 46;
/* odoor is open/closed. */
    if ((objcts_1.oflag2[c__172 - 1] & 8) != 0) {
        i__ = 12;
    }
    if (findex_1.lcell == 4) {
        rspsub_(&c__707, &i__);
    }
/* describe odoor if ther */
    return 0;

/* R50-- Behind Door */

L50000:
    if (prsvec_1.prsa != 6) {
        goto L50100;
    }
/* walk in? */
    cevent_1.cflag[23] = TRUE_;
/* master follows. */
    cevent_1.ctick[23] = -1;
    return 0;

L50100:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    i__ = 46;
/* qdoor is open/closed. */
    if ((objcts_1.oflag2[c__173 - 1] & 8) != 0) {
        i__ = 12;
    }
    rspsub_(&c__708, &i__);
    return 0;
/* RAPPLI, PAGE 14 */

/* R51-- Front Door */

L51000:
    if (prsvec_1.prsa == 6) {
        cevent_1.ctick[23] = 0;
    }
/* if exits, kill follow. */
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    lookto_(&c__0, &c__165, &c__709, &c__0, &c__0);
/* describe south. */
    i__ = 46;
/* panel is open/closed. */
    if (cevent_1.cflag[22] && cevent_1.ctick[22] != 0) {
        i__ = 12;
    }
/* open if inq in p */
    j = 46;
/* qdoor is open/closed. */
    if ((objcts_1.oflag2[c__173 - 1] & 8) != 0) {
        j = 12;
    }
    rspsb2_(&c__710, &i__, &j);
    return 0;

/* R52-- North Corridor */

L52000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    i__ = 46;
    if ((objcts_1.oflag2[c__175 - 1] & 8) != 0) {
        i__ = 12;
    }
/* cdoor is open/closed. */
    rspsub_(&c__711, &i__);
    return 0;

/* R53-- Parapet */

L53000:
    if (prsvec_1.prsa == 119) {
        i__1 = findex_1.pnumb + 712;
        rspsub_(&c__712, &i__1);
    }
    return 0;

/* R54-- Cell */

L54000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    i__ = 721;
/* cdoor is open/closed. */
    if ((objcts_1.oflag2[c__175 - 1] & 8) != 0) {
        i__ = 722;
    }
    rspeak_(&i__);
    i__ = 46;
/* odoor is open/closed. */
    if ((objcts_1.oflag2[c__172 - 1] & 8) != 0) {
        i__ = 12;
    }
    if (findex_1.lcell == 4) {
        rspsub_(&c__723, &i__);
    }
/* describe. */
    return 0;

/* R55-- Prison Cell */

L55000:
    if (prsvec_1.prsa == 119) {
        rspeak_(&c__724);
    }
/* look? */
    return 0;

/* R56-- Nirvana Cell */

L56000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    i__ = 46;
/* odoor is open/closed. */
    if ((objcts_1.oflag2[c__172 - 1] & 8) != 0) {
        i__ = 12;
    }
    rspsub_(&c__725, &i__);
    return 0;
/* RAPPLI, PAGE 15 */

/* R57-- Nirvana and end of game */

L57000:
    if (prsvec_1.prsa != 6) {
        return 0;
    }
/* walkin? */
    s_paus("--More--", 8L);
    rspeak_(&c__726);
    s_paus("--More--", 8L);
    score_(&c_false);
    s_stop(" ", 1L);

/* R58-- Tomb Room */

L58000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    i__ = 46;
/* tomb is open/closed. */
    if ((objcts_1.oflag2[c__119 - 1] & 8) != 0) {
        i__ = 12;
    }
    rspsub_(&c__792, &i__);
    return 0;

/* R59-- Puzzle Side Room */

L59000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    i__ = 861;
/* assume door closed. */
    if (findex_1.cpoutf) {
        i__ = 862;
    }
/* open? */
    rspeak_(&i__);
/* describe. */
    return 0;

/* R60-- Puzzle Room */

L60000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    if (findex_1.cpushf) {
        goto L60100;
    }
/* started puzzle? */
    rspeak_(&c__868);
/* no, describe. */
    if ((objcts_1.oflag2[185] & 4) != 0) {
        rspeak_(&c__869);
    }
    return 0;

L60100:
    cpinfo_(&c__880, &findex_1.cphere);
/* describe room. */
    return 0;
/* RAPPLI, PAGE 16 */

/* R61-- Palantir Room */

L61000:
    if (prsvec_1.prsa != 119) {
        goto L62400;
    }
/* look? */
    rspeak_(&c__1015);
    i__ = 699;
/* string is south. */
    goto L62100;

/* R62-- Prm Room */

/* join common code. */
L62000:
    if (prsvec_1.prsa != 119) {
        goto L62400;
    }
/* look? */
    rspeak_(&c__1016);
/* string is north. */
    i__ = 695;

L62100:
    if (findex_1.plookf) {
        goto L62400;
    }
/* thru window? skip door */
    rspsub_(&c__1017, &i__);
    i__ = 1018;
/* assume lid open. */
    i__1 = play_1.here + 8;
    if (! ((objcts_1.oflag2[i__1 - 1] & 8) != 0)) {
        i__ = 1019;
    }
/* closed. */
    rspeak_(&i__);
/* describe lock. */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* loop through objects. */
        if (objcts_1.ocan[i__ - 1] != play_1.here + 10) {
            goto L62200;
        }
        rspsub_(&c__1020, &objcts_1.odesc2[i__ - 1]);
/* object in keyhole. */
        goto L62300;
L62200:
        ;
    }

L62300:
    if ((objcts_1.oflag2[c__197 - 1] & 8) != 0) {
        rspeak_(&c__1042);
    }
/* door open? */
    if (! findex_1.matf) {
        goto L62400;
    }
/* mat under door? */
    rspeak_(&c__1021);
    if (findex_1.matobj != 0 && (play_1.here == 193 || (objcts_1.oflag2[
            c__197 - 1] & 8) != 0)) {
        rspsub_(&c__1022, &objcts_1.odesc2[findex_1.matobj - 1]);
    }
/* obj on mat? */
    goto L62400;

L62400:
    findex_1.plookf = FALSE_;
/* clear window flag. */
    if (prsvec_1.prso == 0) {
        return 0;
    }
/* any object? */
    i__1 = play_1.here + 10;
    if (prsvec_1.prsa != 132 || ! qempty_(&i__1) || (prsvec_1.prso != 57 && 
            prsvec_1.prso != 92 && prsvec_1.prso != 205 && prsvec_1.prso != 
            23)) {
        goto L62500;
    }
    if (! findex_1.ptoucf) {
        goto L62450;
    }
/* touched? */
    i__1 = play_1.here + 8;
    if ((objcts_1.oflag2[i__1 - 1] & 8) != 0) {
        rspeak_(&c__1043);
    }
/* lid closes. */
    objcts_1.oflag2[play_1.here + 7] = objcts_1.oflag2[play_1.here + 7] & -9;
L62450:
    findex_1.ptoucf = TRUE_;

/* touched now. */
L62500:
    objcts_1.oflag1[56] = objcts_1.oflag1[56] & -513;
    if (objcts_1.ocan[56] == 202 || objcts_1.ocan[56] == 203) {
        objcts_1.oflag1[56] = objcts_1.oflag1[56] | 512;
    }
    objcts_1.oflag1[91] = objcts_1.oflag1[91] & -513;
    if (objcts_1.ocan[91] == 202 || objcts_1.ocan[91] == 203) {
        objcts_1.oflag1[91] = objcts_1.oflag1[91] | 512;
    }
    objcts_1.oflag1[204] = objcts_1.oflag1[204] & -513;
    if (objcts_1.ocan[204] == 202 || objcts_1.ocan[204] == 203) {
        objcts_1.oflag1[204] = objcts_1.oflag1[204] | 512;
    }
    objcts_1.oflag1[22] = objcts_1.oflag1[22] & -513;
    if (objcts_1.ocan[22] == 202 || objcts_1.ocan[22] == 203) {
        objcts_1.oflag1[22] = objcts_1.oflag1[22] | 512;
    }
    if (objcts_1.oroom[206] != 192 && objcts_1.oroom[206] != 193) {
        findex_1.matf = FALSE_;
    }
    objcts_1.oflag1[206] = objcts_1.oflag1[206] & -513;
    if (! findex_1.matf) {
        return 0;
    }
    objcts_1.oflag1[206] = objcts_1.oflag1[206] | 512;
    newsta_(&c__207, &c__0, &play_1.here, &c__0, &c__0);
    return 0;
/* RAPPLI, PAGE 17 */

/* R63-- Inslide */

L63000:
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* loop through objects */
        if (! qhere_(&i__, &play_1.here) || (objcts_1.oflag1[i__ - 1] & 8192) 
                == 0) {
            goto L63100;
        }
        newsta_(&i__, &c__0, &c__9, &c__0, &c__0);
/* drop to cellar, */
        if (i__ == 11) {
            newsta_(&i__, &c__0, &c__0, &c__0, &c__0);
        }
/* unless water */
        rspsub_(&c__1011, &objcts_1.odesc2[i__ - 1]);
L63100:
        ;
    }
    return 0;

/* R64-- Puzzle Anteroom */

L64000:
    if (prsvec_1.prsa != 119) {
        return 0;
    }
/* look? */
    i__ = 1068;
/* not blocked. */
    if (puzzle_1.cpvec[9] != 0) {
        i__ = 1069;
    }
/* blocked. */
    rspeak_(&i__);
/* describe. */
    return 0;

} /* rappli_ */



/* LOOKTO--      Describe view in mirror hallway */

/* Declarations */

/* Subroutine */ int lookto_(integer *nrm, integer *srm, integer *nt, integer 
        *st, integer *ht)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer m1;
    integer mrbf, i__, dir;


    rspeak_(ht);
/* describe hall. */
    rspeak_(nt);
/* describe north view. */
    rspeak_(st);
/* describe south view. */
    dir = 0;
/* assume no direction. */
    if ((i__1 = findex_1.mloc - play_1.here, abs(i__1)) != 1) {
        goto L200;
    }
/* mirror to n or s? */
    if (findex_1.mloc == *nrm) {
        dir = 695;
    }
    if (findex_1.mloc == *srm) {
        dir = 699;
    }
/* dir=n/s. */
    if (findex_1.mdir % 180 != 0) {
        goto L100;
    }
/* mirror n-s? */
    rspsub_(&c__847, &dir);
/* yes, he sees panel */
    rspsb2_(&c__848, &dir, &dir);
/* and narrow rooms. */
    goto L200;

L100:
    m1 = mrhere_(&play_1.here);
/* which mirror? */
    mrbf = 0;
/* assume intact. */
    if ((m1 == 1 && ! findex_1.mr1f) || (m1 == 2 && ! findex_1.mr2f)) {
        mrbf = 1;
    }
/* broken? */
    i__1 = mrbf + 849;
    rspsub_(&i__1, &dir);
/* describe. */
    if (m1 == 1 && findex_1.mropnf) {
        i__1 = mrbf + 823;
        rspeak_(&i__1);
    }
    if (mrbf != 0) {
        rspeak_(&c__851);
    }

L200:
    i__ = 0;
/* assume no more to do. */
    if (*nt == 0 && (dir == 0 || dir == 699)) {
        i__ = 852;
    }
    if (*st == 0 && (dir == 0 || dir == 695)) {
        i__ = 853;
    }
    if (*nt + *st + dir == 0) {
        i__ = 854;
    }
    if (*ht != 0) {
        rspeak_(&i__);
    }
/* describe halls. */
    return 0;

} /* lookto_ */



/* EWTELL--      Describe e/w narrow rooms */

/* Declarations */

/* Subroutine */ int ewtell_(integer *rm, integer *st)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    logical m1;
    integer i__;


/* Note that we are east or west of mirror, and */
/* mirror must be n-s. */

    m1 = findex_1.mdir + (*rm - 167) % 2 * 180 == 180;
    i__ = (*rm - 167) % 2;
/* get basic e/w flag. */
    if ((m1 && ! findex_1.mr1f) || (! m1 && ! findex_1.mr2f)) {
        i__ += 2;
    }
/* mirror broken? */
    i__1 = i__ + 819;
    rspeak_(&i__1);
    if (m1 && findex_1.mropnf) {
        i__1 = i__ / 2 + 823;
        rspeak_(&i__1);
    }
    rspeak_(&c__825);
    rspeak_(st);
    return 0;

} /* ewtell_ */



