/* cvobj.h
 *    include file for objects list
 *********************************************************************/

struct conn {
    struct cvobj *who;
    struct cvloc *where;
    struct conn *link;
};

struct cvobj {
    char *desc;			/* object description */
    char *props;		/* all property messages, in order */
    int iloc,			/* initial location */
    iloc2,			/* initial second location */
    iprop;			/* initial property */
    int prop;			/* current property number */
    struct conn conn1,		/* link to next obj here */
    conn2;			/* link to next obj at 2nd loc */
};

extern struct cvobj cvobj[];

#define	TAKEN	(&(cvloc[0]))	/* use that place for something */
#define	LOST	((struct cvloc *) 0)
#define FIXED	TAKEN

#define OBJSIZ	100
#define ISOBJ(object)	((object) < OBJSIZ)
#define	INBARN(object)	((object)->conn1.where == &(cvloc[2]))
#define	AT(object)		( ((object)->conn1.where == loc ) \
							|| ((object)->conn2.where == loc) )
#define	HERE(object)	( ((object)->conn1.where == loc ) \
							|| (TOTING(object)) )
#define TOTING(object)	( (object)->conn1.where == TAKEN )
#define	FOUND(object)	( (object)->prop >= 0 )
#define	LIQ(object)		((object->prop) ? (_WATER - 1 + (object->prop)) : 0)
#define	ONUM(object)	( (object) - cvobj )
