\ utils.f for advtr.f  Leo Wong 12 June 02003 fyj +
\ Utilities Routines
\ * NUMBER AND WORD INPUT * \
\ * LEFT AND RIGHT SHIFT * \
\ * DATE AND TIME FROM 1 JAN 01967 fyj + * \
\ * RANDOM NUMBER GENERATOR * \

1 20 LSHIFT CONSTANT 21bit

\ * NUMBER AND WORD INPUT * \
: getn  ( -- -1|n )
   \ Return n>=0, the number input, or -1 (failed)
   0 0 PAD DUP 84 2DUP BLANK ACCEPT -TRAILING
   >NUMBER NIP NIP IF DROP -1 THEN ;

CREATE word1 11 CHARS ALLOT
CREATE word2 11 CHARS ALLOT
: getin  ( -- )
   \ Return at most two words; put them in word1 and word2
   CR CR [CHAR] > EMIT PAD DUP 84 ACCEPT
   word> 10 MIN 2DUP supper word1 puts
   word> 10 MIN 2DUP supper word2 puts 2DROP ;

\ * LEFT AND RIGHT SHIFT * \
: shift ( val1 dist -- val2 )
   \ shift Return val left-shifted (logically) dist bits
   \                 (right-shift if dist<0).
   DUP 0< if RSHIFT ELSE LSHIFT THEN ;

\ * DATE AND TIME FROM 1 JAN 01967 fyj + * \
CREATE hath :: ,s 31 28  31  30  31  30  31  31  30  31  30  31 ;
   \ Compile number of days in each month

: days  ( day month year -- days )
   \ Return number of days since 01-JAN-67 ( 67 for Gforth )
   1967 - DUP 365 * OVER 4 / + >R
   4 MOD 3 = OVER 2 > AND 1 AND >R 
   0 SWAP 1- 0 ?DO I CELLS hath + @ + LOOP + 1- 2R> + + ;

: minutes  ( second minute hour -- minutes )
   \ Return number of minutes since midnight
   60 * + NIP ;

: datime  ( -- d t )
   \ datime Return the date and time as d and t.
   \   D is number of days since 01-JAN-67, T is minutes past midnight.
   TIME&DATE  ( sec min hour day month year )
   days  >R minutes R> SWAP ;

\ * RANDOM NUMBER GENERATOR * \
: ran ( range -- 0<=n<range )
   \ Return a value uniformly selected between 0 and range-1.
   datime 18 * 5 + SWAP 1000 + 1000 MOD
   0 ?DO 1021 21bit */MOD DROP LOOP 21bit */ ;

\ The above apparently changes once a minute, so use Brodie's rng
0 VALUE rnd
TIME&DATE + + + + +  TO rnd
: random  ( -- n )
   rnd 31421 * 6927 + DUP TO rnd ;
: ran  ( range -- 0<=n<range )
   random UM* NIP ;
  
\ Vectored execution -- computed goto
: vex  ( n gotolist -- ? )
   OVER 0> 0= ABORT" vex n<=0"
   @+ 2 PICK < IF @ bug ELSE SWAP CELLS + @ EXECUTE THEN ;
: vet
   CREATE  ( n bug -- )  SWAP , ,  \ followed by :: ', xt1 ... xtn ;
   DOES>  ( 1<=n2<=n -- ? )  vex ;
