.\" -*- nroff -*-
.Dd February 28, 1993
.Dt NAPOLEON 1
.Os
.Sh NAME
.Nm napoleon
.Nd adventure game
.Sh SYNOPSIS
.Nm napoleon
.Sh DESCRIPTION
.Nm Napoleon
is a traditional text adventure game.  On the other hand it is modern
in the sense that it has a yacc/bison parser to allow you to type more
complex commands than the traditional two words.
.Pp
You already know what an adventure game is, I expect... so all that
remains is to set the scene for this particular one:
.Sh INTRODUCTION
It was an alarmingly dark night.  In Rusgreve's office, a
solitary candle burned, and spluttered fitfully in the
slight breeze.  The Council of War began.  Prendergast lit a
smelly cigarette.
.Pp
Rusgreve began to explain the problem.  'The difficulty is,'
he said, 'someone is going to have to go in without us
having first obtained proper information.  It isn't going to
be me.'
.Pp
Many, many weeks previously, the investigation had begun. 
At first, Rusgreve had claimed there was nothing to worry
about.  After a time, that became a bigger worry than the
things people might have worried about, and so he rewrote
history so that in fact he had been concerned all along. 
The delay rather hindered the efforts to gain information
about the people involved prior to sending in an agent.
.Pp
Many, many years previously, the so-called Napoleon gang had
been normal criminals - yes, they did a bit of time here,
and yes, there was the odd bungled attack there.  Then
things changed for the better (although it was worse for
everyone else).  The first and most important change was
that Rusgreve took over as director of the Criminal Re-
education Bureau, responsible for placing crooks in the nick
for re-education.
.Pp
The second, and less important change was that the Napoleon
gang were joined by a fourth member.  This member was known
as Professor R. P. P. Tinthywinkle-Croack.  Rusgreve pointed
out early on how surprising it was that one of the Napoleon
gang was using his real name.  Unfortunately it rapidly
became obvious that this was not so.  Information was passed
out to the Napoleons which was supposed to be top secret,
for your eyes only, printed on red paper.  This led to the
uncharitable starting to believe that somewhere in the CRB,
a leaker was at work.  An immediate Public Enquiry was set
up, which served only to pass still more information into
the hands of Joe Public (who Rusgreve always suspected of
being a secret Communist - others only suspected Rusgreve of
being a little simple).
.Pp
One particular piece of information which got into the hands
of the Napoleon gang was the knowledge of how to idea-flip. 
Prendergast was originally employed to try to research this
topic, in order that it could be directed at miscreants, as
part of the re-education programme.  We asked him to explain
it to the Council of War so that it could be quoted below:
.Pp
When you dream, you populate your dreams with other people. 
However those people don't know that they were in your dream
(unless you tell them, yes, Rusgreve).  Now if we can bring
sufficient energy to bear on the problem, we can arrange it
so that people's dreams come true; they don't know it, and
neither does anyone else unless some action is taken to
transport people to them.  But when this happens, two people
can meet in a dream, and both people will remember the same
dream when they wake up.
.Pp
Now this is not just of academic interest.  Many people saw
a lot of potential in this system for creating everything
from idyllic gardens to death traps (the use the Napoleon
gang were eventually to find).
.Pp
What was not appreciated was that people's dreams were not
being realised individually but instead everyone who placed
their dreams at the disposal of the idea-flipping machine
had their dreams combined into a single very large system. 
In the end portions of the system became quite well ordered. 
In places this was because people deliberately dreamed in
such a way as to create improved order while in others it
was due simply to people with efficient minds dreaming.
.Pp
This caused the Napoleon gang a lot of problems.  The point
was that they wanted to create death traps to which people
could be whisked as soon as they fell asleep.  But the
majority of the dreamland was neutral or good, since wide
publication of the invention had been prevented;  apart from
the Napoleon gang, everyone who knew about the invention was
concerned with creating safe places for people to go.
.Pp
However there are nasty places.  These, however, have been
watered down by the proximity of good areas.  They are now
much more what you make of them than unreservedly bad.  That
is, you have to survive by your wits.
.Pp
Next Rusgreve himself gave a short briefing to the meeting,
reading from a large pad in front of him on the table:
.Pp
Now it wouldn't be so bad if the Napoleon gang hadn't
managed to steer anyone to the unpleasant areas, but they
have.  They created for themselves a complex of rooms with
exits leading to all the bad places; then they entered the
dreamland looking for someone important who could be
kidnapped and held hostage there.  And they found someone:
the Princess Caroline, who was dreaming naturally and was
unaware that she had moved from dream to semi reality.
.Pp
She has been asleep ever since, and cannot be woken.  It has
been put about that she is ill, but those people knowing
about the idea-flipping secret know that she is not ill.  So
do the Napoleon gang, who have asked for a large fee in
return for releasing her.  But someone's going to have to go
into the dreamland to let her out.
.Pp
\|'Well volunteered,' said Rusgreve to you at about this
point.
.Pp
\|'Hmmm,' said Prendergast, 'I suppose we could easily put
someone into the Napoleon gang's rooms that lead to all the
nasty bits.  It's just if they get killed, they won't come
back, just like the Princess Caroline didn't.'
.Pp
\|'We won't get anywhere without taking a few risks,' said
Rusgreve, kindly.
.Pp
\|'We don't know what unpleasant things the Napoleon gang
might have put there for unexpected visitors, though,' said
Prendergast.
.Pp
The exchanges went on for quite some time.  In the end
Rusgreve, as director of the Bureau, overruled all
objections and annouced that Something Must be Done.  You
are on your way.
.Pp
\|'Alright then,' said Prendergast with a sigh.  'We'll be
able to keep watch over you until you leave the Napoleons'
place for the various nasty bits, and make sure nothing too
nasty happens.  But we won't be able to help you operate
whatever the Napoleons have put there, and we won't be able
to help you once you get past there into the rest of the
dreamland.'
.Pp
\|'And good luck,' finished Rusgreve. 'We appreciate what you
are doing.  We will give you the papers you need to carry
out this mission to the best of your ability - and remember
the most important thing.  Read the scroll in the office at
the centre of the Napoleons' headquarters.'
.Sh SHEET 604
Target Information -- Napoleon Gang (sheet # 604)
.Pp
Up to date information on the Napoleons is difficult to come
by.  Over the last few years they have moved from being
really quite ordinary criminals who we have been able to
have a try at re-educating sometimes to their present form.
.Pp
It is popularly believed that they 'hit the big time' as the
leader liked to put it, when the information on idea-
flipping fell into their hands, apparently leaked by someone
at the Bureau.  We would like to stress that this is almost
certainly not the case and it is thought to be highly
unlikely that anyone at the Bureau could have been
responsible for the sudden rise to power that the Napoleon
gang have experienced.
.Pp
The reason we haven't got much information to place in this
report is that the Napoleons have become very accustomed to
secrecy.  Last year one of our operatives had to pretend to
be a window-cleaner after he was seen fixing an electronic
device to their window frame.  It is believed that his cover
may have been compromised by someone at the Bureau and
everyone is urged to be uncommonly vigilant to prevent
unauthorised activities such as leaking from being carried
on.  The attached device subsequently only ever recorded
people berating the Bureau for inefficiency in catching
criminals.
.Pp
The Napoleon gang is, however, known to have three members,
as well as Professor R. P. P. Tinthywinkle-Croack.  Apart
from the Professor, all the members use false names, and so
the accuracy of what follows cannot be guaranteed.
.Pp
Napoleon target # 1: Richard Entwhistle-SmytheCumbert
.Pp
Commonly uses the alias of Fred Smith.
.Pp
Served five years in jail for robbery with violence, while
the Napoleons were in a less subtle phase.
.Pp
Commonly believed to be the leader of the outfit, RESC
seemed to be the first to hear of the opportunity available
with the idea-flipping machine.  He approached Professor
Tinthywinkle-Croack to bring him in on the project.  The
meeting was monitored, but unfortunately took place in a
language for which a translator could not be found for
another three weeks, by which time it was, of course, far
too late.
.Pp
If you see RESC, take great care.  He may attack with a
savagery learnt during his days as a robber.  He may try to
trick you, using his undoubted verbal skill.  He may ignore
you and hope you go away.  He might attempt to recruit you,
and we wouldn't want that, would we?
.Pp
RESC may be recognised in the dreamland by his tendency to
end up leading what ever bizarre operation someone has
\|'dreamed' up.  One of nature's leaders, he will lead you
into compromising the Bureau if you are not careful.  Be
warned.  If you change sides, the whole arsenal of the
Bureau's sophisticated tools will be pointed at you.
.Pp
Napoleon target # 2: Charlie Zzzwocke
.Pp
Changed his name by Deed Poll in order that he could take
part in a bank fraud.
.Pp
Commonly uses the alias of Uncle Z, which is not very
convincing, but you believe that that is his name when he is
standing over you asking whether you want to buy any
insurance.
.Pp
A natural thug, he is available for any operation involving
crimes of violence in a dark alley.  He was brought into the
fraud because someone realised that the person most at risk
was the one with the funny name - and predictably Zzzwocke
got caught.  He served three months at an open prison before
absconding.
.Pp
While on the run, he took part in an attack on a bank. 
Unfortunately the bank had folded several months previously
and there was now nothing in the branch except a pile of old
paying-in slips.  He took these, and started to run out
before falling over the doormat and letting his gun off
across the street.  RESC saw him and thought him the ideal
gang member - frightening to anyone not wanting insurance,
but not intelligent enough to have leadership ambitions. 
RESC removed him from under the noses of the police.
.Pp
Of all the gang members, Zzzwocke is the least at home in
dreamland.  'Namby-pamby' pursuits like dreaming are not for
him, and a sudden shock will sometimes cause him to wake up.
.Pp
Napoleon target # 3: Brian Turner
.Pp
[ Note: the above name is believed to be too ordinary to be
correct.  Would anyone who would like to suggest an
alternative name please contact the information desk on the
number shown below. ]
.Pp
Not using any aliases, Brian Turner is a supremely confident
talker who could sell double glazing to... well, anyone
really.  He has been involved in organised crime ever since
his childhood, when he 'organised' people to distract the
store detective while his friends helped themselves to
chocolate bars.  Predictably, he got caught, and was
cautioned.
.Pp
Later he turned his attention to selling timeshare holidays. 
This ended when he got so good at it that he sold himself
one, forgetting all the bad points, like that it was still
just a hole in the ground.
.Pp
Later he turned his attention to getting people to put
thousands of pounds in brown envelopes and leave them in the
hotel safe.  One of the people he did this to was our own
Rusgreve, and this was the reason why Rusgreve decided to go
into crime prevention, in order to get his own back.  This
particular misdeed therefore had repercussions for the crime
statistics far beyond its own ability to increment them.
.Pp
Finally, he joined the Napoleons when a man who had just
been cheated turned nasty.  That man was Mr Zzzwocke.
.Pp
If you have any further information to add to this dossier,
please ring 4733 and ask for Peabody.
.Pp
If you believe that your cover may have been compromised,
please ring 8955 and ask to speak to the Editor.
.Sh SHEET 904
Target Information -- Bureau Leaker (sheet # 904)
.Pp
(this page intentionally left blank)
.Pp
If you have any further information to add to this dossier,
please ring 4733 and ask for Peabody.
.Pp
If you believe that your cover may have been compromised,
please ring 8955 and ask to speak to the Editor.
.Pp
.Sh DIAGNOSTICS
Exit status is always 0.  All errors are reported interactively by the
program.
.Sh BUGS
Surely not?
.Sh HISTORY
This is the first version.  History is just about to start... :-)
