#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>
#include <SquareCircle.h>

// Hermit.t (defining the hermit NPC)

hermit : Person 'old hermit/man/priest' 'old hermit'
  @forestClearing
  "He looks like a scruffy old hermit. "
  isHim = true  
  globalParamName = 'hermit'
  makeProper()
  {
    initializeVocabWith('jeremiah/jerry');
    name = 'Jeremiah';
    isProperName = true;
    return name;
  }  
  beforeAction()
  {
    if(gActionIs(Take) && gDobj == sack && !gRevealed('oldClothes'))
    {
      reportFailure
      ('{The hermit/he} sticks out his leg to prevent you taking the sack, frowning
       at you and growling, <q>Have you no manners? Who gave you permission to
       meddle with my things?</q><.p><.reveal sack>');
       exit;
    }
    if(gActionIs(PutIn) && gIobj == stove && hermit.canTalkTo(gActor))      
    {
      switch(gDobj)
      {
        case whiteEnvelope:
        case paperScrap:
        case document:
        case greenLetter:
          if(gDobj.described)
             "<q>Wait a moment,</q> {the hermit/he} stops you, <q>I shouldn't 
              burn that if I were you.</q><.p>";
          else
             "<q>What are you doing? {the hermit/he} protests, <q>Have you
              even looked at it?</q>" ;
          exit;
                 
       case greenBook:
       case redBook:
       case blueBook:
          "<q>Don't do that!</q> {the hermit/he} stops you, <q>Burning books is
           always wrong, whatever they say.</q> ";
          exit;
         
       case rubberSheet:
       case boots:
         "<q>No - not {that dobj/him}!</q> {the hermit/he} protests, <q>You'll stink
         the place out!</q><.p>
          <q>Oh, right,</q> you reply, stopping yourself putting {the dobj/him} in
          the stove  just in time. ";
         exit; 
       }
    }
    
    if(gActionIs(PutIn) && gIobj == stove && 
       (gDobj == pressRelease || pressRelease.isIn(gDobj))
       && hermit.canTalkTo(gActor))
    {
      "{The hermit/he} nods in eager approval, <q>Yes, burn it!</q> he declares,
       as you open the stove.<.p>";
    }   
    if(isIn(ricketyChair) && gDobj==ricketyChair &&
     !(gActionIs(Examine) || gActionIs(LookUnder) || gActionIs(LookBehind)))
     {
       "<q>Leave my chair alone!</q> growls {the hermit/he}. ";
       exit;
     }
    inherited;
  }
  afterAction()
  {
    if(gActionIs(Yell))
      "<.p><q>There's no need to shout! I can hear you quite well, you know.</q>
       {the hermit/he} complains.<.p>";
    if(gActionIs(Push) && gDobj == redButton)
      "<q>Let's get out of here!</q> {the hermit/he} urges. ";
    inherited;
  }
  
  iobjFor(ThrowAt)
  {
    verify() { illogical('You have no reason to throw anything at {the hermit/him}. '); }
  }
  cannotKissActorMsg = 'That would probably embarrass him, and you\'ve no reason
   to do that. ' 
  uselessToAttackMsg = 'You really don\'t want to do that; right now he may be the
   only friend you\'ve got. '  
  smellDesc = "Frankly, he smells a bit unwashed. "
  thankResponse()
  {
    if(gRevealed('old-clothes'))
      "<q>Thanks for all your help!</q> you say.\b
       <q>My pleasure!</q> he shrugs. ";
    else
      "<q>Thanks!</q> you declare.\b
       <q>I can't imagine what for!</q> he replies. ";
  }
;

+ TopicGroup
  isActive = true
;

++ AskTopic, SuggestedAskTopic, StopEventList @hermit
   [
   '<q>So, who are you -- and what are you doing here?</q> you ask.\b
   <q>Who am I?</q> he repeats, <q>I <i>am</i> nobody, and being nobody I have to live
    nowhere -- and this is as near nowhere as I can find. Who <i>was</i> I? Now that\'s a
    different matter -- I was a priest, but since the New Enlightenment did away with
    God it had no further use for priests, and so we were abolished -- along with any
    other profession that might challenge the power of the state.</q><.reveal new-enlightenment>
    <.reveal god>',
    
    {: "<q>Do you have a name?</q> you enquire.\b
    <q>I did,</q> he replies, <q>Now I find it better not to -- anonymity is my
     last defence. But you can call me <<hermit.makeProper>> if you like --
     it seems appropriate</q>"}, 
     
     {: "<q>What else can you tell me about yourself?</q> you ask.\b
      <q>Nothing -- I\'m just an ex-priest in a society in which priests are
      <i>personae non gratae</i><<personaNote.noteRef>></q> he shrugs." }
   ]
   name = 'himself'
;


++ AskTopic @t_sex
   "<q>What are your views on sex?</q> you ask.<.p>
    <q>What would I know about it? I've been celibate all my life!</q> he replies. "
;

++ AskTopic, SuggestedAskTopic, StopEventList @t_god
  [
    '<q>How does God come into it? Why is the New Enlightenment so opposed to him?</q>
    you inquire.\b
    <q>All tyrannies oppose God.</q> the one-time priest explains, <q>Although they may 
    set up an idol of their own and call it <q>God</q>. But the current idol is called
    <q>Reason</q>. Of course that just disguises its true nature -- in reality our rulers
    have made an idol of themselves -- but idolatry always hides its true nature behind
    some lie or other. God -- the true God -- is the revealer of truth and unmasker of
    idols -- that\'s why no tyranny can allow him.</q><.reveal reason><.reveal idolatry>',
    
    '<q>Do you really think God exists?</q> you ask.\b
     <q>People exist,</q> {the hermit/he} replies, <q>rocks, flowers and rivers
      <i>exist</i>. To say that God <i>exists</i> would be to make him one
      more existent among others, which he certainly isn\'t. God doesn\'t
      <i>exist</i>, he <i>is</i>.</q>',
      
    {: "<q>So God is -- but he doesn\'t exist?</q> you ask.\b
     <q>That\'s right,</q> {the hermit/he} affirms, <q>to say that God exists is
      to say too little -- he is the ground for anything existing at all. God is
      not an existent -- he is <i>to on</i> as Philo put it, Being itself -- Being, 
      not just <i>a</i> being.</q><<toOnNote.noteRef()>>"},
      
     '<q>But if God is, and the New Enlightenment is so anti-God, why does
      God permit it?</q> you ask, congratulating yourself on your cleverness.\b
      {The hermit/he} gives you a bleak look, <q>When God is merciful he may
      punish our misdeeds,</q> he replies, <q>but when he\'s <i>really</i> 
      wrathful he sends the most chilling judgment of all -- he lets us have
      what we want. We wanted the New Enlightenment, we got the New Enlightment,
      never has the punishment fit the crime so well.</q>',
      
     '<q>What\'s the difference between a God who leaves us to our own devices
      and one that doesn\'t exist at all?</q> you complain.\b
      <q>The difference is the ultimate destiny of the universe,</q> he replies,
      <q>the difference is whether we have any grounds for hope.</q>'
   ]
   name = 'God'
   isActive = (gRevealed('god'))
;

++ AskTopic @t_reason
  "<q>Is reason such a bad thing?</q> you wonder.\b
   <q>Certainly not,</q> {the hermit/he} replies, <q>But the elevation of purely
    instrumental reason to quasi-divine status -- now that's another matter.</q>"
   isActive = (gRevealed('reason'))
;

++ ShowTopic @hat
  "<q>Very fetching,</q> {the hermit/he} remarks dryly. "
;

++ GiveTopic @hat
  "{The hermit/he} waves it away, <q>No thank you,</q> he says, very firmly,
   <q>I'm sure your need is greater than mine!</q>"
;

++ AskTellTopic, StopEventList, SuggestedTellTopic +110  
  [t_squareCircle, whiteCoat, t_square, t_circle]
 [
   '<q>They said my punishment was that I had to draw a square circle,</q>
    you tell him, <q>that they wouldn\'t let me out till I did. Why do you
    think that was, do you think?</q>\b
    <q>That\'s certainly rather strange,</q> {the hermit/he} concurs, <q>Perhaps
     it was some kind of experiment -- it wouldn\'t surprise me if they\'re
     experimenting on prisoners now.</q>',    
    
    '<q>I achieved the task by drawing four arcs round a great circle on
     a globe,</q> you explain, <q>and explaining that in spherical geometry
     the lines were straight, being the shortest distance between two points,
     so that my circle was a square.</q>\b
     <q>And they bought that?</q> {the hermit/he} asks.\b
     <q>Apparently,</q> you confirm.\b
     <q>And what happened then?</q> he asks.<.p>
     <q>The guardian left, apparently indicating that I was free to go,</q>
     you reply.<.p>
     <q>It <i>must</i> be some weird sort of experiment,</q> he decides.
     <.reveal experiment-opinion>',
        
    '<q>So what do you think this square circle business is all about?</q>
     you wonder.\b
     <q>Some kind of experiment,</q> he says, <q>I heard there was an
      experimental punishment facility being built round here, so that
     must be it.</q>'
    

 ]
 name = 'the square circle'
;

+++ AltTopic, SuggestedTellTopic, StopEventList
  [
    '<q>There\'s another thing,</q> you add,
    <q>After the guardian let me out I ran into this bloke in the
     prison grounds who seemed very keen to talk to me about
     my square circle.</q><.p>
     <q>What kind of bloke?</q> {the hermit/he} asks.<.p>
     <q>Some fellow in a white coat,</q> you reply.<.p>
     <q>A scientific-looking type?</q> {the hermit/he} suggests,
     <q>It sounds more and more to me like it\'s all some elaborate
     kind of experiment.</q>',
     
    '<q>I obviously didn\'t give the white-coated fellow the answer
     he wanted about my square circle.</q> you remark, <q>He kept
     repeating his question, and when I kept giving him the wrong
     answer he jabbed something into my arm, and I woke up again
     some time later to find I\'d been locked up again.</q><.p>
     <q>Sounds more and more like some bizarre psychological
      experiment,</q> {the hermit/he} muses, <q>A square circle
     is, after all, on the face of it the ultimate contradiction,
     the ultimate irrationality. It doesn\'t surprise me that people
     who have made a god out of rationality should want to test its
     boundaries, which seems to be what\'s happening here.</q>
     <.reveal rationality-test>',
     
     '<q>So you reckon I\'m just kind of experimental subject, and
      that\'s what this square circle business is all about?</q> you
      remark.<.p>
      <q>That certainly seems the most likely explanation,</q> he
      agrees. '     
  
  ]
  name = 'the square circle'
  isActive = (gRevealed('experiment-opinion') && gPlayerChar.hasSeen(whiteCoat))
;

+++ AltTopic, SuggestedTellTopic, StopEventList
  [
    '<q>That scrap of paper I showed you -- the one I found on the hillside
     -- that mentions a square circle.</q> you point out.<.p>
     <q>True,</q> he nods, going on to quote,<q><q>Your square circle idea
      is great.</q> But great for what? A great idea for an experiment perhaps?</q>',
      
     {: "<q>I\'m not so sure the note is proposing a square circle experiment.</q>
      you frown dubiously.<.p>
      <q>I suppose that depends on how you fill in the lacunae<<lacunaNote.noteRef()>>,</q>
       he replies, <q>Perhaps it means someone was going to propose the idea to
       Dunderhead.</q>" },
       
    '<q>So you still think that making me draw a square circle was some elaborate
     kind of experiment.<q> you remark.<.p>
     <q>That seems the explanation that best fits what we know,</q> he concurs.'  
   
  ]
   name = 'the square circle'
  isActive = (gRevealed('rationality-test') && gRevealed('paper-scrap'))
;

+++ AltTopic, SuggestedTellTopic, StopEventList
  [
    '<q>Another thing puzzles me about this square-circle business,</q>
     you remark, <q>That white coated-fellow was very keen that I should
     sign a statement to the effect that not only I had drawn a square
     circle, but that anything I said or might say about square circles
     was to be understood in the light of that.</q><.p>
     <q>Understood in the light of the fact that a square circle is
      perfectly possible, you mean?</q> he asks.<.p>
     <q>Yes, precisely,</q> you confirm.<.p>
     <q>Ah!</q> he declares, <q>You know what that means, don\'t you?</q>
     <.convnode know-what-that-means><.topics>',
     
    '<q>So this square circle business is relevant to who I am, and what I\'ve
     done?</q> you muse.<.p>
     <q>Precisely!</q> he concurs. '
  ]
   name = 'the square circle'
  isActive = (gRevealed('rationality-test') && gRevealed('squarecircle-statement'))
;

+++ AltTopic, SuggestedTellTopic, StopEventList
  [
    '<q>So this whole business about an unspeakable crime and the bizarre
     punishment of having to draw a square circle was just an elaborate ruse
     to get me to sign some statement?</q> you muse.<.p>
     <q>In their book you <i>had</i> committed an unspeakable crime -- or you
      were about to, which amounts to the same thing,</q> he points out,
      <q>You, Pandra, architect of the New Enlightenment, were about to go on record as
      declaring your whole design to be as absurd as a square circle. What effect
      would that have had? It would have destroyed the credibility of the New Enlightenment
      project in an instant -- leaving our present rulers suddenly looking very foolish,
      to say the least. They could hardly hope to cling on to power after a fiasco 
      like that, so they <i>had</i> to try to defuse such a statement. Adapting
      an experimental punishment centre as part of an elaborate ruse to get you
      to sign something would seem a 
      miniscule price to pay for people desperate to cling on to power.</q>',
      
    '<q>So even with me out the way, they needed my signature on a piece of paper
      to prove I think a square circle is possible -- just in case something I said
      comparing the New Enlightenment to a square circle should leak out.</q>
      you surmise.<.p>
      <q>That seems to be about it,</q> {the hermit/he} agrees. ',
      
    '<q>So this whole square circle business all comes down to spin?</q> you ask.<.p>
     <q>Yes, it all comes down to spin,</q> he nods. '  
  ]
  isActive = (gRevealed('pc-is-pandra'))
;


++ AskTopic [t_rulers, t_government]
  "<q>So, who is in charge now?</q> you wonder, <q>I'm afraid I can't
   remember anything!</q>\b
   <q>Our rulers, God bless them, are the people democratically elected to
    run our affairs in the most rational way.</q> he replies, with more than
    a trace of irony in his voice. <q>The fact that they happen to look like
    a self-perpetuating clique of tyrants is just...</q> he breaks off,
    shaking his head in angry frustration. "
;

++ AskTopic, StopEventList @t_cabal
  [
   '<q>Who or what exactly is this <q>cabal</q> you mentioned?</q> you ask.<.p>
    <q>They call themselves the <q>Rational Democrats</q></q>, he replies, <q>though
    I can\'t see anything remotely democratic about them. I suppose their
    appeal was that they appeared to offer something new when all the other parties
    seemed old, tired and corrupt.</q> ',
   
    '<q>So what sort of people are in this Rational Democratic Cabal?</q> you
     wonder.<.p>
     <q>Wicked people who love power, and foolish ones who can\'t distinguish rationality from
     wisdom,</q> he grunts.<.reveal wisdom>',
     
    '<q>So, is there any way of getting rid of the Rational Democrats?</q> you wonder.<.p>
     <q>Chance would be a fine thing!</q> he declares. '    
  ]
  isActive = gRevealed('cabal')
;

++ AskTopic @t_wisdom
  "<q>How does wisdom differ from rationality?</q> you wonder.<.p>
   <q>Wisdom is wider,</q> he replies, <q>You can't be wise if you're irrational, but
    you can be perfectly rational and very unwise. Trying to live by rationality alone,
    abolishing tradition and abandoning the past -- now that is very unwise indeed!</q>
    <.reveal tradition>"
  isActive = gRevealed('wisdom')
;

++ AskTopic, StopEventList @t_tradition
  [
    '<q>Is tradition so important?</q> you wonder?<.p>
     <q>Of course!</q> he replies, <q>Tradition means what is handed down from
      one generation to the next. Without tradition humankind would be nothing --
      an insignficant and probably extinct biped. The stupidity of <i>contrasting</i>
      rationality and tradition beggars belief. Without tradition there would <i>be</i> no 
      rationality. Rationality presupposes language, and our language is part of
      our tradition.</q>',
      
     '<q>So you don\'t think tradition hold us back?</q> you ask.<.p>
      <q>Without tradition, progress would be impossible,</q> he points out, <q>Without
       one generation handing on its wisdom and knowledge to the next, each generation
       would have to start afresh from scratch.</q>',
       
     '<q>Tradition can impede progress, surely,</q> you suggest.<.p>
      <q>Too much food can kill you,</q> he points out, <q>but that doesn\'t mean
      you can live without eating. If in some sent we are what we eat, in a far
      more distinctively human way we are our traditions -- our past makes us who
      we are, and without it, we\'d be nothing.</q>',
      
     '<q>So you think the New Englightenment is wrong to devalue tradition,</q>
      you surmise.<.p>,
      <q>I think it\'s utterly crazy,</q> he tells you. '
  ]
  isActive = gRevealed('tradition')
;

++ AskTellTopic, SuggestedTellTopic @river
  "<q>The river seems very swollen,</q> you remark.\b
   <q>Yes,</q> he agrees, <q>it's the heavy rain we've had recently. What with
   the flooding and the damage to the bridge, we seem to be cut off from the
   south bank altogether.</q><<gSetKnown(damagedBridge)>> "
   name = 'the river'
;

++ AskTopic, SuggestedAskTopic +110 @t_flood
   "<q>How did all this flooding come about?</q> you wonder.\b
    <q>It started raining heavily the night before last and carried on well
     into yesterday,</q> he tells you. "
   name = 'the flooding'
   isActive = (gPlayerChar.knowsAbout(river) || gPlayerChar.knowsAbout(damagedBridge))
;

++ AskTopic, SuggestedAskTopic @damagedBridge
  "<q>What's happened to the bridge?</q> you ask.\b
   <q>Flood damage,<q> he replies, <q>it must have been due for repair anyway,
    but this recent flooding was the last straw. It's not safe to cross now.</q> "
   name = 'the bridge' 
;

++ AskTellTopic, SuggestedTellTopic, StopEventList @gPlayerChar
  [
   {: "<q>I really can\'t remember much about myself,</q> you remark,
   <q>how can I find out who I am?</q>\b
   <q>Perhaps you need to find something that jogs your memory,</q> {the hermit/he} suggests, 
   <q>Can you remember anything at all?</q>\b
   <q>Just before I was arrested -- a picnic -- on a hillside -- with <i>someone</i>,</q> you
    struggle to recall, <q>Oh, it\'s no good! It just won\'t come into focus!</q>\b
   <q>There\'s a prominent hill near here, just to the north of this forest,</q> he
    remarks, <q>I don\'t know if that\'s the one -- but it can\'t hurt you to
    go and take a look; and it may just jog something in your memory.</q>
    <<gSetKnown(hill)>><.reveal id-quest>" },
    
   '<q>I wish I knew who I was!</q> you declare.\b
    <q>Like I said,</q> he reminds you, <q>Go and take a look at that hill -- it might
     just jog your memory.</q>'
  ]
   name = 'yourself'
;

+++ AltTopic, SuggestedTellTopic
  "<q>I'm sure something happened on that hillside -- something terribly significant.
  I keep getting these images, but they're just flashes -- fragmentary -- and I can't 
  get a coherent picture,</q> you tell him, <q>if only I could remember!</q>\b
  {The hermit/he} regards you compassionately, <q>We are what we remember, our stories
  define us,</q> he remarks, <q>so try a bit harder!</q>" 
  isActive = cartridgeCase.discovered
  name = 'yourself'
;

++ AskTellTopic, SuggestedAskTopic, StopEventList @hill
  [
    '<q>Where is this hill, exactly?</q> you ask.\b
     <q>Just to the north,</q> he tells you. <q>From the clearing outside my
      hut, take the path off to the northwest till it meets another path from
      the north. Carry on up that path to the north and you\'ll pretty soon
      come out on the hillside.</q>',
      
    '<q>Can you remind me where I can find that hill?</q> you ask.\b
     <q>Dear me, they really have tampered with your memory!</q> {the hermit/he}
      declares. <q>From outside my hut, go northwest. Then take the path up to
      the north -- and you\'ll be there.</q>'
  ]
  name = 'the hill'  
;

+++ AltTopic, SuggestedTellTopic
  "<q>There\'s definitely something familiar about that hill,</q> you say,
   <q>I feel sure I've been there before -- quite recently.</q>\b
   <q>And?</q> {the hermit/he} prompts.\b
   <q>And I feel certain something terrible happened there.</q> you remark."
  isActive = (hill.seen)
  name = 'the hill'
;


++ TellTopic, SuggestedTellTopic, StopEventList +110 [t_pandra, gPlayerChar]
 [
 '<q>I begin to remember now,</q> you say, <q>I was meeting someone -- a very special
  someone -- on the hill. We began to talk -- about my doubts -- my change of view -- my
  growing suspicion that the whole New Enlightenment project -- that damned New Enlightenment
  project that my own book set in motion -- that the whole wretched thing was turning
  out as absurd as trying to draw a square circle. We were discussing some grand plan
  to put a great big spanner in the works.</q>\b
  <q>So what happened?</q> {the hermit/he} asks gently.\b
  <q>We must have been betrayed,</q> you reply bitterly, <q>I still don\'t remember all
  that clearly, but I think the person I was with was shot trying to defend me -- and I 
  must have been arrested, but I just don\'t remember what happened next.</q>\b
  <q>Wait a minute,</q> {the hermit/he} interrupts, <q>Are you trying to tell me
  that <i>you</i> are Pandra? I don\'t believe it!</q> ',
  
  '<q>Yes, I am Pandra!</q> you declare.\b
   <q>I don\'t believe it!</q> he protests, <q>You can\'t be! They\'d never treat
    Pandra like that!</q>',
    
  '<q>But I <i>am</i> Pandra!</q> you insist, <q>I can prove it!</q>\b
   <q>Then prove it!</q> he demands. '  
  
   
  ]
  name = 'yourself'
  isActive = pandraPicture.described
;

+++ AltTopic, SuggestedTellTopic, StopEventList
  [
    '<q>In a funny sort of way my punishment was just,</q> you muse, <q>I <i>am</i> guilty --
   but not of crimes against the New Enlightenment as my jailors presumably supposed,
   but of dreaming the wretched thing up in the first place.</q>\b
   <q>Quite so,</q> {the hermit/he} concurs, <q>and you now regret it?</q>
   <.convnode regret-it>',
   
   '<q>Well, I\'m in a right fix now,</q> you conclude, <q>The arch-enemy of all who
    oppose the New Enlightenment, and the New Enlightenment\'s public enemy number one!</q>\b
    <q>Then the time has come for you to choose sides and act accordingly,</q> {the hermit/he}
     suggests.'
  ]
  name = 'yourself'
  isActive = gRevealed('pc-is-pandra')
;

++ AskTopic, SuggestedAskTopic, StopEventList @t_newEnlightenment
  [
    '<q>What is this <q>New Enlightenment</q> exactly?</q> you wonder.\b
    The old hermit looks momentarily astounded, then collects himself as he replies,
    <q>My goodness -- they really have tampered with your memory, haven\'t they? The
     New Enlightenment is the recent glorious revolution that has brought about
     the triumph of reason over obfuscation in human affairs, so that in future all
     our lives may be ordered rationally with nothing messy like religion, passion
     or tradition getting in the way. The only problem is our glorious rulers get
     to define what\'s rational  -- and for some reason that always excludes
     any opposition to our rulers. 
     It\'s all based on Pandra\'s ideas, of course</q><.reveal pandra>.<.reveal reason>
     <.reveal tradition>',
     
     '<q>I take it you don\'t entirely approve of the New Enlightenment.</q> you
     remark.\b
     {The hermit/he} gives you a slightly pitying look, <q>Look what it\'s done
     for me. Look what it\'s done for <i>you</i>!</q> he replies.',
     
     '<q>What would it take to get rid of this New Enlightenment.</q> you wonder.\b
      <q>A miracle!</q> {the hermit/he} declares bitterly; then, looking at you
      intently, he adds, <q>What counts is their perceived legitimacy -- so long
      as our current rulers can continue to persuade the great majority of people 
      that the New Enlightenment is basically a good thing, we\'re basically stuck with 
      it; to destroy it one would have to delegitimate it.</q>',
      
     '<q>Is that ever likely to happen -- the delegitimation of the New Englightenment?</q> 
      you ask.\b
      <q>I see no sign of it,</q> {the hermit/he} concedes, <q>But nothing lasts for
      ever. One day...</q>' 
  ]
  isActive = (gRevealed('new-enlightenment'))
  name = 'the New Enlightenment'
;

++ askPandraTopic: AskTopic, SuggestedAskTopic, StopEventList @t_pandra
  [
   '<q>Who\'s Pandra?</q> you want to know.\b
    <q>No one\'s quite sure.</q> he replies, <q>But whoever he or she 
     is Pandra ' + p1,
     
    '<q>What else can you tell me about this Pandra character?</q> you enquire.\b
     <q>I know nothing of Pandra as a person,' + p2,
     
     '<q>Pandra sounds a bit of a Utopian.</q> you suggest.\b
     <q>Quite so,</q> {the hermit/he} agrees, <q>In many ways Pandra\'s critique of
      the existing -- I mean formerly existing -- order was rather acute. Perhaps that
      was what helped Pandra\'s ideas catch on.' + p3,
      
    '<q>So Pandra is not actually one of the leaders of the New Enlightenment?</q> you
      ask.\b
     <q>Pandra is the leading philosopher of the New Enlightenment, but I doubt that
      he or she is the leading administrator.' + p4,
      
     '<q>So, do you think Pandra is evil?</q> you ask.\b
      {The hermit/he} pauses to consider the question, then answers slowly, <q>Not
      evil exactly. Just very foolish -- brilliantly foolish, but totally foolish
      nonetheless. Pandra\'s critical analysis of the human condition certainly has its flashes
      of brilliance, but Pandra\'s answers -- well, let\'s just say they display a total
      ignorance of even basic theology -- or basic humanity -- but then to my old-fashioned
      way of thinking those are two sides of the same coin.</q>',
      
     '<q>So Pandra\'s to blame for the mess we\'re in?</q> you enquire.\b
      <q>Ultimately -- perhaps so.</q> {the hermit/he} agrees. ' 
  ]
  isActive = (gRevealed('pandra'))
  name = 'Pandra'
  p1 = 'wrote the text that\'s become the manifesto for our brave new society. 
     Abstract justice gone mad if you ask me -- and totally pagan, of course.</q>
     <.reveal manifesto>'
  p2 = '</q> {the hermit/he} tells you,
     <q>Pandra\'s great book -- I mean <q>great</q> in the sense of the one that proved
     so influential -- was called <i>Principles of Rational Government</i>. The central
     thesis of the book was that the ordering of society was so fundamentally unjust,
     and human affairs so thoroughly irrational, that the only way forward was to tear
     everything up -- absolutely <i>everything</i> -- and start again, designing an
     ideal society from scratch.</q>'
  p3 = ' Or perhaps they just suited the cabal who 
      took them over and installed themselves as the new government, ruling according
      to Pandra\'s rational principles.</q><.reveal cabal>'
  p4 = ' To be an administrator you have to be
      practical -- and <i>Principles of Rational Government</i> is a deeply impractical
      book, the product of an ivory-tower academic with no true
      feel for the necessary messiness of human existence. The people who run the
      New Enlightenment, however, are people who know how to make things happen in
      the real world, however disagreeable they manage to make it.</q>'
;

++ AskTopic, SuggestedAskTopic, SyncEventList +110 [gPlayerChar, t_pandra]
 [
    '<q>So, I\'m Pandra -- but who is Pandra?</q> you want to know.\b
    {The hermit/he} shakes his head in bemusement, <q>Well, Pandra -- you -- '
      + askPandraTopic.p1,
    
    '<q>What else can you tell me about what I\'m meant to have done?</q> you enquire.\b
     <q>I knew nothing about Pandra as a person up to now,' + askPandraTopic.p2,
     
     '<q>I sound a bit of a Utopian.</q> you suggest.\b
     <q>Quite so,</q> {the hermit/he} agrees, <q>In many ways your critique of
      the existing -- I mean formerly existing -- order was rather acute. Perhaps that
      was what helped Pandra\'s ideas -- your ideas -- catch on.' + askPandraTopic.p3,
      
    '<q>So I wasn\'t actually one of the leaders of the New Enlightenment?</q> you
      ask.\b
     <q>You were the leading philosopher of the New Enlightenment, but I doubt that
      you were ever the leading administrator. ' +  askPandraTopic.p4,
      
     '<q>So, do you think I\'m evil?</q> you ask cautiously.\b
      {The hermit/he} pauses to consider the question, then answers slowly, <q>Not
      evil exactly. Just very foolish -- brilliantly foolish, but totally foolish
      nonetheless. Your critical analysis of the human condition certainly has its flashes
      of brilliance, but your answers -- well, let\'s just say they display a total
      ignorance of even basic theology -- or basic humanity -- but then to my old-fashioned
      way of thinking those are two sides of the same coin.</q>',
      
     '<q>So I\'m to blame for the mess we\'re in?</q> you enquire.\b
      <q>Basically.</q> {the hermit/he} agrees, <q>The question is, can you do anything
       to put it right?</q><.convnode put-right> '
    ]
   masterObject = askPandraTopic
   name = 'Pandra'
   isActive = gRevealed('pc-is-pandra')
;



++ AskTellTopic, SuggestedAskTopic @t_tyranny
  "<q>So you think we live under a tyranny?</q> you query.\b
   {The hermit/he} raises his eyebrows in surprise, <q>I should have
    thought that was totally apparent,</q> he replies.<.p>"
   name = 'tyranny'
;

++ AskTellTopic @t_prison
  "<q>That was a very strange kind of prison they were keeping me in,</q>
   you remark.\b
   <q>They have strange ideas about many things.</q> he replies darkly. "
;

++ AskTellTopic @t_religion
  "<q>Is religion all that important?</q> you wonder.\b
   <q>Only as a means of keeping us in tune with God,</q> he replies. "
  isActive = gRevealed('god')
;

++ AskTopic, StopEventList @t_idolatry
  [ 
   '<q>You mentioned idolatry,</q> you remark, <q>What did you mean
    by it? Surely no one worships idols in this enlightened age!</q><.p>
    <q>Not idols of wood and stone, no,</q> he agrees, <q>but idolatry
    can take many forms, and putting anything before God is ultimately
    idolatry. The present cult of reason certainly is!</q>',
    
   '<q>So you think the New Enlightenment is idolatrous?</q> you ask.<.p>
    <q>It is!</q> he tells you, <q>No doubt about it!</q> ' 
  ]
  isActive = gRevealed('idolatry')
;

++ AskTellTopic, StopEventList @t_justice
  [
    '<q>I don\'t think much of the justice system round here,</q> you remark
     darkly, <q>they wouldn\'t even tell me what they\'d locked me up for!</q>\b
     <q>Ah, you are behind the times!</q> {the hermit/he} replies, <q>According
     to the modern conception of justice, you just have to be an inconvenience
     to the state to be considered guilty. <q>Justice</q> means precisely what
     our rulers want it to mean -- no more, and no less!</q>',
     
    '<q>Is there no rationality to the justice system?</q> you wonder.\b
     <q>Oh, it\'s entirely rational -- from the point of view of the ruling
     elite,<q> he assures you, <q>It lets them punish anyone they disapprove of,
     anyone who threatens them, or anyone who gets in their way. What could be
     more rational for people who desire absolute power?</q>',
     
    '<q>But this modern conception of justice just doesn\'t seem <i>just</i>,</q>
     you complain.\b
     <q>It isn\'t by any decent standard of morality,</q> {the hermit/he} concurs,
     <q>but decency is apparently one of those old-fashioned things we can do without
     in this enlightened age.</q>' 
  ]
;

++ AskTopic @t_society
  "<q>What kind of society has been created here?</q> you wonder.\b
   <q>A cold, godless, loveless one.</q> {the hermit/he} replies grimly. "
;

++ AskTopic, StopEventList @t_love
 [
  '<q>Do you believe in love?</q> you ask him.\b
   <q>Of course,</q> he replies quietly, <q>God is a God of love, and so love
   is the ultimate stuff of the universe.</q>',
   
   '<q>What is love?</q> you wonder.\b
    <q>Love is giving yourself for the sake of the other,<q> {the hermit/he}
    replies simply.</q> '
 ]
 isActive = gRevealed('god')
;

++ AskTopic, StopEventList, SuggestedAskTopic @t_manifesto
 [ 
   '<q>So what does Pandra\'s manifesto teach?</q> you ask.\b
    <q>Forget tradition, forget the past, forget every moral, social, or political
     idea anyone ever had, and start again from scratch. Treat political theory
     like geometry, and design society from the ground up on purely rational lines,
     then all our problems will vanish.</q> he replies, <q>That\'s an oversimplification,
     of course; Pandra\'s argument is more complicated -- even more subtle -- than that,
     but that\'s what it comes down to in essence: he or she tries to out-Plato Plato.</q>
     the old hermit shakes his head at the folly of it all.<.reveal plato>
     <.reveal tradition>',
     
    '<q>You\'ve read Pandra\'s book, then?</q> you enquire.\b
     <q>Oh yes, I\'ve read it,</q> he affirms bitterly.',
     
    '<q>I take it you don\'t approve of Pandra\'s great book,</q> you observe.\b
     <q>You take it correctly,</q> {the hermit/he} affirms, <q>For all its surface
      brilliance, <i>Principles of Rational Government</i> represents the triumph
      of heartless rationalistic arrogance over the spirit of true humanity.
      The tragedy is that the author seems not to recognize it -- seems even to
      appeal to the old-fashioned morality he or she seeks to abolish.</q>
      he pauses for a moment, then goes on, <q>Pandra\'s book is full of ideas about
      what would be good for society and what would be good for people, while at
      the same time calling into question every notion of goodness that any human
      being ever held. For all it\'s rationalistic dress, the book is founded on
      a fundamental contradiction -- but like all atheists, Pandra is unable to see
      the ultimate irrationality of arid rationalism.</q>',
      
     '<q>Why has Pandra\'s book proved so influential?</q> you wonder.\b
      <q>Because it seemed to speak words of hope to people who had despaired of
      the old solutions -- and because it spoke them in the technocratic language
      of science, and people believe that science and technocrats are wise.</q>
      {the hermit/he} shakes his head, and sighs, <q>In short, because we have
      all lost our way, and the voice of a confident guide sounds welcome, even
      if the only way the guide knows is in fact the way into the abyss.</q>',
      
     '<q>If Pandra\'s great book is so terrible, why has no one else seen through
      it?</q> you enquire sceptically.\b
      <q>What makes you think they haven\'t?</q> {the hermit/he} replies, <q>Of
      course, anyone who does is a social deviant, enemy of society and criminal
      by definition -- and what rational person would ever take note of such 
      riff-raff?</q>'      
      
 ]
 isActive = gRevealed('manifesto')
 name = 'Pandra\'s manifesto'
;

++ AskTopic @t_plato
  "<q>You mentioned Plato - where does he come into it?</q> you ask.<.p>
   <q>You've read the <i>Republic</i>, of course?</q> he asks.<.p>
   <q>Right now I can't remember what I've read,</q> you point out.<.p>
   <q>Never mind,</q> he replies, <q>Plato was another utopian. 
     I'm sure Pandra drew from him.</q>"
  isActive = gRevealed('plato')
;

++ AskTopic, StopEventList, SuggestedAskTopic @t_dunderhead
   [
     '<q>Who is this Dunderhead character?</q> you wonder.\b
      <q>To be honest, I don\'t know much about him.</q> {the hermit/he} confesses,
      <q>He calls himself <i>Professor</i> Dunderhead these days, but I don\'t know
       when and where he was ever employed as an academic; the title may simply be
       designed to add a veneer of intellectual respectability to the man. The fact
       that he\'s in charge of the Department of Applied Rationality suggests that he\'s
       basically a senior government administrator.</q><.p><.reveal dofar>',
       
      '<q>Is there anything else you can tell me about Dunderhead?</q> you ask.\b
       <q>Well ...</q> {the hermit/he} hesitates, <q>The fact that he\'s in the 
       position he\'s in probably indicates that he\'s a pretty solid supporter of
       the New Enlightenment, to say the least. Beyond that, I really couldn\'t say.</q>',
       
      '<q>Do you think Dunderhead might hold the key to what happened to me?</q> you wonder.\b
       <q>Well, he\'s head of the Department of Applied Rationality -- 
        he probably hold the key to all sorts of things!</q> {the hermit/he} declares.'        
   ]
   name = 'Dunderhead'
   isActive = (gRevealed('Dunderhead'))
;

++ AskTopic, StopEventList, SuggestedAskTopic @t_department
  [
    '<q>What exactly is the Department of Applied Rationality?</q> you want to know.\b
    <q>It\'s the government department responsible for working out how to put Pandra\'s
    great ideas into practice.<.reveal pandra></q> {the hermit/he} explains, <q>At least
    that\'s the theory. In practice it seems to work out the detailed implementation of
    whatever ghastly ideas our political masters come up with.</q><.p>',
    
    '<q>What sort of things do the DofAR get involved in?</q> you wonder.\b
     <q>Well, just to give you one example, I did hear they\'d set up a new experimental
      punishment facility to try out the government\'s latest ideas on penal reform.</q>
      {the hermit/he} informs you, <q>I suppose that\'s why they built that ugly prison
      blockhouse so close to the Department, stealing a big chunk of Farmer Joe\'s land
      in the process!</q><.reveal old-joe>',
      
    '<q>So the Department of Applied Rationality gets involved in just about eveything.</q>
     you surmise.\b
     <q>That\'s right!</q> {the hermit/he} agrees.'
  ]
  name = 'the Department of Applied Rationality (DofAR)'
  isActive = (gRevealed('dofar'))
;


+ hermitClearing : ActorState
  stateDesc = "He's chopping wood. "
  specialDesc = "An old man, some kind of hermit by the look of him, is chopping wood
   just outside the hut. "
  isInitState = true 
  afterTravel(traveler, connector)
  {
    if(traveler == gPlayerChar)
    {
      "As you approach, the old hermit tucks his axe under one arm, straightens, picks
       up his pile of chopped wood, and walks toward the hut. It's not quite
       clear whether he's ignoring you, avoiding you, or tacitly inviting you to
       follow him. ";
       newActorAction(getActor, Enter, smallHut);
       getActor.moveInto(ricketyChair);
       getActor.posture = sitting;
       getActor.setCurState(hermitSitting);
       gActor.setHim(getActor);
    }
  }
  sayDepartingDir(dir, conn)
  {      
    if(conn == insideHut)    
      "{The hermit/he} enters the hut. ";
    else
     inherited(conn);
  }
;

+ hermitSitting : ActorState
  stateDesc = "He's sitting in a chair. "
  specialDesc = "The old hermit is sitting in a rickety chair, trying to light his
    pipe. "
  afterTravel(traveler, connector)
  {
    if(traveler == gPlayerChar)
    {
      getActor().initiateConversation(hermitChatting, 'hermit-prisoner');
    }
  }  
;

+ hermitChatting : InConversationState
  stateDesc = "He's sitting talking with you. "
  specialDesc = "{The hermit/he} is sitting on his rickety chair, watching you
   intently. "   
  nextState = hermitWaiting 
  attentionSpan = 10  
;

++ hermitWaiting : ConversationReadyState
   stateDesc = "He's sitting in his chair, reading a book. "
   specialDesc = "{The hermit/he} is sitting in his chair, reading a book. "  
   activateState (actor, oldState)
   {
     bible.moveInto(hermit);
   } 
;

+++ HelloTopic, ShuffledEventList
  [
     '<q>Hello again.</q> you say.\b
     {The hermit/he} lowers his book and looks up at you. <q>Yes?</q> he asks.<.p>'
  ]
;

+++ ByeTopic, StopEventList
 [
     new function {       
       "<q>Goodbye, then,</q> says {the hermit/he}, picking up a small black book,
       <q>I hope you find whatever it is you\'re seeking.</q>";
     },
     '<q>Take care now!</q> {the hermit/he} admonishes you.<.p>'
  ]  
;

+++ ImpByeTopic
   "{The hermit/he} picks up his book and starts reading. ";
;

++ AskTopic, SuggestedAskTopic, StopEventList @t_hut
   [
     '<q>Did you build this hut yourself?</q> you ask politely.\b
      <q>No, I found it abandoned,</q> he replies, <q>I assume it doesn\'t fit
      in with the modern idea of rational housing policy, so no one else
      seems to want it.</q>',
      
     '<q>Do you mind living here?</q> you inquire, looking round dubiously.\b
      <q>It\'s not a palace, but it serves my present estate well enough,</q>
      he shrugs. ',
      
     '<q>Do they leave you alone in this place?</q> you wonder.\b
      <q>At the moment they seem content not to bother me if I don\'t bother
      them.</q> he replies. '
   ]
   name = 'the hut'
;

++ AskTopic, SuggestedAskTopic, StopEventList @t_forest
  [
    '<q>Have you lived in this forest long?</q> you wonder.\b
     <q>Long enough for the authorities to forget me -- I hope,</q> he replies. ',
     
    '<q>Do you like it here in the forest?</q> you inquire.\b
     <q>Yes, I do,</q> he answers, <q>It\'s the one place round here that
      feels totally untouched by New Enlightenment logic.<q>', 
     
    '<q>Do you feel safe in this forest?</q> you ask.\b
     <q>As safe as I\'m likely to feel anywhere,</q> he tells you. '      
  ]
  name = 'the forest'
;

++ AskAboutForTopic @axe
   "<q>Can I borrow your axe?</q> you ask.<.p>
    <q>Whatever for?</q> he replies, <q>I've just chopped an ample supply
    of wood, thank you very much!</q>"
;

++ AskTellTopic @smokingPipe
  "<q>Are you sure you should be smoking that thing?</q> you ask, nodding
   towards his battered old pipe, <q>I'm sure it must be bad for your
   health!</q><.p>
   {The hermit/he} gives you a particularly sour look before answering, <q>I
   don't need lessons on health care from you or anyone else, thank you
   very much!</q>"
;


++ AskAboutForTopic, StopEventList, SuggestedAskTopic @sack
   eventList =
   [
     {: "<q>What\'s in that sack -- the one under the table?</q> you wonder.\b
      <q>Oh just some old clothes I\'m going to burn.</q> he replies, <q>They\'re
       too far gone even for me.</q> He glances at you critically, <q>They might
       fit you, but they\'re in a truly dreadful state -- still, looking like
       a disgusting tramp could be better than looking quite so obviously like
       an escaped prisoner; would you like them?</q>
       <.p><<gSetKnown(oldClothes)>><.convnode offer-clothes>" },
       
     '<q>What did you say was in that sack?</q> you ask.\b
      <q>Just some old clothes.</q> he reminds you.'
   ]   
   name = 'the sack'
   timesToSuggest = (sack.described ? 1 : 0)
;

++ AskTellTopic, StopEventList, SuggestedTellTopic @pig
   [
     '<q>I\'ve just come across the most extraordinary thing -- a pig that\'s guarding
      its trough as if it contained the Crown Jewels -- it won\'t let me take a thing
      from it!</q> you tell him.\b
      <q>Sounds to me like the poor animal\'s desperately hungry and in need of feeding.</q>
      {the hermit/he} opines.',
      
     '<q>Who\'s pig is it? Who should be feeding it?</q> you wonder.\b
      <q>It\'s old Joe\'s<.reveal old-joe></q> {the hermit/he} tells you, <q>But I expect he\'s been cut
      off from that part of his farm by the river flooding.</q>' ,
            
     '<q>So that poor old pig needs feeding.</q> you surmise.\b
      <q>I\'m sure it would appreciate being fed.</q> {the hermit/he} agrees. '
   ]
   name = 'the pig'
   isActive = gRevealed('pig-guard')
;

+++ AltTopic
   "<q>Well, I finally managed to outwit that pig.</q> you tell him, <q>I gave him a
     a handful of acorns and then I was able to retrieve a battered old hat from the
     trough.</q>\b
    <q>From the pig's perspective he probably outwitted you.</q> {the hermit} chuckles,
     <q>After all a battered old hat isn't that much use to anyone -- let alone a pig --
     but in exchange he got fed with acorns.</q>"
   isActive = (hat.moved)
;

++ AskTellTopic, StopEventList, SuggestedAskTopic @oldClothes
   [
     '<q>What state are the clothes in that sack in?</q> you ask.\b
     <q>Terrible</q> he tells you, <q>I wouldn\'t be seen dead in them myself.</q> ',
     
     '<q>But are they wearable?</q> you wonder.\b
     <q>That depends what you mean by <q>wearable</q></q> {the hermit/he} replies. '
   ]
   isActive = (!sack.moved)
   name = 'the old clothes'
;


++ AskAboutForTopic +110 [sack, oldClothes]
   "<q>If you're only going to burn them otherwise, is there any chance I could
    have that sack of old clothes?</q> you ask.\b 
    <q>Help yourself.</q> {the hermit/he} shrugs.<.reveal oldClothes>"
   isActive = (!sack.moved && gPlayerChar.knowsAbout(oldClothes))
;

++ AskTellTopic, StopEventList @t_clothes
   [
     '<q>I could really do with a change of clothes; this prison uniform
      is far too conspicuous,</q> you point out.<.p>
      <q>Apart from the rags I\'m wearing, I have nothing to wear apart from
      some even tattier rags I\'m about to burn,</q> he tells you. ',
      
     '<q>If you\'ve got some old clothes you\'re going to burn, is there
      any chance I could have them?</q> you ask hopefully.<.p>
      <q>They\'re in the sack under the table,</q> he nods,
      <q>Would you like to take a look?</q><.convnode offer-clothes> '      
   ]
   isActive = (!sack.moved && !gPlayerChar.knowsAbout(oldClothes))
;


++ GiveShowTopic @pandraPicture
   topicResponse()
   { 
     replaceAction(GiveTo, document, getActor);
   }
;


++ AskTellGiveShowTopic, StopEventList @document
   [
     new function {
     "{The hermit/he} takes the document and studies it carefully. As he reaches the
      last page and sees the photograph his eyebrows disappear up into his hair-line. ";
      if(!document.hasBeenRead)
      {
        "<q>Have you read this?</q> he asks.\b
         <q>Not yet</q> you admit.\b
         <q>I think you should.</q> he insists, handing it back to you.\b
         So you take the document and read it. ";
         local oldLoc = document.location;
         document.moveInto(gPlayerChar);
         nestedAction(Read, document);
         "\nYou turn the page to examine the picture. ";
         nestedAction(Examine, pandraPicture);
         document.moveInto(oldLoc);
         "\b<q>Wow!</q> you declare, handing the document back to {the hermit/him}.\b";
      }
      else if(!pandraPicture.described)
      {
         "He turns it round for you to see. ";
          nestedAction(Examine, pandraPicture);
          "<.p>";
      }
      "<q>So you are Pandra!</q> he declares.\b<.reveal pc-is-pandra>
      <q>So it would seem.</q> you confess.\b
      <q>And you were thinking of <i>denouncing</i> the New Enlightenment?</q>
       he queries incredulously.\b
      <q>So it would seem.</q> you affirm.\b
      {The hermit/he} studies the document a little longer, then shakes his head
      in bemusement, <q>If only there were some way of getting this published!</q>
      he sighs.<.reveal pandra-document> He stares down at the document for a
      few moments more, then looks up at you. <q>One thing's for sure, at any
       rate, you can't go back to your old life now -- ever. I suppose that leaves
       you two choices, so what will you do -- fight or flee?</q>
      <.convnode choose-sides>";
     },
      
      '<q>What do you think would happen if this document got into the public
       domain?</q> you wonder.\b
       <q>The great Pandra, architect and prophet of the New Enlightenment project,
        arrested and imprisoned for likening the whole thing to the impossibility
        of a square circle?</q> he muses, <q>The effect on the Government\'s
       credibility would be devastating!</q>',
       
      '<q>So you think I should try to get this published?</q> you ask.\b
       <q>Now how do you propose to do that?</q> he chuckles bitterly, <q>All the
       media are controlled by the government -- no one will touch it!</q>'      
   ]
   isActive = (getActor.canSee(document))
;

++ AskTellTopic @document
   "<q>I've found this extraordinary document!</q> you begin, <q>It's about
    Pandra and...</q>\b
    <q>Why don't you show me?</q> {the hermit/he} suggests. "
   isActive = (!getActor.canSee(document))
;

++ AskTellGiveShowTopic, StopEventList @pressRelease
   [
     '{The hermit/he} reads it and remarks, <q>So
      it comes to this. Even the pretence of democracy is being
      abandoned. Of course it\'s all entirely logical on New Enlightenment 
      principles.</q>',
      
     '<q>What will happen if this press release doesn\'t get to the Government
      Broadcasting Directorate?</q> you wonder.\b
      {The hermit/he} ponders for a moment, then replies, <q>The people won\'t know
      that the Government has so kindly relieved them of the burden of voting for
      their masters, so they\'ll turn out to the polling stations tomorrow 
      expecting voting as usual. Could be interesting!</q> he smiles. ',
      
      '<q>So what do you suggest I do with this press release?</q> you ask.\b
       <q>Destroy it!</q> he declares.'
      
   ]
   isActive = (getActor.canSee(pressRelease))
;

++ GiveShowTopic @blueCoveralls
   "<q>What do you think I should do with these?</q> you ask, showing him
    the blue coveralls.\b
    <q>I'd get rid of them if I were you.</q> he suggests, <q>They can only
     incriminate you.</q>"
   isActive = !blueCoveralls.isWornBy(gPlayerChar)
;

++ GiveShowTopic, StopEventList @coverPage
   [
     '<q>Looks like there\'s something here they <i>really</i> don\'t
       want people to know about,</q> he observes as he scans the note. ',
       
     '<q>There\'s not much point keeping this,</q> he observes, waving
      the note. '  
   ]
;

++ GiveShowTopic [whiteEnvelope, brownEnvelope]
   topicResponse()
   {
      local envelope = gDobj;
     "You hand {the dobj/him} to {the hermit/him}; he glances at the address
      and then looks inside. ";
      envelope.moveInto(hermit);      
      if(!envelope.isOpen) nestedActorAction(hermit, Open, envelope);
      if(envelope.contents.length==0)
        "<q>It's empty.</q> he observes. ";
      else
        foreach(local cur in envelope.contents)
        {
           "<.p>He takes <<cur.theName>>. ";   
           cur.moveInto(gPlayerChar);     
           nestedAction(ShowTo, cur, hermit );
           " He replaces <<cur.theName>> in the envelope. ";
           cur.moveInto(envelope);
        }
      "So saying, he hands the envelope back to you.<.p>";     
     envelope.moveInto(gPlayerChar);
   }  
;

++ AskTellGiveShowTopic, StopEventList @greenLetter
  [
  '{The hermit/he} reads the green letter, then remarks, <q>I expect you
    could get just about <i>anything</i> published with a covering letter
    like that!</q>\b
    <q>Anything?</q> you query.\b
    <q>Anything!</q> he affirms, <q>If it comes with the imprimatur of the
     Department of Applied Rationality, then it must be rational to publish
     it. I\'m sure that\'s how the Government Broadcasting Directorate would
     see it, anyway.</q> ',
     
     '<q>So you reckon I could get <i>anything</i> published with this covering note?</q>
      you ask.\b
      <q>Yes -- the only problem would be getting it delivered to the Government
      Broadcasting Directorate in a way that didn\'t arouse their suspicions.</q>
      he tells you. '
   ]  
  isActive = (getActor.canSee(greenLetter))
;

++ TopicGroup 
   isActive = (greenLetter.isIn(whiteEnvelope) && document.isIn(whiteEnvelope)
    && gRevealed('pandra-document')) 
   matchScoreAdjustment = 50  
;

+++ GiveShowTopic, StopEventList @whiteEnvelope
  [
    'You hand the white envelope over to {the hermit/him} and he promptly
     examines its contents. <q>If only you could get that delivered to the
     Government Broadcasting Directorate,</q> he sighs longingly, <q>They\'d
     be sure to publish the Pandra document straight away, and then the very
     foundations of the New Enlightenment would be shaken!</q>',
     
     '{The hermit/he} inspects the white envelope again. <q>It\'s just fine!</q>
      he declares, <q>If only we could get it delivered to the GBD!</q>'
  ]
;


++++ AltTopic, ShuffledEventList
  [
    '<q>You\'ve got too much in there.</q> {the hermit/he} decides, after
     glancing inside. ',
     
    '<q>It\'d work better if you took out the inessentials.</q> he advises. ',
    
    '<q>What\'s all this other stuff doing in here?</q> he complains. ',
    
    '<q>Too much,</q> he shakes his head, <q>too much!</q> ' 
  ]
  isActive = (whiteEnvelope.contents.length > 2)
;

+++ AskTellTopic, StopEventList [whiteEnvelope, document, greenLetter]
   [
     '<q>How could we get this package delivered to the Government Broadcasting
       Directorate?</q> you ask.\b
      <q>Good question,</q> {the hermit/he} sighs. <q>It would have to be by
       some route they were expecting -- but how could we achieve that? We can
       hardly just turn up at their door and hand it to them!</q>',
       
      '<q>So what should we do with this?</q> you wonder.\b
       <q>Find a way to insert it into the government\'s normal communications
       traffic.</q> {the hermit/he} suggests, <q>But don\'t ask me how we
       can do that!</q>',
       
      '<q>So, what am I going to do with it?</q> you want to know.\b
       <q>I suppose that\'s up to you.</q> he tells you. ' 
   ] 
;

++++ AltTopic
  topicResponse()
  {
    nestedAction(ShowTo, whiteEnvelope, hermit);
  }
  isActive = (whiteEnvelope.contents.length > 2)
;


++ GiveShowTopic, StopEventList @paperScrap
  [
    {: "<q>What do you make of this?</q> you ask, showing the scrappy note to 
       {the hermit/him}.\b
       <q>Well, it\'s quite hard to make out, isn\'t it?</q> he points out, <q>Especially
     with so many lacunae<<lacunaNote.noteRef()>> in the text. It could be reconstructed
     in so many ways. Perhaps, <q>We'll meet to discuss this, my leader, at our familiar
     rendez-vous. Your Square Circle idea is great, but won't they object to the
     cost? If they think you\'re promoting the New Enlightnment that might help. They
     can be far more daring than you can imagine. Dunderhead and his staff will
     spare no expense if they think it\'s really worth it.</q> Of course I'm just
     making that up as I go along - there must be dozens of other ways you could
     fill in those blanks.<.reveal paper-scrap></q><.reveal Dunderhead>\b
     <i>Yes, there must,</i> you think -- and as dim memories stir you feel
      strangely certain that {the hermit/he}\'s reconstruction is almost
       totally wrong."} ,  
     
     '<q>Any other ideas?</q> you wonder, showing it to him for a second time.<.p>
     <q>I\'m not sure.</q> he admits. <q>I assume the <q>Dunderhead</q> it mentions is the
    Dunderhead who\'s the Senior Director of the Department of Applied Rationality.</q>
    <.reveal dofar>',     
     
     '<q>So what do you think this note means?</q> you ask.<.p>
      <q>Your guess is as good as mine,</q> he shrugs. ',
     
    '<q>Any other ideas?</q> you ask.\b
    <q>No.</q> he replies, adding with an ironic chuckle, <q>Perhaps Dunderhead can
     enlighten you!</q>'
  ]
;

++ CommandTopic @FollowAction
   "<q><<dobj==gPlayerChar ? 'Would you come with me, please'
    : 'Could you follow ' + dobj.theName>>?</q> you ask.<.p>
    <q>Not without good reason,</q> he replies. "
   handleTopic(fromActor, obj)
   {
     action = obj;
     inherited(fromActor, obj);
   }
   action = nil
   dobj = (action == nil ? nil : action.dobjList_[1].obj_)   
;


++ DefaultGiveShowTopic
  "{The hermit/he} doesn\'t seem remotely interested. "
  deferToEntry(other) { return !other.ofKind(DefaultTopic); }
;

++ DefaultTellTopic
 "{The hermit/he} listens <<rand('sympathetically', 'intently', 'politely')>> while
  you tell him all about <<topicText()>>. "
  deferToEntry(other) { return !other.ofKind(DefaultTopic); }

;


++ DefaultAskTopic, ShuffledEventList
   [
     '{The hermit/he} frowns and scratches his ear; perhaps he didn\'t hear you,
      or perhaps he just doesn\'t choose to reply. ',
      
     '{The hermit/he} stares into the fire and mutters something that sounds
     like  <q>\^' + gTopic.getTopicText() + '</q>.',
     
     '{The hermit/he} is temporarily overcome by a fit of coughing. ',
     
     '{The hermit/he} merely stares at you, as if hoping you\'ll talk about something else. ',
     
     'Your question is lost as {the hermit/he} fails to stifle a huge yawn. ',
     
     'He merely shakes his head, though you\'re not sure whether that means he
      doesn\'t know, doesn\'t want to answer, or simply didn\'t hear you properly. ',
      
     '<q>Right,</q> he begins, <q>Well...</q>. The rest of his answer is lost in a trio
      of sneezes. ',
      
     'You suspect he must have misunderstood your question, since you can\'t make any sense
      of his reply. ',
      
     '{The hermit/he} gives such a long and convoluted answer, full of so many classical
      tags that you don\'t understand, that by the time he gets to the end you forget
      what you asked, and once you\'ve managed to recall that again, you find you can\'t
      remember anything he said. ',   
      
     '<q>Good question,</q> {the hermit/he} approves, then pauses to marshal his reply.
      While you\'re waiting for him to gather his thoughts your mind wanders off over the
      events of the last few hours, until you suddenly realize he started speaking
      again and you missed whatever he said. ' 
      
   ]
   deferToEntry(other) { return !other.ofKind(DefaultTopic); }
;

++ cartridgeTopic : AskTellGiveShowTopic, SuggestedShowTopic, StopEventList @cartridgeCase
   [
     '<q>I found this up on top of the hill just to the south of here.</q> you
      tell him.\b
      {The hermit/he} frowns thoughtfully, <q>I thought I heard some gunfire up
       there a couple of days back.</q> he tells you, <q>I don\'t know what it was
       about -- it\'s safer not to.</q><.reveal shooting>',
       
       '<q>Two days ago?</q> you ask, holding up the cartridge case for him to see,
       <q>You say you heard shooting up on the hill two days ago?</q>\b
       <q>That\'s right,</q> {the hermit/he} confirms, <q>It was a perfect summer\'s
        day -- bright and warm and cloudless. It seemed so odd to hear shooting on
        a day like that. But then the weather changed -- almost as if God himself
        was showing his disapproval. It rained heavily all that night and well
        into the next day, flooding the river.</q>',
       
      '<q>I think I was there,</q> you say slowly, <q>I was there with -- someone.
       We were -- we were...</q> you shake your head at the memories that won\'t
       quite come, <q>We were being quite intimate, I think. Enjoying a picnic,
       and discussing -- something important, something world-changing even.</q>\b
       <q>So what happened?</q> asks {the hermit/he}.\b
       <q>That\'s what I\'m trying to remember.</q> you continue. <q>We were
        interrupted -- I\'m sure of that. Then there were shouts -- and shots --
        and -- and...</q>\b
        <q>And that\'s when you were arrested and the person with you was shot?</q>
         he suggests gently.\b
        <q>I think so -- I suppose so -- my mind just can\'t focus on it.</q> you 
        confess. ',       
      
        '<q>The bullet from this killed someone I love,</q> you surmise, turning
         the cartridge case over in your hand, <q>and yet I can\'t recall who, or
         how, or why.</q>\b
         <q>That\'s not just trauma,</q> {the hermit/he} opines, <q>They\'ve
         pumped you full of something to make you forget. They take everything
         from us, this new enlightened goverment, even our memories.</q>',
        
      '<q>Yes, you\'ve already showed me that several times,</q> he reminds you, 
       <q>and I still don\'t know what the gunfire was about.</q>'
   ]
   name = 'the brass cartridge case'
   isActive = (gPlayerChar.canSee(cartridgeCase))
;

++ AskTellTopic, SuggestedAskTopic @t_shooting
  topicResponse()
  {
    nestedAction(ShowTo, cartridgeCase, getActor );
  }
  name = 'the shooting'
  isActive = (gRevealed('shooting') && getActor.canSee(cartridgeCase))
  curiositySatisfied = (cartridgeTopic.curiositySatisfied)
;
   
++ AskTellTopic, SuggestedTellTopic @guardian
  "<q>There's a prison guard blocking the road -- I don't think I can get
   past him.</q> you say.\b
   <q>I shouldn't try,</q> he advises, <q>they must know by now that you've
    gone missing and they'll be looking for you.</q>"
   
  name = 'the guardian'
  isActive = gRevealed('guard-watch')
;

+++ AltTopic, SuggestedTellTopic
  topicResponse()
  {
    "<q>I think there might be a way I could get that document about Pandra
     published,</q> you say, <q>but there's a problem.</q>\b
     <q>What kind of problem.</q> {the hermit/he} wants to know.\b
     <q>There's a guardian in the way. I think it may be the same one that
       was on duty in my prison. If so he's sure to recognize me.</q>\b
     {The hermit/he} stares into the fire for what seems an eternity, before
      finally arriving at a decision and turning back to you, <q>If there's a
      way of undermining this New Enlightenment, then it must be done.</q>
      he declares, <q>Lead the way. I'll come with you and we'll see what can
     be done about this guardian of yours.</q>\b
     {The hermit/he} rises slowly to his feet and waits for you to lead the way.";
     getActor.setCurState(hermitFollowing);  
  }
  name = 'the guardian'
  isActive = gRevealed('guard-watch') && gRevealed('pandra-document')
;   
   
++ AskForTopic @t_help
  topicResponse()
  {
    replaceAction(TellAbout, hermit, guardian);
  }
  isActive = gRevealed('guard-watch')
;


++ AskTellTopic, StopEventList @bible
  [
    '<q>That book -- it\'s a bible isn\'t it?</q> you ask, nodding
     at the black book.\b
     <q>That\'s right,</q> {the hermit/he} agrees. ',
     
    '<q>I suppose you think the Bible is the word of God,</q> you remark,
     a little sceptically.\b
     <q>The words in the Bible are all human words,</q> he replies, <q>but
     they are the words of humans who have encountered God, and, more than
     that, they are the classic words of divine encounter for the faith
     tradition in which I stand.</q>',
     
    '<q>But surely, isn\'t the Bible all myth?</q> you ask.\b
     <q>Surely -- at least, quite largely so,</q> {the hermit/he} agrees
     equably, <q>But despite the popular prejudice of a rationalistic age,
     myth is not falsehood -- on the contrary, myth is the expression of
     non-empirical truth in pictorial form. Not that <i>all</i> myth is
     true in that sense, of course, but at its purest, myth is the highest
     form of truth -- the truth that speaks to the whole person, the truth that
     inspires the imagination and inflames the heart, not like mere brute
     fact that satisfies only the cold, dry, shrivelled intellects of men
     and women who have forgotten what it is to be fully human.</q>',
     
    '<q>So you say that the Bible is true -- even when it isn\'t?</q> you
     ask.\b
     <q>I say the Bible conveys spiritual truth -- the kind of truth that comes
     from encounter of God -- the truth of personal encounter, and that is
     quite apart from whether it also happens to contain factual, empirical
     or historical truth -- yes!</q> he affirms.', 
     
     '<q>I doubt the Bible is read much now,</q> you observe.\b
      <q>I doubt it too,</q> {the hermit/he} concurs, <q>the New Enlightenment
      mind has no idea how to read it.</q><.reveal new-enlightenment>'
    
  ]
  isActive = (gPlayerChar.canSee(bible))
;

++ AskTopic, StopEventList @t_joe
  [
    '<q>Who\'s Joe?</q> you wonder.\b
     <q>He\'s an old bloke who owns a farm that\'s mainly on the other side
     of the river, apart from the field where you found the pig,</q> {the hermit/he}
     explains. '
  ]
  isActive = gRevealed('old-joe')
;

   
++ DefaultAskForTopic
  "{The hermit/he} merely shakes his head. "
   deferToEntry(other) { return !other.ofKind(DefaultTopic); }
;

+ ConvNode 'hermit-prisoner'
  limitSuggestions = true
  npcGreetingMsg = "The hermit looks up as if he had been expecting you all along, and gestures
       towards a plain bench with a vague wave of his pipe, <q>Do sit down,</q> he says,
       <q>we should talk.</q> Without waiting for you to reply, he continues, <q>From those
       coveralls I'd say you're an escaped prisoner -- am I right?</q>"
  npcContinueList : ShuffledEventList {
    [  
      'The hermit eyes you intently, waiting for your response. <q>Escaped?</q>
       he prompts you. ',
      '<q>Did you not hear me? I asked you if you\'d just escaped from prison,</q>
       the hermit reminds you. ',
      '<q>If I\'m sheltering an escaped prisoner, I think I have a right to know,</q>
       the old hermit opines, <q>So, it that what you are: an escaped prisoner?</q>',
      '<q>Those clothes you\'re wearing mark you out as an escaped prisoner -- right?</q>
       the hermit persists. '
    ]        
   }
  canEndConversation(actor, reason)
  {
    switch(reason)
    {
      case endConvTravel:
        "You'd better humour the old hermit by staying and answering his questions. ";
        break;
      case endConvBye:
        "This isn't a good point at which to break off the conversation. ";
        break;
      case endConvBoredom:
        "{The hermit} is still waiting for your answer. ";
        break;
    }
    return nil;
  } 
;

++ YesTopic, SuggestedYesTopic
   "<q>Yes, that's right,</q> you confess, <q>Well, I was let out on completion
    of a strange task, but I have a feeling I wasn't really meant to
    get away, so I suppose it counts as escaping.</q>\b
    The old hermit nods sagely, <q>I see,</q> he remarks. <q>So what were you
    locked up for?</q><.convnode hermit-crime>"
;

++ NoTopic, SuggestedNoTopic
  "<q>Not exactly escaped,</q> you reply, <q>They let me out, after a fashion,
   though I'm not sure I was meant to get out quite the way I came.</q>\b
   <q>That sounds quite a fine distinction,</q> he chuckles, <q>So what were you
    locked up for in the first place?</q> <.convnode hermit-crime>"
;   
   
++ DefaultAnyTopic
   "<q>I think we should establish who you are before we discuss anything else.</q>
   the hermit insists.<.p><.convstay>"
;

+ ConvNode 'hermit-crime'
  limitSuggestions = true
  npcContinueList: ShuffledEventList {
   [
     '<q>Well?</q> he prompts. ',
     '<q>Your crime -- what was it?</q> {the hermit/he} demands. ',
     '<q>I asked you what you were locked up for,</q> the hermit reminds you. '
   ]
  }
;

++ SpecialTopic 'tell him you don\'t know' 
    ['tell', 'him', 'i', 'you', 'don\'t', 'dont', 'do', 'not', 'know']
  "<q>I've no idea.</q> you tell him, <q>The note I found when I woke up said that
   by being a felon I'd forfeited the right to know!</q>\b
   <q>That sounds pretty typical of New Englightenment Justice.</q> the hermit 
   sympathizes, <q>So, who are you?</q><.p><.convnode who-are-you>"
;

++ SpecialTopic, CyclicEventList 'refuse to answer' ['refuse', 'to', 'answer']
  [
  '<q>That\'s none of your business.</q> you tell him sourly.\b
   <q>No?</q> the old man replies, <q>Right now I might be the only friend you\'ve
    got -- if you can\'t persuade me you might be worth helping, who are you
    going to persuade? So, one more time: what were you locked up for?</q><.convstay>
    <.topics>',   
   '<q>I\'d rather not say.</q> you insist.\b
    <q>Suit yourself.</q> he shrugs, <q>Distrusting me is your loss, not mine.
     So at least tell me this: who are you?</q><.p><.convnode who-are-you>' 
  ]
;

++ DefaultAnyTopic
  "<q>Answer the question!</q> the hermit insists, <q>Why were you in prison?</q><.convstay>"
;
  
+ ConvNode 'who-are-you'
  limitSuggestions = true
  npcContinueList : ShuffledEventList {
   [
     '<q>Well?</q> he asks. ',
     '<q>I asked you who you are,</q> {the hermit/he} reminds you. ',
     '<q>Who are you?</q> the hermit repeats. ',
     '<q>What\'s your name?</q> the hermit wants to know. '
   ]
  }
;

++ SpecialTopic 'tell him you have no idea' 
    ['tell', 'him', 'i', 'you', 'don\'t', 'dont', 'do', 'not', 'know', 'i\'ve', 'you\'ve', 
    'have', 'no', 'idea']
   "<q>I've no idea who I am,</q> you reply, <q>I have no memory of anything --
    none to speak of, anyway!</q>\b
    <q>They've pumped you full of some drug or other,</q> he surmises,
    <q>So -- in a tyranny they feel free to do what they like with us!</q> the
     hermit pauses for a moment, blowing a couple of smoke rings while he frowns
     in thought. Then he continues, <q>Finding out who you are should probably
     be your first priority right now.</q><.reveal id-quest>"
;

++ SpecialTopic 'refuse to say' ['refuse', 'to', 'say' , 'answer']
   "<q>I'd rather not say,</q> you reply.\b
    He throws a curious frown at you for a moment, and then shrugs,
    <q>Very well,</q> he replies, <q>but you <i>can</i> trust me,
    you know. In fact, I'm probably the only person round here
    an escaped prisoner <i>can</i> trust</q>. "
;


++ DefaultAnyTopic
  "<q>I asked who you are,</q> the hermit reminds you.<.convstay> "
;

  
+ ConvNode 'put-right';
 
++ YesTopic
  "<q>I wish I could,</q> you sigh.\b
   <q>Maybe you should try!</q> he suggests. "
;

++ NoTopic
  "<q>No -- if I'm Pandra then I must approve of what's happened!</q> you reply.\b
   <q>Don't be daft!</q> he protests, <q>They're a gang of brutal dictators and
    they\'re out to kill you!</q>";
;

+ ConvNode 'regret-it';

++ YesTopic
   "<q>Yes, of course,</q> you affirm with feeling, <q>it's led to absolute
    madness!</q>\b
    <q>Perhaps there\'s something you can do to undo that madness.</q> he suggests gently,
    <q>So what will you do now?</q><.convnode choose-sides>"
;

++ NoTopic
   "<q>No, I don't regret thinking my thoughts and publishing them,</q> you shake
    your head, <q>My ideas were worth exploring, they were just put to bad use.</q>\b
    <q>What other use could they have been put to?</q> he wonders bitterly, <q>Anyway,
     what do you intend to do now?</q><.convnode choose-sides>"
;


+ ConvNode 'know-what-that-means'
  limitSuggestions = true
  whoMust = '<q>Then who must I be for them to go to all that trouble?</q> you wonder.\b
   <q>Now <i>that\'s</i> the question!</q> he concurs. '
;

++ YesTopic, SuggestedYesTopic
  "<q>Ah!</q> you declare as the light begins to dawn, <q>I must have said something
   about square circles they didn't like? Something that implied that a square circle
   is an impossibility?</q>\b
   <q>Something that <i>assumes</i> a square circle is an impossibility more like,</q>
    he replies, <q>and they're peculiarly anxious to be able to show that you
    shouldn't be understood that way!</q><.p><<location.whoMust>>"   
;

++ NoTopic, SuggestedNoTopic
  "<q>No, I've no idea!</q> you shake your head.\b
   <q>You must have said something that presupposes a square circle is an 
    impossibility,</q> he deduces, <q>something they don't want said -- something
    they're very anxious to have taken in a different sense.</q><.p><<location.whoMust>>"
;

+ ConvNode 'choose-sides'
  limitSuggestions = true
;

++ SpecialTopic, StopEventList 'say fight' 
   ['say', 'fight']
   [
     '<q>I\'d say that time has come to fight back!</q> you declare\b
      {The hermit/he} regards you steadily for a moment, then nods, <q>You\'re
      right, they\'ve been allowed to get away with it far too long -- and now
      you\'ve finally got a weapon that can <i>really</i> upset them!</q>\b
      <q>That document, you mean,</q> you surmise.\b
      <q>Quite!</q> he nods.',
      
      '<q>They\'ve taken away everything I ever had or cared about!</q> you
       declare grimly, <q>I still want to fight them.</q>\b
       <q>Then fight them!</q> he tells you. '
   ]  
;

++ SpecialTopic, StopEventList 'say flee'
  ['say', 'flee']
  [
   '<q>Frankly, I just want to get as far away from here as possible,</q> you tell him, 
   <q>change my identity, start a new life. There\'s nothing left for me here.</q>\b
   He looks vaguely disappointed in you, but nevertheless says, <q>Well, your best
   bet is to go east through the forest, then. It\'s a bit tricky to find your way --
   from the clearing outside my hut you need to take the path to the northeast. After
   a few minutes you\'ll come to a point where a much narrower path leads off to the
   right -- it\'s very easy to miss it unless you know what you\'re looking for, but if
   you do miss it you\'ll get hopelessly lost. Okay, so you take that narrow little
   track to the right, and pretty soon it\'ll broaden out and bend round to the
   north, and then you\'ll come to a junction of five paths. At that point you need
   to take the <i>second</i> path to the right -- not the first -- and it\'ll lead you
   straight out to the eastern edge of the forest. After that it\'s down to you.
   Anyway, have you got all that?</q><.reveal secret-path>\b
   <q>Yes, I think so.</q> you reply.\b
   <q>Well, best of luck to you, then.</q> he nods curtly. ',
   
   '<q>I still just want to get as far away from here as possible,</q> you tell him.\b
    <q>Very well,</q> he sighs, <q>You remember the directions through the forest?</q>\b
    <q>Yes, the path northeast out of the clearing, look out of the narrow path to
    the right, when I come to where five paths meet take the second right, then carry
    on out of the forest.</q> you recall.\b
    <q>That\'s right,</q> he confirms. '
  ]
   
;  

+ hermitFollowing : AccompanyingState
  specialDesc = "{The hermit/he} is at your side. "
  accompanyTravel(traveler, conn) 
  { 
    if(conn is in (gates, avenue.south) )
    {
      "<q>No, let's not go that way, I don't like the look of it,</q>
      {the hermit/he} restrains you. ";
      exit;
    }
    
    return traveler==gPlayerChar; 
  }
  arrivingTurn()
  {
    if(getActor.canSee(guardian))
    {
      "<q>Right,</q> says {the hermit/he}, nodding towards the guardian,
       <q>What we need is something I can get his interest with. Any ideas?</q>
       <.reveal hermit-ideas>";
      getActor.setCurState(hermitPlotting);
    } 
    if(getActor.canSee(redButton) && redButton.daemonID == nil)
      "<q>I wonder what would happen if you pressed that,</q> {the hermit/he} muses, pointing
      at the red button. ";  
    if(!getActor.canSee(redButton) && getActor.canSee(smallPanel))
      "<q>What's behind that panel?</q> {the hermit/he} wonders, nodding at the wall. ";
    if(getActor.canSee(motorBike))
      "{The hermit/he} peers at the motorbike with evident interest. <q>I wonder...</q>
       he muses, starting to fiddle with its pouch. ";
  }
  beforeAction()
  {
    if(getActor.location==bridge && gActionIs(South))
    {
      "<q>Stop!</q> {the hermit/he} warns you, grabbing your arm, <q>That
       bridge obviously isn't safe!</q>";
      exit;
    }
    inherited;
  }
  thankResponse = "<q>Thanks for coming along!</q> you say\b
    <q>It's the least I could do,</q> he assures you. "
;  

++ DefaultAnyTopic
  "<q>Let's just keep our minds on the task ahead, shall we?</q> he suggests grimly. "
  deferToEntry(other) { return !other.ofKind(DefaultTopic); }
;
  
+ hermitPlotting : InConversationState
  specialDesc = "{The hermit/he} is waiting for you to speak. "
  attentionSpan = nil
  nextState = hermitRoadWaiting
  beforeTravel(traveler, connector)
  {     
    guardCheck(traveler, connector);
    inherited(traveler, connector); 
  }
  guardCheck(traveler, connector)
  {
    if(connector == prisonRoad && getActor.canSee(guardian) && traveler == gPlayerChar)
    {
      "<q>No, you stay here,</q> {the hermit/he} stops you, <q>Leave
       that guard to me.</q>";
       exit;
    }
  }
;  

++ GiveShowTopic [paperScrap, blueCoveralls]
  topicResponse
  {
    gDobj.moveInto(getActor);
    "<q>Yes, that's just the thing!</q> he declares, taking {it dobj/him} from you,
     <q>You wait here while I see what I can do about our friend over there.</q>
     He nods towards the guardian and then heads off down the road towards him. ";
       getActor.moveIntoForTravel(guardian.location);
       "<.p>{The hermit/he} stops by the guardian and engages him in conversation.
        To begin with the guardian looks fidgety and bored, but then he starts
        to look more interested. {The hermit/he} hands him {the dobj/him},
        the conversation starts to become more agitated, and the two of them
        leave together.<.reveal guard-moved> ";
        
       nestedActorAction(guardian, TravelVia, prisonGate);
       nestedActorAction(getActor, TravelVia, prisonGate); 
       
       guardianAchievement.awardPointsOnce(); 
   }
 
;

++ GiveShowTopic [whiteEnvelope, document, greenLetter]
  "<q>No, you need that!</q> {the hermit/he} points out. "
;

++ AskTellTopic [blueCoveralls, paperScrap]
   "<q>What about <<gTopic.getBestMatch.theName>>?</q> you suggest.\b
    <q>Yes, that might gain his interest.</q> {the hermit/he} agrees. "
;

++ DefaultAskTellTopic
  "<q>What about <<gTopic.getBestMatch.theName>>?</q> you suggest.\b
   <q>I really don't suppose that would be suitable for gaining our
    friend's attention.</q> {the hermit/he} objects.  "
   deferToEntry(other) { return !other.ofKind(DefaultTopic); } 
;



++ DefaultGiveShowTopic, ShuffledEventList
 [
  '<q>No, not {that dobj/him}.</q> he shakes his head. ',
  
  '<q>No, {that dobj/he} won\'t do it.</q> he declines. ',
  
  '<q>I doubt {that dobj/he} will do the trick.</q> he tells you. ',
  
  '<q>No, something else.</q> {the hermit/he} insists. '
 ]
 deferToEntry(other) { return !other.ofKind(DefaultTopic); }
;


++ hermitRoadWaiting : ConversationReadyState
  specialDesc = "{The hermit/he} is waiting for you in the road. "
  beforeTravel(traveler, connector)
  {
    hermitPlotting.guardCheck(traveler, connector);
    inherited(traveler, connector);
  }
;

+++ HelloTopic
  "<q>I'm back.</q> you announce.\b
   <q>So I see.</q> {the hermit/he} remarks. "
;


+++ ByeTopic
  "<q>Right, I'll be off then.</q> you say.\b
   <q>Don't be long!</q> {the hermit/he} replies. "
;
  
+++ ImpByeTopic
  "<q>See you shortly.</q> says {the hermit/he}. "
;  
  
+ ConvNode 'offer-clothes';

++ YesTopic
  "<q>Yes, please,</q> you say, <q>That would be a big help.</q><.p>
   <q>Help yourself, then,</q> he says, <q>They\'re truly terrible,
   but at least you won't be spotted as an escaped prisoner at fifty
   paces!</q><.reveal oldClothes>"
;

++ NoTopic
  "<q>Thanks, but no thanks,</q> you reply.<.p>
   <q>Suit yourself,</q> he shrugs, <q>They are pretty grim. But
   let me know if you change your mind.</q>"
;

 
bible : Readable 'black leather leather-bound bound book/bible' 'black book' 
  "It's a black leather-bound Bible. "
  sightSize = small
  dobjFor(Read) { preCond = [objVisible, objHeld] }
  readDesc = "It would take you a very long time to read all the way through from
    Genesis 1 to Revelation 21, so you settle for a few choice passages from
    Job, Ecclesiastes and the Gospel of Mark. "
;  

smokingPipe: Thing 'battered well chewed well-chewed scratched stubby old pipe/mouthpiece/bowl' 
   'stubby old pipe' @hermit
  "It's a battered, stubby old thing, with a well-chewed mouthpiece and a scratched
   bowl. "
  sightSize = small
;


personaNote : Footnote
  desc = "<i>Persona non grata</i> (plural <i>personae non gratae</i>)
   is a late Latin expression meaning an unacceptable or unwelcome person. "
;

toOnNote : Footnote
  desc = "{The hermit/he} has glossed his translation a bit: <i>to on</i>
  <<!gTextOnly ? '(or &tau;&omicron; &omicron;&nu;)' : ''>>
  means simply <q>the being</q> or perhaps <q>Being</q>."

;

lacunaNote : Footnote
  desc = "In a manuscript a <i>lacuna</i> (plural <i>lacunae</i>) is a blank or missing portion.
  {The hermit/he} means <q>how you fill in the gaps</q>, i.e. the parts where
  tearing or smearing have rendered part of the text on the scrap of paper
  illegible or missing. "  
; 