>> Okay, here it is; the guts of the game. In commenting this file, I'll try to
>> explain what a block of C0MMANDs is for, and why it does what it does. The
>> actual "how" it does what it does should be obvious. If you are serious
>> about figuring out how this game works, behind the scenes, I suggest you
>> print out at least the COMMENT.THF file, which contains several lists of
>> important items.
>> Comments for a particular C0MMAND or group always precede it. Groups of
>> C0MMANDs extend until the next comment begins.


>> The following two allow the walls, floor and ceiling to appear on the
>> menu-input list. The problem with just moving the walls into a room on the
>> first move in that room is that IF the player is using the menu-input, and
>> they try to do something to a wall etc. it does not appear on the menu-input
>> list until AFTER the first move. This group uses RoomFlags and the actual
>> wall NOUNs in combination. Before the real walls are moved into a room, the
>> RoomFlags for the "fake" walls are turned on. When an input is entered that
>> references the walls, floor, or ceiling, the appropriate object is moved
>> into the room, and the RoomFlag for it turned off. On the next move, the
>> real wall is removed, and the "fake wall" is restored ie. appropriate
>> RoomFlag is ON.
>> This part deals with removing the walls after use.
>> The second part of this group, dealing with moving walls into a room when
>> referenced, is located further into the file.

COMMAND ANY
Present 295
Or
Present 296
Or
Present 298
Or
Present 299
TurnRoomFlagOn 25
TurnRoomFlagOn 26
TurnRoomFlagOn 28
TurnRoomFlagOn 29
Destroy 295
Destroy 296
Destroy 298
Destroy 299
END_COMMAND

COMMAND ANY
Present 294
Or
Present 297
TurnRoomFlagOn 24
TurnRoomFlagOn 27
Destroy 294
Destroy 297
END_COMMAND


>> This group is used in combination with the later READ CATALOGUE. RoomFlags
>> are defined for each of the items listed on the catalogue, so that the
>> player can select them if they are playing with the menu-input system. When
>> the player reads a page, the RoomFlags for the items on that page are turned
>> on. Then this group of C0MMANDs turn them off again next turn. This means
>> that the player has one move to order the items on that page before they are
>> removed. This stops the menu-input list from getting too cluttered with
>> numbers.

COMMAND ANY
RoomFlagOn 1
ToggleRoomFlag 1
ToggleRoomFlag 2
ToggleRoomFlag 3
ToggleRoomFlag 4
END_COMMAND

COMMAND ANY
RoomFlagOn 5
ToggleRoomFlag 5
ToggleRoomFlag 6
ToggleRoomFlag 7
ToggleRoomFlag 8
END_COMMAND

COMMAND ANY
RoomFlagOn 9
ToggleRoomFlag 9
ToggleRoomFlag 10
ToggleRoomFlag 11
ToggleRoomFlag 12
END_COMMAND

COMMAND ANY
RoomFlagOn 13
ToggleRoomFlag 13
ToggleRoomFlag 14
ToggleRoomFlag 15
ToggleRoomFlag 16
ToggleRoomFlag 17
END_COMMAND

COMMAND ANY
RoomFlagOn 18
ToggleRoomFlag 18
ToggleRoomFlag 19
ToggleRoomFlag 20
ToggleRoomFlag 21
END_COMMAND

COMMAND ANY
RoomFlagOn 22
ToggleRoomFlag 22
ToggleRoomFlag 23
END_COMMAND


>> This group is for three "random" events that occur at various times during
>> the game. In order they are: Humpty Dumpty, The Tiny Red Imps, The Seven
>> Dwarves. Each group has a different effect. Humpty Dumpty is just a message.
>> The Tiny Red Imps take all the objects you are carrying at the time, except
>> for the portable hole and those you are wearing. These objects are moved to
>> the H Sibbur chest in Hell. The Seven Dwarves simply drop a diamond in the
>> room, which is of no importance in the game.

COMMAND ANY
TurnFlagOff 1
Not VerbIsDirection
Not AtLocation 6
Not AtLocation 13
Not AtLocation 15
Not AtLocation 17
Not AtLocation 28
AtLocationLT 31
TurnFlagOn 1
FlagOff 10
TurnsGT 65
PrintMessage 247
TurnFlagOn 10
DoneWithTurn
END_COMMAND

COMMAND ANY
FlagOn 1
FlagOff 12
TurnsGT 128
IsCarryingTreasure 2
Not Present 292
PrintMessage 248
SendTreasuresToRoom 251 2
TurnFlagOn 12
DoneWithTurn
END_COMMAND

COMMAND ANY
FlagOn 1
FlagOff 13
TurnsGT 267
PrintMessage 249
PutInCurrentRoom 287
TurnFlagOn 13
DoneWithTurn
END_COMMAND


>> This group is for swapping those NOUNs which have been throw out the Wicked
>> Witch's window with their counterparts in the CREATURE list, as well as
>> killing the player. When the player jumps out the window, the NOUNs s/he has
>> throw are swapped for CREATUREs which have more appropriate one-line
>> descriptions. The first C0MMAND deals with the possibility that the player
>> is wearing the Second Chance Ring just before they are killed.

COMMAND ANY
AtLocation 89
IsWearing 289
FlagOff 9
PrintMessage 239
END_COMMAND

COMMAND ANY
AtLocation 89
SwapLocations 267 367
SwapLocations 268 368
SwapLocations 269 369
SwapLocations 270 370
SwapLocations 271 371
SwapLocations 272 372
SwapLocations 273 373
SwapLocations 274 374
SwapLocations 275 375
SwapLocations 278 378
SwapLocations 279 379
SwapLocations 280 380
SwapLocations 281 381
SwapLocations 282 382
SwapLocations 283 383
SwapLocations 284 384
SwapLocations 285 385
SwapLocations 286 386
SwapLocations 287 387
SwapLocations 288 388
SwapLocations 289 389
SwapLocations 291 391
GoToRoom 90
DoneWithTurn
END_COMMAND

COMMAND ANY
AtLocation 90
PrintMessage 240
EndGame
DoneWithTurn
END_COMMAND


>> The player has only a few moves when in the same room with the containment
>> cube, but the count can be reset by leaving the room. Also, the player must
>> push the button in the Treasure Room and then leave immediately. This
>> C0MMAND clears the count of the former, and enforces the latter.

COMMAND ANY
Not AtLocation 5
SetVariableTo 4 0
Not VerbIsDirection
TurnFlagOff 4
END_COMMAND


>> This C0MMAND destroys the portable hole when it has been left hanging in
>> Hell too long, ie. it melts. It swaps in another NOUN, a black puddle, and
>> also destroys the portable hole NOUN on the floor in the room above.

COMMAND ANY
CounterEquals 5 27
PrintMessage 151
SwapLocations 248 249
Destroy 266
DoneWithTurn
END_COMMAND


>> This C0MMAND increments a counter for every move in the Aquarium, and prints
>> a message about the fish when it reaches 7.

COMMAND ANY
AtLocation 18
AddToVariable 13 1
VariableEquals 13 7
PrintMessage 147
DoneWithTurn
END_COMMAND


>> The following group increments a counter for every move in the Plant Room,
>> and kills the player when it reaches the appropriate number. It also covers
>> the possibility that the player is wearing the Second Chance Ring.

COMMAND ANY
AtLocation 28
AddToVariable 14 1
VariableEquals 14 3
PrintMessage 148
END_COMMAND

COMMAND ANY
AtLocation 28
FlagOff 9
IsWearing 289
VariableGT 14 5
PrintMessage 149
GoToRoom 23
TurnFlagOn 9
DoneWithTurn
END_COMMAND

COMMAND ANY
AtLocation 28
VariableGT 14 5
PrintMessage 150
GoToRoom 101
EndGame
DoneWithTurn
END_COMMAND


>> These are for throwing water on the Witch. They allow the Wicked Witch to be
>> killed by any combination of the words "water" and "Witch". This means that
>> the Witch could be killed by typing JUMP WATER INTO WITCH, but I considered
>> that kind of thing pretty unlikely. This means that killing the Witch is
>> covered in two C0MMANDs instead of four. The first is for the first trip to
>> the Castle, and the second C0MMAND is for the second trip. The messages
>> differ slightly in each case.

COMMAND ANY
Present 286
Present 300
CounterGT 6 14
FlagOn 254
Or
NounIsNumber 286
ObjectIsNumber 300
Or
NounIsNumber 300
ObjectIsNumber 286
PrintMessage 139
SwapLocations 300 259
PutInCurrentRoom 260
Destroy 286
TurnCounterOff 6
DoneWithTurn
END_COMMAND

COMMAND ANY
Present 286
Present 300
FlagOn 254
Or
NounIsNumber 286
ObjectIsNumber 300
Or
NounIsNumber 300
ObjectIsNumber 286
PrintMessage 138
SwapLocations 300 259
PutInCurrentRoom 260
Destroy 286
TurnCounterOff 6
DoneWithTurn
END_COMMAND


>> These are for the second trip to the Castle, where the Witch kills the
>> player immediately (if they don't kill her first). The player has two moves;
>> on the second move, if the input is not suitable to kill the Witch, the
>> player dies. The only exception is if the player is wearing the Second
>> Chance ring, in which case they are returned to the Small Room, and can have
>> another attempt at killing the Witch later.

COMMAND ANY
AtLocation 88
CounterGT 6 14
FlagOff 17
PrintMessage 144
TurnFlagOn 17
DoneWithTurn
END_COMMAND

COMMAND ANY
AtLocation 88
CounterGT 6 14
Flagon 17
FlagOff 9
IsWearing 289
PrintMessage 145
TurnFlagOn 9
GoToRoom 2
DoneWithTurn
END_COMMAND

COMMAND ANY
AtLocation 88
Flagon 17
CounterGT 6 14
PrintMessage 146
EndGame
DoneWithTurn
END_COMMAND

>> If the player is standing on the stool and they try to move, a message is
>> given that they get off the stool before moving. The standing-on-stool is
>> swapped with the ordinary stool.

COMMAND ANY
VerbIsDirection
Present 292
PrintMessage 132
BlankLine
SwapLocations 291 292
END_COMMAND


>> If they player moves while carrying the lightsabre, and it is turned on,
>> a message is printed.

COMMAND ANY
VerbIsDirection
IsCarrying 275
PrintMessage 114
END_COMMAND


>> These next four C0MMANDs print messages at various intervals. When the
>> player is in the Witch's Castle, the Scarecrow, the Tinman, and the Lion are
>> all "killed",. The final message is for when the Witch gets bored, and sends
>> the player back to the Plain Room. It also swaps paintings, so that a
>> picture of a destroyed Kansas replaces the earlier one.

COMMAND ANY
CounterEquals 6 3
PrintMessage 118
DoneWithTurn
END_COMMAND

COMMAND ANY
CounterEquals 6 6
PrintMessage 119
Destroy 256
Destroy 257
DoneWithTurn
END_COMMAND

COMMAND ANY
CounterEquals 6 9
PrintMessage 120
DoneWithTurn
END_COMMAND

COMMAND ANY
CounterEquals 6 13
PrintMessage 121
SwapLocations 203 204
GoToRoom 19
DoneWithTurn
END_COMMAND


>> These two send the player from Kansas onto the Yellow Brick Road, when a
>> certain number of turns has elapsed in Kansas. They also move all the items
>> from one version of Kansas to another (first C0MMAND), and move all the
>> items from one version of the YBR to another (second C0MMAND). The first
>> C0MMAND also moves the forest painting to the Rubble Heap In Kansas.

COMMAND ANY
CounterEquals 3 9
PrintMessage 91
GoToRoom 79
SendToRoom 255 74
RelocateAll 69 75
RelocateAll 70 76
RelocateAll 71 77
RelocateAll 72 78
DoneWithTurn
END_COMMAND

COMMAND ANY
CounterEquals 4 5
PrintMessage 92
RelocateAll 79 83
RelocateAll 80 84
RelocateAll 81 85
RelocateAll 82 86
GoToRoom 83
DoneWithTurn
END_COMMAND


>> This group deals with the player putting all three coloured gems into the
>> white sphere. If they are in the Void, the Void is destroyed, along with the
>> gems, and they are freed (sent to Inside The Containment Cube). A point is
>> added to the true score for this action. If they are outside the Void and
>> wearing the Second Chance ring, they are saved from blinding. If they are
>> not wearing the ring, they are permanently blinded and the game finishes.

COMMAND ANY
IsLocated 279 276
IsLocated 281 276
IsLocated 284 276
AtLocation 31
PrintMessage 81
Destroy 279
Destroy 281
Destroy 284
AddToVariable 1 1
GoToRoom 32
DoneWithTurn
END_COMMAND

COMMAND ANY
FlagOff 9
IsWearing 289
IsLocated 279 276
IsLocated 281 276
IsLocated 284 276
PrintMessage 84
Destroy 279
Destroy 281
Destroy 284
TurnFlagOn 9
DoneWithTurn
END_COMMAND

COMMAND ANY
IsLocated 279 276
IsLocated 281 276
IsLocated 284 276
PrintMessage 82
GoToRoom 101
EndGame
DoneWithTurn
END_COMMAND


>> This sucks the player into the Void if they stay in the Mosaic Room too long
>> at one time. If they leave the room, the variable counting the number of
>> moves in the room is reset, and they can safely re-enter. The second part of
>> this C0MMAND can only be executed once, due to Flag 8 being used as a gate.
>> This means that if the player escapes the Void, they won't be trapped again.

COMMAND ANY
FlagOff 8
AtLocation 5
AddToVariable 4 1
VariableEquals 4 5
PrintMessage 83
GoToRoom 31
TurnFlagOn 8
DoneWithTurn
END_COMMAND


>> These two C0MMANDs deal with the suffocation of the player if they stay in
>> the Sealed Room too long. The first is for the case if they are wearing the
>> Second Chance ring; they are warned that their air is running out. The
>> next C0MMAND kills them when the air runs out. A variable is used as a
>> cumulative counter of the number of moves in the room.

COMMAND ANY
AtLocation 17
AddToVariable 16 1
VariableEquals 16 8
FlagOff 9
IsWearing 289
PrintMessage 85
TurnFlagOn 9
DoneWithTurn
END_COMMAND

COMMAND ANY
AtLocation 17
VariableGT 16 10
PrintMessage 80
GoToRoom 101
EndGame
DoneWithTurn
END_COMMAND


>> This adds a point to the true score once, just for getting to Heaven.

COMMAND ANY
AtLocation 63
FlagOff 7
AddToVariable 1 1
TurnFlagOn 7
END_COMMAND


>> These next two C0MMANDs kill the player if they push the LEVER up, when in
>> the laboratory. Even pushing the LEVER down again does not help. The first
>> deals with the case that the player may be wearing the Second Chance ring,
>> and saves them if they are. The second C0MMAND kills they player. Note, in
>> the second C0MMAND, that the player is sent to ROOM 101, which has a blank
>> (empty) ROOM_DESCRiption. This is in case the player enters a direction,
>> eg. NORTH, as the last input before they die. If they were to enter a
>> direction without being sent to a "blank" room, the room description would
>> be redisplayed as well as the death message.

COMMAND ANY
FlagOn 5
FlagOff 9
IsWearing 289
PrintMessage 86
TurnFlagOn 9
TurnFlagOff 5
DoneWithTurn
END_COMMAND

COMMAND ANY
FlagOn 5
PrintMessage 71
GoToRoom 101
EndGame
DoneWithTurn
END_COMMAND


>> This group is the mechanism behind the "giant" objects in the Inch Tall
>> rooms. When the player shrinks, they are moved to the Inch Tall Laboratory.
>> Then, all the objects that could possibly be seen by the player while s/he
>> is tiny are swapped for their "giant" counterparts. Then, all the things in
>> the "Ordinary" set of rooms (ie. the "giant" objects) are relocated to the
>> Inch Tall counterpart. When the player enlarges (determined by counter), the
>> process is reversed.
>> When the player is reduced, everything they are wearing and carrying (with
>> the exception of your fingers) is dropped on the floor, and then swapped.

COMMAND ANY
CounterEquals 2 11
MakeVarRoomNum 2
SubtractFromVariable 2 32
PrintMessage 73
GoToVariableRoom 2
END_COMMAND

COMMAND ANY
FlagOn 6
PrintMessage 72
TurnCounterOn 2
DropEverything
RemoveEverything
WearIt 293
Destroy 222
Destroy 223
Destroy 224
GoToRoom 47
RelocateAll 2 34
RelocateAll 3 35
RelocateAll 4 36
RelocateAll 5 37
RelocateAll 6 38
RelocateAll 7 39
RelocateAll 8 40
RelocateAll 9 41
RelocateAll 10 42
RelocateAll 11 43
RelocateAll 12 44
RelocateAll 14 46
RelocateAll 15 47
RelocateAll 16 48
RelocateAll 18 50
RelocateAll 19 51
RelocateAll 20 52
RelocateAll 21 53
RelocateAll 22 54
RelocateAll 23 55
RelocateAll 24 56
RelocateAll 25 57
RelocateAll 26 58
RelocateAll 27 59
RelocateAll 28 60
RelocateAll 29 61
RelocateAll 30 62
END_COMMAND

COMMAND ANY
FlagOn 6
Or
CounterEquals 2 11
SwapLocations 200 306
SwapLocations 201 307
SwapLocations 214 308
SwapLocations 221 309
SwapLocations 242 310
SwapLocations 261 311
SwapLocations 262 312
SwapLocations 263 313
SwapLocations 264 314
SwapLocations 265 315
SwapLocations 266 316
SwapLocations 267 317
SwapLocations 268 318
SwapLocations 269 319
SwapLocations 270 320
SwapLocations 271 321
SwapLocations 272 322
SwapLocations 273 323
SwapLocations 274 324
SwapLocations 275 325
SwapLocations 276 326
SwapLocations 279 329
SwapLocations 280 330
SwapLocations 281 331
SwapLocations 282 332
SwapLocations 283 333
SwapLocations 284 334
SwapLocations 285 335
SwapLocations 277 327
SwapLocations 278 328
SwapLocations 287 337
SwapLocations 288 338
SwapLocations 289 339
SwapLocations 290 340
SwapLocations 291 341
END_COMMAND

COMMAND ANY
FlagOn 6
TurnFlagOff 6
DoneWithTurn
END_COMMAND

COMMAND ANY
CounterEquals 2 11
RelocateAll 34 2
RelocateAll 35 3
RelocateAll 36 4
RelocateAll 37 5
RelocateAll 38 6
RelocateAll 39 7
RelocateAll 40 8
RelocateAll 41 9
RelocateAll 42 10
RelocateAll 43 11
RelocateAll 44 12
RelocateAll 46 14
RelocateAll 47 15
RelocateAll 48 16
RelocateAll 50 18
RelocateAll 51 19
RelocateAll 52 20
RelocateAll 53 21
RelocateAll 54 22
RelocateAll 55 23
RelocateAll 56 24
RelocateAll 57 25
RelocateAll 58 26
RelocateAll 59 27
RelocateAll 60 28
RelocateAll 61 29
RelocateAll 62 30
DoneWithTurn
END_COMMAND


>> This C0MMAND gives a random message to the player when they are an inch
>> tall, only if they enter inputs of more the one word, ie. when the player
>> is an inch tall, they are allowed only one word inputs.

COMMAND ANY
Not VerbIsDirection
Not NounIsNumber 0
AtLocationGT 33
AtLocationLT 63
RandomMessage 74 79
DoneWithTurn
END_COMMAND


>> This gives a message if player enters an input that references the VOID,
>> when the player is in the Void.

COMMAND ANY
AtLocation 31
NounIsNumber 344
DescribeThing 344
DoneWithTurn
END_COMMAND


>> This gives a general message about the GROUND, if it is present. This is
>> used in Oz. The GROUND is a CREATURE, which is defined as a GROUPMEMBER.
>> This means that the ground follows the player while s/he is in Oz, thus only
>> one CREATURE is necessary to have a ground in all of the rooms of Oz.

COMMAND ANY
NounPresent
NounIsNumber 345
DescribeThing 345
DoneWithTurn
END_COMMAND


>> Gives a general message that the player should be more specific about which
>> chest they would like to VERB. This allows the word CHEST to be recognized
>> without having to have three different chests for each different name.

COMMAND ANY
AtLocation 67
NounIsNumber 355
Or
ObjectIsNumber 335
PrintMessage 68
DoneWithTurn
END_COMMAND


>> This is the second half of the earlier group involved with moving walls
>> around and turning RoomFlags on and off appropriately. When a particular
>> wall is used in an input eg. EXAMINE NORTH WALL, this set moves the correct
>> wall into the room, only if the RoomFlag corresponding to it is defined as
>> On. This means that the wall will not be sent into rooms with no RoomFlag
>> defined, ie. in the case of locations with no walls; in the forest, in Oz,
>> in Hell etc. See the ROOM definitions in the THIEF.DAT file

COMMAND ANY
RoomFlagOn 24
NounIsNumber 294
Or
ObjectIsNumber 294
PutInCurrentRoom 294
ToggleRoomFlag 24
END_COMMAND

COMMAND ANY
RoomFlagOn 25
NounIsNumber 295
Or
ObjectIsNumber 295
PutInCurrentRoom 295
ToggleRoomFlag 25
END_COMMAND

COMMAND ANY
RoomFlagOn 26
NounIsNumber 296
Or
ObjectIsNumber 296
PutInCurrentRoom 296
ToggleRoomFlag 26
END_COMMAND

COMMAND ANY
RoomFlagOn 27
NounIsNumber 297
Or
ObjectIsNumber 297
PutInCurrentRoom 297
ToggleRoomFlag 27
END_COMMAND

COMMAND ANY
RoomFlagOn 28
NounIsNumber 298
Or
ObjectIsNumber 298
PutInCurrentRoom 298
ToggleRoomFlag 28
END_COMMAND

COMMAND ANY
RoomFlagOn 29
NounIsNumber 299
Or
ObjectIsNumber 299
PutInCurrentRoom 299
ToggleRoomFlag 29
END_COMMAND


>> Fairly simple. This C0MMAND prints a different version message. TheCREATURE
>> is used because I ran out of messages, and had to use the CREATURE_DESCR to
>> make everything fit.

COMMAND VERSION
DescribeThing 306
DoneWithTurn
END_COMMAND


>> This group is all the PUT C0MMANDs.

>> This one deals with the player trying to get rid of their fingers by putting
>> them someplace. It won't work.

COMMAND PUT FINGERS ON ANY
Not ObjectIsNumber 0
DescribeThing 307
DoneWithTurn
END_COMMAND


>> This one tells the player that, while they are standing on the stool, they
>> cannot reach the object that they wish to put the item on. The only
>> exception is PUT HOLE ON ROOF (NOUNs 290 and 298 respectively), as the
>> player needs to be standing on the stool to be able to stick the portable
>> hole on the roof.

COMMAND PUT ANY
Present 292
Not NounIsNumber 290
Not ObjectIsNumber 298
NounIsCarrying
ObjectPresent
PrintMessage 137
DoneWithTurn
END_COMMAND


>> This group is specifically for putting the portable hole various places.
>> This one is for if the player is not in the same room with the hole. Since
>> the portable hole stuck on the wall is NOT the NOUN 290, this also covers
>> instances when the hole is in the room, but is stuck onto the wall.
>> Therefore, the player must be carrying the unattached portable hole (or it
>> is lying on the ground) in all of the C0MMANDs following this one. By
>> testing this condition right at the start, it is possible to eliminate
>> repetitive testing in each individual C0MMAND.

COMMAND PUT HOLE
Not Present 290
PrintMessage 107
DoneWithTurn
END_COMMAND


>> This C0MMAND is for sticking the portable hole on the arched door in the
>> Small Room and in the Large Room, ie. from both sides. It isn't possible.

COMMAND PUT HOLE ON DOOR
ObjectPresent
ObjectIsNumber 200
Or
ObjectIsNumber 241
PrintMessage 93
DoneWithTurn
END_COMMAND


>> This checks that the player is trying to stick the hole onto a wall, which
>> are numbered between 294 and 299. If they are trying to attach it to any
>> other kind of object, a "that won't work" kind of message is displayed.

COMMAND PUT HOLE ON ANY
MakeVarObjectNum 2
VariableLT 2 294
Or
VariableGT 2 299
PrintMessage 106
DoneWithTurn
END_COMMAND


>> This is for the final stages of the game. If the open GOLDEN DOOR is
>> present, the hole can be stuck onto the north wall of that room. A flag is
>> set to indicate that this has happened, so that if the player removes their
>> glasses (the only thing that allows them to see the GOLDEN DOOR) and then
>> replaces them, the DOOR and the portable hole can be removed from the room,
>> and then replaced correctly

COMMAND PUT HOLE ON NORTH WALL
Present 223
PrintMessage 94
Destroy 290
SendToRoom 224 12
SetVariableTo 5 91
TurnFlagOn 3
DoneWithTurn
END_COMMAND


>> The following (very long) group works like this: at any given location, it
>> may be possible to stick the hole onto any given wall. If it is possible,
>> then a message is displayed and the unattached portable hole is destroyed
>> (sent to 0). The correct version of the attached hole is then sent to the
>> room, and the corresponding attached hole for the OTHER side of the wall is
>> sent to the appropriate room. Then the variables that hold the values of the
>> adjacent room are set with the right values.

>> For example, in the first C0MMAND below,
>>  1) the unattached hole is destroyed
>>  2) a message is displayed
>>  3) the "on north wall" hole is sent to room 3
>>  4) the "on south wall" hole is put in room 4, which is north of room 3.
>>  5) the variable 5, which holds the value of the room to the north of the
>>     hole-point, is set to 4
>>  6) the variable 6, which holds the value of the room to the south of the
>>     hole-point is set to 3

>> If it is not possible to attach the hole to the specified wall, a random
>> message is printed. If there is already a door there, a message is printed.

COMMAND PUT HOLE ON NORTH WALL
AtLocation 3
RandomMessage 95 97
Destroy 290
SendToRoom 261 3
SendToRoom 262 4
SetVariableTo 5 4
SetVariableTo 6 3
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON NORTH WALL
AtLocation 4
RandomMessage 95 97
Destroy 290
SendToRoom 261 4
SendToRoom 262 25
SetVariableTo 5 25
SetVariableTo 6 4
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON NORTH WALL
AtLocation 5
RandomMessage 95 97
Destroy 290
SendToRoom 261 5
SendToRoom 262 7
SetVariableTo 5 7
SetVariableTo 6 5
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON NORTH WALL
AtLocation 15
RandomMessage 95 97
Destroy 290
SendToRoom 261 15
SendToRoom 262 29
SetVariableTo 5 29
SetVariableTo 6 15
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON NORTH WALL
AtLocation 18
RandomMessage 95 97
Destroy 290
SendToRoom 261 18
SendToRoom 262 30
SetVariableTo 5 30
SetVariableTo 6 18
DoneWithTurn
END_COMMAND
COMMAND PUT HOLE ON NORTH WALL
AtLocation 21
RandomMessage 95 97
Destroy 290
SendToRoom 261 21
SendToRoom 262 9
SetVariableTo 5 9
SetVariableTo 6 21
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON NORTH WALL
AtLocation 23
RandomMessage 95 97
Destroy 290
SendToRoom 261 23
SendToRoom 262 11
SetVariableTo 5 11
SetVariableTo 6 23
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON NORTH WALL
AtLocation 24
RandomMessage 95 97
Destroy 290
SendToRoom 261 24
SendToRoom 262 26
SetVariableTo 5 26
SetVariableTo 6 24
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON NORTH WALL
AtLocation 30
RandomMessage 95 97
Destroy 290
SendToRoom 261 30
SendToRoom 262 28
SetVariableTo 5 28
SetVariableTo 6 30
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON NORTH WALL
Not AtLocation 7
AtLocationGT 5
AtLocationLT 10
Or
AtLocation 10
Not Present 221
Or
AtLocationGT 10
AtLocationLT 14
Or
AtLocation 17
RandomMessage 98 100
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON NORTH WALL
Not AtLocation 22
AtLocationLT 31
PrintMessage 101
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON SOUTH WALL
AtLocation 4
RandomMessage 95 97
Destroy 290
SendToRoom 261 3
SendToRoom 262 4
SetVariableTo 5 4
SetVariableTo 6 3
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON SOUTH WALL
AtLocation 7
RandomMessage 95 97
Destroy 290
SendToRoom 261 5
SendToRoom 262 7
SetVariableTo 5 7
SetVariableTo 6 5
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON SOUTH WALL
AtLocation 9
RandomMessage 95 97
Destroy 290
SendToRoom 261 21
SendToRoom 262 9
SetVariableTo 5 9
SetVariableTo 6 21
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON SOUTH WALL
AtLocation 11
RandomMessage 95 97
Destroy 290
SendToRoom 261 23
SendToRoom 262 11
SetVariableTo 5 11
SetVariableTo 6 23
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON SOUTH WALL
AtLocation 25
RandomMessage 95 97
Destroy 290
SendToRoom 261 4
SendToRoom 262 25
SetVariableTo 5 25
SetVariableTo 6 4
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON SOUTH WALL
AtLocation 26
RandomMessage 95 97
Destroy 290
SendToRoom 261 24
SendToRoom 262 26
SetVariableTo 5 26
SetVariableTo 6 24
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON SOUTH WALL
AtLocation 28
RandomMessage 95 97
Destroy 290
SendToRoom 261 30
SendToRoom 262 28
SetVariableTo 5 28
SetVariableTo 6 30
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON SOUTH WALL
AtLocation 29
RandomMessage 95 97
Destroy 290
SendToRoom 261 15
SendToRoom 262 29
SetVariableTo 5 29
SetVariableTo 6 15
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON SOUTH WALL
AtLocation 30
RandomMessage 95 97
Destroy 290
SendToRoom 261 18
SendToRoom 262 30
SetVariableTo 5 30
SetVariableTo 6 18
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON SOUTH WALL
AtLocation 3
Or
AtLocation 6
Or
AtLocation 13
Or
AtLocationGT 15
AtLocationLT 21
RandomMessage 98 100
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON SOUTH WALL
Not AtLocation 22
AtLocationLT 31
PrintMessage 101
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON EAST WALL
AtLocation 5
RandomMessage 95 97
Destroy 290
SendToRoom 263 5
SendToRoom 264 21
SetVariableTo 7 21
SetVariableTo 8 5
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON EAST WALL
AtLocation 10
RandomMessage 95 97
Destroy 290
SendToRoom 263 10
SendToRoom 264 11
SetVariableTo 7 11
SetVariableTo 8 10
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON EAST WALL
AtLocation 18
RandomMessage 95 97
Destroy 290
SendToRoom 263 18
SendToRoom 264 16
SetVariableTo 7 16
SetVariableTo 8 18
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON EAST WALL
AtLocation 23
RandomMessage 95 97
Destroy 290
SendToRoom 263 23
SendToRoom 264 14
SetVariableTo 7 14
SetVariableTo 8 23
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON EAST WALL
AtLocation 24
RandomMessage 95 97
Destroy 290
SendToRoom 263 24
SendToRoom 264 2
SetVariableTo 7 2
SetVariableTo 8 24
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON EAST WALL
AtLocation 29
RandomMessage 95 97
Destroy 290
SendToRoom 263 29
SendToRoom 264 13
SetVariableTo 7 13
SetVariableTo 8 29
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON EAST WALL
AtLocation 8
Or
AtLocationGT 11
AtLocationLT 18
RandomMessage 98 100
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON EAST WALL
Not AtLocation 22
AtLocationLT 31
PrintMessage 101
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON WEST WALL
AtLocation 4
PrintMessage 138
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON WEST WALL
AtLocation 2
RandomMessage 95 97
Destroy 290
SendToRoom 263 24
SendToRoom 264 2
SetVariableTo 7 2
SetVariableTo 8 24
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON WEST WALL
AtLocation 11
RandomMessage 95 97
Destroy 290
SendToRoom 263 10
SendToRoom 264 11
SetVariableTo 7 11
SetVariableTo 8 10
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON WEST WALL
AtLocation 13
RandomMessage 95 97
Destroy 290
SendToRoom 263 29
SendToRoom 264 13
SetVariableTo 7 13
SetVariableTo 8 29
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON WEST WALL
AtLocation 14
RandomMessage 95 97
Destroy 290
SendToRoom 263 23
SendToRoom 264 14
SetVariableTo 7 14
SetVariableTo 8 23
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON WEST WALL
AtLocation 16
RandomMessage 95 97
Destroy 290
SendToRoom 263 18
SendToRoom 264 16
SetVariableTo 7 16
SetVariableTo 8 18
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON WEST WALL
AtLocation 21
RandomMessage 95 97
Destroy 290
SendToRoom 263 5
SendToRoom 264 21
SetVariableTo 7 21
SetVariableTo 8 5
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON WEST WALL
AtLocationLT 9
Or
AtLocation 17
RandomMessage 98 100
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON WEST WALL
Not AtLocation 22
AtLocationLT 31
PrintMessage 101
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON ROOF
Present 292
AtLocationLT 5
Or
AtLocationGT 14
AtLocationLT 21
Or
AtLocation 24
Or
AtLocation 30
PrintMessage 102
Destroy 290
PutInCurrentRoom 265
SetVariableTo 9 63
MakeVarRoomNum 10
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON ROOF
Present 292
Present 298
PrintMessage 103
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON ROOF
Present 298
PrintMessage 104
DoneWithTurn
END_COMMAND

COMMAND PUT HOLE ON FLOOR
Present 299
PrintMessage 105
Destroy 290
PutInCurrentRoom 266
MakeVarRoomNum 9
SetVariableTo 10 64
TurnCounterOn 5
DoneWithTurn
END_COMMAND


>> This one is for putting the coin in the slot. For some strange reason, this
>> C0MMAND wouldn't recognise the word SLOT in the C0MMAND, probably because I
>> have another slot defined elsewhere. As a result, I have just checked the
>> number of the object to see whether it is the correct slot or not.
>> If everything is as it should be, the player is let through the turnstile,
>> and moved to room 4, the Railway Station. The coin is lost forever.

COMMAND PUT COIN IN ANY
ObjectIsNumber 238
Present 280
AtLocation 24
PrintMessage 110
Destroy 280
GoToRoom 4
DoneWithTurn
END_COMMAND


>> In this C0MMAND, when the Golden Door is visible AND closed, and the player
>> has the amulet, the open GOLDEN DOOR is swapped for the closed GOLDEN DOOR,
>> and the amulet is taken away. A flag is turned on to indicate that the
>> DOOR is open, so that if the player removes the glasses, and then puts them
>> on again, the open GOLDEN DOOR can be removed from the room and then
>> restored correctly. the player scores a point on their true score for this
>> action.

COMMAND PUT AMULET IN INDENTATION
Present 222
Present 268
PrintMessage 111
SwapLocations 222 223
Destroy 268
TurnFlagOn 2
AddToVariable 1 1
DoneWithTurn
END_COMMAND


>> These two C0MMANDs deal with the two cases of cranking the arched door; when
>> it closed, and when it is open. In each case the result is that the
>> door is opposite to what it was before. The crank always winds up on the
>> floor, regardless of whether the player was carrying it or not.
>> Note that this C0MMAND swaps doors and arches on both sides of the wall.

COMMAND PUT CRANK IN SLOT
Present 267
Present 200
PrintMessage 108
SwapLocations 200 201
SwapLocations 241 242
DropIt 267
DoneWithTurn
END_COMMAND

COMMAND PUT CRANK IN SLOT
Present 267
Present 201
PrintMessage 109
SwapLocations 200 201
SwapLocations 241 242
DropIt 267
DoneWithTurn
END_COMMAND


>> The next five C0MMANDs deal with clicking.
>> 1) clicking heels without wearing the slippers. This just produces a
>>    "that won't work" message.
>> 2) clicking heels, after having killed the witch, in the Witch's Castle. A
>>    variable is used to count the number of clicks. When it reaches three, an
>>    expanded message is displayed, and the player is moved to the repaired
>>    version of Kansas (which is not exactly identical to the original).
>>    Paintings are destroyed; both the original "Kansas" picture, and the
>>    "Post-Tornado Kansas" picture. Then the painting of the "Night Sky" is
>>    moved to the Gallery, effectively cutting off access to Kansas and Oz
>>    after that point. Also, the picture of the forest is moved into the
>>    repaired Kansas, so that the player can get back to the "Ordinary" rooms.
>> 3) This one covers clicking the heels when the Witch is still alive in the
>>    Castle, or the player is not in the Castle at all. Either way, the basic
>>    "Nothing happens" message is all they get for their efforts. It isn't
>>    possible to leave the Witch's Castle via the Ruby Slippers unless the
>>    Witch is dead.
>> 4) Clicking your fingers gets a "Click" message. This C0MMAND also covers
>>    the cases when the player clicks their heels and they have not yet
>>    clicked them three times, ie. the C0MMAND in (2) above will be invalid
>>    for the first two times that the player clicks their heels. This C0MMAND
>>    prints the "Click message for those two times.
>> 5) This is a general catch-all for clicking unclickable objects.

COMMAND CLICK HEELS
Not IsWearing 270
PrintMessage 58
DoneWithTurn
END_COMMAND

COMMAND CLICK HEELS
AtLocation 88
Present 259
AddToVariable 12 1
VariableEquals 12 3
PrintMessage 140
Destroy 203
Destroy 204
SendToRoom 205 3
SendToRoom 255 77
GoToRoom 75
AddToVariable 1 1
DoneWithTurn
END_COMMAND

COMMAND CLICK HEELS
Present 300
Or
Not AtLocation 88
PrintMessage 141
DoneWithTurn
END_COMMAND

COMMAND CLICK ANY
NounIsNumber 270
Or
NounIsNumber 293
PrintMessage 142
DoneWithTurn
END_COMMAND

COMMAND CLICK ANY
PrintMessage 143
DoneWithTurn
END_COMMAND


>> This next group of C0MMANDs is for quitting. By defining the conditions for
>> quitting myself, it was possible to insert a ranking before the moves/score
>> display. Also, if QUIT remains a standard function, it can sometimes
>> override an ANY C0MMAND. Since timing was critical in some of the sections
>> of this game, I opted not have any interference. Testing with PromptForNo in
>> the first C0MMAND, means that all C0MMANDs after it has been answered YES.

COMMAND QUIT
PromptForNo
PrintMessage 37
DoneWithTurn
END_COMMAND

COMMAND QUIT
PrintMessage 36
VariableEquals 1 0
PrintMessage 30
EndGame
DoneWithTurn
END_COMMAND

COMMAND QUIT
VariableEquals 1 1
Or
VariableEquals 1 2
PrintMessage 31
EndGame
DoneWithTurn
END_COMMAND

COMMAND QUIT
VariableEquals 1 3
Or
VariableEquals 1 4
PrintMessage 32
EndGame
DoneWithTurn
END_COMMAND

COMMAND QUIT
VariableEquals 1 5
Or
VariableEquals 1 6
PrintMessage 33
EndGame
DoneWithTurn
END_COMMAND

COMMAND QUIT
VariableEquals 1 7
Or
VariableEquals 1 8
PrintMessage 34
EndGame
DoneWithTurn
END_COMMAND

COMMAND QUIT
VariableEquals 1 9
PrintMessage 35
EndGame
DoneWithTurn
END_COMMAND


>> These give a ranking message based on variable 1 (the true score).

COMMAND RANK
VariableEquals 1 0
PrintMessage 30
DoneWithTurn
END_COMMAND

COMMAND RANK
VariableEquals 1 1
Or
VariableEquals 1 2
PrintMessage 31
DoneWithTurn
END_COMMAND

COMMAND RANK
VariableEquals 1 3
Or
VariableEquals 1 4
PrintMessage 32
DoneWithTurn
END_COMMAND

COMMAND RANK
VariableEquals 1 5
Or
VariableEquals 1 6
PrintMessage 33
DoneWithTurn
END_COMMAND

COMMAND RANK
VariableEquals 1 7
Or
VariableEquals 1 8
PrintMessage 34
DoneWithTurn
END_COMMAND

COMMAND RANK
VariableEquals 1 9
PrintMessage 35
DoneWithTurn
END_COMMAND


>> This was "taken over" from the standard AGT functions simply so that it
>> wouldn't interfere with ANY C0MMANDs. See QUIT (above).

COMMAND SCORE
ShowScore
DoneWithTurn
END_COMMAND


>> This performs the same as MOVE CLOTHES and a couple of other variants; it
>> just reveals the pot of cream to the player. It tests first that it has not
>> already been revealed, with the IsNowhere 283.

COMMAND LOOK UNDER CLOTHES
Present 260
IsNowhere 283
PrintMessage 62
PutInCurrentRoom 283
DoneWithTurn
END_COMMAND


>> Taken over to avoid interference; see QUIT (above).

COMMAND LOOK
NounIsNumber 0
LookAtRoom
DoneWithTurn
END_COMMAND


>> This redirects sentences such as LOOK THROUGH HOLE, LOOK UNDER BED etc,
>> which had previously caused a redisplay of the room description.

COMMAND LOOK ANY
RedirectTo EXAMINE $NOUN$
END_COMMAND


>> This C0MMAND prints a message about swimming in the ocean only.

COMMAND SWIM
AtLocation 7
PrintMessage 243
DoneWithTurn
END_COMMAND


>> This C0MMAND sends the player to In The Waterfall, first removing everything
>> the player is wearing and carrying (with the exception of your finger).
>> Since the player could be wearing the glasses at this point, this C0MMAND
>> also destroys the GOLDEN DOOR (both open and closed) and the portable hole
>> which might be stuck on the wall there. If the player is not wearing the
>> glasses, this will have no effect. If the player IS wearing them, then these
>> items should be removed from the North Hall. When the player gets out of
> the Waterfall, and puts the glasses on again, flags 2 and 3 are used to
>> determine the state of the door and hole, and replace them in the room as
>> necessary.

COMMAND SWIM
AtLocation 13
DropEverything
RemoveEverything
WearIt 293
Destroy 222
Destroy 223
Destroy 224
PrintMessage 244
GoToRoom 33
DoneWithTurn
END_COMMAND


>> This merely gives a general message, so that the ever-popular "You can't do
>> that" default message is not used yet again.

COMMAND DESTROY
Not NounIsNumber 0
PrintMessage 245
DoneWithTurn
END_COMMAND


>> These next three C0MMANDs deal with the player opening a chest in A Clearing
>> In Hell that is the wrong one, ie. S Lived and N O'Mead. The first gives the
>> player a second chance if they are wearing the opal ring. The others kill
>> the player if they open the chest. The messages are different for each
>> chest, hence the separate C0MMANDs.

COMMAND OPEN
AtLocation 67
FlagOff 9
IsWearing 289
NounIsNumber 252
Or
NounIsNumber 253
PrintMessage 236
TurnFlagOn 9
DoneWithTurn
END_COMMAND

COMMAND OPEN
AtLocation 67
NounIsNumber 253
PrintMessage 234
EndGame
DoneWithTurn
END_COMMAND

COMMAND OPEN
AtLocation 67
NounIsNumber 252
PrintMessage 235
EndGame
DoneWithTurn
END_COMMAND


>> These two have the same effect as the earlier PUT CRANK IN SLOT.

COMMAND OPEN DOOR WITH CRANK
Present 267
Present 200
PrintMessage 108
SwapLocations 200 201
SwapLocations 241 242
DropIt 267
DoneWithTurn
END_COMMAND

COMMAND CLOSE DOOR WITH CRANK
Present 267
Present 201
PrintMessage 109
SwapLocations 200 201
SwapLocations 241 242
DropIt 267
DoneWithTurn
END_COMMAND


>> This pair is for displaying a message when the player selects brief or
>> verbose. Previously, there was no message to indicate what had happened.

COMMAND BRIEF
PrintMessage 65
FlagOff 15
PrintMessage 67
TurnFlagOn 15
END_COMMAND
COMMAND VERBOSE
PrintMessage 66
END_COMMAND


>> When the player orders something, the catalogue must be present.

COMMAND ORDER
Not Present 288
PrintMessage 223
DoneWithTurn
END_COMMAND


>> This C0MMAND checks whether the ordered item is one of those that it is
>> possible to order, ie. whether the item is listed in the catalogue.

COMMAND ORDER
MakeVarNounNum 2
VariableLT 2 267
Or
VariableGT 2 274
VariableLT 2 351
Or
VariableGT 2 354
PrintMessage 224
DoneWithTurn
END_COMMAND


>> At this point, all following C0MMANDs have as implicit conditions that the
>> catalogue is present, and that the item ordered is legal. This C0MMAND asks
>> for the account number; if it is not correct, and is not 0 (which cancels),
>> the catalogue is taken away from the player.

COMMAND ORDER
PrintMessage 225
GetNumberInput
Not NumberEquals 55748761
Not NumberEquals 0
PrintMessage 226
Destroy 288
DoneWithTurn
END_COMMAND


>> If the entered number is 0, the order is cancelled.

COMMAND ORDER
NumberEquals 0
PrintMessage 227
DoneWithTurn
END_COMMAND


>> This group of three is for those items in the catalogue which are legal to
>> order, but which the player will not be able to receive for some reason,
>> eg. can't afford them, not available, etc.

COMMAND ORDER
NounIsNumber 351
PrintMessage 228
DoneWithTurn
END_COMMAND

COMMAND ORDER
NounIsNumber 352
PrintMessage 229
DoneWithTurn
END_COMMAND

COMMAND ORDER
NounIsNumber 353
Or
NounIsNumber 354
RandomMessage 230 231
DoneWithTurn
END_COMMAND


>> Now we're on to the group of items which can be ordered through the
>> catalogue, and which the player can receive. This C0MMAND removes the
>> hanging amulet from the Treasure Room, so that there is no doubling up if
>> the player orders the amulet through the catalogue.

COMMAND ORDER 9984
Destroy 214
END_COMMAND


>> This is the C0MMAND that actually gives the player the ordered item. Since
>> the numbers listed in the catalogue are defined as synonyms for the
>> corresponding NOUNs, it is only necessary to send the NOUN to the room.
>> The catalogue is taken away from the player. A point is added to the true
>> score for this action.

COMMAND ORDER
PrintMessage 232
PutNounInCurrentRoom
Destroy 288
AddToVariable 1 1
DoneWithTurn
END_COMMAND


>> First check if the catalogue is present...

COMMAND READ CATALOGUE
Not Present 288
QuitAllCmds
END_COMMAND


>> ...then ask for the number of the page to read.
>> Each of these C0MMANDs turn on the RoomFlags corresponding to the items
>> listed on the page. This allows the player to order the items if they are
>> using the menu-input system.

COMMAND READ CATALOGUE
PrintMessage 215
GetNumberInput
NumberEquals 1
PrintMessage 216
TurnRoomFlagOn 1
TurnRoomFlagOn 2
TurnRoomFlagOn 3
TurnRoomFlagOn 4
DoneWithTurn
END_COMMAND

COMMAND READ CATALOGUE
NumberEquals 2
PrintMessage 217
TurnRoomFlagOn 5
TurnRoomFlagOn 6
TurnRoomFlagOn 7
TurnRoomFlagOn 8
DoneWithTurn
END_COMMAND

COMMAND READ CATALOGUE
NumberEquals 3
PrintMessage 218
TurnRoomFlagOn 9
TurnRoomFlagOn 10
TurnRoomFlagOn 11
TurnRoomFlagOn 12
DoneWithTurn
END_COMMAND

COMMAND READ CATALOGUE
NumberEquals 4
PrintMessage 219
TurnRoomFlagOn 13
TurnRoomFlagOn 14
TurnRoomFlagOn 15
TurnRoomFlagOn 16
TurnRoomFlagOn 17
DoneWithTurn
END_COMMAND

COMMAND READ CATALOGUE
NumberEquals 5
PrintMessage 220
TurnRoomFlagOn 18
TurnRoomFlagOn 19
TurnRoomFlagOn 20
TurnRoomFlagOn 21
DoneWithTurn
END_COMMAND

COMMAND READ CATALOGUE
NumberEquals 6
PrintMessage 221
TurnRoomFlagOn 22
TurnRoomFlagOn 23
DoneWithTurn
END_COMMAND


>> This C0MMAND is for if the player enters a page number that does not exist.

COMMAND READ CATALOGUE
PrintMessage 222
DoneWithTurn
END_COMMAND


>> This one tells the player that they already have a pail full of water, since
>> NOUN 286 is the PAIL OF WATER.

COMMAND FILL PAIL WITH ANY
Present 286
ObjectIsNumber 215
Or
ObjectIsNumber 225
Or
ObjectIsNumber 233
Or
ObjectIsNumber 286
PrintMessage 204
DoneWithTurn
END_COMMAND


>> If the player tries to fill the pail in the ocean, it is taken away. (The
>> pail, I mean, not the ocean.)

COMMAND FILL PAIL WITH WATER
Present 215
Present 285
PrintMessage 205
Destroy 285
DoneWithTurn
END_COMMAND


>> This is the "success" C0MMAND for filling the pail with water. The PAIL OF
>> WATER is placed inside the pail itself. This makes it easy to remove the
>> water later on, in a variety of circumstances including throwing it,
>> without having to swap things around. The defaults deal with such things.

COMMAND FILL PAIL WITH ANY
ObjectIsNumber 225
Present 225
Present 285
PrintMessage 206
SendToRoom 286 285
DoneWithTurn
END_COMMAND


>> This gives a message if the player tries to fill the pail from the sealed
>> aquarium. It isn't possible.

COMMAND FILL PAIL WITH WATER
Present 233
Present 285
PrintMessage 207
DoneWithTurn
END_COMMAND


>> The pail can't be filled with anything but water, and this C0MMAND enforces
>> that, checking first that the OBJECT is present.

COMMAND FILL PAIL WITH ANY
Present 285
ObjectPresent
PrintMessage 208
DoneWithTurn
END_COMMAND


>> Nothing else but the pail can be filled. Both the NOUN and the OBJECT must
>> be present, as the default will take care of other cases.

COMMAND FILL ANY WITH ANY
NounPresent
ObjectPresent
PrintMessage 213
DoneWithTurn
END_COMMAND


>> The message from this one tells the player to specify what to put into the
>> OBJECT they have chosen to fill.

COMMAND FILL ANY
NounPresent
ObjectIsNumber 0
PrintMessage 209
DoneWithTurn
END_COMMAND


>> The next group is for emptying things. The first is for the pail that is
>> full of water; the water is removed. The second is for a pail that has no
>> water in it to begin with. The C0MMAND EMPTY ANY covers the player trying to
>> empty any other objects, which is not possible.

COMMAND EMPTY PAIL
Present 286
ObjectIsNumber 0
PrintMessage 210
Destroy 286
DoneWithTurn
END_COMMAND

COMMAND EMPTY PAIL
Present 285
ObjectIsNumber 0
PrintMessage 211
DoneWithTurn
END_COMMAND

COMMAND EMPTY ANY
NounPresent
ObjectIsNumber 0
PrintMessage 212
DoneWithTurn
END_COMMAND


>> This saves C0MMANDs in doubling up, by redirecting all KILL WITH SWORDs to
>> CUT WITH SWORD, which is effectively the same.

COMMAND KILL ANY WITH LIGHTSABRE
RedirectTo CUT $NOUN$ WITH LIGHTSABRE
END_COMMAND


>> Message that the thing to be killed is not present. The Not NounIsNumber 0
>> is to check that the input is KILL SOMETHING, and not just KILL by itself.
>> There is a different response for KILL by itself.

COMMAND KILL
Not NounIsNumber 0
Not NounPresent
PrintMessage 203
DoneWithTurn
END_COMMAND


>> Simple message display; nothing happens when you attack the GUARDSMAN
>> without the lightsabre.

COMMAND KILL GUARDSMAN
PrintMessage 199
DoneWithTurn
END_COMMAND


>> The next two C0MMANDs cover trying to kill the plant, which is usually
>> fatal. The first gives the player a second chance if they are wearing the
>> Second Chance ring, and sends them to the Statue Room. The second C0MMAND
>> simply kills them.

COMMAND KILL PLANT
IsWearing 289
FlagOff 9
PrintMessage 189
GoToRoom 23
TurnFlagOn 9
DoneWithTurn
END_COMMAND

COMMAND KILL PLANT
PrintMessage 200
EndGame
DoneWithTurn
END_COMMAND


>> Tyring to attack the Witch without a valid weapon is futile.

COMMAND KILL WITCH
PrintMessage 201
DoneWithTurn
END_COMMAND

>> This is the message for an input of KILL by itself.

COMMAND KILL
NounIsNumber 0
PrintMessage 202
DoneWithTurn
END_COMMAND


>> Cutting things is impossible when the lightsabre is off (NOUN 274).

COMMAND CUT ANY WITH LIGHTSABRE
IsCarrying 274
PrintMessage 185
DoneWithTurn
END_COMMAND


>> Cutting things is also impossible if the player does not have the lightsabre
>> in his/her possession.

COMMAND CUT ANY WITH LIGHTSABRE
Not IsCarrying 275
PrintMessage 186
DoneWithTurn
END_COMMAND


>> The previous two C0MMANDs have tested that the player is armed with an (on)
>> lightsabre. The next one checks that the player is in the Sealed Room (since
>> this is the only place the string (232) can possibly be). It then destroys
>> the string and gives the player the mobile white sphere in place of the
>> immobile one. A point is added to the true score for this action.

COMMAND CUT STRING WITH LIGHTSABRE
Present 232
PrintMessage 187
Destroy 232
SwapLocations 231 276
AddToVariable 1 1
DoneWithTurn
END_COMMAND


>> Cut/killing the Guardsman is simply a message event. Nothing else happens.

COMMAND CUT GUARDSMAN WITH LIGHTSABRE
Present 239
PrintMessage 188
DoneWithTurn
END_COMMAND


>> Again there are two conditions for killing the plant. In the first, the
>> player is saved by the Second Chance ring and sent to the Statue Room. The
>> variable that counts the number of moves in the Plant Room is set to its
>> maximum; this means that the player will be killed immediately if s/he
>> returns. In the second, the player is killed.

COMMAND CUT PLANT WITH LIGHTSABRE
Present 243
IsWearing 289
FlagOff 9
PrintMessage 189
GoToRoom 23
SetVariableTo 14 6
TurnFlagOn 9
DoneWithTurn
END_COMMAND

COMMAND CUT PLANT WITH LIGHTSABRE
Present 243
PrintMessage 190
EndGame
DoneWithTurn
END_COMMAND


>> Killing the Witch with the lightsabre is a futile effort. The Witch simply
>> turns the lightsabre off (SwapLocations 274 275).

COMMAND CUT WITCH WITH LIGHTSABRE
Present 300
PrintMessage 191
SwapLocations 274 275
DoneWithTurn
END_COMMAND


>> These next three cover trying to cut up other things. The first is for those
>> things which are parts of the scenery and cannot be destroyed by cutting.
>> The second is for those that can be destroyed; they are.
>> The third covers trying to cut anything without specifying an implement to
>> use for the job.

COMMAND CUT ANY WITH LIGHTSABRE
NounPresent
NounWEIGHTGT 100
Or
Not NounIsMovable
RandomMessage 192 194
DoneWithTurn
END_COMMAND

COMMAND CUT ANY WITH LIGHTSABRE
NounPresent
RandomMessage 195 197
DestroyNoun
DoneWithTurn
END_COMMAND

COMMAND CUT
Not NounIsNumber 0
NounPresent
PrintMessage 198
DoneWithTurn
END_COMMAND


>> The following (long) group is for rubbing things with the vanishing cream.
>> The first C0MMAND tests that the player has the pot of cream. The next one
>> is for the case when there is no cream left in the pot. The third is for
>> when the player rubs the cream on an object when it is immovable and
>> therefore cannot be made to vanish. After that, the C0MMANDs are for making
>> things vanish in each individual room, by sending them to a nearby room and
>> displaying the appropriate message. The counter of the amount of cream left
>> is incremented by one.

COMMAND RUB ANY WITH CREAM
Not IsCarrying 283
PrintMessage 183
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
VariableEquals 15 9
NounPresent
PrintMessage 182
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
Not NounIsMovable
Or
NounWeightGT 100
PrintMessage 181
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 2
PrintMessage 180
SendNounToRoom 24
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 3
PrintMessage 177
SendNounToRoom 4
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 4
PrintMessage 177
SendNounToRoom 25
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 5
PrintMessage 178
SendNounToRoom 21
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 7
PrintMessage 179
SendNounToRoom 5
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 8
PrintMessage 179
SendNounToRoom 10
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 9
PrintMessage 179
SendNounToRoom 21
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 10
PrintMessage 178
SendNounToRoom 11
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 11
PrintMessage 179
SendNounToRoom 23
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 12
PrintMessage 179
SendNounToRoom 14
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 13
PrintMessage 180
SendNounToRoom 29
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 14
PrintMessage 180
SendNounToRoom 23
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 15
PrintMessage 177
SendNounToRoom 29
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 16
PrintMessage 180
SendNounToRoom 18
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 17
PrintMessage 177
SendNounToRoom 19
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 18
PrintMessage 177
SendNounToRoom 30
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 19
PrintMessage 179
SendNounToRoom 17
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 20
PrintMessage 177
SendNounToRoom 24
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 21
PrintMessage 180
SendNounToRoom 5
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 22
PrintMessage 179
SendNounToRoom 27
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 23
PrintMessage 177
SendNounToRoom 11
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 24
PrintMessage 178
SendNounToRoom 2
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 25
PrintMessage 179
SendNounToRoom 4
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 26
PrintMessage 179
SendNounToRoom 24
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 27
PrintMessage 178
SendNounToRoom 28
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 28
PrintMessage 179
SendNounToRoom 30
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 29
PrintMessage 179
SendNounToRoom 15
AddToVariable 15 1
DoneWithTurn
END_COMMAND

COMMAND RUB ANY WITH CREAM
NounPresent
AtLocation 30
PrintMessage 177
SendNounToRoom 28
AddToVariable 15 1
DoneWithTurn
END_COMMAND


>> This message is for errors in syntax; since it is not possible to send the
>> OBJECT of a given sentence to a room, I was forced to limit the sentence to
>> one with the item to be moved in the NOUN spot, eg. RUBSTOOLWITHCREAM,
>> where STOOL is the noun, instead of RUBCREAMONSTOOL, where STOOL is the
>> object.

COMMAND RUB CREAM ON ANY
Present 283
ObjectPresent
PrintMessage 176
DoneWithTurn
END_COMMAND


>> This is a general message for rubbing things, which does not involve the
>> cream being used.

COMMAND RUB ANY
NounPresent
PrintMessage 184
DoneWithTurn
END_COMMAND


>> For use in the Void, to give a special message there.

COMMAND LIST EXITS
AtLocation 31
PrintMessage 174
DoneWithTurn
END_COMMAND


>> If the player notices something about the North wall of the Hall in the room
>> description, they may try to examine it. This C0MMAND covers that case,
>> testing that the GOLDEN DOOR is not in the room, since the message given
>> here does not fit with the GOLDEN DOOR being visible.

COMMAND EXAMINE NORTH WALL
AtLocation 12
Not Present 222
Not Present 223
PrintMessage 161
DoneWithTurn
END_COMMAND


>> These two are for giving the description of the pot of vanishing cream,
>> based on the amount of cream left in the pot (variable 15).

COMMAND EXAMINE SMALL POT
Present 283
VariableLT 15 3
PrintMessage 162
DoneWithTurn
END_COMMAND

COMMAND EXAMINE SMALL POT
Present 273
VariableLT 15 8
PrintMessage 163
DoneWithTurn
END_COMMAND


>> For turning the lightsabre on, covering both cases, ie. the sword is off =>
>> turns it on; the sword is already on => simple message.
>> The third C0MMAND is for when the player does not have the lightsabre at
>> all. The message is deliberately non-informative, in case the player is just
>> trying the (on) input to see what it does.

COMMAND ON
Present 274
PrintMessage 156
SwapLocations 274 275
DoneWithTurn
END_COMMAND

COMMAND ON
Present 275
PrintMessage 157
DoneWithTurn
END_COMMAND

COMMAND ON
PrintMessage 160
DoneWithTurn
END_COMMAND


>> These three are the same as the above (on) C0MMANDs, except that they deal
>> with turning the lightsabre off.

COMMAND OFF
Present 275
PrintMessage 158
SwapLocations 274 275
DoneWithTurn
END_COMMAND

COMMAND OFF
Present 274
PrintMessage 159
DoneWithTurn
END_COMMAND

COMMAND OFF
PrintMessage 160
DoneWithTurn
END_COMMAND


>> This redirects as it says. The listed numbers are all the creatures that it
>> is appropriate to try to kill by throwing things at.

COMMAND KILL ANY WITH ANY
NounIsNumber 239
Or
NounIsNumber 243
Or
NounIsNumber 300
Or
NounIsNumber 305
RedirectTo THROW $OBJECT$ AT $NOUN$
END_MESSAGE


>> The player must remove anything they wish to throw. This is to stop them
>> throwing the eyeglasses, which are important, since they affect the position
>> of a number of other objects. This also stops the player from getting rid of
>> their fingers by throwing them.

COMMAND THROW ANY
NounIsWearing
PrintMessage 48
DoneWithTurn
END_COMMAND


>> This is an error message; the player can't throw anything they aren't
>> carrying.

COMMAND THROW ANY
Not NounIsNumber 0
Not NounIsCarrying
PrintMessage 172
DoneWithTurn
END_COMMAND


>> If the player tries to throw anything while they are in the void, the item
>> is taken from them, and sent to In The Containment Cube, where they can
>> later reclaim it, if they escape the void. Since DROP and THROW are synonyms
>> in the Void, this C0MMAND also covers the input DROP SOMETHING.

COMMAND THROW ANY
Not NounIsNumber 0
AtLocation 31
PrintMessage 154
SendNounToRoom 32
DoneWithTurn
END_COMMAND


>> General response for throwing things.

COMMAND THROW ANY
Not NounIsNumber 0
ObjectIsNumber 0
PrintMessage 173
DropNoun
DoneWithTurn
END_COMMAND


>> If the player throws anything out the window when at the Witch's Castle, the
>> item is sent to 6th Floor And Falling. Later, if the player jumps out the
>> window, the items are all swapped for corresponding CREATUREs which have
>> descriptions appropriate to having been thrown 12 storeys.

COMMAND THROW ANY THROUGH WINDOW
Not NounIsNumber 0
AtLocation 88
PrintMessage 171
SendNounToRoom 90
DoneWithTurn
END_COMMAND


>> The same thing happens as above, when the player throws anything at the
>> Witch. She deflects it out the window.

COMMAND THROW ANY AT WITCH
Not NounIsNumber 0
Present 300
PrintMessage 155
SendNounToRoom 90
DoneWithTurn
END_COMMAND


>> This is just a general message C0MMAND. It results in nothing more than the
>> item finishing up on the ground.

COMMAND THROW ANY AT GUARDSMAN
Not NounIsNumber 0
Present 239
PrintMessage 153
DropNoun
DoneWithTurn
END_COMMAND


>> The reason behind the use of this is very complicated. If you really have to
>> know, send me a postcard, and I'll try to explain.

COMMAND MAGIC_WORD
Present 201
Or
Present 307
MakeVarRoomNum 2
AddToVariable 2 25
GoToVariableRoom 2
DoneWithTurn
END_COMMAND

COMMAND MAGIC_WORD
Present 242
GoToRoom 2
DoneWithTurn
END_COMMAND


>> This allows the player to exit the Treasure Room, if they have pushed the
>> button, indicated by Flag 4 being on.

COMMAND EAST
AtLocation 6
FlagOn 4
PrintMessage 123
QuitAllCmds
END_COMMAND


>> This C0MMAND on the other hand, gives the player a second chance if they try
>> to walk out without having pushed the button, as long as they are wearing
>> the Second Chance ring. The player is sent to the Small Room.

COMMAND EAST
AtLocation 6
FlagOff 9
IsWearing 289
PrintMessage 124
TurnFlagOn 9
GoToRoom 2
DoneWithTurn
END_COMMAND


>> This C0MMAND, finally, simply kills the player if they try to walk
>> out, without the ring, and without pushing the button.

COMMAND EAST
AtLocation 6
PrintMessage 125
EndGame
DoneWithTurn
END_COMMAND


>> The next two C0MMANDs are for the case where the player tries to walk onto
>> the railroad tracks. If they are wearing the Second Chance ring, they are
>> spared from death, and are sent out into the turnstile room. If they are not
>> wearing the ring, they are simply killed, and the game stops.

COMMAND WEST
AtLocation 4
FlagOff 9
IsWearing 289
PrintMessage 126
TurnFlagOn 9
GoToRoom 24
DoneWithTurn
END_COMMAND

COMMAND WEST
AtLocation 4
PrintMessage 127
GoToRoom 101
EndGame
DoneWithTurn
END_COMMAND


>> This one sends the player to the Kitchen if they try to walk west, past the
>> Guardsman, when they are not an Inch Tall.

COMMAND WEST
AtLocation 25
PrintMessage 128
GoToRoom 26
DoneWithTurn
END_COMMAND


>> A simple message-display C0MMAND.

COMMAND STEP THROUGH MIRROR
AtLocation 5
PrintMessage 164
DoneWithTurn
END_COMMAND


>> The player is sent to 12th Floor And Falling, when they step through the
>> window in the Witch's Castle. From there, in another C0MMAND, they are moved
>> to 6th Floor And Falling, and then are killed.

COMMAND STEP THROUGH WINDOW
AtLocation 88
PrintMessage 165
GoToRoom 89
DoneWithTurn
END_COMMAND


>> If the player tries to stand on the stool, first it is checked whether the
>> stool is on the floor. If it is, then the "standing on stool" is swapped
>> into the room, which displays one line in the room description.

COMMAND STEP ONTO STOOL
IsCarrying 291
PrintMessage 136
DoneWithTurn
END_COMMAND

COMMAND STEP ONTO STOOL
InRoom 291
PrintMessage 135
SwapLocations 291 292
DoneWithTurn
END_COMMAND

>> These copy the effect of the previous two C0MMANDs, with different wording.
>> For only two C0MMANDs, there is no point using a redirection.

COMMAND STAND ON STOOL
IsCarrying 291
PrintMessage 136
DoneWithTurn
END_COMMAND

COMMAND STAND ON STOOL
InRoom 291
PrintMessage 135
SwapLocations 291 292
DoneWithTurn
END_COMMAND


>> The next two are the general stand message. The first is used if the item
>> specified is present; the second is used if the input is only STAND,
>> ie. meaning STAND UP.

COMMAND STAND ON ANY
NounPresent
PrintMessage 237
DoneWithTurn
END_COMMAND

COMMAND STAND
NounIsNumber 0
PrintMessage 238
DoneWithTurn
END_COMMAND

COMMAND GET UP
RedirectTo STAND
END_COMMAND


>> Simple message-display.

COMMAND SIT
PrintMessage 69
DoneWithTurn
END_COMMAND

>> An obvious redirection. The flag is used to determine whether the player has
>> used the abbreviation HOLE instead of CLIMB THROUGH HOLE. If the player has
>> not used the abbreviation, a message is displayed reminding them about it.
>> If they use the HOLE short-cut, the flag is turned on, and this message is
>> never displayed

COMMAND HOLE
TurnFlagOn 18
RedirectTo STEP THROUGH HOLE
END_COMMAND


>> This checks whether it is appropriate to redirect the UP input, by checking
>> whether the portable hole for the up direction is present or not. If it is,
>> UP is redirected to STEP THROUGH HOLE.

COMMAND UP
Present 248
Or
Present 265
Present 292
RedirectTo STEP THROUGH HOLE
END_COMMAND


>> This one checks if the player means STAND ON THE STOOL, by testing if the
>> stool is present and not being carried, and takes action appropriately.

COMMAND UP
InRoom 291
PrintMessage 135
SwapLocations 291 292
DoneWithTurn
END_COMMAND


>> A simple message-display. Note that this C0MMAND comes after the redirection
>> for going through the hole, and climbing onto the stool. This is so that
>> this C0MMAND doesn't interfere with other valid uses of UP.

COMMAND UP
AtLocation 20
PrintMessage 129
DoneWithTurn
END_COMMAND


>> Since UP has been redefined in the THIEF.DAT, it no longer registers as a
>> valid direction. This makes it necessary to use the following C0MMAND to
>> cover the up direction when in the Void.

COMMAND UP
AtLocation 31
LookAtRoom
DoneWithTurn
END_COMMAND


>> This C0MMAND covers the rooms where there is a roof, displaying a message.
>> The C0MMAND after that covers the case where there is no roof, or it is high
>> enough not to matter.

COMMAND UP
AtLocationLT 31
Or
AtLocation 32
Or
AtLocationGT 69
AtLocationLT 73
Or
AtLocationGT 75
AtLocationLT 79
Or
AtLocation 88
PrintMessage 130
DoneWithTurn
END_COMMAND

COMMAND UP
Not AtLocation 63
PrintMessage 131
DoneWithTurn
END_COMMAND


>> These reverse the previous C0MMANDs, taking the player down from the stool.
>> The "standing on stool" is swapped out of the room in preference to the
>> ordinary stool.

COMMAND STEP OFF STOOL
Present 292
SwapLocations 291 292
PrintMessage 132
DoneWithTurn
END_COMMAND

COMMAND STEP DOWN
Present 292
SwapLocations 291 292
PrintMessage 132
DoneWithTurn
END_COMMAND

COMMAND GET DOWN
Present 292
SwapLocations 291 292
PrintMessage 132
DoneWithTurn
END_COMMAND

COMMAND DOWN
Present 292
SwapLocations 291 292
PrintMessage 132
DoneWithTurn
END_COMMAND


>> This redirects the input DOWN to STEP THROUGH HOLE, if it is appropriate,
>> ie. if the hole leading down is present in the room.

COMMAND DOWN
Not Present 292
Present 247
Or
Present 266
RedirectTo STEP THROUGH HOLE
END_COMMAND


>> This is here for the same reason as the previous UP C0MMAND. DOWN is no
>> longer recognized by AGT as a standard direction, so I needed to include the
>> DOWN response for the Void.

COMMAND DOWN
AtLocation 31
LookAtRoom
DoneWithTurn
END_COMMAND


>> This gives a specialised DOWN message, when the player is in Hell.

COMMAND DOWN
AtLocationGT 63
AtLocationLT 69
PrintMessage 133
DoneWithTurn
END_MESSAGE


>> The default message for DOWN.

COMMAND DOWN
PrintMessage 134
DoneWithTurn
END_COMMAND


>> Again, as for the above UP and DOWN C0MMANDs, I needed to include a response
>> for the four directions no longer defined as actual directions. This gives
>> an appropriate message for the Void. The following C0MMAND gives the default
>> SOUTHEAST, SOUTHWEST, NORTHEAST, and NORTHWEST inputs, since these are all
>> defined as synonyms.

COMMAND SOUTHEAST
AtLocation 31
LookAtRoom
DoneWithTurn
END_COMMAND

COMMAND SOUTHEAST
PrintMessage 122
DoneWithTurn
END_COMMAND


>> Synonymous with EXIT, these are used in Oz, to follow the Yellow Brick Road.

COMMAND FOLLOW
AtLocation 80
PrintMessage 115
END_COMMAND

COMMAND FOLLOW
AtLocation 81
PrintMessage 116
END_COMMAND


>> This destroys the Scarecrow, since he is defined as a GROUPMEMBER, and he
>> should no longer follow the player. The SendToRoom token is used to send the
>> ground (another groupmember) to the starting room of the next set of Oz
>> rooms, where it will be needed later. The counter is turned on to measure
>> the number of moves in the room, for the first visit, and is left turned on
>> to indicate later that the first visit has occurred.

COMMAND FOLLOW
AtLocation 82
PrintMessage 117
Destroy 302
SendToRoom 345 83
TurnCounterOn 6
END_COMMAND


>> Again, the ground is sent back to where it may be later needed.

COMMAND FOLLOW
AtLocation 87
PrintMessage 246
SendToRoom 345 83
END_COMMAND


>> Simple redirections.

COMMAND ENTER ANY
RedirectTo STEP THROUGH $NOUN$
END_COMMAND

COMMAND JUMP THROUGH ANY
Not NounIsNumber
RedirectTo STEP THROUGH $NOUN$
END_COMMAND


>> Prevents the player from taking the stool while standing on it.

COMMAND TAKE STOOL
Present 292
PrintMessage 21
DoneWithTurn
END_COMMAND


>> This stops the player from taking anything that is in the room while they
>> are standing on the stool, except for the portable hole on the roof, which
>> it must be possible to take.

COMMAND TAKE ANY
Not NounIsNumber 265
NounInRoom
Present 292
PrintMessage 38
DoneWithTurn
END_COMMAND


>> The following TAKE ALL C0MMANDs allow the player to take everything out of
>> one of the three valid items. Thus if there is 15 things in the chest, say,
>> the player can get them all in one move.

COMMAND TAKE ALL FROM H SIBBUR
Present 251
IsOpen 251
PrintMessage 18
RelocateAll 251 1
DoneWithTurn
END_COMMAND

COMMAND TAKE ALL FROM SPHERE
Present 276
PrintMessage 17
RelocateAll 276 1
DoneWithTurn
END_COMMAND

COMMAND TAKE ALL FROM SHELVES
Present 230
PrintMessage 17
RelocateAll 230 1
DoneWithTurn
END_COMMAND


>> Other items cannot be cleared in this manner, however.

COMMAND TAKE ALL FROM ANY
ObjectPresent
PrintMessage 214
DoneWithTurn
END_COMMAND


>> All of these TAKE ALL C0MMANDs simply print a message. This is in addition
>> allowing the default AGT to take any other objects that are in the room,
>> ie. items that can be taken are taken, and a message is printed by these
>> C0MMANDS about other items that can't be taken.
COMMAND TAKE ALL
Present 224
Or
Present 247
Or
Present 248
PrintMessage 14
END_COMMAND

COMMAND TAKE ALL
Present 261
Or
Present 262
Or
Present 263
Or
Present 264
Or
Present 265
Or
Present 266
PrintMessage 14
END_COMMAND

COMMAND TAKE ALL
Present 214
SwapLocations 214 268
AddToVariable 1 1
END_COMMAND

COMMAND TAKE ALL
AtLocation 3
PrintMessage 22
END_COMMAND

COMMAND TAKE ALL
AtLocation 4
PrintMessage 23
END_COMMAND

COMMAND TAKE ALL
AtLocation 7 
PrintMessage 24
END_COMMAND

COMMAND TAKE ALL
Present 222
Or
Present 223
PrintMessage 25
END_COMMAND

COMMAND TAKE ALL
Present 231
PrintMessage 26
END_COMMAND

COMMAND TAKE ALL
AtLocation 22
PrintMessage 27
END_COMMAND

COMMAND TAKE ALL
AtLocation 25
PrintMessage 28
END_COMMAND


>> This stops the player taking anything when they are standing on the stool.

COMMAND TAKE ALL
Present 292
PrintMessage 29
DoneWithTurn
END_COMMAND


>> If the player tries to take the water, by itself, then they lose it. It
>> dribbles away.

COMMAND TAKE ANY
Present 286
NounIsNumber 286
PrintMessage 233
Destroy 286
DoneWithTurn
END_COMMAND


>> This removes the hole form the wall, regardless of which wall it is attached
>> to. Since a condition of climbing through the hole is that it is stuck to
>> a wall, there is no need to reset the appropriate variables. Also, since
>> only one hole can exist at any one time, there is no harm in destroying all
>> of the holes, just to make sure that the correct one is destroyed. Flag 3 is
>> turned off, to cover the case when the hole is the one that is attached to
>> the north wall, inside the GOLDEN DOOR.

COMMAND TAKE HOLE
Present 224
Or
Present 261
Or
Present 262
Or
Present 263
Or
Present 264
RandomMessage 39 42
Destroy 224
Destroy 261
Destroy 262
Destroy 263
Destroy 264
TurnFlagOff 3
GetIt 290
DoneWithTurn
END_COMMAND


>> This allows the player to take the hole on the roof, only when the player is
>> standing on the stool. The second C0MMAND covers the case where the player
>> tries to take the hole, and they are not standing on the stool.

COMMAND TAKE HOLE
Present 265
Present 292
PrintMessage 43
Destroy 265
GetIt 290
DoneWithTurn
END_COMMAND

COMMAND TAKE HOLE
Present 265
PrintMessage 44
DoneWithTurn
END_COMMAND


>> When the player takes the hole that is on the floor, the counter of moves
>> in Hell is turned off. This counter is used to determine when the portable
>> hole will melt, if it is left hanging for too long in Hell.

COMMAND TAKE HOLE
Present 266
PrintMessage 45
Destroy 266
GetIt 290
TurnCounterOff 5
DoneWithTurn
END_COMMAND 


>> The player cannot remove the portable hole when it is attached to a cloud
>> in Heaven.

COMMAND TAKE HOLE
Present 247
PrintMessage 46
DoneWithTurn
END_COMMAND

>> If the player tries to take the hole while it is hanging in mid-air in Hell, >> the hole is destroyed, and the counter of the number of moves in Hell is
>> turned off.

COMMAND TAKE HOLE
Present 248
PrintMessage 47
SwapLocations 248 249
TurnCounterOff 5
DoneWithTurn
END_COMMAND


>> Simply sends the player to Waterfall Room, from In The Waterfall. A CREATURE
>> called OUT is defined to allow AGT to recognise the sentence GET OUT.

COMMAND GET OUT
AtLocation 33
PrintMessage 16
GoToRoom 13
DoneWithTurn
END_COMMAND


>> It isn't possible to take the sphere, even when the player is standing on
>> the stool in the Sealed Room.

COMMAND TAKE SPHERE
Present 231
Present 292
PrintMessage 20
DoneWithTurn
END_COMMAND


>> In fact, it isn't possible to take the sphere. It must be cut down first.

COMMAND TAKE SPHERE
Present 231
PrintMessage 19
DoneWithTurn
END_COMMAND


>> This C0MMAND swaps the hanging amulet for the ordinary, carryable amulet.
>> The player gets a point added to the true score for this action.

COMMAND TAKE AMULET
Present 214
PrintMessage 13
Destroy 214
GetIt 268
AddToVariable 1 1
DoneWithTurn
END_COMMAND

>> A simple message-display

COMMAND TAKE FISH
Present 234
PrintMessage 15
DoneWithTurn
END_COMMAND


>> Another simple message-display.

COMMAND TAKE FINGERS
PrintMessage 175
DoneWithTurn
END_COMMAND


>> This one allows the default AGT process for taking an item that is not
>> present to be executed, thus saving a test in every following C0MMAND.

COMMAND TAKE ANY
Not NounPresent
QuitAllCmds
END_COMMAND


>> The default "take" C0MMANd.

COMMAND TAKE ANY
Not NounIsCarrying
NounWeightLT 101
NounIsMovable
PrintMessage 13
GetNoun
DoneWithTurn
END_COMMAND


>> In the following C0MMANDs, the weight of the noun is used to put the noun
>> into a group, to display an individual message for each weight-group. This
>> way, there is some variety in the "take failure" messages.

COMMAND TAKE ANY
NounWeightEquals 101
PrintMessage 152
DoneWithTurn
END_COMMAND

COMMAND TAKE ANY
NounWeightEquals 102
PrintMessage 1
DoneWithTurn
END_COMMAND

COMMAND TAKE ANY
NounWeightEquals 103
PrintMessage 2
DoneWithTurn
END_COMMAND

COMMAND TAKE ANY
NounWeightEquals 104
PrintMessage 3
DoneWithTurn
END_COMMAND

COMMAND TAKE ANY
NounWeightEquals 105
PrintMessage 4
DoneWithTurn
END_COMMAND
COMMAND TAKE ANY
NounWeightEquals 106
PrintMessage 5
DoneWithTurn
END_COMMAND

COMMAND TAKE ANY
NounWeightEquals 107
PrintMessage 6
DoneWithTurn
END_COMMAND

COMMAND TAKE ANY
NounWeightEquals 108
PrintMessage 7
DoneWithTurn
END_COMMAND

COMMAND TAKE ANY
NounWeightEquals 109
PrintMessage 8
DoneWithTurn
END_COMMAND

COMMAND TAKE ANY
NounWeightEquals 110
PrintMessage 9
DoneWithTurn
END_COMMAND

COMMAND TAKE ANY
NounWeightEquals 111
PrintMessage 10
DoneWithTurn
END_COMMAND

COMMAND TAKE ANY
NounWeightEquals 112
PrintMessage 11
DoneWithTurn
END_COMMAND

COMMAND TAKE ANY
NounWeightEquals 113
PrintMessage 12
DoneWithTurn
END_COMMAND


>> Whatever the player is wearing must be removed before it can be dropped.

COMMAND DROP ANY
NounIsWearing
PrintMessage 48
DoneWithTurn
END_COMMAND


>> This redirects DROP WATER to EMPTY PAIL. The indirect method was used
>> because there are a number of NOUNs that are synonymous with water.

COMMAND DROP ANY
IsCarrying 286
NounIsNumber 286
RedirectTo EMPTY PAIL
END_COMMAND


>> Default "drop" response.

COMMAND DROP ANY
NounIsCarrying
PrintMessage 49
DropNoun
DoneWithTurn
END_COMMAND


>> Simple message-display.

COMMAND WEAR ALL
PrintMessage 50
DoneWithTurn
END_COMMAND


>> When the player wears the glasses, they can then see the GOLDEN DOOR. Which
>> GOLDEN DOOR depends on whether they have previously opened the door, and the
>> portable hole may also be made to appear if the player has applied it to the
>> wall. The first C0MMAND covers the case: door closed. The second one will
>> cover: door open. The third C0MMAND is for the case: portable hole applied.
>> The fourth C0MMAND is a catcher, since the first three C0MMANDs are
>> open-ended.

COMMAND WEAR GLASSES
Present 277
Not IsWearing 277
PrintMessage 51
FlagOff 2
SendToRoom 222 12
AtLocation 12
PrintMessage 52
END_COMMAND

COMMAND WEAR GLASSES
Present 277
FlagOn 2
SendToRoom 223 12
AtLocation 12
PrintMessage 54
END_COMMAND

COMMAND WEAR GLASSES
Present 277
Not IsWearing 277
FlagOn 3
SendToRoom 224 12
AtLocation 12
PrintMessage 55
END_COMMAND

COMMAND WEAR GLASSES
Present 277
Not IsWearing 277
WearIt 277
DoneWithTurn
END_COMMAND


>> Basic message-display.

COMMAND REMOVE ALL
IsWearingSomething
PrintMessage 50
DoneWithTurn
END_COMMAND


>> This C0MMAND acts as the opposite to the previous group of "wear glasses".
>> The flags for each condition are set (golden door open/closed = flag 2, hole
>> applied = flag 3) so it safe to destroy each of these when removing the
>> glasses. If those items did not actually exist, destroying them has no
>> adverse effects.

COMMAND REMOVE GLASSES
IsWearing 277
Destroy 222
Destroy 223
Destroy 224
PrintMessage 53
GetIt 277
DoneWithTurn
END_COMMAND


>> This makes taking off your fingers impossible.

COMMAND REMOVE FINGERS
PrintMessage 57
DoneWithTurn
END_COMMAND


>> Removing an object does not drop it in the room; it moves it from "wearing"
>> to "carrying".

COMMAND REMOVE ANY
NounIsWearing
PrintMessage 56
GetNoun
DoneWithTurn
END_COMMAND


>> The player cannot remove something they are not wearing.

COMMAND REMOVE ANY
Not NounIsWearing
PrintMessage 58
DoneWithTurn
END_COMMAND


>> Nothing can be pushed while on the stool.

COMMAND PUSH ANY
NounInRoom
Not NounIsNumber 265
Present 292
PrintMessage 38
DoneWithTurn
END_COMMAND


>> All of the following C0MMANDs implement the mystery object function. When
>> the player is in the "Ordinary" rooms, and they push the switch on the
>> object, they are sent to the corresponding room. The corresponding room is:
>> the player is flipped around the horizontal mid-line of the map. If they
>> were in the top right corner, they would be sent to the lower right corner.
>> If they were in the lower left corner, they would be sent to the top left
>> corner, and vice versa. If they were in the top middle, they would be
>> sent to the bottom middle. If they were in the middle middle they would
>> remain there. Play around with the object, if you don't understand. This
>> flipping is only from top to bottom and bottom to top, it is not from side
>> to side. The object has only five charges, measured with variable 3. All
>> items the player is carrying (with the exception of the object itself, and
>> your fingers) are dropped, before the player is moved, including what the
>> player is wearing. This happens even when the player is sent to the same
>> room they started in. An effect of the object is to leave everything behind
>> when being transported, no matter what the distance.
>> The object doesn't work outside the "Ordinary" rooms.


COMMAND PUSH SWITCH
Not Present 269
QuitAllCmds
END_COMMAND

COMMAND PUSH SWITCH
AddToVariable 3 1
VariableGT 3 5
PrintMessage 59
DoneWithTurn
END_COMMAND

COMMAND PUSH SWITCH
AtLocationGT 30
PrintMessage 60
DoneWithTurn
END_COMMAND

COMMAND PUSH SWITCH
Present 269
DropEverything
RemoveEverything
GetIt 269
WearIt 293
Destroy 222
Destroy 223
Destroy 224
MakeVarRoomNum 2
Present 292
SwapLocations 291 292
END_COMMAND

COMMAND PUSH SWITCH
AtLocation 6
Or
AtLocation 13
Or
AtLocationGT 24
AtLocationLT 30
PrintMessage 242
DoneWithTurn
END_COMMAND

COMMAND PUSH SWITCH
AtLocation 4
Or
AtLocation 14
AddToVariable 2 1
END_COMMAND

COMMAND PUSH SWITCH
AtLocation 3
Or
AtLocation 12
AddToVariable 2 3
END_COMMAND

COMMAND PUSH SWITCH
AtLocation 8
Or
AtLocation 10
AddToVariable 2 9
END_COMMAND

COMMAND PUSH SWITCH
AtLocation 11
Or
AtLocation 23
AddToVariable 2 7
END_COMMAND

COMMAND PUSH SWITCH
AtLocation 9
AddToVariable 2 11
END_COMMAND
COMMAND PUSH SWITCH
AtLocation 21
AddToVariable 2 3
END_COMMAND

COMMAND PUSH SWITCH
AtLocation 2
AddToVariable 2 20
END_COMMAND

COMMAND PUSH SWITCH
AtLocation 5
Or
AtLocation 11
SubtractFromVariable 2 1
END_COMMAND

COMMAND PUSH SWITCH
AtLocation 7
Or
AtLocation 16
SubtractFromVariable 2 4
END_COMMAND

COMMAND PUSH SWITCH
AtLocation 18
Or
AtLocation 30
SubtractFromVariable 2 7
END_COMMAND

COMMAND PUSH SWITCH
AtLocation 17
Or
AtLocation 19
SubtractFromVariable 2 9
END_COMMAND

COMMAND PUSH SWITCH
AtLocation 24
SubtractFromVariable 2 3
END_COMMAND

COMMAND PUSH SWITCH
AtLocation 20
SubtractFromVariable 2 11
END_COMMAND

COMMAND PUSH SWITCH
AtLocation 22
SubtractFromVariable 2 20
END_COMMAND

COMMAND PUSH SWITCH
PrintMessage 241
GoToVariableRoom 2
DoneWithTurn
END_COMMAND


>> When the player pushes the seat, and they have not previously pushed it, the
>> OPENING is sent to the room, and the passageway is opened. Then the player
>> is sent to the corresponding Inch Tall room, and a passage way is opened
>> there too. The player scores a point on the true score for this action.

COMMAND PUSH SEAT
AtLocation 10
Not Present 221
PrintMessage 61
PutInCurrentRoom 221
ChangePassageWay 1 8
GoToRoom 42
ChangePassageWay 1 40
GoToRoom 10
AddToVariable 1 1
DoneWithTurn
END_COMMAND


>> As mentioned elsewhere, this simply reveals the pot of cream to the player,
>> by sending it to the Witch's Castle.

COMMAND PUSH CLOTHES
Present 260
IsNowhere 283
PrintMessage 62
PutInCurrentRoom 283
DoneWithTurn
END_COMMAND


>> This one sets the flag that allows the player to walk out of the Treasure
>> Room without being hassled by the Silver Guardsman.

COMMAND PUSH BUTTON
AtLocation 6
TurnFlagOn 4
END_COMMAND


>> When the player pushes the lever either way, a flag is set to indicate the
>> direction. Then, on the next move, an ANY C0MMAND acts on the flag that has
>> just been set, either killing the player, or shrinking them, depending. The
>> sentences "push lever up" and "push lever down" are allowed by defining
>> CREATUREs with those names.

COMMAND PUSH LEVER UP
AtLocation 15
PrintMessage 63
TurnFlagOn 5 
DoneWithTurn
END_COMMAND

COMMAND PUSH LEVER DOWN
AtLocation 15
PrintMessage 64
TurnFlagOn 6
DoneWithTurn
END_COMMAND

COMMAND PULL LEVER UP
AtLocation 15
PrintMessage 63
TurnFlagOn 5 
DoneWithTurn
END_COMMAND

COMMAND PULL LEVER DOWN
AtLocation 15
PrintMessage 64
TurnFlagOn 6
DoneWithTurn
END_COMMAND


>> Nothing can be pushed while the player is on the stool, except for the hole
>> that may or may not be on the ceiling. Similarly for turning, pulling,
>> playing and knocking.

COMMAND PULL ANY
NounInRoom
Not NounIsNumber 265
Present 292
PrintMessage 38
DoneWithTurn
END_COMMAND

COMMAND TURN ANY
NounInRoom
Not NounIsNumber 265
Present 292
PrintMessage 38
DoneWithTurn
END_COMMAND

COMMAND PLAY ANY
NounInRoom
Not NounIsNumber 265
Present 292
PrintMessage 38
DoneWithTurn
END_COMMAND

COMMAND KNOCK ANY
NounInRoom
Not NounIsNumber 265
Present 292
PrintMessage 38
DoneWithTurn
END_COMMAND


>> Simple message display.

COMMAND KNOCK ANY
Not NounIsNumber 0
PrintMessage 70
DoneWithTurn
END_COMMAND


>> This next C0MMAND allows the player to move through the hole while they are
>> on the stool. If the hole is not the hole on the roof, the player is
>> automatically "climbed down" from the stool before going through the hole.

COMMAND STEP THROUGH HOLE
Present 292
Not Present 265
PrintMessage 132
BlankLine
SwapLocations 291 292
END_COMMAND


>> This C0MMAND prevents the player from carrying the stool through the hole,
>> since the stool is larger than the hole.

COMMAND STEP THROUGH HOLE
IsCarrying 291
Present 224
Or
Present 261
Or
Present 262
Or
Present 263
Or
Present 264
Or
Present 265
Or
Present 266
PrintMessage 112
DoneWithTurn
END_COMMAND

>> This gives the player a 50% chance of being cut to bits if they climb
>> through the hole while they are carrying the (on) lightsabre. They are
>> killed if their number comes up.

COMMAND STEP THROUGH HOLE
IsCarrying 275
Present 261
Or
Present 262
Or
Present 263
Or
Present 264
Or
Present 265
Or
Present 266
PrintMessage 114
Chance 50
PrintMessage 113
EndGame
DoneWithTurn
END_COMMAND


>> The following is one C0MMAND each for the " flat" directions, ie. not up and
>> down. This C0MMAND is for sending the player to the appropriate room,
>> depending on what hole is present in the room at the time. For the UP case
>> there is more than one C0MMAND.

COMMAND STEP THROUGH HOLE
Present 224
Or
Present 261
Or
Present 262
Or
Present 263
Or
Present 264
Or
Present 265
Or
Present 266
DescribeThing 308
FlagOff 18
PrintMessage 250
TurnFlagOn 18
END_COMMAND

COMMAND STEP THROUGH HOLE
Present 224
Or
Present 261
GoToVariableRoom 5
DoneWithTurn
END_COMMAND

COMMAND STEP THROUGH HOLE
Present 262
GoToVariableRoom 6
DoneWithTurn
END_COMMAND

COMMAND STEP THROUGH HOLE
Present 263
GoToVariableRoom 7
DoneWithTurn
END_COMMAND

COMMAND STEP THROUGH HOLE
Present 264
GoToVariableRoom 8
DoneWithTurn
END_COMMAND


>> If the stool is not present, then the player cannot reach the hole.

COMMAND STEP THROUGH HOLE
Present 265
Not Present 292
PrintMessage 44
DoneWithTurn
END_COMMAND


>> Having tested for the absence of the stool, it is safe to let the player go
>> into the room above with this C0MMAND.

COMMAND STEP THROUGH HOLE
Present 248
Or
Present 265
GoToVariableRoom 9
DoneWithTurn
END_COMMAND


>> This one is for going down.

COMMAND STEP THROUGH HOLE
Present 247
Or
Present 266
GoToVariableRoom 10
DoneWithTurn
END_COMMAND


>> Stepping through the painting, in general, sends the player to Kansas, and
>> turns on a counter, so that the player will be whisked away by the tornado,
>> eventually. This first one prevents the player from entering any painting
>> while carrying the portable hole. This prevents complication that may arise
>> from having the hole outside the "Ordinary" rooms.

COMMAND STEP INTO PAINTING
AtLocation 3
IsCarrying 290
PrintMessage 87
DoneWithTurn
END_COMMAND


>> This one sends the player to the first Kansas, activates the counter, and
>> gives the player a point on their true score.

COMMAND STEP INTO PAINTING
Present 203
PrintMessage 88
TurnCounterOn 3
GoToRoom 69
AddToVariable 1 1
DoneWithTurn
END_COMMAND


>> This one is for stepping into the forest painting. It turns off the tornado
>> counters, and sends the player to the forest.

COMMAND STEP INTO PAINTING
Present 255
PrintMessage 88
TurnCounterOff 3
TurnCounterOff 4
GoToRoom 22
DoneWithTurn
END_COMMAND


>> This C0MMAND moves the player to the second Kansas and turns on the second
>> (shorter) tornado counter

COMMAND STEP INTO PAINTING
Present 204
PrintMessage 88
TurnCounterOn 4
GoToRoom 73
DoneWithTurn
END_COMMAND


>> The next two C0MMANDs are for when the player steps through the Night Sky
>> Painting. The first one saves them from death if they are wearing the Second
>> Chance ring. The second kills them.

COMMAND STEP INTO PAINTING
Present 205
IsWearing 289
FlagOff 9
PrintMessage 90
TurnFlagOn 9
DoneWithTurn
END_COMMAND

COMMAND STEP INTO PAINTING
Present 205
PrintMessage 89
EndGame
DoneWithTurn
END_COMMAND


>> Simple message display.

COMMAND JUMP
NounIsNumber 0
RandomMessage 168 170
DoneWithTurn
END_COMMAND


>> Simple message display.

COMMAND GIVE
PrintMessage 166
DoneWithTurn
END_COMMAND


>> Simple message display.

COMMAND CLIMB TREES
PrintMessage 167
DoneWithTurn
END_COMMAND
