#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>


froggerLittleCar : FroggerRoomSet, Car, TravelPushable 'little car' 'little car'
	@froggerRoadsideD
	"This is a wonderful little car. On the front is a heavy cylinder similar to what you would
	see on a steam roller. "

	specialDesc {
		if(!gPlayerChar.isIn(self)) {
			"A little car is parked here. ";
		} else {
			"The inside of the car looks nice. The interior covering the seats, steering wheel,
			and glove compartment is all leather.
			Thankfully this car has an extremely large rear view mirror
			and outside mirrors which are those special extra large European mirrors that make
			driving so much safer. ";
		}
	}

	// This ensures that it can't be seen from a distance.
    sightSize = small
	
	dobjFor(GetOutOf) {
		action() {
			if(driveMode==-1 || driveMode == 0) {
				inherited();
			} else {
				"In classic Hollywood tradition you open the door and do a tuck and roll onto
				the pavement. Sadly, movies do not seem to portray the full difficulty of
				this task. You roll out of the car and tumble end over end until you
				strike your head rather severely on the pavement. ";
				endGame('You have died comically. ');
			}
		}
	}
	
	dobjFor(Enter) {
		action() {
			"You are sitting in the car now. To move the car around, just use normal compass directions. ";
			
			if(driveMode>=1) {
				"In classic Hollywood tradition you run towards the car and attempt to get
				into it as it speeds by. Sadly, counter to Hollywood tradition, the doors
				are locked so you are not able to get inside. ";
			} else {
				inherited();
			}
			
			specialDesc;
		}
	}

	
	dobjFor(Push) {
		action() {
			"You need to specify a direction to push the car.";
		}
	}
		
	dobjFor(PushTravel) {
		verify() {
			if(gActor!=nil && gActor.isIn(froggerLittleCar)) {
				illogical('{You/he} can\'t push the car while you\'re still inside it.');
			} else if(driveMode!=-1) {
				"The car won't move. ";
				exit;
			}
		}
		action() {
			if(driveMode==-1) {
				if(directionsToCrash.indexOf(gAction.getDirection())!=nil) {
					"You push the car into traffic and WHAM! You seem to have caused a major pileup!
					There is no longer any moving traffic. ";
					
					froggerWreckage.wreckCars();
				} else {
					inherited;
				}
			}
		}
	}
	
	directionsToCrash = [northwestDirection,northDirection,northeastDirection]

	driveMode = -1
;
+ Component 'fuel gauge' 'fuel gauge'
	"The fuel gauge indicates that the car is nearly full."
;
+ Component '(large) (heavy) steam cylinder/roller' 'steam roller'
	"It's a large heavy cylinder that would be appropriate for flattening blacktop. On closer
	inspection you can see lots of red stains on it which could possibly be blood. "
;
+ rearviewMirror : Component 'rear view mirror*mirrors' 'rear view mirror'
	"You look into the mirror and see no traffic behind you. "
;	
+ Component 'outside mirror*mirrors' 'outside mirror' "<<rearviewMirror.desc>>"
	dobjFor(Examine) {
		verify() {
			logicalRank(80, 'examine mirror');
		}
	}
;
/*
+ fuzzyDice : Thing '(red) fuzzy dice' 'fuzzy dice'
	"This is a cool looking pair of red fuzzy dice. "
	initDesc = "There is a pair of red fuzzy dice hanging from the rear view mirror. "
	isPlural = true
;
*/
+ Component 'steering wheel' 'steering wheel' "There is nothing special about the steering wheel. ";
+ Component 'interior' 'interior' "There is nothing special about the interior. ";

+ OpenableContainer,Component 'glove compartment' 'glove compartment'
	"There is nothing special about the glove compartment. "
	bulkCapacity = 3
;
++ Readable 'small diary' 'small diary'
	"This is a small book. On the cover it says <q>My Life</q>. "
	readDesc = "The diary isn't too long, but most of it seems pretty repetitive. Here
		are the final entries which look quite important:<.p>
		
		May 7, 1982:\n
		Today I drove east. The river is looking particularly nice, but the view
		was ruined by some of right bastards that are on the road today. Where do these people
		learn to drive? As usual there's that bastard race car that keeps zipping around like
		this is the Indy 500, but he isn't so bad so long as I stay out of his way.
		I saw a few green monsters, but it was always from a distance.<.p>
		
		May 8, 1982:\n
		Today I drove east. The river was ok, but the view was ruined by the bastard
		driving two lanes over who was keeping time with me, taunting me as everyone
		taunts me.
		I rolled over the green monster a few times.
		Ohhh, how I love to see the blood explode out of it when
		I hit it at full speed. It's one of the few joys of my tortured existence.<.p>
		
		May 9, 1982:\n
		Today I drove east, but I ran out of gas, so I had to get out and push the car east
		for a bit until the aerial fueler came by and filled it up again. This would normally be
		very irritating, but I encountered the green monster while pushing the car.
		Normally the roller takes care of it, but there was no way I could push the car
		fast enough to get it, so I beat it to death with my bare hands.<.p>
		
		May 10, 1982:\n
		I have killed many frogs with the roller, but yesterday I killed one with my bare hands
		for the first time. When using the roller it was almost a game. The frogs always seemed
		to taunt me with their presence, so I rewarded their arrogance by flattening them
		and referring to them as monsters. But, using my bare hands was far more personal.
		I feel horrible guilt. The fact that I am no better than a murderer is now clear to me.
		I can no longer continue driving like I always have. I am abandoning my car and am going
		to attempt to cross the river. I hope that if anyone reads this, they will understand
		that I never realized what I was. I hope that I can be forgiven. "
;

