#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>

neighbour: Person
    'tall thin mrs mrs. kindly kind dogwood/neighbour/neighbor/woman/lady' 
    'neighbor' 
    @nextDoorGarden
    
    "She\'s tall and thin, and is wearing a big floppy hat of straw.
    She has rather a kindly look. "
    makeProper()
    {
        name = properName;    
        isProperName = true;
        return name;
    }
    
    /* We want it to be possible to give the neighbour things over the fence */
    iobjFor(GiveTo) { preCond = [objVisible] }
    
    canBeTalkedTo(talker, sense, info)
    {
        if(!talker.isIn(backYard))
            return nil;
        
        return inherited(talker, sense, info);
    }
    
    properName = 'Mrs. Dogwood' 
    isHer = true   
    globalParamName = 'neighbour'
    sightSize = large
    
    /* 
     *   We want to provide custom responses to these actions, not the 
     *   default "too far away" messages the library would give if we left 
     *   the default touchObj preconditions here.
     */
    preCondDobjKiss = [objVisible]
    preCondDobjPull = [objVisible]
    preCondDobjMove = [objVisible]
    
    cannotCleanMsg = '{The neighbour/she} looks well able to take care of her
        own personal hygiene. '   
    cannotMoveMsg = (gAction.getEnteredVerbPhrase == 'pull (dobj)' ? 'As she\'s
        not sitting on a wagon, that would be impractical. ' : 'You try to
            compose a suitably moving speech, but it proves to be beyond
            you. ')
    
    /* 
     *   The noticeWigDaemon will cause her to make a remark if you show up 
     *   wearing a wig -- but only once.
     */
    
    afterAction()
    {
        if(gActionIs(Play) && gDobj == ocarina && neighbour.canTalkTo(me))
        {
            
            "<<(neighbour.name == 'neighbor') ? 'The woman in the garden next
                door' : 'Mrs.\ Dogwood'>> clamps her hands over her ears.
            <.q>My goodness, what an awful racket!<./q> ";
        }
        
        inherited();
    }
    
    
// ECSE All the commented-out code below is replaced by the wigAgenda object
// At the end of the file.    
    
//    startDaemon {
//        if (!noticeWigDaemonID) {
//            noticeWigDaemonID = new Daemon (self, &noticeWigDaemon, 1);
//        }
//    }
//    noticeWigDaemonID = nil
//    noticedTheWig = nil
//    noticeWigDaemon {
//        if (noticedTheWig) {
//            if (noticeWigDaemonID) {
//                noticeWigDaemonID.removeEvent;
//                noticeWigDaemonID = nil;
//                return;
//            }
//        }
//        
//        /* Is she talking to you? */
//        if (curState != neighbourTalkingState) 
//            return;
//        
//        /* Are you in the correct place? */
//        if (me.location != backYard)
//            return;
//        
//        /* Are you wearing a wig? */
//        local wearingWig = nil;
//        if ((blackWig.wornBy == me) || (auburnWig.wornBy == me) ||
//            (greenWig.wornBy == me) || (blondWig.wornBy == me)) 
//            wearingWig = true;
//        
//        if (!wearingWig) 
//            return;
//        
//        /* Okay, she needs to comment on it! */
//        noticedTheWig = true;
//        "<.q>My goodness,<./q> Mrs.\ Dogwood exclaims. <.q>What\'s that on your
//        head? It looks just like one of Mrs.\ Pepper\'s awful wigs. It looks
//        rather silly on you, I must say, but I suppose young people\'s sense of
//        what\'s fashionable or trendy is not quite the same as mine.<./q> ";
//    }
;

+ strawHat: Decoration 'big floppy straw hat*hats' 'straw hat'
    "Her hat shades her face, which is bound to be an advantage to someone
    working in a garden. "
;

+ Decoration 'jacket' 'jacket'
    desc()
    {
        if(brooch.wornBy == neighbour)
            "It has a brooch pinned to it. ";
        else
            inherited;
    }
    ownedBy = location
;

+ neighbourTalkingState: InConversationState
    specialDesc = "{The neighbour/he} {is} standing near the fence, looking
        over it at you. "
    remoteSpecialDesc(pov) { specialDesc; }
    beforeAction() 
    {
        if(gActionIs(Yell))
        {
            reportFailure('There\'s no need to shout --- {the neighbour/she}
                can hear you perfectly well. ');
            exit;
        }
    }
    
;

++ bambooAbout: AskTopic @bamboo
    "<.q>That\'s a very impressive patch of bamboo you have there,
    <<getActor.name>>,<./q> you say.<<askingAboutIt>>\b
    <.q>Oh, you like my bamboo,<./q> she replies. <.q>I\'m quite proud of it.
    It\'s not as easy to grow in this climate as you might suppose.<./q> "
    askedAboutIt = nil
    askingAboutIt {  askedAboutIt = true;  }
;
+++ AltTopic
    "<.q>Do you know, is bamboo good for anything special?<./q> you ask.\b
    <.q>Oh, lots of things, I\'m sure,<./q> Mrs.\ Dogwood replies. "
    isActive = bambooStick.moved
;
    
++ AskForTopic [bamboo, bambooStick]
    topicResponse {
        if (!bambooAbout.askedAboutIt)
            "<.q>That\'s a very impressive patch of bamboo you have there,
            <<getActor.name>>,<./q> you say. <.q>I\'ve always thought it would
            be fun to have a walking cane made of
            bamboo.<<bambooAbout.askingAboutIt>> I don\'t suppose there\'s any
            chance you could cut off one of the pieces for me? You\'d hardly
            miss it!<./q><.reveal bamboo-request>\b
            <.q>Oh, you like my bamboo,<./q> she replies. <.q>I\'m quite proud
            of it. But I dislike cutting any, you know, unless I have a good
            reason.<./q> ";
        else
            "<.q>I don\'t suppose there\'s any chance
            you could cut off a piece of bamboo for me,<./q> you suggest.
            <.q>You\'d hardly miss it!<./q><.reveal bamboo-request>\b
            <.q>I dislike cutting any of my nice bamboo,<./q> she replies, <.q>
            unless I have a good reason.<./q> ";
    }
;

+++ AltTopic
    topicResponse 
    {
        gReveal('bamboo-request');
        "<.q>That\'s a very impressive patch of bamboo you have there,
        <<getActor.name>>,<./q> you say. <.q>I\'ve always thought it would be
        fun to have a walking cane made of bamboo. I don\'t suppose there\'s
        any chance you could cut off one of the pieces for me? You\'d hardly
        miss it!<./q>\b
        <.q>Oh, you like my bamboo,<./q> she replies. <.q>I\'m quite proud of
        it. Normally I dislike cutting it, but...<./q> She pauses.\b ";
        bambooStick.possiblyGive();
    }
    isActive = (brooch.wornBy == neighbour)
;

+++ AltTopic
    "{The neighbour/she} has already given you one bamboo stick; it might be
    pushing your luck too far to ask for another. Besides, what use would you
    have for it? "
    isActive = bambooStick.moved
    isConversational = nil
;

++ AskAboutForTopic @strawHat
    "<.q>Oh, you like my straw hat, do you?<./q> Mrs.\ Dogwood adjusts the brim
    of the hat, settling it more firmly on her head. <.q>I\'d have a sunburned
    nose for certain without a good hat!<./q> "
;

++ DefaultAskForTopic
    "<.q>Can I have...<./q> you begin.\b
    <.q>Tut, Tut!<./q> She chides you with mock severity. <.q>You mean,
    <.s>Please <i>may</i> I have...<./s>!<./q> "
;

//----------------------------------------------------------------------------
// AskTellTopics.

++ AskTellTopic, StopEventList [elf, pamphlet]
    [
        {: "<.q>Do you know anything about...,<./q> you begin, and then pause.
            <.q>I mean, have you ever seen any sort of small, weird-looking
            guys hanging around Mrs.\ Pepper\'s back yard, or in your garden? I
            mean, like, really small and really weird. Like elves or
            something?<./q>\b
        <<getActor.name>> gives you an odd look. <.q>Elves? No, of course not.
            What an odd question! Although, you know, there have been a few
            times, just at sunset, when the light wasn\'t good, when I thought
            I saw ... no, it was only my imagination, I\'m sure of it.<./q> "},
        
        {: "You decide to try one more time. <.q>Are you absolutely sure you
            don\'t know anything about elves?<./q>\b
            <<getActor.name>> shakes her head firmly. "}
    ]
    isActive = (elf.getOutermostRoom != backYard)
;

++ AskTellGiveShowTopic @elf
    "<<getActor.name>> is busy puttering around in her garden. After considering
    it for a moment, you can\'t help thinking that maybe drawing her attention
    to the extremely peculiar little man would be a mistake. "
    isActive = (elf.getOutermostRoom == backYard)
    isConversational = nil
;

++ AskTopic [tJimAikin, tEricEve]
    "<.q>Oh, he's a very nice gentleman,<./q> she replies promptly. <.q>But I\'ve
    noticed --- well, one doesn\'t like to criticize, but he does seem to take
    an almost perverse pleasure in using his computer to devise perplexing
    situations that others then have to grapple with. "
;

++ AskTopic, StopEventList @birdbath
    [
        '<.q>Mrs. Pepper\'s birdbath doesn\'t seem to be attracting many
        birds,<./q> you remark. <.q>It doesn\'t even have any water in
        it!<./q>\b
        <.q>No,<./q> she agrees. <.q>Mrs. Pepper would make a very good
        scarecrow!<./q> ',
        
        '<.q>Why doesn\'t Mrs. Pepper put any water in her birdbath?<.q> you
        ask.\b
        <.q>She\'s not what I\'d call the nurturing sort,<./q> {the
        neighbour/she} replies. ',
        
        'You\'ve probably exhausted the topic of Mrs. Pepper\'s birdbath for
        now. '
    ]
    isConversational = curScriptState < 3
;

++ AskTopic, SuggestedAskTopic, StopEventList +90 @tMrPepper
    [
        '<.q>What happened to Mrs.\ Pepper\'s husband,<./q> you ask.\b
        <.q>Such a tragic accident,<./q> the neighbor replies. <.q>If it
        <i>was</i> an accident. I\'ve always wondered about that. But really, I
        mustn\'t gossip.<./q> ',
        
        '<.q>No, I really don\'t feel comfortable saying any more about
        that,<./q> she says. '
    ]
    name = 'Mr. Pepper'
;

++ AskTopic, SuggestedAskTopic, StopEventList @wheelchair
    [
        '<.q>I saw an old wheelchair down in the cellar of Mrs.\ Pepper\'s
        house,<./q> you mention casually.\b
        <.q>Oh, you did, did you?<./q> The neighbor raises her eyebrows.
        <.q>And I suppose you just come and go in her cellar as you please!
        Well, never mind about that. It was just a terrible accident, you see.
        Poor Mr. Pepper had been confined in that chair for some years. That\'s
        why the ramp was built by the back door, and I\'m told there\'s an
        elevator in the house for the same reason, though I couldn\'t say that
        of my own knowledge.\b
        <.q>At all events, they found him one day, at the foot of the cellar
        stairs, quite dead. The chair must have swerved somehow, though it\'s
        hard to say exactly how that could have happened. Well, the ambulance
        came and they took him away. I can\'t say I\'m surprised the chair is
        still down there. I don\'t think I could bear to touch it myself, if it
        had been my husband.<./q> ',
        
        '<.q>Do you know anything else about the wheelchair?<./q> you inquire.\b
        <.q>I don\'t believe I do,<./q> she says. '
    ]
    name = 'the wheelchair'
;

++ AskTellTopic, StopEventList @toad
    [
        '<.q>Do you know anything about frogs and toads?<./q> you ask Mrs.\
        Dogwood.\b
        <.q>My goodness, what a question! Not so very much, no. I\'ve noticed a
        fat old toad hopping about from time to time. I believe he lives under
        Mrs.\ Pepper\'s back porch. If you find him, I do hope you won\'t catch
        him in a jar or anything. That would be very cruel.<./q> ',
        
        '<.q>Can you tell me anything else about toads?<./q> you ask.\b
        <.q>They eat insects,<./q> she replies. <.q>Other than that, I\'m
        afraid I\'m at a complete loss what to tell you.<./q> ',
        
        'It seems unlikely Mrs.\ Dogwood will have anything further to say on
        that subject. '
    ]
    isConversational = curScriptState < 3
;

++AskTellTopic, SuggestedAskTopic, StopEventList [nextDoorGarden, tGardening]
    [
        '<.q>I was just admiring your wonderful garden,<./q> you tell Mrs.\
        Dogwood politely.\b
        <.q>Why, thank you, dear!<./q> she replies.\b
        <.q>It\'s much nicer than Mrs.\ Pepper\'s,<./q> you add.\b
        <.q>I don\'t like to speak ill of anyone,<./q> Mrs.\ Dogwood says
        piously, <.q>but I think it\'s fair to say Mrs.\ Pepper doesn\'t have a
        green thumb.<./q> ',
        '<.q>Can you tell me anything else about your garden?<./q> you go on.\b
        <.q>Not unless you\'re fascinated by fuschia, in love with lilies, and
        dazzled by rhododendrons,<./q> she says. '
    ]
    name = 'gardening'
;

++AskTopic, StopEventList @tMagic
    [
        '<.q>You don\'t believe in magic, do you?<./q> you ask.\b
        She titters. <.q>Magic? You mean like spells and witchcraft and such
        muck? Certainly not! I\'m a sensible modern woman. All the same, one
        hears tales....<./q> ',
        'You decide to try again. <.q>Are you sure you don\'t believe in magic?
        Like, how somebody might cast a certain spell?<./q>\b
        She snorts derisively. <.q>The very idea!<./q> '
    ]
;

++AskTellTopic, SuggestedAskTopic, StopEventList @oldCar
    [
        '<.q>I saw Mrs.\ Pepper\'s old car in her driveway,<./q> you remark.
        <.q>Is it always there?<./q>\b
        <.q>If she\'s home, it is,<./q> Mrs.\ Dogwood replies promptly.
        <.q>Sometimes in the afternoon she goes out driving, if there\'s a
        special sale on at the mall. You know, Flogg & Grabby\'s, down the
        road?<./q><.convnode flogg> ',
        
        'The neighbor shakes her head. <.q>I\'m afraid I\'ve told you all I
        know about that, dearie.<./q> '
    ]
    name = 'Mrs. Pepper\'s old car'
;

++ AskTopic @rake
    "<.q>I don\'t suppose you have a rake I could borrow,<./q> you ask.\b
    <.q>Oh, I\'m afraid mine\'s at the shop. I know I\'ve seen Mrs.\ Pepper
    using a rake, not that she has anything over there worth raking. Perhaps
    she keeps it in the garage.<./q> "
;

++AskTopic, SuggestedAskTopic, StopEventList @neighbour
    [
        '<.q>You seem to be quite a fine gardener,<./q> you venture. <.q>Have
        you lived in that house for a long time?<./q>\b
        <.q>Oh, long enough,<./q> she replies vaguely. <.q>I daresay I\'m not a
        very interesting person.<./q> ',
        '<.q>You must see a lot of what goes on in the neighborhood,<./q> you
        comment, <.q>if you spend much time in your garden.<./q>\b
        <.q>Oh, I try to mind my own business,<./q> she replies. ',
        'Your continued conversational efforts to learn more about Mrs.\
        Dogwood lead nowhere. She seems rather modest, far more interested in
        gardening than in talking about herself. '
    ]
    name = 'herself'
;

++ skateboardAsk: AskTellTopic, StopEventList @skateboard
    [
        'With some hesitancy, you tell Mrs.\ Dogwood how Mrs.\ Pepper took your
        skateboard. <.q>That\'s scandalous!<./q> she replies. <.q>But I can\'t
        say I\'m surprised. That\'s exactly the sort of person she is, you
        know.<./q>\b
        <.q>Well, do you know where she put it? I\'d like to get it
        back.<./q>\b
        <.q>Oh, no,<./q> she says. <.q>I wish I could help you, honestly. You
        say this was on Friday? I <i>did</i> notice her putting something under
        the back porch on Friday afternoon, now that you mention it. I paid no
        special attention at the time, but I suppose it could have been your
            skateboard. Did you look there?<./q> ',
        
        '<.q>I really don\'t know anything else about that,<./q> she says,
        <.q>beyond what I told you already.<./q> '
    ]
;

+++ AltTopic
    "You mention to Mrs.\ Dogwood that you saw your skateboard under Mrs.\
    Pepper\'s back porch. <.q>But I can\'t reach it,<./q> you add. <.q>Can you
    help me get it out from under there?<./q>\b
    <.q>I can\'t really take the time off from my gardening,<./q> she replies.
    <.q>I\'m quite busy this time of year, you know. And anyway, my arms
    aren\'t much longer than yours. What you need is something long to reach
    under the porch with. I expect if you look around, you might be able to
    find something that would serve.<./q> "
    isActive = (skateboard.discovered && !skateboard.moved)
;

+++ AltTopic, StopEventList
    [
        'You boast to Mrs. Dogwood that you found your skateboard under Mrs.
        Pepper\'s porch, and actually managed to get it back!\b
        <.q>Oh, that\'s wonderful, dear,<./q> she replies. <.q>I\'m so
        pleased.<./q> ',
        
        'You\'ve already told Mrs. Dogwood about getting your skateboard back.
        There\'s not much else to tell. '
    ]
    isActive = (skateboard.moved)
    isConversational = curScriptState < 2
;

++ AskTopic, SuggestedAskTopic, StopEventList @mrsPepper
    [
        '<.q>Do you know Mrs.\ Pepper well?<./q> you ask.\b
        <.q>As well as I want to!<./q> {the neighbour/she} replies. Lowering
        her voice, she adds in a near whisper, <.q>I don\'t normally go in for
        tittle-tattle, but she really is the <i>meanest</i>.... Well, I dropped
        a fine gold brooch one day when I was working near the fence. At least,
        I don\'t know where else I could have dropped it. A few minutes later
        I\'m sure I saw her arm snaking right through the fence, down near the
        ground. By the time I put down my shears and came to take a closer
        look, she was trotting into the house. I never did find that brooch.
        I\'m sure she took it, but when I asked, quite politely, if she might
        have seen it or know where it could be, she got all huffy and claimed
        not to know what I was talking about. Swears she never saw it, she
        does!<./q> <.reveal brooch>',
        
        '<.q>So you think Mrs.\ Pepper is...<./q> you begin.\b
        <.q>... a bad neighbor,<./q> {the neighbour/she} breaks in,
        <.q><i>particularly</i> because she\'s made off with my brooch!<./q>'
    ]
    name = 'Mrs. Pepper'
;

++ AskTellTopic, SuggestedAskTopic, StopEventList @brooch
    [
        '<.q>What does your brooch look like?<./q> you ask.\b
        <.q>It\'s round, and gold, and about so big,<./q> she tells you, holding
        her thumb and forefinger to form a circle about an inch and a half in
        diameter. <.q>It\'s very precious to me, because my mother gave it to
        me. Many years ago her mother, my grandmother, gave it to her.<./q> ', 
        
        '<.q>What did you say your brooch looked like?<./q> you ask.\b
        <.q>It\'s round, and gold, and about so big,<./q> she reminds you,
        holding her thumb and forefinger to form a circle about an inch and a
        half in diameter. '
    ]
    isActive = gRevealed('brooch')
    name = 'her brooch'
;

+++ AltTopic, SuggestedTellTopic, StopEventList
    [
        {: "<.q>I found<<(brooch.hasBeenNamed) ? '' : ' a shiny thing that
            looks a bit like'>> a gold brooch in a jar in Mrs.\ Pepper\'s
            cellar,<./q> you inform Mrs.\ Dogwood.\b
        <.q>My goodness!<./q> she exclaims. <.q>That must be my brooch! Do you
            have it with you? Can you go and get it and bring it to me? I\'d be
            ever so grateful! I thought it was lost
            forever!<<brooch.giveName>><./q> "},
        '<.q>Yes, you told me a few moments ago about finding it. I do hope you
        haven\'t lost it again. I\'d like very much to have it back, if it\'s
        not too much trouble.<./q> '
    ]
    isActive = me.hasSeen(brooch)
    name = (brooch.theName)
;

+++ AltTopic
    "<.q>Yes, it\'s beautiful, isn\'t it?<./q> she says, proudly showing it
    off. <.q>If I can do you the slightest favor in return for finding it, you
    have only to ask.<./q> "
    isActive = (brooch.wornBy == neighbour)
;

++ AskTellTopic, StopEventList [holes, gravel]
    [
        '<.q>Why are there all those holes in Mrs. Pepper\'s back yard?<./q>
        you ask.\b
        <.q>Goodness knows,<./q> she sighs. <.q>I suppose that\'s her idea of
        gardening. She doesn\'t exactly have green fingers --- more like black
        fingers, I\'d say.<./q> ',
        
        '<.q>So Mrs. Pepper dug all those holes because she\'s no good at
        gardening?<./q> you ask.\b
        <.q>Something like that,<./q> she agrees. '
    ]
;

++ AskTopic, StopEventList [auburnWig, blackWig, blondWig, greenWig, tWigsPlural]
    [
        '<.q>Can you tell me anything about Mrs.\ Pepper\'s wigs?<./q> you
        ask.\b
        <.q>Hideous, aren\'t they?<./q> Mrs.\ Dogwood responds promptly. <.q>I
        don\'t know why she\'s so fond of them, or where she buys them, but I
        daresay there\'s no accounting for taste.<./q> ',
        'You try asking more questions about Mrs.\ Pepper\'s taste for wigs,
        but it\'s clear Mrs.\ Dogwood has lost interest in the topic. '
    ]
;

++ AskTopic, StopEventList [tWater, tRain]
    [
        '<.q>Do you know where I can get some fresh water?<./q> you ask.\b
        <.q>Now that is difficult,<./q> she remarks, absently scratching her
        head. <.q>The tap water in this neighborhood isn\'t the best I\'ve
        tasted --- but fresh water? There isn\'t a stream or river nearby ---
        about the only way you\'d get fresh water is if it rained, and they\'re
        not forecasting rain for days!<./q>',
        
        '<./q>So if I want fresh water, I have to wait for it to rain?<./q> you
        ask.\b
        <.q>That\'s right,<./q> she replies briskly, adding with a mildly
        patronizing little smile, <.q>unless you know a way to make rain, that
        is!<./q> '
    ]
    isActive = gRevealed('need-water')
;

/* 
 *   In the main AskTopic, you've been in the house, which means you've 
 *   recovered the keys, so there's little likelihood that you'll be asking 
 *   about them....
 */
++AskTopic [tKeys, keyBunch]
    "Letting {the neighbour/her} suspect that you\'ve been in the house, found
    the keys, and are now free to come and go as you please might not be
    wise. "
;

+++ AltTopic, StopEventList
    [
        '<.q>Do you know where I might find a key to Mrs.\ Pepper\'s
        house?<./q> you ask. <.q>Like, under the doormat or something?<./q>\b
        <.q>I expect she\'s much too secretive to leave keys lying around where
        anyone could get at them,<./q> Mrs.\ Dogwood replies. <.q>Of course, I
        can\'t advise that you try to get into her house in any case. That
        could land you in a great deal of trouble. I don\'t honestly know if
        she\'s home this afternoon, but if she\'s not, she could return home at
        any moment, so it wouldn\'t be safe --- no, not safe at all.<./q> Mrs.\
        Dogwood pauses for a moment and looks at you speculatively. <.q>I\'ve
        noticed that in such warm weather as this, people don\'t always think
        to close their windows. There, I\'ve said too much.<./q> ',
        
        'Mrs.\ Dogwood has already suggested that you look for an open window.
        Provoking her suspicions by pursuing the subject any further might not
        be wise. '
    ]
    isActive = (!kitchen.seen)
    isConversational = curScriptState < 2
;

++ DefaultTellTopic, ShuffledEventList
    [
        '{The neighbour/she} listens with the kind of tolerant smile you\'ve
        come to associate with grown-ups who are not taking you seriously. ',
        
        '{The neighbour/she} nods at appropriate points in your account. ',
        
        '{The neighbour/she} looks faintly amused at what you have to say. ',
        
        '<.q>Really?<./q> {the neighbour/she} remarks. ',
        
        'As you\'re talking, she bends intently over a begonia and flicks a bug
        off of its blossom. <.q>I\'m sorry,<./q> she says, straightening up.
        <.q>These pests are so distracting.<./q> ',
        
        '<.q>That\'s fascinating,<./q> {the neighbour/she} replies. '
    ]
;

++ DefaultAskTopic, ShuffledEventList
    [
        '<.q>That\'s a bit complicated to go into right now, dear,<./q> she
        tells you. ',
        
        '<.q>Well...<./q> she begins, then shakes her head, <.q>No, I don\'t
        have time to explain all that now.<./q>',
        
        '<.q>To tell you the truth,<./q> she begins, and then goes off into a
        rambling explanation you lose the thread of somewhere in the middle of
        the third sentence. ',
        
        '<.q>I hardly know what to say!<./q> she declares. ',
        
        '<.q>Some other time, perhaps,<./q> she suggests, with a lopsided smile.
        ',
        
        '<.q>My, but you\'re inquisitive!<./q> she exclaims. <.q>Just a regular
        little chatterbox.<./q> ',
        
        'She bends over a little bush to inspect it, and then straightens up
        when you start to speak. <.q>I\'m sorry, dear, I didn\'t quite catch
        that. I thought I saw an aphid. Horrid things, aphids.<./q> '
    ]
;

++ YesTopic
    "<.q>Yes what? I didn't ask you anything dearie.<./q> {The neighbour/she}
    frowns in mild puzzlement. "
;

++ NoTopic
    "<.q>Is something wrong? What are you saying <.s>no<./s> to?<./q> {the
    neighbour/she} asks, <.q>perhaps you misheard me --- I didn't just ask you
    anything!<./q>"
;

//------------------------------------------------------------------------------
// GiveShowTopics:

++ GiveShowTopic, StopEventList @ocarina
    [
        'You show the ocarina to {the neighbour/her}, and her face wrinkles in
        a disgusted frown. <.q>That awful thing? I\'ve heard Mrs. Pepper
        tootling on it, though I don\'t think she could carry a tune in a
        basket. She only plays it inside the house, thank goodness --- and I
        fancy the noise comes from upstairs.<./q> ',
        '{The neighbour/she} seems to have lost interest in the ocarina. '
    ]
;

++ GiveShowTopic, StopEventList @flyer
    [
        '{The neighbour/she} scrutinizes the advertising flyer for a moment.
        <.q>Wigs? I\'d have no interest in that, but I shouldn\'t be surprised
        if Mrs.\ Pepper would be keen to know about it. She\'s always been fond
        of wigs, and the cheaper the better. You might ring her doorbell and
        show it to her --- if you\'re feeling kindly toward her, I mean. ',
        '{The neighbour/she} shows no further interest in the advertising flyer. '
    ]
;

+++ AltTopic, StopEventList
    [
        '<.q>Oh, I know Mrs.\ Pepper would be keen to see that,<./q> {the
        neighbour/she} assures you. <.q>You could always drop it on her porch.
        When she comes out the door, she\'ll be bound to notice it.<./q>',
        
        '<.q>I still think leaving it on Mrs. Pepper\'s porch would be your
        best best,<./q> {the neighbour/she} tells you. '
    ]
    isActive = gRevealed('door-slam')
;

++ GiveShowTopic, SuggestedGiveTopic @brooch
    topicResponse()
    {
        "<.q>Do you recognize this brooch, by any chance, {the
        neighbour/she}?<./q> you ask.\b
        <.q>Yes! That\'s it! It\'s mine! I thought it was gone
        forever. Thank you so much for finding it for me.<./q> She takes
        the brooch and pins it to her jacket. ";
        brooch.moveIntoForTravel(neighbour);
        brooch.wornBy = neighbour;
        neighbourJarTopic.achievement.awardPointsOnce();
        bambooStick.possiblyGive();                
    }
    name = 'the brooch'
    isActive = brooch.hasBeenNamed
;

++ neighbourJarTopic: GiveShowTopic @glassJar
    topicResponse()
    {
        "<.q>I found this in Mrs.\ Pepper\'s cellar,<./q> you tell her, showing
        her the glass jar, <.q>but I\'m afraid I couldn\'t get it open.<./q>\b
        <.q>Never mind that!<./q> {the neighbour/she} declares with a
        surprisingly fierce gleam in her eye, <.q>That\'s my brooch all right,
        and as for Mrs.\ Pepper\'s jar...<./q>\b
        She snatches the jar out of your hand and smashes it against the fence
        as if it were an egg. Tossing the broken glass contemptuously aside,
        she pins the brooch triumphantly to her jacket. ";
        glassJar.getState = jarBroken;
        brooch.moveIntoForTravel(neighbour);
        brooch.wornBy = neighbour;
        glassJar.moveInto(nil);
        achievement.awardPointsOnce();
        bambooStick.possiblyGive();          
    }    
    isActive = !glassJar.isOpen
    achievement: Achievement { +2 "giving Mrs.\ Dogwood back her brooch" }
;

++ DefaultGiveShowTopic
    "<.q>I\'m afraid I'm not all that interested in {that dobj/him} right now,
    dear,<./q> she replies, with a quick glance at {the dobj/him}. "
;


++ CommandTopic @SystemAction
    "You seem to be a bit confused: it doesn\'t make sense to ask a character
    in the game to do that! "
    isConversational = nil
;

++ DefaultCommandTopic
    "You suspect that trying to boss {the neighbour/her} around may not be the
    best way to secure her friendly co-operation. "
    isConversational = nil
;

++ neighbourWorkingState: ConversationReadyState
    specialDesc = "{A neighbour/he} {is} working in the garden next door.
        <<me.setHer(neighbour)>>"
    remoteSpecialDesc(pov) { specialDesc; }
    isInitState = true
;

+++ HelloTopic, StopEventList
    [
        {: "<.q>Hi,<./q> you say. <.q>Who are you?<./q>\b
            <.q>I'm <<getActor.makeProper()>>, Mrs. Pepper\'s neighbor,<./q>
            she replies. " },
        
        '<.q>Hello again,<./q> you say.\b
        <.q>Hi there, youngster,<./q> she replies. '
    ]
;

+++ ImpByeTopic
    "{The neighbour/she} returns to her gardening. "
;

+++ ByeTopic
    "<.q><./s>Bye for now!<./q> you say.\b
    <.q>Goodbye,<./q> she replies, turning away to resume her gardening. "
;

+ ConvNode 'flogg'
;

++ YesTopic
    "<.q>Oh yes, my parents go there sometimes,<./q> you tell her, <.q>I'm not
    sure I like it much though. All that boring old junk!<./q>\b
    <.q>Quite,<./q> {the neighbour/she} agrees, <.q>You know <i>just</i> what
    sort of place it is then. But Mrs. Pepper likes it, because she can get
    things cheap.<./q>"
;

++ NoTopic
    "<.q>No, I can't say I do,<./q> you confess.\b
    <.q>You're not missing much,<./q> she assures you, <.q>It's full of nasty
    cheap stuff --- that's why Mrs. Pepper is so fond of going there!<./q>"
;


+ wigAgenda: ConvAgendaItem
    isReady = inherited && me.checkForWig
    initiallyActive = true
    
    invokeItem()
    {
        isDone = true;
        if(neighbour.curState != neighbourTalkingState)
            neighbour.setCurState(neighbourTalkingState);
        "<.q>My goodness,<./q> Mrs.\ Dogwood exclaims. <.q>What\'s that on your
        head? It looks just like one of Mrs.\ Pepper\'s awful wigs. It looks
        rather silly on you, I must say, but I suppose young people\'s sense of
        what\'s fashionable or trendy is not quite the same as mine.<./q> ";       
    }       
;
