#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>

/*
 *   Our game credits and version information.  This object isn't required
 *   by the system, but our GameInfo initialization above needs this for
 *   some of its information.
 *
 */

versionInfo: GameID
    IFID = '9c8b2fba-bb69-5767-e8d4-74eefa08daca'
    name = 'Mrs. Pepper\'s Nasty Secret'
    byline = 'by Jim Aikin and Eric Eve'
    htmlByline = 'by <a href="mailto:editor@musicwords.net">Jim Aikin</a>
        and <a href="mailto:eric.eve@hmc.ox.ac.uk">Eric Eve</a>'
    version = '1.03'
    authorEmail = 'Jim Aikin and Eric Eve <eric.eve@hmc.ox.ac.uk>'
    desc = 'A youngster\'s adventures at the house of a mean old widow'
    htmlDesc = 'A youngster\'s adventures at the house of a mean old widow'
    
    showAbout()
    {
        "<i><<name>></i> is a short, fairly easy game, designed to be played in
        an hour or two. It was written <<byline>> as an entry into Mark
        Engelberg's Interactive Short Fiction competition, and was also
        entered into David Fisher's IFBeginnersComp. (It won both competitions.)
        This game is suitable for
        newcomers to Interactive Fiction. In particular, you can\'t get it into
        an unwinnable state. The only ending is a winning one, you just have to
        find it.\b
        In this game you control the actions of a young person who is on the
        way home after school. What starts as a simple mission to retrieve your
        skateboard soon becomes something more. You\'ll need to explore Mrs.
        Pepper\'s property and see what else you can find there, overcoming
        some obstacles along the way.\b";
        helpMessage.printMsg();
        "For credits, type <<aHref('CREDITS','CREDITS','Show the
            credits')>>.<.p>";
    }
    
    showCredit()
    {
        inherited;
        
        "<p>Special thanks to:\b
        Mark Engelberg for devising and running the competition that inspired
        this game (and for some suggestions).\b
        David Fisher for devising and running a second competition we can enter
        this game into.
        Mike Roberts for writing TADS 3.\b
        Stephen Granade, for his cquotes extension.\b
        Steve Breslin, for his SpellingCorrector extension.\b
        Nikos Chantziaras, for ncDebugActions (an invaluable aid in
        debugging).\b
        Emily Short, for the NewbieGrammar.h extension (for Inform 6) from which
        we borrowed and adapted a number of ideas.\b
        And last, but absolutely not least, our intrepid team of beta-testers,
        without whom this game would have been riddled with distracting
        flaws: Emily Boegheim, Hannah Boegheim, Chris Jones, Juhana Leinonen,
        Jeff Liu, Justin Lowmaster, Radical Al,
        S.\ John Ross, Mike Snyder, and Mike Tarbert. ";
    }
;

/*
 *   Style tags for producing "curly" single- and double-quotes:
 */

dquoStyleTag: StyleTag 'q'
  openText  = '&ldquo;'
  closeText = '&rdquo;'
;

squoStyleTag: StyleTag 's'
  openText  = '&lsquo;'
  closeText = '&rsquo;'
;

/*
 *   The "gameMain" object lets us set the initial player character and
 *   control the game's startup procedure.  Every game must define this
 *   object.  For convenience, we inherit from the library's GameMainDef
 *   class, which defines suitable defaults for most of this object's
 *   required methods and properties.  
 */

gameMain: GameMainDef
    /* the initial player character is 'me' */
    initialPlayerChar = me
    showIntro()
    {
        "\b\b\bWalking home from school is mostly okay, except for one big
        problem: Every day you have to pass right by Mrs.\ Pepper\'s house. She
        may not actually be a witch, but she sure acts like one. She\'s ugly
        and crabby, and she seems to go out of her way to cause trouble for
        you. The time she came at you with the garden rake, swinging it like it
        was a giant claw ... you still shudder when you think of it.\b        
        Last Friday was a new low. You would never, ever skateboard in her
        driveway --- that would be practically suicidal. But somehow when you
        got to the driveway your skateboard swerved, all by itself, as if
        somebody had put a spell on it. And then you fell off.\b
        
        While you were picking grit out of the ugly scrape on your skinned
        elbow, Mrs.\ Pepper appeared out of nowhere and snatched up your
        skateboard! She screeched something about rowdy children, trespassing,
        and needing to be taught a lesson. She swung the skateboard at you like
        it was a bat, and then ran off with it, cackling. Afterward you rang
        her doorbell for what seemed like an hour, begging her to give the
        skateboard back, and she wouldn\'t even come to the door.\b
        
        And now it\'s Monday afternoon, and here you are, on your way home from
        school as usual (but with no skateboard). Just up ahead is Mrs.\
        Pepper\'s driveway.... 
        \b\b\b

	<center><font size=+2><b><<versionInfo.name>></b></font><.p>
	<font size=+1>An after-school adventure</font><.p>
	\^<<versionInfo.byline>></center>
        \b\b\b<<elf.startDaemon>><<neighbour.startDaemon>>";
        playerHelper.showAbout();
        "\b";
    }
    
    showGoodbye()
    {
        "<.p>Thanks for playing --- we hope you enjoyed it!<.p>";
    }
    
    setAboutBox()
    {
        "<ABOUTBOX><CENTER>
        \b\b
        <b><FONT SIZE=+1><<versionInfo.name>></FONT></b>\b
        <<versionInfo.byline>>\b
        Version <<versionInfo.version>>\b
        </CENTER></ABOUTBOX>";
    }
    
    allVerbsAllowAll = nil
    beforeRunsBeforeCheck = nil
;

/*
 *   Define the player character.  The name of this object is not
 *   important, but it MUST match the name we use to initialize
 *   gameMain.initialPlayerChar above.
 *  
 */

me: Actor
    location = onTheSidewalk
    bulkCapacity = 1000
    maxSingleBulk = 1000
    bulk = 50
    desc = "You<./s>re not wearing anything special today<<checkForWig() ? '
        (apart from the ridiculous wig, that is)' : ''>> --- just a shirt,
        jeans, and a pair of sneakers. "
    showAllHints = nil
    checkForWig 
    {
        return contents.indexWhich({x: x.ofKind(Wig) && x.wornBy == me } );
    }
    sightSize = medium
    
    /* 
     *   The countHeld method will let us know how many things the PC is 
     *   carrying that are NOT being worn:
     */
    countHeld = (contents.countWhich({x: x.wornBy != me}))
    
    cannotEatMsg = 'You gnaw on the corner of a fingernail for a moment, but
        really it doesn\'t taste that good. '
    uselessToAttackMsg = 'You lack both masochistic and suicidal tendencies. '
    cannotCleanMsg = dobjMsg('You can take a bath at home. ')
    cannotClimbMsg = 'You\'d have to be a contortionist to climb yourself. '
    droppingSelfMsg = (gAction.getEnteredVerbPhrase.startsWith('put ') ? 'You
        should never put yourself down. There are plenty of other people to
        give you put-downs.' : 'For better or worse, you\'re stuck with
            yourself for life. ')
    takingSelfMsg = 'Your attempts to pull yourself up by your own bootstraps
        are not crowned with success. '
    cutNoEffectMsg = 'You\'re not that keen on the sight of blood. '
    cannotDrinkMsg = 'The last time you looked, you weren\'t a liquid. '
    cannotFlipMsg = 'You\'re not an acrobat. '
    feelDesc = "Yup --- you\'re still all there! "
    cannotFollowSelfMsg = 'You don\'t have a tail to chase. '
    cannotJumpOverMsg = 'That would be an interesting trick, if you could
        manage it! '
    cannotKissSelfMsg = 'Kissing yourself --- now that would be <i>really</i>
        sad! '
    goToSleep = "You're not feeling even remotely tired. "
    moveNoEffectMsg = 'You remain unmoved. '
    pushNoEffectMsg = 'You don\'t like it when other people push you around, so
        you\'re not about to start doing it to yourself. '
    pullNoEffectMsg = 'You tug on a stray lock of hair, accomplishing very little. '
    cannotScrewMsg = 'I\'d really rather not. '
    cannotTurnOffMsg = 'A large plateful of over-boiled cabbage of the kind
        your school cook regularly produces normally has that effect;
        fortunately that\'s behind you for today. '
    cannotTurnOnMsg = 'Mom\'s cooking sometimes has that effect, but you\'ll
        have to wait till you get home. '
    cannotTurnMsg = 'You might get dizzy. '
    smellDesc = "You're no more malodorous than usual. "
    soundDesc = "You\'re so quiet as you listen to yourself that there's
        nothing to hear. "
    cannotUnplugMsg = 'Better not; you\'re never at your best unplugged. '
    nothingThroughMsg = 'Your mother always says she can see right through you,
        but you\'re more opaque to yourself. '
    throwingSelfMsg = 'Trying to work out how to throw yourself anywhere leaves
        you totally --- thrown. '
    puttingSelfMsg = 'Your parents and teachers, adults in general, and the
        older kids at school all seem eager enough to put you in your place,
        without your trying to join in! '   
    
    lastAction = nil
    actorAction()
    {
        if(!gAction.isImplicit)
            lastAction = gAction;
    }
;

+ myClothes: Wearable, Fixture
    'my clothes/clothing/jeans/shirt/sneakers/shoes/shoe/garments' 
    'your clothes'
    "Just your regular school clothes, nothing special. "
    isPlural = true
    wornBy = me
    isQualifiedName = true    
    dobjFor(Doff) 
    {
        check() 
        {
            failCheck('There\'s surely no reason to get undressed just now. ');
        }
    }
    cannotCleanMsg = dobjMsg('You mother does that for you. ')
;

+ Decoration 'dark muddy brown short hair' 'your hair'
    "It's a kind of muddy brown in colour and quite short, since you had it cut
    recently. "
    isMassNoun = true
    isQualifiedName = true
    ownedBy = me
    wornBy = me //so we're not count as held.
    notImportantMsg = 'You have better things to do than mess with your hair
        right now. '
    dobjFor(Pull)
    {
        verify() {}
        action() { "Ouch! "; }
    }
    dobjFor(Brush)
    {
        verify()
        {
            if(!gActor.canTouch(brush))
                illogicalNow('You have nothing to brush it with. ');
            else
                logicalRank(120, 'brushable');
        }
        check() {}
        action() { replaceAction(BrushWith, self, brush); }
    }
    
    dobjFor(BrushWith)
    {
        verify() { logicalRank(120, 'brushable'); }
        check() {}
        action() 
        { 
            "You give your hair a good brush. Maybe it ends up just a
            <i>little</i> tidier. "; 
        }        
    }
    
    beforeAction()
    {
        if(gDobj == self || gIobj == self)
        {
            local wigWorn = me.contents.valWhich({x: x.wornBy == me &&
                                                 x.ofKind(Wig) });
            if(wigWorn)
                tryImplicitAction(Doff, wigWorn);
        }
    }
;

//==============================================================================
/* Various game-wide modifications and definitions */

/* 
 *   The following custom MainCommandReports are used to help the 
 *   summarizing of reports relating to reactions to the ocarina being 
 *   played. If several openable objects exhibit the same behaviour, we want 
 *   them to be grouped into the same report (e.g "The stove, the drawer and 
 *   the cabinet slam shut" rather than "The stove slams shut. The drawer 
 *   slams shut. The cabinet slams shut. "). Using custom MainCommandReport 
 *   rather than double-quoted strings to report these reactions makes it 
 *   easier to identify and summarize the reports in the transcript.
 */

class SlamShutReport: MainCommandReport
    construct(obj)
    {
       /* remember the object that slammed */
        slamObj = obj;

        /* inherit the default handling */
        gMessageParams(obj);
        inherited('{The obj/he} slam{s} shut. ');
    }

    /* my slamming object */
    slamObj = nil

    sortOrder = 10
;

class SlamShutInDarkReport: MainCommandReport
    construct(obj)
    {
       /* remember the object that slammed */
        slamObj = obj;

        /* inherit the default handling */
        gMessageParams(obj);
        inherited('You hear something slam shut nearby. ');
    }

    /* my slamming object */
    slamObj = nil

    sortOrder = 10
;

class VibrateReport: MainCommandReport
    construct(obj)
    {
       /* remember the object that vibrates */
        vibObj = obj;

        /* inherit the default handling */
        gMessageParams(obj);
        inherited('{The obj/he} vibrate{s} for a moment in a dull, heavy way,
            as if {it\'s obj/he\'s} becoming darker and more massive. ');
    }

    /* my vibrating object */
    vibObj = nil

    sortOrder = 20
;

class ShimmerReport: MainCommandReport
    construct(obj)
    {
       /* remember the object that vibrates */
        vibObj = obj;

        /* inherit the default handling */
        gMessageParams(obj);
        inherited('{The obj/he} shimmer{s} pleasantly for a moment, as if a
            rainbow of light is passing across {it obj/him}.  ');
    }

    /* my vibrating object */
    vibObj = nil

    sortOrder = 30
;

class MomentaryShimmerReport: MainCommandReport
    construct(obj)
    {
       /* remember the object that vibrates */
        vibObj = obj;

        /* inherit the default handling */
        gMessageParams(obj);
        inherited('You fancy you detect a momentary shimmering across the
            surface of {the obj/him}, but possibly your eyes are playing tricks
            on you. ');
    }

    /* my vibrating object */
    vibObj = nil

    sortOrder = 40
;

//------------------------------------------------------------------------------
/* 
 *   Related to the above custom MainCommandReports are the modifications to 
 *   Openable that make use of them. This makes Openable objects subject to 
 *   magical locking and unlocking unless we define them to be not magically 
 *   lockable.
 */

modify Openable

    isMagicallyLocked_ = nil
    isMagicallyLocked()
    {
        return masterObject == self ? isMagicallyLocked_ :
        masterObject.isMagicallyLocked();
    }
    
    initiallyMagicallyLocked = nil
    
    makeMagicallyLocked(stat)
    {
        /* apply to self or the master object, as appropriate */
        if (masterObject == self)
            isMagicallyLocked_ = stat;
        else
            masterObject.makeMagicallyLocked(stat);

        /* inherit the next superclass's handling */
        inherited(stat);
    }

    initializeThing()
    {
        /* inherit the default handling */
        inherited();
        
        /* if we're the master, set our initial state */
        if (masterObject == self)
            isMagicallyLocked_ = initiallyMagicallyLocked;
    }
    
    dobjFor(Open)
    {
        check()
        {
            /* check the ordinary kind of lock first */
            inherited;
            
            /* then check for magic locking */
            if(isMagicallyLocked)
            {
                /* set 'it' to me, so TOUCH IT works */
                gActor.setPronounObj(self);
                if (blackWig.wornBy == me) 
                    giveExtraHintCount++;
                
                reportFailure(magicallyLockedMsg);
                
                if (giveExtraHintCount == 3) 
                {
                    "(It occurs to you vaguely that there might be
                    more to it than just wearing the black wig."; 
                    
                    if (dummiesBook.firstRead)
                        " You might want to look around for handy sources of
                        information on how Mrs.\ Pepper does things.";
                    ") ";
                }
                exit;
            }
        }
    }
    giveExtraHintCount = 0
    magicallyLockedMsg = '{The dobj/he} won\'t budge; {it dobj/he}
        resist{s} your attempts to open {it dobj/him} with almost supernatural
        determination. <.reveal magic-lock>'
    
    /* This can be used to exclude certain items from magic locking */
    canBeMagicallyLocked = true 
    
    afterAction()
    {
        local isVisible = (gActor.canSee(self));
        
        if(gActionIs(Play) && gDobj == ocarina && canBeMagicallyLocked)
        {
            if(blackWig.wornBy == gActor)
            {
                makeMagicallyLocked(!isMagicallyLocked);

                if(isOpen)
                {
                    if(isVisible)
                        gTranscript.addReport(new SlamShutReport(self));
                    else
                        gTranscript.addReport(new SlamShutInDarkReport(self));
                    makeOpen(nil);
                }
                else if(isVisible)
                {
                    if(isMagicallyLocked)
                        gTranscript.addReport(new VibrateReport(self));
                    else
                        gTranscript.addReport(new ShimmerReport(self));
                }
            }
            else if(isMagicallyLocked && isVisible)
                gTranscript.addReport(new MomentaryShimmerReport(self));
        }
    }
;

//==============================================================================

modify Lockable
    replace checkDobjOpen()
    {
        /* make sure we're unlocked */
            if (isLocked)
            {
                /* let them know we're locked */
                reportFailure(&cannotOpenLockedMsg);

                /* set 'it' to me, so UNLOCK IT works */
                gActor.setPronounObj(self);

                /* we cannot proceed */
                exit;
            }
        
        inherited;
    }
;




modify BoardAction
   isGetOn = (rexSearch('<NoCase>%<(on|onto)%>', getEnteredVerbPhrase))
;

/* 
 *   This modification is mainly about getting rid of the word "unusual," as 
 *   in "You see nothing unusual in the..." when the player looks in a 
 *   patently empty container.
 */
modify thingLookInLister
    showListEmpty(pov, parent)
    {
        gMessageParams(parent);
        defaultDescReport('There\'s nothing in {the parent/him}. ');
    }
;

modify Thing
    /* 
     *   This modification prevents things from being reported as seen from 
     *   the sidewalk when they've been dropped in the driveway:
     */
    sightSize = small
    
    /* for throwing paper objects at other things: */
    isPaper = nil
    dobjFor(JumpOver)
    {
        verify()
        {
            if(isIn(gActor))
                illogicalNow('You can hardly jump over {the dobj/him} while
                    you\'re carrying {it dobj/him}. '); 
        }
        action()
        {
            "You take a modest leap and land on the other side of {the
            dobj/him}. ";
        }
    }
    
    /* 
     *   This modification prevents your picking up anything while carrying 
     *   the pot. However, TADS will still allow you to take off the wig 
     *   while carrying the pot, so we'll handle that in the Wig class.
     */
    notifyMoveInto(newCont) 
    {
        if ((newCont == me) && (pot.location == me)) 
        {
            "You find that it\'s impossible to carry anything else
            while holding the heavy pot. ";
            exit;
        }
        else inherited (newCont);
    }
    
    // by default, do nothing.
    makeDamp(obj) { }
;

modify Readable
    /* 
     *   It will get slightly damp if it's placed in the sink while the 
     *   faucet is running:
     */
    isDamp = nil
    makeDamp (obj) 
    {
        if (!isDamp) 
        {
            reportAfter(&becomingDampMsg, self);
            isDamp = true;
            name = 'slightly damp ' + name;
            cmdDict.addWord(self, 'slightly', &adjective);
            cmdDict.addWord(self, 'damp', &adjective);            
        }
    }
    
    examineStatus()
    {
        if(isDamp)
            "It's slightly damp, but still readable. ";
        inherited();
    }
    
    feelDesc = "It feels <<isDamp ? 'a little damp' : 'much as you would
        expect'>>. "
;

modify Room
    /* We can always see a Room from a distance. */
    sightSize = large
    yellCheck() 
    {
        if(!elf.isIn(self))
           failCheck(noYellHereMsg); 
    }
    noYellHereMsg = 'You don\'t want to draw attention to yourself. '
    yellDesc() { mainReport(&okayYellMsg); }
    
    /* 
     *   Define a visted property that is set to true the first time the 
     *   player character enters this room.
     */
    visited = nil    
    
    travelerArriving(traveler, origin, connector, backConnector)
    {
        inherited(traveler, origin, connector, backConnector);
        if(me.isOrIsIn(traveler))
            visited = true;
    }
    
    dobjFor(Enter)
    {
        preCond = [objVisible]
        verify()
        {
            if(gActor.isIn(self))
                inherited;
        }
        
        action()        
        {
            local conn;
            
            /* find a connector from the current location to the new location */
            conn = gActor.location.getConnectorTo(gActor, self);
            
            /* if we found the connector, perform the travel */
            if (conn != nil)
                replaceAction(TravelVia, conn);
            
            /* otherwise, explain that we can't */
            else
                reportFailure(cannotTravelHereMsg, self);
        }
    }
    cannotTravelHereMsg(obj)
    {
        return '{You/he} cannot reach {the dobj/him} directly from here. Try
            getting nearer first. ';
    }
;

modify NonPortable
    dobjFor(JumpOver) { verify() { illogical(&cannotJumpOverMsg); }}
;

modify Decoration
    dobjFor(Search) asDobjFor(LookIn)
;

/* 
 *   This modification ensures that a container only lists its contents if 
 *   the player char is in the same location as the container.
 */
modify Container
    contentsListedInExamine = (gPlayerChar.isIn(getOutermostRoom))
;

modify Enterable
    dobjFor(LookIn) asDobjFor(Enter)
;

/* 
 *   This modification turns n-spaces back into ordinary spaces after the 
 *   abbreviations listed in the abbreviations property.
 */
modify typographicalOutputFilter
    filterText(ostr, val)
    {
        val = inherited(ostr, val);
        val = rexReplace(abbrPat, val, '%1. ', ReplaceAll);
        return val;
    }

    abbrPat = static new RexPattern(
        '<NoCase>%<(' + abbreviations + ')<dot>\u2002'
        )
    abbreviations = 'mr|mrs|dr|prof'
;

modify playerActionMessages
    cannotCleanMsg = 'One of the good things about going to school is you might
        just get a good enough education to <i>avoid</i> becoming a cleaner, so
        that\'s one skill you have no desire to practice! '
    cannotCutWithMsg {
        if (gDobj != me)
            return '{The iobj/he} do{es}n\'t have much of an edge to {it
            iobj/him}. You\'d probably have a hard time cutting butter with {it
            iobj/him}, let alone {the dobj/him}. ';
       return '{The iobj/he} do{es}n\'t have much of an edge to {it
            iobj/him}. You\'d probably have a hard time cutting butter with {it
            iobj/him}, let alone yourself. ';
    }
    cannotEatMsg = '{The dobj/he} look{s} profoundly unappetizing. '
    
    cannotFindTopicMsg = '{The dobj/he} do{es}n\'t seem to have much to say on
        that subject --- nothing you can find in the index, at any rate. '
    cannotGetOffOfMsg = 'You\'re not on {it dobj/him}. '
    cannotJumpOverMsg = 'This isn\'t the school sports day and you\'re not 
        feeling that acrobatic. '
    cannotJumpOffMsg = 'You\'re not on {the dobj/him}. '
    cannotKissMsg = 'You\'re not feeling that affectionate just now. '
    newlyDarkMsg = 'It\'s suddenly dark, and you can\'t see a thing. '
    timePassesMsg = 'Precious time slips by, never to be recovered. '
    shouldNotBreakMsg = 'Painful experience has taught you that breaking things
        quite often gets you into trouble. '
    needJetPackMsg = 'You\'d have to be wearing a jet-pack to manage that. '
    decorationNotImportantMsg(obj)
    {
        gMessageParams(obj);
        return 'You really don<./s>t need to mess with {the obj/him}. ';
    }

    notASurfaceMsg = '{The iobj/he} doe{es}n<./s>t look much good for putting
        things on. '
    mustBeJokingMsg = 'You must be joking! '    
    pushButtonNoEffectMsg = '{You/he} push{es} {the dobj/him}, but nothing
        happens. '
    leaveAloneMsg(obj)
    {
        gMessageParams(obj);
        return 'It would be politer and more considerate to leave {the obj/him}
            alone. ';
    }
    okayJumpMsg {

        if (me.getOutermostRoom == driveByHouse) 
            return 'You jump as high as you can, but the window remains
                elusively just out of reach. ';
        
        if ((me.location == cellar) && (glassJar.discovered) && 
            (glassJar.location == plankShelf))
            return 'You jump high enough that your fingertips almost brush the
                shelf, but the glass jar remains elusively just out of
                reach. ';
        
        return 'You jump up and down a few times. It doesn\'t achieve
                anything, but the exercise can\'t have done you any harm. ';
    }
    becomingDampMsg(obj)
    {
        gMessageParams(obj);
        return '{The obj/he} become{s} a bit damp. ';
    }
    okayTakeMsg = '{You/he} pick{s} up {the dobj/him}. '
    okayDropMsg = '{You/he} set{s} down {the dobj/him}. '
    throwHitFallMsg(projectile, target, dest)
    {
        gMessageParams(projectile, target);
        if (projectile.isPaper) return '{The projectile/he} 
            {flutter[s projectile]|fluttered} ' + dest.putInName + '. ';
        return '{The projectile/he} hit{[s]|} {the target/him}
            without any obvious effect, and {fall[s projectile]|fell} '
            + dest.putInName + '. ';
    }
    objCannotHearActorMsg(myActor)
    {
        gMessageParams(myActor);
        return '{The myActor/she} do{es}n\'t appear to hear you. Perhaps if you
            were closer to {it myActor/her}.... ';
    }
;

/* 
 *   So that commands like 'throw the jar against the wall' won't ask you 
 *   which wall you mean:
 */
modify defaultNorthWall
    vocabLikelihood = 10
;

modify Platform
    dobjFor(JumpOff)
    {
        verify() 
        {
            if(!gActor.isIn(self))
                inherited;
        }
        action()
        {
            "You jump off {the dobj/him} and land back on the ground. ";
            replaceAction(GetOffOf, self);
        }
    }
;

modify ComplexContainer
    dobjFor(JumpOff) maybeRemapTo(subSurface != nil, JumpOff, subSurface)
;

modify JumpOffIAction
    execAction()
    {
        local loc = gActor.location;
        if(loc.ofKind(Platform))
            replaceAction(JumpOff, loc);
        else
            inherited;
        
    }
;

modify JumpAction
   execAction()
    {
        local loc = gActor.location;
        if(loc.ofKind(Platform))
            replaceAction(JumpOff, loc);
        else
            inherited;
        
    }
; 


modify Actor
    tasteDesc = "{It dobj/he} really doesn't look that tasty! "
    cannotEatMsg = 'Whatever else you may be, you are not a cannibal! '
    lookThroughMsg = '{It dobj/he} doesn\'t look particularly transparent. '
    cannotKissActorMsg = 'It seems unlikely either of you would fancy that. '
    
    iobjFor(ThrowAt)
    {
        verify() 
        {
            illogical('It\'s rude to throw things at people. ');
        }
    }    
    iobjFor(ThrowTo)
    {
        verify() {}
        action()
        {
            "You consider tossing {the dobj/him} to {the iobj/him}, but you
            decide it would be safer and politer just to give {it dobj/him} to
            {it iobj/him} instead.<.p>";
            replaceAction(GiveTo, gDobj, gIobj);
        }
    }
;


/* 
 *   This code is imported from Eric's TADS 3 Tour Guide, with slight changes
 *   in the punctuation and handling for Unthing, MultiLocs and 'the floor':
 */
modify DefaultAskForTopic 
    handleTopic(fromActor, topic) 
    { 
        /* note the invocation */ 
        noteInvocation(fromActor); 
        
        /* set pronoun antecedents if possible */ 
        setTopicPronouns(fromActor, topic); 
        
        obj = topic.getBestMatch;     
        if(obj == nil) 
            inherited(fromActor, topic); 
        else if(obj.ofKind(Thing)) 
            handleThing(fromActor); 
        else if(obj.ofKind(Topic)) 
            topicMsg;         
    } 
    /* The object (if any) matched by this topic */ 
    obj = nil 
    
    handleThing(fromActor) 
    { 
        requestMsg;
        if(obj.isIn(fromActor)) 
            alreadyHaveMsg; 
        else if(obj.isIn(getActor)) 
            refuseMsg; 
        else if(obj == getActor) 
            askForOtherMsg; 
        else if(obj == fromActor) 
            askForSelfMsg; 
        // New code:
        else if (obj.ofKind(Unthing))
            dontHaveMsg;
        else if(getActor.canSee(obj)) 
            pointOutMsg; 
        else 
            dontHaveMsg;         
    } 
    
    requestMsg = "<q>Could you give me <<me.knowsAbout(obj) ? obj.theName :
          obj.aName>>, please?</q> you ask.\b"

    /* 
     *   The message to display if the player character asks for something 
     *   he already has.  If the player character is carrying the asked-for 
     *   object in another container, the NPC points this out.
     */ 
    alreadyHaveMsg = "<q>You already have <<obj.theName>>,</q>
        <<getActor.theName>> points out<<obj.isDirectlyIn(gActor) ? '.' : '.
            <q>\^'+ obj.itIsContraction +  ' in that ' + obj.location.name + '
                you\'re carrying.</q>'>> " 
    
    /* 
     *   The message to display if the requested actor has the object asks 
     *   for but declines to hand it over
     */ 
    refuseMsg = "<q>No, I need <<obj.itObj>> myself,</q> <<getActor.itNom>> replies. " 
    
    /* 
     *   The message to display if neither the asker nor the askee has the 
     *   object but the askee can see where it is
     */ 
    // Customized pointOutMsg to produce 'the floor' when indoors:
    pointOutMsg = "<q>\^<<obj.itIsContraction>> just over there,</q>
        <<getActor.itNom>> observes, pointing at
        <<obj.location.ofKind(OutdoorRoom) ? 'the ground' :
          ''>><<(obj.location.ofKind(Room) &&
                 !obj.location.ofKind(OutdoorRoom)) ? 'the floor' :
          ''>><<!obj.location.ofKind(Room) ? obj.location.theName : ''>>. " 
    
    /* 
     *   The message to display if neither the asker nor the askee has the 
     *   object and the askee can't see it
     */ 
    dontHaveMsg = "<q>I'm afraid I don't have <<objPronoun(obj)>>,</q> 
        <<getActor.itNom>> tells you. " 
    
    /* The message to display if the player asks for the NPC */ 
    askForOtherMsg = "<q>That's me --- here I am,</q> <<getActor.itNom>> tells you. " 
    
    /* The message to display if the player asks for himself/herself */ 
    askForSelfMsg = "<q>You're right there,</q> <<getActor.itNom>> points out. " 
    
    /* 
     *   By default we use the standard handling for a defined topic, but 
     *   this can be overridden if desired.
     */ 
    topicMsg() 
    { 
        if(ofKind(Script)) doScript; 
        else topicResponse; 
    }  
    
    objPronoun(obj)
    {
        if(gPlayerChar.knowsAbout(obj))
            return obj.itObj;
        if(obj.isPlural)
            return 'any';
        return 'one';
    }
; 

modify SuggestedTopicLister
    showListSuffixWide(cnt, pov, parent)
    {
        /* end the sentence; include a paren if not in explicit mode */
        ". You could also ask or tell <<targetActor.itObj>> about various
        other things that might occur to you.<<isExplicit? '' : ')'>> ";
    }
    showListEmpty(pov, parent)
    {
        /*
         *   say that the list is empty if it was explicitly requested;
         *   say nothing if the list is being added by the library
         */
        if (isExplicit)
        {
            gMessageParams(askingActor, targetActor);
            "<<isExplicit ? '' : '('>>{You askingActor/he} {have} nothing
            very specific in mind right now to discuss with
            {the targetActor/him}, but by all means try anything
            that occurs to you.<<isExplicit ? '' : ')'>> ";
        }
    }
;

modify NestedRoom
     
    /* 
     *   checkTouchViaPath() is a standard library method defined on Thing 
     *   (and on some of Thing's subclasses). Here we use it to enforce the 
     *   condition that an actor in NestedRoom can't touch anything outside 
     *   that NestedRoom (apart from author-defined exceptions).
     */
    
    checkTouchViaPath(obj, dest, op)
    {
        /* 
         *   Allow an actor in this NestedRoom to touch the NestedRoom 
         *   itself, plus anything defined as being reachable from inside the
         *   NestedRoom, but nothing else that's not in the NestedRoom.
         */
        if(op == PathOut && dest != self && !canReachFromInside(obj, dest))
           return new CheckStatusFailure(cannotReachFromInsideMsg(dest), dest);
                           
        return inherited(obj, dest, op);
    }
    
    /* 
     *   Display a suitable message explaining why the actor (obj) can't 
     *   touch the object (dest) that's outside this NestedRoom. Note, this 
     *   is not a standard method on NestedRoom - we've "borrowed" it from 
     *   OutOfReach.
     */
    
    cannotReachFromInsideMsg(dest)
    {
        return 'You can\'t reach ' + dest.theName + ' from ' + theName + '. ';
    }
   
    /*  
     *   canReachFromInside() is likewise a custom method (on NestedRoom), 
     *   though the library does define it on OutOfReach. Here we use it to 
     *   determine which objects outside this NestedRoom (if any) an actor 
     *   can reach from inside. Here obj is the actor doing the reaching and 
     *   dest is the object the actor is trying to reach. 
     *
     *   By default, we don't allow an actor inside us to reach anything 
     *   outside us.
     */
    
    canReachFromInside(obj, dest) { return nil; }
    
    /*  
     *   This is a standard library method which is called when someone can't
     *   touch through us. Here we assume that since the problem is limited 
     *   reach from within this NestedRoom the way to remove the obstructor 
     *   (i.e. to bring the target object within reach) is simply to leave 
     *   this NestedRoom.
     */
    
    tryImplicitRemoveObstructor(sense, obj)
    {       
        return tryRemovingFromNested();
    }
      
;

modify TourGuide
    dobjFor(Follow)
    {
        verify()
        {
            /*
             *   If the actor can see us, and we're in a "guided tour"
             *   state, we can definitely perform the travel.  Otherwise,
             *   use the standard "follow" behavior. 
             */
            if (gActor.canSee(self) && getTourDest() != nil)
            {
                logicalRank(120, 'followable');
                /* 
                 *   we're waiting to show the actor to the next stop on
                 *   the tour, so we can definitely proceed with this
                 *   action 
                 */
            }
            else
            {
                /* we're not in a tour state, so use the standard handling */
                inherited();
            }
        }
    }

;


/* Prevent other PreParsers from messing with player comments */
modify commentPreParser
    runOrder = 10
;

/* 
 *   Topics that can be looked up in the book, or conversed about:
 */

tRain: Topic '(cause) (produce) (producing) making summoning (causing) rain (spell)
    rain/precipitation/storm/cloud/clouds'; 
tMrPepper: Topic 'mr mr. pepper/husband';
tMagic: Topic 'spell/magic/witchcraft/spells/spell-casting';
tWitches: Topic 'witch/witches/crones/crone';
tMagicLock: Topic
    '(magic) magically lock unlock locking unlocking (spell) locked opening
    door/doors/lock/locks';
tSleepSpell: Topic '(causing) (cause) (produce) (producing) putting (someone)
    (to) inducing sleeping (spell) sleep/sleepiness/drowsiness/slumber';
tSwerveSpell: Topic
    '(causing) (cause) (make) (making) deflecting (to) wheeled vehicles swerve';
tRoots: Topic 'root-bound roots/rootedness';
tKeys: Topic 'key/keys';
tWater: Topic 'fresh (rain) water';
tGardening: Topic 'gardens/gardening';
tWigsPlural: Topic 'wigs';
tMusic: Topic 'music/score/ocarina';
tGarments: Topic 'wearing garments';
tNativeSoil: Topic 'native soil';
tJimAikin: Topic 'jim aikin/aiken';
tEricEve: Topic 'eric eve';
tWarts: Topic 'warts';
tAstrology: Topic 'polynesian astrology';
tLovePotion: Topic 'love potion/potions';

// Notes for management of the bulk and bulkCapacity of portable objects and containers:
//    me (bulk 50, bC 1000, msB 1000)
//
//    Upstairs:
//    pot (bulk 210, bC 30, mSB 30)
//    pamphlet (bulk 8)
//    dressing table drawer (bulkCapacity 30, maxSingleBulk 30)
//    dressing table (bC60, mSB 60)
//    bed (bc200, mSB 200)
//    wigs (bulk 12 each)
//    ocarina (bulk 7)
//    basin (bC 40, mSB 40)
//    bathtub (bC 250, mSB 250)
//
//    Downstairs:
//    mantel (bC 35, mSB 35)
//    framed photo (bulk 15)
//    fireplace (bC 50, mSB 50)
//    book (bulk 11)
//    piece of paper (bulk 2)
//    remote (bulk 7)
//    battery (bulk 3)
//    couch (bC 100, mSB 100)
//    coffee table (80, 80)
//    kitchen drawer (bulkCapacity 35, maxSingleBulk 35)
//    kitchen table (bC 90, mSB 90)
//    sink (bC 50, mSB 50)
//    refrigerator (bulkCapacity 50, maxSingleBulk 50)
//    stove (bulkCapacity 50, maxSingleBulk 50)
//    flashlight (bulk 7)
//    butter knife (bulk 7)
//    cupboard (bC 40, mSB 40)
//    chipped glass (bulk 15)
//    keys (bulk 4)
//    wheelchair (bulk 200, bC 60, mSB 60)
//    shelf (bC 50, mSB 50)
//    jar (bulk 20, bC 10, mSB 10)
//    brooch (bulk 5)
//    oven -- top and interior: bC 50, mSB 50

//    Outdoors:
//    rake (bulk 75)
//    bamboo stick (bulk 55)
//    skateboard (bulk 35, bulkCapacity 220, maxSingleBulk 220) -- just big enough for the pot.
//    trashCan (bulk 300, bulkCapacity 150, maxSingleBulk 150)
//    trash can lid (bulk 60)
//    old car (200, 200)
//    holes in back yard (bC 50, mSB 50)
//    screwdriver (bulk 7)
//    toolbox (bulk 50, 40, 40)
//    workbench (500, 200)
//    flyer (bulk 2)
//    orange (bulk 6)
//    birdbath (60, 60)
//    crawlspace (200, 200) -- slightly too small for the pot.
//    holes

    
    
