! Custom routines. These are routines that can be provided by the programmer to do certain
! things. Unless you have a VERY good reason, NEVER allow a routine that replaces a stubbed one
! to contain nothing. It MUST contain a rfalse!

! AfterLife
! Allows the player to be given a second chance before death.
! Only called if deadflag is not 0 (normal) or 2 (winning).
! i.e. 1 (death) or 3 and above (exotic death).
[ AfterLife;
 rfalse;
];

! AfterPrompt
! Just after the prompt is displayed.
! Whereas GamePostRoutine is like a super-after rule, AfterPrompt should be used for system
! manipulation (as opposed to game manipulation).
[ AfterPrompt;
 rfalse;
];

! Amusing
! Providing the AMUSING_PROVIDED default is set to 0, shows amusing things to do.
! So long as you die (method 2, i.e. winning).
[ Amusing;
 rfalse;
];

! BeforeParsing
! Just before the prompt is displayed.
! Whereas GamePreRoutine is like a super-before rule, BeforeParsing should be used for system
! manipulation (as opposed to game manipulation).
[ BeforeParsing;
 rfalse;
];

! DarkToDark
! To quote Graham Nelson:
! "Called when a player goes from one dark room into another one; a splendid excuse to kill the
!  player off."
[ DarkToDark;
 rfalse;
];

! DeathMessage
! What to do in the likely event of death.
! Use of deadflag (the variable which controls your death):
! 0 - Normal (playing).
! 1 - Dead (standard message).
! 2 - Won (standard message).
! 3 and above - Custom messages.
! Setting this variable to any non-zero value will end the game.
! Despite the name, 'deadflag' can (and must) also refer to winning and losing.
[ DeathMessage;
 switch (deadflag)
 {
  4: print "[Roll credits]";	! As do most programs when they end.
  default: ;			! Do nothing.
 }
 rfalse;
];

! GamePostRoutine
! Allows you to do things after the player has done something.
[ GamePostRoutine;
 rfalse;
];

! GamePreRoutine
! Allows you to do things before the player can do anything.
[ GamePreRoutine;
 rfalse;
];

! TimePasses
! What happens with the passing of time. This is called after every turn.
[ TimePasses;
 rfalse;
];

! PrintRank
! Displays a rank based on your current score.
[ PrintRank;
 print ". ";	! As typing 'score' both displays your score and rank.
 switch (score)
 {
  default: ;	! Do nothing by default.
 }
 NewLine (1);	! As typing 'score' both displays your score and rank.
 rfalse;
];

! PressAKey
! Waits for a key to be pressed.
[ PressAKey pkey;
 if (pkey~=0)	! Option to display a prompt.
 {
  NewLine (1);
  print "[Please press a key to continue]";
 }
 @read_char 1 0 0 pkey;
 return pkey;	! So PressAKey can have many uses.
];

! NewLine
! Prints 'NewLines' number of new_lines.
[ NewLine NewLines Count;
 for (Count=0: Count<NewLines: Count++)
 {
  new_line;
 }
 rfalse;
];

! clrscr
! Clears the screen.
[ clrscr;
 @erase_window $ffff;
 rfalse;
];

! What the Quip function does is to see if it has been called before with the same text. If so,
! it increments the appropriate member of the 'QuipsNumber' array. If not, it increases
! 'NoQuipsSeen' by 1, and stores the address of the text in the 'QuipsText' array, and puts 0
! in the corresponding place in the 'QuipsNumber' array.
! The robot names are printed with the proportional font turned off, so that the hanging indent
! will line up, and the function 'HangingIndent' is called to do that actual printing.
[ Quip
  n		! the number of times the quip should be ignored before printing
  ns		! the number of newlines at the start of the quip
  Character	! the character who says the quip
  text		! the packed address of the text of the quip
  ne		! the number of newlines at the end of the quip
  i		! the quip's index in the 'QuipsText' and 'QuipsNumber' arrays
  ;

 style roman;	! Just in case.
 ! If 'n' is -1, don't bother to store the quip because it can't possibly be seen twice.

 if (n == -1) jump QuipPrint;

 ! Have we seen this quip before? If so, increment the count of times seen, taking care not to
 ! overflow.

 for (i = 0: i < NoQuipsSeen: i++)
 {
  if (text == QuipsText-->i)
  {
   if (QuipsNumber->i < 255)
   {
    QuipsNumber->i = QuipsNumber->i + 1;
   }
   jump QuipFound;
  }
 }

 ! If we haven't seen it before, add it to the array

 if (NoQuipsSeen >= NUMBER_QUIPS)
 {
  "** Error: out of quip space **";
 }
 i = NoQuipsSeen;
 NoQuipsSeen ++;
 QuipsText-->i = text;
 QuipsNumber->i = 0;

 ! We only print the quip if the number of times it's been seen before matches the parameter
 ! 'n'.

 .QuipFound;
 if (QuipsNumber->i ~= n)
 {
  rfalse;
 }

 ! Now print it

 .QuipPrint;
 for (i = 0: i < ns: i++)
 {
  new_line;
 }
 font off;
 print (string)BotName-->(Character-1);
 font on;
 HangingIndent (text, BotLength->(Character-1));
 for (i = 0: i < ne: i++)
 {
  new_line;
 }
 style roman;
];

! Printing text with a hanging indent: Quip text is printed to an array in memory rather than
! to the screen (using the 'output_stream' opcode). Then for each line, a breakpoint is
! determined that prevents a word being split over the line. Then print the appropriate portion
! of the array (using the 'print_table' opcode), print the indent, and go back for another
! line. The indent is printed with the proportional font turned off.

Constant MAX_STRING_LENGTH 1000;	! maximum length of any quip in the game
Array sb -> MAX_STRING_LENGTH;		! buffer to hold the printed string

[ HangingIndent
  text		! packed address of text to print
  overlap	! extent to which first line sticks out over the 6-char indent
  len		! length of text in characters
  from		! first character not printed
  width		! width of screen in characters, less six character indent
  bp		! break point in string
  start		! where to start printing from
  n		! number of characters to print
  flag		! 0 if this is the first line being printed (so omit indent)
  ;

 ! String manipulation. The string starts out in encoded form, so it is first decoded to the
 ! string buffer:

 @output_stream 3 sb;
 print (string) text;
 @output_stream -3;

 ! Set up parameters (recall that the first two bytes of the array 'sb' hold the length).

 width = 0->33 - 6;
 len = sb-->0 + 2;
 from = 2;
 if (len > MAX_STRING_LENGTH)
 {
  "** Error: string was too long **";
 }

 while (from < len)
 {
  if (flag == 0)
  {
   flag = 1;
   bp = from + width - overlap;
  } else
  {
   font off;
   new_line;
   spaces 6 + overlap;
   font on;
   bp = from + width;
  }

  ! See if it can print the rest of the text on one line.

  if (bp >= len)
  {
   bp = len;
   jump FoundBreakPoint;
  }

  ! Find the best breakpoint, if any.

  for (: bp >= from: bp--)
  {
   if (sb->bp == ' ')
   {
    jump FoundBreakPoint;
   }
  }

  ! No breakpoint found, so split in the middle of the word.

  bp = from + width;

  ! Print the text from 'from' to the breakpoint.

  .FoundBreakPoint;
  start = sb + from;

  n = bp - from;
  @print_table start n 1;

  ! Skip any whitespace.

  from = bp;
  while (sb->from == ' ')
  {
   from ++;
  }
 }
];

! SoL
! To display SoL text.
[ SoL;
 print (NewLine)1, (FormatText)"[SATELLITE OF LOVE]", (NewLine)1;
 rfalse;
];

! Deep13
! As above, but for Deep 13.
[ Deep13;
 print (NewLine)1, (FormatText)"[DEEP 13]", (NewLine)1;
];

! FormatText
! Syntax: FormatText (string);
! To quote Allen Garvin, the author of this routine:
! "I added the printf from the designer's manual, but didn't find it very useful, so I changed
! it into this :)"
! Note that this routine uses the global table 'printed_text'.
! You may need to increase $MAX_STATIC_DATA should you make this table larger.
[ FormatText format j k;
 @output_stream 3 printed_text;	! Most cunning. Re-route textual output to this array.
 print (string) format;		! Just print it out (to an array and not the screen).
 @output_stream -3;		! And resume normal service.
 j = printed_text-->0;		! Determine (less 2) the string length.
 for (k=2: k<j+2: k++)		! Then get to work.
 {
  if (printed_text->k == '%')	! A '%' symbol is used to control formatting.
  {
   switch (printed_text-> (++k))
   {
    '%': print "%";		! To get a % mark, use '%%'.
    ' ': spaces 1;		! To get a single space, '% '. Not sure why this may be of use.
    'B': style bold;		! i.e. use the sequence '%B' for bold text.
    'F': style fixed;		! i.e. use the sequence '%F' for fixed-point text.
    'P': style roman;		! i.e. use the sequence '%P' to return to normal.
    'R': style reverse;		! i.e. use the sequence '%R' for reverse-video text.
    'U': style underline;	! i.e. use the sequence '%U' for underlined text.
   }
  } else			! Just print the character out.
  {
   print (char) printed_text->k;
  }
 }
];

! MST3KLogo
! Displays the logo.
[ MST3KLogo;
 Center ("_________^", 1);
 Center ("/           @@92^", 1);
 Center ("/     Mystery   @@92^", 1);
 Center ("|      Science    |^", 1);
 Center ("|      Theater    |^", 1);
 Center ("@@92      3000     /^", 1);
 Center (" @@92___________/^^", 1);
 rfalse;
];

! PushTheButtonFrank
! Simulates the effect of Frank pushing the button.
[ PushTheButtonFrank h i w;
 @read_char 1 i;
 clrscr ();
 font off;
 h = (0->32 - 3) / 2;
 w = (0->33 - 5) / 2;
 for (i = 0 : i < h - 1 : i++)
 {
  new_line;
 }
 spaces w; print "@@92 | /^";
 spaces w; print "--o--^";
 spaces w; print "/ | @@92";
 new_line;
 font on;
 @read_char 1 i;
 clrscr ();
 NewLine (2);
];

! Introduction
! Displays the introductory text (the MST3K love theme and, optionally, the rest).
[ Introduction;
 style bold; Center ("MYSTERY SCIENCE THEATRE 3000, Adventure 101, Reel 1.", 1); style roman;
 NewLine (2);
 print "In a not too distant future, way down in Deep 13, Dr. Forrester and TV's Frank were hatching an evil scheme. They hired a temp by the name of Mike, just a regular Joe they didn't like. Their experiment needed a good test case, so they bonked him on the noggin and they shot him into space.";
 NewLine (2);
 print "~We'll send him cheesy movies, the worst we can find.~ (La la la)^~He'll have to sit and watch them all, and we'll monitor his mind.~ (La la la)^Now keep in mind Mike can't control when the movies begin or end. (La la la)^He'll try to keep his sanity with the help of his robot friends.^^Robot Roll Call:^";
 print (FormatText)"%FCAMBOT:%P Show yourself.";
 NewLine (1);
 Quip (-1, 0, Gypsy, "I'm not ready.", 1);
 Quip (-1, 0, Tom, "Hello there.", 1);
 print (FormatText)"%FCROOOOW:%P That's one ~o~.";
 NewLine (2);
 print "If you're wondering how he eats and breathes, and other science facts... (La la la)^Then repeat to yourself ~it's just a show, I should really just relax, for Mystery Science Theatre 3000.~";
 NewLine (1);
 PressAKey (1);
 clrscr ();
 print "See rest of introduction? (Y/N) ";
 if (PressAKey (0)=='N' or 'n' or 27)	! No.
 {
  clrscr ();	! Clear the screen up.
  rfalse;	! Then return.
 }
 ! Everything from here on down is only displayed if the player wants to see it.
 clrscr ();
 MST3KLogo ();
 print (NewLine)1, "1... 2... 3... 4... 5... 6... G...", (NewLine)1;
 SoL ();
 print (NewLine)1, "[Crow, Gypsy, and Tom Servo are each seated in front of a computer. Mike appears in front of them]", (NewLine)1;
 Quip (-1, 1, Mike, "[to Cambot] Oh, hi everyone, and welcome to the Satellite of Love. I'm Mike Nelson. My robots Crow, Tom Servo, and Gypsy recently got ahold of an Interactive Fiction programming language called Inform, and they're just about to unveil their very first text adventures. Let's take a look.", 1);
 Quip (-1, 1, Crow, "[Excited] Oh! Oh! Me first! Me first! Oh, oh, oh! Me, me, me!", 1);
 Quip (-1, 1, Mike, "Would you like to go first, Crow?", 1);
 Quip (-1, 1, Crow, "[A bit reluctantly] Ummm... well, I guess so.", 1);
 Quip (-1, 1, Mike, "Okay, let's see what you've got. [Reads] ~The roar of rotating blades thunders in your ears as the chopper descends into the thick undergrowth of the jungle below. Fearlessly, you strap on a belt laced with grenades and sling your M-16 over your shoulder, the urge to kill quickening your pulse until you feel positively invincible. The chopper swings into a landing, and you leap out, determined to rescue the POWs and prove yourself a hero to the proud nation in which you were born and raised.~ Wow, this is really exciting, Crow. Great introduction.", 1);
 Quip (-1, 1, Crow, "Umm, it's not done yet, Mike.", 1);
 Quip (-1, 1, Mike, "Oh, there's more? [Taps the <Enter> key, then continues reading] ~A squadron of armed enemy troops, dressed in camouflauge, leap out of the surrounding undergrowth. You fire round upon round at them, lacing each body with a string of bullets that shatters bones and sprays the nearby foliage a bright crimson. When the last one drops dead at your feet, you race through the jungle to a village of grass huts, plastering any who dare stand in your way. The earth is stained red with the blood of the enemy!~", 1);
 Quip (-1, 1, Crow, "[Interrupting] This is my favourite part, right here!", 1);
 Quip (-1, 1, Mike, "[Continues reading] ~Emerging into the village, you dodge gunfire while lobbing grenades at enemy soldiers! Explosions rock the land! Bullets and bodies fly everywhere! The carnage continues for hours. Then, suddenly, a profound silence. You race into the center of the POW camp and smash open the front gates. You lead the prisoners back to the clearing, where the chopper is waiting. You fly back to the states and are awarded the Medal of Honour for your heroism! Congratulations!~", 1);
 Quip (-1, 1, Crow, "[Pleased] Well? Whadya think?", 1);
 Quip (-1, 1, Mike, "Umm, Crow? Don't you think this game could use a few puzzles?", 1);
 Quip (-1, 1, Crow, "[A little embarassed] Oh yeah, heh heh. I guess I sort of got carried away there. I was watching ~Rambo~ earlier, and one thing led to another...", 1);
 print (NewLine)1, "[The commercial sign light flashes]", (NewLine)1;
 Quip (-1, 1, Mike, "We'll be right back.", 1);
 print (NewLine)1, "[It's once again time for the wacky exploits of Mentos, the Freshmaker!]", (NewLine)1;
 print (NewLine)1, "[After the commercials, show Mike and the bots, as before]", (NewLine)1;
 Quip (-1, 1, Mike, "Well, I thought it was a good first try, Crow.", 1);
 Quip (-1, 1, Crow, "Really? You really liked it, Mike?", 1);
 Quip (-1, 1, Mike, "Of course I did. Now let's see what Gypsy's been up to. [Reads Gypsy's screen] ~Richard Basehart Adventure, by Gypsy.~", 1);
 Quip (-1, 1, Gypsy, "Yaaaaay! Richard Basehart! Richard Basehart!", 1);
 Quip (-1, 1, Mike, "[Calms Gypsy down, then continues reading] ~You are standing in Richard Basehart's house. Richard Basehart is here.~ Okay, let's see... [Types] ~EXAMINE RICHARD BASEHART.~ [Reads] ~You see nothing special.~. Well, let's try... [Types] ~TALK TO RICHARD BASEHART.~ [Reads] ~Nothing happens.~ Hmmm. Would you mind giving me a clue here, Gypsy?", 1);
 Quip (-1, 1, Gypsy, "~KISS RICHARD BASEHART?~", 1);
 Quip (-1, 1, Mike, "[Types] Okay, ~KISS RICHARD BASEHART.~ [Reads] It says, ~You win.~", 1);
 Quip (-1, 1, Gypsy, "Yaaaaaay! Richard Basehart! Richard Basehart! Yaaaaaaay!", 1);
 Quip (-1, 1, Crow, "That's IT? Geez, not very good.", 1);
 print (NewLine)1, "[Gypsy starts crying. Mike tries to comfort her]", (NewLine)1;
 Quip (-1, 1, Tom, "Oh, you're really one to talk, Crow. At least she included some actual interactivity in hers!", 1);
 Quip (-1, 1, Crow, "Ahh, bite me, Servo!", 1);
 print (NewLine)1, "[The two bots start fighting, but Mike breaks it up]", (NewLine)1;
 Quip (-1, 1, Mike, "Cut it out, guys. We still haven't seen Tom's game yet.", 1);
 print (NewLine)1, "[Crow peers at Tom's computer, then laughs]", (NewLine)1;
 Quip (-1, 1, Crow, "Check this out, Mike! His screen's completely blank! He hasn't typed a thing! [Snickers to himself]", 1);
 Quip (-1, 1, Tom, "I can't help it! My arms don't work!", 1);
 Quip (-1, 1, Crow, "Loser.", 1);
 Quip (-1, 1, Tom, "[On the verge of tears] Shut up, just SHUT UP!", 1);
 print (NewLine)1, "[They start fighting again. Gypsy continues crying for Richard Basehart. The mads' light begins flashing]", (NewLine)1;
 Quip (-1, 1, Mike, "Uh-oh, cool it, guys. Looks like Duncanthrax and Dimwit Flathead are calling.", 1);
 Deep13 ();
 print (NewLine)1, "[Dr. Forrester and TV's Frank are standing in the foreground]", (NewLine)1;
 Quip (-1, 1, Forrester, "Ah, greetings, ~Aunt Jemima.~ I see you and your little friends have discovered the joys of Interactive Fiction. Guess I have no choice but to reveal to you the darker side of it with this week's experiment! But first, the Invention Exchange. Frank?", 1);
 print (NewLine)1, "[Frank pushes a cart with a computer, electronic helmet, and another strange device into the foreground]", (NewLine)1;
 Quip (-1, 1, Frank, "Thanks, Steve. Well, Mike, as you know, one of the biggest frustrations with text adventures is the terminology. Let's face it, sometimes you just can't guess what words the author wants you to use when you type your commands.", 1);
 Quip (-1, 1, Forrester, "That's why we've come up with this little device I like to call the ~Fictionary.~ Basically, it's a translator that feeds the recognised vocabulary of an adventure game directly into your brain. That way, you always know which words will work and which ones won't.", 1);
 Quip (-1, 1, Frank, "See, how it works is, one end of the Fictionary [Indicates the strange device] has a coax cable running into this cyber-helmet you wear over your head. [Puts the helmet on] The other end is wired to the hard drive and motherboard of this computer, and it interprets the game file and sends the processed vocabulary directly into your mind.", 1);
 Quip (-1, 1, Forrester, "[To Mike] It's really quite technical, booby, so don't strain your little mind trying to comprehend it.", 1);
 Quip (-1, 1, Frank, "Here, check it out.", 1);
 print (NewLine)1, "[Frank switches the machine on, then just stands there]", (NewLine)1;
 Quip (-1, 1, Forrester, "Frank?", 1);
 Quip (-1, 1, Frank, "Sorry, but I don't know the word 'Frank.'", 1);
 Quip (-1, 1, Forrester, "[A little alarmed] Frank, what's happening?", 1);
 Quip (-1, 1, Frank, "Sorry, but I don't know the word 'happening.'", 1);
 Quip (-1, 1, Forrester, "What the...? [Opens the computer case and looks inside] Frank, you numbskull, you wired it all wrong! [Explanatory, to Mike and bots] It's sending the parser itself into his brain. Right now, Frank thinks he's a ZIP interpreter.", 1);
 Quip (-1, 1, Frank, "I don't understand. Please try rephrasing that.", 1);
 Quip (-1, 1, Forrester, "[A little embarrassed] As you can see, we still haven't gotten all the bugs worked out...", 1);
 Quip (-1, 1, Frank, "I can't go that way.", 1);
 print (NewLine)1, "[Dr. Forrester sighs, and switches the machine off. Frank shakes his head and looks around, disoriented]", (NewLine)1;
 SoL ();
 Quip (-1, 1, Tom, "Wow. Now THAT'S weird.", 1);
 print (NewLine)1, "[Mike has brought one of the bots' computers into the foreground, and there is a device with two robotic arms connected to the terminal]", (NewLine)1;
 Quip (-1, 1, Mike, "Well, Dr. F, here's our invention. Basically, we've come up with a fun new method of measuring force between two objects in contact with each other.", 1);
 Quip (-1, 1, Crow, "See, you take two objects, such as this box of Wild Rebels cereal and Joey the Lemur, load one into each of these arms here... [Mike does so] ...and run a simple computer program.", 1);
 print (NewLine)1, "[Mike types on the terminal. The two arms begin moving back and forth, rubbing the two objects against each other. A piece of paper slides out of a printer attached to the computer]", (NewLine)1;
 Quip (-1, 1, Mike, "As you can see, it analyzes the forces at work and presents you with a whole sheet of raw data based on its observations. We call it ~Interactive Friction!~", 1);
 Quip (-1, 1, Crow, "And the computer program is a ~SLIP Interpreter!~", 1);
 Quip (-1, 1, Tom, "What do you think, Sirs?", 1);
 Deep13 ();
 Quip (-1, 1, Frank, "~Interactive Friction?~ I don't get it.", 1);
 Quip (-1, 1, Forrester, "[Dismissively] Oh, never mind, Frank. They're just toying with you. [Turns back to face Mike and the bots] Well, ~Michael Berlyn,~ your experiment today is a little piece of Interactive Tripe with an astoundingly infantile storyline and no puzzles to speak of.", 1);
 SoL ();
 Quip (-1, 1, Tom, "[Sarcastially, to Crow] Now why does that sound familiar?", 1);
 Quip (-1, 1, Crow, "Don't make me hurt you, Servo.", 1);
 Deep13 ();
 Quip (-1, 1, Forrester, "[Continuing] It's a hard-boiled little program called ~Detective,~ and it will make you wish you'd never heard of text adventures. And so, as the Implementors say, ~Feel Free~ -- to DIE! [Laughs evilly] Frank, send them the game.", 1);
 print (NewLine)1, "[While Dr. Forrester has been talking, Frank has slipped the Fictionary helmet onto his head again]", (NewLine)1;
 Quip (-1, 1, Frank, "Sorry, but I don't know the word 'game.'", 1);
 Quip (-1, 1, Forrester, "[Sighs] Frank, do you really want me to kill you a third time today?", 1);
 Quip (-1, 1, Frank, "Sorry, but I don't know the word 'today'.", 1);
 Quip (-1, 1, Forrester, "Do you know the word 'PAIN,' Frank? Endless, intense, excruciating PAIN? Now take that thing off and push the button!", 1);
 Quip (-1, 1, Frank, "[Looks around] Sorry, but I can't see any 'button' here.", 1);
 Quip (-1, 1, Forrester, "[Exasperated] Oh, for the love of God... [He pushes the button himself]", 1);
 SoL ();
 Quip (-1, 1, Mike, "Oh, we've got MOVIE SIGN! [General chaos ensues]", 1);
 PressAKey (1);
 clrscr ();
 rfalse;
];

! EndGame
! Displays the end game text.
[ End;
 clrscr ();	! Clear the screen.
 print (NewLine)1, "[Mike and the bots leave the theatre]", (NewLine)1;
 print "1... 2... 3... 4... 5... 6... G...", (NewLine)1;
 SoL ();
 print (NewLine)1, "[Mike and the bots are in their usual places]", (NewLine)1;
 Quip (-1, 1, Mike, "Well, when you come right down to it, I thought the writing was one of the strong points of this game.", 1);
 Quip (-1, 1, Tom, "Oh, for me it was the intense and addictive gameplay that just left you begging for more.", 1);
 Quip (-1, 1, Crow, "You guys are CRAZY, you know that? Just plain no-holds-barred out-of-your-minds seats-of-honor-at-the-local-funny-farm-convention CRAZY! This game was terrible! It was torture! I mean, LOOK AT IT! You get sent to investigate the mayor's murder, but you never see his body or even learn his name, and his house is scattered with weird useless items preceded by stupid adjectives, including a knife that's there but you CAN'T PICK IT UP! Then you go through about a million hallways that never lead anywhere, closets that", 1);
 Quip (-1, 0, Crow, "TELEPORT YOU AROUND LIKE THE STARCROSS DISKS, AND IN HALF THE ROOMS YOU GET KILLED SIMPLY BY ENTERING THEM, AND WITH ONE OF THEM YOU LEARN EVERYTHING THERE IS TO KNOW ABOUT THE KILLER SIMPLY BY ENTERING IT, AND THEN YOU RUN THROUGH A MILLION MORE STUPID HALLWAYS AND YOU CATCH THE KILLER AND THAT'S THE END! BUT YOU ONLY CATCH ONE KILLER, AND THERE'S A NOTE IN THE MAYOR'S HOUSE THAT SAYS THEY'RE A GROUP OF VIGILANTES AND THEN MATT BARRINGER TELLS US TO LOOK IT UP WHEN IT'S PAINFULLY OBVIOUS THAT HE HAS AN EVEN SMALLER VOCABULARY THAN THIS GAME! AND THEN THERE'S THE SCENE IN THE CELLS WHERE YOU JUST ASK EVERYONE IF THEY KNOW ANYTHING! AND THE MUSIC STORE! WHAT THE HELL WAS THE POINT OF KILLING THE GUY IN THE MUSIC STORE? NOTHING MADE ANY SENSE, I TELL YOU! AND WHEN IT'S ALL OVER, YOU DON'T EVEN KNOW WHY OR HOW THE KILLER DID IT!", 1);
 print (NewLine)1, "[Crow continues babbling incoherently]", (NewLine)1;
 Quip (-1, 1, Tom, "Wow, sounds like he's taking this pretty hard.", 1);
 Quip (-1, 1, Mike, "Well, I know what will cheer him up. [Goes over to Gypsy at one of the computers] Gypsy's been working on another game while we've been in the theatre.", 1);
 Quip (-1, 1, Gypsy, "Yaaaay! ~Richard Basehart Adventure II!~ Yaaaaaaay!", 1);
 Quip (-1, 1, Mike, "C'mon, check it out, Crow!", 1);
 Quip (-1, 1, Crow, "NO! YOU KEEP THAT THING AWAY FROM ME! I'M NEVER TOUCHING ANOTHER TEXT ADVENTURE AGAIN -- NEVER, EVER, EVER, AS LONG AS I LIVE, AND YOU CAN'T MAKE ME!", 1);
 print (NewLine)1, "[Crow storms off the set]", (NewLine)1;
 Quip (-1, 1, Mike, "Gee, sounds like Crow's a little upset.", 1);
 print (NewLine)1, "[The mads' light flashes]", (NewLine)1;
 Quip (-1, 1, Mike, "Well, I hope you're happy, Dr. F, now that you've alienated him from Interactive Fiction forever.", 1);
 Quip (-1, 1, Tom, "Yeah, how 'bout a little more science and less mystery next time, huh?", 1);
 Deep13 ();
 Quip (-1, 1, Forrester, "Ah, very cute, my little brass lantern. But do you really think you can quit Interactive Fiction that easily? Your little friend will come back to it, Nelson, and then I'll send him another game like this. And another! And ANOTHER! [Laughs evilly] Push the button, Frank. [Pause] Frank?", 1);
 print (NewLine)1, "[Dr. Forrester looks around, and sees that Frank has once again donned the Fictionary helmet]", (NewLine)1;
 Quip (-1, 1, Frank, "[Looks around] Sorry, but I can't see any 'button' here.", 1);
 Quip (-1, 1, Forrester, "Oh, will you just drop it, Frank?", 1);
 Quip (-1, 1, Frank, "I'm not carrying that.", 1);
 Quip (-1, 1, Forrester, "[Sighs with exasperation, then picks up a game manual and glances at it] Okay, let's see now... Ah, here it is! The special magic word that'll make Frank push the button. ~XYZZY.~", 1);
 print (NewLine)1, "[Frank hears Dr. F say it, and pushes the button. The screen goes dark]", (NewLine)1;
 PushTheButtonFrank ();
 Quip (-1, 1, Frank, "[voice] It is now pitch black. You are likely to be eaten by a Grue.", 1);
 Quip (-1, 1, Forrester, "[voice] I'll get you for this, Frank. I swear it.", 1);
 NewLine (1);
 print (FormatText)"%F%RSTINGER:%P";
 print (FormatText)"%F%B ~I'm supposed to get 20 years but I'll be out in 2. You can't make me talk cuz it don't matter to me.~%P";
 NewLine (1);
 deadflag=4;	! You have won the game.
 rfalse;
];