#ifdef RCSID
static char RCSid[] =
"$Header: d:/cvsroot/tads/GAMES/plant/plant.t,v 1.2 1999/05/17 02:52:11 MJRoberts Exp $";
#endif

/* Copyright (c) 1998 by Michael J. Roberts.  All Rights Reserved. */
/*
Name
  plant.t - main file for The Plant
Function
  
Notes
  
Modified
  07/12/98 MJRoberts  - Creation
*/


/* include the adventure library */
#include <adv.t>

/* include the game information utilities */
#include <gameinfo.t>

/* include the attachable class */
#include "attach.t"

/* include the 'instructions' command */
#include "plantins.t"

/* Mr. Teeterwaller */
#include "plantmt.t"

/* standard definitions required by the system and the library */
#include "plantstd.t"

/* road locations */
#include "plantrd.t"

/* warehouse interior */
#include "plantwh.t"

/* plant interior, surface (above ground) */
#include "plantsur.t"

/* plant interior, underground */
#include "plantug.t"

/* special edition features */
#include "plantse.t"

/*
 *   Game information 
 */
getGameInfo: function
{
    return
        ['Name', 'The Plant',
         'Byline', 'by Michael J. Roberts',
         'AuthorEmail', 'Michael J. Roberts <mjr_@hotmail.com>',
         'Desc', 'You\'re on a business trip with your boss, driving
             down a deserted highway in the middle of nowhere, when the
             car breaks down. You set off on foot seeking help, but you
             soon find yourself in the middle of a shocking conspiracy
             in a dangerous industrial complex. Can you penetrate the
             decades-old cover-up and reveal the secrets that might
             forever change the world?
             \\nThe Plant is a thrilling interactive mystery that
             won third place in the 1998 Annual IF Competition.  This
             Special Edition features extensive author\'s notes,
             including thoughts about the game design process.',
         'Version', version.vsnnum,
         'Genre','Science Fiction',
         'Forgiveness','Merciful',
         'FirstPublished', '1998-09-30',
         'ReleaseDate', '1999-05-09',
         'Language', 'en-US',
         'LicenseType', 'Freeware',
         'CopyingRules', 'Nominal Cost Only',
         'PresentationProfile', 'Default',
         
         /* 
          *   note - we have two IFIDs because we had two public releases
          *   before the IFID system was introduced, hence two generated
          *   hash-based IFIDs for files in circulation 
          */
         'IFID', 'TADS2-0604401F269363BE743FE9F1C241D3BF,TADS2-A94AFB10D704EF53BA57E9DE95B49422'
        ];
}
