Include "Grammar";

Verb      "break"       * noun                         -> Break
                        * noun "with" held             -> BreakWith;
Verb      'connect'     * noun 'to' noun               -> Tie;
Verb      'crush'       * held                         -> Crush;
Extend    "cut"         * "through" noun               -> Cut
                        * "through" noun "with" held   -> CutWith
                        * noun "with" held             -> CutWith;
Verb      "diagnose"    *                              -> Diagnose;
Extend    "examine"     * noun "in" noun               -> ExamineIn;
Extend    'exit'        * noun                         -> Exit;
Verb      'glue' 'stick'* noun                         -> Glue
                        * noun "together"              -> Glue
                        * noun "to" noun               -> Glue;        
Verb      "hello"       *                              -> Hello;
Verb meta "help" "info" 'h//' 'credits' *              -> Help;
Verb meta "hint" "hints" *                             -> Hint;
Extend    "jump"        * 'on' noun                    -> Enter
                        * 'off' noun                   -> GetOff;
Extend    "jump" first  * 'off'                        -> Exit;
Verb      "kick"        * noun                         -> Kick;
Extend    "kick"        * "yourself"                   -> KickYourself;
Verb      'krip'        *                              -> NewMild
                        * topic                        -> NewMild;
Extend    "look"        * noun                         -> Look_dir
                        * 'out' noun                   -> Search
                        * 'out' 'of' noun              -> Search;
Verb      'make' 'build'* 'ram'/'hydraulic'            -> MakeRam
                        * 'hydraulic' 'ram'            -> MakeRam
                        * 'the' 'ram'                  -> MakeRam
                        * 'the' 'hydraulic'            -> MakeRam
                        * 'the' 'hydraulic' 'ram'      -> MakeRam

                        * 'toy'/'space'/'rocket'       -> MakeRocket
                        * 'space' 'rocket'             -> MakeRocket
                        * 'toy' 'rocket'               -> MakeRocket
                        * 'space' 'toy'                -> MakeRocket
                        * 'rocket' 'toy'               -> MakeRocket
                        * 'toy' 'space' 'rocket'       -> MakeRocket
                        * 'space' 'toy' 'rocket'       -> MakeRocket
                        * 'space' 'rocket' 'toy'       -> MakeRocket
                        * 'rocket' 'space' 'toy'       -> MakeRocket
                        * 'spacerocket'                -> MakeRocket
                        * 'toy' 'spacerocket'          -> MakeRocket   
                        * 'spacerocket' 'toy'          -> MakeRocket  
                        * 'the' 'toy'                  -> MakeRocket
                        * 'the' 'space'                -> MakeRocket
                        * 'the' 'rocket'               -> MakeRocket
                        * 'the' 'space' 'rocket'       -> MakeRocket
                        * 'the' 'toy' 'rocket'         -> MakeRocket
                        * 'the' 'space' 'toy'          -> MakeRocket
                        * 'the' 'rocket' 'toy'         -> MakeRocket
                        * 'the' 'toy' 'space' 'rocket' -> MakeRocket
                        * 'the' 'space' 'toy' 'rocket' -> MakeRocket
                        * 'the' 'space' 'rocket' 'toy' -> MakeRocket
                        * 'the' 'rocket' 'space' 'toy' -> MakeRocket
                        * 'the' 'spacerocket'          -> MakeRocket
                        * 'the' 'toy' 'spacerocket'    -> MakeRocket   
                        * 'the' 'spacerocket' 'toy'    -> MakeRocket;

Verb      'megakrip'    *                              -> NewMild
                        * topic                        -> NewMild;
Verb      "play"        * noun                         -> Play
                        * "with" noun                  -> Play
                        * noun "with" creature         -> PlayWith;
Verb      "plug"        * "in" noun "in"/"into" noun   -> Plug
                        * noun "in"/"into" noun        -> Plug 
                        * multiexcept "in"/"into" noun -> Insert; 
Verb      'poke'        * creature                     -> WakeOther;
Extend    'put'         * 'hand'  'in'   noun          -> PutHandIn
                        * 'hand'  'into' noun          -> PutHandIn
                        * 'hands' 'in'   noun          -> PutHandIn
                        * 'hands' 'into' noun          -> PutHandIn;
Extend    "read" first  * legible                      -> Read;
Verb      "saw"         * noun                         -> Cut
                        * "through" noun               -> Cut
                        * "through" noun "with" held   -> CutWith
                        * noun "with" held             -> CutWith;
Verb      "scream"      *                              -> Scream;
Verb      'shake'       * noun                         -> Shake;
Extend    'shake'       * "hand"  "with" creature      -> ShakeHands
                        * "hands" "with" creature      -> ShakeHands;
Extend    "sit" first   *                              -> Sit
                        * "down"                       -> Sit;
Extend    "stand" first *                              -> Stand
                        * "up"                         -> Stand;
Verb      "tear"        * noun                         -> Tear;
Verb meta "time"        *                              -> Time;
Verb      'trot'        *                              -> NewMild
                        * topic                        -> NewMild;
Verb      "type"        * number                       -> Type
                        * number "on" noun             -> TypeOn reverse;
Verb      "unplug"      * noun                         -> Unplug 
                        * multiinside "from" noun      -> Remove;
Verb      "use"         * noun                         -> Use;
Verb      "xyzzy"       *                              -> Spell;

Extend 'bother' replace *                              -> NewMild
                        * topic                        -> NewMild;
Extend 'curses' replace *                              -> NewMild
                        * topic                        -> NewMild;
Extend 'drat'   replace *                              -> NewMild
                        * topic                        -> NewMild;
Extend 'darn'   replace *                              -> NewMild
                        * topic                        -> NewMild;

Extend 'shit'   replace *                              -> NewStrong
                        * topic                        -> NewStrong;
Extend 'fuck'   replace *                              -> NewStrong
                        * topic                        -> NewStrong;
Extend 'damn'   replace *                              -> NewStrong
                        * topic                        -> NewStrong;
Extend 'sod'    replace *                              -> NewStrong
                        * topic                        -> NewStrong;

Extend only "fix"    replace * noun                    -> Fix
                             * noun "to" noun          -> Tie;
Extend      "tie"    replace * noun "to" noun          -> Tie;
Extend      "attach" replace * noun "to" noun          -> Tie;
Extend      "fasten" replace * noun "to" noun          -> Tie;

[ BreakSub; "I wouldn't do that; you might need it later in the game."; ];

[ BreakWithSub; "I wouldn't do that; you might need it later in the game.";];

[ CrushSub; "That's not something you can crush."; ];

[ CutWithSub;
  if (second ~= Hacksaw) "You can't cut with that.";
  if (noun   ~= Bars)    "Cutting that up would achieve little.";
];

[ DiagnoseSub;
  switch (sick)
  {
    0: print "You are in perfect health.";
  }
  print "^";

  switch (sleepy)
  {
    0: print "You are well-rested.";
  }
  print "^";

  switch (hungry)
  {
    0: print "You are well-fed.";
    1: print "You are fairly hungry and thirsty.";
    2: print "You are very hungry and thirsty.";
    3: print "You are awesomely hungry and thirsty.";
    4: print "You are about to pass out from hunger.";
  }
  print "^";
];

[ ExamineInSub; "I only understand you as far as wanting to examine ", 
                (the) noun, "."; ];

[ FixSub; "[Such general commands won't work. To repair something, you 
            must perform the specific steps required.]"; ];

[ GlueSub; if (glue in player)
             "Nothing needs gluing at the moment.";
           else
             "You're not holding any glue.";
];

[ HelloSub; "You say Hello to your self, not unsurprisingly that doesn't help
             you solve the game."; ];

[ HintSub; "[No Hint System is available (a) because the game is very 
             simple, and (b) it takes away the fun of solving the problems 
             yourself.]"; ];

[ KickSub; if (noun == player) 
             "You only need to kick yourself after you look up all the 
              hints, and discover how easy the puzzles really were.";

           "That would achieve little, except damage ", (the) noun,
           ", and make you feel better."; ];

[ KickYourselfSub;
  "You only need to kick yourself, after you look up all the 
   hints, and discover how easy the puzzles really were."; ];

[ Look_dirSub; "You see nothing of interest."; ];

[ MakeRamSub; 
  if (Ram.state == made)
    "You've already made that!";
  if (Popular_Mechanics.state == read)
  {
    if (EmptyDiet in Player)
      "Now if you weren't such a greedy guts you could have made it.";
    if (CrushedCan in Player)
      "Hum, you get the feeling ", (the) CrushedCan," might have been 
       useful here. That is before you mangled it.";
    if ( (Hosing in Player) && (DietCola in Player) && (Wood in Player) && 
    (Glue in Player) && (Hacksaw in Player) && (Syringe in Player) )
    {
      if ( ((Steel1 in Player) && (Steel2 notin Player)) ||
           ((Steel2 in Player) && (Steel1 notin Player)) )
        "You're one bar short, of a jail house! As the saying goes.";
      if ((Steel1 in Player) && (Steel2 in Player))
      {
        achieved(6);
        move Ram to player;
        Ram.state = made;
        remove hosing;
        remove Steel1;
        remove Steel2;
        remove DietCola;
        remove Wood;
        remove Syringe;
        Glue.state = stuck;
        "You take all the bits and after a bit of sawing and gluing make ", 
         (a) Ram, ".";
      }
      "You're not holding everything you need."; 
    }
    "You're not holding everything you need."; 
  }
 "I don't know how to make that."; 
];

[ MakeRocketSub; if (Annual.state == read)
                   "You're not holding everything you need."; 
                 "I don't know how to make that."; 
];

[ PlaySub; "That isn't a game."; ];

[ PlayWithSub; "That isn't a game."; ];

[ PlugSub; "You can't plug that in there."; ];

[ PutHandInSub; "Putting your hand in take would achieve little."; ];

[ ReadSub; <<Examine noun>>; ];

[ ScreamSub; "Aarrrrggggggghhhhhhhh!"; ];

[ ShakeHandsSub; "You can only do that to something animate."; ];

[ ShakeSub; "That has no effect."; ];

[ SitSub; 
  if (parent(parent(player))) return L__M(##Enter, 1, parent(player)); 
  
  if (Couch in Location)
  {
    move Player to Couch; 
    "(on ", (the) Couch, ")^
     You get onto ", (the) Couch, ".";
  }

  if ( (Lounge_Chair in Location) || (Briefing_Room_Chair in Location)
    || (Waiting_Room_Chair in Location) )
  {
    switch (Location)
    {
      Lounge:        move Player to Lounge_Chair;
      Briefing_Room: move Player to Briefing_Room_Chair;
      Waiting_Room:  move Player to Waiting_Room_Chair;
    }    
    "(on the chair)^
     You get onto the chair.";
  }

  Spacetime = Spacetime + 24;
  "You recline on the floor for a bit, and then stand up again.";
];

[ SpellSub;
  score = score + 3;
  "You a hear voice from across a vast distance of time and space, ~That's
   Magic! Not a lot.~";
];

[ StandSub;
  if (Player in Couch)
  {
    move Player to Location; 
    if (lookmode==2)
      <<LOOK>>;
    else
      "You get off ", (the) Couch, ".^^", (object) Location;
  }

  if ((Player in Lounge_Chair) || (Player in Briefing_Room_Chair)
  || (Player in Waiting_Room_Chair)) 
  {
    move Player to Location;
    if (lookmode==2)
      <<LOOK>>;
    else
      "You get off the chair.^^", (object) Location;
  }

  "You are already standing, I think.";
];

[ TearSub; "You can't tear that."; ];

[ TimeSub; if (watch has worn)
             print "Adjusted Galactic Standard Time (adjusted to your local
                    day-cycle) is exactly ", spacetime , ".^"; 
           else
             "Current Galactic Standard Time is impossible to determine,
              since you've removed your chronometer.";
];

[ TypeOnSub; "That's not something you can type numbers on."; ];

[ TypeSub; if ( ((Computer in Desk) && (Player in Office)) 
           || (Computer in Location) || (Computer in Player) )
             <<TypeOn Kb noun>>;
           else
             "There's nothing to type on here."; ];

[ UnplugSub; "You can't unplug that."; ];

[ UseSub; "Be more specific."; ];

[ HelpSub; 
"This game is based on the example transcript included with Infocom's 
 Planetfall game, by Steve Meretzky. All Infocom games are now the property 
 of Activision. It understands the following commands:^^
 North, South, East, West, Fore, Aft, Starboard, Port, Up, Down, In, Out,
 Exit, Examine, Look, Look through, Diagnose, Time, Score, Wait, Shake, 
 Open, Cut, Close, Lock, Unlock, Take, Drop, Type, Push, Kick, Crush, Play,
 Sit, Stand, Read, Save, Restore, Restart, Quit, Brief, Superbrief, Verbose, 
 Version, Again, Oops, Eat, Drink, Use, Break, Put, Make,
 Give <OBJECT> to <ACTOR>,
 Tell <ACTOR> about <SUBJECT>,
 Plug <OBJECT1> in <OBJECT2>, 
 Show <OBJECT> to <ACTOR>,
 Unplug <OBJECT>, 
 Footnote <NUMBER>,
 Wait <NUMBER>,
 Wake <ACTOR>
 ...^^ 
 The game descriptions for this games use fore, aft, port, and starboard for 
 directions which can be abbreviated to f, a, p, sb. If you are not 
 comfortable using these directions you can still use respectively north, 
 south, west, east which can be abbreviated to n, s, w, e. Up and Down work 
 as usual. You can examine AND read books.^^
 Some of the commands have to be combined with objects,
 carried by the player, or found in rooms. The maximum score is ",
 MAX_SCORE, " at present.
 The puzzles aren't very complicated; just examine EVERYTHING, and you should
 be able to solve them. Good luck, and enjoy! And if you think Activision
 should resurrect Planetfall II, LET THEM KNOW.^^
 There may be some spelling mistakes in this game, but probably not as many
 as you think. The spelling is British English, which is not exactly the
 same as American English (which I assume many players use). That's my story
 and I'm sticking to it.^^
 When the program is run using WInfocom, the opening text may be a bit 
 garbled; just type RESTART.^^
 I would like to thank the following people for their help in this project:^
 David Dyte for organizing the 1998 Interactive Fiction Competition and 
 Technical Advice while I was learning Inform. Everyone on the 
 rec.arts.int-fiction newsgroup who gave me technical advice (too numerous to 
 mention).^
 Version 1 Beta Testers: Vincent Lynch, Mary K. Kuhner, Stephen Robert 
 Norris, Stuart Andrew Moore and Imran Ghory.^
 Version 2 Beta Testers: James Braun, Bronxelf (a former Infocom Tester who 
 worked with Steve Meretzky), Tom Lorimer, Jason F. Finx (a star grammer
 checker), Chad Schultz and Mark Silcox.^^
 You can Email the author at me@@64dledgard.freeserve.co.uk with error 
 reports, possible improvements etc...
"; ];

[ NewStrongSub; 
  "You're lucky none of your colleagues are around, if they heard you speak 
   that way, if would mean instant demotion.^~An officer of high rank has to 
   set an example to his/her subordinates.~^STELLAR PATROL REGULATIONS, 
   Paragraph 32, Subsection VII."; ];

[ NewMildSub; "Your not an Ensign any more, you should know better than to 
               use such trotting kripping language."; ];

!--------------------------------------------------------------------------
! To move a followable object, call MoveNPC(object, destination, 
! actiontomove, objectnumber). Pass 0 for actionnumber and objectnumber to
! disallow following.  Pass 0 for destination to remove object.
! 
! When the player attempts to follow the object, the action <actiontomove
! objectnumber> will be generated.
! 
! In this release, the player can also attempt to follow any followable
! object contained within the moving followable object. For example, if
! Louise drives off in a car, the player may 'Follow Louise' as well as
! 'Follow car'.
! 
! Examples: MoveNPC(bob, bobshouse, ##Go, n_obj);
!           MoveNPC(driver, car, ##Enter, car);
!
! classes, procs (newroom)
!--------------------------------------------------------------------------

[ FollowScope i;
if (scope_stage==1) rfalse;
if (scope_stage==2)
{ objectloop (i ofclass FollowClass)
{ PlaceInScope(i);
}
rtrue;
}
"Did you have any particular direction in mind.";
];

Verb "follow" "chase" "pursue" "trail"
    * scope=FollowScope -> Follow;

[ FollowSub oldnoun oldpos;
    if ( (Location==Hall_l) && 
    ((Bracelet in Fussbudget) || (Fussbudget in Store)) )
    {
      print "(go fore/north)^";
      <<GO FORE_OBJ>>;
    }
    if ( (parent(noun) == location or player)
    || ((Location==SickBay) && (Fussbudget in Cage))
    || ((Location==TeleportRoom) && (Fussbudget in TransporterPad)) )
      print_ret "But ", (the) noun, " is right here!";
    if (noun hasnt followable)
      "That's not something you can follow.";
    if (noun.follow_action == 0)
    {
      if (Sickbay hasnt visited)
        "You don't see anyone by that name here.";
      "You have no idea where ", (the) noun, " is.";
    }
    oldnoun = noun;
    oldpos = parent(player);
    <(noun.follow_action) noun.follow_object>;
    if (oldnoun notin parent(player) && parent(player) ~= oldpos)
      print "^(", (the) oldnoun, " doesn't seem to be here any more.)^";
    rtrue;
];

[ MoveNPC2 tomove actn objn i;
    if (tomove has followable) {
        tomove.follow_action= actn;
        tomove.follow_object= objn;
        objectloop(i in tomove) {
            MoveNPC2(i, actn, objn);
        }
    }
];
