#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>
#include <SquareCircle.h>

 /* receptionist.t
  *
  * This file defines the receptionist npc
  */
  
receptionist : Person 'young blonde ms woman/receptionist/phryjid' 'receptionist'
  @receptionArea
  "She's a neatly dressed young woman with blonde hair cut short in regulation rational style. "
  isHer = true
  globalParamName = 'receptionist'
  holdingDescInventoryLister = myActorHoldingDescInventoryListerLong
  praised = 0
  patience = 5

  checkMissingObjects
  {    
    if(canSee(gPlayerChar))
    {
       local okay = boxCheck(nil);
       checkLoot(okay);
    }
  }
   
  checkLoot(okay)
  {  
    local lootList = [], displacedList = [];
    
    foreach(local obj in forbiddenObjects)
    {
      if(obj.isIn(gPlayerChar) && canSee(obj))
        lootList += obj;
      else if(!obj.isIn(receptionDesk) && canSee(obj))
        displacedList += obj;
    }
       
    if(lootList != [])
    {
     "{The receptionist/she} glowers furiously at you and snatches back ";
     local listLen = lootList.length();
     for(local i=1; i<=listLen; i++)
     {
       local obj = lootList[i];
       "<<obj.theName>>";
       if(i == listLen)
         " from you, returning <<listLen > 1 ? 'them' : 'it'>> to
          <<listLen > 1 ? 'their' : 'its'>> proper place. ";
       else if(i == listLen - 1)
         " and ";
       else
         ", ";
     
       obj.moveInto(obj.properPlace);       
     }
     okay = nil;  
    }
    
    foreach(local obj in displacedList)
    {
      gMessageParams(obj);
      comment.doScript;
      "She picks up {the obj/him} and puts {it obj/him} back 
       <<obj.properPlace.ofKind(Surface) ? 'on' : 'in'>> <<obj.properPlace.theName>><.p>";
       obj.moveInto(obj.properPlace);
    }       
     
    if(!okay)
      lootWarning.doScript; 
  }
  
  
  
  comment : ShuffledEventList {
   [
     '<q>How did {that obj/he} get there?</q> she mutters. ',
     '<q>Did you move {that obj/him}?</q> she asks accusingly. ',
     '<q>Who\'s been messing around with this?</q> she frowns. ',
     '<q>Why can\'t people just leave things alone?</q> she complains. '
   ]
  }
  forbiddenObjects = [whiteEnvelope, brownEnvelope, wireBasket, document, telephone, papers]
  beforeAction()
  {
    if(gActionIs(Take) && forbiddenObjects.indexOf(gDobj) && curState != recepDistracted)
    { 
      switch(gDobj)
      { 
        case brownEnvelope: brownEnvelopeTake.doScript(); break;
        case whiteEnvelope: whiteEnvelopeTake.doScript(); break;        
        default: "<.p><q>Leave {that dobj/him} alone!</q> snaps {the receptionist/she},
          snatching {the dobj/him} from your grasp and putting {it dobj/him} back on the 
          desk.<.p>";
      }
      reportFailure('');
      exit;
    }
    inherited;
  }
  lootWarning : EventList {      
    [
      '<.p><q>I don\'t know <i>what</i> you think you\'re doing!</q> she tells you,
       <q>But I\'d thank you to leave government property alone!</q>
       <.reveal smuggle-envelope>',  
       
      '<.p><q>How many times do I have to tell you, <i>leave these things alone!</i></q>
       she cries.<.p>
       <q>Sorry,</q> you say, <q>I just thought...</q>\b
       <q>Then don\'t!</q> she interrupts you.',
            
       
      '<.p>She frowns even more fiercely and threatens,
       <q>If you do that once more I\'ll have to call security!</q>',
       
       {: receptionist.patienceExhausted() }
       
//      new function { "<q>Right, that's it!</q> she snaps. 
//      <q>I don't know who you're working for but we'll soon find out!</q>\b
//       She presses a button to summon the security guards. ";
//       torture();
//       }       
    ]    
  }
  
   
  brownEnvelopeTake : EventList {
   [
     '<.p>{The receptionist/she} puts out a hand to restrain you. <q>Leave that where it is,
      please.</q> she orders you.<.p><.reveal snatch-envelope>',
      
     '<.p><q>I thought I told you to leave that alone!</q> {the receptionist/she} complains,
      snatching the brown envelope from you and dumping it back in the tray. ', 
      
     '<.p>{The receptionist/she} knocks your hand away angrily. <q>If you try that again
      I\'ll have to call security.</q> she admonishes you.<.p>',
      
     {: receptionist.patienceExhausted() } 
      
   ]
  }
  whiteEnvelopeTake : EventList {
   [
     '{The receptionist/she} pushes your hand aside. <q>Leave that where it is,
      please.</q> she orders you.<.p><.reveal snatch-envelope>',
      
     '<q><i>Will</i> you leave that alone!</q> {the receptionist/she} glowers
      at you. Meekly, you hand her back the white envelope, which she drops
      noisily into the tray. ', 
      
     '{The receptionist/she} knocks your hand away angrily. <q>If you try that again
      I\'ll call security!</q> she warns you.<.p>',
      
      {: receptionist.patienceExhausted() }
   ]
  }
  patienceExhausted()
  {
     "<q>Don't say I didn't warn you!</q> {the receptionist/she} sighs heavily. Then, before
     you have time to move, she presses a button behind her desk.<.p>";
     callWithSenseContext(nil, nil, {: torture() } );
  }
  cannotKissActorMsg = 'You must be joking! '
  uselessToAttackMsg = 'You suspect that trying to ' + gVerbName 
    + ' {the receptionist/her} here will prove counterproductive, 
      since she\'ll probably be able to summon help before you can overpower her. '

  
  beforeTravel(traveler, connector)
  {
    if(traveler == gPlayerChar && connector == corridor)
    {
      noEntry.doScript;
      setCurState(recepTalking);       
      exit;
    }
    if(traveler == gPlayerChar && connector == glassDoorsInside
        && blueBook.location is in (receptionist, receptionDesk) )
    {
       "<q>Hey!</q> {the receptionist/she} calls, <q>You forgot your 
        book<<gRevealed('forgot-book') ? ' again' : ''>>!</q>\b
        <q>Oh -- yes,</q> you say, returning to her desk, <q>of course,
          thank you.</q><.p><.reveal forgot-book>";
       setCurState(recepTalking);
       exit;         
    }
    

      inherited(traveler, connector);
  }
   
  noEntry : StopEventList {
     [
       '<q>We don\'t allow visitors into the building without a pass.</q> {the
        receptionist/she} tells you.<.reveal pass>',
       '<q>No pass, no entry.</q> {the receptionist/she} reminds you. ',
       '<q>Where do you think you\'re going?</q> {the receptionist/she} snaps,
        <q>If you haven\'t got a pass, you can\'t go in.</q>',
       '<q>How many more times do I have to tell you?</q> {the receptionist/she}
        glowers at you, <q>You\'re not allowed in!</q>'  
     ]
    }
    
  
  boxCheck(leaving)
  {

     local forbiddenObjectSeen = nil; 
     
     /* If nothing is out of place, there's no more for this routine
        to do.
      */
     
     local allVisible = true, allInPlace = true;
     foreach(local obj in forbiddenObjects)
     {
       if(!canSee(obj) && obj.location != nil && !obj.location.ofKind(Envelope))       
         allVisible = nil;
       if(!obj.isIn(receptionDesk) && !obj.isIn(nil))
         allInPlace = nil;    
       
     }    
     
     if(allInPlace) return true; 
     
     "<.p>She suddenly notices that something is out of place, and stares
       at you intently to check what you're carrying.<.p>";
     
     if(allVisible) return nil;
     
     local playerCarryingForbidden = !checkContents(gPlayerChar);
     local forbiddenInDroppedBox = !checkContents(receptionArea);    
     
     forbiddenObjectSeen = playerCarryingForbidden || forbiddenInDroppedBox;     

     if(!forbiddenObjectSeen)     
     {       
       "<.p><q>Well,</q> she grunts, after satisfying herself that you're
        not carrying anything you shouldn't be, 
        <q>I suppose that all <i>seems</i> to be in order.</q><.p>";    

     }
     
     return !forbiddenObjectSeen;
  }  
      
  checkContents(cont)
  {
    local okay = true;
    if(cont.ofKind(ComplexContainer) && cont.subContainer != nil)
      cont = cont.subContainer;
    if(cont == tinBox) hasSeenTinBoxOpen = true;  
    foreach(local cur in cont.contents)
    {      
      if(forbiddenObjects.indexOf(cur))
      {
        "<.p>She takes <<cur.theName>> from <<cont.theName>> and returns it to the
          <<cur.properPlace.theName>>. ";
        
        cur.moveInto(cur.properPlace);
        
        if(cont==redBook.subContainer && !redBook.isObviousContainer)
        {
           redBook.isObviousContainer = true; // You've given the game away with the red book
           "<q>So, this red book is not what it seems,</q> she observes, <q>Well,
            now I know!</q> ";
        }
        
        okay = nil;        
      }
      if(cur.isObviousContainer || cur.isOpen)
      {
       local origLoc = cur.location; 
       if((cur.ofKind(Openable) || cur.ofKind(ComplexContainer))&& !cur.isOpen)
       {
         "<.p><q><<searchInsideMsgList.getNextValue()>> that <<cur.name>>,</q> she 
          <<rand('announces', 'declares', 'decides', 'tells you', 'says', 'states')>>.\n ";
          
          if(cur.isIn(gPlayerChar))
          { 
            "Under her ferocious gaze you obediently hand her <<cur.theName>>. ";
            
            cur.moveInto(self);         
           }       
          if(cur.isLocked) checkLocked(cur); 
          if(!cur.isLocked) {
            nestedActorAction(receptionist, Open, cur);
            if(wantsKeyFor != nil) keyCheck(wantsKeyFor);            
          }
        } 
        if(!cur.isLocked)        
           okay = okay && checkContents(cur);
        if(origLoc != cur.location)
        {
          "<.p>Having <<cur.isLocked ? 'examined' : 'searched'>> it, 
            she returns <<cur.theName>> to <<origLoc.theName>>. ";
          cur.moveInto(origLoc);
        }
      }  
    }
    return okay;
  }  
    
  wantsKeyFor = nil //set to the locked box she finds a locked box but no key  
  
  hasSeenTinBoxOpen = nil /* once she's seen the tin box open she can't
                           *  be fooled by a claim that you don't have the key.
                           */ 
  
  checkLocked(box)
  {
    "She finds <<box.theName>> locked, and looks up at you suspiciously.\n";
      if(brassKey.isIn(gPlayerChar) && (canSee(brassKey) || hasSeenTinBoxOpen))
      {
        "<q>The key, please!</q> she demands, holding out her palm
        <<canSee(brassKey) ? '. ' : ', <q>This tin box was open just now,
        so I know you must have it!</q>'>><.p>
        You find you dare not refuse her, so you <<canSee(brassKey) ? 
        'meekly drop the key into her palm' :  'surreptitiously retrieve
        the small brass key from its hiding place and ostentatiously
        hand it over to her with a broad, accommodating smile'>>. ";
        brassKey.baseMoveInto(self);
      }
      if(!keyCheck(box))      
      {
        "<q>I don't suppose you have the key to that <<box.name>>?</q> she asks.\b
         <q>No, I don't. &rsquo;Fraid not. Sorry.</q> you reply.\b
         <q>Very well,</q> she sighs.<.p>";
         wantsKeyFor = box;
      }
  }

  keyCheck(box)
  {
      if(canSee(brassKey) && !brassKey.isDirectlyIn(self))
      {
        "She spots <<brassKey.theName>>, <q>Hm, this perhaps?</q>
         she muses, picking it up. ";
         brassKey.moveInto(self);
      }
      if(brassKey.isIn(receptionist))
      {
        nestedActorAction(receptionist, UnlockWith, box, brassKey);
        "She proceeds to unlock the box, and then puts the key down on 
         the desk. ";
        brassKey.moveInto(receptionDesk);  
        wantsKeyFor = nil;
        return true;              
      }
      return nil;
  }

  searchInsideMsgList : ShuffledList  
  {
    valueList = [
      'I think I\'d better take a look inside',
      'I\'ll have to search',
      'I\'d better see what\'s in',
      'I\'ll just check what\'s in',
      'I\'ll just take a peek in'      
    ]
  }
    
  afterAction()
  {
    if(gActionIs(Yell))
      "<.p><q>Don't you <<gVerbName>> at me!</q> 
      {the receptionist/she} exclaims fiercely, <q>It's irrational and unbecoming!</q><.p>";
    inherited;
  }
  
  iobjFor(ThrowAt)
  {
    check() {
      reportFailure('That would antagonize her needlessly. ');
      exit;
    }
  }

    
  feelDesc = "She doesn't look like she'll welcome your pawing her. "
  smellDesc = "At first whiff you think she might be wearing perfume, but then you
   decide it smells more like disinfectant. "
  followAlreadyHereMsg = 'She\'s not going anywhere. ' 
  cannotScrewMsg = 'What? Right here, in reception -- on her desk? Are you <i>completely</i>
   shameless? Besides, you can be quite sure she\'d never allow it!'
  cannotTakeMsg = 'Fat chance she\'ll let {you/him} do that! '
  thankResponse = "<q>Thanks ever so much!</q> you declare.\b
   <q>That's utterly irrational,</q> she replies coldly, <q>I have done nothing whatever
    to earn your gratitude -- nor would I wish to!</q>"
;

+ Component 'hair' 'receptionist\'s hair'
  "{The receptionist/she}'s blonde hair has been cut short and trimmed to an uncompromisingly 
   neat style. "
   feelDesc =  "{The receptionist/she} doesn't look like the type of woman who would
       tolerate that. "
   smellDesc = "It smells faintly of whatever thoroughly rational shampoo she uses to
     keep it regimentally clean. "    
;   


+ recepDistracted : ActorState, CyclicEventList
  stateDesc = "She's busily reading the book you just gave her. "
  specialDesc = "{The receptionist/she} is reading a book with great interest. "
   
  eventList =
  [
    '{The receptionist/she} studies the book closely. ',
    '<q>Fascinating!</q> {the receptionist/she} mutters as she turns the pages. ',
    '{The receptionist/she} stares intently at the page. ',
    '{The receptionist/she} turns another page. ',
    '<q>I never knew that,</q> {the receptionist/she} mutters as she studies
     a fresh page. ',
    new function {
      "{The receptionist/she} suddenly remembers she's meant to be working,
       and so reluctantly closes the book and puts it down on her desk, telling
       you, <q>It's really interesting!</q> ";       
       receptionist.setCurState(recepTalking);
    } 
  ]
  deactivateState(actor, newState)
  {
    if(blueBook.isIn(receptionist))
       blueBook.moveInto(receptionDesk);
    
    receptionist.checkMissingObjects;   
       
  }
  activateState(actor, oldState)
  {
    curScriptState = 1;
  }
  thankResponse = "She ignores you, probably because she's so totally engrossed
   in the book. "
;

++ AskForTopic @blueBook
   topicResponse()
   {
     "<q>Could I have my book back, please?</q> you ask.<.p>
      {The receptionist/she} blinks and looks up at you, <q>Have I
      really been that long?</q> she asks anxiously, putting
      the book back down on the desk, <q>I'm afraid I became
      totally engrossed -- but I should be concentrating on my work!</q>";
      getActor.setCurState(recepTalking);
   }
;


++ DefaultAnyTopic
  "She's too engrossed in the book to notice you. "
;


+ recepTalking : InConversationState
  stateDesc = "She's looking up at you with evident distaste. "
  specialDesc = "{The receptionist/she} is sitting behind her desk looking up at you. "
  nextState = recepSitting
  
;

++ recepSitting : ConversationReadyState, ShuffledEventList
  isInitState = true
  stateDesc = "She's sitting behind the desk. "
  specialDesc = "{A receptionist/she} is sitting behind the desk.<.p>"
   
  eventList =
  [
    '{The receptionist/she} pauses to file her nails.<.p>',
    '{The receptionist/she} shuffles some papers on her desk.<.p>',
    '{The receptionist/she} answers the phone.<.p>',
    '{The receptionist/she} stares vacantly into space.<.p>',
    '{The receptionist/she} rummages through her handbag.<.p>',
    '{The receptionist/she} glances up at you.<.p>',
    '{The receptionist/she} starts reading one of the papers on her desk.<.p>',
    '{The receptionist/she} yawns.<.p>',
    '{The receptionist/she} scratches her nose.<.p>',
    '{The receptionist/she} glances over at the lifts<.p>',
    '{The receptionist/she} frowns in thought.<.p>'
  ]
  eventPercent = 80
  eventReduceAfter = 2
  eventReduceTo = 40
;

+++ HelloTopic, StopEventList
  [
    '<q>Excuse me.</q> you say.\b
     <q>Yes?</q> she looks up at you, glaring disapprovingly at your attire, <q>Can I
      help you?</q>',
    '<q>Hello again.</q> you greet her.\b
     <q>You again!</q> she declares, <q>What now?</q><.p>',
    '<q>It\'s me again.</q> you declare.\b
     <q>So I see,</q> {the receptionist/she} observes, without any obvious pleasure.<.p>'
  ]
;

+++ ByeTopic
 "<q>Cheerio, then.</q> you say.\b<q>Good day!</q> she replies. "
;

+++ ImpByeTopic
  "{The receptionist/she} turns her attention back to her desk. "
;

++ AskTopic, SuggestedAskTopic, StopEventList @brownEnvelope
   [
     '<q>What\'s in that envelope?</q> you ask.\b
      <q>That\'s none of your business!</q> she replies tartly.<.p>',
     '<q>Do you get many important envelopes like that?</q> you wonder.\b
      <q>This is an important government department -- go figure.</q> she retorts.<.p>',
     '<q>Aren\'t you curious about that envelope?</q> you inquire.\b
      <q>I\'m not paid to be curious.</q> she shrugs.<.p>',
     '<q>That envelope...</q> you begin.\b
      <q>... is absolutely none of your business.</q> she concludes firmly.<.p>'
   ]
   isActive = (!brownEnvelope.moved)
   name = 'the brown envelope'
;

++ AskForTopic, StopEventList @brownEnvelope
  [
    '<q>Er, perhaps I could take that envelope upstairs for you.</q> you offer.\b
     <q>No.</q> she replies firmly. ',
    '<q>Are you sure you wouldn\'t like me to take that envelope upstairs for you?</q>
     you ask.\b
     <q>Quite sure, thank you.</q> she replies briskly.'
  ]
  isActive = (!brownEnvelope.moved)
;

++ AskTopic, SuggestedAskTopic, CyclicEventList @whiteEnvelope
  [
    '<q>What\'s so urgent about this white envelope?</q> you ask.\b
     <q>How would I know?</q> she replies, <q>And what business is it of yours?</q>',
     
    '<q>I wonder what\'s in that white envelope.</q> you remark.\b
     <q>I don\'t,</q> she replies, <q>Wondering about what may not and need not
      know is deeply irrational.</q>' 
  ]
  name = 'the white envelope'
  isActive = (!whiteEnvelope.moved)
;

++ AskForTopic @blueBook
  "<q>May I have my book back, please?</q> you ask.<.p>
   <q>It's on the desk,</q> she nods, <q>help yourself.</q>"
   isActive = blueBook.isIn(receptionDesk)
;


++ AskAboutForTopic @telephone
  "<q>May I use your telephone, please?</q>\b
   <q>No, you may not.</q> she tells you firmly."
;

++ AskTopic, SuggestedAskTopic, StopEventList @papers
   [
     '<q>Are those papers interesting?</q> you ask her.\b
      <q>Not particularly.</q> she shrugs.',
     '<q>What\'s in those papers, then?</q> you wonder.\b
      <q>Just routine departmental business.</q> she replies.' 
   ]
   name = 'the papers'
;

++ AskTopic, SuggestedAskTopic, StopEventList @receptionist
   [
     '<q>Do you enjoy working here?</q> you ask her.\b
      <q>It is an honour to serve the cause of rational government.</q> she
       assures you briskly.<.p>',
     new function {
      "<q>So, what's your name?</q> you enquire.\b
       <q>Phryjid.</q> she replies tersely.";
       receptionist.isProperName = true;
       receptionist.name = 'Phryjid';
     },
     '<q>So, Phryjid, tell me all about yourself.</q> you suggest brightly.\b
      <q>Why on earth would it be rational for me to do that?</q> she replies
       incredulously, <q>You\'re just a smelly and intrusive stranger!</q>',
     '<q>What do you do for fun?</q> you ask her.\b
      <q>Fun?</q> she repeats incredulously, <q>Fun? I\'m a government servant,
      a <i>rational</i> government servant. I don\'t indulge in anything as
      irrational as <q>fun</q> -- ever!</q> she seems scandalized by the very
      thought of it, but then she adds, <q>I do, of course, enjoy learning
      all I can about our glorious new order of society. I read everything
      I can on it.</q><.p>',
     '<q>Are you married, Phryjid?</q> you enquire.\b
      She almost falls off her chair with shock. <q>Married!</q> she squeals in
      horror, <q>What kind of antique notion is that! I merely participate in the
      rational breeding programme laid down by the Department of Eugenics -- as
      does any law-abiding citizen. You are so <i>primitive</i>!</q><.p>',  
     '<q>So, what else can you tell me about yourself?</q> you ask brightly.\b
      <q>As little as possible.</q> she replies firmly.' 
   ]
   name = 'herself'
//   timesToSuggest = (eventList.length)
;

++ AskTopic @t_work
  "<q>So what exactly is your job here?</q> you ask.\b
   <q>I\'m the receptionist,</q> she replies in a tone suggesting intense
    irritation at being forced to explain the blindingly obvious, <q>I answer
    the phone, direct people to their appointments, look after mail, and
    ensure that unauthorised and undesirable persons --</q> she gives you
    a particularly hard look at this point <q>-- don\'t pester my superiors.</q> "
;


++ AskTopic, SuggestedAskTopic, StopEventList @t_justice
   [
     '<q>What are your ideas on justice?</q> you ask her.\b
      <q>You ask <i>me</i> that?</q> she queries, <q>Not that it\'s a complicated
      question, of course.</q> she recovers herself, <q>This department has rationalized
      and simplified the justice system considerably, so even a common tramp like you
      should be able to understand it.</q>',
     '<q>So, tell me how this new simplified justice works.</q> you ask.\b
      <q>Simple.</q> she declares, <q>If you do something wrong, you\'re punished
       for it. If we think you\'ve done something wrong, then you have.</q>\b
      <q>So if you think I\'ve done something wrong, I\'m punished just for that?</q>
       you query.\b
      <q>There, I told you it was so simple that even an ignorant tramp could understand
      it!</q> she agrees triumphantly.',
      '<q>Do you find this new justice system, er... </q> you were about to say
       <q>fair</q> or <q>just</q> but just in time you change it to <q>interesting?</q>\b
       <q>Actually, I do.</q> she declares, <q>I study everything I can on it.</q>',
      '<q>So you\'re really interested in justice?</q> you ask.\b
       <q>New Enlightenment Justice -- yes!</q> she declares.'        
   ]
   name = 'justice'
//   timesToSuggest = static (eventList.length)
;

++ InsultTopic, ShuffledEventList, SuggestedTopicTree
   [ 
     '<q>You look like a hard-faced bitch to me.</q> you remark.\b
      <q>Good,</q> she smiles, <q>because that\'s <i>just</i> what I
      am.</q>',
      '<q>You\'re an awkward so-and-so, aren\'t you!</q> you tell her.\b
       <q>I certainly hope so!</q> she grins. '
   ]
   [  
     '<q>You\'re about as attractive as venomous spider wrapped in rusty
      barbed wire.</q> you tell her.\b
      <q>But twice as dangerous!</q> she warns you.',
      
     '<q>Do you make a point of being bloody-minded and difficult?</q>
      you ask.\b
      <q>Only to the likes of you.</q> she replies.',
      
      '<q>You stupid cow!</q> you rant at her.\b
      <q>Is that <i>really</i> the best you can come up with?</q>
       she sneers, <q>I should have thought a lobotomized ox could devise
       a more original insult!</q>',
       
      '<q>Stubborn bitch!</q> you cry.\b
       <q>Merely forthright and determined.</q> she replies.',
       
      '<q>You\'re a repressed, frigid little vixen.</q> you
       opine.\b
       <q>While you give every appearance of being an uncouth, primitive
         retard.</q> she replies evenly. ',
         
      '<q>I think you\'re utterly loathsome!</q> you fulminate.\b
       <q>I wish I could say something as kind about you.</q> she replies.',
        
      '<q>Why does this department employ such an ugly receptionist?</q>
        you demand.\b
       <q>To frighten away unwelcome visitors?</q> she suggests. ',
       
       '<q>Why are you so damned unhelpful?</q> you complain.\b
        <q>Because nothing you have said or done suggests that you
         deserve to be helped.</q> she replies.'        
       
   ]
   handleTopic(fromActor, topic)
   {
     getActor().praised--;
     inherited(fromActor, topic);
   }
   fullName = 'insult her'
   timesToSuggest = nil
;

+++ AltTopic  
  topicResponse()
  {
    getActor.praised = 4;
    "<q>Well,</q> you say, <q>you\'re a hard bitch, aren\'t you? All that
     praise I've been heaping on you and you can\'t even manage a smile!</q>\b
     <q>How irrational you are!</q> she complains, <q>Gratuitous flattery followed
     by gratuitous insult! Clearly the product of a pre-rational and probably
     criminally schizophrenic mind!</q>";
  }
  isActive = (getActor.praised > 4)
;

++ PraiseTopic, SuggestedTopic
   "<<gAction.zeroActionTime>><.convnode praiseReceptionist>"
   
   fullName = 'praise her'
//   timesToSuggest = static (eventList.length)
;

++ AskTopic, SuggestedAskTopic, StopEventList @t_dunderhead
  [
    '<q>Who\'s this Dunderhead fellow?</q> you ask.\b
     <q>He\'s the Director -- and a <i>very</i> important man.</q> she replies
     in a sniffy tone calculated to convey <q>far too important for a smelly tramp
     like you to be concerned with.</q>',
    '<q>Can I see Professor Dunderhead, please?</q> you ask.\b
     <q>Certainly not -- he\'s <i>far</i> too busy!</q> she retorts.<.p>',
    '<q>I\'ll tell you what,</q> you offer, <q>If you just ring through to him
     and tell him I\'m coming, I can take that urgent envelope up to him for you.</q>\b
     <q>That won\'t be necessary, thank you very much.</q> she replies stiffly.',
    '<q>Are you quite sure you wouldn\'t like me to take that envelope up to 
     Professor Dunderhead for you?</q> you ask.\b
     <q>Quite sure!</q> she almost snarls.'     
  ]
  name = 'Professor Dunderhead'
  isActive = (gRevealed('dunderhead'))
//  timesToSuggest = static (eventList.length)
;

++ AskTopic, SuggestedAskTopic, StopEventList @t_pass
   [
     '<q>How does one go about getting a pass?</q> you enquire.\b
      <q>Well,</q> she replies, <q>Either you have to work here, which you
       obviously don\'t, or you have to match our security criteria and have 
       a valid reason for needing to enter the building -- in which case you
       would be issued a visitor pass.</q><.reveal criteria>',
     '<q>So how would I go about applying for a pass?</q> you ask.\b
      <q>Well, to get the required security clearance you would need to apply
       to department G16 on the third floor for the appropriate vetting.</q> she
       informs you.<.reveal department-g16>\b
       <q>Right, let me in to see department G16 then.</q> you request.\b
       <q>Not without a pass.</q> she replies.',
      '<q>I\'m getting confused.</q> you say, <q>You\'re saying I need a visitor pass
       to get into the building, but that in order to qualify for a pass I need
       to see someone in the building?</q>\b
       <q>That\'s right,</q> she replies crisply, <q>Rational security measures,
       you see.</q>\b
       <q>Then how does a member of the public get in here?</q> you ask.\b
       <q>You don\'t.</q> she replies smugly, <q>No outsiders, no security risk.
        It\'s entirely rational, don\'t you see?</q><.convnode entirely-rational>',        
      '<q>So you\'re telling me there\'s no way I can get a visitor pass?</q> you ask.\b
       <q>That\'s right!</q> she beams, clearly delighted that this is the case. '
   ]
   isActive = (gRevealed('pass'))
   name = 'a pass'
;

++ AskTopic, SuggestedAskTopic @t_departmentG16
   "<q>What is Department G16?</q> you ask.\b
    <q>It's the department that issues security passes.</q> she tells you.\b
    <q>So how do I get there?</q> you want to know.\b
    <q>It\'s on the third floor -- but I can't let you into the lifts without a pass.</q>
     she informs you."
  isActive = (gRevealed('department-g16'))
  name = 'the department'
;

++ AskTopic, SuggestedAskTopic @t_securityCriteria
  "<q>What are the security criteria that one has to match to gain entrance, then?</q>
   you want to know.\b
   <q>Thoroughly rational ones, of course. For example, do you have a good reason
    for being granted access to this department?</q> she replies.<.convnode criteria>"
  isActive = (gRevealed('criteria'))
  name = 'security criteria'
;


++ AskTopic, SuggestedAskTopic, StopEventList @t_pandra
  [
    '<q>What do you know about Pandra?</q> you ask.\b
     <q>Pandra?</q> she repeats, evidently surprised by your question,
     <q>Why, as we all know, Pandra\'s is the great mind that showed
      us the way to Rational Government.</q>',
      
     '<q>Have you read Pandra\'s works?</q> you wonder.\b
      <q>I\'ve read <i>Principles of Rational Government</i>,</q> she replies,
      <q>as all citizens do. It\'s a great book, a very great book. Actually,
       I\'ve read it several times.</q>',
       
     '<q>So you think Pandra\'s great?</q> you ask.\b
      <q>Pandra is the greatest!</q> she declares with surprising warmth,
       and something like rapture in her eyes. '  
  ]
  name = 'Pandra'
  isActive = (gRevealed('pandra'))
;

++ AskTopic, StopEventList @t_manifesto
  [
    '<q>You think Pandra\'s <i>Principles of Rational Government</i> is
      a great book?</q> you ask.<.p>
     <q>Yes, of course,</q> she declares, <q>It\'s the greatest book in
      the world! The foundation of all rational government!</q>',
      
    '<q>So what does Pandra\'s book say, exactly?</q> you enquire.<.p>
     <q>It shows how irrationality has made such a mess of the past, and how
      rationality can make a wonderful future!</q> she declares with 
      evangelical fervour.',
      
    '<q>How exactly does Pandra\'s book think that rationality is going to
     make things so much better?</q> you wonder.<.p>
     <q>You should read it for yourself!</q> she tells you. '  
       
  ]
  isActive = (gRevealed('pandra'))
;



++ AskTellTopic, StopEventList @t_sex
  [
    '<q>What do you think about sex?</q> you ask suddenly.\b
     <q>It has its purpose as a means of reproduction.</q> she shrugs
     nonchalantly. ',
     
    '<q>Do you approve of sex?</q> you enquire.\b
     <q>Of course,</q> she replies, <q>it shuffles the gene pool, which
      is far better for long-term public health than cloning would be.</q> ',
      
    '<q>So tell me, do you enjoy sex?</q> you dare to ask.\b
     <q>Enjoy?</q> she replies, as if the idea had never previously 
     occurred to her, <q>It\'s just a necessary bodily function, like
     eating and sleeping. I suppose there are biological and evolutionary
     reasons why the proper exercise of such functions give a certain
     amount of positive emotional feedback, but being self-aware rational
     creatures that is not something to which we need pay that much
     attention.</q>',
     
    '<q>When did you last have sex?</q> you wonder.\b
     <q>I think we\'ve exhausted that topic,</q> she replies tartly. '
  ]
;

++ AskTellTopic, StopEventList @t_love
 [
   '<q>Tell me, do you believe in love?</q> you ask.\b
    <q>Of course,</q> she replies briskly, <q>I love my job, my duty, 
    my place in this rational order -- and of course I love good order,
    rationality, and all the values of the New Enlightnment.</q>
    <.reveal new-enlightenment>',
    
    '<q>What about people -- do you believe in loving other people?</q> you
     wonder.\b
    <q>Certainly not!</q> she snaps, <q>That\'s a terrible retrograde notion,
     a trick of nature that we\'ve now outgrown!</q> Settling back in her
     chair to lecture you, she continues, <q>In pre-rational ages, love was
     an evolutionary leftover, nature\'s way of tricking parents into caring
     for their children, men and women into reproducing, and people in general
     to co-operate. Now that child-rearing, procreation and social co-operation
     have all been reorganized along rational lines, the sentiments that used
     to drive them are no longer necessary.</q>',
     
    '<q>Have you never felt love for another human being?</q> you ask.\b
     <q>Being evolved from lower animals, like others of my species,</q> she
     replies in an offhand tone that suggests she may not be including you
     in this classification, <q>I do of course experience emotional disturbances from time 
     to time -- but, like all civilized human beings I have been schooled to recognize
     them as mere chemical imbalances in my body, and thus to ignore them -- especially
     soggy sentimental ones like affection for other people.</q> She pauses for a
     moment, and then adds with a cold smile, <q>but some other emotions, like
     anger and hatred, do have their occasional uses -- particularly in motivating
     one to deal with undesirables.</q>',
     
     '<q>So, you\'ve never loved anyone?</q> you ask incredulously.\b
      <q>Loved? Certainly not!</q> she replies, perhaps a little too quickly,
      <q>Of course there are people I <i>admire</i> -- Pandra, for example.</q>
      <.reveal pandra>',
     
     '<q>So do you think you\'re incapable of loving another human being?</q> you ask.\b
      <q>I certainly hope so!</q> she declares. '
     
 ]
;

++ AskTopic, StopEventList @t_god
  [
    '<q>Do you believe in God?</q> you ask.\b
     <q>If you mean some big Daddy in the sky, then no, of course not,</q>
     she replies, <q>not even a child would believe such a thing. But if
     you mean the principle of rationality behind all things... well, we
     live in a totally rational universe, and I believe in reason, so
     if by <q>God</q> you mean <q>reason</q> then yes, I believe in it.</q>',
   
   '<q>So there is no God but reason?</q> you enquire.\b
    <q>No God but reason,</q> she affirms. '
      
  ]
;

++ AskTopic, SuggestedAskTopic, StopEventList @biker
  [
    '<q>Why do you use a motorcycle courier?</q> you ask, <q>surely this
     enlightened age can manage a more efficient means of communication!</q>\b
     <q>But not a more secure one,</q> she replies, <q>as you should know,
     electronic communications can always be intercepted, and we handle some
     <i>highly</i> sensitive information here.</q>',
     
    '<q>How do you know the courier won\'t be intercepted?</q> you wonder.\b
     <q>Oh -- there\'re all specially vetted and highly trained.</q> she assures you.',
     
    '<q>How frequently does the courier service run from here?</q> you inquire.\b
     <q>Often enough to ensure our urgent mail is delivered with the minimum of
     delay.</q> she replies. ',
     
    '<q>How does one get to become a courier?</q> you ask.\b
     <q>If you\'re thinking of applying, you can forget it!</q> she sneers. '  
  ] 
  name = 'the courier'
;

++ AskTopic @t_newEnlightenment
  "<q>Tell me about the New Enlightenment,</q> you request.\b
   <q>It's the best thing that ever happened to the human race!</q> she
    declares, with a fierce, fanatical gleam in her eye. " 
  isActive = gRevealed('new-enlightenment')
;

++ GiveShowTopic @blueCoveralls
  "That would be a <i>seriously</i> bad idea. Even if she's not
   quite as clever as she thinks it is, she's got enough between her ears to work
   out that someone wearing shabby clothes and carrying prison coveralls could well
   be an escaped prisoner, and she has even less sympathy for criminals than she
   does for the rest of humanity. "
  isConversational = nil
;

++ GiveShowTopic @sandwich
  "<q>No thank you!</q> she says, flinching from the sandwich, <q>It doesn't match my
   dietometric profile!</q> "
;

++ GiveTopic, SuggestedGiveTopic @blueBook
   topicResponse
   {
      takeBook.doScript;
      blueBook.moveInto(getActor);
      getActor.setCurState(recepDistracted);
   }
   name = 'the blue book'
   takeBook : ShuffledEventList {
    [
      '<q>I thought you might like to read this,</q> you say, holding out the
       blue book to her.<.p>
       {The receptionist/she} takes the book, glances at the title, and opens it at
      once, remarking, <q>Now, this <i>does</i> look interesting.</q>\b
      She settles back to read.<.reveal recep-read-book>',
      
      '<q>Perhaps you\'d like to take another quick look?</q> you suggest, <q>After
       all, a brain like yours obviously needs feeding!</q><.p>
       <q>You think so?</q> she replies, with the ghost of a smile tugging at the
       the corners of her mouth, <q>Oh, very well then, I suppose I could dip into
       one more time.</q>'
    ]
    [
      '<q>Perhaps you\'d like to take just one more peep?</q> you suggest.<.p>
       <q>No, I really shouldn\'t -- I\'m meant to be working and you\'re obviously
       just trying to distract me.</q> she says.<.p>
       <q>Very well,</q> you shrug, putting the blue book down on the desk right
        in front of her.<.p>
       Within thirty seconds she succumbs to temptation, picks it up, and starts
        reading once more. ',
        
       '<q>Are you sure you\'ve looked at this book thoroughly enough?</q> you
        enquire, trying to hand it to her again, <q>I understand it\'s required
        reading for every citizen.</q><.p>
        <q>Whatever do you mean?</q> she asks. A worried frown creases her brow,
        and she takes the book from you just to check. ',
        
       '<q>I\'m sure you\'re destined for greater things than being a receptionist,</q>
        you say.<.p>
        <q>Whatever makes you think that?</q> she demands.<.p>
        <q>Well, for one thing, your obvious enthusiasm for improving literature.</q>
         you suggest, handing her the blue book.<.p>
        <q>Well...</q> she starts to protest, but then she starts turning the pages
         and within a few moments she\'s temporarily hooked again. ',
         
       '<q>I\'m sure there\'s something in here that establishes my right to enter
        this building!</q> you announce, handing her the blue book.<.p>
        <q>Nonsense!</q> she declares, and just to prove her point she takes it
         from you and starts turning the pages just to check. '        
         
    ]
   }
   timesToSuggest = (gRevealed('blue-book-shown') ? 5 : 0)
;

++ ShowTopic @blueBook
  "You hold out the blue book for her to see. 
   {The receptionist/she} glances at the title, <q>Now <i>that</i> looks like it
   might be interesting,</q> she remarks.<.reveal blue-book-shown>"
;

+++ AltTopic 
  "You hold out the blue book to her again, <q>You did find it interesting?</q>
   you enquire.</q><.p>
   <q>Oh yes,</q> she nods. "
  isActive = gRevealed('recep-read-book')
;


++ AskTellTopic @blueBook
  "<q>I've come across this book on Modern Theories of Crime and Punishment,</q>
  you tell her, <q>is that the sort of thing you might find interesting?</q>\b
  <q>I might.</q> she agrees cautiously. "
;

+++ AltTopic
   "<q>Did you find it useful -- that blue book?</q> you wonder.<.p>
    <q>Quite informative -- yes,</q> she agrees, <q>very informative, in fact.
     Not quite up to Pandra's standards, of course, but very interesting
     nonetheless.</q><.reveal pandra> "
   isActive = gRevealed('recep-read-book')
;



++ GiveShowTopic @greenBook
    "{The receptionist/she} takes the book, glances at it briefly, then hands it
     back, <q>Geometry is a good rational subject,</q> she approves, <q>but I
     shouldn\'t be reading about it at work. Besides, I'm really more interested
     in politics and law.</q><.p>"
   name = 'the green book'  
;

++ GiveShowTopic, StopEventList @redBook
   [
    'She takes one look at the title and gives a firm shake of her head, <q>I have
      <i>no</i> intention of occupying my time with elementary geometry exercises, so I
      have no need of that key, thank you very much!</q>',
      
    '<q>I\'ve already told you, I don\'t need it.</q> she reminds you.',
    
    '<q>I\'m not interested,</q> she snaps, <q>How many times do I have to tell you?</q>'  
   ]
;


++ GiveShowTopic, EventList [pressRelease, document, greenLetter, coverPage, 
     whiteEnvelope, brownEnvelope]
  [
   'You hesitate to show her {the dobj/him}, suspecting that she won\'t be at
    all pleased that you\'ve managed to get hold of it. That you\'ve done
    so hardly reflects well on her, and it seems not at all unlikely that 
    she\'ll take it out on you! ',
  
   new function {
    "{The receptionist/she} takes {the dobj/him} and begins to read it. A look
    of growing consternation spreads over her face as she realizes what you 
    have just given her.\b
    <q>Where did you get this?</q> she demands.\b
    <q>Well, I...</q> you begin.\b
    <q>Never mind, it isn\'t me you need to answer to.</q> she interrupts,
    <q>Stay right there, I'm calling security!</q>\b
    Before you can move or utter another word she presses a button behind her desk. ";
    torture();
  }
  ]
  isConversational = (curScriptState > 1)
  
;

++ AskTopic, SuggestedAskTopic, StopEventList @t_department
 [
   '<q>What is this department?</q> you ask.\b
    <q>It\'s the Department of Applied Rationality,</q> she replies crisply,
    <q>Didn\'t you see the notice outside? Or are you illiterate?</q>',
    
   '<q>What does the Department of Applied Rationality do?</q> you want to know.\b
    <q>It applies rationality, of course,</q> she replies. ',
    
    '<q>What does this department apply rationality to?</q> you enquire.\b
     <q>All sorts of things,</q> she replies airily.'
 ]
 name = 'the department'
;

++ AskTopic, StopEventList @t_government
 [
  '<q>So, what do you think of the government?</q> you ask.\b
   <q>Like all law-abiding citizens, I recognize them as the most thoroughly
    rational government in the history of the human race,</q> she tells you. ',
  
  '<q>You work for the government?</q> you enquire.\b
   <q>This is a government department; I work here; go figure.</q> she replies. ',
   
  '<q>What makes the government so great?</q> you wonder.\b
   <q>It\'s total dedication to rationality, of course,</q> she answers. ' 
    
 ]
;


++ AskTellTopic, StopEventList @t_squareCircle
[
  '<q>Have you ever drawn a square circle? I have!</q> you announce proudly,
   in an attempt to impress her.\b
   {The receptionist/she} studies her fingernails with a bored expression,
   <q>I suppose you drew four lines in a circle on some sphere,</q> she
   deduces dismissively, <q>any child could do that. But I suppose some
   people who lack a proper mathematical education might imagine that
   a square circle was an impossibility.</q>',
   
  '<q>But what is the significance of square circles in the rational scheme
   of things?</q> you want to know.\b
   <q>Significance?</q> she repeats, then gives a little shrug, <q>None that
   I know of.</q>',
   
  '<q>Tell me,</q> you ask, <q>why might a prisoner be asked to draw a square
   circle?</q>\b
   <q>How would I know?</q> she replies, <q>I don\'t associate with criminals,
   and I don\'t work for the Punishment Service. I have heard it said, though,
   that the Punishment Service sometimes tries to match the punishment to
   the crime.</q>',
   
  '<q>What sort of crime would be matched by the punishment of having to
   draw a square circle?</q> you ask her.\b
   {The receptionist/she} yawns vigorously to signal her utter disinterest
   in the question, <q>Some crime against rationality, no doubt,</q> she
   replies vaguely. '    
]
;

++ AskTopic, StopEventList @t_prison
  [
    '<q>Does this department have much to do with prisons?</q> you ask.\b
     <q>Not really,</q> she replies, <q>That\'s the domain of the Punishment
     Service.</q>',
     
    '<q>Isn\'t rationality applied to prisons, then?</q> you demand.\b
     <q>Of course, rationality is applied to all aspects of society,</q> she
     replies stiffly, <q>but this department would only be interested at the
     very general level of rationally co-ordinating penal policy with other 
     government policy; the details are left to the Punishment Service.</q>',
     
    '<q>Do you know what goes on in prison?</q> you ask.\b
     <q>Of course,</q> she shrugs, <q>the rational punishment of criminals.</q>'     
  ]
;

++ AskTopic, StopEventList +110 @t_reason
  [
    '<q>So, what\'s so great about rationality?</q> you ask.\b
    She looks at you in utter horror, as if you were questioning the very
    foundations of her existence, then, turning visibly paler she says,
    <q>You\'re just testing me, right? You\'re from the Rationality Audit
    Office, checking up on government employees?</q>\b
    <q>Maybe,</q> you reply noncomittally, <q>but if I were it would hardly
    be entirely rational of me to reveal the fact, would it?</q>\b
    <q>I suppose not,</q> she frowns, <q>Well,</q> she continues, trying
    to collect herself, <q>For one thing rationality is the most reasonable
    way to conduct human affairs, and for another, reason is the cure for
    all the ills of the past.</q>',
    
    '<q>So reason is good because it\'s rational?</q> you ask.\b
    <q>That\'s right.</q> she affirms.\b
    <q>And rationality is good because it\'s reasonable?</q>\b
    <q>Of course!</q> she nods.\b
    <q>Isn\'t that a circular argument?</q> you suggest.\b
    <q>Well, it\'s certainly not a square one!</q> she jests feebly. ',
    
    '<q>How has rationality helped you?</q> you wonder.\b
     <q>Through rationality I lead a properly ordered and useful life,<q>
     she replies promptly.\b
     <q>Useful to whom?</q> you ask.\b
     <q>Why -- to society of course!</q> she replies.',
     
    '<q>How has reason improved things?</q> you want to know.\b
     She gives a little shudder, <q>Can\'t you remember the mess we had
     before?</q>\b
     Since you can still hardly remember anything before you awoke in
     your prison cell, you grunt a non-committal reply.\b
     <q>War, global pollution, international terrorism, rising crime --
      it was terrible!</q> she reminds you, <q>We just <i>had</i> to find
      a different way!</q>',
      
    '<q>So reason has answered all our problems.</q> you remark flatly.\b
     <q>Yes, of course!</q> she affirms. '  
    
  ]  
;

++ TellTopic @gPlayerChar
   "She doesn't look the sort of person with whom to share confidences; telling her
    the truth about your recent escape would be disastrous, and you haven't figured
    out enough to tell her a useful lie. "
   isConversational = nil
;

++ DefaultAskTellTopic, ShuffledEventList
  [
    '{The receptionist/she} merely glares at you coldly. ',
    
    'The phone rings, obliging {the receptionist/her} to interrupt the conversation
     briefly while she answers it and puts the caller through. When she replaces
     the receiver, she looks up at you again, but seems to have missed what you said. ',
     
    '<q>If you\'ve got nothing better to discuss, I have work to do.</q> she
      replies frostily. ',
      
    '<q>What nonsense!</q> she declares. ',
    
    '<q>I have no intention of wasting time discussing ' + topicText() +
    ' with you!</q> she frowns, <q>I have <i>far</i> more important things to attend to!</q>'  
   
  ]  
;

++ DefaultCommandTopic, ShuffledEventList
  [
    '<q>I only take orders from my superiors,</q> she informs you stiffly. ',
    '<q>Do it yourself!</q> she snaps. ',
    '<q>Certainly not!</q> she declares. '    
  ]
;

++ DefaultGiveShowTopic
  "{The receptionist/she} shows not the least interest. "
;

++ DefaultAskForTopic
   "<q>No.</q> she says, very firmly. "
;


+ praiseReceptionistNode : ConvNode 'praiseReceptionist'
  limitSuggestions = true
;

++ praiseLooksTopic : SpecialTopic, StopEventList 'praise her looks' ['praise', 'her', 'looks']
  [
    '<q>I like your haircut.</q> you tell her, <q>It\'s very neat;
     and it looks nice on you.</q>\b
     <q>It\'s just the rational way to wear it.</q> she shrugs.',
     
    '<q>Has anyone told you what a very attractive woman you are?</q> you
     enquire.\b
     She rolls her eyes in despair, <q>What sewer did <i>you</i> crawl out of?</q>
     she mutters. ',
     
     '<q>You know, you really are amazingly beautiful.</q> you declare.\b
      <q>If you think your grotesque flattery will have any effect on me, you\'re
       wasting your time.</q> she informs you. ',
       
     '<q>What\'s a beautiful woman like you...</q> you begin.\b  
      <q>You\'re becoming <i>very</i> tedious.</q> she interrupts you. '
  ]
;

++ praiseIntelligenceTopic: SpecialTopic, StopEventList 
  'praise her intelligence' ['praise', 'her', 'intelligence']
  [
    '<q>You\'re obviously a highly intelligent woman.</q> you tell her.\b
     <q>How can you possibly tell that?</q> she demands.\b
     <q>One only has to look at you -- such a thoroughly <i>rational</i> appearance.</q>
      you say.\b
     <q>Why, thank you.</q> she almost smiles, preening herself.',
     
     '<q>Even after talking with you so briefly I can tell you\'re very clever.</q>
      you remark.\b
      <q>You think so?</q> she asks, evidently not displeased. ',
      
     '<q>What\'s a clever woman like you doing working as a mere receptionist?</q> 
      you wonder.\b
      <q>We all have to start somewhere in the service of Rational Government.</q>
      she replies. ',
      
      '<q>An intelligent woman like you should go far.</q> you tell her.\b
       <q>Well -- one can but hope.</q> she says, <q>I do try to stretch my mind --
       by reading all I can so as better to understand Rational Government.</q> '
      
  ]
  handleTopic(fromActor, topic)
  {
    getActor.praised++;
    inherited(fromActor, topic);
  }
;

+++ AltTopic
  topicResponse()
  {
    getActor.praised = -4;
    "<q>Despite everything I've said, I do think you\'re really rather
     intelligent,</q> you tell her, <q>your ripostes to my insults demonstrate
     a keen mind and a ready wit.</q>\b
    <q>I'm glad you appreciate it,</q> she replies, only slightly mollified. "; 
  }
  isActive = (getActor.praised < -4)
;


++ praiseDiligenceTopic: SpecialTopic, StopEventList 
  'praise her diligence' ['praise', 'her', 'diligence']
  [
     '<q>You seem to be working hard.</q> you remark.\b
      <q>I do whatever is necessary to maintain efficiency.</q> she
       replies coolly. ',
       
      '<q>I reckon they\'re jolly lucky to get someone as diligent as
       you.</q> you tell her.\b
       <q>I merely do my duty like any rational citizen.</q> she shrugs. ',
       
      '<q>I bet not many other citizens are as conscientious as you are!</q>
       you declare.\b
       <q>How could you possibly know that?</q> she complains; but a ghost of
        a smile nevertheless tugs at the corner of her lips. ',
        
      '<q>Are you as conscientious in your use of leisure?</q> you inquire.\b
       <q>Oh, absolutely!</q> she declares, <q>I spend as much time as I can
        reading to educate myself about the workings of Rational Government
        so I can be a better citizen.</q> '  
  ] 
  handleTopic(fromActor, topic)
  {
    getActor.praised++;
    inherited(fromActor, topic);
  }
;

+++ AltTopic
topicResponse()
  {
    getActor.praised = -4;
    "<q>Perhaps I've been a bit hard on you,</q> you concede, <q>you're only
      doing your job after all, and you are doing it pretty conscientiously.</q>\b        
    <q>Naturally, I'm a loyal citizen,</q> she replies, only slightly mollified. "; 
  }
  isActive = (getActor.praised < -4)
;

+ receptionistBikerState : HermitActorState
  specialDesc = "{The receptionist/she} is deep in conversation with the despatch rider. "
  stateDesc = "She's deep in conversation with the despatch rider. "
  noResponse = "She angrily waves you to silence, snapping, <q>Wait your turn!</q> before
    returning her full attention to the despatch rider. "
;

+ ConvNode 'criteria';

++ YesTopic, SuggestedYesTopic
  "<q>Yes, of course.</q> you reply.\b
   <q>Such as?</q> she asks.<.convnode criteria-2>"
;

++ NoTopic, SuggestedNoTopic
  "<q>No, not really.</q> you admit.\b
   <q>Well, there you are then,</q> she replies, <q>you obviously don't meet the
   criteria.</q>"
;

+ ConvNode 'criteria-2';

++ SpecialTopic 'refuse to say' ['refuse', 'to', 'say']
  "<q>My reasons are none of your business.</q> you tell her.\b
   <q>They are if you want to come in here!</q> she replies you, <q>But it's
    obvious you wouldn't match the criteria anyway.</q>"
;

++ SpecialTopic 'claim to have an appointment' 
   ['claim', 'to', 'i', 'have', 'an', 'appointment']
  "<q>I have an appointment with your boss,</q> you claim.\b
   <q>No you don't,</q> she replies, pretending to check the list, <q>there's no
    appointment here for a smelly tramp!</q>"
;

++ SpecialTopic 'try to be mysterious' ['try', 'to', 'be', 'being', 'mysterious']
   "<q>Well, you see, it's sensitive goverment business...</q> you whisper in a 
   confidential tone.\b
    <q>Nonsense!</q> she cuts you short, <q>If you were here on government business
     you'd already have a pass!</q>"
;

++ SpecialTopic 'admit pure curiosity' ['admit', 'pure', 'curiosity']
  "<q>I just wondered what went on in here,</q> you confess.\b
   <q>That's absolutely <i>no</i> reason to let you see!</q> she retorts,
   <q>Allowing you to satisfy your curiosity would be deeply irrational!</q>"
;

+ ConvNode 'entirely-rational';

++ YesTopic
  "<q>Oh yes, entirely rational,</q> you agree with as much sarcasm
   as you can muster.<.p>
   {The receptionist/she} appears -- or chooses to appear -- oblivious
   of your irony, and merely nods as if to say, <q>There you are then!</q>"
;

++ NoTopic
  "<q>No, frankly I don't see!</q> you reply.<.p>
  <q>I suppose that's only to be expected,</q> she remarks, <q>You
   don't look particularly intelligent.</q> "
;



function torture()
{
  "Before you can escape, a pair of burly guards rush in and seize you by the
   arms. Under their questioning you inevitably let slip that you've escaped from
   the punishment facility, so they drag you back there...<.p>";
   inputManager.pauseForMore(true);
   gPlayerChar.moveIntoForTravel(driveway);
   whiteCoat.moveIntoForTravel(driveway);
   guardian.moveIntoForTravel(driveway);
   guardian.setCurState(guardianPistol);
   nestedAction(Look);
   "<q>It's all right, I'll take over from here,</q> he
    tells the two guards who have just brought you here.<.p>
    The two guards nod in acknowledgement, and walk away to the north, leaving
    you alone with the white coated man and your old enemy the guardian.<.p>"; 
    whiteCoat.killPlayer();
    
}
