// AdvDatabase.h - database

#ifndef _AdvDatabase_h_
#define _AdvDatabase_h_

#include "AdvDef.h"
#include "AdvGlobals.h"

/////////////
// Data files

#define LONGFILE	"ADV1.DAT"
#define MSGFILE		"ADV2.DAT"
#define OBJFILE		"ADV3.DAT"
#define SHORTFILE	"ADV4.DAT"
#define VOCABFILE	"ADV5.DAT"

//////
// API

bool loadObjectDescriptions
  (AdvGlobalContext&    gc,
   OBJECT_DESCRIPTOR*   descriptionArray,
   long                 nArraySize,
   char*                szFilespec,
   long&                nEntriesLoaded);

void unloadObjectDescriptions
  (OBJECT_DESCRIPTOR*   descriptionArray,
   long                 nArraySize);

bool loadDescriptionArray
  (AdvGlobalContext&  gc,
   PTR_TEXTLINES*     descriptionArray,
   long               nArraySize,
   char*              szFilespec,
   long&              nEntriesLoaded);

void unloadDescriptionArray
  (PTR_TEXTLINES*   descriptionArray,
   long             nArraySize);

long translateVocabWord
  (char*  pszWord);

#endif

// End AdvDatabase.h
