/*
 *      ADV.H - Header file for Collosal Cave Adventure
 *      (C) 1986 Ravi Bhavnani
 *      All rights reserved
 */

#include "advdef.h"

char    *malloc();

extern
o_struct        obj   [MAXOBJECTS];     /* object descriptions */
extern
t_struct        msg  [MAXMESSAGES];     /* message texts */
extern
t_struct        shortp [MAXPLACES];     /* short place descriptions */
extern
t_struct        longp  [MAXPLACES];     /* long place descriptions */
extern
v_struct        vocab   [MAXVOCAB];     /* vocabulary array */

extern
FILE    *f;             /* generic file ptr */

extern	struct dsc$descriptor_s
	userinput,	/* string descriptor used by SMG$ routines */
	advprompt,	/* string descriptor used by SMG$ routines */
	adv$dat,	/* logical pointing to datafile directory */
	adv$sav;	/* logical pointing to save/restore directory */

extern
string  str,		/* generic char string */
        input,		/* user input line */
        word1,		/* word 1 of user input */
        word2,		/*      2               */
	dat_dir,	/* directory of data files */
	sav_dir,	/*              saved      */
	objfile,	/* object file name */
	msgfile,	/* message file name */
	shortfile,	/* short descriptions file name */
	longfile,	/* long descriptions file name */
	vocabfile;	/* vocabulary file name */

extern
long    startplay,      /* time he started playing */
        nowtime,        /* current time */
        memused,	/* dynamic RAM used */
	kbd_id,		/* keyboard id for SMG$ routines */
	ktbl_id,	/* key table id for SMG$ routines */
	oldcmask,	/* old control mask for ^Y trapping */
	newcmask;	/* new control mask for ^Y trapping */

extern
int	major,		/* major version */
	minor,		/* minor version */
	release,	/* release number */
	debug,          /* debug flag - used during development */
	margin,		/* margin left while printing trace info */
        nmsgs,          /* # messages */
        nlongs,         /* # long place descriptions */
        nshorts,        /* # short place descriptions */
        nvocab,         /* # words in vocabulary */
        nobj,           /* # objects */
        inword,         /* # words in input */
        arg1,           /* user input word 1 */
        arg2,           /* user input word 2 */
        context,        /* context of earlier command */
        ticker,         /* 1 = need to tick the administrative clock */
        moved,          /* 1 = we were able to change locs */
        demo,           /* 1 = it's a demo game */
        lamplife,       /* lamp's life */
        lighted,        /* there is light here */
        briefmode,      /* 1 = brief place descriptions after first time */
        fastmode,       /* 1 = brief place descriptions always */
        thing,          /* general purpose object */
        loc,            /* general purpose location */
        derf,           /* general purpose int */
        here,           /* current location */
        prevloc,        /* previous location */
        nmoves,         /* # moves */
        nturns,         /* # turns */
        dwarfcount,     /* # dwarves alive */
        dwarrows,       /* # dwarves in room! */
        invct,          /* inventory count */
        hintime,        /* used in hint logic */
        quitting,       /* 1 = he wants to quit */
        ranout,         /* 1 = his lamp *just* ran out of juice */
        knives,         /* # knives thrown by attacking dwarves */
        closure,        /* phases of closure */
        clock,          /* clock tick counter */
        foobar,         /* fee fie foe foo indicator */
        strength,       /* adventurer's strength */
        cameotime,      /* cameo time counter */
        nomagic,        /* 1 = magic inhibit mode */
        deaths,         /* # times he died */
        scorex,         /* his score */
        maxscore,       /* max possible he could have scored so far */
        penalties,      /* penalty points for hints, etc. */
        olorin,         /* 1 = he's a wizard */
        nretort,        /* # retorts said */
        ok2desc,        /* 1 = it's ok to say place and object descriptions */
        justdied,       /* 1 = he just died */
        password,       /* safe exit pwd: blerbi/klaetu/knerl/snoeze/zorton */
	safeexit,	/* loc you end up when you exit safe */
        paniced,        /* 1 = tried to leave cave on closure */
        mushtime,       /* mushroom time */
        lastclock,      /* last value of clock */
        escap,          /* 1 = cannot escape from cylindrical room */
        dragtime,       /* dragon time */
        saidxyzzyplugh,	/* 1 = used xyzzy or plugh to enter cave */
	waterphuggg,	/* 1 = said PHUGGG near water */
	extended;	/* 1 = extended version moves recognized */

        /* PLACE RELATED PROPERTIES */

extern
parray  lit,            /* place is self-illuminated */
        visited,        /* # times we've been here */
        nodwarf,        /* dwarves not allowed here */
        noback,         /* GO BACK won't work here */
        notincave,      /* place is outside the cave */
        hintable,       /* hint available here */
        h2ohere,        /* water available here */
        inmaze,         /* place is inside a maze */
        onexit,         /* place has one exit */
        thrower;        /* throwing things here send them elsewhere */

        /* OBJECT RELATED PROPERTIES */

extern
oarray  portable,       /* object can be carried */
        seen,           /* we've seen it */
        valued,         /* it's a treasure (must be left in building) */
        mortal,         /* it's killable */
        openable,       /* can be opened/unlocked */
        invisible,      /* what else? */
        weightless,     /* not counted in inventory */
        where_is,       /* current location of object */
        special1,       /* special bit 1 - context dependent */
        special2,       /*             2                     */
        firstdesc,      /* describe these objects first */
        val,            /* value of object */
	nodesc;		/* is never described */
