/*
===========================================================================
Copyright (C) 1999-2005 Id Software, Inc.

This file is part of Quake III Arena source code.

Quake III Arena source code is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the License,
or (at your option) any later version.

Quake III Arena source code is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Foobar; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
===========================================================================
*/
/**** This file is autogenerated.  Run GenerateQGL.pl to update it ****/

#ifdef QGL_LOG_GL_CALLS
extern unsigned int QGLLogGLCalls;
extern FILE *QGLDebugFile(void);
#endif

extern void QGLCheckError(const char *message);
extern unsigned int QGLBeginStarted;

// This has to be done to avoid infinite recursion between our glGetError wrapper and QGLCheckError()
static inline GLenum _glGetError(void) {
    return glGetError();
}

// void glAccum (GLenum op, GLfloat value);
static inline void qglAccum(GLenum op, GLfloat value)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glAccum(op=%lu, value=%f)\n", op, value);
#endif
    glAccum(op, value);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glAccum");
#endif
}

// void glAlphaFunc (GLenum func, GLclampf ref);
static inline void qglAlphaFunc(GLenum func, GLclampf ref)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glAlphaFunc(func=%lu, ref=%f)\n", func, ref);
#endif
    glAlphaFunc(func, ref);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glAlphaFunc");
#endif
}

// GLboolean glAreTexturesResident (GLsizei n, const GLuint *textures, GLboolean *residences);
static inline GLboolean qglAreTexturesResident(GLsizei n, const GLuint *textures, GLboolean *residences)
{
    GLboolean returnValue;
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glAreTexturesResident(n=%ld, textures=%p, residences=%p)\n", n, textures, residences);
#endif
    returnValue = glAreTexturesResident(n, textures, residences);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glAreTexturesResident");
#endif
    return returnValue;
}

// void glArrayElement (GLint i);
static inline void qglArrayElement(GLint i)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glArrayElement(i=%ld)\n", i);
#endif
    glArrayElement(i);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glArrayElement");
#endif
}

// void glBegin (GLenum mode);
static inline void qglBegin(GLenum mode)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glBegin(mode=%lu)\n", mode);
#endif
    glBegin(mode);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    QGLBeginStarted++;
    if (!QGLBeginStarted)
        QGLCheckError("glBegin");
#endif
}

// void glBindTexture (GLenum target, GLuint texture);
static inline void qglBindTexture(GLenum target, GLuint texture)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glBindTexture(target=%lu, texture=%lu)\n", target, texture);
#endif
    glBindTexture(target, texture);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glBindTexture");
#endif
}

// void glBitmap (GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap);
static inline void qglBitmap(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glBitmap(width=%ld, height=%ld, xorig=%f, yorig=%f, xmove=%f, ymove=%f, bitmap=%p)\n", width, height, xorig, yorig, xmove, ymove, bitmap);
#endif
    glBitmap(width, height, xorig, yorig, xmove, ymove, bitmap);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glBitmap");
#endif
}

// void glBlendFunc (GLenum sfactor, GLenum dfactor);
static inline void qglBlendFunc(GLenum sfactor, GLenum dfactor)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glBlendFunc(sfactor=%lu, dfactor=%lu)\n", sfactor, dfactor);
#endif
    glBlendFunc(sfactor, dfactor);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glBlendFunc");
#endif
}

// void glCallList (GLuint list);
static inline void qglCallList(GLuint list)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glCallList(list=%lu)\n", list);
#endif
    glCallList(list);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glCallList");
#endif
}

// void glCallLists (GLsizei n, GLenum type, const GLvoid *lists);
static inline void qglCallLists(GLsizei n, GLenum type, const GLvoid *lists)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glCallLists(n=%ld, type=%lu, lists=%p)\n", n, type, lists);
#endif
    glCallLists(n, type, lists);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glCallLists");
#endif
}

// void glClear (GLbitfield mask);
static inline void qglClear(GLbitfield mask)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glClear(mask=%lu)\n", mask);
#endif
    glClear(mask);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glClear");
#endif
}

// void glClearAccum (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
static inline void qglClearAccum(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glClearAccum(red=%f, green=%f, blue=%f, alpha=%f)\n", red, green, blue, alpha);
#endif
    glClearAccum(red, green, blue, alpha);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glClearAccum");
#endif
}

// void glClearColor (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
static inline void qglClearColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glClearColor(red=%f, green=%f, blue=%f, alpha=%f)\n", red, green, blue, alpha);
#endif
    glClearColor(red, green, blue, alpha);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glClearColor");
#endif
}

// void glClearDepth (GLclampd depth);
static inline void qglClearDepth(GLclampd depth)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glClearDepth(depth=%f)\n", depth);
#endif
    glClearDepth(depth);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glClearDepth");
#endif
}

// void glClearIndex (GLfloat c);
static inline void qglClearIndex(GLfloat c)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glClearIndex(c=%f)\n", c);
#endif
    glClearIndex(c);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glClearIndex");
#endif
}

// void glClearStencil (GLint s);
static inline void qglClearStencil(GLint s)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glClearStencil(s=%ld)\n", s);
#endif
    glClearStencil(s);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glClearStencil");
#endif
}

// void glClipPlane (GLenum plane, const GLdouble *equation);
static inline void qglClipPlane(GLenum plane, const GLdouble *equation)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glClipPlane(plane=%lu, equation=%p)\n", plane, equation);
#endif
    glClipPlane(plane, equation);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glClipPlane");
#endif
}

// void glColor3b (GLbyte red, GLbyte green, GLbyte blue);
static inline void qglColor3b(GLbyte red, GLbyte green, GLbyte blue)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor3b(red=%d, green=%d, blue=%d)\n", red, green, blue);
#endif
    glColor3b(red, green, blue);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor3b");
#endif
}

// void glColor3bv (const GLbyte *v);
static inline void qglColor3bv(const GLbyte *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor3bv(v=%p)\n", v);
#endif
    glColor3bv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor3bv");
#endif
}

// void glColor3d (GLdouble red, GLdouble green, GLdouble blue);
static inline void qglColor3d(GLdouble red, GLdouble green, GLdouble blue)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor3d(red=%f, green=%f, blue=%f)\n", red, green, blue);
#endif
    glColor3d(red, green, blue);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor3d");
#endif
}

// void glColor3dv (const GLdouble *v);
static inline void qglColor3dv(const GLdouble *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor3dv(v=%p)\n", v);
#endif
    glColor3dv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor3dv");
#endif
}

// void glColor3f (GLfloat red, GLfloat green, GLfloat blue);
static inline void qglColor3f(GLfloat red, GLfloat green, GLfloat blue)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor3f(red=%f, green=%f, blue=%f)\n", red, green, blue);
#endif
    glColor3f(red, green, blue);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor3f");
#endif
}

// void glColor3fv (const GLfloat *v);
static inline void qglColor3fv(const GLfloat *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor3fv(v=%p)\n", v);
#endif
    glColor3fv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor3fv");
#endif
}

// void glColor3i (GLint red, GLint green, GLint blue);
static inline void qglColor3i(GLint red, GLint green, GLint blue)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor3i(red=%ld, green=%ld, blue=%ld)\n", red, green, blue);
#endif
    glColor3i(red, green, blue);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor3i");
#endif
}

// void glColor3iv (const GLint *v);
static inline void qglColor3iv(const GLint *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor3iv(v=%p)\n", v);
#endif
    glColor3iv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor3iv");
#endif
}

// void glColor3s (GLshort red, GLshort green, GLshort blue);
static inline void qglColor3s(GLshort red, GLshort green, GLshort blue)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor3s(red=%d, green=%d, blue=%d)\n", red, green, blue);
#endif
    glColor3s(red, green, blue);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor3s");
#endif
}

// void glColor3sv (const GLshort *v);
static inline void qglColor3sv(const GLshort *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor3sv(v=%p)\n", v);
#endif
    glColor3sv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor3sv");
#endif
}

// void glColor3ub (GLubyte red, GLubyte green, GLubyte blue);
static inline void qglColor3ub(GLubyte red, GLubyte green, GLubyte blue)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor3ub(red=%u, green=%u, blue=%u)\n", red, green, blue);
#endif
    glColor3ub(red, green, blue);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor3ub");
#endif
}

// void glColor3ubv (const GLubyte *v);
static inline void qglColor3ubv(const GLubyte *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor3ubv(v=%p)\n", v);
#endif
    glColor3ubv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor3ubv");
#endif
}

// void glColor3ui (GLuint red, GLuint green, GLuint blue);
static inline void qglColor3ui(GLuint red, GLuint green, GLuint blue)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor3ui(red=%lu, green=%lu, blue=%lu)\n", red, green, blue);
#endif
    glColor3ui(red, green, blue);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor3ui");
#endif
}

// void glColor3uiv (const GLuint *v);
static inline void qglColor3uiv(const GLuint *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor3uiv(v=%p)\n", v);
#endif
    glColor3uiv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor3uiv");
#endif
}

// void glColor3us (GLushort red, GLushort green, GLushort blue);
static inline void qglColor3us(GLushort red, GLushort green, GLushort blue)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor3us(red=%u, green=%u, blue=%u)\n", red, green, blue);
#endif
    glColor3us(red, green, blue);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor3us");
#endif
}

// void glColor3usv (const GLushort *v);
static inline void qglColor3usv(const GLushort *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor3usv(v=%p)\n", v);
#endif
    glColor3usv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor3usv");
#endif
}

// void glColor4b (GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha);
static inline void qglColor4b(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor4b(red=%d, green=%d, blue=%d, alpha=%d)\n", red, green, blue, alpha);
#endif
    glColor4b(red, green, blue, alpha);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor4b");
#endif
}

// void glColor4bv (const GLbyte *v);
static inline void qglColor4bv(const GLbyte *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor4bv(v=%p)\n", v);
#endif
    glColor4bv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor4bv");
#endif
}

// void glColor4d (GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha);
static inline void qglColor4d(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor4d(red=%f, green=%f, blue=%f, alpha=%f)\n", red, green, blue, alpha);
#endif
    glColor4d(red, green, blue, alpha);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor4d");
#endif
}

// void glColor4dv (const GLdouble *v);
static inline void qglColor4dv(const GLdouble *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor4dv(v=%p)\n", v);
#endif
    glColor4dv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor4dv");
#endif
}

// void glColor4f (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
static inline void qglColor4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor4f(red=%f, green=%f, blue=%f, alpha=%f)\n", red, green, blue, alpha);
#endif
    glColor4f(red, green, blue, alpha);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor4f");
#endif
}

// void glColor4fv (const GLfloat *v);
static inline void qglColor4fv(const GLfloat *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor4fv(v=%p)\n", v);
#endif
    glColor4fv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor4fv");
#endif
}

// void glColor4i (GLint red, GLint green, GLint blue, GLint alpha);
static inline void qglColor4i(GLint red, GLint green, GLint blue, GLint alpha)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor4i(red=%ld, green=%ld, blue=%ld, alpha=%ld)\n", red, green, blue, alpha);
#endif
    glColor4i(red, green, blue, alpha);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor4i");
#endif
}

// void glColor4iv (const GLint *v);
static inline void qglColor4iv(const GLint *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor4iv(v=%p)\n", v);
#endif
    glColor4iv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor4iv");
#endif
}

// void glColor4s (GLshort red, GLshort green, GLshort blue, GLshort alpha);
static inline void qglColor4s(GLshort red, GLshort green, GLshort blue, GLshort alpha)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor4s(red=%d, green=%d, blue=%d, alpha=%d)\n", red, green, blue, alpha);
#endif
    glColor4s(red, green, blue, alpha);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor4s");
#endif
}

// void glColor4sv (const GLshort *v);
static inline void qglColor4sv(const GLshort *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor4sv(v=%p)\n", v);
#endif
    glColor4sv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor4sv");
#endif
}

// void glColor4ub (GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha);
static inline void qglColor4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor4ub(red=%u, green=%u, blue=%u, alpha=%u)\n", red, green, blue, alpha);
#endif
    glColor4ub(red, green, blue, alpha);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor4ub");
#endif
}

// void glColor4ubv (const GLubyte *v);
static inline void qglColor4ubv(const GLubyte *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor4ubv(v=%p)\n", v);
#endif
    glColor4ubv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor4ubv");
#endif
}

// void glColor4ui (GLuint red, GLuint green, GLuint blue, GLuint alpha);
static inline void qglColor4ui(GLuint red, GLuint green, GLuint blue, GLuint alpha)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor4ui(red=%lu, green=%lu, blue=%lu, alpha=%lu)\n", red, green, blue, alpha);
#endif
    glColor4ui(red, green, blue, alpha);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor4ui");
#endif
}

// void glColor4uiv (const GLuint *v);
static inline void qglColor4uiv(const GLuint *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor4uiv(v=%p)\n", v);
#endif
    glColor4uiv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor4uiv");
#endif
}

// void glColor4us (GLushort red, GLushort green, GLushort blue, GLushort alpha);
static inline void qglColor4us(GLushort red, GLushort green, GLushort blue, GLushort alpha)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor4us(red=%u, green=%u, blue=%u, alpha=%u)\n", red, green, blue, alpha);
#endif
    glColor4us(red, green, blue, alpha);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor4us");
#endif
}

// void glColor4usv (const GLushort *v);
static inline void qglColor4usv(const GLushort *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColor4usv(v=%p)\n", v);
#endif
    glColor4usv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColor4usv");
#endif
}

// void glColorMask (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
static inline void qglColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColorMask(red=%u, green=%u, blue=%u, alpha=%u)\n", red, green, blue, alpha);
#endif
    glColorMask(red, green, blue, alpha);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColorMask");
#endif
}

// void glColorMaterial (GLenum face, GLenum mode);
static inline void qglColorMaterial(GLenum face, GLenum mode)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColorMaterial(face=%lu, mode=%lu)\n", face, mode);
#endif
    glColorMaterial(face, mode);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColorMaterial");
#endif
}

// void glColorPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
static inline void qglColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glColorPointer(size=%ld, type=%lu, stride=%ld, pointer=%p)\n", size, type, stride, pointer);
#endif
    glColorPointer(size, type, stride, pointer);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glColorPointer");
#endif
}

// void glCopyPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum type);
static inline void qglCopyPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glCopyPixels(x=%ld, y=%ld, width=%ld, height=%ld, type=%lu)\n", x, y, width, height, type);
#endif
    glCopyPixels(x, y, width, height, type);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glCopyPixels");
#endif
}

// void glCopyTexImage1D (GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border);
static inline void qglCopyTexImage1D(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glCopyTexImage1D(target=%lu, level=%ld, internalFormat=%lu, x=%ld, y=%ld, width=%ld, border=%ld)\n", target, level, internalFormat, x, y, width, border);
#endif
    glCopyTexImage1D(target, level, internalFormat, x, y, width, border);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glCopyTexImage1D");
#endif
}

// void glCopyTexImage2D (GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
static inline void qglCopyTexImage2D(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glCopyTexImage2D(target=%lu, level=%ld, internalFormat=%lu, x=%ld, y=%ld, width=%ld, height=%ld, border=%ld)\n", target, level, internalFormat, x, y, width, height, border);
#endif
    glCopyTexImage2D(target, level, internalFormat, x, y, width, height, border);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glCopyTexImage2D");
#endif
}

// void glCopyTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
static inline void qglCopyTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glCopyTexSubImage1D(target=%lu, level=%ld, xoffset=%ld, x=%ld, y=%ld, width=%ld)\n", target, level, xoffset, x, y, width);
#endif
    glCopyTexSubImage1D(target, level, xoffset, x, y, width);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glCopyTexSubImage1D");
#endif
}

// void glCopyTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
static inline void qglCopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glCopyTexSubImage2D(target=%lu, level=%ld, xoffset=%ld, yoffset=%ld, x=%ld, y=%ld, width=%ld, height=%ld)\n", target, level, xoffset, yoffset, x, y, width, height);
#endif
    glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glCopyTexSubImage2D");
#endif
}

// void glCullFace (GLenum mode);
static inline void qglCullFace(GLenum mode)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glCullFace(mode=%lu)\n", mode);
#endif
    glCullFace(mode);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glCullFace");
#endif
}

// void glDeleteLists (GLuint list, GLsizei range);
static inline void qglDeleteLists(GLuint list, GLsizei range)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glDeleteLists(list=%lu, range=%ld)\n", list, range);
#endif
    glDeleteLists(list, range);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glDeleteLists");
#endif
}

// void glDeleteTextures (GLsizei n, const GLuint *textures);
static inline void qglDeleteTextures(GLsizei n, const GLuint *textures)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glDeleteTextures(n=%ld, textures=%p)\n", n, textures);
#endif
    glDeleteTextures(n, textures);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glDeleteTextures");
#endif
}

// void glDepthFunc (GLenum func);
static inline void qglDepthFunc(GLenum func)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glDepthFunc(func=%lu)\n", func);
#endif
    glDepthFunc(func);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glDepthFunc");
#endif
}

// void glDepthMask (GLboolean flag);
static inline void qglDepthMask(GLboolean flag)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glDepthMask(flag=%u)\n", flag);
#endif
    glDepthMask(flag);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glDepthMask");
#endif
}

// void glDepthRange (GLclampd zNear, GLclampd zFar);
static inline void qglDepthRange(GLclampd zNear, GLclampd zFar)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glDepthRange(zNear=%f, zFar=%f)\n", zNear, zFar);
#endif
    glDepthRange(zNear, zFar);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glDepthRange");
#endif
}

// void glDisable (GLenum cap);
static inline void qglDisable(GLenum cap)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glDisable(cap=%lu)\n", cap);
#endif
    glDisable(cap);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glDisable");
#endif
}

// void glDisableClientState (GLenum array);
static inline void qglDisableClientState(GLenum array)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glDisableClientState(array=%lu)\n", array);
#endif
    glDisableClientState(array);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glDisableClientState");
#endif
}

// void glDrawArrays (GLenum mode, GLint first, GLsizei count);
static inline void qglDrawArrays(GLenum mode, GLint first, GLsizei count)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glDrawArrays(mode=%lu, first=%ld, count=%ld)\n", mode, first, count);
#endif
    glDrawArrays(mode, first, count);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glDrawArrays");
#endif
}

// void glDrawBuffer (GLenum mode);
static inline void qglDrawBuffer(GLenum mode)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glDrawBuffer(mode=%lu)\n", mode);
#endif
    glDrawBuffer(mode);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glDrawBuffer");
#endif
}

// void glDrawElements (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices);
static inline void qglDrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glDrawElements(mode=%lu, count=%ld, type=%lu, indices=%p)\n", mode, count, type, indices);
#endif
    glDrawElements(mode, count, type, indices);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glDrawElements");
#endif
}

// void glDrawPixels (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
static inline void qglDrawPixels(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glDrawPixels(width=%ld, height=%ld, format=%lu, type=%lu, pixels=%p)\n", width, height, format, type, pixels);
#endif
    glDrawPixels(width, height, format, type, pixels);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glDrawPixels");
#endif
}

// void glEdgeFlag (GLboolean flag);
static inline void qglEdgeFlag(GLboolean flag)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEdgeFlag(flag=%u)\n", flag);
#endif
    glEdgeFlag(flag);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glEdgeFlag");
#endif
}

// void glEdgeFlagPointer (GLsizei stride, const GLvoid *pointer);
static inline void qglEdgeFlagPointer(GLsizei stride, const GLvoid *pointer)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEdgeFlagPointer(stride=%ld, pointer=%p)\n", stride, pointer);
#endif
    glEdgeFlagPointer(stride, pointer);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glEdgeFlagPointer");
#endif
}

// void glEdgeFlagv (const GLboolean *flag);
static inline void qglEdgeFlagv(const GLboolean *flag)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEdgeFlagv(flag=%p)\n", flag);
#endif
    glEdgeFlagv(flag);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glEdgeFlagv");
#endif
}

// void glEnable (GLenum cap);
static inline void qglEnable(GLenum cap)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEnable(cap=%lu)\n", cap);
#endif
    glEnable(cap);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glEnable");
#endif
}

// void glEnableClientState (GLenum array);
static inline void qglEnableClientState(GLenum array)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEnableClientState(array=%lu)\n", array);
#endif
    glEnableClientState(array);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glEnableClientState");
#endif
}

// void glEnd (void);
static inline void qglEnd(void)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEnd(void)\n");
#endif
    glEnd();
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    QGLBeginStarted--;
    if (!QGLBeginStarted)
        QGLCheckError("glEnd");
#endif
}

// void glEndList (void);
static inline void qglEndList(void)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEndList(void)\n");
#endif
    glEndList();
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glEndList");
#endif
}

// void glEvalCoord1d (GLdouble u);
static inline void qglEvalCoord1d(GLdouble u)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEvalCoord1d(u=%f)\n", u);
#endif
    glEvalCoord1d(u);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glEvalCoord1d");
#endif
}

// void glEvalCoord1dv (const GLdouble *u);
static inline void qglEvalCoord1dv(const GLdouble *u)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEvalCoord1dv(u=%p)\n", u);
#endif
    glEvalCoord1dv(u);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glEvalCoord1dv");
#endif
}

// void glEvalCoord1f (GLfloat u);
static inline void qglEvalCoord1f(GLfloat u)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEvalCoord1f(u=%f)\n", u);
#endif
    glEvalCoord1f(u);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glEvalCoord1f");
#endif
}

// void glEvalCoord1fv (const GLfloat *u);
static inline void qglEvalCoord1fv(const GLfloat *u)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEvalCoord1fv(u=%p)\n", u);
#endif
    glEvalCoord1fv(u);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glEvalCoord1fv");
#endif
}

// void glEvalCoord2d (GLdouble u, GLdouble v);
static inline void qglEvalCoord2d(GLdouble u, GLdouble v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEvalCoord2d(u=%f, v=%f)\n", u, v);
#endif
    glEvalCoord2d(u, v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glEvalCoord2d");
#endif
}

// void glEvalCoord2dv (const GLdouble *u);
static inline void qglEvalCoord2dv(const GLdouble *u)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEvalCoord2dv(u=%p)\n", u);
#endif
    glEvalCoord2dv(u);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glEvalCoord2dv");
#endif
}

// void glEvalCoord2f (GLfloat u, GLfloat v);
static inline void qglEvalCoord2f(GLfloat u, GLfloat v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEvalCoord2f(u=%f, v=%f)\n", u, v);
#endif
    glEvalCoord2f(u, v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glEvalCoord2f");
#endif
}

// void glEvalCoord2fv (const GLfloat *u);
static inline void qglEvalCoord2fv(const GLfloat *u)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEvalCoord2fv(u=%p)\n", u);
#endif
    glEvalCoord2fv(u);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glEvalCoord2fv");
#endif
}

// void glEvalMesh1 (GLenum mode, GLint i1, GLint i2);
static inline void qglEvalMesh1(GLenum mode, GLint i1, GLint i2)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEvalMesh1(mode=%lu, i1=%ld, i2=%ld)\n", mode, i1, i2);
#endif
    glEvalMesh1(mode, i1, i2);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glEvalMesh1");
#endif
}

// void glEvalMesh2 (GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2);
static inline void qglEvalMesh2(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEvalMesh2(mode=%lu, i1=%ld, i2=%ld, j1=%ld, j2=%ld)\n", mode, i1, i2, j1, j2);
#endif
    glEvalMesh2(mode, i1, i2, j1, j2);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glEvalMesh2");
#endif
}

// void glEvalPoint1 (GLint i);
static inline void qglEvalPoint1(GLint i)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEvalPoint1(i=%ld)\n", i);
#endif
    glEvalPoint1(i);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glEvalPoint1");
#endif
}

// void glEvalPoint2 (GLint i, GLint j);
static inline void qglEvalPoint2(GLint i, GLint j)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glEvalPoint2(i=%ld, j=%ld)\n", i, j);
#endif
    glEvalPoint2(i, j);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glEvalPoint2");
#endif
}

// void glFeedbackBuffer (GLsizei size, GLenum type, GLfloat *buffer);
static inline void qglFeedbackBuffer(GLsizei size, GLenum type, GLfloat *buffer)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glFeedbackBuffer(size=%ld, type=%lu, buffer=%p)\n", size, type, buffer);
#endif
    glFeedbackBuffer(size, type, buffer);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glFeedbackBuffer");
#endif
}

// void glFinish (void);
static inline void qglFinish(void)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glFinish(void)\n");
#endif
    glFinish();
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glFinish");
#endif
}

// void glFlush (void);
static inline void qglFlush(void)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glFlush(void)\n");
#endif
    glFlush();
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glFlush");
#endif
}

// void glFogf (GLenum pname, GLfloat param);
static inline void qglFogf(GLenum pname, GLfloat param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glFogf(pname=%lu, param=%f)\n", pname, param);
#endif
    glFogf(pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glFogf");
#endif
}

// void glFogfv (GLenum pname, const GLfloat *params);
static inline void qglFogfv(GLenum pname, const GLfloat *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glFogfv(pname=%lu, params=%p)\n", pname, params);
#endif
    glFogfv(pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glFogfv");
#endif
}

// void glFogi (GLenum pname, GLint param);
static inline void qglFogi(GLenum pname, GLint param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glFogi(pname=%lu, param=%ld)\n", pname, param);
#endif
    glFogi(pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glFogi");
#endif
}

// void glFogiv (GLenum pname, const GLint *params);
static inline void qglFogiv(GLenum pname, const GLint *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glFogiv(pname=%lu, params=%p)\n", pname, params);
#endif
    glFogiv(pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glFogiv");
#endif
}

// void glFrontFace (GLenum mode);
static inline void qglFrontFace(GLenum mode)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glFrontFace(mode=%lu)\n", mode);
#endif
    glFrontFace(mode);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glFrontFace");
#endif
}

// void glFrustum (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
static inline void qglFrustum(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glFrustum(left=%f, right=%f, bottom=%f, top=%f, zNear=%f, zFar=%f)\n", left, right, bottom, top, zNear, zFar);
#endif
    glFrustum(left, right, bottom, top, zNear, zFar);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glFrustum");
#endif
}

// GLuint glGenLists (GLsizei range);
static inline GLuint qglGenLists(GLsizei range)
{
    GLuint returnValue;
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGenLists(range=%ld)\n", range);
#endif
    returnValue = glGenLists(range);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGenLists");
#endif
    return returnValue;
}

// void glGenTextures (GLsizei n, GLuint *textures);
static inline void qglGenTextures(GLsizei n, GLuint *textures)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGenTextures(n=%ld, textures=%p)\n", n, textures);
#endif
    glGenTextures(n, textures);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGenTextures");
#endif
}

// void glGetBooleanv (GLenum pname, GLboolean *params);
static inline void qglGetBooleanv(GLenum pname, GLboolean *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetBooleanv(pname=%lu, params=%p)\n", pname, params);
#endif
    glGetBooleanv(pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetBooleanv");
#endif
}

// void glGetClipPlane (GLenum plane, GLdouble *equation);
static inline void qglGetClipPlane(GLenum plane, GLdouble *equation)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetClipPlane(plane=%lu, equation=%p)\n", plane, equation);
#endif
    glGetClipPlane(plane, equation);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetClipPlane");
#endif
}

// void glGetDoublev (GLenum pname, GLdouble *params);
static inline void qglGetDoublev(GLenum pname, GLdouble *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetDoublev(pname=%lu, params=%p)\n", pname, params);
#endif
    glGetDoublev(pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetDoublev");
#endif
}

// GLenum glGetError (void);
static inline GLenum qglGetError(void)
{
    GLenum returnValue;
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetError(void)\n");
#endif
    returnValue = glGetError();
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetError");
#endif
    return returnValue;
}

// void glGetFloatv (GLenum pname, GLfloat *params);
static inline void qglGetFloatv(GLenum pname, GLfloat *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetFloatv(pname=%lu, params=%p)\n", pname, params);
#endif
    glGetFloatv(pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetFloatv");
#endif
}

// void glGetIntegerv (GLenum pname, GLint *params);
static inline void qglGetIntegerv(GLenum pname, GLint *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetIntegerv(pname=%lu, params=%p)\n", pname, params);
#endif
    glGetIntegerv(pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetIntegerv");
#endif
}

// void glGetLightfv (GLenum light, GLenum pname, GLfloat *params);
static inline void qglGetLightfv(GLenum light, GLenum pname, GLfloat *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetLightfv(light=%lu, pname=%lu, params=%p)\n", light, pname, params);
#endif
    glGetLightfv(light, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetLightfv");
#endif
}

// void glGetLightiv (GLenum light, GLenum pname, GLint *params);
static inline void qglGetLightiv(GLenum light, GLenum pname, GLint *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetLightiv(light=%lu, pname=%lu, params=%p)\n", light, pname, params);
#endif
    glGetLightiv(light, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetLightiv");
#endif
}

// void glGetMapdv (GLenum target, GLenum query, GLdouble *v);
static inline void qglGetMapdv(GLenum target, GLenum query, GLdouble *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetMapdv(target=%lu, query=%lu, v=%p)\n", target, query, v);
#endif
    glGetMapdv(target, query, v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetMapdv");
#endif
}

// void glGetMapfv (GLenum target, GLenum query, GLfloat *v);
static inline void qglGetMapfv(GLenum target, GLenum query, GLfloat *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetMapfv(target=%lu, query=%lu, v=%p)\n", target, query, v);
#endif
    glGetMapfv(target, query, v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetMapfv");
#endif
}

// void glGetMapiv (GLenum target, GLenum query, GLint *v);
static inline void qglGetMapiv(GLenum target, GLenum query, GLint *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetMapiv(target=%lu, query=%lu, v=%p)\n", target, query, v);
#endif
    glGetMapiv(target, query, v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetMapiv");
#endif
}

// void glGetMaterialfv (GLenum face, GLenum pname, GLfloat *params);
static inline void qglGetMaterialfv(GLenum face, GLenum pname, GLfloat *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetMaterialfv(face=%lu, pname=%lu, params=%p)\n", face, pname, params);
#endif
    glGetMaterialfv(face, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetMaterialfv");
#endif
}

// void glGetMaterialiv (GLenum face, GLenum pname, GLint *params);
static inline void qglGetMaterialiv(GLenum face, GLenum pname, GLint *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetMaterialiv(face=%lu, pname=%lu, params=%p)\n", face, pname, params);
#endif
    glGetMaterialiv(face, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetMaterialiv");
#endif
}

// void glGetPixelMapfv (GLenum map, GLfloat *values);
static inline void qglGetPixelMapfv(GLenum map, GLfloat *values)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetPixelMapfv(map=%lu, values=%p)\n", map, values);
#endif
    glGetPixelMapfv(map, values);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetPixelMapfv");
#endif
}

// void glGetPixelMapuiv (GLenum map, GLuint *values);
static inline void qglGetPixelMapuiv(GLenum map, GLuint *values)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetPixelMapuiv(map=%lu, values=%p)\n", map, values);
#endif
    glGetPixelMapuiv(map, values);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetPixelMapuiv");
#endif
}

// void glGetPixelMapusv (GLenum map, GLushort *values);
static inline void qglGetPixelMapusv(GLenum map, GLushort *values)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetPixelMapusv(map=%lu, values=%p)\n", map, values);
#endif
    glGetPixelMapusv(map, values);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetPixelMapusv");
#endif
}

// void glGetPointerv (GLenum pname, GLvoid* *params);
static inline void qglGetPointerv(GLenum pname, GLvoid* *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetPointerv(pname=%lu, params=%p)\n", pname, params);
#endif
    glGetPointerv(pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetPointerv");
#endif
}

// void glGetPolygonStipple (GLubyte *mask);
static inline void qglGetPolygonStipple(GLubyte *mask)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetPolygonStipple(mask=%p)\n", mask);
#endif
    glGetPolygonStipple(mask);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetPolygonStipple");
#endif
}

// const GLubyte * glGetString (GLenum name);
static inline const GLubyte * qglGetString(GLenum name)
{
    const GLubyte * returnValue;
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetString(name=%lu)\n", name);
#endif
    returnValue = glGetString(name);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetString");
#endif
    return returnValue;
}

// void glGetTexEnvfv (GLenum target, GLenum pname, GLfloat *params);
static inline void qglGetTexEnvfv(GLenum target, GLenum pname, GLfloat *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetTexEnvfv(target=%lu, pname=%lu, params=%p)\n", target, pname, params);
#endif
    glGetTexEnvfv(target, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetTexEnvfv");
#endif
}

// void glGetTexEnviv (GLenum target, GLenum pname, GLint *params);
static inline void qglGetTexEnviv(GLenum target, GLenum pname, GLint *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetTexEnviv(target=%lu, pname=%lu, params=%p)\n", target, pname, params);
#endif
    glGetTexEnviv(target, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetTexEnviv");
#endif
}

// void glGetTexGendv (GLenum coord, GLenum pname, GLdouble *params);
static inline void qglGetTexGendv(GLenum coord, GLenum pname, GLdouble *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetTexGendv(coord=%lu, pname=%lu, params=%p)\n", coord, pname, params);
#endif
    glGetTexGendv(coord, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetTexGendv");
#endif
}

// void glGetTexGenfv (GLenum coord, GLenum pname, GLfloat *params);
static inline void qglGetTexGenfv(GLenum coord, GLenum pname, GLfloat *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetTexGenfv(coord=%lu, pname=%lu, params=%p)\n", coord, pname, params);
#endif
    glGetTexGenfv(coord, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetTexGenfv");
#endif
}

// void glGetTexGeniv (GLenum coord, GLenum pname, GLint *params);
static inline void qglGetTexGeniv(GLenum coord, GLenum pname, GLint *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetTexGeniv(coord=%lu, pname=%lu, params=%p)\n", coord, pname, params);
#endif
    glGetTexGeniv(coord, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetTexGeniv");
#endif
}

// void glGetTexImage (GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
static inline void qglGetTexImage(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetTexImage(target=%lu, level=%ld, format=%lu, type=%lu, pixels=%p)\n", target, level, format, type, pixels);
#endif
    glGetTexImage(target, level, format, type, pixels);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetTexImage");
#endif
}

// void glGetTexLevelParameterfv (GLenum target, GLint level, GLenum pname, GLfloat *params);
static inline void qglGetTexLevelParameterfv(GLenum target, GLint level, GLenum pname, GLfloat *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetTexLevelParameterfv(target=%lu, level=%ld, pname=%lu, params=%p)\n", target, level, pname, params);
#endif
    glGetTexLevelParameterfv(target, level, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetTexLevelParameterfv");
#endif
}

// void glGetTexLevelParameteriv (GLenum target, GLint level, GLenum pname, GLint *params);
static inline void qglGetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetTexLevelParameteriv(target=%lu, level=%ld, pname=%lu, params=%p)\n", target, level, pname, params);
#endif
    glGetTexLevelParameteriv(target, level, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetTexLevelParameteriv");
#endif
}

// void glGetTexParameterfv (GLenum target, GLenum pname, GLfloat *params);
static inline void qglGetTexParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetTexParameterfv(target=%lu, pname=%lu, params=%p)\n", target, pname, params);
#endif
    glGetTexParameterfv(target, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetTexParameterfv");
#endif
}

// void glGetTexParameteriv (GLenum target, GLenum pname, GLint *params);
static inline void qglGetTexParameteriv(GLenum target, GLenum pname, GLint *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glGetTexParameteriv(target=%lu, pname=%lu, params=%p)\n", target, pname, params);
#endif
    glGetTexParameteriv(target, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glGetTexParameteriv");
#endif
}

// void glHint (GLenum target, GLenum mode);
static inline void qglHint(GLenum target, GLenum mode)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glHint(target=%lu, mode=%lu)\n", target, mode);
#endif
    glHint(target, mode);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glHint");
#endif
}

// void glIndexMask (GLuint mask);
static inline void qglIndexMask(GLuint mask)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glIndexMask(mask=%lu)\n", mask);
#endif
    glIndexMask(mask);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glIndexMask");
#endif
}

// void glIndexPointer (GLenum type, GLsizei stride, const GLvoid *pointer);
static inline void qglIndexPointer(GLenum type, GLsizei stride, const GLvoid *pointer)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glIndexPointer(type=%lu, stride=%ld, pointer=%p)\n", type, stride, pointer);
#endif
    glIndexPointer(type, stride, pointer);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glIndexPointer");
#endif
}

// void glIndexd (GLdouble c);
static inline void qglIndexd(GLdouble c)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glIndexd(c=%f)\n", c);
#endif
    glIndexd(c);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glIndexd");
#endif
}

// void glIndexdv (const GLdouble *c);
static inline void qglIndexdv(const GLdouble *c)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glIndexdv(c=%p)\n", c);
#endif
    glIndexdv(c);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glIndexdv");
#endif
}

// void glIndexf (GLfloat c);
static inline void qglIndexf(GLfloat c)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glIndexf(c=%f)\n", c);
#endif
    glIndexf(c);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glIndexf");
#endif
}

// void glIndexfv (const GLfloat *c);
static inline void qglIndexfv(const GLfloat *c)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glIndexfv(c=%p)\n", c);
#endif
    glIndexfv(c);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glIndexfv");
#endif
}

// void glIndexi (GLint c);
static inline void qglIndexi(GLint c)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glIndexi(c=%ld)\n", c);
#endif
    glIndexi(c);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glIndexi");
#endif
}

// void glIndexiv (const GLint *c);
static inline void qglIndexiv(const GLint *c)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glIndexiv(c=%p)\n", c);
#endif
    glIndexiv(c);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glIndexiv");
#endif
}

// void glIndexs (GLshort c);
static inline void qglIndexs(GLshort c)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glIndexs(c=%d)\n", c);
#endif
    glIndexs(c);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glIndexs");
#endif
}

// void glIndexsv (const GLshort *c);
static inline void qglIndexsv(const GLshort *c)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glIndexsv(c=%p)\n", c);
#endif
    glIndexsv(c);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glIndexsv");
#endif
}

// void glIndexub (GLubyte c);
static inline void qglIndexub(GLubyte c)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glIndexub(c=%u)\n", c);
#endif
    glIndexub(c);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glIndexub");
#endif
}

// void glIndexubv (const GLubyte *c);
static inline void qglIndexubv(const GLubyte *c)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glIndexubv(c=%p)\n", c);
#endif
    glIndexubv(c);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glIndexubv");
#endif
}

// void glInitNames (void);
static inline void qglInitNames(void)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glInitNames(void)\n");
#endif
    glInitNames();
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glInitNames");
#endif
}

// void glInterleavedArrays (GLenum format, GLsizei stride, const GLvoid *pointer);
static inline void qglInterleavedArrays(GLenum format, GLsizei stride, const GLvoid *pointer)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glInterleavedArrays(format=%lu, stride=%ld, pointer=%p)\n", format, stride, pointer);
#endif
    glInterleavedArrays(format, stride, pointer);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glInterleavedArrays");
#endif
}

// GLboolean glIsEnabled (GLenum cap);
static inline GLboolean qglIsEnabled(GLenum cap)
{
    GLboolean returnValue;
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glIsEnabled(cap=%lu)\n", cap);
#endif
    returnValue = glIsEnabled(cap);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glIsEnabled");
#endif
    return returnValue;
}

// GLboolean glIsList (GLuint list);
static inline GLboolean qglIsList(GLuint list)
{
    GLboolean returnValue;
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glIsList(list=%lu)\n", list);
#endif
    returnValue = glIsList(list);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glIsList");
#endif
    return returnValue;
}

// GLboolean glIsTexture (GLuint texture);
static inline GLboolean qglIsTexture(GLuint texture)
{
    GLboolean returnValue;
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glIsTexture(texture=%lu)\n", texture);
#endif
    returnValue = glIsTexture(texture);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glIsTexture");
#endif
    return returnValue;
}

// void glLightModelf (GLenum pname, GLfloat param);
static inline void qglLightModelf(GLenum pname, GLfloat param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glLightModelf(pname=%lu, param=%f)\n", pname, param);
#endif
    glLightModelf(pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glLightModelf");
#endif
}

// void glLightModelfv (GLenum pname, const GLfloat *params);
static inline void qglLightModelfv(GLenum pname, const GLfloat *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glLightModelfv(pname=%lu, params=%p)\n", pname, params);
#endif
    glLightModelfv(pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glLightModelfv");
#endif
}

// void glLightModeli (GLenum pname, GLint param);
static inline void qglLightModeli(GLenum pname, GLint param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glLightModeli(pname=%lu, param=%ld)\n", pname, param);
#endif
    glLightModeli(pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glLightModeli");
#endif
}

// void glLightModeliv (GLenum pname, const GLint *params);
static inline void qglLightModeliv(GLenum pname, const GLint *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glLightModeliv(pname=%lu, params=%p)\n", pname, params);
#endif
    glLightModeliv(pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glLightModeliv");
#endif
}

// void glLightf (GLenum light, GLenum pname, GLfloat param);
static inline void qglLightf(GLenum light, GLenum pname, GLfloat param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glLightf(light=%lu, pname=%lu, param=%f)\n", light, pname, param);
#endif
    glLightf(light, pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glLightf");
#endif
}

// void glLightfv (GLenum light, GLenum pname, const GLfloat *params);
static inline void qglLightfv(GLenum light, GLenum pname, const GLfloat *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glLightfv(light=%lu, pname=%lu, params=%p)\n", light, pname, params);
#endif
    glLightfv(light, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glLightfv");
#endif
}

// void glLighti (GLenum light, GLenum pname, GLint param);
static inline void qglLighti(GLenum light, GLenum pname, GLint param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glLighti(light=%lu, pname=%lu, param=%ld)\n", light, pname, param);
#endif
    glLighti(light, pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glLighti");
#endif
}

// void glLightiv (GLenum light, GLenum pname, const GLint *params);
static inline void qglLightiv(GLenum light, GLenum pname, const GLint *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glLightiv(light=%lu, pname=%lu, params=%p)\n", light, pname, params);
#endif
    glLightiv(light, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glLightiv");
#endif
}

// void glLineStipple (GLint factor, GLushort pattern);
static inline void qglLineStipple(GLint factor, GLushort pattern)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glLineStipple(factor=%ld, pattern=%u)\n", factor, pattern);
#endif
    glLineStipple(factor, pattern);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glLineStipple");
#endif
}

// void glLineWidth (GLfloat width);
static inline void qglLineWidth(GLfloat width)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glLineWidth(width=%f)\n", width);
#endif
    glLineWidth(width);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glLineWidth");
#endif
}

// void glListBase (GLuint base);
static inline void qglListBase(GLuint base)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glListBase(base=%lu)\n", base);
#endif
    glListBase(base);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glListBase");
#endif
}

// void glLoadIdentity (void);
static inline void qglLoadIdentity(void)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glLoadIdentity(void)\n");
#endif
    glLoadIdentity();
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glLoadIdentity");
#endif
}

// void glLoadMatrixd (const GLdouble *m);
static inline void qglLoadMatrixd(const GLdouble *m)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glLoadMatrixd(m=%p)\n", m);
#endif
    glLoadMatrixd(m);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glLoadMatrixd");
#endif
}

// void glLoadMatrixf (const GLfloat *m);
static inline void qglLoadMatrixf(const GLfloat *m)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glLoadMatrixf(m=%p)\n", m);
#endif
    glLoadMatrixf(m);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glLoadMatrixf");
#endif
}

// void glLoadName (GLuint name);
static inline void qglLoadName(GLuint name)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glLoadName(name=%lu)\n", name);
#endif
    glLoadName(name);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glLoadName");
#endif
}

// void glLogicOp (GLenum opcode);
static inline void qglLogicOp(GLenum opcode)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glLogicOp(opcode=%lu)\n", opcode);
#endif
    glLogicOp(opcode);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glLogicOp");
#endif
}

// void glMap1d (GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points);
static inline void qglMap1d(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glMap1d(target=%lu, u1=%f, u2=%f, stride=%ld, order=%ld, points=%p)\n", target, u1, u2, stride, order, points);
#endif
    glMap1d(target, u1, u2, stride, order, points);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glMap1d");
#endif
}

// void glMap1f (GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points);
static inline void qglMap1f(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glMap1f(target=%lu, u1=%f, u2=%f, stride=%ld, order=%ld, points=%p)\n", target, u1, u2, stride, order, points);
#endif
    glMap1f(target, u1, u2, stride, order, points);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glMap1f");
#endif
}

// void glMap2d (GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points);
static inline void qglMap2d(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glMap2d(target=%lu, u1=%f, u2=%f, ustride=%ld, uorder=%ld, v1=%f, v2=%f, vstride=%ld, vorder=%ld, points=%p)\n", target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
#endif
    glMap2d(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glMap2d");
#endif
}

// void glMap2f (GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points);
static inline void qglMap2f(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glMap2f(target=%lu, u1=%f, u2=%f, ustride=%ld, uorder=%ld, v1=%f, v2=%f, vstride=%ld, vorder=%ld, points=%p)\n", target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
#endif
    glMap2f(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glMap2f");
#endif
}

// void glMapGrid1d (GLint un, GLdouble u1, GLdouble u2);
static inline void qglMapGrid1d(GLint un, GLdouble u1, GLdouble u2)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glMapGrid1d(un=%ld, u1=%f, u2=%f)\n", un, u1, u2);
#endif
    glMapGrid1d(un, u1, u2);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glMapGrid1d");
#endif
}

// void glMapGrid1f (GLint un, GLfloat u1, GLfloat u2);
static inline void qglMapGrid1f(GLint un, GLfloat u1, GLfloat u2)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glMapGrid1f(un=%ld, u1=%f, u2=%f)\n", un, u1, u2);
#endif
    glMapGrid1f(un, u1, u2);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glMapGrid1f");
#endif
}

// void glMapGrid2d (GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2);
static inline void qglMapGrid2d(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glMapGrid2d(un=%ld, u1=%f, u2=%f, vn=%ld, v1=%f, v2=%f)\n", un, u1, u2, vn, v1, v2);
#endif
    glMapGrid2d(un, u1, u2, vn, v1, v2);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glMapGrid2d");
#endif
}

// void glMapGrid2f (GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2);
static inline void qglMapGrid2f(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glMapGrid2f(un=%ld, u1=%f, u2=%f, vn=%ld, v1=%f, v2=%f)\n", un, u1, u2, vn, v1, v2);
#endif
    glMapGrid2f(un, u1, u2, vn, v1, v2);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glMapGrid2f");
#endif
}

// void glMaterialf (GLenum face, GLenum pname, GLfloat param);
static inline void qglMaterialf(GLenum face, GLenum pname, GLfloat param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glMaterialf(face=%lu, pname=%lu, param=%f)\n", face, pname, param);
#endif
    glMaterialf(face, pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glMaterialf");
#endif
}

// void glMaterialfv (GLenum face, GLenum pname, const GLfloat *params);
static inline void qglMaterialfv(GLenum face, GLenum pname, const GLfloat *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glMaterialfv(face=%lu, pname=%lu, params=%p)\n", face, pname, params);
#endif
    glMaterialfv(face, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glMaterialfv");
#endif
}

// void glMateriali (GLenum face, GLenum pname, GLint param);
static inline void qglMateriali(GLenum face, GLenum pname, GLint param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glMateriali(face=%lu, pname=%lu, param=%ld)\n", face, pname, param);
#endif
    glMateriali(face, pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glMateriali");
#endif
}

// void glMaterialiv (GLenum face, GLenum pname, const GLint *params);
static inline void qglMaterialiv(GLenum face, GLenum pname, const GLint *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glMaterialiv(face=%lu, pname=%lu, params=%p)\n", face, pname, params);
#endif
    glMaterialiv(face, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glMaterialiv");
#endif
}

// void glMatrixMode (GLenum mode);
static inline void qglMatrixMode(GLenum mode)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glMatrixMode(mode=%lu)\n", mode);
#endif
    glMatrixMode(mode);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glMatrixMode");
#endif
}

// void glMultMatrixd (const GLdouble *m);
static inline void qglMultMatrixd(const GLdouble *m)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glMultMatrixd(m=%p)\n", m);
#endif
    glMultMatrixd(m);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glMultMatrixd");
#endif
}

// void glMultMatrixf (const GLfloat *m);
static inline void qglMultMatrixf(const GLfloat *m)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glMultMatrixf(m=%p)\n", m);
#endif
    glMultMatrixf(m);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glMultMatrixf");
#endif
}

// void glNewList (GLuint list, GLenum mode);
static inline void qglNewList(GLuint list, GLenum mode)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glNewList(list=%lu, mode=%lu)\n", list, mode);
#endif
    glNewList(list, mode);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glNewList");
#endif
}

// void glNormal3b (GLbyte nx, GLbyte ny, GLbyte nz);
static inline void qglNormal3b(GLbyte nx, GLbyte ny, GLbyte nz)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glNormal3b(nx=%d, ny=%d, nz=%d)\n", nx, ny, nz);
#endif
    glNormal3b(nx, ny, nz);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glNormal3b");
#endif
}

// void glNormal3bv (const GLbyte *v);
static inline void qglNormal3bv(const GLbyte *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glNormal3bv(v=%p)\n", v);
#endif
    glNormal3bv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glNormal3bv");
#endif
}

// void glNormal3d (GLdouble nx, GLdouble ny, GLdouble nz);
static inline void qglNormal3d(GLdouble nx, GLdouble ny, GLdouble nz)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glNormal3d(nx=%f, ny=%f, nz=%f)\n", nx, ny, nz);
#endif
    glNormal3d(nx, ny, nz);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glNormal3d");
#endif
}

// void glNormal3dv (const GLdouble *v);
static inline void qglNormal3dv(const GLdouble *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glNormal3dv(v=%p)\n", v);
#endif
    glNormal3dv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glNormal3dv");
#endif
}

// void glNormal3f (GLfloat nx, GLfloat ny, GLfloat nz);
static inline void qglNormal3f(GLfloat nx, GLfloat ny, GLfloat nz)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glNormal3f(nx=%f, ny=%f, nz=%f)\n", nx, ny, nz);
#endif
    glNormal3f(nx, ny, nz);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glNormal3f");
#endif
}

// void glNormal3fv (const GLfloat *v);
static inline void qglNormal3fv(const GLfloat *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glNormal3fv(v=%p)\n", v);
#endif
    glNormal3fv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glNormal3fv");
#endif
}

// void glNormal3i (GLint nx, GLint ny, GLint nz);
static inline void qglNormal3i(GLint nx, GLint ny, GLint nz)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glNormal3i(nx=%ld, ny=%ld, nz=%ld)\n", nx, ny, nz);
#endif
    glNormal3i(nx, ny, nz);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glNormal3i");
#endif
}

// void glNormal3iv (const GLint *v);
static inline void qglNormal3iv(const GLint *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glNormal3iv(v=%p)\n", v);
#endif
    glNormal3iv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glNormal3iv");
#endif
}

// void glNormal3s (GLshort nx, GLshort ny, GLshort nz);
static inline void qglNormal3s(GLshort nx, GLshort ny, GLshort nz)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glNormal3s(nx=%d, ny=%d, nz=%d)\n", nx, ny, nz);
#endif
    glNormal3s(nx, ny, nz);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glNormal3s");
#endif
}

// void glNormal3sv (const GLshort *v);
static inline void qglNormal3sv(const GLshort *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glNormal3sv(v=%p)\n", v);
#endif
    glNormal3sv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glNormal3sv");
#endif
}

// void glNormalPointer (GLenum type, GLsizei stride, const GLvoid *pointer);
static inline void qglNormalPointer(GLenum type, GLsizei stride, const GLvoid *pointer)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glNormalPointer(type=%lu, stride=%ld, pointer=%p)\n", type, stride, pointer);
#endif
    glNormalPointer(type, stride, pointer);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glNormalPointer");
#endif
}

// void glOrtho (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
static inline void qglOrtho(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glOrtho(left=%f, right=%f, bottom=%f, top=%f, zNear=%f, zFar=%f)\n", left, right, bottom, top, zNear, zFar);
#endif
    glOrtho(left, right, bottom, top, zNear, zFar);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glOrtho");
#endif
}

// void glPassThrough (GLfloat token);
static inline void qglPassThrough(GLfloat token)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPassThrough(token=%f)\n", token);
#endif
    glPassThrough(token);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPassThrough");
#endif
}

// void glPixelMapfv (GLenum map, GLsizei mapsize, const GLfloat *values);
static inline void qglPixelMapfv(GLenum map, GLsizei mapsize, const GLfloat *values)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPixelMapfv(map=%lu, mapsize=%ld, values=%p)\n", map, mapsize, values);
#endif
    glPixelMapfv(map, mapsize, values);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPixelMapfv");
#endif
}

// void glPixelMapuiv (GLenum map, GLsizei mapsize, const GLuint *values);
static inline void qglPixelMapuiv(GLenum map, GLsizei mapsize, const GLuint *values)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPixelMapuiv(map=%lu, mapsize=%ld, values=%p)\n", map, mapsize, values);
#endif
    glPixelMapuiv(map, mapsize, values);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPixelMapuiv");
#endif
}

// void glPixelMapusv (GLenum map, GLsizei mapsize, const GLushort *values);
static inline void qglPixelMapusv(GLenum map, GLsizei mapsize, const GLushort *values)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPixelMapusv(map=%lu, mapsize=%ld, values=%p)\n", map, mapsize, values);
#endif
    glPixelMapusv(map, mapsize, values);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPixelMapusv");
#endif
}

// void glPixelStoref (GLenum pname, GLfloat param);
static inline void qglPixelStoref(GLenum pname, GLfloat param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPixelStoref(pname=%lu, param=%f)\n", pname, param);
#endif
    glPixelStoref(pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPixelStoref");
#endif
}

// void glPixelStorei (GLenum pname, GLint param);
static inline void qglPixelStorei(GLenum pname, GLint param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPixelStorei(pname=%lu, param=%ld)\n", pname, param);
#endif
    glPixelStorei(pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPixelStorei");
#endif
}

// void glPixelTransferf (GLenum pname, GLfloat param);
static inline void qglPixelTransferf(GLenum pname, GLfloat param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPixelTransferf(pname=%lu, param=%f)\n", pname, param);
#endif
    glPixelTransferf(pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPixelTransferf");
#endif
}

// void glPixelTransferi (GLenum pname, GLint param);
static inline void qglPixelTransferi(GLenum pname, GLint param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPixelTransferi(pname=%lu, param=%ld)\n", pname, param);
#endif
    glPixelTransferi(pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPixelTransferi");
#endif
}

// void glPixelZoom (GLfloat xfactor, GLfloat yfactor);
static inline void qglPixelZoom(GLfloat xfactor, GLfloat yfactor)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPixelZoom(xfactor=%f, yfactor=%f)\n", xfactor, yfactor);
#endif
    glPixelZoom(xfactor, yfactor);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPixelZoom");
#endif
}

// void glPointSize (GLfloat size);
static inline void qglPointSize(GLfloat size)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPointSize(size=%f)\n", size);
#endif
    glPointSize(size);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPointSize");
#endif
}

// void glPolygonMode (GLenum face, GLenum mode);
static inline void qglPolygonMode(GLenum face, GLenum mode)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPolygonMode(face=%lu, mode=%lu)\n", face, mode);
#endif
    glPolygonMode(face, mode);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPolygonMode");
#endif
}

// void glPolygonOffset (GLfloat factor, GLfloat units);
static inline void qglPolygonOffset(GLfloat factor, GLfloat units)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPolygonOffset(factor=%f, units=%f)\n", factor, units);
#endif
    glPolygonOffset(factor, units);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPolygonOffset");
#endif
}

// void glPolygonStipple (const GLubyte *mask);
static inline void qglPolygonStipple(const GLubyte *mask)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPolygonStipple(mask=%p)\n", mask);
#endif
    glPolygonStipple(mask);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPolygonStipple");
#endif
}

// void glPopAttrib (void);
static inline void qglPopAttrib(void)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPopAttrib(void)\n");
#endif
    glPopAttrib();
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPopAttrib");
#endif
}

// void glPopClientAttrib (void);
static inline void qglPopClientAttrib(void)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPopClientAttrib(void)\n");
#endif
    glPopClientAttrib();
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPopClientAttrib");
#endif
}

// void glPopMatrix (void);
static inline void qglPopMatrix(void)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPopMatrix(void)\n");
#endif
    glPopMatrix();
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPopMatrix");
#endif
}

// void glPopName (void);
static inline void qglPopName(void)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPopName(void)\n");
#endif
    glPopName();
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPopName");
#endif
}

// void glPrioritizeTextures (GLsizei n, const GLuint *textures, const GLclampf *priorities);
static inline void qglPrioritizeTextures(GLsizei n, const GLuint *textures, const GLclampf *priorities)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPrioritizeTextures(n=%ld, textures=%p, priorities=%p)\n", n, textures, priorities);
#endif
    glPrioritizeTextures(n, textures, priorities);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPrioritizeTextures");
#endif
}

// void glPushAttrib (GLbitfield mask);
static inline void qglPushAttrib(GLbitfield mask)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPushAttrib(mask=%lu)\n", mask);
#endif
    glPushAttrib(mask);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPushAttrib");
#endif
}

// void glPushClientAttrib (GLbitfield mask);
static inline void qglPushClientAttrib(GLbitfield mask)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPushClientAttrib(mask=%lu)\n", mask);
#endif
    glPushClientAttrib(mask);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPushClientAttrib");
#endif
}

// void glPushMatrix (void);
static inline void qglPushMatrix(void)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPushMatrix(void)\n");
#endif
    glPushMatrix();
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPushMatrix");
#endif
}

// void glPushName (GLuint name);
static inline void qglPushName(GLuint name)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glPushName(name=%lu)\n", name);
#endif
    glPushName(name);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glPushName");
#endif
}

// void glRasterPos2d (GLdouble x, GLdouble y);
static inline void qglRasterPos2d(GLdouble x, GLdouble y)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos2d(x=%f, y=%f)\n", x, y);
#endif
    glRasterPos2d(x, y);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos2d");
#endif
}

// void glRasterPos2dv (const GLdouble *v);
static inline void qglRasterPos2dv(const GLdouble *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos2dv(v=%p)\n", v);
#endif
    glRasterPos2dv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos2dv");
#endif
}

// void glRasterPos2f (GLfloat x, GLfloat y);
static inline void qglRasterPos2f(GLfloat x, GLfloat y)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos2f(x=%f, y=%f)\n", x, y);
#endif
    glRasterPos2f(x, y);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos2f");
#endif
}

// void glRasterPos2fv (const GLfloat *v);
static inline void qglRasterPos2fv(const GLfloat *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos2fv(v=%p)\n", v);
#endif
    glRasterPos2fv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos2fv");
#endif
}

// void glRasterPos2i (GLint x, GLint y);
static inline void qglRasterPos2i(GLint x, GLint y)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos2i(x=%ld, y=%ld)\n", x, y);
#endif
    glRasterPos2i(x, y);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos2i");
#endif
}

// void glRasterPos2iv (const GLint *v);
static inline void qglRasterPos2iv(const GLint *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos2iv(v=%p)\n", v);
#endif
    glRasterPos2iv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos2iv");
#endif
}

// void glRasterPos2s (GLshort x, GLshort y);
static inline void qglRasterPos2s(GLshort x, GLshort y)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos2s(x=%d, y=%d)\n", x, y);
#endif
    glRasterPos2s(x, y);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos2s");
#endif
}

// void glRasterPos2sv (const GLshort *v);
static inline void qglRasterPos2sv(const GLshort *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos2sv(v=%p)\n", v);
#endif
    glRasterPos2sv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos2sv");
#endif
}

// void glRasterPos3d (GLdouble x, GLdouble y, GLdouble z);
static inline void qglRasterPos3d(GLdouble x, GLdouble y, GLdouble z)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos3d(x=%f, y=%f, z=%f)\n", x, y, z);
#endif
    glRasterPos3d(x, y, z);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos3d");
#endif
}

// void glRasterPos3dv (const GLdouble *v);
static inline void qglRasterPos3dv(const GLdouble *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos3dv(v=%p)\n", v);
#endif
    glRasterPos3dv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos3dv");
#endif
}

// void glRasterPos3f (GLfloat x, GLfloat y, GLfloat z);
static inline void qglRasterPos3f(GLfloat x, GLfloat y, GLfloat z)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos3f(x=%f, y=%f, z=%f)\n", x, y, z);
#endif
    glRasterPos3f(x, y, z);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos3f");
#endif
}

// void glRasterPos3fv (const GLfloat *v);
static inline void qglRasterPos3fv(const GLfloat *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos3fv(v=%p)\n", v);
#endif
    glRasterPos3fv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos3fv");
#endif
}

// void glRasterPos3i (GLint x, GLint y, GLint z);
static inline void qglRasterPos3i(GLint x, GLint y, GLint z)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos3i(x=%ld, y=%ld, z=%ld)\n", x, y, z);
#endif
    glRasterPos3i(x, y, z);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos3i");
#endif
}

// void glRasterPos3iv (const GLint *v);
static inline void qglRasterPos3iv(const GLint *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos3iv(v=%p)\n", v);
#endif
    glRasterPos3iv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos3iv");
#endif
}

// void glRasterPos3s (GLshort x, GLshort y, GLshort z);
static inline void qglRasterPos3s(GLshort x, GLshort y, GLshort z)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos3s(x=%d, y=%d, z=%d)\n", x, y, z);
#endif
    glRasterPos3s(x, y, z);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos3s");
#endif
}

// void glRasterPos3sv (const GLshort *v);
static inline void qglRasterPos3sv(const GLshort *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos3sv(v=%p)\n", v);
#endif
    glRasterPos3sv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos3sv");
#endif
}

// void glRasterPos4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
static inline void qglRasterPos4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos4d(x=%f, y=%f, z=%f, w=%f)\n", x, y, z, w);
#endif
    glRasterPos4d(x, y, z, w);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos4d");
#endif
}

// void glRasterPos4dv (const GLdouble *v);
static inline void qglRasterPos4dv(const GLdouble *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos4dv(v=%p)\n", v);
#endif
    glRasterPos4dv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos4dv");
#endif
}

// void glRasterPos4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
static inline void qglRasterPos4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos4f(x=%f, y=%f, z=%f, w=%f)\n", x, y, z, w);
#endif
    glRasterPos4f(x, y, z, w);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos4f");
#endif
}

// void glRasterPos4fv (const GLfloat *v);
static inline void qglRasterPos4fv(const GLfloat *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos4fv(v=%p)\n", v);
#endif
    glRasterPos4fv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos4fv");
#endif
}

// void glRasterPos4i (GLint x, GLint y, GLint z, GLint w);
static inline void qglRasterPos4i(GLint x, GLint y, GLint z, GLint w)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos4i(x=%ld, y=%ld, z=%ld, w=%ld)\n", x, y, z, w);
#endif
    glRasterPos4i(x, y, z, w);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos4i");
#endif
}

// void glRasterPos4iv (const GLint *v);
static inline void qglRasterPos4iv(const GLint *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos4iv(v=%p)\n", v);
#endif
    glRasterPos4iv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos4iv");
#endif
}

// void glRasterPos4s (GLshort x, GLshort y, GLshort z, GLshort w);
static inline void qglRasterPos4s(GLshort x, GLshort y, GLshort z, GLshort w)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos4s(x=%d, y=%d, z=%d, w=%d)\n", x, y, z, w);
#endif
    glRasterPos4s(x, y, z, w);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos4s");
#endif
}

// void glRasterPos4sv (const GLshort *v);
static inline void qglRasterPos4sv(const GLshort *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRasterPos4sv(v=%p)\n", v);
#endif
    glRasterPos4sv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRasterPos4sv");
#endif
}

// void glReadBuffer (GLenum mode);
static inline void qglReadBuffer(GLenum mode)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glReadBuffer(mode=%lu)\n", mode);
#endif
    glReadBuffer(mode);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glReadBuffer");
#endif
}

// void glReadPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
static inline void qglReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glReadPixels(x=%ld, y=%ld, width=%ld, height=%ld, format=%lu, type=%lu, pixels=%p)\n", x, y, width, height, format, type, pixels);
#endif
    glReadPixels(x, y, width, height, format, type, pixels);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glReadPixels");
#endif
}

// void glRectd (GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2);
static inline void qglRectd(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRectd(x1=%f, y1=%f, x2=%f, y2=%f)\n", x1, y1, x2, y2);
#endif
    glRectd(x1, y1, x2, y2);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRectd");
#endif
}

// void glRectdv (const GLdouble *v1, const GLdouble *v2);
static inline void qglRectdv(const GLdouble *v1, const GLdouble *v2)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRectdv(v1=%p, v2=%p)\n", v1, v2);
#endif
    glRectdv(v1, v2);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRectdv");
#endif
}

// void glRectf (GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2);
static inline void qglRectf(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRectf(x1=%f, y1=%f, x2=%f, y2=%f)\n", x1, y1, x2, y2);
#endif
    glRectf(x1, y1, x2, y2);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRectf");
#endif
}

// void glRectfv (const GLfloat *v1, const GLfloat *v2);
static inline void qglRectfv(const GLfloat *v1, const GLfloat *v2)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRectfv(v1=%p, v2=%p)\n", v1, v2);
#endif
    glRectfv(v1, v2);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRectfv");
#endif
}

// void glRecti (GLint x1, GLint y1, GLint x2, GLint y2);
static inline void qglRecti(GLint x1, GLint y1, GLint x2, GLint y2)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRecti(x1=%ld, y1=%ld, x2=%ld, y2=%ld)\n", x1, y1, x2, y2);
#endif
    glRecti(x1, y1, x2, y2);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRecti");
#endif
}

// void glRectiv (const GLint *v1, const GLint *v2);
static inline void qglRectiv(const GLint *v1, const GLint *v2)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRectiv(v1=%p, v2=%p)\n", v1, v2);
#endif
    glRectiv(v1, v2);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRectiv");
#endif
}

// void glRects (GLshort x1, GLshort y1, GLshort x2, GLshort y2);
static inline void qglRects(GLshort x1, GLshort y1, GLshort x2, GLshort y2)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRects(x1=%d, y1=%d, x2=%d, y2=%d)\n", x1, y1, x2, y2);
#endif
    glRects(x1, y1, x2, y2);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRects");
#endif
}

// void glRectsv (const GLshort *v1, const GLshort *v2);
static inline void qglRectsv(const GLshort *v1, const GLshort *v2)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRectsv(v1=%p, v2=%p)\n", v1, v2);
#endif
    glRectsv(v1, v2);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRectsv");
#endif
}

// GLint glRenderMode (GLenum mode);
static inline GLint qglRenderMode(GLenum mode)
{
    GLint returnValue;
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRenderMode(mode=%lu)\n", mode);
#endif
    returnValue = glRenderMode(mode);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRenderMode");
#endif
    return returnValue;
}

// void glRotated (GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
static inline void qglRotated(GLdouble angle, GLdouble x, GLdouble y, GLdouble z)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRotated(angle=%f, x=%f, y=%f, z=%f)\n", angle, x, y, z);
#endif
    glRotated(angle, x, y, z);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRotated");
#endif
}

// void glRotatef (GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
static inline void qglRotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glRotatef(angle=%f, x=%f, y=%f, z=%f)\n", angle, x, y, z);
#endif
    glRotatef(angle, x, y, z);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glRotatef");
#endif
}

// void glScaled (GLdouble x, GLdouble y, GLdouble z);
static inline void qglScaled(GLdouble x, GLdouble y, GLdouble z)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glScaled(x=%f, y=%f, z=%f)\n", x, y, z);
#endif
    glScaled(x, y, z);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glScaled");
#endif
}

// void glScalef (GLfloat x, GLfloat y, GLfloat z);
static inline void qglScalef(GLfloat x, GLfloat y, GLfloat z)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glScalef(x=%f, y=%f, z=%f)\n", x, y, z);
#endif
    glScalef(x, y, z);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glScalef");
#endif
}

// void glScissor (GLint x, GLint y, GLsizei width, GLsizei height);
static inline void qglScissor(GLint x, GLint y, GLsizei width, GLsizei height)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glScissor(x=%ld, y=%ld, width=%ld, height=%ld)\n", x, y, width, height);
#endif
    glScissor(x, y, width, height);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glScissor");
#endif
}

// void glSelectBuffer (GLsizei size, GLuint *buffer);
static inline void qglSelectBuffer(GLsizei size, GLuint *buffer)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glSelectBuffer(size=%ld, buffer=%p)\n", size, buffer);
#endif
    glSelectBuffer(size, buffer);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glSelectBuffer");
#endif
}

// void glShadeModel (GLenum mode);
static inline void qglShadeModel(GLenum mode)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glShadeModel(mode=%lu)\n", mode);
#endif
    glShadeModel(mode);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glShadeModel");
#endif
}

// void glStencilFunc (GLenum func, GLint ref, GLuint mask);
static inline void qglStencilFunc(GLenum func, GLint ref, GLuint mask)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glStencilFunc(func=%lu, ref=%ld, mask=%lu)\n", func, ref, mask);
#endif
    glStencilFunc(func, ref, mask);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glStencilFunc");
#endif
}

// void glStencilMask (GLuint mask);
static inline void qglStencilMask(GLuint mask)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glStencilMask(mask=%lu)\n", mask);
#endif
    glStencilMask(mask);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glStencilMask");
#endif
}

// void glStencilOp (GLenum fail, GLenum zfail, GLenum zpass);
static inline void qglStencilOp(GLenum fail, GLenum zfail, GLenum zpass)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glStencilOp(fail=%lu, zfail=%lu, zpass=%lu)\n", fail, zfail, zpass);
#endif
    glStencilOp(fail, zfail, zpass);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glStencilOp");
#endif
}

// void glTexCoord1d (GLdouble s);
static inline void qglTexCoord1d(GLdouble s)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord1d(s=%f)\n", s);
#endif
    glTexCoord1d(s);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord1d");
#endif
}

// void glTexCoord1dv (const GLdouble *v);
static inline void qglTexCoord1dv(const GLdouble *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord1dv(v=%p)\n", v);
#endif
    glTexCoord1dv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord1dv");
#endif
}

// void glTexCoord1f (GLfloat s);
static inline void qglTexCoord1f(GLfloat s)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord1f(s=%f)\n", s);
#endif
    glTexCoord1f(s);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord1f");
#endif
}

// void glTexCoord1fv (const GLfloat *v);
static inline void qglTexCoord1fv(const GLfloat *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord1fv(v=%p)\n", v);
#endif
    glTexCoord1fv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord1fv");
#endif
}

// void glTexCoord1i (GLint s);
static inline void qglTexCoord1i(GLint s)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord1i(s=%ld)\n", s);
#endif
    glTexCoord1i(s);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord1i");
#endif
}

// void glTexCoord1iv (const GLint *v);
static inline void qglTexCoord1iv(const GLint *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord1iv(v=%p)\n", v);
#endif
    glTexCoord1iv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord1iv");
#endif
}

// void glTexCoord1s (GLshort s);
static inline void qglTexCoord1s(GLshort s)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord1s(s=%d)\n", s);
#endif
    glTexCoord1s(s);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord1s");
#endif
}

// void glTexCoord1sv (const GLshort *v);
static inline void qglTexCoord1sv(const GLshort *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord1sv(v=%p)\n", v);
#endif
    glTexCoord1sv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord1sv");
#endif
}

// void glTexCoord2d (GLdouble s, GLdouble t);
static inline void qglTexCoord2d(GLdouble s, GLdouble t)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord2d(s=%f, t=%f)\n", s, t);
#endif
    glTexCoord2d(s, t);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord2d");
#endif
}

// void glTexCoord2dv (const GLdouble *v);
static inline void qglTexCoord2dv(const GLdouble *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord2dv(v=%p)\n", v);
#endif
    glTexCoord2dv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord2dv");
#endif
}

// void glTexCoord2f (GLfloat s, GLfloat t);
static inline void qglTexCoord2f(GLfloat s, GLfloat t)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord2f(s=%f, t=%f)\n", s, t);
#endif
    glTexCoord2f(s, t);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord2f");
#endif
}

// void glTexCoord2fv (const GLfloat *v);
static inline void qglTexCoord2fv(const GLfloat *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord2fv(v=%p)\n", v);
#endif
    glTexCoord2fv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord2fv");
#endif
}

// void glTexCoord2i (GLint s, GLint t);
static inline void qglTexCoord2i(GLint s, GLint t)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord2i(s=%ld, t=%ld)\n", s, t);
#endif
    glTexCoord2i(s, t);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord2i");
#endif
}

// void glTexCoord2iv (const GLint *v);
static inline void qglTexCoord2iv(const GLint *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord2iv(v=%p)\n", v);
#endif
    glTexCoord2iv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord2iv");
#endif
}

// void glTexCoord2s (GLshort s, GLshort t);
static inline void qglTexCoord2s(GLshort s, GLshort t)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord2s(s=%d, t=%d)\n", s, t);
#endif
    glTexCoord2s(s, t);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord2s");
#endif
}

// void glTexCoord2sv (const GLshort *v);
static inline void qglTexCoord2sv(const GLshort *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord2sv(v=%p)\n", v);
#endif
    glTexCoord2sv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord2sv");
#endif
}

// void glTexCoord3d (GLdouble s, GLdouble t, GLdouble r);
static inline void qglTexCoord3d(GLdouble s, GLdouble t, GLdouble r)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord3d(s=%f, t=%f, r=%f)\n", s, t, r);
#endif
    glTexCoord3d(s, t, r);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord3d");
#endif
}

// void glTexCoord3dv (const GLdouble *v);
static inline void qglTexCoord3dv(const GLdouble *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord3dv(v=%p)\n", v);
#endif
    glTexCoord3dv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord3dv");
#endif
}

// void glTexCoord3f (GLfloat s, GLfloat t, GLfloat r);
static inline void qglTexCoord3f(GLfloat s, GLfloat t, GLfloat r)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord3f(s=%f, t=%f, r=%f)\n", s, t, r);
#endif
    glTexCoord3f(s, t, r);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord3f");
#endif
}

// void glTexCoord3fv (const GLfloat *v);
static inline void qglTexCoord3fv(const GLfloat *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord3fv(v=%p)\n", v);
#endif
    glTexCoord3fv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord3fv");
#endif
}

// void glTexCoord3i (GLint s, GLint t, GLint r);
static inline void qglTexCoord3i(GLint s, GLint t, GLint r)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord3i(s=%ld, t=%ld, r=%ld)\n", s, t, r);
#endif
    glTexCoord3i(s, t, r);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord3i");
#endif
}

// void glTexCoord3iv (const GLint *v);
static inline void qglTexCoord3iv(const GLint *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord3iv(v=%p)\n", v);
#endif
    glTexCoord3iv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord3iv");
#endif
}

// void glTexCoord3s (GLshort s, GLshort t, GLshort r);
static inline void qglTexCoord3s(GLshort s, GLshort t, GLshort r)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord3s(s=%d, t=%d, r=%d)\n", s, t, r);
#endif
    glTexCoord3s(s, t, r);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord3s");
#endif
}

// void glTexCoord3sv (const GLshort *v);
static inline void qglTexCoord3sv(const GLshort *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord3sv(v=%p)\n", v);
#endif
    glTexCoord3sv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord3sv");
#endif
}

// void glTexCoord4d (GLdouble s, GLdouble t, GLdouble r, GLdouble q);
static inline void qglTexCoord4d(GLdouble s, GLdouble t, GLdouble r, GLdouble q)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord4d(s=%f, t=%f, r=%f, q=%f)\n", s, t, r, q);
#endif
    glTexCoord4d(s, t, r, q);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord4d");
#endif
}

// void glTexCoord4dv (const GLdouble *v);
static inline void qglTexCoord4dv(const GLdouble *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord4dv(v=%p)\n", v);
#endif
    glTexCoord4dv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord4dv");
#endif
}

// void glTexCoord4f (GLfloat s, GLfloat t, GLfloat r, GLfloat q);
static inline void qglTexCoord4f(GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord4f(s=%f, t=%f, r=%f, q=%f)\n", s, t, r, q);
#endif
    glTexCoord4f(s, t, r, q);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord4f");
#endif
}

// void glTexCoord4fv (const GLfloat *v);
static inline void qglTexCoord4fv(const GLfloat *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord4fv(v=%p)\n", v);
#endif
    glTexCoord4fv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord4fv");
#endif
}

// void glTexCoord4i (GLint s, GLint t, GLint r, GLint q);
static inline void qglTexCoord4i(GLint s, GLint t, GLint r, GLint q)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord4i(s=%ld, t=%ld, r=%ld, q=%ld)\n", s, t, r, q);
#endif
    glTexCoord4i(s, t, r, q);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord4i");
#endif
}

// void glTexCoord4iv (const GLint *v);
static inline void qglTexCoord4iv(const GLint *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord4iv(v=%p)\n", v);
#endif
    glTexCoord4iv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord4iv");
#endif
}

// void glTexCoord4s (GLshort s, GLshort t, GLshort r, GLshort q);
static inline void qglTexCoord4s(GLshort s, GLshort t, GLshort r, GLshort q)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord4s(s=%d, t=%d, r=%d, q=%d)\n", s, t, r, q);
#endif
    glTexCoord4s(s, t, r, q);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord4s");
#endif
}

// void glTexCoord4sv (const GLshort *v);
static inline void qglTexCoord4sv(const GLshort *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoord4sv(v=%p)\n", v);
#endif
    glTexCoord4sv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoord4sv");
#endif
}

// void glTexCoordPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
static inline void qglTexCoordPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexCoordPointer(size=%ld, type=%lu, stride=%ld, pointer=%p)\n", size, type, stride, pointer);
#endif
    glTexCoordPointer(size, type, stride, pointer);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexCoordPointer");
#endif
}

// void glTexEnvf (GLenum target, GLenum pname, GLfloat param);
static inline void qglTexEnvf(GLenum target, GLenum pname, GLfloat param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexEnvf(target=%lu, pname=%lu, param=%f)\n", target, pname, param);
#endif
    glTexEnvf(target, pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexEnvf");
#endif
}

// void glTexEnvfv (GLenum target, GLenum pname, const GLfloat *params);
static inline void qglTexEnvfv(GLenum target, GLenum pname, const GLfloat *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexEnvfv(target=%lu, pname=%lu, params=%p)\n", target, pname, params);
#endif
    glTexEnvfv(target, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexEnvfv");
#endif
}

// void glTexEnvi (GLenum target, GLenum pname, GLint param);
static inline void qglTexEnvi(GLenum target, GLenum pname, GLint param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexEnvi(target=%lu, pname=%lu, param=%ld)\n", target, pname, param);
#endif
    glTexEnvi(target, pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexEnvi");
#endif
}

// void glTexEnviv (GLenum target, GLenum pname, const GLint *params);
static inline void qglTexEnviv(GLenum target, GLenum pname, const GLint *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexEnviv(target=%lu, pname=%lu, params=%p)\n", target, pname, params);
#endif
    glTexEnviv(target, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexEnviv");
#endif
}

// void glTexGend (GLenum coord, GLenum pname, GLdouble param);
static inline void qglTexGend(GLenum coord, GLenum pname, GLdouble param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexGend(coord=%lu, pname=%lu, param=%f)\n", coord, pname, param);
#endif
    glTexGend(coord, pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexGend");
#endif
}

// void glTexGendv (GLenum coord, GLenum pname, const GLdouble *params);
static inline void qglTexGendv(GLenum coord, GLenum pname, const GLdouble *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexGendv(coord=%lu, pname=%lu, params=%p)\n", coord, pname, params);
#endif
    glTexGendv(coord, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexGendv");
#endif
}

// void glTexGenf (GLenum coord, GLenum pname, GLfloat param);
static inline void qglTexGenf(GLenum coord, GLenum pname, GLfloat param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexGenf(coord=%lu, pname=%lu, param=%f)\n", coord, pname, param);
#endif
    glTexGenf(coord, pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexGenf");
#endif
}

// void glTexGenfv (GLenum coord, GLenum pname, const GLfloat *params);
static inline void qglTexGenfv(GLenum coord, GLenum pname, const GLfloat *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexGenfv(coord=%lu, pname=%lu, params=%p)\n", coord, pname, params);
#endif
    glTexGenfv(coord, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexGenfv");
#endif
}

// void glTexGeni (GLenum coord, GLenum pname, GLint param);
static inline void qglTexGeni(GLenum coord, GLenum pname, GLint param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexGeni(coord=%lu, pname=%lu, param=%ld)\n", coord, pname, param);
#endif
    glTexGeni(coord, pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexGeni");
#endif
}

// void glTexGeniv (GLenum coord, GLenum pname, const GLint *params);
static inline void qglTexGeniv(GLenum coord, GLenum pname, const GLint *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexGeniv(coord=%lu, pname=%lu, params=%p)\n", coord, pname, params);
#endif
    glTexGeniv(coord, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexGeniv");
#endif
}

// void glTexImage1D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
static inline void qglTexImage1D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexImage1D(target=%lu, level=%ld, internalformat=%ld, width=%ld, border=%ld, format=%lu, type=%lu, pixels=%p)\n", target, level, internalformat, width, border, format, type, pixels);
#endif
    glTexImage1D(target, level, internalformat, width, border, format, type, pixels);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexImage1D");
#endif
}

// void glTexImage2D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
static inline void qglTexImage2D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexImage2D(target=%lu, level=%ld, internalformat=%ld, width=%ld, height=%ld, border=%ld, format=%lu, type=%lu, pixels=%p)\n", target, level, internalformat, width, height, border, format, type, pixels);
#endif
    glTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexImage2D");
#endif
}

// void glTexParameterf (GLenum target, GLenum pname, GLfloat param);
static inline void qglTexParameterf(GLenum target, GLenum pname, GLfloat param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexParameterf(target=%lu, pname=%lu, param=%f)\n", target, pname, param);
#endif
    glTexParameterf(target, pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexParameterf");
#endif
}

// void glTexParameterfv (GLenum target, GLenum pname, const GLfloat *params);
static inline void qglTexParameterfv(GLenum target, GLenum pname, const GLfloat *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexParameterfv(target=%lu, pname=%lu, params=%p)\n", target, pname, params);
#endif
    glTexParameterfv(target, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexParameterfv");
#endif
}

// void glTexParameteri (GLenum target, GLenum pname, GLint param);
static inline void qglTexParameteri(GLenum target, GLenum pname, GLint param)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexParameteri(target=%lu, pname=%lu, param=%ld)\n", target, pname, param);
#endif
    glTexParameteri(target, pname, param);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexParameteri");
#endif
}

// void glTexParameteriv (GLenum target, GLenum pname, const GLint *params);
static inline void qglTexParameteriv(GLenum target, GLenum pname, const GLint *params)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexParameteriv(target=%lu, pname=%lu, params=%p)\n", target, pname, params);
#endif
    glTexParameteriv(target, pname, params);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexParameteriv");
#endif
}

// void glTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
static inline void qglTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexSubImage1D(target=%lu, level=%ld, xoffset=%ld, width=%ld, format=%lu, type=%lu, pixels=%p)\n", target, level, xoffset, width, format, type, pixels);
#endif
    glTexSubImage1D(target, level, xoffset, width, format, type, pixels);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexSubImage1D");
#endif
}

// void glTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
static inline void qglTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTexSubImage2D(target=%lu, level=%ld, xoffset=%ld, yoffset=%ld, width=%ld, height=%ld, format=%lu, type=%lu, pixels=%p)\n", target, level, xoffset, yoffset, width, height, format, type, pixels);
#endif
    glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTexSubImage2D");
#endif
}

// void glTranslated (GLdouble x, GLdouble y, GLdouble z);
static inline void qglTranslated(GLdouble x, GLdouble y, GLdouble z)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTranslated(x=%f, y=%f, z=%f)\n", x, y, z);
#endif
    glTranslated(x, y, z);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTranslated");
#endif
}

// void glTranslatef (GLfloat x, GLfloat y, GLfloat z);
static inline void qglTranslatef(GLfloat x, GLfloat y, GLfloat z)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glTranslatef(x=%f, y=%f, z=%f)\n", x, y, z);
#endif
    glTranslatef(x, y, z);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glTranslatef");
#endif
}

// void glVertex2d (GLdouble x, GLdouble y);
static inline void qglVertex2d(GLdouble x, GLdouble y)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex2d(x=%f, y=%f)\n", x, y);
#endif
    glVertex2d(x, y);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex2d");
#endif
}

// void glVertex2dv (const GLdouble *v);
static inline void qglVertex2dv(const GLdouble *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex2dv(v=%p)\n", v);
#endif
    glVertex2dv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex2dv");
#endif
}

// void glVertex2f (GLfloat x, GLfloat y);
static inline void qglVertex2f(GLfloat x, GLfloat y)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex2f(x=%f, y=%f)\n", x, y);
#endif
    glVertex2f(x, y);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex2f");
#endif
}

// void glVertex2fv (const GLfloat *v);
static inline void qglVertex2fv(const GLfloat *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex2fv(v=%p)\n", v);
#endif
    glVertex2fv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex2fv");
#endif
}

// void glVertex2i (GLint x, GLint y);
static inline void qglVertex2i(GLint x, GLint y)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex2i(x=%ld, y=%ld)\n", x, y);
#endif
    glVertex2i(x, y);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex2i");
#endif
}

// void glVertex2iv (const GLint *v);
static inline void qglVertex2iv(const GLint *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex2iv(v=%p)\n", v);
#endif
    glVertex2iv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex2iv");
#endif
}

// void glVertex2s (GLshort x, GLshort y);
static inline void qglVertex2s(GLshort x, GLshort y)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex2s(x=%d, y=%d)\n", x, y);
#endif
    glVertex2s(x, y);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex2s");
#endif
}

// void glVertex2sv (const GLshort *v);
static inline void qglVertex2sv(const GLshort *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex2sv(v=%p)\n", v);
#endif
    glVertex2sv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex2sv");
#endif
}

// void glVertex3d (GLdouble x, GLdouble y, GLdouble z);
static inline void qglVertex3d(GLdouble x, GLdouble y, GLdouble z)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex3d(x=%f, y=%f, z=%f)\n", x, y, z);
#endif
    glVertex3d(x, y, z);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex3d");
#endif
}

// void glVertex3dv (const GLdouble *v);
static inline void qglVertex3dv(const GLdouble *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex3dv(v=%p)\n", v);
#endif
    glVertex3dv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex3dv");
#endif
}

// void glVertex3f (GLfloat x, GLfloat y, GLfloat z);
static inline void qglVertex3f(GLfloat x, GLfloat y, GLfloat z)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex3f(x=%f, y=%f, z=%f)\n", x, y, z);
#endif
    glVertex3f(x, y, z);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex3f");
#endif
}

// void glVertex3fv (const GLfloat *v);
static inline void qglVertex3fv(const GLfloat *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex3fv(v=%p)\n", v);
#endif
    glVertex3fv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex3fv");
#endif
}

// void glVertex3i (GLint x, GLint y, GLint z);
static inline void qglVertex3i(GLint x, GLint y, GLint z)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex3i(x=%ld, y=%ld, z=%ld)\n", x, y, z);
#endif
    glVertex3i(x, y, z);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex3i");
#endif
}

// void glVertex3iv (const GLint *v);
static inline void qglVertex3iv(const GLint *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex3iv(v=%p)\n", v);
#endif
    glVertex3iv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex3iv");
#endif
}

// void glVertex3s (GLshort x, GLshort y, GLshort z);
static inline void qglVertex3s(GLshort x, GLshort y, GLshort z)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex3s(x=%d, y=%d, z=%d)\n", x, y, z);
#endif
    glVertex3s(x, y, z);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex3s");
#endif
}

// void glVertex3sv (const GLshort *v);
static inline void qglVertex3sv(const GLshort *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex3sv(v=%p)\n", v);
#endif
    glVertex3sv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex3sv");
#endif
}

// void glVertex4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
static inline void qglVertex4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex4d(x=%f, y=%f, z=%f, w=%f)\n", x, y, z, w);
#endif
    glVertex4d(x, y, z, w);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex4d");
#endif
}

// void glVertex4dv (const GLdouble *v);
static inline void qglVertex4dv(const GLdouble *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex4dv(v=%p)\n", v);
#endif
    glVertex4dv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex4dv");
#endif
}

// void glVertex4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
static inline void qglVertex4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex4f(x=%f, y=%f, z=%f, w=%f)\n", x, y, z, w);
#endif
    glVertex4f(x, y, z, w);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex4f");
#endif
}

// void glVertex4fv (const GLfloat *v);
static inline void qglVertex4fv(const GLfloat *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex4fv(v=%p)\n", v);
#endif
    glVertex4fv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex4fv");
#endif
}

// void glVertex4i (GLint x, GLint y, GLint z, GLint w);
static inline void qglVertex4i(GLint x, GLint y, GLint z, GLint w)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex4i(x=%ld, y=%ld, z=%ld, w=%ld)\n", x, y, z, w);
#endif
    glVertex4i(x, y, z, w);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex4i");
#endif
}

// void glVertex4iv (const GLint *v);
static inline void qglVertex4iv(const GLint *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex4iv(v=%p)\n", v);
#endif
    glVertex4iv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex4iv");
#endif
}

// void glVertex4s (GLshort x, GLshort y, GLshort z, GLshort w);
static inline void qglVertex4s(GLshort x, GLshort y, GLshort z, GLshort w)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex4s(x=%d, y=%d, z=%d, w=%d)\n", x, y, z, w);
#endif
    glVertex4s(x, y, z, w);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex4s");
#endif
}

// void glVertex4sv (const GLshort *v);
static inline void qglVertex4sv(const GLshort *v)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertex4sv(v=%p)\n", v);
#endif
    glVertex4sv(v);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertex4sv");
#endif
}

// void glVertexPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
static inline void qglVertexPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glVertexPointer(size=%ld, type=%lu, stride=%ld, pointer=%p)\n", size, type, stride, pointer);
#endif
    glVertexPointer(size, type, stride, pointer);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glVertexPointer");
#endif
}

// void glViewport (GLint x, GLint y, GLsizei width, GLsizei height);
static inline void qglViewport(GLint x, GLint y, GLsizei width, GLsizei height)
{
#if !defined(NDEBUG) && defined(QGL_LOG_GL_CALLS)
    if (QGLLogGLCalls)
        fprintf(QGLDebugFile(), "glViewport(x=%ld, y=%ld, width=%ld, height=%ld)\n", x, y, width, height);
#endif
    glViewport(x, y, width, height);
#if !defined(NDEBUG) && defined(QGL_CHECK_GL_ERRORS)
    if (!QGLBeginStarted)
        QGLCheckError("glViewport");
#endif
}

// Prevent calls to the 'normal' GL functions
#define glAccum CALL_THE_QGL_VERSION_OF_glAccum
#define glAlphaFunc CALL_THE_QGL_VERSION_OF_glAlphaFunc
#define glAreTexturesResident CALL_THE_QGL_VERSION_OF_glAreTexturesResident
#define glArrayElement CALL_THE_QGL_VERSION_OF_glArrayElement
#define glBegin CALL_THE_QGL_VERSION_OF_glBegin
#define glBindTexture CALL_THE_QGL_VERSION_OF_glBindTexture
#define glBitmap CALL_THE_QGL_VERSION_OF_glBitmap
#define glBlendFunc CALL_THE_QGL_VERSION_OF_glBlendFunc
#define glCallList CALL_THE_QGL_VERSION_OF_glCallList
#define glCallLists CALL_THE_QGL_VERSION_OF_glCallLists
#define glClear CALL_THE_QGL_VERSION_OF_glClear
#define glClearAccum CALL_THE_QGL_VERSION_OF_glClearAccum
#define glClearColor CALL_THE_QGL_VERSION_OF_glClearColor
#define glClearDepth CALL_THE_QGL_VERSION_OF_glClearDepth
#define glClearIndex CALL_THE_QGL_VERSION_OF_glClearIndex
#define glClearStencil CALL_THE_QGL_VERSION_OF_glClearStencil
#define glClipPlane CALL_THE_QGL_VERSION_OF_glClipPlane
#define glColor3b CALL_THE_QGL_VERSION_OF_glColor3b
#define glColor3bv CALL_THE_QGL_VERSION_OF_glColor3bv
#define glColor3d CALL_THE_QGL_VERSION_OF_glColor3d
#define glColor3dv CALL_THE_QGL_VERSION_OF_glColor3dv
#define glColor3f CALL_THE_QGL_VERSION_OF_glColor3f
#define glColor3fv CALL_THE_QGL_VERSION_OF_glColor3fv
#define glColor3i CALL_THE_QGL_VERSION_OF_glColor3i
#define glColor3iv CALL_THE_QGL_VERSION_OF_glColor3iv
#define glColor3s CALL_THE_QGL_VERSION_OF_glColor3s
#define glColor3sv CALL_THE_QGL_VERSION_OF_glColor3sv
#define glColor3ub CALL_THE_QGL_VERSION_OF_glColor3ub
#define glColor3ubv CALL_THE_QGL_VERSION_OF_glColor3ubv
#define glColor3ui CALL_THE_QGL_VERSION_OF_glColor3ui
#define glColor3uiv CALL_THE_QGL_VERSION_OF_glColor3uiv
#define glColor3us CALL_THE_QGL_VERSION_OF_glColor3us
#define glColor3usv CALL_THE_QGL_VERSION_OF_glColor3usv
#define glColor4b CALL_THE_QGL_VERSION_OF_glColor4b
#define glColor4bv CALL_THE_QGL_VERSION_OF_glColor4bv
#define glColor4d CALL_THE_QGL_VERSION_OF_glColor4d
#define glColor4dv CALL_THE_QGL_VERSION_OF_glColor4dv
#define glColor4f CALL_THE_QGL_VERSION_OF_glColor4f
#define glColor4fv CALL_THE_QGL_VERSION_OF_glColor4fv
#define glColor4i CALL_THE_QGL_VERSION_OF_glColor4i
#define glColor4iv CALL_THE_QGL_VERSION_OF_glColor4iv
#define glColor4s CALL_THE_QGL_VERSION_OF_glColor4s
#define glColor4sv CALL_THE_QGL_VERSION_OF_glColor4sv
#define glColor4ub CALL_THE_QGL_VERSION_OF_glColor4ub
#define glColor4ubv CALL_THE_QGL_VERSION_OF_glColor4ubv
#define glColor4ui CALL_THE_QGL_VERSION_OF_glColor4ui
#define glColor4uiv CALL_THE_QGL_VERSION_OF_glColor4uiv
#define glColor4us CALL_THE_QGL_VERSION_OF_glColor4us
#define glColor4usv CALL_THE_QGL_VERSION_OF_glColor4usv
#define glColorMask CALL_THE_QGL_VERSION_OF_glColorMask
#define glColorMaterial CALL_THE_QGL_VERSION_OF_glColorMaterial
#define glColorPointer CALL_THE_QGL_VERSION_OF_glColorPointer
#define glCopyPixels CALL_THE_QGL_VERSION_OF_glCopyPixels
#define glCopyTexImage1D CALL_THE_QGL_VERSION_OF_glCopyTexImage1D
#define glCopyTexImage2D CALL_THE_QGL_VERSION_OF_glCopyTexImage2D
#define glCopyTexSubImage1D CALL_THE_QGL_VERSION_OF_glCopyTexSubImage1D
#define glCopyTexSubImage2D CALL_THE_QGL_VERSION_OF_glCopyTexSubImage2D
#define glCullFace CALL_THE_QGL_VERSION_OF_glCullFace
#define glDeleteLists CALL_THE_QGL_VERSION_OF_glDeleteLists
#define glDeleteTextures CALL_THE_QGL_VERSION_OF_glDeleteTextures
#define glDepthFunc CALL_THE_QGL_VERSION_OF_glDepthFunc
#define glDepthMask CALL_THE_QGL_VERSION_OF_glDepthMask
#define glDepthRange CALL_THE_QGL_VERSION_OF_glDepthRange
#define glDisable CALL_THE_QGL_VERSION_OF_glDisable
#define glDisableClientState CALL_THE_QGL_VERSION_OF_glDisableClientState
#define glDrawArrays CALL_THE_QGL_VERSION_OF_glDrawArrays
#define glDrawBuffer CALL_THE_QGL_VERSION_OF_glDrawBuffer
#define glDrawElements CALL_THE_QGL_VERSION_OF_glDrawElements
#define glDrawPixels CALL_THE_QGL_VERSION_OF_glDrawPixels
#define glEdgeFlag CALL_THE_QGL_VERSION_OF_glEdgeFlag
#define glEdgeFlagPointer CALL_THE_QGL_VERSION_OF_glEdgeFlagPointer
#define glEdgeFlagv CALL_THE_QGL_VERSION_OF_glEdgeFlagv
#define glEnable CALL_THE_QGL_VERSION_OF_glEnable
#define glEnableClientState CALL_THE_QGL_VERSION_OF_glEnableClientState
#define glEnd CALL_THE_QGL_VERSION_OF_glEnd
#define glEndList CALL_THE_QGL_VERSION_OF_glEndList
#define glEvalCoord1d CALL_THE_QGL_VERSION_OF_glEvalCoord1d
#define glEvalCoord1dv CALL_THE_QGL_VERSION_OF_glEvalCoord1dv
#define glEvalCoord1f CALL_THE_QGL_VERSION_OF_glEvalCoord1f
#define glEvalCoord1fv CALL_THE_QGL_VERSION_OF_glEvalCoord1fv
#define glEvalCoord2d CALL_THE_QGL_VERSION_OF_glEvalCoord2d
#define glEvalCoord2dv CALL_THE_QGL_VERSION_OF_glEvalCoord2dv
#define glEvalCoord2f CALL_THE_QGL_VERSION_OF_glEvalCoord2f
#define glEvalCoord2fv CALL_THE_QGL_VERSION_OF_glEvalCoord2fv
#define glEvalMesh1 CALL_THE_QGL_VERSION_OF_glEvalMesh1
#define glEvalMesh2 CALL_THE_QGL_VERSION_OF_glEvalMesh2
#define glEvalPoint1 CALL_THE_QGL_VERSION_OF_glEvalPoint1
#define glEvalPoint2 CALL_THE_QGL_VERSION_OF_glEvalPoint2
#define glFeedbackBuffer CALL_THE_QGL_VERSION_OF_glFeedbackBuffer
#define glFinish CALL_THE_QGL_VERSION_OF_glFinish
#define glFlush CALL_THE_QGL_VERSION_OF_glFlush
#define glFogf CALL_THE_QGL_VERSION_OF_glFogf
#define glFogfv CALL_THE_QGL_VERSION_OF_glFogfv
#define glFogi CALL_THE_QGL_VERSION_OF_glFogi
#define glFogiv CALL_THE_QGL_VERSION_OF_glFogiv
#define glFrontFace CALL_THE_QGL_VERSION_OF_glFrontFace
#define glFrustum CALL_THE_QGL_VERSION_OF_glFrustum
#define glGenLists CALL_THE_QGL_VERSION_OF_glGenLists
#define glGenTextures CALL_THE_QGL_VERSION_OF_glGenTextures
#define glGetBooleanv CALL_THE_QGL_VERSION_OF_glGetBooleanv
#define glGetClipPlane CALL_THE_QGL_VERSION_OF_glGetClipPlane
#define glGetDoublev CALL_THE_QGL_VERSION_OF_glGetDoublev
#define glGetError CALL_THE_QGL_VERSION_OF_glGetError
#define glGetFloatv CALL_THE_QGL_VERSION_OF_glGetFloatv
#define glGetIntegerv CALL_THE_QGL_VERSION_OF_glGetIntegerv
#define glGetLightfv CALL_THE_QGL_VERSION_OF_glGetLightfv
#define glGetLightiv CALL_THE_QGL_VERSION_OF_glGetLightiv
#define glGetMapdv CALL_THE_QGL_VERSION_OF_glGetMapdv
#define glGetMapfv CALL_THE_QGL_VERSION_OF_glGetMapfv
#define glGetMapiv CALL_THE_QGL_VERSION_OF_glGetMapiv
#define glGetMaterialfv CALL_THE_QGL_VERSION_OF_glGetMaterialfv
#define glGetMaterialiv CALL_THE_QGL_VERSION_OF_glGetMaterialiv
#define glGetPixelMapfv CALL_THE_QGL_VERSION_OF_glGetPixelMapfv
#define glGetPixelMapuiv CALL_THE_QGL_VERSION_OF_glGetPixelMapuiv
#define glGetPixelMapusv CALL_THE_QGL_VERSION_OF_glGetPixelMapusv
#define glGetPointerv CALL_THE_QGL_VERSION_OF_glGetPointerv
#define glGetPolygonStipple CALL_THE_QGL_VERSION_OF_glGetPolygonStipple
#define glGetString CALL_THE_QGL_VERSION_OF_glGetString
#define glGetTexEnvfv CALL_THE_QGL_VERSION_OF_glGetTexEnvfv
#define glGetTexEnviv CALL_THE_QGL_VERSION_OF_glGetTexEnviv
#define glGetTexGendv CALL_THE_QGL_VERSION_OF_glGetTexGendv
#define glGetTexGenfv CALL_THE_QGL_VERSION_OF_glGetTexGenfv
#define glGetTexGeniv CALL_THE_QGL_VERSION_OF_glGetTexGeniv
#define glGetTexImage CALL_THE_QGL_VERSION_OF_glGetTexImage
#define glGetTexLevelParameterfv CALL_THE_QGL_VERSION_OF_glGetTexLevelParameterfv
#define glGetTexLevelParameteriv CALL_THE_QGL_VERSION_OF_glGetTexLevelParameteriv
#define glGetTexParameterfv CALL_THE_QGL_VERSION_OF_glGetTexParameterfv
#define glGetTexParameteriv CALL_THE_QGL_VERSION_OF_glGetTexParameteriv
#define glHint CALL_THE_QGL_VERSION_OF_glHint
#define glIndexMask CALL_THE_QGL_VERSION_OF_glIndexMask
#define glIndexPointer CALL_THE_QGL_VERSION_OF_glIndexPointer
#define glIndexd CALL_THE_QGL_VERSION_OF_glIndexd
#define glIndexdv CALL_THE_QGL_VERSION_OF_glIndexdv
#define glIndexf CALL_THE_QGL_VERSION_OF_glIndexf
#define glIndexfv CALL_THE_QGL_VERSION_OF_glIndexfv
#define glIndexi CALL_THE_QGL_VERSION_OF_glIndexi
#define glIndexiv CALL_THE_QGL_VERSION_OF_glIndexiv
#define glIndexs CALL_THE_QGL_VERSION_OF_glIndexs
#define glIndexsv CALL_THE_QGL_VERSION_OF_glIndexsv
#define glIndexub CALL_THE_QGL_VERSION_OF_glIndexub
#define glIndexubv CALL_THE_QGL_VERSION_OF_glIndexubv
#define glInitNames CALL_THE_QGL_VERSION_OF_glInitNames
#define glInterleavedArrays CALL_THE_QGL_VERSION_OF_glInterleavedArrays
#define glIsEnabled CALL_THE_QGL_VERSION_OF_glIsEnabled
#define glIsList CALL_THE_QGL_VERSION_OF_glIsList
#define glIsTexture CALL_THE_QGL_VERSION_OF_glIsTexture
#define glLightModelf CALL_THE_QGL_VERSION_OF_glLightModelf
#define glLightModelfv CALL_THE_QGL_VERSION_OF_glLightModelfv
#define glLightModeli CALL_THE_QGL_VERSION_OF_glLightModeli
#define glLightModeliv CALL_THE_QGL_VERSION_OF_glLightModeliv
#define glLightf CALL_THE_QGL_VERSION_OF_glLightf
#define glLightfv CALL_THE_QGL_VERSION_OF_glLightfv
#define glLighti CALL_THE_QGL_VERSION_OF_glLighti
#define glLightiv CALL_THE_QGL_VERSION_OF_glLightiv
#define glLineStipple CALL_THE_QGL_VERSION_OF_glLineStipple
#define glLineWidth CALL_THE_QGL_VERSION_OF_glLineWidth
#define glListBase CALL_THE_QGL_VERSION_OF_glListBase
#define glLoadIdentity CALL_THE_QGL_VERSION_OF_glLoadIdentity
#define glLoadMatrixd CALL_THE_QGL_VERSION_OF_glLoadMatrixd
#define glLoadMatrixf CALL_THE_QGL_VERSION_OF_glLoadMatrixf
#define glLoadName CALL_THE_QGL_VERSION_OF_glLoadName
#define glLogicOp CALL_THE_QGL_VERSION_OF_glLogicOp
#define glMap1d CALL_THE_QGL_VERSION_OF_glMap1d
#define glMap1f CALL_THE_QGL_VERSION_OF_glMap1f
#define glMap2d CALL_THE_QGL_VERSION_OF_glMap2d
#define glMap2f CALL_THE_QGL_VERSION_OF_glMap2f
#define glMapGrid1d CALL_THE_QGL_VERSION_OF_glMapGrid1d
#define glMapGrid1f CALL_THE_QGL_VERSION_OF_glMapGrid1f
#define glMapGrid2d CALL_THE_QGL_VERSION_OF_glMapGrid2d
#define glMapGrid2f CALL_THE_QGL_VERSION_OF_glMapGrid2f
#define glMaterialf CALL_THE_QGL_VERSION_OF_glMaterialf
#define glMaterialfv CALL_THE_QGL_VERSION_OF_glMaterialfv
#define glMateriali CALL_THE_QGL_VERSION_OF_glMateriali
#define glMaterialiv CALL_THE_QGL_VERSION_OF_glMaterialiv
#define glMatrixMode CALL_THE_QGL_VERSION_OF_glMatrixMode
#define glMultMatrixd CALL_THE_QGL_VERSION_OF_glMultMatrixd
#define glMultMatrixf CALL_THE_QGL_VERSION_OF_glMultMatrixf
#define glNewList CALL_THE_QGL_VERSION_OF_glNewList
#define glNormal3b CALL_THE_QGL_VERSION_OF_glNormal3b
#define glNormal3bv CALL_THE_QGL_VERSION_OF_glNormal3bv
#define glNormal3d CALL_THE_QGL_VERSION_OF_glNormal3d
#define glNormal3dv CALL_THE_QGL_VERSION_OF_glNormal3dv
#define glNormal3f CALL_THE_QGL_VERSION_OF_glNormal3f
#define glNormal3fv CALL_THE_QGL_VERSION_OF_glNormal3fv
#define glNormal3i CALL_THE_QGL_VERSION_OF_glNormal3i
#define glNormal3iv CALL_THE_QGL_VERSION_OF_glNormal3iv
#define glNormal3s CALL_THE_QGL_VERSION_OF_glNormal3s
#define glNormal3sv CALL_THE_QGL_VERSION_OF_glNormal3sv
#define glNormalPointer CALL_THE_QGL_VERSION_OF_glNormalPointer
#define glOrtho CALL_THE_QGL_VERSION_OF_glOrtho
#define glPassThrough CALL_THE_QGL_VERSION_OF_glPassThrough
#define glPixelMapfv CALL_THE_QGL_VERSION_OF_glPixelMapfv
#define glPixelMapuiv CALL_THE_QGL_VERSION_OF_glPixelMapuiv
#define glPixelMapusv CALL_THE_QGL_VERSION_OF_glPixelMapusv
#define glPixelStoref CALL_THE_QGL_VERSION_OF_glPixelStoref
#define glPixelStorei CALL_THE_QGL_VERSION_OF_glPixelStorei
#define glPixelTransferf CALL_THE_QGL_VERSION_OF_glPixelTransferf
#define glPixelTransferi CALL_THE_QGL_VERSION_OF_glPixelTransferi
#define glPixelZoom CALL_THE_QGL_VERSION_OF_glPixelZoom
#define glPointSize CALL_THE_QGL_VERSION_OF_glPointSize
#define glPolygonMode CALL_THE_QGL_VERSION_OF_glPolygonMode
#define glPolygonOffset CALL_THE_QGL_VERSION_OF_glPolygonOffset
#define glPolygonStipple CALL_THE_QGL_VERSION_OF_glPolygonStipple
#define glPopAttrib CALL_THE_QGL_VERSION_OF_glPopAttrib
#define glPopClientAttrib CALL_THE_QGL_VERSION_OF_glPopClientAttrib
#define glPopMatrix CALL_THE_QGL_VERSION_OF_glPopMatrix
#define glPopName CALL_THE_QGL_VERSION_OF_glPopName
#define glPrioritizeTextures CALL_THE_QGL_VERSION_OF_glPrioritizeTextures
#define glPushAttrib CALL_THE_QGL_VERSION_OF_glPushAttrib
#define glPushClientAttrib CALL_THE_QGL_VERSION_OF_glPushClientAttrib
#define glPushMatrix CALL_THE_QGL_VERSION_OF_glPushMatrix
#define glPushName CALL_THE_QGL_VERSION_OF_glPushName
#define glRasterPos2d CALL_THE_QGL_VERSION_OF_glRasterPos2d
#define glRasterPos2dv CALL_THE_QGL_VERSION_OF_glRasterPos2dv
#define glRasterPos2f CALL_THE_QGL_VERSION_OF_glRasterPos2f
#define glRasterPos2fv CALL_THE_QGL_VERSION_OF_glRasterPos2fv
#define glRasterPos2i CALL_THE_QGL_VERSION_OF_glRasterPos2i
#define glRasterPos2iv CALL_THE_QGL_VERSION_OF_glRasterPos2iv
#define glRasterPos2s CALL_THE_QGL_VERSION_OF_glRasterPos2s
#define glRasterPos2sv CALL_THE_QGL_VERSION_OF_glRasterPos2sv
#define glRasterPos3d CALL_THE_QGL_VERSION_OF_glRasterPos3d
#define glRasterPos3dv CALL_THE_QGL_VERSION_OF_glRasterPos3dv
#define glRasterPos3f CALL_THE_QGL_VERSION_OF_glRasterPos3f
#define glRasterPos3fv CALL_THE_QGL_VERSION_OF_glRasterPos3fv
#define glRasterPos3i CALL_THE_QGL_VERSION_OF_glRasterPos3i
#define glRasterPos3iv CALL_THE_QGL_VERSION_OF_glRasterPos3iv
#define glRasterPos3s CALL_THE_QGL_VERSION_OF_glRasterPos3s
#define glRasterPos3sv CALL_THE_QGL_VERSION_OF_glRasterPos3sv
#define glRasterPos4d CALL_THE_QGL_VERSION_OF_glRasterPos4d
#define glRasterPos4dv CALL_THE_QGL_VERSION_OF_glRasterPos4dv
#define glRasterPos4f CALL_THE_QGL_VERSION_OF_glRasterPos4f
#define glRasterPos4fv CALL_THE_QGL_VERSION_OF_glRasterPos4fv
#define glRasterPos4i CALL_THE_QGL_VERSION_OF_glRasterPos4i
#define glRasterPos4iv CALL_THE_QGL_VERSION_OF_glRasterPos4iv
#define glRasterPos4s CALL_THE_QGL_VERSION_OF_glRasterPos4s
#define glRasterPos4sv CALL_THE_QGL_VERSION_OF_glRasterPos4sv
#define glReadBuffer CALL_THE_QGL_VERSION_OF_glReadBuffer
#define glReadPixels CALL_THE_QGL_VERSION_OF_glReadPixels
#define glRectd CALL_THE_QGL_VERSION_OF_glRectd
#define glRectdv CALL_THE_QGL_VERSION_OF_glRectdv
#define glRectf CALL_THE_QGL_VERSION_OF_glRectf
#define glRectfv CALL_THE_QGL_VERSION_OF_glRectfv
#define glRecti CALL_THE_QGL_VERSION_OF_glRecti
#define glRectiv CALL_THE_QGL_VERSION_OF_glRectiv
#define glRects CALL_THE_QGL_VERSION_OF_glRects
#define glRectsv CALL_THE_QGL_VERSION_OF_glRectsv
#define glRenderMode CALL_THE_QGL_VERSION_OF_glRenderMode
#define glRotated CALL_THE_QGL_VERSION_OF_glRotated
#define glRotatef CALL_THE_QGL_VERSION_OF_glRotatef
#define glScaled CALL_THE_QGL_VERSION_OF_glScaled
#define glScalef CALL_THE_QGL_VERSION_OF_glScalef
#define glScissor CALL_THE_QGL_VERSION_OF_glScissor
#define glSelectBuffer CALL_THE_QGL_VERSION_OF_glSelectBuffer
#define glShadeModel CALL_THE_QGL_VERSION_OF_glShadeModel
#define glStencilFunc CALL_THE_QGL_VERSION_OF_glStencilFunc
#define glStencilMask CALL_THE_QGL_VERSION_OF_glStencilMask
#define glStencilOp CALL_THE_QGL_VERSION_OF_glStencilOp
#define glTexCoord1d CALL_THE_QGL_VERSION_OF_glTexCoord1d
#define glTexCoord1dv CALL_THE_QGL_VERSION_OF_glTexCoord1dv
#define glTexCoord1f CALL_THE_QGL_VERSION_OF_glTexCoord1f
#define glTexCoord1fv CALL_THE_QGL_VERSION_OF_glTexCoord1fv
#define glTexCoord1i CALL_THE_QGL_VERSION_OF_glTexCoord1i
#define glTexCoord1iv CALL_THE_QGL_VERSION_OF_glTexCoord1iv
#define glTexCoord1s CALL_THE_QGL_VERSION_OF_glTexCoord1s
#define glTexCoord1sv CALL_THE_QGL_VERSION_OF_glTexCoord1sv
#define glTexCoord2d CALL_THE_QGL_VERSION_OF_glTexCoord2d
#define glTexCoord2dv CALL_THE_QGL_VERSION_OF_glTexCoord2dv
#define glTexCoord2f CALL_THE_QGL_VERSION_OF_glTexCoord2f
#define glTexCoord2fv CALL_THE_QGL_VERSION_OF_glTexCoord2fv
#define glTexCoord2i CALL_THE_QGL_VERSION_OF_glTexCoord2i
#define glTexCoord2iv CALL_THE_QGL_VERSION_OF_glTexCoord2iv
#define glTexCoord2s CALL_THE_QGL_VERSION_OF_glTexCoord2s
#define glTexCoord2sv CALL_THE_QGL_VERSION_OF_glTexCoord2sv
#define glTexCoord3d CALL_THE_QGL_VERSION_OF_glTexCoord3d
#define glTexCoord3dv CALL_THE_QGL_VERSION_OF_glTexCoord3dv
#define glTexCoord3f CALL_THE_QGL_VERSION_OF_glTexCoord3f
#define glTexCoord3fv CALL_THE_QGL_VERSION_OF_glTexCoord3fv
#define glTexCoord3i CALL_THE_QGL_VERSION_OF_glTexCoord3i
#define glTexCoord3iv CALL_THE_QGL_VERSION_OF_glTexCoord3iv
#define glTexCoord3s CALL_THE_QGL_VERSION_OF_glTexCoord3s
#define glTexCoord3sv CALL_THE_QGL_VERSION_OF_glTexCoord3sv
#define glTexCoord4d CALL_THE_QGL_VERSION_OF_glTexCoord4d
#define glTexCoord4dv CALL_THE_QGL_VERSION_OF_glTexCoord4dv
#define glTexCoord4f CALL_THE_QGL_VERSION_OF_glTexCoord4f
#define glTexCoord4fv CALL_THE_QGL_VERSION_OF_glTexCoord4fv
#define glTexCoord4i CALL_THE_QGL_VERSION_OF_glTexCoord4i
#define glTexCoord4iv CALL_THE_QGL_VERSION_OF_glTexCoord4iv
#define glTexCoord4s CALL_THE_QGL_VERSION_OF_glTexCoord4s
#define glTexCoord4sv CALL_THE_QGL_VERSION_OF_glTexCoord4sv
#define glTexCoordPointer CALL_THE_QGL_VERSION_OF_glTexCoordPointer
#define glTexEnvf CALL_THE_QGL_VERSION_OF_glTexEnvf
#define glTexEnvfv CALL_THE_QGL_VERSION_OF_glTexEnvfv
#define glTexEnvi CALL_THE_QGL_VERSION_OF_glTexEnvi
#define glTexEnviv CALL_THE_QGL_VERSION_OF_glTexEnviv
#define glTexGend CALL_THE_QGL_VERSION_OF_glTexGend
#define glTexGendv CALL_THE_QGL_VERSION_OF_glTexGendv
#define glTexGenf CALL_THE_QGL_VERSION_OF_glTexGenf
#define glTexGenfv CALL_THE_QGL_VERSION_OF_glTexGenfv
#define glTexGeni CALL_THE_QGL_VERSION_OF_glTexGeni
#define glTexGeniv CALL_THE_QGL_VERSION_OF_glTexGeniv
#define glTexImage1D CALL_THE_QGL_VERSION_OF_glTexImage1D
#define glTexImage2D CALL_THE_QGL_VERSION_OF_glTexImage2D
#define glTexParameterf CALL_THE_QGL_VERSION_OF_glTexParameterf
#define glTexParameterfv CALL_THE_QGL_VERSION_OF_glTexParameterfv
#define glTexParameteri CALL_THE_QGL_VERSION_OF_glTexParameteri
#define glTexParameteriv CALL_THE_QGL_VERSION_OF_glTexParameteriv
#define glTexSubImage1D CALL_THE_QGL_VERSION_OF_glTexSubImage1D
#define glTexSubImage2D CALL_THE_QGL_VERSION_OF_glTexSubImage2D
#define glTranslated CALL_THE_QGL_VERSION_OF_glTranslated
#define glTranslatef CALL_THE_QGL_VERSION_OF_glTranslatef
#define glVertex2d CALL_THE_QGL_VERSION_OF_glVertex2d
#define glVertex2dv CALL_THE_QGL_VERSION_OF_glVertex2dv
#define glVertex2f CALL_THE_QGL_VERSION_OF_glVertex2f
#define glVertex2fv CALL_THE_QGL_VERSION_OF_glVertex2fv
#define glVertex2i CALL_THE_QGL_VERSION_OF_glVertex2i
#define glVertex2iv CALL_THE_QGL_VERSION_OF_glVertex2iv
#define glVertex2s CALL_THE_QGL_VERSION_OF_glVertex2s
#define glVertex2sv CALL_THE_QGL_VERSION_OF_glVertex2sv
#define glVertex3d CALL_THE_QGL_VERSION_OF_glVertex3d
#define glVertex3dv CALL_THE_QGL_VERSION_OF_glVertex3dv
#define glVertex3f CALL_THE_QGL_VERSION_OF_glVertex3f
#define glVertex3fv CALL_THE_QGL_VERSION_OF_glVertex3fv
#define glVertex3i CALL_THE_QGL_VERSION_OF_glVertex3i
#define glVertex3iv CALL_THE_QGL_VERSION_OF_glVertex3iv
#define glVertex3s CALL_THE_QGL_VERSION_OF_glVertex3s
#define glVertex3sv CALL_THE_QGL_VERSION_OF_glVertex3sv
#define glVertex4d CALL_THE_QGL_VERSION_OF_glVertex4d
#define glVertex4dv CALL_THE_QGL_VERSION_OF_glVertex4dv
#define glVertex4f CALL_THE_QGL_VERSION_OF_glVertex4f
#define glVertex4fv CALL_THE_QGL_VERSION_OF_glVertex4fv
#define glVertex4i CALL_THE_QGL_VERSION_OF_glVertex4i
#define glVertex4iv CALL_THE_QGL_VERSION_OF_glVertex4iv
#define glVertex4s CALL_THE_QGL_VERSION_OF_glVertex4s
#define glVertex4sv CALL_THE_QGL_VERSION_OF_glVertex4sv
#define glVertexPointer CALL_THE_QGL_VERSION_OF_glVertexPointer
#define glViewport CALL_THE_QGL_VERSION_OF_glViewport
